var TRACEID_GPU_TIMINGS = 'GpuTimings';

var version = '2.6.2';
var revision = '2cc67f6';
function extend(target, ex) {
		for(var prop in ex){
				var copy = ex[prop];
				if (Array.isArray(copy)) {
						target[prop] = extend([], copy);
				} else if (copy && typeof copy === 'object') {
						target[prop] = extend({}, copy);
				} else {
						target[prop] = copy;
				}
		}
		return target;
}

var guid = {
		create () {
				return 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, (c)=>{
						var r = Math.random() * 16 | 0;
						var v = c === 'x' ? r : r & 0x3 | 0x8;
						return v.toString(16);
				});
		}
};

var path = {
		delimiter: '/',
		join () {
				for(var _len = arguments.length, sections = new Array(_len), _key = 0; _key < _len; _key++){
						sections[_key] = arguments[_key];
				}
				var result = sections[0];
				for(var i = 0; i < sections.length - 1; i++){
						var one = sections[i];
						var two = sections[i + 1];
						if (two[0] === path.delimiter) {
								result = two;
								continue;
						}
						if (one && two && one[one.length - 1] !== path.delimiter && two[0] !== path.delimiter) {
								result += path.delimiter + two;
						} else {
								result += two;
						}
				}
				return result;
		},
		normalize (pathname) {
				var lead = pathname.startsWith(path.delimiter);
				var trail = pathname.endsWith(path.delimiter);
				var parts = pathname.split('/');
				var result = '';
				var cleaned = [];
				for(var i = 0; i < parts.length; i++){
						if (parts[i] === '') continue;
						if (parts[i] === '.') continue;
						if (parts[i] === '..' && cleaned.length > 0) {
								cleaned = cleaned.slice(0, cleaned.length - 2);
								continue;
						}
						if (i > 0) cleaned.push(path.delimiter);
						cleaned.push(parts[i]);
				}
				result = cleaned.join('');
				if (!lead && result[0] === path.delimiter) {
						result = result.slice(1);
				}
				if (trail && result[result.length - 1] !== path.delimiter) {
						result += path.delimiter;
				}
				return result;
		},
		split (pathname) {
				var lastDelimiterIndex = pathname.lastIndexOf(path.delimiter);
				if (lastDelimiterIndex !== -1) {
						return [
								pathname.substring(0, lastDelimiterIndex),
								pathname.substring(lastDelimiterIndex + 1)
						];
				}
				return [
						'',
						pathname
				];
		},
		getBasename (pathname) {
				return path.split(pathname)[1];
		},
		getDirectory (pathname) {
				return path.split(pathname)[0];
		},
		getExtension (pathname) {
				var ext = pathname.split('?')[0].split('.').pop();
				if (ext !== pathname) {
						return "." + ext;
				}
				return '';
		},
		isRelativePath (pathname) {
				return pathname.charAt(0) !== '/' && pathname.match(/:\/\//) === null;
		},
		extractPath (pathname) {
				var result = '';
				var parts = pathname.split('/');
				var i = 0;
				if (parts.length > 1) {
						if (path.isRelativePath(pathname)) {
								if (parts[0] === '.') {
										for(i = 0; i < parts.length - 1; ++i){
												result += i === 0 ? parts[i] : "/" + parts[i];
										}
								} else if (parts[0] === '..') {
										for(i = 0; i < parts.length - 1; ++i){
												result += i === 0 ? parts[i] : "/" + parts[i];
										}
								} else {
										result = '.';
										for(i = 0; i < parts.length - 1; ++i){
												result += "/" + parts[i];
										}
								}
						} else {
								for(i = 0; i < parts.length - 1; ++i){
										result += i === 0 ? parts[i] : "/" + parts[i];
								}
						}
				}
				return result;
		}
};

var detectPassiveEvents = ()=>{
		var result = false;
		try {
				var opts = Object.defineProperty({}, 'passive', {
						get: function get() {
								result = true;
								return false;
						}
				});
				window.addEventListener('testpassive', null, opts);
				window.removeEventListener('testpassive', null, opts);
		} catch (e) {}
		return result;
};
var ua = typeof navigator !== 'undefined' ? navigator.userAgent : '';
var environment = typeof window !== 'undefined' ? 'browser' : typeof global !== 'undefined' ? 'node' : 'worker';
var platformName = /android/i.test(ua) ? 'android' : /ip(?:[ao]d|hone)/i.test(ua) ? 'ios' : /windows/i.test(ua) ? 'windows' : /mac os/i.test(ua) ? 'osx' : /linux/i.test(ua) ? 'linux' : /cros/i.test(ua) ? 'cros' : null;
var browserName = environment !== 'browser' ? null : /Chrome\/|Chromium\/|Edg.*\//.test(ua) ? 'chrome' : /Safari\//.test(ua) ? 'safari' : /Firefox\//.test(ua) ? 'firefox' : 'other';
var touch = environment === 'browser' && ('ontouchstart' in window || 'maxTouchPoints' in navigator && navigator.maxTouchPoints > 0);
var passiveEvents = detectPassiveEvents();
var platform = {
		name: platformName,
		browser: environment === 'browser',
		worker: environment === 'worker',
		android: platformName === 'android',
		touch: touch,
		passiveEvents: passiveEvents,
		browserName: browserName
};

var ASCII_LOWERCASE = 'abcdefghijklmnopqrstuvwxyz';
var ASCII_UPPERCASE = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
var ASCII_LETTERS = ASCII_LOWERCASE + ASCII_UPPERCASE;
var HIGH_SURROGATE_BEGIN = 0xD800;
var HIGH_SURROGATE_END = 0xDBFF;
var LOW_SURROGATE_BEGIN = 0xDC00;
var LOW_SURROGATE_END = 0xDFFF;
var ZERO_WIDTH_JOINER = 0x200D;
var REGIONAL_INDICATOR_BEGIN = 0x1F1E6;
var REGIONAL_INDICATOR_END = 0x1F1FF;
var FITZPATRICK_MODIFIER_BEGIN = 0x1F3FB;
var FITZPATRICK_MODIFIER_END = 0x1F3FF;
var DIACRITICAL_MARKS_BEGIN = 0x20D0;
var DIACRITICAL_MARKS_END = 0x20FF;
var VARIATION_MODIFIER_BEGIN = 0xFE00;
var VARIATION_MODIFIER_END = 0xFE0F;
function getCodePointData(string, i) {
		if (i === void 0) i = 0;
		var size = string.length;
		if (i < 0 || i >= size) {
				return null;
		}
		var first = string.charCodeAt(i);
		if (size > 1 && first >= HIGH_SURROGATE_BEGIN && first <= HIGH_SURROGATE_END) {
				var second = string.charCodeAt(i + 1);
				if (second >= LOW_SURROGATE_BEGIN && second <= LOW_SURROGATE_END) {
						return {
								code: (first - HIGH_SURROGATE_BEGIN) * 0x400 + second - LOW_SURROGATE_BEGIN + 0x10000,
								long: true
						};
				}
		}
		return {
				code: first,
				long: false
		};
}
function isCodeBetween(string, begin, end) {
		if (!string) {
				return false;
		}
		var codeData = getCodePointData(string);
		if (codeData) {
				var code = codeData.code;
				return code >= begin && code <= end;
		}
		return false;
}
function numCharsToTakeForNextSymbol(string, index) {
		if (index === string.length - 1) {
				return 1;
		}
		if (isCodeBetween(string[index], HIGH_SURROGATE_BEGIN, HIGH_SURROGATE_END)) {
				var first = string.substring(index, index + 2);
				var second = string.substring(index + 2, index + 4);
				if (isCodeBetween(second, FITZPATRICK_MODIFIER_BEGIN, FITZPATRICK_MODIFIER_END) || isCodeBetween(first, REGIONAL_INDICATOR_BEGIN, REGIONAL_INDICATOR_END) && isCodeBetween(second, REGIONAL_INDICATOR_BEGIN, REGIONAL_INDICATOR_END)) {
						return 4;
				}
				if (isCodeBetween(second, VARIATION_MODIFIER_BEGIN, VARIATION_MODIFIER_END)) {
						return 3;
				}
				return 2;
		}
		if (isCodeBetween(string[index + 1], VARIATION_MODIFIER_BEGIN, VARIATION_MODIFIER_END)) {
				return 2;
		}
		return 1;
}
var string = {
		ASCII_LOWERCASE: ASCII_LOWERCASE,
		ASCII_UPPERCASE: ASCII_UPPERCASE,
		ASCII_LETTERS: ASCII_LETTERS,
		format (s) {
				for(var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++){
						args[_key - 1] = arguments[_key];
				}
				for(var i = 0; i < args.length; i++){
						s = s.replace("{" + i + "}", args[i]);
				}
				return s;
		},
		getCodePoint (string, i) {
				var codePointData = getCodePointData(string, i);
				return codePointData && codePointData.code;
		},
		getCodePoints (string) {
				if (typeof string !== 'string') {
						throw new TypeError('Not a string');
				}
				var i = 0;
				var arr = [];
				var codePoint;
				while(!!(codePoint = getCodePointData(string, i))){
						arr.push(codePoint.code);
						i += codePoint.long ? 2 : 1;
				}
				return arr;
		},
		getSymbols (string) {
				if (typeof string !== 'string') {
						throw new TypeError('Not a string');
				}
				var index = 0;
				var length = string.length;
				var output = [];
				var take = 0;
				var ch;
				while(index < length){
						take += numCharsToTakeForNextSymbol(string, index + take);
						ch = string[index + take];
						if (isCodeBetween(ch, DIACRITICAL_MARKS_BEGIN, DIACRITICAL_MARKS_END)) {
								ch = string[index + take++];
						}
						if (isCodeBetween(ch, VARIATION_MODIFIER_BEGIN, VARIATION_MODIFIER_END)) {
								ch = string[index + take++];
						}
						if (ch && ch.charCodeAt(0) === ZERO_WIDTH_JOINER) {
								ch = string[index + take++];
								continue;
						}
						var char = string.substring(index, index + take);
						output.push(char);
						index += take;
						take = 0;
				}
				return output;
		},
		fromCodePoint () {
				var chars = [];
				var current;
				var codePoint;
				var units;
				for(var i = 0; i < arguments.length; ++i){
						current = Number(arguments[i]);
						codePoint = current - 0x10000;
						units = current > 0xFFFF ? [
								(codePoint >> 10) + 0xD800,
								codePoint % 0x400 + 0xDC00
						] : [
								current
						];
						chars.push(String.fromCharCode.apply(null, units));
				}
				return chars.join('');
		}
};

class EventHandle {
		off() {
				if (this._removed) return;
				this.handler.offByHandle(this);
		}
		on(name, callback, scope) {
				if (scope === void 0) scope = this;
				return this.handler._addCallback(name, callback, scope, false);
		}
		once(name, callback, scope) {
				if (scope === void 0) scope = this;
				return this.handler._addCallback(name, callback, scope, true);
		}
		set removed(value) {
				if (!value) return;
				this._removed = true;
		}
		get removed() {
				return this._removed;
		}
		constructor(handler, name, callback, scope, once = false){
				this._removed = false;
				this.handler = handler;
				this.name = name;
				this.callback = callback;
				this.scope = scope;
				this._once = once;
		}
}

class EventHandler {
		initEventHandler() {
				this._callbacks = new Map();
				this._callbackActive = new Map();
		}
		_addCallback(name, callback, scope, once) {
				if (!this._callbacks.has(name)) {
						this._callbacks.set(name, []);
				}
				if (this._callbackActive.has(name)) {
						var callbackActive = this._callbackActive.get(name);
						if (callbackActive && callbackActive === this._callbacks.get(name)) {
								this._callbackActive.set(name, callbackActive.slice());
						}
				}
				var evt = new EventHandle(this, name, callback, scope, once);
				this._callbacks.get(name).push(evt);
				return evt;
		}
		on(name, callback, scope) {
				if (scope === void 0) scope = this;
				return this._addCallback(name, callback, scope, false);
		}
		once(name, callback, scope) {
				if (scope === void 0) scope = this;
				return this._addCallback(name, callback, scope, true);
		}
		off(name, callback, scope) {
				if (name) {
						if (this._callbackActive.has(name) && this._callbackActive.get(name) === this._callbacks.get(name)) {
								this._callbackActive.set(name, this._callbackActive.get(name).slice());
						}
				} else {
						for (var [key, callbacks] of this._callbackActive){
								if (!this._callbacks.has(key)) {
										continue;
								}
								if (this._callbacks.get(key) !== callbacks) {
										continue;
								}
								this._callbackActive.set(key, callbacks.slice());
						}
				}
				if (!name) {
						for (var callbacks1 of this._callbacks.values()){
								for(var i = 0; i < callbacks1.length; i++){
										callbacks1[i].removed = true;
								}
						}
						this._callbacks.clear();
				} else if (!callback) {
						var callbacks2 = this._callbacks.get(name);
						if (callbacks2) {
								for(var i1 = 0; i1 < callbacks2.length; i1++){
										callbacks2[i1].removed = true;
								}
								this._callbacks.delete(name);
						}
				} else {
						var callbacks3 = this._callbacks.get(name);
						if (!callbacks3) {
								return this;
						}
						for(var i2 = 0; i2 < callbacks3.length; i2++){
								if (callbacks3[i2].callback !== callback) {
										continue;
								}
								if (scope && callbacks3[i2].scope !== scope) {
										continue;
								}
								callbacks3[i2].removed = true;
								callbacks3.splice(i2, 1);
								i2--;
						}
						if (callbacks3.length === 0) {
								this._callbacks.delete(name);
						}
				}
				return this;
		}
		offByHandle(handle) {
				var name = handle.name;
				handle.removed = true;
				if (this._callbackActive.has(name) && this._callbackActive.get(name) === this._callbacks.get(name)) {
						this._callbackActive.set(name, this._callbackActive.get(name).slice());
				}
				var callbacks = this._callbacks.get(name);
				if (!callbacks) {
						return this;
				}
				var ind = callbacks.indexOf(handle);
				if (ind !== -1) {
						callbacks.splice(ind, 1);
						if (callbacks.length === 0) {
								this._callbacks.delete(name);
						}
				}
				return this;
		}
		fire(name, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8) {
				if (!name) {
						return this;
				}
				var callbacksInitial = this._callbacks.get(name);
				if (!callbacksInitial) {
						return this;
				}
				var callbacks;
				if (!this._callbackActive.has(name)) {
						this._callbackActive.set(name, callbacksInitial);
				} else if (this._callbackActive.get(name) !== callbacksInitial) {
						callbacks = callbacksInitial.slice();
				}
				for(var i = 0; (callbacks || this._callbackActive.get(name)) && i < (callbacks || this._callbackActive.get(name)).length; i++){
						var evt = (callbacks || this._callbackActive.get(name))[i];
						if (!evt.callback) continue;
						evt.callback.call(evt.scope, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
						if (evt._once) {
								var existingCallback = this._callbacks.get(name);
								var ind = existingCallback ? existingCallback.indexOf(evt) : -1;
								if (ind !== -1) {
										if (this._callbackActive.get(name) === existingCallback) {
												this._callbackActive.set(name, this._callbackActive.get(name).slice());
										}
										var callbacks1 = this._callbacks.get(name);
										if (!callbacks1) continue;
										callbacks1[ind].removed = true;
										callbacks1.splice(ind, 1);
										if (callbacks1.length === 0) {
												this._callbacks.delete(name);
										}
								}
						}
				}
				if (!callbacks) {
						this._callbackActive.delete(name);
				}
				return this;
		}
		hasEvent(name) {
				var _this__callbacks_get;
				return !!((_this__callbacks_get = this._callbacks.get(name)) == null ? void 0 : _this__callbacks_get.length);
		}
		constructor(){
				this._callbacks = new Map();
				this._callbackActive = new Map();
		}
}

class IndexedList {
		push(key, item) {
				if (this._index[key]) {
						throw Error("Key already in index " + key);
				}
				var location = this._list.push(item) - 1;
				this._index[key] = location;
		}
		has(key) {
				return this._index[key] !== undefined;
		}
		get(key) {
				var location = this._index[key];
				if (location !== undefined) {
						return this._list[location];
				}
				return null;
		}
		remove(key) {
				var location = this._index[key];
				if (location !== undefined) {
						this._list.splice(location, 1);
						delete this._index[key];
						for(key in this._index){
								var idx = this._index[key];
								if (idx > location) {
										this._index[key] = idx - 1;
								}
						}
						return true;
				}
				return false;
		}
		list() {
				return this._list;
		}
		clear() {
				this._list.length = 0;
				for(var prop in this._index){
						delete this._index[prop];
				}
		}
		constructor(){
				this._list = [];
				this._index = {};
		}
}

var cachedResult = (func)=>{
		var uninitToken = {};
		var result = uninitToken;
		return ()=>{
				if (result === uninitToken) {
						result = func();
				}
				return result;
		};
};
class Impl {
		static loadScript(url, callback) {
				var s = document.createElement("script");
				s.setAttribute('src', url);
				s.onload = ()=>{
						callback(null);
				};
				s.onerror = ()=>{
						callback("Failed to load script='" + url + "'");
				};
				document.body.appendChild(s);
		}
		static loadWasm(moduleName, config, callback) {
				var loadUrl = Impl.wasmSupported() && config.glueUrl && config.wasmUrl ? config.glueUrl : config.fallbackUrl;
				if (loadUrl) {
						Impl.loadScript(loadUrl, (err)=>{
								if (err) {
										callback(err, null);
								} else {
										var module = window[moduleName];
										window[moduleName] = undefined;
										module({
												locateFile: ()=>config.wasmUrl,
												onAbort: ()=>{
														callback('wasm module aborted.');
												}
										}).then((instance)=>{
												callback(null, instance);
										});
								}
						});
				} else {
						callback('No supported wasm modules found.', null);
				}
		}
		static getModule(name) {
				if (!Impl.modules.hasOwnProperty(name)) {
						Impl.modules[name] = {
								config: null,
								initializing: false,
								instance: null,
								callbacks: []
						};
				}
				return Impl.modules[name];
		}
		static initialize(moduleName, module) {
				if (module.initializing) {
						return;
				}
				var config = module.config;
				if (config.glueUrl || config.wasmUrl || config.fallbackUrl) {
						module.initializing = true;
						Impl.loadWasm(moduleName, config, (err, instance)=>{
								if (err) {
										if (config.errorHandler) {
												config.errorHandler(err);
										} else {
												console.error("failed to initialize module=" + moduleName + " error=" + err);
										}
								} else {
										module.instance = instance;
										module.callbacks.forEach((callback)=>{
												callback(instance);
										});
								}
						});
				}
		}
}
Impl.modules = {};
Impl.wasmSupported = cachedResult(()=>{
		try {
				if (typeof WebAssembly === 'object' && typeof WebAssembly.instantiate === 'function') {
						var module = new WebAssembly.Module(Uint8Array.of(0x0, 0x61, 0x73, 0x6d, 0x01, 0x00, 0x00, 0x00));
						if (module instanceof WebAssembly.Module) {
								return new WebAssembly.Instance(module) instanceof WebAssembly.Instance;
						}
				}
		} catch (e) {}
		return false;
});
class WasmModule {
		static setConfig(moduleName, config) {
				var module = Impl.getModule(moduleName);
				module.config = config;
				if (module.callbacks.length > 0) {
						Impl.initialize(moduleName, module);
				}
		}
		static getConfig(moduleName) {
				var _Impl_modules_moduleName, _Impl_modules;
				return (_Impl_modules = Impl.modules) == null ? void 0 : (_Impl_modules_moduleName = _Impl_modules[moduleName]) == null ? void 0 : _Impl_modules_moduleName.config;
		}
		static getInstance(moduleName, callback) {
				var module = Impl.getModule(moduleName);
				if (module.instance) {
						callback(module.instance);
				} else {
						module.callbacks.push(callback);
						if (module.config) {
								Impl.initialize(moduleName, module);
						}
				}
		}
}

class ReadStream {
		get remainingBytes() {
				return this.dataView.byteLength - this.offset;
		}
		reset(offset) {
				if (offset === void 0) offset = 0;
				this.offset = offset;
		}
		skip(bytes) {
				this.offset += bytes;
		}
		align(bytes) {
				this.offset = this.offset + bytes - 1 & ~(bytes - 1);
		}
		_inc(amount) {
				this.offset += amount;
				return this.offset - amount;
		}
		readChar() {
				return String.fromCharCode(this.dataView.getUint8(this.offset++));
		}
		readChars(numChars) {
				var result = '';
				for(var i = 0; i < numChars; ++i){
						result += this.readChar();
				}
				return result;
		}
		readU8() {
				return this.dataView.getUint8(this.offset++);
		}
		readU16() {
				return this.dataView.getUint16(this._inc(2), true);
		}
		readU32() {
				return this.dataView.getUint32(this._inc(4), true);
		}
		readU64() {
				return this.readU32() + 2 ** 32 * this.readU32();
		}
		readU32be() {
				return this.dataView.getUint32(this._inc(4), false);
		}
		readArray(result) {
				for(var i = 0; i < result.length; ++i){
						result[i] = this.readU8();
				}
		}
		readLine() {
				var view = this.dataView;
				var result = '';
				while(true){
						if (this.offset >= view.byteLength) {
								break;
						}
						var c = String.fromCharCode(this.readU8());
						if (c === '\n') {
								break;
						}
						result += c;
				}
				return result;
		}
		constructor(arraybuffer){
				this.offset = 0;
				this.arraybuffer = arraybuffer;
				this.dataView = new DataView(arraybuffer);
		}
}

class SortedLoopArray {
		_binarySearch(item) {
				var left = 0;
				var right = this.items.length - 1;
				var search = item[this._sortBy];
				var middle;
				var current;
				while(left <= right){
						middle = Math.floor((left + right) / 2);
						current = this.items[middle][this._sortBy];
						if (current <= search) {
								left = middle + 1;
						} else if (current > search) {
								right = middle - 1;
						}
				}
				return left;
		}
		_doSort(a, b) {
				var sortBy = this._sortBy;
				return a[sortBy] - b[sortBy];
		}
		insert(item) {
				var index = this._binarySearch(item);
				this.items.splice(index, 0, item);
				this.length++;
				if (this.loopIndex >= index) {
						this.loopIndex++;
				}
		}
		append(item) {
				this.items.push(item);
				this.length++;
		}
		remove(item) {
				var idx = this.items.indexOf(item);
				if (idx < 0) return;
				this.items.splice(idx, 1);
				this.length--;
				if (this.loopIndex >= idx) {
						this.loopIndex--;
				}
		}
		sort() {
				var current = this.loopIndex >= 0 ? this.items[this.loopIndex] : null;
				this.items.sort(this._sortHandler);
				if (current !== null) {
						this.loopIndex = this.items.indexOf(current);
				}
		}
		constructor(args){
				this.items = [];
				this.length = 0;
				this.loopIndex = -1;
				this._sortBy = args.sortBy;
				this._sortHandler = this._doSort.bind(this);
		}
}

class Tags extends EventHandler {
		add() {
				for(var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++){
						args[_key] = arguments[_key];
				}
				var changed = false;
				var tags = this._processArguments(args, true);
				if (!tags.length) {
						return changed;
				}
				for(var i = 0; i < tags.length; i++){
						if (this._index[tags[i]]) {
								continue;
						}
						changed = true;
						this._index[tags[i]] = true;
						this._list.push(tags[i]);
						this.fire('add', tags[i], this._parent);
				}
				if (changed) {
						this.fire('change', this._parent);
				}
				return changed;
		}
		remove() {
				for(var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++){
						args[_key] = arguments[_key];
				}
				var changed = false;
				if (!this._list.length) {
						return changed;
				}
				var tags = this._processArguments(args, true);
				if (!tags.length) {
						return changed;
				}
				for(var i = 0; i < tags.length; i++){
						if (!this._index[tags[i]]) {
								continue;
						}
						changed = true;
						delete this._index[tags[i]];
						this._list.splice(this._list.indexOf(tags[i]), 1);
						this.fire('remove', tags[i], this._parent);
				}
				if (changed) {
						this.fire('change', this._parent);
				}
				return changed;
		}
		clear() {
				if (!this._list.length) {
						return;
				}
				var tags = this._list.slice(0);
				this._list = [];
				this._index = {};
				for(var i = 0; i < tags.length; i++){
						this.fire('remove', tags[i], this._parent);
				}
				this.fire('change', this._parent);
		}
		has() {
				for(var _len = arguments.length, query = new Array(_len), _key = 0; _key < _len; _key++){
						query[_key] = arguments[_key];
				}
				if (!this._list.length) {
						return false;
				}
				return this._has(this._processArguments(query));
		}
		_has(tags) {
				if (!this._list.length || !tags.length) {
						return false;
				}
				for(var i = 0; i < tags.length; i++){
						if (tags[i].length === 1) {
								if (this._index[tags[i][0]]) {
										return true;
								}
						} else {
								var multiple = true;
								for(var t = 0; t < tags[i].length; t++){
										if (this._index[tags[i][t]]) {
												continue;
										}
										multiple = false;
										break;
								}
								if (multiple) {
										return true;
								}
						}
				}
				return false;
		}
		list() {
				return this._list.slice(0);
		}
		_processArguments(args, flat) {
				var tags = [];
				var tmp = [];
				if (!args || !args.length) {
						return tags;
				}
				for(var i = 0; i < args.length; i++){
						if (args[i] instanceof Array) {
								if (!flat) {
										tmp = [];
								}
								for(var t = 0; t < args[i].length; t++){
										if (typeof args[i][t] !== 'string') {
												continue;
										}
										if (flat) {
												tags.push(args[i][t]);
										} else {
												tmp.push(args[i][t]);
										}
								}
								if (!flat && tmp.length) {
										tags.push(tmp);
								}
						} else if (typeof args[i] === 'string') {
								if (flat) {
										tags.push(args[i]);
								} else {
										tags.push([
												args[i]
										]);
								}
						}
				}
				return tags;
		}
		get size() {
				return this._list.length;
		}
		constructor(parent){
				super(), this._index = {}, this._list = [];
				this._parent = parent;
		}
}
Tags.EVENT_ADD = 'add';
Tags.EVENT_REMOVE = 'remove';
Tags.EVENT_CHANGE = 'change';

var now = typeof window !== 'undefined' && window.performance && window.performance.now ? performance.now.bind(performance) : Date.now;

var re = /^(([^:/?#]+):)?(\/\/([^/?#]*))?([^?#]*)(\?([^#]*))?(#(.*))?/;
class URI {
		toString() {
				var s = '';
				if (this.scheme) {
						s += "" + this.scheme + ":";
				}
				if (this.authority) {
						s += "//" + this.authority;
				}
				s += this.path;
				if (this.query) {
						s += "?" + this.query;
				}
				if (this.fragment) {
						s += "#" + this.fragment;
				}
				return s;
		}
		getQuery() {
				var result = {};
				if (this.query) {
						var queryParams = decodeURIComponent(this.query).split('&');
						for (var queryParam of queryParams){
								var pair = queryParam.split('=');
								result[pair[0]] = pair[1];
						}
				}
				return result;
		}
		setQuery(params) {
				var q = '';
				for(var key in params){
						if (params.hasOwnProperty(key)) {
								if (q !== '') {
										q += '&';
								}
								q += encodeURIComponent(key) + "=" + encodeURIComponent(params[key]);
						}
				}
				this.query = q;
		}
		constructor(uri){
				var result = uri.match(re);
				this.scheme = result[2];
				this.authority = result[4];
				this.path = result[5];
				this.query = result[7];
				this.fragment = result[9];
		}
}

class Tracing {
		static set(channel, enabled) {
		}
		static get(channel) {
				return Tracing._traceChannels.has(channel);
		}
}
Tracing._traceChannels = new Set();
Tracing.stack = false;

var CURVE_LINEAR = 0;
var CURVE_SMOOTHSTEP = 1;
var CURVE_SPLINE = 4;
var CURVE_STEP = 5;

var math = {
		DEG_TO_RAD: Math.PI / 180,
		RAD_TO_DEG: 180 / Math.PI,
		clamp (value, min, max) {
				if (value >= max) return max;
				if (value <= min) return min;
				return value;
		},
		intToBytes24 (i) {
				var r = i >> 16 & 0xff;
				var g = i >> 8 & 0xff;
				var b = i & 0xff;
				return [
						r,
						g,
						b
				];
		},
		intToBytes32 (i) {
				var r = i >> 24 & 0xff;
				var g = i >> 16 & 0xff;
				var b = i >> 8 & 0xff;
				var a = i & 0xff;
				return [
						r,
						g,
						b,
						a
				];
		},
		bytesToInt24 (r, g, b) {
				if (r.length) {
						b = r[2];
						g = r[1];
						r = r[0];
				}
				return r << 16 | g << 8 | b;
		},
		bytesToInt32 (r, g, b, a) {
				if (r.length) {
						a = r[3];
						b = r[2];
						g = r[1];
						r = r[0];
				}
				return (r << 24 | g << 16 | b << 8 | a) >>> 0;
		},
		lerp (a, b, alpha) {
				return a + (b - a) * math.clamp(alpha, 0, 1);
		},
		lerpAngle (a, b, alpha) {
				if (b - a > 180) {
						b -= 360;
				}
				if (b - a < -180) {
						b += 360;
				}
				return math.lerp(a, b, math.clamp(alpha, 0, 1));
		},
		powerOfTwo (x) {
				return x !== 0 && !(x & x - 1);
		},
		nextPowerOfTwo (val) {
				val--;
				val |= val >> 1;
				val |= val >> 2;
				val |= val >> 4;
				val |= val >> 8;
				val |= val >> 16;
				val++;
				return val;
		},
		nearestPowerOfTwo (val) {
				return Math.pow(2, Math.round(Math.log(val) / Math.log(2)));
		},
		random (min, max) {
				var diff = max - min;
				return Math.random() * diff + min;
		},
		smoothstep (min, max, x) {
				if (x <= min) return 0;
				if (x >= max) return 1;
				x = (x - min) / (max - min);
				return x * x * (3 - 2 * x);
		},
		smootherstep (min, max, x) {
				if (x <= min) return 0;
				if (x >= max) return 1;
				x = (x - min) / (max - min);
				return x * x * x * (x * (x * 6 - 15) + 10);
		},
		roundUp (numToRound, multiple) {
				if (multiple === 0) {
						return numToRound;
				}
				return Math.ceil(numToRound / multiple) * multiple;
		},
		between (num, a, b, inclusive) {
				var min = Math.min(a, b);
				var max = Math.max(a, b);
				return inclusive ? num >= min && num <= max : num > min && num < max;
		}
};

class Color {
		clone() {
				var cstr = this.constructor;
				return new cstr(this.r, this.g, this.b, this.a);
		}
		copy(rhs) {
				this.r = rhs.r;
				this.g = rhs.g;
				this.b = rhs.b;
				this.a = rhs.a;
				return this;
		}
		equals(rhs) {
				return this.r === rhs.r && this.g === rhs.g && this.b === rhs.b && this.a === rhs.a;
		}
		set(r, g, b, a) {
				if (a === void 0) a = 1;
				this.r = r;
				this.g = g;
				this.b = b;
				this.a = a;
				return this;
		}
		lerp(lhs, rhs, alpha) {
				this.r = lhs.r + alpha * (rhs.r - lhs.r);
				this.g = lhs.g + alpha * (rhs.g - lhs.g);
				this.b = lhs.b + alpha * (rhs.b - lhs.b);
				this.a = lhs.a + alpha * (rhs.a - lhs.a);
				return this;
		}
		linear(src) {
				if (src === void 0) src = this;
				this.r = Math.pow(src.r, 2.2);
				this.g = Math.pow(src.g, 2.2);
				this.b = Math.pow(src.b, 2.2);
				this.a = src.a;
				return this;
		}
		gamma(src) {
				if (src === void 0) src = this;
				this.r = Math.pow(src.r, 1 / 2.2);
				this.g = Math.pow(src.g, 1 / 2.2);
				this.b = Math.pow(src.b, 1 / 2.2);
				this.a = src.a;
				return this;
		}
		mulScalar(scalar) {
				this.r *= scalar;
				this.g *= scalar;
				this.b *= scalar;
				return this;
		}
		fromString(hex) {
				var i = parseInt(hex.replace('#', '0x'), 16);
				var bytes;
				if (hex.length > 7) {
						bytes = math.intToBytes32(i);
				} else {
						bytes = math.intToBytes24(i);
						bytes[3] = 255;
				}
				this.set(bytes[0] / 255, bytes[1] / 255, bytes[2] / 255, bytes[3] / 255);
				return this;
		}
		fromArray(arr, offset) {
				if (offset === void 0) offset = 0;
				var _arr_offset;
				this.r = (_arr_offset = arr[offset]) != null ? _arr_offset : this.r;
				var _arr_;
				this.g = (_arr_ = arr[offset + 1]) != null ? _arr_ : this.g;
				var _arr_1;
				this.b = (_arr_1 = arr[offset + 2]) != null ? _arr_1 : this.b;
				var _arr_2;
				this.a = (_arr_2 = arr[offset + 3]) != null ? _arr_2 : this.a;
				return this;
		}
		toString(alpha, asArray) {
				var { r, g, b, a } = this;
				if (asArray || r > 1 || g > 1 || b > 1) {
						return r.toFixed(3) + ", " + g.toFixed(3) + ", " + b.toFixed(3) + ", " + a.toFixed(3);
				}
				var s = "#" + ((1 << 24) + (Math.round(r * 255) << 16) + (Math.round(g * 255) << 8) + Math.round(b * 255)).toString(16).slice(1);
				if (alpha === true) {
						var aa = Math.round(a * 255).toString(16);
						if (this.a < 16 / 255) {
								s += "0" + aa;
						} else {
								s += aa;
						}
				}
				return s;
		}
		toArray(arr, offset, alpha) {
				if (arr === void 0) arr = [];
				if (offset === void 0) offset = 0;
				if (alpha === void 0) alpha = true;
				arr[offset] = this.r;
				arr[offset + 1] = this.g;
				arr[offset + 2] = this.b;
				if (alpha) {
						arr[offset + 3] = this.a;
				}
				return arr;
		}
		constructor(r = 0, g = 0, b = 0, a = 1){
				var length = r.length;
				if (length === 3 || length === 4) {
						this.r = r[0];
						this.g = r[1];
						this.b = r[2];
						var _r_;
						this.a = (_r_ = r[3]) != null ? _r_ : 1;
				} else {
						this.r = r;
						this.g = g;
						this.b = b;
						this.a = a;
				}
		}
}
Color.BLACK = Object.freeze(new Color(0, 0, 0, 1));
Color.BLUE = Object.freeze(new Color(0, 0, 1, 1));
Color.CYAN = Object.freeze(new Color(0, 1, 1, 1));
Color.GRAY = Object.freeze(new Color(0.5, 0.5, 0.5, 1));
Color.GREEN = Object.freeze(new Color(0, 1, 0, 1));
Color.MAGENTA = Object.freeze(new Color(1, 0, 1, 1));
Color.RED = Object.freeze(new Color(1, 0, 0, 1));
Color.WHITE = Object.freeze(new Color(1, 1, 1, 1));
Color.YELLOW = Object.freeze(new Color(1, 1, 0, 1));

class CurveEvaluator {
		evaluate(time, forceReset) {
				if (forceReset === void 0) forceReset = false;
				if (forceReset || time < this._left || time >= this._right) {
						this._reset(time);
				}
				var result;
				var type = this._curve.type;
				if (type === CURVE_STEP) {
						result = this._p0;
				} else {
						var t = this._recip === 0 ? 0 : (time - this._left) * this._recip;
						if (type === CURVE_LINEAR) {
								result = math.lerp(this._p0, this._p1, t);
						} else if (type === CURVE_SMOOTHSTEP) {
								result = math.lerp(this._p0, this._p1, t * t * (3 - 2 * t));
						} else {
								result = this._evaluateHermite(this._p0, this._p1, this._m0, this._m1, t);
						}
				}
				return result;
		}
		_reset(time) {
				var keys = this._curve.keys;
				var len = keys.length;
				if (!len) {
						this._left = -Infinity;
						this._right = Infinity;
						this._recip = 0;
						this._p0 = this._p1 = this._m0 = this._m1 = 0;
				} else {
						if (time < keys[0][0]) {
								this._left = -Infinity;
								this._right = keys[0][0];
								this._recip = 0;
								this._p0 = this._p1 = keys[0][1];
								this._m0 = this._m1 = 0;
						} else if (time >= keys[len - 1][0]) {
								this._left = keys[len - 1][0];
								this._right = Infinity;
								this._recip = 0;
								this._p0 = this._p1 = keys[len - 1][1];
								this._m0 = this._m1 = 0;
						} else {
								var index = 0;
								while(time >= keys[index + 1][0]){
										index++;
								}
								this._left = keys[index][0];
								this._right = keys[index + 1][0];
								var diff = 1.0 / (this._right - this._left);
								this._recip = isFinite(diff) ? diff : 0;
								this._p0 = keys[index][1];
								this._p1 = keys[index + 1][1];
								if (this._curve.type === CURVE_SPLINE) {
										this._calcTangents(keys, index);
								}
						}
				}
		}
		_calcTangents(keys, index) {
				var a;
				var b = keys[index];
				var c = keys[index + 1];
				var d;
				if (index === 0) {
						a = [
								keys[0][0] + (keys[0][0] - keys[1][0]),
								keys[0][1] + (keys[0][1] - keys[1][1])
						];
				} else {
						a = keys[index - 1];
				}
				if (index === keys.length - 2) {
						d = [
								keys[index + 1][0] + (keys[index + 1][0] - keys[index][0]),
								keys[index + 1][1] + (keys[index + 1][1] - keys[index][1])
						];
				} else {
						d = keys[index + 2];
				}
				if (this._curve.type === CURVE_SPLINE) {
						var s1_ = 2 * (c[0] - b[0]) / (c[0] - a[0]);
						var s2_ = 2 * (c[0] - b[0]) / (d[0] - b[0]);
						this._m0 = this._curve.tension * (isFinite(s1_) ? s1_ : 0) * (c[1] - a[1]);
						this._m1 = this._curve.tension * (isFinite(s2_) ? s2_ : 0) * (d[1] - b[1]);
				} else {
						var s1 = (c[0] - b[0]) / (b[0] - a[0]);
						var s2 = (c[0] - b[0]) / (d[0] - c[0]);
						var a_ = b[1] + (a[1] - b[1]) * (isFinite(s1) ? s1 : 0);
						var d_ = c[1] + (d[1] - c[1]) * (isFinite(s2) ? s2 : 0);
						var tension = this._curve.tension;
						this._m0 = tension * (c[1] - a_);
						this._m1 = tension * (d_ - b[1]);
				}
		}
		_evaluateHermite(p0, p1, m0, m1, t) {
				var t2 = t * t;
				var twot = t + t;
				var omt = 1 - t;
				var omt2 = omt * omt;
				return p0 * ((1 + twot) * omt2) + m0 * (t * omt2) + p1 * (t2 * (3 - twot)) + m1 * (t2 * (t - 1));
		}
		constructor(curve, time = 0){
				this._left = -Infinity;
				this._right = Infinity;
				this._recip = 0;
				this._p0 = 0;
				this._p1 = 0;
				this._m0 = 0;
				this._m1 = 0;
				this._curve = curve;
				this._reset(time);
		}
}

class Curve {
		get length() {
				return this.keys.length;
		}
		add(time, value) {
				var keys = this.keys;
				var len = keys.length;
				var i = 0;
				for(; i < len; i++){
						if (keys[i][0] > time) {
								break;
						}
				}
				var key = [
						time,
						value
				];
				this.keys.splice(i, 0, key);
				return key;
		}
		get(index) {
				return this.keys[index];
		}
		sort() {
				this.keys.sort((a, b)=>a[0] - b[0]);
		}
		value(time) {
				return this._eval.evaluate(time, true);
		}
		closest(time) {
				var keys = this.keys;
				var length = keys.length;
				var min = 2;
				var result = null;
				for(var i = 0; i < length; i++){
						var diff = Math.abs(time - keys[i][0]);
						if (min >= diff) {
								min = diff;
								result = keys[i];
						} else {
								break;
						}
				}
				return result;
		}
		clone() {
				var result = new this.constructor();
				result.keys = this.keys.map((key)=>[
								...key
						]);
				result.type = this.type;
				result.tension = this.tension;
				return result;
		}
		quantize(precision) {
				precision = Math.max(precision, 2);
				var values = new Float32Array(precision);
				var step = 1.0 / (precision - 1);
				values[0] = this._eval.evaluate(0, true);
				for(var i = 1; i < precision; i++){
						values[i] = this._eval.evaluate(step * i);
				}
				return values;
		}
		quantizeClamped(precision, min, max) {
				var result = this.quantize(precision);
				for(var i = 0; i < result.length; ++i){
						result[i] = Math.min(max, Math.max(min, result[i]));
				}
				return result;
		}
		constructor(data){
				this.keys = [];
				this.type = CURVE_SMOOTHSTEP;
				this.tension = 0.5;
				this._eval = new CurveEvaluator(this);
				if (data) {
						for(var i = 0; i < data.length - 1; i += 2){
								this.keys.push([
										data[i],
										data[i + 1]
								]);
						}
				}
				this.sort();
		}
}

class CurveSet {
		get length() {
				return this.curves.length;
		}
		set type(value) {
				this._type = value;
				for(var i = 0; i < this.curves.length; i++){
						this.curves[i].type = value;
				}
		}
		get type() {
				return this._type;
		}
		get(index) {
				return this.curves[index];
		}
		value(time, result) {
				if (result === void 0) result = [];
				var length = this.curves.length;
				result.length = length;
				for(var i = 0; i < length; i++){
						result[i] = this.curves[i].value(time);
				}
				return result;
		}
		clone() {
				var result = new this.constructor();
				result.curves = [];
				for(var i = 0; i < this.curves.length; i++){
						result.curves.push(this.curves[i].clone());
				}
				result._type = this._type;
				return result;
		}
		quantize(precision) {
				precision = Math.max(precision, 2);
				var numCurves = this.curves.length;
				var values = new Float32Array(precision * numCurves);
				var step = 1.0 / (precision - 1);
				for(var c = 0; c < numCurves; c++){
						var ev = new CurveEvaluator(this.curves[c]);
						for(var i = 0; i < precision; i++){
								values[i * numCurves + c] = ev.evaluate(step * i);
						}
				}
				return values;
		}
		quantizeClamped(precision, min, max) {
				var result = this.quantize(precision);
				for(var i = 0; i < result.length; ++i){
						result[i] = Math.min(max, Math.max(min, result[i]));
				}
				return result;
		}
		constructor(){
				this.curves = [];
				this._type = CURVE_SMOOTHSTEP;
				if (arguments.length > 1) {
						for(var i = 0; i < arguments.length; i++){
								this.curves.push(new Curve(arguments[i]));
						}
				} else {
						if (arguments.length === 0) {
								this.curves.push(new Curve());
						} else {
								var arg = arguments[0];
								if (typeof arg === 'number') {
										for(var i1 = 0; i1 < arg; i1++){
												this.curves.push(new Curve());
										}
								} else {
										for(var i2 = 0; i2 < arg.length; i2++){
												this.curves.push(new Curve(arg[i2]));
										}
								}
						}
				}
		}
}

var oneDiv255 = 1 / 255;
var floatView = new Float32Array(1);
var int32View = new Int32Array(floatView.buffer);
class FloatPacking {
		static float2Half(value) {
				floatView[0] = value;
				var x = int32View[0];
				var bits = x >> 16 & 0x8000;
				var m = x >> 12 & 0x07ff;
				var e = x >> 23 & 0xff;
				if (e < 103) {
						return bits;
				}
				if (e > 142) {
						bits |= 0x7c00;
						bits |= (e === 255 ? 0 : 1) && x & 0x007fffff;
						return bits;
				}
				if (e < 113) {
						m |= 0x0800;
						bits |= (m >> 114 - e) + (m >> 113 - e & 1);
						return bits;
				}
				bits |= e - 112 << 10 | m >> 1;
				bits += m & 1;
				return bits;
		}
		static float2Bytes(value, array, offset, numBytes) {
				var enc1 = 255.0 * value % 1;
				array[offset + 0] = Math.round((value % 1 - oneDiv255 * enc1) * 255);
				if (numBytes > 1) {
						var enc2 = 65025.0 * value % 1;
						array[offset + 1] = Math.round((enc1 - oneDiv255 * enc2) * 255);
						if (numBytes > 2) {
								var enc3 = 16581375.0 * value % 1;
								array[offset + 2] = Math.round((enc2 - oneDiv255 * enc3) * 255);
								if (numBytes > 3) {
										array[offset + 3] = Math.round(enc3 * 255);
								}
						}
				}
		}
		static float2BytesRange(value, array, offset, min, max, numBytes) {
				value = math.clamp((value - min) / (max - min), 0, 1);
				FloatPacking.float2Bytes(value, array, offset, numBytes);
		}
		static float2RGBA8(value, data) {
				floatView[0] = value;
				var intBits = int32View[0];
				data.r = (intBits >> 24 & 0xFF) / 255.0;
				data.g = (intBits >> 16 & 0xFF) / 255.0;
				data.b = (intBits >> 8 & 0xFF) / 255.0;
				data.a = (intBits & 0xFF) / 255.0;
		}
}

class Vec3 {
		add(rhs) {
				this.x += rhs.x;
				this.y += rhs.y;
				this.z += rhs.z;
				return this;
		}
		add2(lhs, rhs) {
				this.x = lhs.x + rhs.x;
				this.y = lhs.y + rhs.y;
				this.z = lhs.z + rhs.z;
				return this;
		}
		addScalar(scalar) {
				this.x += scalar;
				this.y += scalar;
				this.z += scalar;
				return this;
		}
		addScaled(rhs, scalar) {
				this.x += rhs.x * scalar;
				this.y += rhs.y * scalar;
				this.z += rhs.z * scalar;
				return this;
		}
		clone() {
				var cstr = this.constructor;
				return new cstr(this.x, this.y, this.z);
		}
		copy(rhs) {
				this.x = rhs.x;
				this.y = rhs.y;
				this.z = rhs.z;
				return this;
		}
		cross(lhs, rhs) {
				var lx = lhs.x;
				var ly = lhs.y;
				var lz = lhs.z;
				var rx = rhs.x;
				var ry = rhs.y;
				var rz = rhs.z;
				this.x = ly * rz - ry * lz;
				this.y = lz * rx - rz * lx;
				this.z = lx * ry - rx * ly;
				return this;
		}
		distance(rhs) {
				var x = this.x - rhs.x;
				var y = this.y - rhs.y;
				var z = this.z - rhs.z;
				return Math.sqrt(x * x + y * y + z * z);
		}
		div(rhs) {
				this.x /= rhs.x;
				this.y /= rhs.y;
				this.z /= rhs.z;
				return this;
		}
		div2(lhs, rhs) {
				this.x = lhs.x / rhs.x;
				this.y = lhs.y / rhs.y;
				this.z = lhs.z / rhs.z;
				return this;
		}
		divScalar(scalar) {
				this.x /= scalar;
				this.y /= scalar;
				this.z /= scalar;
				return this;
		}
		dot(rhs) {
				return this.x * rhs.x + this.y * rhs.y + this.z * rhs.z;
		}
		equals(rhs) {
				return this.x === rhs.x && this.y === rhs.y && this.z === rhs.z;
		}
		equalsApprox(rhs, epsilon) {
				if (epsilon === void 0) epsilon = 1e-6;
				return Math.abs(this.x - rhs.x) < epsilon && Math.abs(this.y - rhs.y) < epsilon && Math.abs(this.z - rhs.z) < epsilon;
		}
		length() {
				return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
		}
		lengthSq() {
				return this.x * this.x + this.y * this.y + this.z * this.z;
		}
		lerp(lhs, rhs, alpha) {
				this.x = lhs.x + alpha * (rhs.x - lhs.x);
				this.y = lhs.y + alpha * (rhs.y - lhs.y);
				this.z = lhs.z + alpha * (rhs.z - lhs.z);
				return this;
		}
		mul(rhs) {
				this.x *= rhs.x;
				this.y *= rhs.y;
				this.z *= rhs.z;
				return this;
		}
		mul2(lhs, rhs) {
				this.x = lhs.x * rhs.x;
				this.y = lhs.y * rhs.y;
				this.z = lhs.z * rhs.z;
				return this;
		}
		mulScalar(scalar) {
				this.x *= scalar;
				this.y *= scalar;
				this.z *= scalar;
				return this;
		}
		normalize(src) {
				if (src === void 0) src = this;
				var lengthSq = src.x * src.x + src.y * src.y + src.z * src.z;
				if (lengthSq > 0) {
						var invLength = 1 / Math.sqrt(lengthSq);
						this.x = src.x * invLength;
						this.y = src.y * invLength;
						this.z = src.z * invLength;
				}
				return this;
		}
		floor(src) {
				if (src === void 0) src = this;
				this.x = Math.floor(src.x);
				this.y = Math.floor(src.y);
				this.z = Math.floor(src.z);
				return this;
		}
		ceil(src) {
				if (src === void 0) src = this;
				this.x = Math.ceil(src.x);
				this.y = Math.ceil(src.y);
				this.z = Math.ceil(src.z);
				return this;
		}
		round(src) {
				if (src === void 0) src = this;
				this.x = Math.round(src.x);
				this.y = Math.round(src.y);
				this.z = Math.round(src.z);
				return this;
		}
		min(rhs) {
				if (rhs.x < this.x) this.x = rhs.x;
				if (rhs.y < this.y) this.y = rhs.y;
				if (rhs.z < this.z) this.z = rhs.z;
				return this;
		}
		max(rhs) {
				if (rhs.x > this.x) this.x = rhs.x;
				if (rhs.y > this.y) this.y = rhs.y;
				if (rhs.z > this.z) this.z = rhs.z;
				return this;
		}
		project(rhs) {
				var a_dot_b = this.x * rhs.x + this.y * rhs.y + this.z * rhs.z;
				var b_dot_b = rhs.x * rhs.x + rhs.y * rhs.y + rhs.z * rhs.z;
				var s = a_dot_b / b_dot_b;
				this.x = rhs.x * s;
				this.y = rhs.y * s;
				this.z = rhs.z * s;
				return this;
		}
		set(x, y, z) {
				this.x = x;
				this.y = y;
				this.z = z;
				return this;
		}
		sub(rhs) {
				this.x -= rhs.x;
				this.y -= rhs.y;
				this.z -= rhs.z;
				return this;
		}
		sub2(lhs, rhs) {
				this.x = lhs.x - rhs.x;
				this.y = lhs.y - rhs.y;
				this.z = lhs.z - rhs.z;
				return this;
		}
		subScalar(scalar) {
				this.x -= scalar;
				this.y -= scalar;
				this.z -= scalar;
				return this;
		}
		fromArray(arr, offset) {
				if (offset === void 0) offset = 0;
				var _arr_offset;
				this.x = (_arr_offset = arr[offset]) != null ? _arr_offset : this.x;
				var _arr_;
				this.y = (_arr_ = arr[offset + 1]) != null ? _arr_ : this.y;
				var _arr_1;
				this.z = (_arr_1 = arr[offset + 2]) != null ? _arr_1 : this.z;
				return this;
		}
		toString() {
				return "[" + this.x + ", " + this.y + ", " + this.z + "]";
		}
		toArray(arr, offset) {
				if (arr === void 0) arr = [];
				if (offset === void 0) offset = 0;
				arr[offset] = this.x;
				arr[offset + 1] = this.y;
				arr[offset + 2] = this.z;
				return arr;
		}
		constructor(x = 0, y = 0, z = 0){
				if (x.length === 3) {
						this.x = x[0];
						this.y = x[1];
						this.z = x[2];
				} else {
						this.x = x;
						this.y = y;
						this.z = z;
				}
		}
}
Vec3.ZERO = Object.freeze(new Vec3(0, 0, 0));
Vec3.HALF = Object.freeze(new Vec3(0.5, 0.5, 0.5));
Vec3.ONE = Object.freeze(new Vec3(1, 1, 1));
Vec3.UP = Object.freeze(new Vec3(0, 1, 0));
Vec3.DOWN = Object.freeze(new Vec3(0, -1, 0));
Vec3.RIGHT = Object.freeze(new Vec3(1, 0, 0));
Vec3.LEFT = Object.freeze(new Vec3(-1, 0, 0));
Vec3.FORWARD = Object.freeze(new Vec3(0, 0, -1));
Vec3.BACK = Object.freeze(new Vec3(0, 0, 1));

class Mat3 {
		clone() {
				var cstr = this.constructor;
				return new cstr().copy(this);
		}
		copy(rhs) {
				var src = rhs.data;
				var dst = this.data;
				dst[0] = src[0];
				dst[1] = src[1];
				dst[2] = src[2];
				dst[3] = src[3];
				dst[4] = src[4];
				dst[5] = src[5];
				dst[6] = src[6];
				dst[7] = src[7];
				dst[8] = src[8];
				return this;
		}
		set(src) {
				var dst = this.data;
				dst[0] = src[0];
				dst[1] = src[1];
				dst[2] = src[2];
				dst[3] = src[3];
				dst[4] = src[4];
				dst[5] = src[5];
				dst[6] = src[6];
				dst[7] = src[7];
				dst[8] = src[8];
				return this;
		}
		getX(x) {
				if (x === void 0) x = new Vec3();
				return x.set(this.data[0], this.data[1], this.data[2]);
		}
		getY(y) {
				if (y === void 0) y = new Vec3();
				return y.set(this.data[3], this.data[4], this.data[5]);
		}
		getZ(z) {
				if (z === void 0) z = new Vec3();
				return z.set(this.data[6], this.data[7], this.data[8]);
		}
		equals(rhs) {
				var l = this.data;
				var r = rhs.data;
				return l[0] === r[0] && l[1] === r[1] && l[2] === r[2] && l[3] === r[3] && l[4] === r[4] && l[5] === r[5] && l[6] === r[6] && l[7] === r[7] && l[8] === r[8];
		}
		isIdentity() {
				var m = this.data;
				return m[0] === 1 && m[1] === 0 && m[2] === 0 && m[3] === 0 && m[4] === 1 && m[5] === 0 && m[6] === 0 && m[7] === 0 && m[8] === 1;
		}
		setIdentity() {
				var m = this.data;
				m[0] = 1;
				m[1] = 0;
				m[2] = 0;
				m[3] = 0;
				m[4] = 1;
				m[5] = 0;
				m[6] = 0;
				m[7] = 0;
				m[8] = 1;
				return this;
		}
		toString() {
				return "[" + this.data.join(', ') + "]";
		}
		transpose(src) {
				if (src === void 0) src = this;
				var s = src.data;
				var t = this.data;
				if (s === t) {
						var tmp;
						tmp = s[1];
						t[1] = s[3];
						t[3] = tmp;
						tmp = s[2];
						t[2] = s[6];
						t[6] = tmp;
						tmp = s[5];
						t[5] = s[7];
						t[7] = tmp;
				} else {
						t[0] = s[0];
						t[1] = s[3];
						t[2] = s[6];
						t[3] = s[1];
						t[4] = s[4];
						t[5] = s[7];
						t[6] = s[2];
						t[7] = s[5];
						t[8] = s[8];
				}
				return this;
		}
		setFromMat4(m) {
				var src = m.data;
				var dst = this.data;
				dst[0] = src[0];
				dst[1] = src[1];
				dst[2] = src[2];
				dst[3] = src[4];
				dst[4] = src[5];
				dst[5] = src[6];
				dst[6] = src[8];
				dst[7] = src[9];
				dst[8] = src[10];
				return this;
		}
		setFromQuat(r) {
				var qx = r.x;
				var qy = r.y;
				var qz = r.z;
				var qw = r.w;
				var x2 = qx + qx;
				var y2 = qy + qy;
				var z2 = qz + qz;
				var xx = qx * x2;
				var xy = qx * y2;
				var xz = qx * z2;
				var yy = qy * y2;
				var yz = qy * z2;
				var zz = qz * z2;
				var wx = qw * x2;
				var wy = qw * y2;
				var wz = qw * z2;
				var m = this.data;
				m[0] = 1 - (yy + zz);
				m[1] = xy + wz;
				m[2] = xz - wy;
				m[3] = xy - wz;
				m[4] = 1 - (xx + zz);
				m[5] = yz + wx;
				m[6] = xz + wy;
				m[7] = yz - wx;
				m[8] = 1 - (xx + yy);
				return this;
		}
		invertMat4(src) {
				var s = src.data;
				var a0 = s[0];
				var a1 = s[1];
				var a2 = s[2];
				var a4 = s[4];
				var a5 = s[5];
				var a6 = s[6];
				var a8 = s[8];
				var a9 = s[9];
				var a10 = s[10];
				var b11 = a10 * a5 - a6 * a9;
				var b21 = -a10 * a1 + a2 * a9;
				var b31 = a6 * a1 - a2 * a5;
				var b12 = -a10 * a4 + a6 * a8;
				var b22 = a10 * a0 - a2 * a8;
				var b32 = -a6 * a0 + a2 * a4;
				var b13 = a9 * a4 - a5 * a8;
				var b23 = -a9 * a0 + a1 * a8;
				var b33 = a5 * a0 - a1 * a4;
				var det = a0 * b11 + a1 * b12 + a2 * b13;
				if (det === 0) {
						this.setIdentity();
				} else {
						var invDet = 1 / det;
						var t = this.data;
						t[0] = b11 * invDet;
						t[1] = b21 * invDet;
						t[2] = b31 * invDet;
						t[3] = b12 * invDet;
						t[4] = b22 * invDet;
						t[5] = b32 * invDet;
						t[6] = b13 * invDet;
						t[7] = b23 * invDet;
						t[8] = b33 * invDet;
				}
				return this;
		}
		transformVector(vec, res) {
				if (res === void 0) res = new Vec3();
				var m = this.data;
				var { x, y, z } = vec;
				res.x = x * m[0] + y * m[3] + z * m[6];
				res.y = x * m[1] + y * m[4] + z * m[7];
				res.z = x * m[2] + y * m[5] + z * m[8];
				return res;
		}
		constructor(){
				this.data = new Float32Array(9);
				this.data[0] = this.data[4] = this.data[8] = 1;
		}
}
Mat3.IDENTITY = Object.freeze(new Mat3());
Mat3.ZERO = Object.freeze(new Mat3().set([
		0,
		0,
		0,
		0,
		0,
		0,
		0,
		0,
		0
]));

class Vec2 {
		add(rhs) {
				this.x += rhs.x;
				this.y += rhs.y;
				return this;
		}
		add2(lhs, rhs) {
				this.x = lhs.x + rhs.x;
				this.y = lhs.y + rhs.y;
				return this;
		}
		addScalar(scalar) {
				this.x += scalar;
				this.y += scalar;
				return this;
		}
		addScaled(rhs, scalar) {
				this.x += rhs.x * scalar;
				this.y += rhs.y * scalar;
				return this;
		}
		clone() {
				var cstr = this.constructor;
				return new cstr(this.x, this.y);
		}
		copy(rhs) {
				this.x = rhs.x;
				this.y = rhs.y;
				return this;
		}
		cross(rhs) {
				return this.x * rhs.y - this.y * rhs.x;
		}
		distance(rhs) {
				var x = this.x - rhs.x;
				var y = this.y - rhs.y;
				return Math.sqrt(x * x + y * y);
		}
		div(rhs) {
				this.x /= rhs.x;
				this.y /= rhs.y;
				return this;
		}
		div2(lhs, rhs) {
				this.x = lhs.x / rhs.x;
				this.y = lhs.y / rhs.y;
				return this;
		}
		divScalar(scalar) {
				this.x /= scalar;
				this.y /= scalar;
				return this;
		}
		dot(rhs) {
				return this.x * rhs.x + this.y * rhs.y;
		}
		equals(rhs) {
				return this.x === rhs.x && this.y === rhs.y;
		}
		equalsApprox(rhs, epsilon) {
				if (epsilon === void 0) epsilon = 1e-6;
				return Math.abs(this.x - rhs.x) < epsilon && Math.abs(this.y - rhs.y) < epsilon;
		}
		length() {
				return Math.sqrt(this.x * this.x + this.y * this.y);
		}
		lengthSq() {
				return this.x * this.x + this.y * this.y;
		}
		lerp(lhs, rhs, alpha) {
				this.x = lhs.x + alpha * (rhs.x - lhs.x);
				this.y = lhs.y + alpha * (rhs.y - lhs.y);
				return this;
		}
		mul(rhs) {
				this.x *= rhs.x;
				this.y *= rhs.y;
				return this;
		}
		mul2(lhs, rhs) {
				this.x = lhs.x * rhs.x;
				this.y = lhs.y * rhs.y;
				return this;
		}
		mulScalar(scalar) {
				this.x *= scalar;
				this.y *= scalar;
				return this;
		}
		normalize(src) {
				if (src === void 0) src = this;
				var lengthSq = src.x * src.x + src.y * src.y;
				if (lengthSq > 0) {
						var invLength = 1 / Math.sqrt(lengthSq);
						this.x = src.x * invLength;
						this.y = src.y * invLength;
				}
				return this;
		}
		rotate(degrees) {
				var angle = Math.atan2(this.x, this.y) + degrees * math.DEG_TO_RAD;
				var len = Math.sqrt(this.x * this.x + this.y * this.y);
				this.x = Math.sin(angle) * len;
				this.y = Math.cos(angle) * len;
				return this;
		}
		angle() {
				return Math.atan2(this.x, this.y) * math.RAD_TO_DEG;
		}
		angleTo(rhs) {
				return Math.atan2(this.x * rhs.y + this.y * rhs.x, this.x * rhs.x + this.y * rhs.y) * math.RAD_TO_DEG;
		}
		floor(src) {
				if (src === void 0) src = this;
				this.x = Math.floor(src.x);
				this.y = Math.floor(src.y);
				return this;
		}
		ceil(src) {
				if (src === void 0) src = this;
				this.x = Math.ceil(src.x);
				this.y = Math.ceil(src.y);
				return this;
		}
		round(src) {
				if (src === void 0) src = this;
				this.x = Math.round(src.x);
				this.y = Math.round(src.y);
				return this;
		}
		min(rhs) {
				if (rhs.x < this.x) this.x = rhs.x;
				if (rhs.y < this.y) this.y = rhs.y;
				return this;
		}
		max(rhs) {
				if (rhs.x > this.x) this.x = rhs.x;
				if (rhs.y > this.y) this.y = rhs.y;
				return this;
		}
		set(x, y) {
				this.x = x;
				this.y = y;
				return this;
		}
		sub(rhs) {
				this.x -= rhs.x;
				this.y -= rhs.y;
				return this;
		}
		sub2(lhs, rhs) {
				this.x = lhs.x - rhs.x;
				this.y = lhs.y - rhs.y;
				return this;
		}
		subScalar(scalar) {
				this.x -= scalar;
				this.y -= scalar;
				return this;
		}
		fromArray(arr, offset) {
				if (offset === void 0) offset = 0;
				var _arr_offset;
				this.x = (_arr_offset = arr[offset]) != null ? _arr_offset : this.x;
				var _arr_;
				this.y = (_arr_ = arr[offset + 1]) != null ? _arr_ : this.y;
				return this;
		}
		toString() {
				return "[" + this.x + ", " + this.y + "]";
		}
		toArray(arr, offset) {
				if (arr === void 0) arr = [];
				if (offset === void 0) offset = 0;
				arr[offset] = this.x;
				arr[offset + 1] = this.y;
				return arr;
		}
		static angleRad(lhs, rhs) {
				return Math.atan2(lhs.x * rhs.y - lhs.y * rhs.x, lhs.x * rhs.x + lhs.y * rhs.y);
		}
		constructor(x = 0, y = 0){
				if (x.length === 2) {
						this.x = x[0];
						this.y = x[1];
				} else {
						this.x = x;
						this.y = y;
				}
		}
}
Vec2.ZERO = Object.freeze(new Vec2(0, 0));
Vec2.HALF = Object.freeze(new Vec2(0.5, 0.5));
Vec2.ONE = Object.freeze(new Vec2(1, 1));
Vec2.UP = Object.freeze(new Vec2(0, 1));
Vec2.DOWN = Object.freeze(new Vec2(0, -1));
Vec2.RIGHT = Object.freeze(new Vec2(1, 0));
Vec2.LEFT = Object.freeze(new Vec2(-1, 0));

class Vec4 {
		add(rhs) {
				this.x += rhs.x;
				this.y += rhs.y;
				this.z += rhs.z;
				this.w += rhs.w;
				return this;
		}
		add2(lhs, rhs) {
				this.x = lhs.x + rhs.x;
				this.y = lhs.y + rhs.y;
				this.z = lhs.z + rhs.z;
				this.w = lhs.w + rhs.w;
				return this;
		}
		addScalar(scalar) {
				this.x += scalar;
				this.y += scalar;
				this.z += scalar;
				this.w += scalar;
				return this;
		}
		addScaled(rhs, scalar) {
				this.x += rhs.x * scalar;
				this.y += rhs.y * scalar;
				this.z += rhs.z * scalar;
				this.w += rhs.w * scalar;
				return this;
		}
		clone() {
				var cstr = this.constructor;
				return new cstr(this.x, this.y, this.z, this.w);
		}
		copy(rhs) {
				this.x = rhs.x;
				this.y = rhs.y;
				this.z = rhs.z;
				this.w = rhs.w;
				return this;
		}
		div(rhs) {
				this.x /= rhs.x;
				this.y /= rhs.y;
				this.z /= rhs.z;
				this.w /= rhs.w;
				return this;
		}
		div2(lhs, rhs) {
				this.x = lhs.x / rhs.x;
				this.y = lhs.y / rhs.y;
				this.z = lhs.z / rhs.z;
				this.w = lhs.w / rhs.w;
				return this;
		}
		divScalar(scalar) {
				this.x /= scalar;
				this.y /= scalar;
				this.z /= scalar;
				this.w /= scalar;
				return this;
		}
		dot(rhs) {
				return this.x * rhs.x + this.y * rhs.y + this.z * rhs.z + this.w * rhs.w;
		}
		equals(rhs) {
				return this.x === rhs.x && this.y === rhs.y && this.z === rhs.z && this.w === rhs.w;
		}
		equalsApprox(rhs, epsilon) {
				if (epsilon === void 0) epsilon = 1e-6;
				return Math.abs(this.x - rhs.x) < epsilon && Math.abs(this.y - rhs.y) < epsilon && Math.abs(this.z - rhs.z) < epsilon && Math.abs(this.w - rhs.w) < epsilon;
		}
		length() {
				return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w);
		}
		lengthSq() {
				return this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w;
		}
		lerp(lhs, rhs, alpha) {
				this.x = lhs.x + alpha * (rhs.x - lhs.x);
				this.y = lhs.y + alpha * (rhs.y - lhs.y);
				this.z = lhs.z + alpha * (rhs.z - lhs.z);
				this.w = lhs.w + alpha * (rhs.w - lhs.w);
				return this;
		}
		mul(rhs) {
				this.x *= rhs.x;
				this.y *= rhs.y;
				this.z *= rhs.z;
				this.w *= rhs.w;
				return this;
		}
		mul2(lhs, rhs) {
				this.x = lhs.x * rhs.x;
				this.y = lhs.y * rhs.y;
				this.z = lhs.z * rhs.z;
				this.w = lhs.w * rhs.w;
				return this;
		}
		mulScalar(scalar) {
				this.x *= scalar;
				this.y *= scalar;
				this.z *= scalar;
				this.w *= scalar;
				return this;
		}
		normalize(src) {
				if (src === void 0) src = this;
				var lengthSq = src.x * src.x + src.y * src.y + src.z * src.z + src.w * src.w;
				if (lengthSq > 0) {
						var invLength = 1 / Math.sqrt(lengthSq);
						this.x = src.x * invLength;
						this.y = src.y * invLength;
						this.z = src.z * invLength;
						this.w = src.w * invLength;
				}
				return this;
		}
		floor(src) {
				if (src === void 0) src = this;
				this.x = Math.floor(src.x);
				this.y = Math.floor(src.y);
				this.z = Math.floor(src.z);
				this.w = Math.floor(src.w);
				return this;
		}
		ceil(src) {
				if (src === void 0) src = this;
				this.x = Math.ceil(src.x);
				this.y = Math.ceil(src.y);
				this.z = Math.ceil(src.z);
				this.w = Math.ceil(src.w);
				return this;
		}
		round(src) {
				if (src === void 0) src = this;
				this.x = Math.round(src.x);
				this.y = Math.round(src.y);
				this.z = Math.round(src.z);
				this.w = Math.round(src.w);
				return this;
		}
		min(rhs) {
				if (rhs.x < this.x) this.x = rhs.x;
				if (rhs.y < this.y) this.y = rhs.y;
				if (rhs.z < this.z) this.z = rhs.z;
				if (rhs.w < this.w) this.w = rhs.w;
				return this;
		}
		max(rhs) {
				if (rhs.x > this.x) this.x = rhs.x;
				if (rhs.y > this.y) this.y = rhs.y;
				if (rhs.z > this.z) this.z = rhs.z;
				if (rhs.w > this.w) this.w = rhs.w;
				return this;
		}
		set(x, y, z, w) {
				this.x = x;
				this.y = y;
				this.z = z;
				this.w = w;
				return this;
		}
		sub(rhs) {
				this.x -= rhs.x;
				this.y -= rhs.y;
				this.z -= rhs.z;
				this.w -= rhs.w;
				return this;
		}
		sub2(lhs, rhs) {
				this.x = lhs.x - rhs.x;
				this.y = lhs.y - rhs.y;
				this.z = lhs.z - rhs.z;
				this.w = lhs.w - rhs.w;
				return this;
		}
		subScalar(scalar) {
				this.x -= scalar;
				this.y -= scalar;
				this.z -= scalar;
				this.w -= scalar;
				return this;
		}
		fromArray(arr, offset) {
				if (offset === void 0) offset = 0;
				var _arr_offset;
				this.x = (_arr_offset = arr[offset]) != null ? _arr_offset : this.x;
				var _arr_;
				this.y = (_arr_ = arr[offset + 1]) != null ? _arr_ : this.y;
				var _arr_1;
				this.z = (_arr_1 = arr[offset + 2]) != null ? _arr_1 : this.z;
				var _arr_2;
				this.w = (_arr_2 = arr[offset + 3]) != null ? _arr_2 : this.w;
				return this;
		}
		toString() {
				return "[" + this.x + ", " + this.y + ", " + this.z + ", " + this.w + "]";
		}
		toArray(arr, offset) {
				if (arr === void 0) arr = [];
				if (offset === void 0) offset = 0;
				arr[offset] = this.x;
				arr[offset + 1] = this.y;
				arr[offset + 2] = this.z;
				arr[offset + 3] = this.w;
				return arr;
		}
		constructor(x = 0, y = 0, z = 0, w = 0){
				if (x.length === 4) {
						this.x = x[0];
						this.y = x[1];
						this.z = x[2];
						this.w = x[3];
				} else {
						this.x = x;
						this.y = y;
						this.z = z;
						this.w = w;
				}
		}
}
Vec4.ZERO = Object.freeze(new Vec4(0, 0, 0, 0));
Vec4.HALF = Object.freeze(new Vec4(0.5, 0.5, 0.5, 0.5));
Vec4.ONE = Object.freeze(new Vec4(1, 1, 1, 1));

var _halfSize$1 = new Vec2();
var x$1 = new Vec3();
var y$1 = new Vec3();
var z$1 = new Vec3();
var scale = new Vec3();
class Mat4 {
		static _getPerspectiveHalfSize(halfSize, fov, aspect, znear, fovIsHorizontal) {
				if (fovIsHorizontal) {
						halfSize.x = znear * Math.tan(fov * Math.PI / 360);
						halfSize.y = halfSize.x / aspect;
				} else {
						halfSize.y = znear * Math.tan(fov * Math.PI / 360);
						halfSize.x = halfSize.y * aspect;
				}
		}
		add2(lhs, rhs) {
				var a = lhs.data, b = rhs.data, r = this.data;
				r[0] = a[0] + b[0];
				r[1] = a[1] + b[1];
				r[2] = a[2] + b[2];
				r[3] = a[3] + b[3];
				r[4] = a[4] + b[4];
				r[5] = a[5] + b[5];
				r[6] = a[6] + b[6];
				r[7] = a[7] + b[7];
				r[8] = a[8] + b[8];
				r[9] = a[9] + b[9];
				r[10] = a[10] + b[10];
				r[11] = a[11] + b[11];
				r[12] = a[12] + b[12];
				r[13] = a[13] + b[13];
				r[14] = a[14] + b[14];
				r[15] = a[15] + b[15];
				return this;
		}
		add(rhs) {
				return this.add2(this, rhs);
		}
		clone() {
				var cstr = this.constructor;
				return new cstr().copy(this);
		}
		copy(rhs) {
				var src = rhs.data, dst = this.data;
				dst[0] = src[0];
				dst[1] = src[1];
				dst[2] = src[2];
				dst[3] = src[3];
				dst[4] = src[4];
				dst[5] = src[5];
				dst[6] = src[6];
				dst[7] = src[7];
				dst[8] = src[8];
				dst[9] = src[9];
				dst[10] = src[10];
				dst[11] = src[11];
				dst[12] = src[12];
				dst[13] = src[13];
				dst[14] = src[14];
				dst[15] = src[15];
				return this;
		}
		equals(rhs) {
				var l = this.data, r = rhs.data;
				return l[0] === r[0] && l[1] === r[1] && l[2] === r[2] && l[3] === r[3] && l[4] === r[4] && l[5] === r[5] && l[6] === r[6] && l[7] === r[7] && l[8] === r[8] && l[9] === r[9] && l[10] === r[10] && l[11] === r[11] && l[12] === r[12] && l[13] === r[13] && l[14] === r[14] && l[15] === r[15];
		}
		isIdentity() {
				var m = this.data;
				return m[0] === 1 && m[1] === 0 && m[2] === 0 && m[3] === 0 && m[4] === 0 && m[5] === 1 && m[6] === 0 && m[7] === 0 && m[8] === 0 && m[9] === 0 && m[10] === 1 && m[11] === 0 && m[12] === 0 && m[13] === 0 && m[14] === 0 && m[15] === 1;
		}
		mul2(lhs, rhs) {
				var a = lhs.data;
				var b = rhs.data;
				var r = this.data;
				var a00 = a[0];
				var a01 = a[1];
				var a02 = a[2];
				var a03 = a[3];
				var a10 = a[4];
				var a11 = a[5];
				var a12 = a[6];
				var a13 = a[7];
				var a20 = a[8];
				var a21 = a[9];
				var a22 = a[10];
				var a23 = a[11];
				var a30 = a[12];
				var a31 = a[13];
				var a32 = a[14];
				var a33 = a[15];
				var b0, b1, b2, b3;
				b0 = b[0];
				b1 = b[1];
				b2 = b[2];
				b3 = b[3];
				r[0] = a00 * b0 + a10 * b1 + a20 * b2 + a30 * b3;
				r[1] = a01 * b0 + a11 * b1 + a21 * b2 + a31 * b3;
				r[2] = a02 * b0 + a12 * b1 + a22 * b2 + a32 * b3;
				r[3] = a03 * b0 + a13 * b1 + a23 * b2 + a33 * b3;
				b0 = b[4];
				b1 = b[5];
				b2 = b[6];
				b3 = b[7];
				r[4] = a00 * b0 + a10 * b1 + a20 * b2 + a30 * b3;
				r[5] = a01 * b0 + a11 * b1 + a21 * b2 + a31 * b3;
				r[6] = a02 * b0 + a12 * b1 + a22 * b2 + a32 * b3;
				r[7] = a03 * b0 + a13 * b1 + a23 * b2 + a33 * b3;
				b0 = b[8];
				b1 = b[9];
				b2 = b[10];
				b3 = b[11];
				r[8] = a00 * b0 + a10 * b1 + a20 * b2 + a30 * b3;
				r[9] = a01 * b0 + a11 * b1 + a21 * b2 + a31 * b3;
				r[10] = a02 * b0 + a12 * b1 + a22 * b2 + a32 * b3;
				r[11] = a03 * b0 + a13 * b1 + a23 * b2 + a33 * b3;
				b0 = b[12];
				b1 = b[13];
				b2 = b[14];
				b3 = b[15];
				r[12] = a00 * b0 + a10 * b1 + a20 * b2 + a30 * b3;
				r[13] = a01 * b0 + a11 * b1 + a21 * b2 + a31 * b3;
				r[14] = a02 * b0 + a12 * b1 + a22 * b2 + a32 * b3;
				r[15] = a03 * b0 + a13 * b1 + a23 * b2 + a33 * b3;
				return this;
		}
		mulAffine2(lhs, rhs) {
				var a = lhs.data;
				var b = rhs.data;
				var r = this.data;
				var a00 = a[0];
				var a01 = a[1];
				var a02 = a[2];
				var a10 = a[4];
				var a11 = a[5];
				var a12 = a[6];
				var a20 = a[8];
				var a21 = a[9];
				var a22 = a[10];
				var a30 = a[12];
				var a31 = a[13];
				var a32 = a[14];
				var b0, b1, b2;
				b0 = b[0];
				b1 = b[1];
				b2 = b[2];
				r[0] = a00 * b0 + a10 * b1 + a20 * b2;
				r[1] = a01 * b0 + a11 * b1 + a21 * b2;
				r[2] = a02 * b0 + a12 * b1 + a22 * b2;
				r[3] = 0;
				b0 = b[4];
				b1 = b[5];
				b2 = b[6];
				r[4] = a00 * b0 + a10 * b1 + a20 * b2;
				r[5] = a01 * b0 + a11 * b1 + a21 * b2;
				r[6] = a02 * b0 + a12 * b1 + a22 * b2;
				r[7] = 0;
				b0 = b[8];
				b1 = b[9];
				b2 = b[10];
				r[8] = a00 * b0 + a10 * b1 + a20 * b2;
				r[9] = a01 * b0 + a11 * b1 + a21 * b2;
				r[10] = a02 * b0 + a12 * b1 + a22 * b2;
				r[11] = 0;
				b0 = b[12];
				b1 = b[13];
				b2 = b[14];
				r[12] = a00 * b0 + a10 * b1 + a20 * b2 + a30;
				r[13] = a01 * b0 + a11 * b1 + a21 * b2 + a31;
				r[14] = a02 * b0 + a12 * b1 + a22 * b2 + a32;
				r[15] = 1;
				return this;
		}
		mul(rhs) {
				return this.mul2(this, rhs);
		}
		transformPoint(vec, res) {
				if (res === void 0) res = new Vec3();
				var m = this.data;
				var { x, y, z } = vec;
				res.x = x * m[0] + y * m[4] + z * m[8] + m[12];
				res.y = x * m[1] + y * m[5] + z * m[9] + m[13];
				res.z = x * m[2] + y * m[6] + z * m[10] + m[14];
				return res;
		}
		transformVector(vec, res) {
				if (res === void 0) res = new Vec3();
				var m = this.data;
				var { x, y, z } = vec;
				res.x = x * m[0] + y * m[4] + z * m[8];
				res.y = x * m[1] + y * m[5] + z * m[9];
				res.z = x * m[2] + y * m[6] + z * m[10];
				return res;
		}
		transformVec4(vec, res) {
				if (res === void 0) res = new Vec4();
				var m = this.data;
				var { x, y, z, w } = vec;
				res.x = x * m[0] + y * m[4] + z * m[8] + w * m[12];
				res.y = x * m[1] + y * m[5] + z * m[9] + w * m[13];
				res.z = x * m[2] + y * m[6] + z * m[10] + w * m[14];
				res.w = x * m[3] + y * m[7] + z * m[11] + w * m[15];
				return res;
		}
		setLookAt(position, target, up) {
				z$1.sub2(position, target).normalize();
				y$1.copy(up).normalize();
				x$1.cross(y$1, z$1).normalize();
				y$1.cross(z$1, x$1);
				var r = this.data;
				r[0] = x$1.x;
				r[1] = x$1.y;
				r[2] = x$1.z;
				r[3] = 0;
				r[4] = y$1.x;
				r[5] = y$1.y;
				r[6] = y$1.z;
				r[7] = 0;
				r[8] = z$1.x;
				r[9] = z$1.y;
				r[10] = z$1.z;
				r[11] = 0;
				r[12] = position.x;
				r[13] = position.y;
				r[14] = position.z;
				r[15] = 1;
				return this;
		}
		setFrustum(left, right, bottom, top, znear, zfar) {
				var temp1 = 2 * znear;
				var temp2 = right - left;
				var temp3 = top - bottom;
				var temp4 = zfar - znear;
				var r = this.data;
				r[0] = temp1 / temp2;
				r[1] = 0;
				r[2] = 0;
				r[3] = 0;
				r[4] = 0;
				r[5] = temp1 / temp3;
				r[6] = 0;
				r[7] = 0;
				r[8] = (right + left) / temp2;
				r[9] = (top + bottom) / temp3;
				r[10] = (-zfar - znear) / temp4;
				r[11] = -1;
				r[12] = 0;
				r[13] = 0;
				r[14] = -temp1 * zfar / temp4;
				r[15] = 0;
				return this;
		}
		setPerspective(fov, aspect, znear, zfar, fovIsHorizontal) {
				Mat4._getPerspectiveHalfSize(_halfSize$1, fov, aspect, znear, fovIsHorizontal);
				return this.setFrustum(-_halfSize$1.x, _halfSize$1.x, -_halfSize$1.y, _halfSize$1.y, znear, zfar);
		}
		setOrtho(left, right, bottom, top, near, far) {
				var r = this.data;
				r[0] = 2 / (right - left);
				r[1] = 0;
				r[2] = 0;
				r[3] = 0;
				r[4] = 0;
				r[5] = 2 / (top - bottom);
				r[6] = 0;
				r[7] = 0;
				r[8] = 0;
				r[9] = 0;
				r[10] = -2 / (far - near);
				r[11] = 0;
				r[12] = -(right + left) / (right - left);
				r[13] = -(top + bottom) / (top - bottom);
				r[14] = -(far + near) / (far - near);
				r[15] = 1;
				return this;
		}
		setFromAxisAngle(axis, angle) {
				angle *= math.DEG_TO_RAD;
				var { x, y, z } = axis;
				var c = Math.cos(angle);
				var s = Math.sin(angle);
				var t = 1 - c;
				var tx = t * x;
				var ty = t * y;
				var m = this.data;
				m[0] = tx * x + c;
				m[1] = tx * y + s * z;
				m[2] = tx * z - s * y;
				m[3] = 0;
				m[4] = tx * y - s * z;
				m[5] = ty * y + c;
				m[6] = ty * z + s * x;
				m[7] = 0;
				m[8] = tx * z + s * y;
				m[9] = ty * z - x * s;
				m[10] = t * z * z + c;
				m[11] = 0;
				m[12] = 0;
				m[13] = 0;
				m[14] = 0;
				m[15] = 1;
				return this;
		}
		setTranslate(x, y, z) {
				var m = this.data;
				m[0] = 1;
				m[1] = 0;
				m[2] = 0;
				m[3] = 0;
				m[4] = 0;
				m[5] = 1;
				m[6] = 0;
				m[7] = 0;
				m[8] = 0;
				m[9] = 0;
				m[10] = 1;
				m[11] = 0;
				m[12] = x;
				m[13] = y;
				m[14] = z;
				m[15] = 1;
				return this;
		}
		setScale(x, y, z) {
				var m = this.data;
				m[0] = x;
				m[1] = 0;
				m[2] = 0;
				m[3] = 0;
				m[4] = 0;
				m[5] = y;
				m[6] = 0;
				m[7] = 0;
				m[8] = 0;
				m[9] = 0;
				m[10] = z;
				m[11] = 0;
				m[12] = 0;
				m[13] = 0;
				m[14] = 0;
				m[15] = 1;
				return this;
		}
		setViewport(x, y, width, height) {
				var m = this.data;
				m[0] = width * 0.5;
				m[1] = 0;
				m[2] = 0;
				m[3] = 0;
				m[4] = 0;
				m[5] = height * 0.5;
				m[6] = 0;
				m[7] = 0;
				m[8] = 0;
				m[9] = 0;
				m[10] = 0.5;
				m[11] = 0;
				m[12] = x + width * 0.5;
				m[13] = y + height * 0.5;
				m[14] = 0.5;
				m[15] = 1;
				return this;
		}
		setReflection(normal, distance) {
				var a = normal.x;
				var b = normal.y;
				var c = normal.z;
				var data = this.data;
				data[0] = 1.0 - 2 * a * a;
				data[1] = -2 * a * b;
				data[2] = -2 * a * c;
				data[3] = 0;
				data[4] = -2 * a * b;
				data[5] = 1.0 - 2 * b * b;
				data[6] = -2 * b * c;
				data[7] = 0;
				data[8] = -2 * a * c;
				data[9] = -2 * b * c;
				data[10] = 1.0 - 2 * c * c;
				data[11] = 0;
				data[12] = -2 * a * distance;
				data[13] = -2 * b * distance;
				data[14] = -2 * c * distance;
				data[15] = 1;
				return this;
		}
		invert(src) {
				if (src === void 0) src = this;
				var s = src.data;
				var a00 = s[0];
				var a01 = s[1];
				var a02 = s[2];
				var a03 = s[3];
				var a10 = s[4];
				var a11 = s[5];
				var a12 = s[6];
				var a13 = s[7];
				var a20 = s[8];
				var a21 = s[9];
				var a22 = s[10];
				var a23 = s[11];
				var a30 = s[12];
				var a31 = s[13];
				var a32 = s[14];
				var a33 = s[15];
				var b00 = a00 * a11 - a01 * a10;
				var b01 = a00 * a12 - a02 * a10;
				var b02 = a00 * a13 - a03 * a10;
				var b03 = a01 * a12 - a02 * a11;
				var b04 = a01 * a13 - a03 * a11;
				var b05 = a02 * a13 - a03 * a12;
				var b06 = a20 * a31 - a21 * a30;
				var b07 = a20 * a32 - a22 * a30;
				var b08 = a20 * a33 - a23 * a30;
				var b09 = a21 * a32 - a22 * a31;
				var b10 = a21 * a33 - a23 * a31;
				var b11 = a22 * a33 - a23 * a32;
				var det = b00 * b11 - b01 * b10 + b02 * b09 + b03 * b08 - b04 * b07 + b05 * b06;
				if (det === 0) {
						this.setIdentity();
				} else {
						var invDet = 1 / det;
						var t = this.data;
						t[0] = (a11 * b11 - a12 * b10 + a13 * b09) * invDet;
						t[1] = (-a01 * b11 + a02 * b10 - a03 * b09) * invDet;
						t[2] = (a31 * b05 - a32 * b04 + a33 * b03) * invDet;
						t[3] = (-a21 * b05 + a22 * b04 - a23 * b03) * invDet;
						t[4] = (-a10 * b11 + a12 * b08 - a13 * b07) * invDet;
						t[5] = (a00 * b11 - a02 * b08 + a03 * b07) * invDet;
						t[6] = (-a30 * b05 + a32 * b02 - a33 * b01) * invDet;
						t[7] = (a20 * b05 - a22 * b02 + a23 * b01) * invDet;
						t[8] = (a10 * b10 - a11 * b08 + a13 * b06) * invDet;
						t[9] = (-a00 * b10 + a01 * b08 - a03 * b06) * invDet;
						t[10] = (a30 * b04 - a31 * b02 + a33 * b00) * invDet;
						t[11] = (-a20 * b04 + a21 * b02 - a23 * b00) * invDet;
						t[12] = (-a10 * b09 + a11 * b07 - a12 * b06) * invDet;
						t[13] = (a00 * b09 - a01 * b07 + a02 * b06) * invDet;
						t[14] = (-a30 * b03 + a31 * b01 - a32 * b00) * invDet;
						t[15] = (a20 * b03 - a21 * b01 + a22 * b00) * invDet;
				}
				return this;
		}
		set(src) {
				var dst = this.data;
				dst[0] = src[0];
				dst[1] = src[1];
				dst[2] = src[2];
				dst[3] = src[3];
				dst[4] = src[4];
				dst[5] = src[5];
				dst[6] = src[6];
				dst[7] = src[7];
				dst[8] = src[8];
				dst[9] = src[9];
				dst[10] = src[10];
				dst[11] = src[11];
				dst[12] = src[12];
				dst[13] = src[13];
				dst[14] = src[14];
				dst[15] = src[15];
				return this;
		}
		setIdentity() {
				var m = this.data;
				m[0] = 1;
				m[1] = 0;
				m[2] = 0;
				m[3] = 0;
				m[4] = 0;
				m[5] = 1;
				m[6] = 0;
				m[7] = 0;
				m[8] = 0;
				m[9] = 0;
				m[10] = 1;
				m[11] = 0;
				m[12] = 0;
				m[13] = 0;
				m[14] = 0;
				m[15] = 1;
				return this;
		}
		setTRS(t, r, s) {
				var qx = r.x;
				var qy = r.y;
				var qz = r.z;
				var qw = r.w;
				var sx = s.x;
				var sy = s.y;
				var sz = s.z;
				var x2 = qx + qx;
				var y2 = qy + qy;
				var z2 = qz + qz;
				var xx = qx * x2;
				var xy = qx * y2;
				var xz = qx * z2;
				var yy = qy * y2;
				var yz = qy * z2;
				var zz = qz * z2;
				var wx = qw * x2;
				var wy = qw * y2;
				var wz = qw * z2;
				var m = this.data;
				m[0] = (1 - (yy + zz)) * sx;
				m[1] = (xy + wz) * sx;
				m[2] = (xz - wy) * sx;
				m[3] = 0;
				m[4] = (xy - wz) * sy;
				m[5] = (1 - (xx + zz)) * sy;
				m[6] = (yz + wx) * sy;
				m[7] = 0;
				m[8] = (xz + wy) * sz;
				m[9] = (yz - wx) * sz;
				m[10] = (1 - (xx + yy)) * sz;
				m[11] = 0;
				m[12] = t.x;
				m[13] = t.y;
				m[14] = t.z;
				m[15] = 1;
				return this;
		}
		transpose(src) {
				if (src === void 0) src = this;
				var s = src.data;
				var t = this.data;
				if (s === t) {
						var tmp;
						tmp = s[1];
						t[1] = s[4];
						t[4] = tmp;
						tmp = s[2];
						t[2] = s[8];
						t[8] = tmp;
						tmp = s[3];
						t[3] = s[12];
						t[12] = tmp;
						tmp = s[6];
						t[6] = s[9];
						t[9] = tmp;
						tmp = s[7];
						t[7] = s[13];
						t[13] = tmp;
						tmp = s[11];
						t[11] = s[14];
						t[14] = tmp;
				} else {
						t[0] = s[0];
						t[1] = s[4];
						t[2] = s[8];
						t[3] = s[12];
						t[4] = s[1];
						t[5] = s[5];
						t[6] = s[9];
						t[7] = s[13];
						t[8] = s[2];
						t[9] = s[6];
						t[10] = s[10];
						t[11] = s[14];
						t[12] = s[3];
						t[13] = s[7];
						t[14] = s[11];
						t[15] = s[15];
				}
				return this;
		}
		getTranslation(t) {
				if (t === void 0) t = new Vec3();
				return t.set(this.data[12], this.data[13], this.data[14]);
		}
		getX(x) {
				if (x === void 0) x = new Vec3();
				return x.set(this.data[0], this.data[1], this.data[2]);
		}
		getY(y) {
				if (y === void 0) y = new Vec3();
				return y.set(this.data[4], this.data[5], this.data[6]);
		}
		getZ(z) {
				if (z === void 0) z = new Vec3();
				return z.set(this.data[8], this.data[9], this.data[10]);
		}
		getScale(scale) {
				if (scale === void 0) scale = new Vec3();
				this.getX(x$1);
				this.getY(y$1);
				this.getZ(z$1);
				scale.set(x$1.length(), y$1.length(), z$1.length());
				return scale;
		}
		get scaleSign() {
				this.getX(x$1);
				this.getY(y$1);
				this.getZ(z$1);
				x$1.cross(x$1, y$1);
				return x$1.dot(z$1) < 0 ? -1 : 1;
		}
		setFromEulerAngles(ex, ey, ez) {
				ex *= math.DEG_TO_RAD;
				ey *= math.DEG_TO_RAD;
				ez *= math.DEG_TO_RAD;
				var s1 = Math.sin(-ex);
				var c1 = Math.cos(-ex);
				var s2 = Math.sin(-ey);
				var c2 = Math.cos(-ey);
				var s3 = Math.sin(-ez);
				var c3 = Math.cos(-ez);
				var m = this.data;
				m[0] = c2 * c3;
				m[1] = -c2 * s3;
				m[2] = s2;
				m[3] = 0;
				m[4] = c1 * s3 + c3 * s1 * s2;
				m[5] = c1 * c3 - s1 * s2 * s3;
				m[6] = -c2 * s1;
				m[7] = 0;
				m[8] = s1 * s3 - c1 * c3 * s2;
				m[9] = c3 * s1 + c1 * s2 * s3;
				m[10] = c1 * c2;
				m[11] = 0;
				m[12] = 0;
				m[13] = 0;
				m[14] = 0;
				m[15] = 1;
				return this;
		}
		getEulerAngles(eulers) {
				if (eulers === void 0) eulers = new Vec3();
				this.getScale(scale);
				var sx = scale.x;
				var sy = scale.y;
				var sz = scale.z;
				if (sx === 0 || sy === 0 || sz === 0) {
						return eulers.set(0, 0, 0);
				}
				var m = this.data;
				var y = Math.asin(-m[2] / sx);
				var halfPi = Math.PI * 0.5;
				var x, z;
				if (y < halfPi) {
						if (y > -halfPi) {
								x = Math.atan2(m[6] / sy, m[10] / sz);
								z = Math.atan2(m[1] / sx, m[0] / sx);
						} else {
								z = 0;
								x = -Math.atan2(m[4] / sy, m[5] / sy);
						}
				} else {
						z = 0;
						x = Math.atan2(m[4] / sy, m[5] / sy);
				}
				return eulers.set(x, y, z).mulScalar(math.RAD_TO_DEG);
		}
		toString() {
				return "[" + this.data.join(', ') + "]";
		}
		constructor(){
				this.data = new Float32Array(16);
				this.data[0] = this.data[5] = this.data[10] = this.data[15] = 1;
		}
}
Mat4.IDENTITY = Object.freeze(new Mat4());
Mat4.ZERO = Object.freeze(new Mat4().set([
		0,
		0,
		0,
		0,
		0,
		0,
		0,
		0,
		0,
		0,
		0,
		0,
		0,
		0,
		0,
		0
]));

class Quat {
		clone() {
				var cstr = this.constructor;
				return new cstr(this.x, this.y, this.z, this.w);
		}
		conjugate(src) {
				if (src === void 0) src = this;
				this.x = src.x * -1;
				this.y = src.y * -1;
				this.z = src.z * -1;
				this.w = src.w;
				return this;
		}
		copy(rhs) {
				this.x = rhs.x;
				this.y = rhs.y;
				this.z = rhs.z;
				this.w = rhs.w;
				return this;
		}
		equals(rhs) {
				return this.x === rhs.x && this.y === rhs.y && this.z === rhs.z && this.w === rhs.w;
		}
		equalsApprox(rhs, epsilon) {
				if (epsilon === void 0) epsilon = 1e-6;
				return Math.abs(this.x - rhs.x) < epsilon && Math.abs(this.y - rhs.y) < epsilon && Math.abs(this.z - rhs.z) < epsilon && Math.abs(this.w - rhs.w) < epsilon;
		}
		getAxisAngle(axis) {
				var rad = Math.acos(this.w) * 2;
				var s = Math.sin(rad / 2);
				if (s !== 0) {
						axis.x = this.x / s;
						axis.y = this.y / s;
						axis.z = this.z / s;
						if (axis.x < 0 || axis.y < 0 || axis.z < 0) {
								axis.x *= -1;
								axis.y *= -1;
								axis.z *= -1;
								rad *= -1;
						}
				} else {
						axis.x = 1;
						axis.y = 0;
						axis.z = 0;
				}
				return rad * math.RAD_TO_DEG;
		}
		getEulerAngles(eulers) {
				if (eulers === void 0) eulers = new Vec3();
				var x, y, z;
				var qx = this.x;
				var qy = this.y;
				var qz = this.z;
				var qw = this.w;
				var a2 = 2 * (qw * qy - qx * qz);
				if (a2 <= -0.99999) {
						x = 2 * Math.atan2(qx, qw);
						y = -Math.PI / 2;
						z = 0;
				} else if (a2 >= 0.99999) {
						x = 2 * Math.atan2(qx, qw);
						y = Math.PI / 2;
						z = 0;
				} else {
						x = Math.atan2(2 * (qw * qx + qy * qz), 1 - 2 * (qx * qx + qy * qy));
						y = Math.asin(a2);
						z = Math.atan2(2 * (qw * qz + qx * qy), 1 - 2 * (qy * qy + qz * qz));
				}
				return eulers.set(x, y, z).mulScalar(math.RAD_TO_DEG);
		}
		invert(src) {
				if (src === void 0) src = this;
				return this.conjugate(src).normalize();
		}
		length() {
				return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w);
		}
		lengthSq() {
				return this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w;
		}
		mul(rhs) {
				var q1x = this.x;
				var q1y = this.y;
				var q1z = this.z;
				var q1w = this.w;
				var q2x = rhs.x;
				var q2y = rhs.y;
				var q2z = rhs.z;
				var q2w = rhs.w;
				this.x = q1w * q2x + q1x * q2w + q1y * q2z - q1z * q2y;
				this.y = q1w * q2y + q1y * q2w + q1z * q2x - q1x * q2z;
				this.z = q1w * q2z + q1z * q2w + q1x * q2y - q1y * q2x;
				this.w = q1w * q2w - q1x * q2x - q1y * q2y - q1z * q2z;
				return this;
		}
		mulScalar(scalar, src) {
				if (src === void 0) src = this;
				this.x = src.x * scalar;
				this.y = src.y * scalar;
				this.z = src.z * scalar;
				this.w = src.w * scalar;
				return this;
		}
		mul2(lhs, rhs) {
				var q1x = lhs.x;
				var q1y = lhs.y;
				var q1z = lhs.z;
				var q1w = lhs.w;
				var q2x = rhs.x;
				var q2y = rhs.y;
				var q2z = rhs.z;
				var q2w = rhs.w;
				this.x = q1w * q2x + q1x * q2w + q1y * q2z - q1z * q2y;
				this.y = q1w * q2y + q1y * q2w + q1z * q2x - q1x * q2z;
				this.z = q1w * q2z + q1z * q2w + q1x * q2y - q1y * q2x;
				this.w = q1w * q2w - q1x * q2x - q1y * q2y - q1z * q2z;
				return this;
		}
		normalize(src) {
				if (src === void 0) src = this;
				var len = src.length();
				if (len === 0) {
						this.x = this.y = this.z = 0;
						this.w = 1;
				} else {
						len = 1 / len;
						this.x = src.x * len;
						this.y = src.y * len;
						this.z = src.z * len;
						this.w = src.w * len;
				}
				return this;
		}
		set(x, y, z, w) {
				this.x = x;
				this.y = y;
				this.z = z;
				this.w = w;
				return this;
		}
		setFromAxisAngle(axis, angle) {
				angle *= 0.5 * math.DEG_TO_RAD;
				var sa = Math.sin(angle);
				var ca = Math.cos(angle);
				this.x = sa * axis.x;
				this.y = sa * axis.y;
				this.z = sa * axis.z;
				this.w = ca;
				return this;
		}
		setFromEulerAngles(ex, ey, ez) {
				if (ex instanceof Vec3) {
						var vec = ex;
						ex = vec.x;
						ey = vec.y;
						ez = vec.z;
				}
				var halfToRad = 0.5 * math.DEG_TO_RAD;
				ex *= halfToRad;
				ey *= halfToRad;
				ez *= halfToRad;
				var sx = Math.sin(ex);
				var cx = Math.cos(ex);
				var sy = Math.sin(ey);
				var cy = Math.cos(ey);
				var sz = Math.sin(ez);
				var cz = Math.cos(ez);
				this.x = sx * cy * cz - cx * sy * sz;
				this.y = cx * sy * cz + sx * cy * sz;
				this.z = cx * cy * sz - sx * sy * cz;
				this.w = cx * cy * cz + sx * sy * sz;
				return this;
		}
		setFromMat4(m) {
				var d = m.data;
				var m00 = d[0];
				var m01 = d[1];
				var m02 = d[2];
				var m10 = d[4];
				var m11 = d[5];
				var m12 = d[6];
				var m20 = d[8];
				var m21 = d[9];
				var m22 = d[10];
				var l;
				l = m00 * m00 + m01 * m01 + m02 * m02;
				if (l === 0) return this.set(0, 0, 0, 1);
				l = 1 / Math.sqrt(l);
				m00 *= l;
				m01 *= l;
				m02 *= l;
				l = m10 * m10 + m11 * m11 + m12 * m12;
				if (l === 0) return this.set(0, 0, 0, 1);
				l = 1 / Math.sqrt(l);
				m10 *= l;
				m11 *= l;
				m12 *= l;
				l = m20 * m20 + m21 * m21 + m22 * m22;
				if (l === 0) return this.set(0, 0, 0, 1);
				l = 1 / Math.sqrt(l);
				m20 *= l;
				m21 *= l;
				m22 *= l;
				if (m22 < 0) {
						if (m00 > m11) {
								this.set(1 + m00 - m11 - m22, m01 + m10, m20 + m02, m12 - m21);
						} else {
								this.set(m01 + m10, 1 - m00 + m11 - m22, m12 + m21, m20 - m02);
						}
				} else {
						if (m00 < -m11) {
								this.set(m20 + m02, m12 + m21, 1 - m00 - m11 + m22, m01 - m10);
						} else {
								this.set(m12 - m21, m20 - m02, m01 - m10, 1 + m00 + m11 + m22);
						}
				}
				return this.mulScalar(1.0 / this.length());
		}
		setFromDirections(from, to) {
				var dotProduct = 1 + from.dot(to);
				if (dotProduct < Number.EPSILON) {
						if (Math.abs(from.x) > Math.abs(from.y)) {
								this.x = -from.z;
								this.y = 0;
								this.z = from.x;
								this.w = 0;
						} else {
								this.x = 0;
								this.y = -from.z;
								this.z = from.y;
								this.w = 0;
						}
				} else {
						this.x = from.y * to.z - from.z * to.y;
						this.y = from.z * to.x - from.x * to.z;
						this.z = from.x * to.y - from.y * to.x;
						this.w = dotProduct;
				}
				return this.normalize();
		}
		slerp(lhs, rhs, alpha) {
				var lx = lhs.x;
				var ly = lhs.y;
				var lz = lhs.z;
				var lw = lhs.w;
				var rx = rhs.x;
				var ry = rhs.y;
				var rz = rhs.z;
				var rw = rhs.w;
				var cosHalfTheta = lw * rw + lx * rx + ly * ry + lz * rz;
				if (cosHalfTheta < 0) {
						rw = -rw;
						rx = -rx;
						ry = -ry;
						rz = -rz;
						cosHalfTheta = -cosHalfTheta;
				}
				if (Math.abs(cosHalfTheta) >= 1) {
						this.w = lw;
						this.x = lx;
						this.y = ly;
						this.z = lz;
						return this;
				}
				var halfTheta = Math.acos(cosHalfTheta);
				var sinHalfTheta = Math.sqrt(1 - cosHalfTheta * cosHalfTheta);
				if (Math.abs(sinHalfTheta) < 0.001) {
						this.w = lw * 0.5 + rw * 0.5;
						this.x = lx * 0.5 + rx * 0.5;
						this.y = ly * 0.5 + ry * 0.5;
						this.z = lz * 0.5 + rz * 0.5;
						return this;
				}
				var ratioA = Math.sin((1 - alpha) * halfTheta) / sinHalfTheta;
				var ratioB = Math.sin(alpha * halfTheta) / sinHalfTheta;
				this.w = lw * ratioA + rw * ratioB;
				this.x = lx * ratioA + rx * ratioB;
				this.y = ly * ratioA + ry * ratioB;
				this.z = lz * ratioA + rz * ratioB;
				return this;
		}
		transformVector(vec, res) {
				if (res === void 0) res = new Vec3();
				var x = vec.x, y = vec.y, z = vec.z;
				var qx = this.x, qy = this.y, qz = this.z, qw = this.w;
				var ix = qw * x + qy * z - qz * y;
				var iy = qw * y + qz * x - qx * z;
				var iz = qw * z + qx * y - qy * x;
				var iw = -qx * x - qy * y - qz * z;
				res.x = ix * qw + iw * -qx + iy * -qz - iz * -qy;
				res.y = iy * qw + iw * -qy + iz * -qx - ix * -qz;
				res.z = iz * qw + iw * -qz + ix * -qy - iy * -qx;
				return res;
		}
		toString() {
				return "[" + this.x + ", " + this.y + ", " + this.z + ", " + this.w + "]";
		}
		constructor(x = 0, y = 0, z = 0, w = 1){
				if (x.length === 4) {
						this.x = x[0];
						this.y = x[1];
						this.z = x[2];
						this.w = x[3];
				} else {
						this.x = x;
						this.y = y;
						this.z = z;
						this.w = w;
				}
		}
}
Quat.IDENTITY = Object.freeze(new Quat(0, 0, 0, 1));
Quat.ZERO = Object.freeze(new Quat(0, 0, 0, 0));

var tmpVecA$1 = new Vec3();
var tmpVecB$1 = new Vec3();
var tmpVecC = new Vec3();
var tmpVecD = new Vec3();
var tmpVecE = new Vec3();
class BoundingBox {
		add(other) {
				var tc = this.center;
				var tcx = tc.x;
				var tcy = tc.y;
				var tcz = tc.z;
				var th = this.halfExtents;
				var thx = th.x;
				var thy = th.y;
				var thz = th.z;
				var tminx = tcx - thx;
				var tmaxx = tcx + thx;
				var tminy = tcy - thy;
				var tmaxy = tcy + thy;
				var tminz = tcz - thz;
				var tmaxz = tcz + thz;
				var oc = other.center;
				var ocx = oc.x;
				var ocy = oc.y;
				var ocz = oc.z;
				var oh = other.halfExtents;
				var ohx = oh.x;
				var ohy = oh.y;
				var ohz = oh.z;
				var ominx = ocx - ohx;
				var omaxx = ocx + ohx;
				var ominy = ocy - ohy;
				var omaxy = ocy + ohy;
				var ominz = ocz - ohz;
				var omaxz = ocz + ohz;
				if (ominx < tminx) tminx = ominx;
				if (omaxx > tmaxx) tmaxx = omaxx;
				if (ominy < tminy) tminy = ominy;
				if (omaxy > tmaxy) tmaxy = omaxy;
				if (ominz < tminz) tminz = ominz;
				if (omaxz > tmaxz) tmaxz = omaxz;
				tc.x = (tminx + tmaxx) * 0.5;
				tc.y = (tminy + tmaxy) * 0.5;
				tc.z = (tminz + tmaxz) * 0.5;
				th.x = (tmaxx - tminx) * 0.5;
				th.y = (tmaxy - tminy) * 0.5;
				th.z = (tmaxz - tminz) * 0.5;
		}
		copy(src) {
				this.center.copy(src.center);
				this.halfExtents.copy(src.halfExtents);
		}
		clone() {
				return new BoundingBox(this.center, this.halfExtents);
		}
		intersects(other) {
				var aMax = this.getMax();
				var aMin = this.getMin();
				var bMax = other.getMax();
				var bMin = other.getMin();
				return aMin.x <= bMax.x && aMax.x >= bMin.x && aMin.y <= bMax.y && aMax.y >= bMin.y && aMin.z <= bMax.z && aMax.z >= bMin.z;
		}
		_intersectsRay(ray, point) {
				var tMin = tmpVecA$1.copy(this.getMin()).sub(ray.origin);
				var tMax = tmpVecB$1.copy(this.getMax()).sub(ray.origin);
				var dir = ray.direction;
				if (dir.x === 0) {
						tMin.x = tMin.x < 0 ? -Number.MAX_VALUE : Number.MAX_VALUE;
						tMax.x = tMax.x < 0 ? -Number.MAX_VALUE : Number.MAX_VALUE;
				} else {
						tMin.x /= dir.x;
						tMax.x /= dir.x;
				}
				if (dir.y === 0) {
						tMin.y = tMin.y < 0 ? -Number.MAX_VALUE : Number.MAX_VALUE;
						tMax.y = tMax.y < 0 ? -Number.MAX_VALUE : Number.MAX_VALUE;
				} else {
						tMin.y /= dir.y;
						tMax.y /= dir.y;
				}
				if (dir.z === 0) {
						tMin.z = tMin.z < 0 ? -Number.MAX_VALUE : Number.MAX_VALUE;
						tMax.z = tMax.z < 0 ? -Number.MAX_VALUE : Number.MAX_VALUE;
				} else {
						tMin.z /= dir.z;
						tMax.z /= dir.z;
				}
				var realMin = tmpVecC.set(Math.min(tMin.x, tMax.x), Math.min(tMin.y, tMax.y), Math.min(tMin.z, tMax.z));
				var realMax = tmpVecD.set(Math.max(tMin.x, tMax.x), Math.max(tMin.y, tMax.y), Math.max(tMin.z, tMax.z));
				var minMax = Math.min(Math.min(realMax.x, realMax.y), realMax.z);
				var maxMin = Math.max(Math.max(realMin.x, realMin.y), realMin.z);
				var intersects = minMax >= maxMin && maxMin >= 0;
				if (intersects) {
						point.copy(ray.direction).mulScalar(maxMin).add(ray.origin);
				}
				return intersects;
		}
		_fastIntersectsRay(ray) {
				var diff = tmpVecA$1;
				var cross = tmpVecB$1;
				var prod = tmpVecC;
				var absDiff = tmpVecD;
				var absDir = tmpVecE;
				var rayDir = ray.direction;
				diff.sub2(ray.origin, this.center);
				absDiff.set(Math.abs(diff.x), Math.abs(diff.y), Math.abs(diff.z));
				prod.mul2(diff, rayDir);
				if (absDiff.x > this.halfExtents.x && prod.x >= 0) {
						return false;
				}
				if (absDiff.y > this.halfExtents.y && prod.y >= 0) {
						return false;
				}
				if (absDiff.z > this.halfExtents.z && prod.z >= 0) {
						return false;
				}
				absDir.set(Math.abs(rayDir.x), Math.abs(rayDir.y), Math.abs(rayDir.z));
				cross.cross(rayDir, diff);
				cross.set(Math.abs(cross.x), Math.abs(cross.y), Math.abs(cross.z));
				if (cross.x > this.halfExtents.y * absDir.z + this.halfExtents.z * absDir.y) {
						return false;
				}
				if (cross.y > this.halfExtents.x * absDir.z + this.halfExtents.z * absDir.x) {
						return false;
				}
				if (cross.z > this.halfExtents.x * absDir.y + this.halfExtents.y * absDir.x) {
						return false;
				}
				return true;
		}
		intersectsRay(ray, point) {
				if (point) {
						return this._intersectsRay(ray, point);
				}
				return this._fastIntersectsRay(ray);
		}
		setMinMax(min, max) {
				this.center.add2(max, min).mulScalar(0.5);
				this.halfExtents.sub2(max, min).mulScalar(0.5);
		}
		getMin() {
				return this._min.copy(this.center).sub(this.halfExtents);
		}
		getMax() {
				return this._max.copy(this.center).add(this.halfExtents);
		}
		containsPoint(point) {
				var min = this.getMin();
				var max = this.getMax();
				if (point.x < min.x || point.x > max.x || point.y < min.y || point.y > max.y || point.z < min.z || point.z > max.z) {
						return false;
				}
				return true;
		}
		setFromTransformedAabb(aabb, m, ignoreScale) {
				if (ignoreScale === void 0) ignoreScale = false;
				var ac = aabb.center;
				var ar = aabb.halfExtents;
				var d = m.data;
				var mx0 = d[0];
				var mx1 = d[4];
				var mx2 = d[8];
				var my0 = d[1];
				var my1 = d[5];
				var my2 = d[9];
				var mz0 = d[2];
				var mz1 = d[6];
				var mz2 = d[10];
				if (ignoreScale) {
						var lengthSq = mx0 * mx0 + mx1 * mx1 + mx2 * mx2;
						if (lengthSq > 0) {
								var invLength = 1 / Math.sqrt(lengthSq);
								mx0 *= invLength;
								mx1 *= invLength;
								mx2 *= invLength;
						}
						lengthSq = my0 * my0 + my1 * my1 + my2 * my2;
						if (lengthSq > 0) {
								var invLength1 = 1 / Math.sqrt(lengthSq);
								my0 *= invLength1;
								my1 *= invLength1;
								my2 *= invLength1;
						}
						lengthSq = mz0 * mz0 + mz1 * mz1 + mz2 * mz2;
						if (lengthSq > 0) {
								var invLength2 = 1 / Math.sqrt(lengthSq);
								mz0 *= invLength2;
								mz1 *= invLength2;
								mz2 *= invLength2;
						}
				}
				this.center.set(d[12] + mx0 * ac.x + mx1 * ac.y + mx2 * ac.z, d[13] + my0 * ac.x + my1 * ac.y + my2 * ac.z, d[14] + mz0 * ac.x + mz1 * ac.y + mz2 * ac.z);
				this.halfExtents.set(Math.abs(mx0) * ar.x + Math.abs(mx1) * ar.y + Math.abs(mx2) * ar.z, Math.abs(my0) * ar.x + Math.abs(my1) * ar.y + Math.abs(my2) * ar.z, Math.abs(mz0) * ar.x + Math.abs(mz1) * ar.y + Math.abs(mz2) * ar.z);
		}
		static computeMinMax(vertices, min, max, numVerts) {
				if (numVerts === void 0) numVerts = vertices.length / 3;
				if (numVerts > 0) {
						var minx = vertices[0];
						var miny = vertices[1];
						var minz = vertices[2];
						var maxx = minx;
						var maxy = miny;
						var maxz = minz;
						var n = numVerts * 3;
						for(var i = 3; i < n; i += 3){
								var x = vertices[i];
								var y = vertices[i + 1];
								var z = vertices[i + 2];
								if (x < minx) minx = x;
								if (y < miny) miny = y;
								if (z < minz) minz = z;
								if (x > maxx) maxx = x;
								if (y > maxy) maxy = y;
								if (z > maxz) maxz = z;
						}
						min.set(minx, miny, minz);
						max.set(maxx, maxy, maxz);
				}
		}
		compute(vertices, numVerts) {
				BoundingBox.computeMinMax(vertices, tmpVecA$1, tmpVecB$1, numVerts);
				this.setMinMax(tmpVecA$1, tmpVecB$1);
		}
		intersectsBoundingSphere(sphere) {
				var sq = this._distanceToBoundingSphereSq(sphere);
				if (sq <= sphere.radius * sphere.radius) {
						return true;
				}
				return false;
		}
		_distanceToBoundingSphereSq(sphere) {
				var boxMin = this.getMin();
				var boxMax = this.getMax();
				var sq = 0;
				var axis = [
						'x',
						'y',
						'z'
				];
				for(var i = 0; i < 3; ++i){
						var out = 0;
						var pn = sphere.center[axis[i]];
						var bMin = boxMin[axis[i]];
						var bMax = boxMax[axis[i]];
						var val = 0;
						if (pn < bMin) {
								val = bMin - pn;
								out += val * val;
						}
						if (pn > bMax) {
								val = pn - bMax;
								out += val * val;
						}
						sq += out;
				}
				return sq;
		}
		_expand(expandMin, expandMax) {
				tmpVecA$1.add2(this.getMin(), expandMin);
				tmpVecB$1.add2(this.getMax(), expandMax);
				this.setMinMax(tmpVecA$1, tmpVecB$1);
		}
		constructor(center, halfExtents){
				this.center = new Vec3();
				this.halfExtents = new Vec3(0.5, 0.5, 0.5);
				this._min = new Vec3();
				this._max = new Vec3();
				if (center) {
						this.center.copy(center);
				}
				if (halfExtents) {
						this.halfExtents.copy(halfExtents);
				}
		}
}

var tmpVecA = new Vec3();
var tmpVecB = new Vec3();
class BoundingSphere {
		containsPoint(point) {
				var lenSq = tmpVecA.sub2(point, this.center).lengthSq();
				var r = this.radius;
				return lenSq < r * r;
		}
		intersectsRay(ray, point) {
				var m = tmpVecA.copy(ray.origin).sub(this.center);
				var b = m.dot(tmpVecB.copy(ray.direction).normalize());
				var c = m.dot(m) - this.radius * this.radius;
				if (c > 0 && b > 0) {
						return false;
				}
				var discr = b * b - c;
				if (discr < 0) {
						return false;
				}
				var t = Math.abs(-b - Math.sqrt(discr));
				if (point) {
						point.copy(ray.direction).mulScalar(t).add(ray.origin);
				}
				return true;
		}
		intersectsBoundingSphere(sphere) {
				tmpVecA.sub2(sphere.center, this.center);
				var totalRadius = sphere.radius + this.radius;
				if (tmpVecA.lengthSq() <= totalRadius * totalRadius) {
						return true;
				}
				return false;
		}
		constructor(center = new Vec3(), radius = 0.5){
				this.center = center;
				this.radius = radius;
		}
}

class Plane {
		clone() {
				var cstr = this.constructor;
				return new cstr().copy(this);
		}
		copy(src) {
				this.normal.copy(src.normal);
				this.distance = src.distance;
				return this;
		}
		intersectsLine(start, end, point) {
				var d = this.distance;
				var d0 = this.normal.dot(start) + d;
				var d1 = this.normal.dot(end) + d;
				var t = d0 / (d0 - d1);
				var intersects = t >= 0 && t <= 1;
				if (intersects && point) {
						point.lerp(start, end, t);
				}
				return intersects;
		}
		intersectsRay(ray, point) {
				var denominator = this.normal.dot(ray.direction);
				if (denominator === 0) {
						return false;
				}
				var t = -(this.normal.dot(ray.origin) + this.distance) / denominator;
				if (t >= 0 && point) {
						point.copy(ray.direction).mulScalar(t).add(ray.origin);
				}
				return t >= 0;
		}
		normalize() {
				var invLength = 1 / this.normal.length();
				this.normal.mulScalar(invLength);
				this.distance *= invLength;
				return this;
		}
		set(nx, ny, nz, d) {
				this.normal.set(nx, ny, nz);
				this.distance = d;
				return this;
		}
		setFromPointNormal(point, normal) {
				this.normal.copy(normal);
				this.distance = -this.normal.dot(point);
				return this;
		}
		constructor(normal = Vec3.UP, distance = 0){
				this.normal = new Vec3();
				this.normal.copy(normal);
				this.distance = distance;
		}
}

class Frustum {
		clone() {
				var cstr = this.constructor;
				return new cstr().copy(this);
		}
		copy(src) {
				for(var i = 0; i < 6; i++){
						this.planes[i].copy(src.planes[i]);
				}
				return this;
		}
		setFromMat4(matrix) {
				var [m00, m01, m02, m03, m10, m11, m12, m13, m20, m21, m22, m23, m30, m31, m32, m33] = matrix.data;
				var planes = this.planes;
				planes[0].set(m03 - m00, m13 - m10, m23 - m20, m33 - m30).normalize();
				planes[1].set(m03 + m00, m13 + m10, m23 + m20, m33 + m30).normalize();
				planes[2].set(m03 + m01, m13 + m11, m23 + m21, m33 + m31).normalize();
				planes[3].set(m03 - m01, m13 - m11, m23 - m21, m33 - m31).normalize();
				planes[4].set(m03 - m02, m13 - m12, m23 - m22, m33 - m32).normalize();
				planes[5].set(m03 + m02, m13 + m12, m23 + m22, m33 + m32).normalize();
		}
		containsPoint(point) {
				for(var p = 0; p < 6; p++){
						var { normal, distance } = this.planes[p];
						if (normal.dot(point) + distance <= 0) {
								return false;
						}
				}
				return true;
		}
		containsSphere(sphere) {
				var { center, radius } = sphere;
				var c = 0;
				for(var p = 0; p < 6; p++){
						var { normal, distance } = this.planes[p];
						var d = normal.dot(center) + distance;
						if (d <= -radius) {
								return 0;
						}
						if (d > radius) {
								c++;
						}
				}
				return c === 6 ? 2 : 1;
		}
		constructor(){
				this.planes = [];
				for(var i = 0; i < 6; i++){
						this.planes[i] = new Plane();
				}
		}
}

class Ray {
		set(origin, direction) {
				this.origin.copy(origin);
				this.direction.copy(direction);
				return this;
		}
		copy(src) {
				return this.set(src.origin, src.direction);
		}
		clone() {
				return new this.constructor(this.origin, this.direction);
		}
		constructor(origin, direction){
				this.origin = new Vec3();
				this.direction = Vec3.FORWARD.clone();
				if (origin) {
						this.origin.copy(origin);
				}
				if (direction) {
						this.direction.copy(direction);
				}
		}
}

var DISTANCE_LINEAR = 'linear';
var DISTANCE_INVERSE = 'inverse';
var DISTANCE_EXPONENTIAL = 'exponential';

var ADDRESS_REPEAT = 0;
var ADDRESS_CLAMP_TO_EDGE = 1;
var ADDRESS_MIRRORED_REPEAT = 2;
var BLENDMODE_ZERO = 0;
var BLENDMODE_ONE = 1;
var BLENDMODE_SRC_COLOR = 2;
var BLENDMODE_DST_COLOR = 4;
var BLENDMODE_ONE_MINUS_DST_COLOR = 5;
var BLENDMODE_SRC_ALPHA = 6;
var BLENDMODE_ONE_MINUS_SRC_ALPHA = 8;
var BLENDEQUATION_ADD = 0;
var BLENDEQUATION_REVERSE_SUBTRACT = 2;
var BLENDEQUATION_MIN = 3;
var BLENDEQUATION_MAX = 4;
var BUFFER_STATIC = 0;
var BUFFER_DYNAMIC = 1;
var BUFFER_STREAM = 2;
var BUFFER_GPUDYNAMIC = 3;
var CLEARFLAG_COLOR = 1;
var CLEARFLAG_DEPTH = 2;
var CLEARFLAG_STENCIL = 4;
var CULLFACE_NONE = 0;
var CULLFACE_BACK = 1;
var CULLFACE_FRONT = 2;
var CULLFACE_FRONTANDBACK = 3;
var FILTER_NEAREST = 0;
var FILTER_LINEAR = 1;
var FILTER_NEAREST_MIPMAP_NEAREST = 2;
var FILTER_NEAREST_MIPMAP_LINEAR = 3;
var FILTER_LINEAR_MIPMAP_NEAREST = 4;
var FILTER_LINEAR_MIPMAP_LINEAR = 5;
var FUNC_NEVER = 0;
var FUNC_LESS = 1;
var FUNC_EQUAL = 2;
var FUNC_LESSEQUAL = 3;
var FUNC_GREATER = 4;
var FUNC_NOTEQUAL = 5;
var FUNC_GREATEREQUAL = 6;
var FUNC_ALWAYS = 7;
var INDEXFORMAT_UINT8 = 0;
var INDEXFORMAT_UINT16 = 1;
var INDEXFORMAT_UINT32 = 2;
var PIXELFORMAT_A8 = 0;
var PIXELFORMAT_L8 = 1;
var PIXELFORMAT_LA8 = 2;
var PIXELFORMAT_RGB565 = 3;
var PIXELFORMAT_RGBA5551 = 4;
var PIXELFORMAT_RGBA4 = 5;
var PIXELFORMAT_RGB8 = 6;
var PIXELFORMAT_RGBA8 = 7;
var PIXELFORMAT_DXT1 = 8;
var PIXELFORMAT_DXT3 = 9;
var PIXELFORMAT_DXT5 = 10;
var PIXELFORMAT_RGB16F = 11;
var PIXELFORMAT_RGBA16F = 12;
var PIXELFORMAT_RGB32F = 13;
var PIXELFORMAT_RGBA32F = 14;
var PIXELFORMAT_R32F = 15;
var PIXELFORMAT_DEPTH = 16;
var PIXELFORMAT_DEPTHSTENCIL = 17;
var PIXELFORMAT_111110F = 18;
var PIXELFORMAT_SRGB8 = 19;
var PIXELFORMAT_SRGBA8 = 20;
var PIXELFORMAT_ETC1 = 21;
var PIXELFORMAT_ETC2_RGB = 22;
var PIXELFORMAT_ETC2_RGBA = 23;
var PIXELFORMAT_PVRTC_2BPP_RGB_1 = 24;
var PIXELFORMAT_PVRTC_2BPP_RGBA_1 = 25;
var PIXELFORMAT_PVRTC_4BPP_RGB_1 = 26;
var PIXELFORMAT_PVRTC_4BPP_RGBA_1 = 27;
var PIXELFORMAT_ASTC_4x4 = 28;
var PIXELFORMAT_ATC_RGB = 29;
var PIXELFORMAT_ATC_RGBA = 30;
var PIXELFORMAT_BGRA8 = 31;
var PIXELFORMAT_R8I = 32;
var PIXELFORMAT_R8U = 33;
var PIXELFORMAT_R16I = 34;
var PIXELFORMAT_R16U = 35;
var PIXELFORMAT_R32I = 36;
var PIXELFORMAT_R32U = 37;
var PIXELFORMAT_RG8I = 38;
var PIXELFORMAT_RG8U = 39;
var PIXELFORMAT_RG16I = 40;
var PIXELFORMAT_RG16U = 41;
var PIXELFORMAT_RG32I = 42;
var PIXELFORMAT_RG32U = 43;
var PIXELFORMAT_RGBA8I = 44;
var PIXELFORMAT_RGBA8U = 45;
var PIXELFORMAT_RGBA16I = 46;
var PIXELFORMAT_RGBA16U = 47;
var PIXELFORMAT_RGBA32I = 48;
var PIXELFORMAT_RGBA32U = 49;
var PIXELFORMAT_R16F = 50;
var PIXELFORMAT_RG16F = 51;
var PIXELFORMAT_R8 = 52;
var PIXELFORMAT_RG8 = 53;
var PIXELFORMAT_DXT1_SRGB = 54;
var PIXELFORMAT_DXT3_SRGBA = 55;
var PIXELFORMAT_DXT5_SRGBA = 56;
var PIXELFORMAT_ETC2_SRGB = 61;
var PIXELFORMAT_ETC2_SRGBA = 62;
var PIXELFORMAT_ASTC_4x4_SRGB = 63;
var PIXELFORMAT_SBGRA8 = 64;
var PIXELFORMAT_BC6F = 65;
var PIXELFORMAT_BC6UF = 66;
var PIXELFORMAT_BC7 = 67;
var PIXELFORMAT_BC7_SRGBA = 68;
var PIXELFORMAT_DEPTH16 = 69;
var pixelFormatInfo = new Map([
		[
				PIXELFORMAT_A8,
				{
						name: 'A8',
						size: 1,
						ldr: true
				}
		],
		[
				PIXELFORMAT_R8,
				{
						name: 'R8',
						size: 1,
						ldr: true
				}
		],
		[
				PIXELFORMAT_L8,
				{
						name: 'L8',
						size: 1,
						ldr: true
				}
		],
		[
				PIXELFORMAT_LA8,
				{
						name: 'LA8',
						size: 2,
						ldr: true
				}
		],
		[
				PIXELFORMAT_RG8,
				{
						name: 'RG8',
						size: 2,
						ldr: true
				}
		],
		[
				PIXELFORMAT_RGB565,
				{
						name: 'RGB565',
						size: 2,
						ldr: true
				}
		],
		[
				PIXELFORMAT_RGBA5551,
				{
						name: 'RGBA5551',
						size: 2,
						ldr: true
				}
		],
		[
				PIXELFORMAT_RGBA4,
				{
						name: 'RGBA4',
						size: 2,
						ldr: true
				}
		],
		[
				PIXELFORMAT_RGB8,
				{
						name: 'RGB8',
						size: 4,
						ldr: true
				}
		],
		[
				PIXELFORMAT_RGBA8,
				{
						name: 'RGBA8',
						size: 4,
						ldr: true,
						srgbFormat: PIXELFORMAT_SRGBA8
				}
		],
		[
				PIXELFORMAT_R16F,
				{
						name: 'R16F',
						size: 2
				}
		],
		[
				PIXELFORMAT_RG16F,
				{
						name: 'RG16F',
						size: 4
				}
		],
		[
				PIXELFORMAT_RGB16F,
				{
						name: 'RGB16F',
						size: 8
				}
		],
		[
				PIXELFORMAT_RGBA16F,
				{
						name: 'RGBA16F',
						size: 8
				}
		],
		[
				PIXELFORMAT_RGB32F,
				{
						name: 'RGB32F',
						size: 16
				}
		],
		[
				PIXELFORMAT_RGBA32F,
				{
						name: 'RGBA32F',
						size: 16
				}
		],
		[
				PIXELFORMAT_R32F,
				{
						name: 'R32F',
						size: 4
				}
		],
		[
				PIXELFORMAT_DEPTH,
				{
						name: 'DEPTH',
						size: 4
				}
		],
		[
				PIXELFORMAT_DEPTH16,
				{
						name: 'DEPTH16',
						size: 2
				}
		],
		[
				PIXELFORMAT_DEPTHSTENCIL,
				{
						name: 'DEPTHSTENCIL',
						size: 4
				}
		],
		[
				PIXELFORMAT_111110F,
				{
						name: '111110F',
						size: 4
				}
		],
		[
				PIXELFORMAT_SRGB8,
				{
						name: 'SRGB8',
						size: 4,
						ldr: true,
						srgb: true
				}
		],
		[
				PIXELFORMAT_SRGBA8,
				{
						name: 'SRGBA8',
						size: 4,
						ldr: true,
						srgb: true
				}
		],
		[
				PIXELFORMAT_BGRA8,
				{
						name: 'BGRA8',
						size: 4,
						ldr: true
				}
		],
		[
				PIXELFORMAT_SBGRA8,
				{
						name: 'SBGRA8',
						size: 4,
						ldr: true,
						srgb: true
				}
		],
		[
				PIXELFORMAT_DXT1,
				{
						name: 'DXT1',
						blockSize: 8,
						ldr: true,
						srgbFormat: PIXELFORMAT_DXT1_SRGB
				}
		],
		[
				PIXELFORMAT_DXT3,
				{
						name: 'DXT3',
						blockSize: 16,
						ldr: true,
						srgbFormat: PIXELFORMAT_DXT3_SRGBA
				}
		],
		[
				PIXELFORMAT_DXT5,
				{
						name: 'DXT5',
						blockSize: 16,
						ldr: true,
						srgbFormat: PIXELFORMAT_DXT5_SRGBA
				}
		],
		[
				PIXELFORMAT_ETC1,
				{
						name: 'ETC1',
						blockSize: 8,
						ldr: true
				}
		],
		[
				PIXELFORMAT_ETC2_RGB,
				{
						name: 'ETC2_RGB',
						blockSize: 8,
						ldr: true,
						srgbFormat: PIXELFORMAT_ETC2_SRGB
				}
		],
		[
				PIXELFORMAT_ETC2_RGBA,
				{
						name: 'ETC2_RGBA',
						blockSize: 16,
						ldr: true,
						srgbFormat: PIXELFORMAT_ETC2_SRGBA
				}
		],
		[
				PIXELFORMAT_PVRTC_2BPP_RGB_1,
				{
						name: 'PVRTC_2BPP_RGB_1',
						ldr: true,
						blockSize: 8
				}
		],
		[
				PIXELFORMAT_PVRTC_2BPP_RGBA_1,
				{
						name: 'PVRTC_2BPP_RGBA_1',
						ldr: true,
						blockSize: 8
				}
		],
		[
				PIXELFORMAT_PVRTC_4BPP_RGB_1,
				{
						name: 'PVRTC_4BPP_RGB_1',
						ldr: true,
						blockSize: 8
				}
		],
		[
				PIXELFORMAT_PVRTC_4BPP_RGBA_1,
				{
						name: 'PVRTC_4BPP_RGBA_1',
						ldr: true,
						blockSize: 8
				}
		],
		[
				PIXELFORMAT_ASTC_4x4,
				{
						name: 'ASTC_4x4',
						blockSize: 16,
						ldr: true,
						srgbFormat: PIXELFORMAT_ASTC_4x4_SRGB
				}
		],
		[
				PIXELFORMAT_ATC_RGB,
				{
						name: 'ATC_RGB',
						blockSize: 8,
						ldr: true
				}
		],
		[
				PIXELFORMAT_ATC_RGBA,
				{
						name: 'ATC_RGBA',
						blockSize: 16,
						ldr: true
				}
		],
		[
				PIXELFORMAT_BC6F,
				{
						name: 'BC6H_RGBF',
						blockSize: 16
				}
		],
		[
				PIXELFORMAT_BC6UF,
				{
						name: 'BC6H_RGBUF',
						blockSize: 16
				}
		],
		[
				PIXELFORMAT_BC7,
				{
						name: 'BC7_RGBA',
						blockSize: 16,
						ldr: true,
						srgbFormat: PIXELFORMAT_BC7_SRGBA
				}
		],
		[
				PIXELFORMAT_DXT1_SRGB,
				{
						name: 'DXT1_SRGB',
						blockSize: 8,
						ldr: true,
						srgb: true
				}
		],
		[
				PIXELFORMAT_DXT3_SRGBA,
				{
						name: 'DXT3_SRGBA',
						blockSize: 16,
						ldr: true,
						srgb: true
				}
		],
		[
				PIXELFORMAT_DXT5_SRGBA,
				{
						name: 'DXT5_SRGBA',
						blockSize: 16,
						ldr: true,
						srgb: true
				}
		],
		[
				PIXELFORMAT_ETC2_SRGB,
				{
						name: 'ETC2_SRGB',
						blockSize: 8,
						ldr: true,
						srgb: true
				}
		],
		[
				PIXELFORMAT_ETC2_SRGBA,
				{
						name: 'ETC2_SRGBA',
						blockSize: 16,
						ldr: true,
						srgb: true
				}
		],
		[
				PIXELFORMAT_ASTC_4x4_SRGB,
				{
						name: 'ASTC_4x4_SRGB',
						blockSize: 16,
						ldr: true,
						srgb: true
				}
		],
		[
				PIXELFORMAT_BC7_SRGBA,
				{
						name: 'BC7_SRGBA',
						blockSize: 16,
						ldr: true,
						srgb: true
				}
		],
		[
				PIXELFORMAT_R8I,
				{
						name: 'R8I',
						size: 1,
						isInt: true
				}
		],
		[
				PIXELFORMAT_R8U,
				{
						name: 'R8U',
						size: 1,
						isInt: true
				}
		],
		[
				PIXELFORMAT_R16I,
				{
						name: 'R16I',
						size: 2,
						isInt: true
				}
		],
		[
				PIXELFORMAT_R16U,
				{
						name: 'R16U',
						size: 2,
						isInt: true
				}
		],
		[
				PIXELFORMAT_R32I,
				{
						name: 'R32I',
						size: 4,
						isInt: true
				}
		],
		[
				PIXELFORMAT_R32U,
				{
						name: 'R32U',
						size: 4,
						isInt: true
				}
		],
		[
				PIXELFORMAT_RG8I,
				{
						name: 'RG8I',
						size: 2,
						isInt: true
				}
		],
		[
				PIXELFORMAT_RG8U,
				{
						name: 'RG8U',
						size: 2,
						isInt: true
				}
		],
		[
				PIXELFORMAT_RG16I,
				{
						name: 'RG16I',
						size: 4,
						isInt: true
				}
		],
		[
				PIXELFORMAT_RG16U,
				{
						name: 'RG16U',
						size: 4,
						isInt: true
				}
		],
		[
				PIXELFORMAT_RG32I,
				{
						name: 'RG32I',
						size: 8,
						isInt: true
				}
		],
		[
				PIXELFORMAT_RG32U,
				{
						name: 'RG32U',
						size: 8,
						isInt: true
				}
		],
		[
				PIXELFORMAT_RGBA8I,
				{
						name: 'RGBA8I',
						size: 4,
						isInt: true
				}
		],
		[
				PIXELFORMAT_RGBA8U,
				{
						name: 'RGBA8U',
						size: 4,
						isInt: true
				}
		],
		[
				PIXELFORMAT_RGBA16I,
				{
						name: 'RGBA16I',
						size: 8,
						isInt: true
				}
		],
		[
				PIXELFORMAT_RGBA16U,
				{
						name: 'RGBA16U',
						size: 8,
						isInt: true
				}
		],
		[
				PIXELFORMAT_RGBA32I,
				{
						name: 'RGBA32I',
						size: 16,
						isInt: true
				}
		],
		[
				PIXELFORMAT_RGBA32U,
				{
						name: 'RGBA32U',
						size: 16,
						isInt: true
				}
		]
]);
var isCompressedPixelFormat = (format)=>{
		var _pixelFormatInfo_get;
		return ((_pixelFormatInfo_get = pixelFormatInfo.get(format)) == null ? void 0 : _pixelFormatInfo_get.blockSize) !== undefined;
};
var isSrgbPixelFormat = (format)=>{
		var _pixelFormatInfo_get;
		return ((_pixelFormatInfo_get = pixelFormatInfo.get(format)) == null ? void 0 : _pixelFormatInfo_get.srgb) === true;
};
var isIntegerPixelFormat = (format)=>{
		var _pixelFormatInfo_get;
		return ((_pixelFormatInfo_get = pixelFormatInfo.get(format)) == null ? void 0 : _pixelFormatInfo_get.isInt) === true;
};
var pixelFormatLinearToGamma = (format)=>{
		var _pixelFormatInfo_get;
		return ((_pixelFormatInfo_get = pixelFormatInfo.get(format)) == null ? void 0 : _pixelFormatInfo_get.srgbFormat) || format;
};
var pixelFormatGammaToLinear = (format)=>{
		for (var [key, value] of pixelFormatInfo){
				if (value.srgbFormat === format) {
						return key;
				}
		}
		return format;
};
var requiresManualGamma = (format)=>{
		var info = pixelFormatInfo.get(format);
		return !!((info == null ? void 0 : info.ldr) && !(info == null ? void 0 : info.srgb));
};
var getPixelFormatArrayType = (format)=>{
		switch(format){
				case PIXELFORMAT_R32F:
				case PIXELFORMAT_RGB32F:
				case PIXELFORMAT_RGBA32F:
						return Float32Array;
				case PIXELFORMAT_R32I:
				case PIXELFORMAT_RG32I:
				case PIXELFORMAT_RGBA32I:
						return Int32Array;
				case PIXELFORMAT_R32U:
				case PIXELFORMAT_RG32U:
				case PIXELFORMAT_RGBA32U:
						return Uint32Array;
				case PIXELFORMAT_R16I:
				case PIXELFORMAT_RG16I:
				case PIXELFORMAT_RGBA16I:
						return Int16Array;
				case PIXELFORMAT_RG8:
				case PIXELFORMAT_R16U:
				case PIXELFORMAT_RG16U:
				case PIXELFORMAT_RGBA16U:
				case PIXELFORMAT_RGB565:
				case PIXELFORMAT_RGBA5551:
				case PIXELFORMAT_RGBA4:
				case PIXELFORMAT_R16F:
				case PIXELFORMAT_RG16F:
				case PIXELFORMAT_RGB16F:
				case PIXELFORMAT_RGBA16F:
						return Uint16Array;
				case PIXELFORMAT_R8I:
				case PIXELFORMAT_RG8I:
				case PIXELFORMAT_RGBA8I:
						return Int8Array;
				default:
						return Uint8Array;
		}
};
var PRIMITIVE_POINTS = 0;
var PRIMITIVE_LINES = 1;
var PRIMITIVE_LINELOOP = 2;
var PRIMITIVE_LINESTRIP = 3;
var PRIMITIVE_TRIANGLES = 4;
var PRIMITIVE_TRISTRIP = 5;
var PRIMITIVE_TRIFAN = 6;
var SEMANTIC_POSITION = 'POSITION';
var SEMANTIC_NORMAL = 'NORMAL';
var SEMANTIC_TANGENT = 'TANGENT';
var SEMANTIC_BLENDWEIGHT = 'BLENDWEIGHT';
var SEMANTIC_BLENDINDICES = 'BLENDINDICES';
var SEMANTIC_COLOR = 'COLOR';
var SEMANTIC_TEXCOORD = 'TEXCOORD';
var SEMANTIC_TEXCOORD0 = 'TEXCOORD0';
var SEMANTIC_TEXCOORD1 = 'TEXCOORD1';
var SEMANTIC_TEXCOORD2 = 'TEXCOORD2';
var SEMANTIC_TEXCOORD3 = 'TEXCOORD3';
var SEMANTIC_TEXCOORD4 = 'TEXCOORD4';
var SEMANTIC_TEXCOORD5 = 'TEXCOORD5';
var SEMANTIC_TEXCOORD6 = 'TEXCOORD6';
var SEMANTIC_TEXCOORD7 = 'TEXCOORD7';
var SEMANTIC_ATTR0 = 'ATTR0';
var SEMANTIC_ATTR1 = 'ATTR1';
var SEMANTIC_ATTR2 = 'ATTR2';
var SEMANTIC_ATTR3 = 'ATTR3';
var SEMANTIC_ATTR4 = 'ATTR4';
var SEMANTIC_ATTR5 = 'ATTR5';
var SEMANTIC_ATTR6 = 'ATTR6';
var SEMANTIC_ATTR7 = 'ATTR7';
var SEMANTIC_ATTR8 = 'ATTR8';
var SEMANTIC_ATTR9 = 'ATTR9';
var SEMANTIC_ATTR10 = 'ATTR10';
var SEMANTIC_ATTR11 = 'ATTR11';
var SEMANTIC_ATTR12 = 'ATTR12';
var SEMANTIC_ATTR13 = 'ATTR13';
var SEMANTIC_ATTR14 = 'ATTR14';
var SEMANTIC_ATTR15 = 'ATTR15';
var SHADERTAG_MATERIAL = 1;
var STENCILOP_KEEP = 0;
var STENCILOP_REPLACE = 2;
var STENCILOP_INCREMENT = 3;
var STENCILOP_DECREMENT = 5;
var TEXTURELOCK_NONE = 0;
var TEXTURELOCK_READ = 1;
var TEXTURELOCK_WRITE = 2;
var TEXTURETYPE_DEFAULT = 'default';
var TEXTURETYPE_RGBM = 'rgbm';
var TEXTURETYPE_RGBE = 'rgbe';
var TEXTURETYPE_RGBP = 'rgbp';
var TEXTURETYPE_SWIZZLEGGGR = 'swizzleGGGR';
var TEXTUREDIMENSION_2D = '2d';
var SAMPLETYPE_FLOAT = 0;
var SAMPLETYPE_UNFILTERABLE_FLOAT = 1;
var SAMPLETYPE_DEPTH = 2;
var TEXTUREPROJECTION_NONE = 'none';
var TEXTUREPROJECTION_CUBE = 'cube';
var TEXTUREPROJECTION_EQUIRECT = 'equirect';
var TEXTUREPROJECTION_OCTAHEDRAL = 'octahedral';
var SHADERLANGUAGE_GLSL = 'glsl';
var SHADERLANGUAGE_WGSL = 'wgsl';
var TYPE_INT8 = 0;
var TYPE_UINT8 = 1;
var TYPE_INT16 = 2;
var TYPE_UINT16 = 3;
var TYPE_INT32 = 4;
var TYPE_UINT32 = 5;
var TYPE_FLOAT32 = 6;
var UNIFORMTYPE_BOOL = 0;
var UNIFORMTYPE_INT = 1;
var UNIFORMTYPE_FLOAT = 2;
var UNIFORMTYPE_VEC2 = 3;
var UNIFORMTYPE_VEC3 = 4;
var UNIFORMTYPE_VEC4 = 5;
var UNIFORMTYPE_IVEC2 = 6;
var UNIFORMTYPE_IVEC3 = 7;
var UNIFORMTYPE_IVEC4 = 8;
var UNIFORMTYPE_BVEC2 = 9;
var UNIFORMTYPE_BVEC3 = 10;
var UNIFORMTYPE_BVEC4 = 11;
var UNIFORMTYPE_MAT2 = 12;
var UNIFORMTYPE_MAT3 = 13;
var UNIFORMTYPE_MAT4 = 14;
var UNIFORMTYPE_TEXTURE2D = 15;
var UNIFORMTYPE_TEXTURECUBE = 16;
var UNIFORMTYPE_FLOATARRAY = 17;
var UNIFORMTYPE_TEXTURE2D_SHADOW = 18;
var UNIFORMTYPE_TEXTURECUBE_SHADOW = 19;
var UNIFORMTYPE_TEXTURE3D = 20;
var UNIFORMTYPE_VEC2ARRAY = 21;
var UNIFORMTYPE_VEC3ARRAY = 22;
var UNIFORMTYPE_VEC4ARRAY = 23;
var UNIFORMTYPE_MAT4ARRAY = 24;
var UNIFORMTYPE_TEXTURE2D_ARRAY = 25;
var UNIFORMTYPE_UINT = 26;
var UNIFORMTYPE_UVEC2 = 27;
var UNIFORMTYPE_UVEC3 = 28;
var UNIFORMTYPE_UVEC4 = 29;
var UNIFORMTYPE_INTARRAY = 30;
var UNIFORMTYPE_UINTARRAY = 31;
var UNIFORMTYPE_BOOLARRAY = 32;
var UNIFORMTYPE_IVEC2ARRAY = 33;
var UNIFORMTYPE_UVEC2ARRAY = 34;
var UNIFORMTYPE_BVEC2ARRAY = 35;
var UNIFORMTYPE_IVEC3ARRAY = 36;
var UNIFORMTYPE_UVEC3ARRAY = 37;
var UNIFORMTYPE_BVEC3ARRAY = 38;
var UNIFORMTYPE_IVEC4ARRAY = 39;
var UNIFORMTYPE_UVEC4ARRAY = 40;
var UNIFORMTYPE_BVEC4ARRAY = 41;
var UNIFORMTYPE_ITEXTURE2D = 42;
var UNIFORMTYPE_UTEXTURE2D = 43;
var UNIFORMTYPE_ITEXTURECUBE = 44;
var UNIFORMTYPE_UTEXTURECUBE = 45;
var UNIFORMTYPE_ITEXTURE3D = 46;
var UNIFORMTYPE_UTEXTURE3D = 47;
var UNIFORMTYPE_ITEXTURE2D_ARRAY = 48;
var UNIFORMTYPE_UTEXTURE2D_ARRAY = 49;
var uniformTypeToNameWGSL = [
		[
				'bool'
		],
		[
				'i32'
		],
		[
				'f32'
		],
		[
				'vec2f',
				'vec2<f32>'
		],
		[
				'vec3f',
				'vec3<f32>'
		],
		[
				'vec4f',
				'vec4<f32>'
		],
		[
				'vec2i',
				'vec2<i32>'
		],
		[
				'vec3i',
				'vec3<i32>'
		],
		[
				'vec4i',
				'vec4<i32>'
		],
		[
				'vec2<bool>'
		],
		[
				'vec3<bool>'
		],
		[
				'vec4<bool>'
		],
		[
				'mat2x2f',
				'mat2x2<f32>'
		],
		[
				'mat3x3f',
				'mat3x3<f32>'
		],
		[
				'mat4x4f',
				'mat4x4<f32>'
		],
		[
				'texture_2d<f32>'
		],
		[
				'texture_cube<f32>'
		],
		[
				'array<f32>'
		],
		[
				'texture_depth_2d'
		],
		[
				'texture_depth_cube'
		],
		[
				'texture_3d<f32>'
		],
		[
				'array<vec2<f32>>'
		],
		[
				'array<vec3<f32>>'
		],
		[
				'array<vec4<f32>>'
		],
		[
				'array<mat4x4<f32>>'
		],
		[
				'texture_2d_array<f32>'
		],
		[
				'u32'
		],
		[
				'vec2u',
				'vec2<u32>'
		],
		[
				'vec3u',
				'vec3<u32>'
		],
		[
				'vec4u',
				'vec4<u32>'
		],
		[
				'array<i32>'
		],
		[
				'array<u32>'
		],
		[
				'array<bool>'
		],
		[
				'array<vec2i>',
				'array<vec2<i32>>'
		],
		[
				'array<vec2u>',
				'array<vec2<u32>>'
		],
		[
				'array<vec2b>',
				'array<vec2<bool>>'
		],
		[
				'array<vec3i>',
				'array<vec3<i32>>'
		],
		[
				'array<vec3u>',
				'array<vec3<u32>>'
		],
		[
				'array<vec3b>',
				'array<vec3<bool>>'
		],
		[
				'array<vec4i>',
				'array<vec4<i32>>'
		],
		[
				'array<vec4u>',
				'array<vec4<u32>>'
		],
		[
				'array<vec4b>',
				'array<vec4<bool>>'
		],
		[
				'texture_2d<i32>'
		],
		[
				'texture_2d<u32>'
		],
		[
				'texture_cube<i32>'
		],
		[
				'texture_cube<u32>'
		],
		[
				'texture_3d<i32>'
		],
		[
				'texture_3d<u32>'
		],
		[
				'texture_2d_array<i32>'
		],
		[
				'texture_2d_array<u32>'
		]
];
var uniformTypeToNameMapWGSL = new Map();
uniformTypeToNameWGSL.forEach((names, index)=>{
		names.forEach((name)=>uniformTypeToNameMapWGSL.set(name, index));
});
var DEVICETYPE_WEBGL2 = 'webgl2';
var SHADERSTAGE_VERTEX = 1;
var SHADERSTAGE_FRAGMENT = 2;
var SHADERSTAGE_COMPUTE = 4;
var DISPLAYFORMAT_LDR = 'ldr';
var TEXPROPERTY_MIN_FILTER = 1;
var TEXPROPERTY_MAG_FILTER = 2;
var TEXPROPERTY_ADDRESS_U = 4;
var TEXPROPERTY_ADDRESS_V = 8;
var TEXPROPERTY_ADDRESS_W = 16;
var TEXPROPERTY_COMPARE_ON_READ = 32;
var TEXPROPERTY_COMPARE_FUNC = 64;
var TEXPROPERTY_ANISOTROPY = 128;
var TEXPROPERTY_ALL = 255;
var BINDGROUP_VIEW = 0;
var BINDGROUP_MESH = 1;
var BINDGROUP_MESH_UB = 2;
var UNIFORM_BUFFER_DEFAULT_SLOT_NAME = 'default';
var typedArrayTypes = [
		Int8Array,
		Uint8Array,
		Int16Array,
		Uint16Array,
		Int32Array,
		Uint32Array,
		Float32Array,
		Uint16Array
];
var typedArrayTypesByteSize = [
		1,
		1,
		2,
		2,
		4,
		4,
		4,
		2
];
var typedArrayIndexFormats = [
		Uint8Array,
		Uint16Array,
		Uint32Array
];
var typedArrayIndexFormatsByteSize = [
		1,
		2,
		4
];
var semanticToLocation = {};
semanticToLocation[SEMANTIC_POSITION] = 0;
semanticToLocation[SEMANTIC_NORMAL] = 1;
semanticToLocation[SEMANTIC_BLENDWEIGHT] = 2;
semanticToLocation[SEMANTIC_BLENDINDICES] = 3;
semanticToLocation[SEMANTIC_COLOR] = 4;
semanticToLocation[SEMANTIC_TEXCOORD0] = 5;
semanticToLocation[SEMANTIC_TEXCOORD1] = 6;
semanticToLocation[SEMANTIC_TEXCOORD2] = 7;
semanticToLocation[SEMANTIC_TEXCOORD3] = 8;
semanticToLocation[SEMANTIC_TEXCOORD4] = 9;
semanticToLocation[SEMANTIC_TEXCOORD5] = 10;
semanticToLocation[SEMANTIC_TEXCOORD6] = 11;
semanticToLocation[SEMANTIC_TEXCOORD7] = 12;
semanticToLocation[SEMANTIC_TANGENT] = 13;
semanticToLocation[SEMANTIC_ATTR0] = 0;
semanticToLocation[SEMANTIC_ATTR1] = 1;
semanticToLocation[SEMANTIC_ATTR2] = 2;
semanticToLocation[SEMANTIC_ATTR3] = 3;
semanticToLocation[SEMANTIC_ATTR4] = 4;
semanticToLocation[SEMANTIC_ATTR5] = 5;
semanticToLocation[SEMANTIC_ATTR6] = 6;
semanticToLocation[SEMANTIC_ATTR7] = 7;
semanticToLocation[SEMANTIC_ATTR8] = 8;
semanticToLocation[SEMANTIC_ATTR9] = 9;
semanticToLocation[SEMANTIC_ATTR10] = 10;
semanticToLocation[SEMANTIC_ATTR11] = 11;
semanticToLocation[SEMANTIC_ATTR12] = 12;
semanticToLocation[SEMANTIC_ATTR13] = 13;
semanticToLocation[SEMANTIC_ATTR14] = 14;
semanticToLocation[SEMANTIC_ATTR15] = 15;
var CHUNKAPI_1_65 = '1.65';

var id$a = 0;
class BindBaseFormat {
		constructor(name, visibility){
				this.slot = -1;
				this.scopeId = null;
				this.name = name;
				this.visibility = visibility;
		}
}
class BindUniformBufferFormat extends BindBaseFormat {
}
class BindStorageBufferFormat extends BindBaseFormat {
		constructor(name, visibility, readOnly = false){
				super(name, visibility), this.format = '';
				this.readOnly = readOnly;
		}
}
class BindTextureFormat extends BindBaseFormat {
		constructor(name, visibility, textureDimension = TEXTUREDIMENSION_2D, sampleType = SAMPLETYPE_FLOAT, hasSampler = true, samplerName = null){
				super(name, visibility);
				this.textureDimension = textureDimension;
				this.sampleType = sampleType;
				this.hasSampler = hasSampler;
				this.samplerName = samplerName != null ? samplerName : "" + name + "_sampler";
		}
}
class BindStorageTextureFormat extends BindBaseFormat {
		constructor(name, format = PIXELFORMAT_RGBA8, textureDimension = TEXTUREDIMENSION_2D, write = true, read = false){
				super(name, SHADERSTAGE_COMPUTE);
				this.format = format;
				this.textureDimension = textureDimension;
				this.write = write;
				this.read = read;
		}
}
class BindGroupFormat {
		destroy() {
				this.impl.destroy();
		}
		getTexture(name) {
				var index = this.textureFormatsMap.get(name);
				if (index !== undefined) {
						return this.textureFormats[index];
				}
				return null;
		}
		getStorageTexture(name) {
				var index = this.storageTextureFormatsMap.get(name);
				if (index !== undefined) {
						return this.storageTextureFormats[index];
				}
				return null;
		}
		loseContext() {}
		constructor(graphicsDevice, formats){
				this.uniformBufferFormats = [];
				this.textureFormats = [];
				this.storageTextureFormats = [];
				this.storageBufferFormats = [];
				this.id = id$a++;
				var slot = 0;
				formats.forEach((format)=>{
						format.slot = slot++;
						if (format instanceof BindTextureFormat && format.hasSampler) {
								slot++;
						}
						if (format instanceof BindUniformBufferFormat) {
								this.uniformBufferFormats.push(format);
						} else if (format instanceof BindTextureFormat) {
								this.textureFormats.push(format);
						} else if (format instanceof BindStorageTextureFormat) {
								this.storageTextureFormats.push(format);
						} else if (format instanceof BindStorageBufferFormat) {
								this.storageBufferFormats.push(format);
						} else ;
				});
				this.device = graphicsDevice;
				var scope = graphicsDevice.scope;
				this.bufferFormatsMap = new Map();
				this.uniformBufferFormats.forEach((bf, i)=>this.bufferFormatsMap.set(bf.name, i));
				this.textureFormatsMap = new Map();
				this.textureFormats.forEach((tf, i)=>{
						this.textureFormatsMap.set(tf.name, i);
						tf.scopeId = scope.resolve(tf.name);
				});
				this.storageTextureFormatsMap = new Map();
				this.storageTextureFormats.forEach((tf, i)=>{
						this.storageTextureFormatsMap.set(tf.name, i);
						tf.scopeId = scope.resolve(tf.name);
				});
				this.storageBufferFormatsMap = new Map();
				this.storageBufferFormats.forEach((bf, i)=>{
						this.storageBufferFormatsMap.set(bf.name, i);
						bf.scopeId = scope.resolve(bf.name);
				});
				this.impl = graphicsDevice.createBindGroupFormatImpl(this);
		}
}

class DeviceCache {
		get(device, onCreate) {
				if (!this._cache.has(device)) {
						this._cache.set(device, onCreate());
						device.on('destroy', ()=>{
								this.remove(device);
						});
						device.on('devicelost', ()=>{
								var _this__cache_get_loseContext, _this__cache_get;
								(_this__cache_get = this._cache.get(device)) == null ? void 0 : (_this__cache_get_loseContext = _this__cache_get.loseContext) == null ? void 0 : _this__cache_get_loseContext.call(_this__cache_get, device);
						});
				}
				return this._cache.get(device);
		}
		remove(device) {
				var _this__cache_get_destroy, _this__cache_get;
				(_this__cache_get = this._cache.get(device)) == null ? void 0 : (_this__cache_get_destroy = _this__cache_get.destroy) == null ? void 0 : _this__cache_get_destroy.call(_this__cache_get, device);
				this._cache.delete(device);
		}
		constructor(){
				this._cache = new Map();
		}
}

class TextureUtils {
		static calcLevelDimension(dimension, mipLevel) {
				return Math.max(dimension >> mipLevel, 1);
		}
		static calcMipLevelsCount(width, height, depth) {
				if (depth === void 0) depth = 1;
				return 1 + Math.floor(Math.log2(Math.max(width, height, depth)));
		}
		static calcLevelGpuSize(width, height, depth, format) {
				var _pixelFormatInfo_get;
				var formatInfo = pixelFormatInfo.get(format);
				var _pixelFormatInfo_get_size;
				var pixelSize = (_pixelFormatInfo_get_size = (_pixelFormatInfo_get = pixelFormatInfo.get(format)) == null ? void 0 : _pixelFormatInfo_get.size) != null ? _pixelFormatInfo_get_size : 0;
				if (pixelSize > 0) {
						return width * height * depth * pixelSize;
				}
				var _formatInfo_blockSize;
				var blockSize = (_formatInfo_blockSize = formatInfo.blockSize) != null ? _formatInfo_blockSize : 0;
				var blockWidth = Math.floor((width + 3) / 4);
				var blockHeight = Math.floor((height + 3) / 4);
				var blockDepth = Math.floor((depth + 3) / 4);
				if (format === PIXELFORMAT_PVRTC_2BPP_RGB_1 || format === PIXELFORMAT_PVRTC_2BPP_RGBA_1) {
						blockWidth = Math.max(Math.floor(blockWidth / 2), 1);
				}
				return blockWidth * blockHeight * blockDepth * blockSize;
		}
		static calcGpuSize(width, height, depth, format, mipmaps, cubemap) {
				var result = 0;
				while(1){
						result += TextureUtils.calcLevelGpuSize(width, height, depth, format);
						if (!mipmaps || width === 1 && height === 1 && depth === 1) {
								break;
						}
						width = Math.max(width >> 1, 1);
						height = Math.max(height >> 1, 1);
						depth = Math.max(depth >> 1, 1);
				}
				return result * (cubemap ? 6 : 1);
		}
}

var id$9 = 0;
class Texture {
		destroy() {
				var device = this.device;
				if (device) {
						var idx = device.textures.indexOf(this);
						if (idx !== -1) {
								device.textures.splice(idx, 1);
						}
						device.scope.removeValue(this);
						this.impl.destroy(device);
						this.adjustVramSizeTracking(device._vram, -this._gpuSize);
						this._levels = null;
						this.device = null;
				}
		}
		recreateImpl(upload) {
				if (upload === void 0) upload = true;
				var _this_impl;
				var { device } = this;
				(_this_impl = this.impl) == null ? void 0 : _this_impl.destroy(device);
				this.impl = null;
				this.impl = device.createTextureImpl(this);
				this.dirtyAll();
				if (upload) {
						this.upload();
				}
		}
		resize(width, height, depth) {
				if (depth === void 0) depth = 1;
				var device = this.device;
				this.adjustVramSizeTracking(device._vram, -this._gpuSize);
				this.impl.destroy(device);
				this._width = Math.floor(width);
				this._height = Math.floor(height);
				this._depth = Math.floor(depth);
				this._updateNumLevel();
				this.impl = device.createTextureImpl(this);
				this.dirtyAll();
		}
		loseContext() {
				this.impl.loseContext();
				this.dirtyAll();
		}
		adjustVramSizeTracking(vram, size) {
				vram.tex += size;
		}
		propertyChanged(flag) {
				this.impl.propertyChanged(flag);
				this.renderVersionDirty = this.device.renderVersion;
		}
		_updateNumLevel() {
				var maxLevels = this.mipmaps ? TextureUtils.calcMipLevelsCount(this.width, this.height) : 1;
				var requestedLevels = this._numLevelsRequested;
				this._numLevels = Math.min(requestedLevels != null ? requestedLevels : maxLevels, maxLevels);
				this._mipmaps = this._numLevels > 1;
		}
		get lockedMode() {
				return this._lockedMode;
		}
		set minFilter(v) {
				if (this._minFilter !== v) {
						if (isIntegerPixelFormat(this._format)) ; else {
								this._minFilter = v;
								this.propertyChanged(TEXPROPERTY_MIN_FILTER);
						}
				}
		}
		get minFilter() {
				return this._minFilter;
		}
		set magFilter(v) {
				if (this._magFilter !== v) {
						if (isIntegerPixelFormat(this._format)) ; else {
								this._magFilter = v;
								this.propertyChanged(TEXPROPERTY_MAG_FILTER);
						}
				}
		}
		get magFilter() {
				return this._magFilter;
		}
		set addressU(v) {
				if (this._addressU !== v) {
						this._addressU = v;
						this.propertyChanged(TEXPROPERTY_ADDRESS_U);
				}
		}
		get addressU() {
				return this._addressU;
		}
		set addressV(v) {
				if (this._addressV !== v) {
						this._addressV = v;
						this.propertyChanged(TEXPROPERTY_ADDRESS_V);
				}
		}
		get addressV() {
				return this._addressV;
		}
		set addressW(addressW) {
				if (!this._volume) {
						return;
				}
				if (addressW !== this._addressW) {
						this._addressW = addressW;
						this.propertyChanged(TEXPROPERTY_ADDRESS_W);
				}
		}
		get addressW() {
				return this._addressW;
		}
		set compareOnRead(v) {
				if (this._compareOnRead !== v) {
						this._compareOnRead = v;
						this.propertyChanged(TEXPROPERTY_COMPARE_ON_READ);
				}
		}
		get compareOnRead() {
				return this._compareOnRead;
		}
		set compareFunc(v) {
				if (this._compareFunc !== v) {
						this._compareFunc = v;
						this.propertyChanged(TEXPROPERTY_COMPARE_FUNC);
				}
		}
		get compareFunc() {
				return this._compareFunc;
		}
		set anisotropy(v) {
				if (this._anisotropy !== v) {
						this._anisotropy = v;
						this.propertyChanged(TEXPROPERTY_ANISOTROPY);
				}
		}
		get anisotropy() {
				return this._anisotropy;
		}
		set mipmaps(v) {
				if (this._mipmaps !== v) {
						if (this.device.isWebGPU) ; else if (isIntegerPixelFormat(this._format)) ; else {
								this._mipmaps = v;
						}
						if (v) this._needsMipmapsUpload = true;
				}
		}
		get mipmaps() {
				return this._mipmaps;
		}
		get numLevels() {
				return this._numLevels;
		}
		get storage() {
				return this._storage;
		}
		get width() {
				return this._width;
		}
		get height() {
				return this._height;
		}
		get depth() {
				return this._depth;
		}
		get format() {
				return this._format;
		}
		get cubemap() {
				return this._cubemap;
		}
		get gpuSize() {
				var mips = this.pot && this._mipmaps && !(this._compressed && this._levels.length === 1);
				return TextureUtils.calcGpuSize(this._width, this._height, this._depth, this._format, mips, this._cubemap);
		}
		get array() {
				return this._arrayLength > 0;
		}
		get arrayLength() {
				return this._arrayLength;
		}
		get volume() {
				return this._volume;
		}
		set srgb(value) {
				var currentSrgb = isSrgbPixelFormat(this.format);
				if (value !== currentSrgb) {
						if (value) {
								var srgbFormat = pixelFormatLinearToGamma(this.format);
								if (this._format !== srgbFormat) {
										this._format = srgbFormat;
										this.recreateImpl();
										this.device._shadersDirty = true;
								}
						} else {
								var linearFormat = pixelFormatGammaToLinear(this.format);
								if (this._format !== linearFormat) {
										this._format = linearFormat;
										this.recreateImpl();
										this.device._shadersDirty = true;
								}
						}
				}
		}
		get srgb() {
				return isSrgbPixelFormat(this.format);
		}
		set flipY(flipY) {
				if (this._flipY !== flipY) {
						this._flipY = flipY;
						this._needsUpload = true;
				}
		}
		get flipY() {
				return this._flipY;
		}
		set premultiplyAlpha(premultiplyAlpha) {
				if (this._premultiplyAlpha !== premultiplyAlpha) {
						this._premultiplyAlpha = premultiplyAlpha;
						this._needsUpload = true;
				}
		}
		get premultiplyAlpha() {
				return this._premultiplyAlpha;
		}
		get pot() {
				return math.powerOfTwo(this._width) && math.powerOfTwo(this._height);
		}
		get encoding() {
				switch(this.type){
						case TEXTURETYPE_RGBM:
								return 'rgbm';
						case TEXTURETYPE_RGBE:
								return 'rgbe';
						case TEXTURETYPE_RGBP:
								return 'rgbp';
				}
				return requiresManualGamma(this.format) ? 'srgb' : 'linear';
		}
		dirtyAll() {
				this._levelsUpdated = this._cubemap ? [
						[
								true,
								true,
								true,
								true,
								true,
								true
						]
				] : [
						true
				];
				this._needsUpload = true;
				this._needsMipmapsUpload = this._mipmaps;
				this._mipmapsUploaded = false;
				this.propertyChanged(TEXPROPERTY_ALL);
		}
		lock(options) {
				if (options === void 0) options = {};
				var _options, _options1, _options2;
				var _level;
				(_level = (_options = options).level) != null ? _level : _options.level = 0;
				var _face;
				(_face = (_options1 = options).face) != null ? _face : _options1.face = 0;
				var _mode;
				(_mode = (_options2 = options).mode) != null ? _mode : _options2.mode = TEXTURELOCK_WRITE;
				this._lockedMode = options.mode;
				this._lockedLevel = options.level;
				var levels = this.cubemap ? this._levels[options.face] : this._levels;
				if (levels[options.level] === null) {
						var width = Math.max(1, this._width >> options.level);
						var height = Math.max(1, this._height >> options.level);
						var depth = Math.max(1, this._depth >> options.level);
						var data = new ArrayBuffer(TextureUtils.calcLevelGpuSize(width, height, depth, this._format));
						levels[options.level] = new (getPixelFormatArrayType(this._format))(data);
				}
				return levels[options.level];
		}
		setSource(source, mipLevel) {
				if (mipLevel === void 0) mipLevel = 0;
				var invalid = false;
				var width, height;
				if (this._cubemap) {
						if (source[0]) {
								width = source[0].width || 0;
								height = source[0].height || 0;
								for(var i = 0; i < 6; i++){
										var face = source[i];
										if (!face || face.width !== width || face.height !== height || !this.device._isBrowserInterface(face)) {
												invalid = true;
												break;
										}
								}
						} else {
								invalid = true;
						}
						if (!invalid) {
								for(var i1 = 0; i1 < 6; i1++){
										if (this._levels[mipLevel][i1] !== source[i1]) {
												this._levelsUpdated[mipLevel][i1] = true;
										}
								}
						}
				} else {
						if (!this.device._isBrowserInterface(source)) {
								invalid = true;
						}
						if (!invalid) {
								if (source !== this._levels[mipLevel]) {
										this._levelsUpdated[mipLevel] = true;
								}
								if (source instanceof HTMLVideoElement) {
										width = source.videoWidth;
										height = source.videoHeight;
								} else {
										width = source.width;
										height = source.height;
								}
						}
				}
				if (invalid) {
						this._width = 4;
						this._height = 4;
						if (this._cubemap) {
								for(var i2 = 0; i2 < 6; i2++){
										this._levels[mipLevel][i2] = null;
										this._levelsUpdated[mipLevel][i2] = true;
								}
						} else {
								this._levels[mipLevel] = null;
								this._levelsUpdated[mipLevel] = true;
						}
				} else {
						if (mipLevel === 0) {
								this._width = width;
								this._height = height;
						}
						this._levels[mipLevel] = source;
				}
				if (this._invalid !== invalid || !invalid) {
						this._invalid = invalid;
						this.upload();
				}
		}
		getSource(mipLevel) {
				if (mipLevel === void 0) mipLevel = 0;
				return this._levels[mipLevel];
		}
		unlock() {
				if (this._lockedMode === TEXTURELOCK_NONE) ;
				if (this._lockedMode === TEXTURELOCK_WRITE) {
						this.upload();
				}
				this._lockedLevel = -1;
				this._lockedMode = TEXTURELOCK_NONE;
		}
		upload() {
				this._needsUpload = true;
				this._needsMipmapsUpload = this._mipmaps;
				this.impl.uploadImmediate == null ? void 0 : this.impl.uploadImmediate.call(this.impl, this.device, this);
		}
		read(x, y, width, height, options) {
				if (options === void 0) options = {};
				return this.impl.read == null ? void 0 : this.impl.read.call(this.impl, x, y, width, height, options);
		}
		constructor(graphicsDevice, options = {}){
				this._gpuSize = 0;
				this.id = id$9++;
				this._invalid = false;
				this._lockedLevel = -1;
				this._lockedMode = TEXTURELOCK_NONE;
				this.renderVersionDirty = 0;
				this._storage = false;
				this._numLevels = 0;
				this.device = graphicsDevice;
				var _options_name;
				this.name = (_options_name = options.name) != null ? _options_name : '';
				var _options_width;
				this._width = Math.floor((_options_width = options.width) != null ? _options_width : 4);
				var _options_height;
				this._height = Math.floor((_options_height = options.height) != null ? _options_height : 4);
				var _options_format;
				this._format = (_options_format = options.format) != null ? _options_format : PIXELFORMAT_RGBA8;
				this._compressed = isCompressedPixelFormat(this._format);
				this._integerFormat = isIntegerPixelFormat(this._format);
				if (this._integerFormat) {
						options.minFilter = FILTER_NEAREST;
						options.magFilter = FILTER_NEAREST;
				}
				var _options_volume;
				this._volume = (_options_volume = options.volume) != null ? _options_volume : false;
				var _options_depth;
				this._depth = Math.floor((_options_depth = options.depth) != null ? _options_depth : 1);
				var _options_arrayLength;
				this._arrayLength = Math.floor((_options_arrayLength = options.arrayLength) != null ? _options_arrayLength : 0);
				var _options_storage;
				this._storage = (_options_storage = options.storage) != null ? _options_storage : false;
				var _options_cubemap;
				this._cubemap = (_options_cubemap = options.cubemap) != null ? _options_cubemap : false;
				var _options_flipY;
				this._flipY = (_options_flipY = options.flipY) != null ? _options_flipY : false;
				var _options_premultiplyAlpha;
				this._premultiplyAlpha = (_options_premultiplyAlpha = options.premultiplyAlpha) != null ? _options_premultiplyAlpha : false;
				var _options_mipmaps;
				this._mipmaps = (_options_mipmaps = options.mipmaps) != null ? _options_mipmaps : true;
				this._numLevelsRequested = options.numLevels;
				if (options.numLevels !== undefined) {
						this._numLevels = options.numLevels;
				}
				this._updateNumLevel();
				var _options_minFilter;
				this._minFilter = (_options_minFilter = options.minFilter) != null ? _options_minFilter : FILTER_LINEAR_MIPMAP_LINEAR;
				var _options_magFilter;
				this._magFilter = (_options_magFilter = options.magFilter) != null ? _options_magFilter : FILTER_LINEAR;
				var _options_anisotropy;
				this._anisotropy = (_options_anisotropy = options.anisotropy) != null ? _options_anisotropy : 1;
				var _options_addressU;
				this._addressU = (_options_addressU = options.addressU) != null ? _options_addressU : ADDRESS_REPEAT;
				var _options_addressV;
				this._addressV = (_options_addressV = options.addressV) != null ? _options_addressV : ADDRESS_REPEAT;
				var _options_addressW;
				this._addressW = (_options_addressW = options.addressW) != null ? _options_addressW : ADDRESS_REPEAT;
				var _options_compareOnRead;
				this._compareOnRead = (_options_compareOnRead = options.compareOnRead) != null ? _options_compareOnRead : false;
				var _options_compareFunc;
				this._compareFunc = (_options_compareFunc = options.compareFunc) != null ? _options_compareFunc : FUNC_LESS;
				this.type = options.hasOwnProperty('type') ? options.type : TEXTURETYPE_DEFAULT;
				this.projection = TEXTUREPROJECTION_NONE;
				if (this._cubemap) {
						this.projection = TEXTUREPROJECTION_CUBE;
				} else if (options.projection && options.projection !== TEXTUREPROJECTION_CUBE) {
						this.projection = options.projection;
				}
				this._levels = options.levels;
				var upload = !!options.levels;
				if (!this._levels) {
						this._levels = this._cubemap ? [
								[
										null,
										null,
										null,
										null,
										null,
										null
								]
						] : [
								null
						];
				}
				this.recreateImpl(upload);
				graphicsDevice.textures.push(this);
		}
}

var textureData = {
		white: [
				255,
				255,
				255,
				255
		],
		gray: [
				128,
				128,
				128,
				255
		],
		black: [
				0,
				0,
				0,
				255
		],
		normal: [
				128,
				128,
				255,
				255
		],
		pink: [
				255,
				128,
				255,
				255
		]
};
class BuiltInTextures {
		destroy() {
				this.map.forEach((texture)=>{
						texture.destroy();
				});
		}
		constructor(){
				this.map = new Map();
		}
}
var deviceCache$3 = new DeviceCache();
var getBuiltInTexture = (device, name)=>{
		var cache = deviceCache$3.get(device, ()=>{
				return new BuiltInTextures();
		});
		if (!cache.map.has(name)) {
				var texture = new Texture(device, {
						name: "built-in-texture-" + name,
						width: 1,
						height: 1,
						format: PIXELFORMAT_RGBA8
				});
				var pixels = texture.lock();
				var data = textureData[name];
				pixels.set(data);
				texture.unlock();
				cache.map.set(name, texture);
		}
		return cache.map.get(name);
};

var id$8 = 0;
class DynamicBindGroup {
		constructor(){
				this.offsets = [];
		}
}
class BindGroup {
		destroy() {
				this.impl.destroy();
				this.impl = null;
				this.format = null;
				this.defaultUniformBuffer = null;
		}
		setUniformBuffer(name, uniformBuffer) {
				var index = this.format.bufferFormatsMap.get(name);
				if (this.uniformBuffers[index] !== uniformBuffer) {
						this.uniformBuffers[index] = uniformBuffer;
						this.dirty = true;
				}
		}
		setStorageBuffer(name, storageBuffer) {
				var index = this.format.storageBufferFormatsMap.get(name);
				if (this.storageBuffers[index] !== storageBuffer) {
						this.storageBuffers[index] = storageBuffer;
						this.dirty = true;
				}
		}
		setTexture(name, texture) {
				var index = this.format.textureFormatsMap.get(name);
				if (this.textures[index] !== texture) {
						this.textures[index] = texture;
						this.dirty = true;
				} else if (this.renderVersionUpdated < texture.renderVersionDirty) {
						this.dirty = true;
				}
		}
		setStorageTexture(name, texture) {
				var index = this.format.storageTextureFormatsMap.get(name);
				if (this.storageTextures[index] !== texture) {
						this.storageTextures[index] = texture;
						this.dirty = true;
				} else if (this.renderVersionUpdated < texture.renderVersionDirty) {
						this.dirty = true;
				}
		}
		updateUniformBuffers() {
				for(var i = 0; i < this.uniformBuffers.length; i++){
						this.uniformBuffers[i].update();
				}
		}
		update() {
				var { textureFormats, storageTextureFormats, storageBufferFormats } = this.format;
				for(var i = 0; i < textureFormats.length; i++){
						var textureFormat = textureFormats[i];
						var value = textureFormat.scopeId.value;
						if (!value) {
								if (textureFormat.name === 'uSceneDepthMap') {
										value = getBuiltInTexture(this.device, 'white');
								}
								if (textureFormat.name === 'uSceneColorMap') {
										value = getBuiltInTexture(this.device, 'pink');
								}
								if (!value) {
										value = getBuiltInTexture(this.device, 'pink');
								}
						}
						this.setTexture(textureFormat.name, value);
				}
				for(var i1 = 0; i1 < storageTextureFormats.length; i1++){
						var storageTextureFormat = storageTextureFormats[i1];
						var value1 = storageTextureFormat.scopeId.value;
						this.setStorageTexture(storageTextureFormat.name, value1);
				}
				for(var i2 = 0; i2 < storageBufferFormats.length; i2++){
						var storageBufferFormat = storageBufferFormats[i2];
						var value2 = storageBufferFormat.scopeId.value;
						this.setStorageBuffer(storageBufferFormat.name, value2);
				}
				this.uniformBufferOffsets.length = this.uniformBuffers.length;
				for(var i3 = 0; i3 < this.uniformBuffers.length; i3++){
						var uniformBuffer = this.uniformBuffers[i3];
						this.uniformBufferOffsets[i3] = uniformBuffer.offset;
						if (this.renderVersionUpdated < uniformBuffer.renderVersionDirty) {
								this.dirty = true;
						}
				}
				if (this.dirty) {
						this.dirty = false;
						this.renderVersionUpdated = this.device.renderVersion;
						this.impl.update(this);
				}
		}
		constructor(graphicsDevice, format, defaultUniformBuffer){
				this.renderVersionUpdated = -1;
				this.uniformBufferOffsets = [];
				this.id = id$8++;
				this.device = graphicsDevice;
				this.format = format;
				this.dirty = true;
				this.impl = graphicsDevice.createBindGroupImpl(this);
				this.textures = [];
				this.storageTextures = [];
				this.storageBuffers = [];
				this.uniformBuffers = [];
				this.defaultUniformBuffer = defaultUniformBuffer;
				if (defaultUniformBuffer) {
						this.setUniformBuffer(UNIFORM_BUFFER_DEFAULT_SLOT_NAME, defaultUniformBuffer);
				}
		}
}

var BitPacking = {
		set (storage, value, shift, mask) {
				if (mask === void 0) mask = 1;
				var data = storage & ~(mask << shift);
				return data | value << shift;
		},
		get (storage, shift, mask) {
				if (mask === void 0) mask = 1;
				return storage >> shift & mask;
		},
		all (storage, shift, mask) {
				if (mask === void 0) mask = 1;
				var shifted = mask << shift;
				return (storage & shifted) === shifted;
		},
		any (storage, shift, mask) {
				if (mask === void 0) mask = 1;
				return (storage & mask << shift) !== 0;
		}
};

var opMask = 7;
var factorMask = 15;
var colorOpShift = 0;
var colorSrcFactorShift = 3;
var colorDstFactorShift = 7;
var alphaOpShift = 11;
var alphaSrcFactorShift = 14;
var alphaDstFactorShift = 18;
var redWriteShift = 22;
var greenWriteShift = 23;
var blueWriteShift = 24;
var alphaWriteShift = 25;
var blendShift = 26;
var allWriteMasks = 15;
var allWriteShift = redWriteShift;
class BlendState {
		set blend(value) {
				this.target0 = BitPacking.set(this.target0, value ? 1 : 0, blendShift);
		}
		get blend() {
				return BitPacking.all(this.target0, blendShift);
		}
		setColorBlend(op, srcFactor, dstFactor) {
				this.target0 = BitPacking.set(this.target0, op, colorOpShift, opMask);
				this.target0 = BitPacking.set(this.target0, srcFactor, colorSrcFactorShift, factorMask);
				this.target0 = BitPacking.set(this.target0, dstFactor, colorDstFactorShift, factorMask);
		}
		setAlphaBlend(op, srcFactor, dstFactor) {
				this.target0 = BitPacking.set(this.target0, op, alphaOpShift, opMask);
				this.target0 = BitPacking.set(this.target0, srcFactor, alphaSrcFactorShift, factorMask);
				this.target0 = BitPacking.set(this.target0, dstFactor, alphaDstFactorShift, factorMask);
		}
		setColorWrite(redWrite, greenWrite, blueWrite, alphaWrite) {
				this.redWrite = redWrite;
				this.greenWrite = greenWrite;
				this.blueWrite = blueWrite;
				this.alphaWrite = alphaWrite;
		}
		get colorOp() {
				return BitPacking.get(this.target0, colorOpShift, opMask);
		}
		get colorSrcFactor() {
				return BitPacking.get(this.target0, colorSrcFactorShift, factorMask);
		}
		get colorDstFactor() {
				return BitPacking.get(this.target0, colorDstFactorShift, factorMask);
		}
		get alphaOp() {
				return BitPacking.get(this.target0, alphaOpShift, opMask);
		}
		get alphaSrcFactor() {
				return BitPacking.get(this.target0, alphaSrcFactorShift, factorMask);
		}
		get alphaDstFactor() {
				return BitPacking.get(this.target0, alphaDstFactorShift, factorMask);
		}
		set redWrite(value) {
				this.target0 = BitPacking.set(this.target0, value ? 1 : 0, redWriteShift);
		}
		get redWrite() {
				return BitPacking.all(this.target0, redWriteShift);
		}
		set greenWrite(value) {
				this.target0 = BitPacking.set(this.target0, value ? 1 : 0, greenWriteShift);
		}
		get greenWrite() {
				return BitPacking.all(this.target0, greenWriteShift);
		}
		set blueWrite(value) {
				this.target0 = BitPacking.set(this.target0, value ? 1 : 0, blueWriteShift);
		}
		get blueWrite() {
				return BitPacking.all(this.target0, blueWriteShift);
		}
		set alphaWrite(value) {
				this.target0 = BitPacking.set(this.target0, value ? 1 : 0, alphaWriteShift);
		}
		get alphaWrite() {
				return BitPacking.all(this.target0, alphaWriteShift);
		}
		get allWrite() {
				return BitPacking.get(this.target0, allWriteShift, allWriteMasks);
		}
		copy(rhs) {
				this.target0 = rhs.target0;
				return this;
		}
		clone() {
				var clone = new this.constructor();
				return clone.copy(this);
		}
		get key() {
				return this.target0;
		}
		equals(rhs) {
				return this.target0 === rhs.target0;
		}
		constructor(blend = false, colorOp = BLENDEQUATION_ADD, colorSrcFactor = BLENDMODE_ONE, colorDstFactor = BLENDMODE_ZERO, alphaOp, alphaSrcFactor, alphaDstFactor, redWrite = true, greenWrite = true, blueWrite = true, alphaWrite = true){
				this.target0 = 0;
				this.setColorBlend(colorOp, colorSrcFactor, colorDstFactor);
				this.setAlphaBlend(alphaOp != null ? alphaOp : colorOp, alphaSrcFactor != null ? alphaSrcFactor : colorSrcFactor, alphaDstFactor != null ? alphaDstFactor : colorDstFactor);
				this.setColorWrite(redWrite, greenWrite, blueWrite, alphaWrite);
				this.blend = blend;
		}
}
BlendState.NOBLEND = Object.freeze(new BlendState());
BlendState.NOWRITE = Object.freeze(new BlendState(undefined, undefined, undefined, undefined, undefined, undefined, undefined, false, false, false, false));
BlendState.ALPHABLEND = Object.freeze(new BlendState(true, BLENDEQUATION_ADD, BLENDMODE_SRC_ALPHA, BLENDMODE_ONE_MINUS_SRC_ALPHA));
BlendState.ADDBLEND = Object.freeze(new BlendState(true, BLENDEQUATION_ADD, BLENDMODE_ONE, BLENDMODE_ONE));

class StringIds {
		get(name) {
				var value = this.map.get(name);
				if (value === undefined) {
						value = this.id++;
						this.map.set(name, value);
				}
				return value;
		}
		constructor(){
				this.map = new Map();
				this.id = 0;
		}
}

var stringIds$2 = new StringIds();
var funcMask = 7;
var funcShift = 0;
var writeShift = 3;
class DepthState {
		set test(value) {
				this.func = value ? FUNC_LESSEQUAL : FUNC_ALWAYS;
				this.updateKey();
		}
		get test() {
				return this.func !== FUNC_ALWAYS;
		}
		set write(value) {
				this.data = BitPacking.set(this.data, value ? 1 : 0, writeShift);
				this.updateKey();
		}
		get write() {
				return BitPacking.all(this.data, writeShift);
		}
		set func(value) {
				this.data = BitPacking.set(this.data, value, funcShift, funcMask);
				this.updateKey();
		}
		get func() {
				return BitPacking.get(this.data, funcShift, funcMask);
		}
		set depthBias(value) {
				this._depthBias = value;
				this.updateKey();
		}
		get depthBias() {
				return this._depthBias;
		}
		set depthBiasSlope(value) {
				this._depthBiasSlope = value;
				this.updateKey();
		}
		get depthBiasSlope() {
				return this._depthBiasSlope;
		}
		copy(rhs) {
				this.data = rhs.data;
				this._depthBias = rhs._depthBias;
				this._depthBiasSlope = rhs._depthBiasSlope;
				this.key = rhs.key;
				return this;
		}
		clone() {
				var clone = new this.constructor();
				return clone.copy(this);
		}
		updateKey() {
				var { data, _depthBias, _depthBiasSlope } = this;
				var key = data + "-" + _depthBias + "-" + _depthBiasSlope;
				this.key = stringIds$2.get(key);
		}
		equals(rhs) {
				return this.key === rhs.key;
		}
		constructor(func = FUNC_LESSEQUAL, write = true){
				this.data = 0;
				this._depthBias = 0;
				this._depthBiasSlope = 0;
				this.key = 0;
				this.func = func;
				this.write = write;
		}
}
DepthState.DEFAULT = Object.freeze(new DepthState());
DepthState.NODEPTH = Object.freeze(new DepthState(FUNC_ALWAYS, false));
DepthState.WRITEDEPTH = Object.freeze(new DepthState(FUNC_ALWAYS, true));

class Version {
		equals(other) {
				return this.globalId === other.globalId && this.revision === other.revision;
		}
		copy(other) {
				this.globalId = other.globalId;
				this.revision = other.revision;
		}
		reset() {
				this.globalId = 0;
				this.revision = 0;
		}
		constructor(){
				this.globalId = 0;
				this.revision = 0;
		}
}

var idCounter = 0;
class VersionedObject {
		increment() {
				this.version.revision++;
		}
		constructor(){
				idCounter++;
				this.version = new Version();
				this.version.globalId = idCounter;
		}
}

class ScopeId {
		toJSON(key) {
				return undefined;
		}
		setValue(value) {
				this.value = value;
				this.versionObject.increment();
		}
		getValue() {
				return this.value;
		}
		constructor(name){
				this.name = name;
				this.value = null;
				this.versionObject = new VersionedObject();
		}
}

class ScopeSpace {
		resolve(name) {
				if (!this.variables.has(name)) {
						this.variables.set(name, new ScopeId(name));
				}
				return this.variables.get(name);
		}
		removeValue(value) {
				for(var uniformName in this.variables){
						var uniform = this.variables[uniformName];
						if (uniform.value === value) {
								uniform.value = null;
						}
				}
		}
		constructor(name){
				this.name = name;
				this.variables = new Map();
		}
}

var id$7 = 0;
class VertexBuffer {
		destroy() {
				var device = this.device;
				var idx = device.buffers.indexOf(this);
				if (idx !== -1) {
						device.buffers.splice(idx, 1);
				}
				if (this.impl.initialized) {
						this.impl.destroy(device);
						this.adjustVramSizeTracking(device._vram, -this.storage.byteLength);
				}
		}
		adjustVramSizeTracking(vram, size) {
				vram.vb += size;
		}
		loseContext() {
				this.impl.loseContext();
		}
		getFormat() {
				return this.format;
		}
		getUsage() {
				return this.usage;
		}
		getNumVertices() {
				return this.numVertices;
		}
		lock() {
				return this.storage;
		}
		unlock() {
				this.impl.unlock(this);
		}
		setData(data) {
				if (data.byteLength !== this.numBytes) {
						return false;
				}
				this.storage = data;
				this.unlock();
				return true;
		}
		constructor(graphicsDevice, format, numVertices, options){
				this.usage = BUFFER_STATIC;
				var _options_usage;
				this.usage = (_options_usage = options == null ? void 0 : options.usage) != null ? _options_usage : BUFFER_STATIC;
				this.device = graphicsDevice;
				this.format = format;
				this.numVertices = numVertices;
				this.id = id$7++;
				this.impl = graphicsDevice.createVertexBufferImpl(this, format, options);
				this.numBytes = format.verticesByteSize ? format.verticesByteSize : format.size * numVertices;
				this.adjustVramSizeTracking(graphicsDevice._vram, this.numBytes);
				var initialData = options == null ? void 0 : options.data;
				if (initialData) {
						this.setData(initialData);
				} else {
						this.storage = new ArrayBuffer(this.numBytes);
				}
				this.device.buffers.push(this);
		}
}

function hashCode(str) {
		if (str === null || str === undefined) {
				return 0;
		}
		var hash = 0;
		for(var i = 0, len = str.length; i < len; i++){
				hash = (hash << 5) - hash + str.charCodeAt(i);
				hash |= 0;
		}
		return hash;
}
function hash32Fnv1a(array) {
		var prime = 16777619;
		var hash = 2166136261;
		for(var i = 0; i < array.length; i++){
				hash ^= array[i];
				hash *= prime;
		}
		return hash >>> 0;
}

var stringIds$1 = new StringIds();
var webgpuValidElementSizes = [
		2,
		4,
		8,
		12,
		16
];
var deviceCache$2 = new DeviceCache();
class VertexFormat {
		get elements() {
				return this._elements;
		}
		static getDefaultInstancingFormat(graphicsDevice) {
				return deviceCache$2.get(graphicsDevice, ()=>{
						return new VertexFormat(graphicsDevice, [
								{
										semantic: SEMANTIC_ATTR12,
										components: 4,
										type: TYPE_FLOAT32
								},
								{
										semantic: SEMANTIC_ATTR13,
										components: 4,
										type: TYPE_FLOAT32
								},
								{
										semantic: SEMANTIC_ATTR14,
										components: 4,
										type: TYPE_FLOAT32
								},
								{
										semantic: SEMANTIC_ATTR15,
										components: 4,
										type: TYPE_FLOAT32
								}
						]);
				});
		}
		static isElementValid(graphicsDevice, elementDesc) {
				var elementSize = elementDesc.components * typedArrayTypesByteSize[elementDesc.type];
				if (graphicsDevice.isWebGPU && !webgpuValidElementSizes.includes(elementSize)) {
						return false;
				}
				return true;
		}
		update() {
				this._evaluateHash();
		}
		_evaluateHash() {
				var stringElementsBatch = [];
				var stringElementsRender = [];
				var len = this._elements.length;
				for(var i = 0; i < len; i++){
						var { name, dataType, numComponents, normalize, offset, stride, size, asInt } = this._elements[i];
						var stringElementBatch = name + dataType + numComponents + normalize + asInt;
						stringElementsBatch.push(stringElementBatch);
						var stringElementRender = stringElementBatch + offset + stride + size;
						stringElementsRender.push(stringElementRender);
				}
				stringElementsBatch.sort();
				var batchingString = stringElementsBatch.join();
				this.batchingHash = hashCode(batchingString);
				this.shaderProcessingHashString = batchingString;
				this.renderingHashString = stringElementsRender.join('_');
				this.renderingHash = stringIds$1.get(this.renderingHashString);
		}
		constructor(graphicsDevice, description, vertexCount){
				this.device = graphicsDevice;
				this._elements = [];
				this.hasUv0 = false;
				this.hasUv1 = false;
				this.hasColor = false;
				this.hasTangents = false;
				this.verticesByteSize = 0;
				this.vertexCount = vertexCount;
				this.interleaved = vertexCount === undefined;
				this.instancing = false;
				this.size = description.reduce((total, desc)=>{
						return total + Math.ceil(desc.components * typedArrayTypesByteSize[desc.type] / 4) * 4;
				}, 0);
				var offset = 0, elementSize;
				for(var i = 0, len = description.length; i < len; i++){
						var elementDesc = description[i];
						elementSize = elementDesc.components * typedArrayTypesByteSize[elementDesc.type];
						if (vertexCount) {
								offset = math.roundUp(offset, elementSize);
						}
						var _elementDesc_asInt;
						var asInt = (_elementDesc_asInt = elementDesc.asInt) != null ? _elementDesc_asInt : false;
						var _elementDesc_normalize;
						var normalize = asInt ? false : (_elementDesc_normalize = elementDesc.normalize) != null ? _elementDesc_normalize : false;
						var element = {
								name: elementDesc.semantic,
								offset: vertexCount ? offset : elementDesc.hasOwnProperty('offset') ? elementDesc.offset : offset,
								stride: vertexCount ? elementSize : elementDesc.hasOwnProperty('stride') ? elementDesc.stride : this.size,
								dataType: elementDesc.type,
								numComponents: elementDesc.components,
								normalize: normalize,
								size: elementSize,
								asInt: asInt
						};
						this._elements.push(element);
						if (vertexCount) {
								offset += elementSize * vertexCount;
						} else {
								offset += Math.ceil(elementSize / 4) * 4;
						}
						if (elementDesc.semantic === SEMANTIC_TEXCOORD0) {
								this.hasUv0 = true;
						} else if (elementDesc.semantic === SEMANTIC_TEXCOORD1) {
								this.hasUv1 = true;
						} else if (elementDesc.semantic === SEMANTIC_COLOR) {
								this.hasColor = true;
						} else if (elementDesc.semantic === SEMANTIC_TANGENT) {
								this.hasTangents = true;
						}
				}
				if (vertexCount) {
						this.verticesByteSize = offset;
				}
				this._evaluateHash();
		}
}

var stringIds = new StringIds();
class StencilParameters {
		set func(value) {
				this._func = value;
				this._dirty = true;
		}
		get func() {
				return this._func;
		}
		set ref(value) {
				this._ref = value;
				this._dirty = true;
		}
		get ref() {
				return this._ref;
		}
		set fail(value) {
				this._fail = value;
				this._dirty = true;
		}
		get fail() {
				return this._fail;
		}
		set zfail(value) {
				this._zfail = value;
				this._dirty = true;
		}
		get zfail() {
				return this._zfail;
		}
		set zpass(value) {
				this._zpass = value;
				this._dirty = true;
		}
		get zpass() {
				return this._zpass;
		}
		set readMask(value) {
				this._readMask = value;
				this._dirty = true;
		}
		get readMask() {
				return this._readMask;
		}
		set writeMask(value) {
				this._writeMask = value;
				this._dirty = true;
		}
		get writeMask() {
				return this._writeMask;
		}
		_evalKey() {
				var { _func, _ref, _fail, _zfail, _zpass, _readMask, _writeMask } = this;
				var key = _func + "," + _ref + "," + _fail + "," + _zfail + "," + _zpass + "," + _readMask + "," + _writeMask;
				this._key = stringIds.get(key);
				this._dirty = false;
		}
		get key() {
				if (this._dirty) {
						this._evalKey();
				}
				return this._key;
		}
		copy(rhs) {
				this._func = rhs._func;
				this._ref = rhs._ref;
				this._readMask = rhs._readMask;
				this._writeMask = rhs._writeMask;
				this._fail = rhs._fail;
				this._zfail = rhs._zfail;
				this._zpass = rhs._zpass;
				this._dirty = rhs._dirty;
				this._key = rhs._key;
				return this;
		}
		clone() {
				var clone = new this.constructor();
				return clone.copy(this);
		}
		constructor(options = {}){
				this._dirty = true;
				var _options_func;
				this._func = (_options_func = options.func) != null ? _options_func : FUNC_ALWAYS;
				var _options_ref;
				this._ref = (_options_ref = options.ref) != null ? _options_ref : 0;
				var _options_readMask;
				this._readMask = (_options_readMask = options.readMask) != null ? _options_readMask : 0xFF;
				var _options_writeMask;
				this._writeMask = (_options_writeMask = options.writeMask) != null ? _options_writeMask : 0xFF;
				var _options_fail;
				this._fail = (_options_fail = options.fail) != null ? _options_fail : STENCILOP_KEEP;
				var _options_zfail;
				this._zfail = (_options_zfail = options.zfail) != null ? _options_zfail : STENCILOP_KEEP;
				var _options_zpass;
				this._zpass = (_options_zpass = options.zpass) != null ? _options_zpass : STENCILOP_KEEP;
				this._evalKey();
		}
}
StencilParameters.DEFAULT = Object.freeze(new StencilParameters());

function _extends$i() {
		_extends$i = Object.assign || function(target) {
				for(var i = 1; i < arguments.length; i++){
						var source = arguments[i];
						for(var key in source){
								if (Object.prototype.hasOwnProperty.call(source, key)) {
										target[key] = source[key];
								}
						}
				}
				return target;
		};
		return _extends$i.apply(this, arguments);
}
class GraphicsDevice extends EventHandler {
		postInit() {
				var vertexFormat = new VertexFormat(this, [
						{
								semantic: SEMANTIC_POSITION,
								components: 2,
								type: TYPE_FLOAT32
						}
				]);
				var positions = new Float32Array([
						-1,
						-1,
						1,
						-1,
						-1,
						1,
						1,
						1
				]);
				this.quadVertexBuffer = new VertexBuffer(this, vertexFormat, 4, {
						data: positions
				});
		}
		initCapsDefines() {
				var { capsDefines } = this;
				capsDefines.clear();
				if (this.textureFloatFilterable) capsDefines.set('CAPS_TEXTURE_FLOAT_FILTERABLE', '');
				if (this.textureFloatRenderable) capsDefines.set('CAPS_TEXTURE_FLOAT_RENDERABLE', '');
		}
		destroy() {
				var _this_quadVertexBuffer, _this_dynamicBuffers, _this_gpuProfiler;
				this.fire('destroy');
				(_this_quadVertexBuffer = this.quadVertexBuffer) == null ? void 0 : _this_quadVertexBuffer.destroy();
				this.quadVertexBuffer = null;
				(_this_dynamicBuffers = this.dynamicBuffers) == null ? void 0 : _this_dynamicBuffers.destroy();
				this.dynamicBuffers = null;
				(_this_gpuProfiler = this.gpuProfiler) == null ? void 0 : _this_gpuProfiler.destroy();
				this.gpuProfiler = null;
		}
		onDestroyShader(shader) {
				this.fire('destroy:shader', shader);
				var idx = this.shaders.indexOf(shader);
				if (idx !== -1) {
						this.shaders.splice(idx, 1);
				}
		}
		postDestroy() {
				this.scope = null;
				this.canvas = null;
		}
		loseContext() {
				var _this_gpuProfiler;
				this.contextLost = true;
				this.backBufferSize.set(-1, -1);
				for (var texture of this.textures){
						texture.loseContext();
				}
				for (var buffer of this.buffers){
						buffer.loseContext();
				}
				for (var target of this.targets){
						target.loseContext();
				}
				(_this_gpuProfiler = this.gpuProfiler) == null ? void 0 : _this_gpuProfiler.loseContext();
		}
		restoreContext() {
				var _this_gpuProfiler_restoreContext, _this_gpuProfiler;
				this.contextLost = false;
				this.initializeRenderState();
				this.initializeContextCaches();
				for (var buffer of this.buffers){
						buffer.unlock();
				}
				(_this_gpuProfiler = this.gpuProfiler) == null ? void 0 : (_this_gpuProfiler_restoreContext = _this_gpuProfiler.restoreContext) == null ? void 0 : _this_gpuProfiler_restoreContext.call(_this_gpuProfiler);
		}
		toJSON(key) {
				return undefined;
		}
		initializeContextCaches() {
				this.indexBuffer = null;
				this.vertexBuffers = [];
				this.shader = null;
				this.shaderValid = undefined;
				this.shaderAsyncCompile = false;
				this.renderTarget = null;
		}
		initializeRenderState() {
				this.blendState = new BlendState();
				this.depthState = new DepthState();
				this.cullMode = CULLFACE_BACK;
				this.vx = this.vy = this.vw = this.vh = 0;
				this.sx = this.sy = this.sw = this.sh = 0;
				this.blendColor = new Color(0, 0, 0, 0);
		}
		setStencilState(stencilFront, stencilBack) {}
		setBlendState(blendState) {}
		setBlendColor(r, g, b, a) {}
		setDepthState(depthState) {}
		setCullMode(cullMode) {}
		setRenderTarget(renderTarget) {
				this.renderTarget = renderTarget;
		}
		setIndexBuffer(indexBuffer) {
				this.indexBuffer = indexBuffer;
		}
		setVertexBuffer(vertexBuffer) {
				if (vertexBuffer) {
						this.vertexBuffers.push(vertexBuffer);
				}
		}
		clearVertexBuffer() {
				this.vertexBuffers.length = 0;
		}
		clearIndexBuffer() {
				this.indexBuffer = null;
		}
		getRenderTarget() {
				return this.renderTarget;
		}
		initRenderTarget(target) {
				if (target.initialized) return;
				target.init();
				this.targets.add(target);
		}
		_isBrowserInterface(texture) {
				return this._isImageBrowserInterface(texture) || this._isImageCanvasInterface(texture) || this._isImageVideoInterface(texture);
		}
		_isImageBrowserInterface(texture) {
				return typeof ImageBitmap !== 'undefined' && texture instanceof ImageBitmap || typeof HTMLImageElement !== 'undefined' && texture instanceof HTMLImageElement;
		}
		_isImageCanvasInterface(texture) {
				return typeof HTMLCanvasElement !== 'undefined' && texture instanceof HTMLCanvasElement;
		}
		_isImageVideoInterface(texture) {
				return typeof HTMLVideoElement !== 'undefined' && texture instanceof HTMLVideoElement;
		}
		resizeCanvas(width, height) {
				var pixelRatio = Math.min(this._maxPixelRatio, platform.browser ? window.devicePixelRatio : 1);
				var w = Math.floor(width * pixelRatio);
				var h = Math.floor(height * pixelRatio);
				if (w !== this.canvas.width || h !== this.canvas.height) {
						this.setResolution(w, h);
				}
		}
		setResolution(width, height) {
				this.canvas.width = width;
				this.canvas.height = height;
				this.fire(GraphicsDevice.EVENT_RESIZE, width, height);
		}
		updateClientRect() {
				if (platform.worker) {
						this.clientRect.width = this.canvas.width;
						this.clientRect.height = this.canvas.height;
				} else {
						var rect = this.canvas.getBoundingClientRect();
						this.clientRect.width = rect.width;
						this.clientRect.height = rect.height;
				}
		}
		get width() {
				return this.canvas.width;
		}
		get height() {
				return this.canvas.height;
		}
		set fullscreen(fullscreen) {}
		get fullscreen() {
				return false;
		}
		set maxPixelRatio(ratio) {
				this._maxPixelRatio = ratio;
		}
		get maxPixelRatio() {
				return this._maxPixelRatio;
		}
		get deviceType() {
				return this._deviceType;
		}
		startRenderPass(renderPass) {}
		endRenderPass(renderPass) {}
		startComputePass(name) {}
		endComputePass() {}
		frameStart() {
				this.renderPassIndex = 0;
				this.renderVersion++;
		}
		frameEnd() {}
		computeDispatch(computes, name) {
		}
		getRenderableHdrFormat(formats, filterable, samples) {
				if (formats === void 0) formats = [
						PIXELFORMAT_111110F,
						PIXELFORMAT_RGBA16F,
						PIXELFORMAT_RGBA32F
				];
				if (filterable === void 0) filterable = true;
				if (samples === void 0) samples = 1;
				for(var i = 0; i < formats.length; i++){
						var format = formats[i];
						switch(format){
								case PIXELFORMAT_111110F:
										{
												if (this.textureRG11B10Renderable) {
														return format;
												}
												break;
										}
								case PIXELFORMAT_RGBA16F:
										if (this.textureHalfFloatRenderable) {
												return format;
										}
										break;
								case PIXELFORMAT_RGBA32F:
										if (this.isWebGPU && samples > 1) {
												continue;
										}
										if (this.textureFloatRenderable && (!filterable || this.textureFloatFilterable)) {
												return format;
										}
										break;
						}
				}
				return undefined;
		}
		validateAttributes(shader, vb0Format, vb1Format) {}
		constructor(canvas, options){
				var _this_initOptions, _this_initOptions1, _this_initOptions2, _this_initOptions3, _this_initOptions4, _this_initOptions5;
				super(), this.backBuffer = null, this.backBufferSize = new Vec2(), this.backBufferAntialias = false, this.isWebGPU = false, this.isWebGL2 = false, this.isHdr = false, this.maxColorAttachments = 1, this.maxSamples = 1, this.supportsCompute = false, this.supportsStorageTextureRead = false, this.renderTarget = null, this.shaders = [], this.textures = [], this.targets = new Set(), this.renderVersion = 0, this.insideRenderPass = false, this.supportsUniformBuffers = false, this.supportsClipDistances = false, this.textureRG11B10Renderable = false, this.textureFloatFilterable = false, this.blendState = new BlendState(), this.depthState = new DepthState(), this.stencilEnabled = false, this.stencilFront = new StencilParameters(), this.stencilBack = new StencilParameters(), this.defaultClearOptions = {
						color: [
								0,
								0,
								0,
								1
						],
						depth: 1,
						stencil: 0,
						flags: CLEARFLAG_COLOR | CLEARFLAG_DEPTH
				}, this.clientRect = {
						width: 0,
						height: 0
				}, this._shadersDirty = false, this.capsDefines = new Map();
				this.canvas = canvas;
				this.initOptions = _extends$i({}, options);
				var _alpha;
				(_alpha = (_this_initOptions = this.initOptions).alpha) != null ? _alpha : _this_initOptions.alpha = true;
				var _depth;
				(_depth = (_this_initOptions1 = this.initOptions).depth) != null ? _depth : _this_initOptions1.depth = true;
				var _stencil;
				(_stencil = (_this_initOptions2 = this.initOptions).stencil) != null ? _stencil : _this_initOptions2.stencil = true;
				var _antialias;
				(_antialias = (_this_initOptions3 = this.initOptions).antialias) != null ? _antialias : _this_initOptions3.antialias = true;
				var _powerPreference;
				(_powerPreference = (_this_initOptions4 = this.initOptions).powerPreference) != null ? _powerPreference : _this_initOptions4.powerPreference = 'high-performance';
				var _displayFormat;
				(_displayFormat = (_this_initOptions5 = this.initOptions).displayFormat) != null ? _displayFormat : _this_initOptions5.displayFormat = DISPLAYFORMAT_LDR;
				this._maxPixelRatio = platform.browser ? Math.min(1, window.devicePixelRatio) : 1;
				this.buffers = [];
				this._vram = {
						tex: 0,
						vb: 0,
						ib: 0,
						ub: 0,
						sb: 0
				};
				this._shaderStats = {
						vsCompiled: 0,
						fsCompiled: 0,
						linked: 0,
						materialShaders: 0,
						compileTime: 0
				};
				this.initializeContextCaches();
				this._drawCallsPerFrame = 0;
				this._shaderSwitchesPerFrame = 0;
				this._primsPerFrame = [];
				for(var i = PRIMITIVE_POINTS; i <= PRIMITIVE_TRIFAN; i++){
						this._primsPerFrame[i] = 0;
				}
				this._renderTargetCreationTime = 0;
				this.scope = new ScopeSpace('Device');
				this.textureBias = this.scope.resolve('textureBias');
				this.textureBias.setValue(0.0);
		}
}
GraphicsDevice.EVENT_RESIZE = 'resizecanvas';

var id$6 = 0;
class RenderTarget {
		destroy() {
				var device = this._device;
				if (device) {
						device.targets.delete(this);
						if (device.renderTarget === this) {
								device.setRenderTarget(null);
						}
						this.destroyFrameBuffers();
				}
		}
		destroyFrameBuffers() {
				var device = this._device;
				if (device) {
						this.impl.destroy(device);
				}
		}
		destroyTextureBuffers() {
				var _this__depthBuffer, _this__colorBuffers;
				(_this__depthBuffer = this._depthBuffer) == null ? void 0 : _this__depthBuffer.destroy();
				this._depthBuffer = null;
				(_this__colorBuffers = this._colorBuffers) == null ? void 0 : _this__colorBuffers.forEach((colorBuffer)=>{
						colorBuffer.destroy();
				});
				this._colorBuffers = null;
				this._colorBuffer = null;
		}
		resize(width, height) {
				if (this.width !== width || this.height !== height) {
						var _this__depthBuffer, _this__colorBuffers;
						if (this.mipLevel > 0) {
								return;
						}
						var device = this._device;
						this.destroyFrameBuffers();
						if (device.renderTarget === this) {
								device.setRenderTarget(null);
						}
						(_this__depthBuffer = this._depthBuffer) == null ? void 0 : _this__depthBuffer.resize(width, height);
						(_this__colorBuffers = this._colorBuffers) == null ? void 0 : _this__colorBuffers.forEach((colorBuffer)=>{
								colorBuffer.resize(width, height);
						});
						this.validateMrt();
						this.impl = device.createRenderTargetImpl(this);
				}
		}
		validateMrt() {}
		init() {
				this.impl.init(this._device, this);
		}
		get initialized() {
				return this.impl.initialized;
		}
		get device() {
				return this._device;
		}
		loseContext() {
				this.impl.loseContext();
		}
		resolve(color, depth) {
				if (color === void 0) color = true;
				if (depth === void 0) depth = !!this._depthBuffer;
				if (this._device && this._samples > 1) {
						this.impl.resolve(this._device, this, color, depth);
				}
		}
		copy(source, color, depth) {
				if (!this._device) {
						if (source._device) {
								this._device = source._device;
						} else {
								return false;
						}
				}
				var success = this._device.copyRenderTarget(source, this, color, depth);
				return success;
		}
		get samples() {
				return this._samples;
		}
		get depth() {
				return this._depth;
		}
		get stencil() {
				return this._stencil;
		}
		get colorBuffer() {
				return this._colorBuffer;
		}
		getColorBuffer(index) {
				var _this__colorBuffers;
				return (_this__colorBuffers = this._colorBuffers) == null ? void 0 : _this__colorBuffers[index];
		}
		get depthBuffer() {
				return this._depthBuffer;
		}
		get face() {
				return this._face;
		}
		get mipLevel() {
				return this._mipLevel;
		}
		get mipmaps() {
				return this._mipmaps;
		}
		get width() {
				var _this__colorBuffer, _this__depthBuffer;
				var width = ((_this__colorBuffer = this._colorBuffer) == null ? void 0 : _this__colorBuffer.width) || ((_this__depthBuffer = this._depthBuffer) == null ? void 0 : _this__depthBuffer.width) || this._device.width;
				if (this._mipLevel > 0) {
						width = TextureUtils.calcLevelDimension(width, this._mipLevel);
				}
				return width;
		}
		get height() {
				var _this__colorBuffer, _this__depthBuffer;
				var height = ((_this__colorBuffer = this._colorBuffer) == null ? void 0 : _this__colorBuffer.height) || ((_this__depthBuffer = this._depthBuffer) == null ? void 0 : _this__depthBuffer.height) || this._device.height;
				if (this._mipLevel > 0) {
						height = TextureUtils.calcLevelDimension(height, this._mipLevel);
				}
				return height;
		}
		isColorBufferSrgb(index) {
				if (index === void 0) index = 0;
				if (this.device.backBuffer === this) {
						return isSrgbPixelFormat(this.device.backBufferFormat);
				}
				var colorBuffer = this.getColorBuffer(index);
				return colorBuffer ? isSrgbPixelFormat(colorBuffer.format) : false;
		}
		constructor(options = {}){
				var _options_colorBuffer, _options_colorBuffers, _options_depthBuffer;
				this.id = id$6++;
				var _options_colorBuffer_device, _ref, _ref1;
				var device = (_ref1 = (_ref = (_options_colorBuffer_device = (_options_colorBuffer = options.colorBuffer) == null ? void 0 : _options_colorBuffer.device) != null ? _options_colorBuffer_device : (_options_colorBuffers = options.colorBuffers) == null ? void 0 : _options_colorBuffers[0].device) != null ? _ref : (_options_depthBuffer = options.depthBuffer) == null ? void 0 : _options_depthBuffer.device) != null ? _ref1 : options.graphicsDevice;
				this._device = device;
				var { maxSamples } = this._device;
				var _options_samples;
				this._samples = Math.min((_options_samples = options.samples) != null ? _options_samples : 1, maxSamples);
				if (device.isWebGPU) {
						this._samples = this._samples > 1 ? maxSamples : 1;
				}
				this._colorBuffer = options.colorBuffer;
				if (options.colorBuffer) {
						this._colorBuffers = [
								options.colorBuffer
						];
				}
				this._depthBuffer = options.depthBuffer;
				var _options_face;
				this._face = (_options_face = options.face) != null ? _options_face : 0;
				if (this._depthBuffer) {
						var format = this._depthBuffer._format;
						if (format === PIXELFORMAT_DEPTH || format === PIXELFORMAT_DEPTH16) {
								this._depth = true;
								this._stencil = false;
						} else if (format === PIXELFORMAT_DEPTHSTENCIL) {
								this._depth = true;
								this._stencil = true;
						} else if (format === PIXELFORMAT_R32F && this._depthBuffer.device.isWebGPU && this._samples > 1) {
								this._depth = true;
								this._stencil = false;
						} else {
								this._depth = false;
								this._stencil = false;
						}
				} else {
						var _options_depth;
						this._depth = (_options_depth = options.depth) != null ? _options_depth : true;
						var _options_stencil;
						this._stencil = (_options_stencil = options.stencil) != null ? _options_stencil : false;
				}
				if (options.colorBuffers) {
						if (!this._colorBuffers) {
								this._colorBuffers = [
										...options.colorBuffers
								];
								this._colorBuffer = options.colorBuffers[0];
						}
				}
				var _options_autoResolve;
				this.autoResolve = (_options_autoResolve = options.autoResolve) != null ? _options_autoResolve : true;
				this.name = options.name;
				if (!this.name) {
						var _this__colorBuffer;
						this.name = (_this__colorBuffer = this._colorBuffer) == null ? void 0 : _this__colorBuffer.name;
				}
				if (!this.name) {
						var _this__depthBuffer;
						this.name = (_this__depthBuffer = this._depthBuffer) == null ? void 0 : _this__depthBuffer.name;
				}
				if (!this.name) {
						this.name = 'Untitled';
				}
				var _options_flipY;
				this.flipY = (_options_flipY = options.flipY) != null ? _options_flipY : false;
				var _options_mipLevel;
				this._mipLevel = (_options_mipLevel = options.mipLevel) != null ? _options_mipLevel : 0;
				if (this._mipLevel > 0 && this._depth) {
						this._mipLevel = 0;
				}
				this._mipmaps = options.mipLevel === undefined;
				this.validateMrt();
				this.impl = device.createRenderTargetImpl(this);
		}
}

class RefCountedObject {
		incRefCount() {
				this._refCount++;
		}
		decRefCount() {
				this._refCount--;
		}
		get refCount() {
				return this._refCount;
		}
		constructor(){
				this._refCount = 0;
		}
}

class Entry extends RefCountedObject {
		constructor(obj){
				super();
				this.object = obj;
				this.incRefCount();
		}
}
class RefCountedKeyCache {
		destroy() {
				this.cache.forEach((entry)=>{
						var _entry_object;
						(_entry_object = entry.object) == null ? void 0 : _entry_object.destroy();
				});
				this.cache.clear();
		}
		clear() {
				this.cache.clear();
		}
		get(key) {
				var entry = this.cache.get(key);
				if (entry) {
						entry.incRefCount();
						return entry.object;
				}
				return null;
		}
		set(key, object) {
				this.cache.set(key, new Entry(object));
		}
		release(key) {
				var entry = this.cache.get(key);
				if (entry) {
						entry.decRefCount();
						if (entry.refCount === 0) {
								var _entry_object;
								this.cache.delete(key);
								(_entry_object = entry.object) == null ? void 0 : _entry_object.destroy();
						}
				}
		}
		constructor(){
				this.cache = new Map();
		}
}

class MultisampledTextureCache extends RefCountedKeyCache {
		loseContext(device) {
				this.clear();
		}
}
var multisampledTextureCache = new DeviceCache();
var getMultisampledTextureCache = (device)=>{
		return multisampledTextureCache.get(device, ()=>{
				return new MultisampledTextureCache();
		});
};

var uniformTypeToNumComponents = [];
uniformTypeToNumComponents[UNIFORMTYPE_FLOAT] = 1;
uniformTypeToNumComponents[UNIFORMTYPE_VEC2] = 2;
uniformTypeToNumComponents[UNIFORMTYPE_VEC3] = 3;
uniformTypeToNumComponents[UNIFORMTYPE_VEC4] = 4;
uniformTypeToNumComponents[UNIFORMTYPE_INT] = 1;
uniformTypeToNumComponents[UNIFORMTYPE_IVEC2] = 2;
uniformTypeToNumComponents[UNIFORMTYPE_IVEC3] = 3;
uniformTypeToNumComponents[UNIFORMTYPE_IVEC4] = 4;
uniformTypeToNumComponents[UNIFORMTYPE_BOOL] = 1;
uniformTypeToNumComponents[UNIFORMTYPE_BVEC2] = 2;
uniformTypeToNumComponents[UNIFORMTYPE_BVEC3] = 3;
uniformTypeToNumComponents[UNIFORMTYPE_BVEC4] = 4;
uniformTypeToNumComponents[UNIFORMTYPE_MAT2] = 8;
uniformTypeToNumComponents[UNIFORMTYPE_MAT3] = 12;
uniformTypeToNumComponents[UNIFORMTYPE_MAT4] = 16;
uniformTypeToNumComponents[UNIFORMTYPE_UINT] = 1;
uniformTypeToNumComponents[UNIFORMTYPE_UVEC2] = 2;
uniformTypeToNumComponents[UNIFORMTYPE_UVEC3] = 3;
uniformTypeToNumComponents[UNIFORMTYPE_UVEC4] = 4;
class UniformFormat {
		get isArrayType() {
				return this.count > 0;
		}
		calculateOffset(offset) {
				var alignment = this.byteSize <= 8 ? this.byteSize : 16;
				if (this.count) {
						alignment = 16;
				}
				offset = math.roundUp(offset, alignment);
				this.offset = offset / 4;
		}
		constructor(name, type, count = 0){
				this.shortName = name;
				this.name = count ? "" + name + "[0]" : name;
				this.type = type;
				this.numComponents = uniformTypeToNumComponents[type];
				this.updateType = type;
				if (count > 0) {
						switch(type){
								case UNIFORMTYPE_FLOAT:
										this.updateType = UNIFORMTYPE_FLOATARRAY;
										break;
								case UNIFORMTYPE_INT:
										this.updateType = UNIFORMTYPE_INTARRAY;
										break;
								case UNIFORMTYPE_UINT:
										this.updateType = UNIFORMTYPE_UINTARRAY;
										break;
								case UNIFORMTYPE_BOOL:
										this.updateType = UNIFORMTYPE_BOOLARRAY;
										break;
								case UNIFORMTYPE_VEC2:
										this.updateType = UNIFORMTYPE_VEC2ARRAY;
										break;
								case UNIFORMTYPE_IVEC2:
										this.updateType = UNIFORMTYPE_IVEC2ARRAY;
										break;
								case UNIFORMTYPE_UVEC2:
										this.updateType = UNIFORMTYPE_UVEC2ARRAY;
										break;
								case UNIFORMTYPE_BVEC2:
										this.updateType = UNIFORMTYPE_BVEC2ARRAY;
										break;
								case UNIFORMTYPE_VEC3:
										this.updateType = UNIFORMTYPE_VEC3ARRAY;
										break;
								case UNIFORMTYPE_IVEC3:
										this.updateType = UNIFORMTYPE_IVEC3ARRAY;
										break;
								case UNIFORMTYPE_UVEC3:
										this.updateType = UNIFORMTYPE_UVEC3ARRAY;
										break;
								case UNIFORMTYPE_BVEC3:
										this.updateType = UNIFORMTYPE_BVEC3ARRAY;
										break;
								case UNIFORMTYPE_VEC4:
										this.updateType = UNIFORMTYPE_VEC4ARRAY;
										break;
								case UNIFORMTYPE_IVEC4:
										this.updateType = UNIFORMTYPE_IVEC4ARRAY;
										break;
								case UNIFORMTYPE_UVEC4:
										this.updateType = UNIFORMTYPE_UVEC4ARRAY;
										break;
								case UNIFORMTYPE_BVEC4:
										this.updateType = UNIFORMTYPE_BVEC4ARRAY;
										break;
								case UNIFORMTYPE_MAT4:
										this.updateType = UNIFORMTYPE_MAT4ARRAY;
										break;
						}
				}
				this.count = count;
				var componentSize = this.numComponents;
				if (count) {
						componentSize = math.roundUp(componentSize, 4);
				}
				this.byteSize = componentSize * 4;
				if (count) {
						this.byteSize *= count;
				}
		}
}
class UniformBufferFormat {
		get(name) {
				return this.map.get(name);
		}
		constructor(graphicsDevice, uniforms){
				this.byteSize = 0;
				this.map = new Map();
				this.scope = graphicsDevice.scope;
				this.uniforms = uniforms;
				var offset = 0;
				for(var i = 0; i < uniforms.length; i++){
						var uniform = uniforms[i];
						uniform.calculateOffset(offset);
						offset = uniform.offset * 4 + uniform.byteSize;
						uniform.scopeId = this.scope.resolve(uniform.name);
						this.map.set(uniform.name, uniform);
				}
				this.byteSize = math.roundUp(offset, 16);
		}
}

var KEYWORD = /[ \t]*#(ifn?def|if|endif|else|elif|define|undef|extension|include)/g;
var DEFINE = /define[ \t]+([^\n]+)\r?(?:\n|$)/g;
var EXTENSION = /extension[ \t]+([\w-]+)[ \t]*:[ \t]*(enable|require)/g;
var UNDEF = /undef[ \t]+([^\n]+)\r?(?:\n|$)/g;
var IF = /(ifdef|ifndef|if)[ \t]*([^\r\n]+)\r?\n/g;
var ENDIF = /(endif|else|elif)(?:[ \t]+([^\r\n]*))?\r?\n?/g;
var IDENTIFIER$1 = /\{?[\w-]+\}?/;
var DEFINED = /(!|\s)?defined\(([\w-]+)\)/;
var COMPARISON = /([a-z_]\w*)\s*(==|!=|<|<=|>|>=)\s*([\w"']+)/i;
var INVALID = /[+\-]/g;
var INCLUDE = /include[ \t]+"([\w-]+)(?:\s*,\s*([\w-]+))?"\r?(?:\n|$)/g;
var LOOP_INDEX = /\{i\}/g;
var FRAGCOLOR = /(pcFragColor[1-8])\b/g;
class Preprocessor {
		static run(source, includes, options) {
				if (includes === void 0) includes = new Map();
				if (options === void 0) options = {};
				Preprocessor.sourceName = options.sourceName;
				source = this.stripComments(source);
				source = source.split(/\r?\n/).map((line)=>line.trimEnd()).join('\n');
				var defines = new Map();
				var injectDefines = new Map();
				source = this._preprocess(source, defines, injectDefines, includes, options.stripDefines);
				var intDefines = new Map();
				defines.forEach((value, key)=>{
						if (Number.isInteger(parseFloat(value)) && !value.includes('.')) {
								intDefines.set(key, value);
						}
				});
				source = this.stripComments(source);
				source = this.stripUnusedColorAttachments(source, options);
				source = this.RemoveEmptyLines(source);
				source = this.processArraySize(source, intDefines);
				source = this.injectDefines(source, injectDefines);
				return source;
		}
		static stripUnusedColorAttachments(source, options) {
				if (options.stripUnusedColorAttachments) {
						var counts = new Map();
						var matches = source.match(FRAGCOLOR);
						matches == null ? void 0 : matches.forEach((match)=>{
								var index = parseInt(match.charAt(match.length - 1), 10);
								var _counts_get;
								counts.set(index, ((_counts_get = counts.get(index)) != null ? _counts_get : 0) + 1);
						});
						var anySingleUse = Array.from(counts.values()).some((count)=>count === 1);
						if (anySingleUse) {
								var lines = source.split('\n');
								var keepLines = [];
								for(var i = 0; i < lines.length; i++){
										var match = lines[i].match(FRAGCOLOR);
										if (match) {
												var index = parseInt(match[0].charAt(match[0].length - 1), 10);
												if (index > 0 && counts.get(index) === 1) {
														continue;
												}
										}
										keepLines.push(lines[i]);
								}
								source = keepLines.join('\n');
						}
				}
				return source;
		}
		static stripComments(source) {
				return source.replace(/\/\*[\s\S]*?\*\/|([^\\:]|^)\/\/.*$/gm, '$1');
		}
		static processArraySize(source, intDefines) {
				if (source !== null) {
						intDefines.forEach((value, key)=>{
								source = source.replace(new RegExp("\\[" + key + "\\]", 'g'), "[" + value + "]");
						});
				}
				return source;
		}
		static injectDefines(source, injectDefines) {
				if (source !== null && injectDefines.size > 0) {
						var lines = source.split('\n');
						injectDefines.forEach((value, key)=>{
								var regex = new RegExp(key, 'g');
								for(var i = 0; i < lines.length; i++){
										if (!lines[i].includes('#')) {
												lines[i] = lines[i].replace(regex, value);
										}
								}
						});
						source = lines.join('\n');
				}
				return source;
		}
		static RemoveEmptyLines(source) {
				if (source !== null) {
						source = source.split(/\r?\n/).map((line)=>line.trim() === '' ? '' : line).join('\n');
						source = source.replace(/(\n\n){3,}/g, '\n\n');
				}
				return source;
		}
		static _preprocess(source, defines, injectDefines, includes, stripDefines) {
				if (defines === void 0) defines = new Map();
				var originalSource = source;
				var stack = [];
				var error = false;
				var match;
				while((match = KEYWORD.exec(source)) !== null && !error){
						var keyword = match[1];
						switch(keyword){
								case 'define':
										{
												DEFINE.lastIndex = match.index;
												var define = DEFINE.exec(source);
												error || (error = define === null);
												var expression = define[1];
												IDENTIFIER$1.lastIndex = define.index;
												var identifierValue = IDENTIFIER$1.exec(expression);
												var identifier = identifierValue[0];
												var value = expression.substring(identifier.length).trim();
												if (value === '') value = 'true';
												var keep = Preprocessor._keep(stack);
												var stripThisDefine = stripDefines;
												if (keep) {
														var replacementDefine = identifier.startsWith('{') && identifier.endsWith('}');
														if (replacementDefine) {
																stripThisDefine = true;
														}
														if (replacementDefine) {
																injectDefines.set(identifier, value);
														} else {
																defines.set(identifier, value);
														}
														if (stripThisDefine) {
																source = source.substring(0, define.index - 1) + source.substring(DEFINE.lastIndex);
																KEYWORD.lastIndex = define.index - 1;
														}
												}
												if (!stripThisDefine) {
														KEYWORD.lastIndex = define.index + define[0].length;
												}
												break;
										}
								case 'undef':
										{
												UNDEF.lastIndex = match.index;
												var undef = UNDEF.exec(source);
												var identifier1 = undef[1].trim();
												var keep1 = Preprocessor._keep(stack);
												if (keep1) {
														defines.delete(identifier1);
														if (stripDefines) {
																source = source.substring(0, undef.index - 1) + source.substring(UNDEF.lastIndex);
																KEYWORD.lastIndex = undef.index - 1;
														}
												}
												if (!stripDefines) {
														KEYWORD.lastIndex = undef.index + undef[0].length;
												}
												break;
										}
								case 'extension':
										{
												EXTENSION.lastIndex = match.index;
												var extension = EXTENSION.exec(source);
												error || (error = extension === null);
												if (extension) {
														var identifier2 = extension[1];
														var keep2 = Preprocessor._keep(stack);
														if (keep2) {
																defines.set(identifier2, 'true');
														}
												}
												KEYWORD.lastIndex = extension.index + extension[0].length;
												break;
										}
								case 'ifdef':
								case 'ifndef':
								case 'if':
										{
												IF.lastIndex = match.index;
												var iff = IF.exec(source);
												var expression1 = iff[2];
												var evaluated = Preprocessor.evaluate(expression1, defines);
												error || (error = evaluated.error);
												var result = evaluated.result;
												if (keyword === 'ifndef') {
														result = !result;
												}
												stack.push({
														anyKeep: result,
														keep: result,
														start: match.index,
														end: IF.lastIndex
												});
												KEYWORD.lastIndex = iff.index + iff[0].length;
												break;
										}
								case 'endif':
								case 'else':
								case 'elif':
										{
												ENDIF.lastIndex = match.index;
												var endif = ENDIF.exec(source);
												var blockInfo = stack.pop();
												if (!blockInfo) {
														console.error('Shader preprocessing encountered "#' + endif[1] + '" without a preceding #if #ifdef #ifndef while preprocessing ' + Preprocessor.sourceName + " on line:\n " + source.substring(match.index, match.index + 100) + "...", {
																source: originalSource
														});
														error = true;
														continue;
												}
												var blockCode = blockInfo.keep ? source.substring(blockInfo.end, match.index) : '';
												source = source.substring(0, blockInfo.start) + blockCode + source.substring(ENDIF.lastIndex);
												KEYWORD.lastIndex = blockInfo.start + blockCode.length;
												var endifCommand = endif[1];
												if (endifCommand === 'else' || endifCommand === 'elif') {
														var result1 = false;
														if (!blockInfo.anyKeep) {
																if (endifCommand === 'else') {
																		result1 = !blockInfo.keep;
																} else {
																		var evaluated1 = Preprocessor.evaluate(endif[2], defines);
																		result1 = evaluated1.result;
																		error || (error = evaluated1.error);
																}
														}
														stack.push({
																anyKeep: blockInfo.anyKeep || result1,
																keep: result1,
																start: KEYWORD.lastIndex,
																end: KEYWORD.lastIndex
														});
												}
												break;
										}
								case 'include':
										{
												var _include_;
												INCLUDE.lastIndex = match.index;
												var include = INCLUDE.exec(source);
												error || (error = include === null);
												var identifier3 = include[1].trim();
												var countIdentifier = (_include_ = include[2]) == null ? void 0 : _include_.trim();
												var keep3 = Preprocessor._keep(stack);
												if (keep3) {
														var includeSource = includes == null ? void 0 : includes.get(identifier3);
														if (includeSource !== undefined) {
																includeSource = this.stripComments(includeSource);
																if (countIdentifier) {
																		var countString = defines.get(countIdentifier);
																		var count = parseFloat(countString);
																		if (Number.isInteger(count)) {
																				var result2 = '';
																				for(var i = 0; i < count; i++){
																						result2 += includeSource.replace(LOOP_INDEX, String(i));
																				}
																				includeSource = result2;
																		} else {
																				console.error('Include Count identifier "' + countIdentifier + '" not resolved while preprocessing ' + Preprocessor.sourceName + " on line:\n " + source.substring(match.index, match.index + 100) + "...", {
																						source: originalSource
																				});
																				error = true;
																		}
																}
																source = source.substring(0, include.index - 1) + includeSource + source.substring(INCLUDE.lastIndex);
																KEYWORD.lastIndex = include.index - 1;
														} else {
																console.error('Include "' + identifier3 + '" not resolved while preprocessing ' + Preprocessor.sourceName, {
																		source: originalSource
																});
																error = true;
																continue;
														}
												}
												break;
										}
						}
				}
				if (stack.length > 0) {
						console.error("Shader preprocessing reached the end of the file without encountering the necessary #endif to close a preceding #if, #ifdef, or #ifndef block. " + Preprocessor.sourceName);
						error = true;
				}
				if (error) {
						console.error('Failed to preprocess shader: ', {
								source: originalSource
						});
						return originalSource;
				}
				return source;
		}
		static _keep(stack) {
				for(var i = 0; i < stack.length; i++){
						if (!stack[i].keep) {
								return false;
						}
				}
				return true;
		}
		static evaluateAtomicExpression(expr, defines) {
				var error = false;
				expr = expr.trim();
				var invert = false;
				var definedMatch = DEFINED.exec(expr);
				if (definedMatch) {
						invert = definedMatch[1] === '!';
						expr = definedMatch[2].trim();
						var exists = defines.has(expr);
						return {
								result: invert ? !exists : exists,
								error
						};
				}
				var comparisonMatch = COMPARISON.exec(expr);
				if (comparisonMatch) {
						var _defines_get;
						var left = (_defines_get = defines.get(comparisonMatch[1].trim())) != null ? _defines_get : comparisonMatch[1].trim();
						var _defines_get1;
						var right = (_defines_get1 = defines.get(comparisonMatch[3].trim())) != null ? _defines_get1 : comparisonMatch[3].trim();
						var operator = comparisonMatch[2].trim();
						var result = false;
						switch(operator){
								case '==':
										result = left === right;
										break;
								case '!=':
										result = left !== right;
										break;
								case '<':
										result = left < right;
										break;
								case '<=':
										result = left <= right;
										break;
								case '>':
										result = left > right;
										break;
								case '>=':
										result = left >= right;
										break;
								default:
										error = true;
						}
						return {
								result,
								error
						};
				}
				var result1 = defines.has(expr);
				return {
						result: result1,
						error
				};
		}
		static evaluate(expression, defines) {
				var correct = INVALID.exec(expression) === null;
				var orSegments = expression.split('||');
				for (var orSegment of orSegments){
						var andSegments = orSegment.split('&&');
						var andResult = true;
						for (var andSegment of andSegments){
								var { result, error } = Preprocessor.evaluateAtomicExpression(andSegment.trim(), defines);
								if (!result || error) {
										andResult = false;
										break;
								}
						}
						if (andResult) {
								return {
										result: true,
										error: !correct
								};
						}
				}
				return {
						result: false,
						error: !correct
				};
		}
}

var gles3PS = "\n#ifndef outType_0\n#define outType_0 vec4\n#endif\nlayout(location = 0) out highp outType_0 pcFragColor0;\n#if COLOR_ATTACHMENT_1\nlayout(location = 1) out highp outType_1 pcFragColor1;\n#endif\n#if COLOR_ATTACHMENT_2\nlayout(location = 2) out highp outType_2 pcFragColor2;\n#endif\n#if COLOR_ATTACHMENT_3\nlayout(location = 3) out highp outType_3 pcFragColor3;\n#endif\n#if COLOR_ATTACHMENT_4\nlayout(location = 4) out highp outType_4 pcFragColor4;\n#endif\n#if COLOR_ATTACHMENT_5\nlayout(location = 5) out highp outType_5 pcFragColor5;\n#endif\n#if COLOR_ATTACHMENT_6\nlayout(location = 6) out highp outType_6 pcFragColor6;\n#endif\n#if COLOR_ATTACHMENT_7\nlayout(location = 7) out highp outType_7 pcFragColor7;\n#endif\n#define gl_FragColor pcFragColor0\n#define varying in\n#define texture2D texture\n#define texture2DBias texture\n#define textureCube texture\n#define texture2DProj textureProj\n#define texture2DLod textureLod\n#define texture2DProjLod textureProjLod\n#define textureCubeLod textureLod\n#define texture2DGrad textureGrad\n#define texture2DProjGrad textureProjGrad\n#define textureCubeGrad textureGrad\n#define utexture2D texture\n#define itexture2D texture\n#define texture2DLodEXT texture2DLodEXT_is_no_longer_supported_use_texture2DLod_instead\n#define texture2DProjLodEXT texture2DProjLodEXT_is_no_longer_supported_use_texture2DProjLod\n#define textureCubeLodEXT textureCubeLodEXT_is_no_longer_supported_use_textureCubeLod_instead\n#define texture2DGradEXT texture2DGradEXT_is_no_longer_supported_use_texture2DGrad_instead\n#define texture2DProjGradEXT texture2DProjGradEXT_is_no_longer_supported_use_texture2DProjGrad_instead\n#define textureCubeGradEXT textureCubeGradEXT_is_no_longer_supported_use_textureCubeGrad_instead\n#define textureShadow(res, uv) textureGrad(res, uv, vec2(1, 1), vec2(1, 1))\n#define SHADOWMAP_PASS(name) name\n#define SHADOWMAP_ACCEPT(name) sampler2DShadow name\n#define TEXTURE_PASS(name) name\n#define TEXTURE_ACCEPT(name) sampler2D name\n#define TEXTURE_ACCEPT_HIGHP(name) highp sampler2D name\n#define GL2\n";

var gles3VS = "\n#define attribute in\n#define varying out\n#define texture2D texture\n#define utexture2D texture\n#define itexture2D texture\n#define GL2\n#define VERTEXSHADER\n#define TEXTURE_PASS(name) name\n#define TEXTURE_ACCEPT(name) sampler2D name\n#define TEXTURE_ACCEPT_HIGHP(name) highp sampler2D name\n";

var webgpuPS = "\n#extension GL_EXT_samplerless_texture_functions : require\n#ifndef outType_0\n#define outType_0 vec4\n#endif\n#ifndef outType_1\n#define outType_1 vec4\n#endif\n#ifndef outType_2\n#define outType_2 vec4\n#endif\n#ifndef outType_3\n#define outType_3 vec4\n#endif\n#ifndef outType_4\n#define outType_4 vec4\n#endif\n#ifndef outType_5\n#define outType_5 vec4\n#endif\n#ifndef outType_6\n#define outType_6 vec4\n#endif\n#ifndef outType_7\n#define outType_7 vec4\n#endif\nlayout(location = 0) out highp outType_0 pcFragColor0;\nlayout(location = 1) out highp outType_1 pcFragColor1;\nlayout(location = 2) out highp outType_2 pcFragColor2;\nlayout(location = 3) out highp outType_3 pcFragColor3;\nlayout(location = 4) out highp outType_4 pcFragColor4;\nlayout(location = 5) out highp outType_5 pcFragColor5;\nlayout(location = 6) out highp outType_6 pcFragColor6;\nlayout(location = 7) out highp outType_7 pcFragColor7;\n#define gl_FragColor pcFragColor0\n#define texture2D(res, uv) texture(sampler2D(res, res ## _sampler), uv)\n#define texture2DBias(res, uv, bias) texture(sampler2D(res, res ## _sampler), uv, bias)\n#define texture2DLod(res, uv, lod) textureLod(sampler2D(res, res ## _sampler), uv, lod)\n#define textureCube(res, uv) texture(samplerCube(res, res ## _sampler), uv)\n#define textureCubeLod(res, uv, lod) textureLod(samplerCube(res, res ## _sampler), uv, lod)\n#define textureShadow(res, uv) textureLod(sampler2DShadow(res, res ## _sampler), uv, 0.0)\n#define itexture2D(res, uv) texture(isampler2D(res, res ## _sampler), uv)\n#define utexture2D(res, uv) texture(usampler2D(res, res ## _sampler), uv)\n#define texture2DLodEXT texture2DLodEXT_is_no_longer_supported_use_texture2DLod_instead\n#define texture2DProjLodEXT texture2DProjLodEXT_is_no_longer_supported_use_texture2DProjLod\n#define textureCubeLodEXT textureCubeLodEXT_is_no_longer_supported_use_textureCubeLod_instead\n#define texture2DGradEXT texture2DGradEXT_is_no_longer_supported_use_texture2DGrad_instead\n#define texture2DProjGradEXT texture2DProjGradEXT_is_no_longer_supported_use_texture2DProjGrad_instead\n#define textureCubeGradEXT textureCubeGradEXT_is_no_longer_supported_use_textureCubeGrad_instead\n#define SHADOWMAP_PASS(name) name, name ## _sampler\n#define SHADOWMAP_ACCEPT(name) texture2D name, sampler name ## _sampler\n#define TEXTURE_PASS(name) name, name ## _sampler\n#define TEXTURE_ACCEPT(name) texture2D name, sampler name ## _sampler\n#define TEXTURE_ACCEPT_HIGHP TEXTURE_ACCEPT\n#define GL2\n#define WEBGPU\n";

var webgpuVS = "\n#extension GL_EXT_samplerless_texture_functions : require\n#define texture2D(res, uv) texture(sampler2D(res, res ## _sampler), uv)\n#define itexture2D(res, uv) texture(isampler2D(res, res ## _sampler), uv)\n#define utexture2D(res, uv) texture(usampler2D(res, res ## _sampler), uv)\n#define TEXTURE_PASS(name) name, name ## _sampler\n#define TEXTURE_ACCEPT(name) texture2D name, sampler name ## _sampler\n#define TEXTURE_ACCEPT_HIGHP TEXTURE_ACCEPT\n#define GL2\n#define WEBGPU\n#define VERTEXSHADER\n#define gl_VertexID gl_VertexIndex\n#define gl_InstanceID gl_InstanceIndex\n";

var wgslFS = "\n";

var wgslVS = "\n#define VERTEXSHADER\n";

var sharedGLSL = "\nvec2 getGrabScreenPos(vec4 clipPos) {\n	vec2 uv = (clipPos.xy / clipPos.w) * 0.5 + 0.5;\n	#ifdef WEBGPU\n		uv.y = 1.0 - uv.y;\n	#endif\n	return uv;\n}\nvec2 getImageEffectUV(vec2 uv) {\n	#ifdef WEBGPU\n		uv.y = 1.0 - uv.y;\n	#endif\n	return uv;\n}\n";

var sharedWGSL = "\nfn getGrabScreenPos(clipPos: vec4<f32>) -> vec2<f32> {\n	var uv: vec2<f32> = (clipPos.xy / clipPos.w) * 0.5 + vec2<f32>(0.5);\n	uv.y = 1.0 - uv.y;\n	return uv;\n}\nfn getImageEffectUV(uv: vec2<f32>) -> vec2<f32> {\n	var modifiedUV: vec2<f32> = uv;\n	modifiedUV.y = 1.0 - modifiedUV.y;\n	return modifiedUV;\n}\nstruct WrappedF32 { @size(16) element: f32 }\nstruct WrappedI32 { @size(16) element: i32 }\nstruct WrappedU32 { @size(16) element: u32 }\nstruct WrappedVec2F { @size(16) element: vec2f }\nstruct WrappedVec2I { @size(16) element: vec2i }\nstruct WrappedVec2U { @size(16) element: vec2u }\n";

var _attrib2Semantic = {
		vertex_position: SEMANTIC_POSITION,
		vertex_normal: SEMANTIC_NORMAL,
		vertex_tangent: SEMANTIC_TANGENT,
		vertex_texCoord0: SEMANTIC_TEXCOORD0,
		vertex_texCoord1: SEMANTIC_TEXCOORD1,
		vertex_texCoord2: SEMANTIC_TEXCOORD2,
		vertex_texCoord3: SEMANTIC_TEXCOORD3,
		vertex_texCoord4: SEMANTIC_TEXCOORD4,
		vertex_texCoord5: SEMANTIC_TEXCOORD5,
		vertex_texCoord6: SEMANTIC_TEXCOORD6,
		vertex_texCoord7: SEMANTIC_TEXCOORD7,
		vertex_color: SEMANTIC_COLOR,
		vertex_boneIndices: SEMANTIC_BLENDINDICES,
		vertex_boneWeights: SEMANTIC_BLENDWEIGHT
};
class ShaderUtils {
		static createDefinition(device, options) {
				var getDefines = (gpu, gl2, isVertex, options)=>{
						var deviceIntro = device.isWebGPU ? gpu : gl2;
						var attachmentsDefine = '';
						if (!isVertex) {
								var _options_fragmentOutputTypes;
								var fragmentOutputTypes = (_options_fragmentOutputTypes = options.fragmentOutputTypes) != null ? _options_fragmentOutputTypes : 'vec4';
								if (!Array.isArray(fragmentOutputTypes)) {
										fragmentOutputTypes = [
												fragmentOutputTypes
										];
								}
								for(var i = 0; i < device.maxColorAttachments; i++){
										attachmentsDefine += "#define COLOR_ATTACHMENT_" + i + "\n";
										var _fragmentOutputTypes_i;
										var outType = (_fragmentOutputTypes_i = fragmentOutputTypes[i]) != null ? _fragmentOutputTypes_i : 'vec4';
										attachmentsDefine += "#define outType_" + i + " " + outType + "\n";
								}
						}
						return attachmentsDefine + deviceIntro;
				};
				var _options_name;
				var name = (_options_name = options.name) != null ? _options_name : 'Untitled';
				var vertCode;
				var fragCode;
				var vertexDefinesCode = ShaderUtils.getDefinesCode(device, options.vertexDefines);
				var fragmentDefinesCode = ShaderUtils.getDefinesCode(device, options.fragmentDefines);
				var wgsl = options.shaderLanguage === SHADERLANGUAGE_WGSL;
				if (wgsl) {
						vertCode = "\n                " + wgslVS + "\n                " + sharedWGSL + "\n                " + vertexDefinesCode + "\n                " + options.vertexCode + "\n            ";
						fragCode = "\n                " + wgslFS + "\n                " + sharedWGSL + "\n                " + fragmentDefinesCode + "\n                " + options.fragmentCode + "\n            ";
				} else {
						vertCode = ShaderUtils.versionCode(device) + getDefines(webgpuVS, gles3VS, true, options) + vertexDefinesCode + ShaderUtils.precisionCode(device) + "\n                " + sharedGLSL + "\n                " + ShaderUtils.getShaderNameCode(name) + "\n                " + options.vertexCode;
						fragCode = (options.fragmentPreamble || '') + ShaderUtils.versionCode(device) + getDefines(webgpuPS, gles3PS, false, options) + fragmentDefinesCode + ShaderUtils.precisionCode(device) + "\n                " + sharedGLSL + "\n                " + ShaderUtils.getShaderNameCode(name) + "\n                " + (options.fragmentCode || ShaderUtils.dummyFragmentCode());
				}
				var _options_shaderLanguage;
				return {
						name: name,
						shaderLanguage: (_options_shaderLanguage = options.shaderLanguage) != null ? _options_shaderLanguage : SHADERLANGUAGE_GLSL,
						attributes: options.attributes,
						vshader: vertCode,
						vincludes: options.vertexIncludes,
						fincludes: options.fragmentIncludes,
						fshader: fragCode,
						useTransformFeedback: options.useTransformFeedback,
						meshUniformBufferFormat: options.meshUniformBufferFormat,
						meshBindGroupFormat: options.meshBindGroupFormat
				};
		}
		static getDefinesCode(device, defines) {
				var code = '';
				device.capsDefines.forEach((value, key)=>{
						code += "#define " + key + " " + value + "\n";
				});
				code += '\n';
				defines == null ? void 0 : defines.forEach((value, key)=>{
						code += "#define " + key + " " + value + "\n";
				});
				code += '\n';
				return code;
		}
		static getShaderNameCode(name) {
				return "#define SHADER_NAME " + name + "\n";
		}
		static dummyFragmentCode() {
				return 'void main(void) {gl_FragColor = vec4(0.0);}';
		}
		static versionCode(device) {
				return device.isWebGPU ? '#version 450\n' : '#version 300 es\n';
		}
		static precisionCode(device, forcePrecision) {
				if (forcePrecision && forcePrecision !== 'highp' && forcePrecision !== 'mediump' && forcePrecision !== 'lowp') {
						forcePrecision = null;
				}
				if (forcePrecision) {
						if (forcePrecision === 'highp' && device.maxPrecision !== 'highp') {
								forcePrecision = 'mediump';
						}
						if (forcePrecision === 'mediump' && device.maxPrecision === 'lowp') {
								forcePrecision = 'lowp';
						}
				}
				var precision = forcePrecision ? forcePrecision : device.precision;
				var code = "\n            precision " + precision + " float;\n            precision " + precision + " int;\n            precision " + precision + " usampler2D;\n            precision " + precision + " isampler2D;\n            precision " + precision + " sampler2DShadow;\n            precision " + precision + " samplerCubeShadow;\n            precision " + precision + " sampler2DArray;\n        ";
				return code;
		}
		static collectAttributes(vsCode) {
				var attribs = {};
				var attrs = 0;
				var found = vsCode.indexOf('attribute');
				while(found >= 0){
						if (found > 0 && vsCode[found - 1] === '/') break;
						var ignore = false;
						if (found > 0) {
								var startOfLine = vsCode.lastIndexOf('\n', found);
								startOfLine = startOfLine !== -1 ? startOfLine + 1 : 0;
								var lineStartString = vsCode.substring(startOfLine, found);
								if (lineStartString.includes('#')) {
										ignore = true;
								}
						}
						if (!ignore) {
								var endOfLine = vsCode.indexOf(';', found);
								var startOfAttribName = vsCode.lastIndexOf(' ', endOfLine);
								var attribName = vsCode.substring(startOfAttribName + 1, endOfLine);
								if (attribs[attribName]) ; else {
										var semantic = _attrib2Semantic[attribName];
										if (semantic !== undefined) {
												attribs[attribName] = semantic;
										} else {
												attribs[attribName] = "ATTR" + attrs;
												attrs++;
										}
								}
						}
						found = vsCode.indexOf('attribute', found + 1);
				}
				return attribs;
		}
}

var id$5 = 0;
class Shader {
		init() {
				this.ready = false;
				this.failed = false;
		}
		get label() {
				return "Shader Id " + this.id + " (" + (this.definition.shaderLanguage === SHADERLANGUAGE_WGSL ? 'WGSL' : 'GLSL') + ") " + this.name;
		}
		destroy() {
				this.device.onDestroyShader(this);
				this.impl.destroy(this);
		}
		loseContext() {
				this.init();
				this.impl.loseContext();
		}
		restoreContext() {
				this.impl.restoreContext(this.device, this);
		}
		constructor(graphicsDevice, definition){
				this.attributes = new Map();
				this.id = id$5++;
				this.device = graphicsDevice;
				this.definition = definition;
				this.name = definition.name || 'Untitled';
				this.init();
				if (definition.cshader) ; else {
						var wgsl = definition.shaderLanguage === SHADERLANGUAGE_WGSL;
						definition.vshader = Preprocessor.run(definition.vshader, definition.vincludes, {
								sourceName: "vertex shader for " + this.label,
								stripDefines: wgsl
						});
						if (definition.shaderLanguage === SHADERLANGUAGE_GLSL) {
								var _definition;
								var _attributes;
								(_attributes = (_definition = definition).attributes) != null ? _attributes : _definition.attributes = ShaderUtils.collectAttributes(definition.vshader);
						}
						var stripUnusedColorAttachments = graphicsDevice.isWebGL2 && (platform.name === 'osx' || platform.name === 'ios');
						definition.fshader = Preprocessor.run(definition.fshader, definition.fincludes, {
								stripUnusedColorAttachments,
								stripDefines: wgsl,
								sourceName: "fragment shader for " + this.label
						});
				}
				this.impl = graphicsDevice.createShaderImpl(this);
		}
}

class DynamicBufferAllocation {
}

var _updateFunctions = [];
_updateFunctions[UNIFORMTYPE_FLOAT] = function(uniformBuffer, value, offset) {
		var dst = uniformBuffer.storageFloat32;
		dst[offset] = value;
};
_updateFunctions[UNIFORMTYPE_VEC2] = (uniformBuffer, value, offset)=>{
		var dst = uniformBuffer.storageFloat32;
		dst[offset] = value[0];
		dst[offset + 1] = value[1];
};
_updateFunctions[UNIFORMTYPE_VEC3] = (uniformBuffer, value, offset)=>{
		var dst = uniformBuffer.storageFloat32;
		dst[offset] = value[0];
		dst[offset + 1] = value[1];
		dst[offset + 2] = value[2];
};
_updateFunctions[UNIFORMTYPE_VEC4] = (uniformBuffer, value, offset)=>{
		var dst = uniformBuffer.storageFloat32;
		dst[offset] = value[0];
		dst[offset + 1] = value[1];
		dst[offset + 2] = value[2];
		dst[offset + 3] = value[3];
};
_updateFunctions[UNIFORMTYPE_INT] = function(uniformBuffer, value, offset) {
		var dst = uniformBuffer.storageInt32;
		dst[offset] = value;
};
_updateFunctions[UNIFORMTYPE_IVEC2] = function(uniformBuffer, value, offset) {
		var dst = uniformBuffer.storageInt32;
		dst[offset] = value[0];
		dst[offset + 1] = value[1];
};
_updateFunctions[UNIFORMTYPE_IVEC3] = function(uniformBuffer, value, offset) {
		var dst = uniformBuffer.storageInt32;
		dst[offset] = value[0];
		dst[offset + 1] = value[1];
		dst[offset + 2] = value[2];
};
_updateFunctions[UNIFORMTYPE_IVEC4] = function(uniformBuffer, value, offset) {
		var dst = uniformBuffer.storageInt32;
		dst[offset] = value[0];
		dst[offset + 1] = value[1];
		dst[offset + 2] = value[2];
		dst[offset + 3] = value[3];
};
_updateFunctions[UNIFORMTYPE_MAT2] = (uniformBuffer, value, offset)=>{
		var dst = uniformBuffer.storageFloat32;
		dst[offset] = value[0];
		dst[offset + 1] = value[1];
		dst[offset + 4] = value[2];
		dst[offset + 5] = value[3];
		dst[offset + 8] = value[4];
		dst[offset + 9] = value[5];
};
_updateFunctions[UNIFORMTYPE_MAT3] = (uniformBuffer, value, offset)=>{
		var dst = uniformBuffer.storageFloat32;
		dst[offset] = value[0];
		dst[offset + 1] = value[1];
		dst[offset + 2] = value[2];
		dst[offset + 4] = value[3];
		dst[offset + 5] = value[4];
		dst[offset + 6] = value[5];
		dst[offset + 8] = value[6];
		dst[offset + 9] = value[7];
		dst[offset + 10] = value[8];
};
_updateFunctions[UNIFORMTYPE_FLOATARRAY] = function(uniformBuffer, value, offset, count) {
		var dst = uniformBuffer.storageFloat32;
		for(var i = 0; i < count; i++){
				dst[offset + i * 4] = value[i];
		}
};
_updateFunctions[UNIFORMTYPE_VEC2ARRAY] = (uniformBuffer, value, offset, count)=>{
		var dst = uniformBuffer.storageFloat32;
		for(var i = 0; i < count; i++){
				dst[offset + i * 4] = value[i * 2];
				dst[offset + i * 4 + 1] = value[i * 2 + 1];
		}
};
_updateFunctions[UNIFORMTYPE_VEC3ARRAY] = (uniformBuffer, value, offset, count)=>{
		var dst = uniformBuffer.storageFloat32;
		for(var i = 0; i < count; i++){
				dst[offset + i * 4] = value[i * 3];
				dst[offset + i * 4 + 1] = value[i * 3 + 1];
				dst[offset + i * 4 + 2] = value[i * 3 + 2];
		}
};
_updateFunctions[UNIFORMTYPE_UINT] = (uniformBuffer, value, offset, count)=>{
		var dst = uniformBuffer.storageUint32;
		dst[offset] = value;
};
_updateFunctions[UNIFORMTYPE_UVEC2] = (uniformBuffer, value, offset, count)=>{
		var dst = uniformBuffer.storageUint32;
		dst[offset] = value[0];
		dst[offset + 1] = value[1];
};
_updateFunctions[UNIFORMTYPE_UVEC3] = (uniformBuffer, value, offset, count)=>{
		var dst = uniformBuffer.storageUint32;
		dst[offset] = value[0];
		dst[offset + 1] = value[1];
		dst[offset + 2] = value[2];
};
_updateFunctions[UNIFORMTYPE_UVEC4] = (uniformBuffer, value, offset, count)=>{
		var dst = uniformBuffer.storageUint32;
		dst[offset] = value[0];
		dst[offset + 1] = value[1];
		dst[offset + 2] = value[2];
		dst[offset + 3] = value[3];
};
_updateFunctions[UNIFORMTYPE_INTARRAY] = function(uniformBuffer, value, offset, count) {
		var dst = uniformBuffer.storageInt32;
		for(var i = 0; i < count; i++){
				dst[offset + i * 4] = value[i];
		}
};
_updateFunctions[UNIFORMTYPE_BOOLARRAY] = _updateFunctions[UNIFORMTYPE_INTARRAY];
_updateFunctions[UNIFORMTYPE_UINTARRAY] = function(uniformBuffer, value, offset, count) {
		var dst = uniformBuffer.storageUint32;
		for(var i = 0; i < count; i++){
				dst[offset + i * 4] = value[i];
		}
};
_updateFunctions[UNIFORMTYPE_IVEC2ARRAY] = (uniformBuffer, value, offset, count)=>{
		var dst = uniformBuffer.storageInt32;
		for(var i = 0; i < count; i++){
				dst[offset + i * 4] = value[i * 2];
				dst[offset + i * 4 + 1] = value[i * 2 + 1];
		}
};
_updateFunctions[UNIFORMTYPE_BVEC2ARRAY] = _updateFunctions[UNIFORMTYPE_IVEC2ARRAY];
_updateFunctions[UNIFORMTYPE_UVEC2ARRAY] = (uniformBuffer, value, offset, count)=>{
		var dst = uniformBuffer.storageUint32;
		for(var i = 0; i < count; i++){
				dst[offset + i * 4] = value[i * 2];
				dst[offset + i * 4 + 1] = value[i * 2 + 1];
		}
};
_updateFunctions[UNIFORMTYPE_IVEC3ARRAY] = (uniformBuffer, value, offset, count)=>{
		var dst = uniformBuffer.storageInt32;
		for(var i = 0; i < count; i++){
				dst[offset + i * 4] = value[i * 3];
				dst[offset + i * 4 + 1] = value[i * 3 + 1];
				dst[offset + i * 4 + 2] = value[i * 3 + 2];
		}
};
_updateFunctions[UNIFORMTYPE_BVEC3ARRAY] = _updateFunctions[UNIFORMTYPE_IVEC3ARRAY];
_updateFunctions[UNIFORMTYPE_UVEC3ARRAY] = (uniformBuffer, value, offset, count)=>{
		var dst = uniformBuffer.storageUint32;
		for(var i = 0; i < count; i++){
				dst[offset + i * 4] = value[i * 3];
				dst[offset + i * 4 + 1] = value[i * 3 + 1];
				dst[offset + i * 4 + 2] = value[i * 3 + 2];
		}
};
class UniformBuffer {
		destroy() {
				if (this.persistent) {
						var device = this.device;
						this.impl.destroy(device);
						device._vram.ub -= this.format.byteSize;
				}
		}
		get offset() {
				return this.persistent ? 0 : this.allocation.offset;
		}
		assignStorage(storage) {
				this.storageInt32 = storage;
				this.storageUint32 = new Uint32Array(storage.buffer, storage.byteOffset, storage.byteLength / 4);
				this.storageFloat32 = new Float32Array(storage.buffer, storage.byteOffset, storage.byteLength / 4);
		}
		loseContext() {
				var _this_impl;
				(_this_impl = this.impl) == null ? void 0 : _this_impl.loseContext();
		}
		setUniform(uniformFormat, value) {
				var offset = uniformFormat.offset;
				if (value !== null && value !== undefined) {
						var updateFunction = _updateFunctions[uniformFormat.updateType];
						if (updateFunction) {
								updateFunction(this, value, offset, uniformFormat.count);
						} else {
								this.storageFloat32.set(value, offset);
						}
				}
		}
		set(name, value) {
				var uniformFormat = this.format.map.get(name);
				if (uniformFormat) {
						this.setUniform(uniformFormat, value);
				}
		}
		startUpdate(dynamicBindGroup) {
				if (!this.persistent) {
						var allocation = this.allocation;
						var oldGpuBuffer = allocation.gpuBuffer;
						this.device.dynamicBuffers.alloc(allocation, this.format.byteSize);
						this.assignStorage(allocation.storage);
						if (dynamicBindGroup) {
								dynamicBindGroup.bindGroup = allocation.gpuBuffer.getBindGroup(this);
								dynamicBindGroup.offsets[0] = allocation.offset;
						}
						if (oldGpuBuffer !== allocation.gpuBuffer) {
								this.renderVersionDirty = this.device.renderVersion;
						}
				}
		}
		endUpdate() {
				if (this.persistent) {
						this.impl.unlock(this);
				} else {
						this.storageFloat32 = null;
						this.storageInt32 = null;
				}
		}
		update(dynamicBindGroup) {
				this.startUpdate(dynamicBindGroup);
				var uniforms = this.format.uniforms;
				for(var i = 0; i < uniforms.length; i++){
						var value = uniforms[i].scopeId.value;
						this.setUniform(uniforms[i], value);
				}
				this.endUpdate();
		}
		constructor(graphicsDevice, format, persistent = true){
				this.renderVersionDirty = 0;
				this.device = graphicsDevice;
				this.format = format;
				this.persistent = persistent;
				if (persistent) {
						this.impl = graphicsDevice.createUniformBufferImpl(this);
						var storage = new ArrayBuffer(format.byteSize);
						this.assignStorage(new Int32Array(storage));
						graphicsDevice._vram.ub += this.format.byteSize;
				} else {
						this.allocation = new DynamicBufferAllocation();
				}
		}
}

class GpuProfiler {
		loseContext() {
				this.pastFrameAllocations.clear();
		}
		set enabled(value) {
				this._enableRequest = value;
		}
		get enabled() {
				return this._enableRequest;
		}
		processEnableRequest() {
				if (this._enableRequest !== this._enabled) {
						this._enabled = this._enableRequest;
						if (!this._enabled) {
								this._frameTime = 0;
						}
				}
		}
		request(renderVersion) {
				this.pastFrameAllocations.set(renderVersion, this.frameAllocations);
				this.frameAllocations = [];
		}
		report(renderVersion, timings) {
				if (timings) {
						var allocations = this.pastFrameAllocations.get(renderVersion);
						if (timings.length > 0) {
								this._frameTime = timings[0];
						}
						if (Tracing.get(TRACEID_GPU_TIMINGS)) {
								var total = 0;
								for(var i = 0; i < allocations.length; ++i){
										allocations[i];
										total += timings[i];
								}
						}
				}
				this.pastFrameAllocations.delete(renderVersion);
		}
		getSlot(name) {
				var slot = this.frameAllocations.length;
				this.frameAllocations.push(name);
				return slot;
		}
		get slotCount() {
				return this.frameAllocations.length;
		}
		constructor(){
				this.frameAllocations = [];
				this.pastFrameAllocations = new Map();
				this._enabled = false;
				this._enableRequest = false;
				this._frameTime = 0;
		}
}

class WebglBuffer {
		destroy(device) {
				if (this.bufferId) {
						device.gl.deleteBuffer(this.bufferId);
						this.bufferId = null;
				}
		}
		get initialized() {
				return !!this.bufferId;
		}
		loseContext() {
				this.bufferId = null;
		}
		unlock(device, usage, target, storage) {
				var gl = device.gl;
				if (!this.bufferId) {
						var glUsage;
						switch(usage){
								case BUFFER_STATIC:
										glUsage = gl.STATIC_DRAW;
										break;
								case BUFFER_DYNAMIC:
										glUsage = gl.DYNAMIC_DRAW;
										break;
								case BUFFER_STREAM:
										glUsage = gl.STREAM_DRAW;
										break;
								case BUFFER_GPUDYNAMIC:
										glUsage = gl.DYNAMIC_COPY;
										break;
						}
						this.bufferId = gl.createBuffer();
						gl.bindBuffer(target, this.bufferId);
						gl.bufferData(target, storage, glUsage);
				} else {
						gl.bindBuffer(target, this.bufferId);
						gl.bufferSubData(target, 0, storage);
				}
		}
		constructor(){
				this.bufferId = null;
		}
}

class WebglVertexBuffer extends WebglBuffer {
		destroy(device) {
				super.destroy(device);
				device.unbindVertexArray();
		}
		loseContext() {
				super.loseContext();
				this.vao = null;
		}
		unlock(vertexBuffer) {
				var device = vertexBuffer.device;
				super.unlock(device, vertexBuffer.usage, device.gl.ARRAY_BUFFER, vertexBuffer.storage);
		}
		constructor(...args){
				super(...args), this.vao = null;
		}
}

class WebglIndexBuffer extends WebglBuffer {
		unlock(indexBuffer) {
				var device = indexBuffer.device;
				super.unlock(device, indexBuffer.usage, device.gl.ELEMENT_ARRAY_BUFFER, indexBuffer.storage);
		}
		constructor(indexBuffer){
				super();
				var gl = indexBuffer.device.gl;
				var format = indexBuffer.format;
				if (format === INDEXFORMAT_UINT8) {
						this.glFormat = gl.UNSIGNED_BYTE;
				} else if (format === INDEXFORMAT_UINT16) {
						this.glFormat = gl.UNSIGNED_SHORT;
				} else if (format === INDEXFORMAT_UINT32) {
						this.glFormat = gl.UNSIGNED_INT;
				}
		}
}

class WebglShaderInput {
		constructor(graphicsDevice, name, type, locationId){
				this.locationId = locationId;
				this.scopeId = graphicsDevice.scope.resolve(name);
				this.version = new Version();
				if (name.substring(name.length - 3) === '[0]') {
						switch(type){
								case UNIFORMTYPE_FLOAT:
										type = UNIFORMTYPE_FLOATARRAY;
										break;
								case UNIFORMTYPE_INT:
										type = UNIFORMTYPE_INTARRAY;
										break;
								case UNIFORMTYPE_UINT:
										type = UNIFORMTYPE_UINTARRAY;
										break;
								case UNIFORMTYPE_BOOL:
										type = UNIFORMTYPE_BOOLARRAY;
										break;
								case UNIFORMTYPE_VEC2:
										type = UNIFORMTYPE_VEC2ARRAY;
										break;
								case UNIFORMTYPE_IVEC2:
										type = UNIFORMTYPE_IVEC2ARRAY;
										break;
								case UNIFORMTYPE_UVEC2:
										type = UNIFORMTYPE_UVEC2ARRAY;
										break;
								case UNIFORMTYPE_BVEC2:
										type = UNIFORMTYPE_BVEC2ARRAY;
										break;
								case UNIFORMTYPE_VEC3:
										type = UNIFORMTYPE_VEC3ARRAY;
										break;
								case UNIFORMTYPE_IVEC3:
										type = UNIFORMTYPE_IVEC3ARRAY;
										break;
								case UNIFORMTYPE_UVEC3:
										type = UNIFORMTYPE_UVEC3ARRAY;
										break;
								case UNIFORMTYPE_BVEC3:
										type = UNIFORMTYPE_BVEC3ARRAY;
										break;
								case UNIFORMTYPE_VEC4:
										type = UNIFORMTYPE_VEC4ARRAY;
										break;
								case UNIFORMTYPE_IVEC4:
										type = UNIFORMTYPE_IVEC4ARRAY;
										break;
								case UNIFORMTYPE_UVEC4:
										type = UNIFORMTYPE_UVEC4ARRAY;
										break;
								case UNIFORMTYPE_BVEC4:
										type = UNIFORMTYPE_BVEC4ARRAY;
										break;
						}
				}
				this.dataType = type;
				this.value = [
						null,
						null,
						null,
						null
				];
				this.array = [];
		}
}

var _vertexShaderBuiltins = new Set([
		'gl_VertexID',
		'gl_InstanceID',
		'gl_DrawID',
		'gl_BaseVertex',
		'gl_BaseInstance'
]);
class CompiledShaderCache {
		destroy(device) {
				this.map.forEach((shader)=>{
						device.gl.deleteShader(shader);
				});
		}
		loseContext(device) {
				this.map.clear();
		}
		constructor(){
				this.map = new Map();
		}
}
var _vertexShaderCache = new DeviceCache();
var _fragmentShaderCache = new DeviceCache();
class WebglShader {
		destroy(shader) {
				if (this.glProgram) {
						shader.device.gl.deleteProgram(this.glProgram);
						this.glProgram = null;
				}
		}
		init() {
				this.uniforms = [];
				this.samplers = [];
				this.attributes = [];
				this.glProgram = null;
				this.glVertexShader = null;
				this.glFragmentShader = null;
		}
		loseContext() {
				this.init();
		}
		restoreContext(device, shader) {
				this.compile(device, shader);
				this.link(device, shader);
		}
		compile(device, shader) {
				var definition = shader.definition;
				this.glVertexShader = this._compileShaderSource(device, definition.vshader, true);
				this.glFragmentShader = this._compileShaderSource(device, definition.fshader, false);
		}
		link(device, shader) {
				if (this.glProgram) {
						return;
				}
				var gl = device.gl;
				if (gl.isContextLost()) {
						return;
				}
				var glProgram = gl.createProgram();
				this.glProgram = glProgram;
				gl.attachShader(glProgram, this.glVertexShader);
				gl.attachShader(glProgram, this.glFragmentShader);
				var definition = shader.definition;
				var attrs = definition.attributes;
				if (definition.useTransformFeedback) {
						var outNames = [];
						for(var attr in attrs){
								if (attrs.hasOwnProperty(attr)) {
										outNames.push("out_" + attr);
								}
						}
						gl.transformFeedbackVaryings(glProgram, outNames, gl.INTERLEAVED_ATTRIBS);
				}
				for(var attr1 in attrs){
						if (attrs.hasOwnProperty(attr1)) {
								var semantic = attrs[attr1];
								var loc = semanticToLocation[semantic];
								gl.bindAttribLocation(glProgram, loc, attr1);
						}
				}
				gl.linkProgram(glProgram);
		}
		_compileShaderSource(device, src, isVertexShader) {
				var gl = device.gl;
				if (gl.isContextLost()) {
						return null;
				}
				var shaderDeviceCache = isVertexShader ? _vertexShaderCache : _fragmentShaderCache;
				var shaderCache = shaderDeviceCache.get(device, ()=>{
						return new CompiledShaderCache();
				});
				var glShader = shaderCache.map.get(src);
				if (!glShader) {
						glShader = gl.createShader(isVertexShader ? gl.VERTEX_SHADER : gl.FRAGMENT_SHADER);
						gl.shaderSource(glShader, src);
						gl.compileShader(glShader);
						shaderCache.map.set(src, glShader);
				}
				return glShader;
		}
		finalize(device, shader) {
				var gl = device.gl;
				if (gl.isContextLost()) {
						return true;
				}
				var glProgram = this.glProgram;
				var definition = shader.definition;
				var linkStatus = gl.getProgramParameter(glProgram, gl.LINK_STATUS);
				if (!linkStatus) {
						if (!this._isCompiled(device, shader, this.glVertexShader, definition.vshader, 'vertex')) {
								return false;
						}
						if (!this._isCompiled(device, shader, this.glFragmentShader, definition.fshader, 'fragment')) {
								return false;
						}
						var message = "Failed to link shader program. Error: " + gl.getProgramInfoLog(glProgram);
						console.error(message);
						return false;
				}
				var numAttributes = gl.getProgramParameter(glProgram, gl.ACTIVE_ATTRIBUTES);
				shader.attributes.clear();
				for(var i = 0; i < numAttributes; i++){
						var info = gl.getActiveAttrib(glProgram, i);
						var location = gl.getAttribLocation(glProgram, info.name);
						if (_vertexShaderBuiltins.has(info.name)) {
								continue;
						}
						if (definition.attributes[info.name] === undefined) {
								console.error('Vertex shader attribute "' + info.name + '" is not mapped to a semantic in shader definition, shader [' + shader.label + "]", shader);
								shader.failed = true;
						} else {
								shader.attributes.set(location, info.name);
						}
				}
				var samplerTypes = device._samplerTypes;
				var numUniforms = gl.getProgramParameter(glProgram, gl.ACTIVE_UNIFORMS);
				for(var i1 = 0; i1 < numUniforms; i1++){
						var info1 = gl.getActiveUniform(glProgram, i1);
						var location1 = gl.getUniformLocation(glProgram, info1.name);
						var shaderInput = new WebglShaderInput(device, info1.name, device.pcUniformType[info1.type], location1);
						if (samplerTypes.has(info1.type)) {
								this.samplers.push(shaderInput);
						} else {
								this.uniforms.push(shaderInput);
						}
				}
				shader.ready = true;
				return true;
		}
		_isCompiled(device, shader, glShader, source, shaderType) {
				var gl = device.gl;
				if (!gl.getShaderParameter(glShader, gl.COMPILE_STATUS)) {
						var infoLog = gl.getShaderInfoLog(glShader);
						var [code, error] = this._processError(source, infoLog);
						var message = "Failed to compile " + shaderType + " shader:\n\n" + infoLog + "\n" + code + " while rendering " + void 0;
						console.error(message);
						return false;
				}
				return true;
		}
		isLinked(device) {
				var { extParallelShaderCompile } = device;
				if (extParallelShaderCompile) {
						return device.gl.getProgramParameter(this.glProgram, extParallelShaderCompile.COMPLETION_STATUS_KHR);
				}
				return true;
		}
		_processError(src, infoLog) {
				var error = {};
				var code = '';
				if (src) {
						var lines = src.split('\n');
						var from = 0;
						var to = lines.length;
						if (infoLog && infoLog.startsWith('ERROR:')) {
								var match = infoLog.match(/^ERROR:\s(\d+):(\d+):\s*(.+)/);
								if (match) {
										error.message = match[3];
										error.line = parseInt(match[2], 10);
										from = Math.max(0, error.line - 6);
										to = Math.min(lines.length, error.line + 5);
								}
						}
						for(var i = from; i < to; i++){
								var linePrefix = i + 1 === error.line ? '> ' : '  ';
								code += "" + linePrefix + (i + 1) + ":	" + lines[i] + "\n";
						}
						error.source = src;
				}
				return [
						code,
						error
				];
		}
		constructor(shader){
				this.compileDuration = 0;
				this.init();
				this.compile(shader.device, shader);
				this.link(shader.device, shader);
				shader.device.shaders.push(shader);
		}
}

function downsampleImage(image, size) {
		var srcW = image.width;
		var srcH = image.height;
		if (srcW > size || srcH > size) {
				var scale = size / Math.max(srcW, srcH);
				var dstW = Math.floor(srcW * scale);
				var dstH = Math.floor(srcH * scale);
				var canvas = document.createElement('canvas');
				canvas.width = dstW;
				canvas.height = dstH;
				var context = canvas.getContext('2d');
				context.drawImage(image, 0, 0, srcW, srcH, 0, 0, dstW, dstH);
				return canvas;
		}
		return image;
}
class WebglTexture {
		destroy(device) {
				if (this._glTexture) {
						for(var i = 0; i < device.textureUnits.length; i++){
								var textureUnit = device.textureUnits[i];
								for(var j = 0; j < textureUnit.length; j++){
										if (textureUnit[j] === this._glTexture) {
												textureUnit[j] = null;
										}
								}
						}
						device.gl.deleteTexture(this._glTexture);
						this._glTexture = null;
				}
		}
		loseContext() {
				this._glTexture = null;
		}
		propertyChanged(flag) {
				this.dirtyParameterFlags |= flag;
		}
		initialize(device, texture) {
				var gl = device.gl;
				this._glTexture = gl.createTexture();
				this._glTarget = texture._cubemap ? gl.TEXTURE_CUBE_MAP : texture._volume ? gl.TEXTURE_3D : texture.array ? gl.TEXTURE_2D_ARRAY : gl.TEXTURE_2D;
				switch(texture._format){
						case PIXELFORMAT_A8:
								this._glFormat = gl.ALPHA;
								this._glInternalFormat = gl.ALPHA;
								this._glPixelType = gl.UNSIGNED_BYTE;
								break;
						case PIXELFORMAT_L8:
								this._glFormat = gl.LUMINANCE;
								this._glInternalFormat = gl.LUMINANCE;
								this._glPixelType = gl.UNSIGNED_BYTE;
								break;
						case PIXELFORMAT_LA8:
								this._glFormat = gl.LUMINANCE_ALPHA;
								this._glInternalFormat = gl.LUMINANCE_ALPHA;
								this._glPixelType = gl.UNSIGNED_BYTE;
								break;
						case PIXELFORMAT_R8:
								this._glFormat = gl.RED;
								this._glInternalFormat = gl.R8;
								this._glPixelType = gl.UNSIGNED_BYTE;
								break;
						case PIXELFORMAT_RG8:
								this._glFormat = gl.RG;
								this._glInternalFormat = gl.RG8;
								this._glPixelType = gl.UNSIGNED_BYTE;
								break;
						case PIXELFORMAT_RGB565:
								this._glFormat = gl.RGB;
								this._glInternalFormat = gl.RGB;
								this._glPixelType = gl.UNSIGNED_SHORT_5_6_5;
								break;
						case PIXELFORMAT_RGBA5551:
								this._glFormat = gl.RGBA;
								this._glInternalFormat = gl.RGBA;
								this._glPixelType = gl.UNSIGNED_SHORT_5_5_5_1;
								break;
						case PIXELFORMAT_RGBA4:
								this._glFormat = gl.RGBA;
								this._glInternalFormat = gl.RGBA;
								this._glPixelType = gl.UNSIGNED_SHORT_4_4_4_4;
								break;
						case PIXELFORMAT_RGB8:
								this._glFormat = gl.RGB;
								this._glInternalFormat = gl.RGB8;
								this._glPixelType = gl.UNSIGNED_BYTE;
								break;
						case PIXELFORMAT_RGBA8:
								this._glFormat = gl.RGBA;
								this._glInternalFormat = gl.RGBA8;
								this._glPixelType = gl.UNSIGNED_BYTE;
								break;
						case PIXELFORMAT_BGRA8:
						case PIXELFORMAT_SBGRA8:
								break;
						case PIXELFORMAT_DXT1:
								this._glFormat = gl.RGB;
								this._glInternalFormat = device.extCompressedTextureS3TC.COMPRESSED_RGB_S3TC_DXT1_EXT;
								break;
						case PIXELFORMAT_DXT3:
								this._glFormat = gl.RGBA;
								this._glInternalFormat = device.extCompressedTextureS3TC.COMPRESSED_RGBA_S3TC_DXT3_EXT;
								break;
						case PIXELFORMAT_DXT5:
								this._glFormat = gl.RGBA;
								this._glInternalFormat = device.extCompressedTextureS3TC.COMPRESSED_RGBA_S3TC_DXT5_EXT;
								break;
						case PIXELFORMAT_ETC1:
								this._glFormat = gl.RGB;
								this._glInternalFormat = device.extCompressedTextureETC1.COMPRESSED_RGB_ETC1_WEBGL;
								break;
						case PIXELFORMAT_PVRTC_2BPP_RGB_1:
								this._glFormat = gl.RGB;
								this._glInternalFormat = device.extCompressedTexturePVRTC.COMPRESSED_RGB_PVRTC_2BPPV1_IMG;
								break;
						case PIXELFORMAT_PVRTC_2BPP_RGBA_1:
								this._glFormat = gl.RGBA;
								this._glInternalFormat = device.extCompressedTexturePVRTC.COMPRESSED_RGBA_PVRTC_2BPPV1_IMG;
								break;
						case PIXELFORMAT_PVRTC_4BPP_RGB_1:
								this._glFormat = gl.RGB;
								this._glInternalFormat = device.extCompressedTexturePVRTC.COMPRESSED_RGB_PVRTC_4BPPV1_IMG;
								break;
						case PIXELFORMAT_PVRTC_4BPP_RGBA_1:
								this._glFormat = gl.RGBA;
								this._glInternalFormat = device.extCompressedTexturePVRTC.COMPRESSED_RGBA_PVRTC_4BPPV1_IMG;
								break;
						case PIXELFORMAT_ETC2_RGB:
								this._glFormat = gl.RGB;
								this._glInternalFormat = device.extCompressedTextureETC.COMPRESSED_RGB8_ETC2;
								break;
						case PIXELFORMAT_ETC2_RGBA:
								this._glFormat = gl.RGBA;
								this._glInternalFormat = device.extCompressedTextureETC.COMPRESSED_RGBA8_ETC2_EAC;
								break;
						case PIXELFORMAT_ASTC_4x4:
								this._glFormat = gl.RGBA;
								this._glInternalFormat = device.extCompressedTextureASTC.COMPRESSED_RGBA_ASTC_4x4_KHR;
								break;
						case PIXELFORMAT_ATC_RGB:
								this._glFormat = gl.RGB;
								this._glInternalFormat = device.extCompressedTextureATC.COMPRESSED_RGB_ATC_WEBGL;
								break;
						case PIXELFORMAT_ATC_RGBA:
								this._glFormat = gl.RGBA;
								this._glInternalFormat = device.extCompressedTextureATC.COMPRESSED_RGBA_ATC_INTERPOLATED_ALPHA_WEBGL;
								break;
						case PIXELFORMAT_BC6F:
								this._glFormat = gl.RGB;
								this._glInternalFormat = device.extTextureCompressionBPTC.COMPRESSED_RGB_BPTC_SIGNED_FLOAT_EXT;
								break;
						case PIXELFORMAT_BC6UF:
								this._glFormat = gl.RGB;
								this._glInternalFormat = device.extTextureCompressionBPTC.COMPRESSED_RGB_BPTC_UNSIGNED_FLOAT_EXT;
								break;
						case PIXELFORMAT_BC7:
								this._glFormat = gl.RGBA;
								this._glInternalFormat = device.extTextureCompressionBPTC.COMPRESSED_RGBA_BPTC_UNORM_EXT;
								break;
						case PIXELFORMAT_DXT1_SRGB:
								this._glFormat = gl.SRGB;
								this._glInternalFormat = device.extCompressedTextureS3TC_SRGB.COMPRESSED_SRGB_S3TC_DXT1_EXT;
								break;
						case PIXELFORMAT_DXT3_SRGBA:
								this._glFormat = gl.SRGB_ALPHA;
								this._glInternalFormat = device.extCompressedTextureS3TC_SRGB.COMPRESSED_SRGB_ALPHA_S3TC_DXT3_EXT;
								break;
						case PIXELFORMAT_DXT5_SRGBA:
								this._glFormat = gl.SRGB_ALPHA;
								this._glInternalFormat = device.extCompressedTextureS3TC_SRGB.COMPRESSED_SRGB_ALPHA_S3TC_DXT5_EXT;
								break;
						case PIXELFORMAT_ETC2_SRGB:
								this._glFormat = gl.SRGB;
								this._glInternalFormat = device.extCompressedTextureETC.COMPRESSED_SRGB8_ETC2;
								break;
						case PIXELFORMAT_ETC2_SRGBA:
								this._glFormat = gl.SRGB_ALPHA;
								this._glInternalFormat = device.extCompressedTextureETC.COMPRESSED_SRGB8_ALPHA8_ETC2_EAC;
								break;
						case PIXELFORMAT_ASTC_4x4_SRGB:
								this._glFormat = gl.SRGB_ALPHA;
								this._glInternalFormat = device.extCompressedTextureASTC.COMPRESSED_SRGB8_ALPHA8_ASTC_4x4_KHR;
								break;
						case PIXELFORMAT_BC7_SRGBA:
								this._glFormat = gl.RGBA;
								this._glInternalFormat = device.extTextureCompressionBPTC.COMPRESSED_SRGB_ALPHA_BPTC_UNORM_EXT;
								break;
						case PIXELFORMAT_R16F:
								this._glFormat = gl.RED;
								this._glInternalFormat = gl.R16F;
								this._glPixelType = gl.HALF_FLOAT;
								break;
						case PIXELFORMAT_RG16F:
								this._glFormat = gl.RG;
								this._glInternalFormat = gl.RG16F;
								this._glPixelType = gl.HALF_FLOAT;
								break;
						case PIXELFORMAT_RGB16F:
								this._glFormat = gl.RGB;
								this._glInternalFormat = gl.RGB16F;
								this._glPixelType = gl.HALF_FLOAT;
								break;
						case PIXELFORMAT_RGBA16F:
								this._glFormat = gl.RGBA;
								this._glInternalFormat = gl.RGBA16F;
								this._glPixelType = gl.HALF_FLOAT;
								break;
						case PIXELFORMAT_RGB32F:
								this._glFormat = gl.RGB;
								this._glInternalFormat = gl.RGB32F;
								this._glPixelType = gl.FLOAT;
								break;
						case PIXELFORMAT_RGBA32F:
								this._glFormat = gl.RGBA;
								this._glInternalFormat = gl.RGBA32F;
								this._glPixelType = gl.FLOAT;
								break;
						case PIXELFORMAT_R32F:
								this._glFormat = gl.RED;
								this._glInternalFormat = gl.R32F;
								this._glPixelType = gl.FLOAT;
								break;
						case PIXELFORMAT_DEPTH:
								this._glFormat = gl.DEPTH_COMPONENT;
								this._glInternalFormat = gl.DEPTH_COMPONENT32F;
								this._glPixelType = gl.FLOAT;
								break;
						case PIXELFORMAT_DEPTH16:
								this._glFormat = gl.DEPTH_COMPONENT;
								this._glInternalFormat = gl.DEPTH_COMPONENT16;
								this._glPixelType = gl.UNSIGNED_SHORT;
								break;
						case PIXELFORMAT_DEPTHSTENCIL:
								this._glFormat = gl.DEPTH_STENCIL;
								this._glInternalFormat = gl.DEPTH24_STENCIL8;
								this._glPixelType = gl.UNSIGNED_INT_24_8;
								break;
						case PIXELFORMAT_111110F:
								this._glFormat = gl.RGB;
								this._glInternalFormat = gl.R11F_G11F_B10F;
								this._glPixelType = gl.UNSIGNED_INT_10F_11F_11F_REV;
								break;
						case PIXELFORMAT_SRGB8:
								this._glFormat = gl.RGB;
								this._glInternalFormat = gl.SRGB8;
								this._glPixelType = gl.UNSIGNED_BYTE;
								break;
						case PIXELFORMAT_SRGBA8:
								this._glFormat = gl.RGBA;
								this._glInternalFormat = gl.SRGB8_ALPHA8;
								this._glPixelType = gl.UNSIGNED_BYTE;
								break;
						case PIXELFORMAT_R8I:
								this._glFormat = gl.RED_INTEGER;
								this._glInternalFormat = gl.R8I;
								this._glPixelType = gl.BYTE;
								break;
						case PIXELFORMAT_R8U:
								this._glFormat = gl.RED_INTEGER;
								this._glInternalFormat = gl.R8UI;
								this._glPixelType = gl.UNSIGNED_BYTE;
								break;
						case PIXELFORMAT_R16I:
								this._glFormat = gl.RED_INTEGER;
								this._glInternalFormat = gl.R16I;
								this._glPixelType = gl.SHORT;
								break;
						case PIXELFORMAT_R16U:
								this._glFormat = gl.RED_INTEGER;
								this._glInternalFormat = gl.R16UI;
								this._glPixelType = gl.UNSIGNED_SHORT;
								break;
						case PIXELFORMAT_R32I:
								this._glFormat = gl.RED_INTEGER;
								this._glInternalFormat = gl.R32I;
								this._glPixelType = gl.INT;
								break;
						case PIXELFORMAT_R32U:
								this._glFormat = gl.RED_INTEGER;
								this._glInternalFormat = gl.R32UI;
								this._glPixelType = gl.UNSIGNED_INT;
								break;
						case PIXELFORMAT_RG8I:
								this._glFormat = gl.RG_INTEGER;
								this._glInternalFormat = gl.RG8I;
								this._glPixelType = gl.BYTE;
								break;
						case PIXELFORMAT_RG8U:
								this._glFormat = gl.RG_INTEGER;
								this._glInternalFormat = gl.RG8UI;
								this._glPixelType = gl.UNSIGNED_BYTE;
								break;
						case PIXELFORMAT_RG16I:
								this._glFormat = gl.RG_INTEGER;
								this._glInternalFormat = gl.RG16I;
								this._glPixelType = gl.SHORT;
								break;
						case PIXELFORMAT_RG16U:
								this._glFormat = gl.RG_INTEGER;
								this._glInternalFormat = gl.RG16UI;
								this._glPixelType = gl.UNSIGNED_SHORT;
								break;
						case PIXELFORMAT_RG32I:
								this._glFormat = gl.RG_INTEGER;
								this._glInternalFormat = gl.RG32I;
								this._glPixelType = gl.INT;
								break;
						case PIXELFORMAT_RG32U:
								this._glFormat = gl.RG_INTEGER;
								this._glInternalFormat = gl.RG32UI;
								this._glPixelType = gl.UNSIGNED_INT;
								break;
						case PIXELFORMAT_RGBA8I:
								this._glFormat = gl.RGBA_INTEGER;
								this._glInternalFormat = gl.RGBA8I;
								this._glPixelType = gl.BYTE;
								break;
						case PIXELFORMAT_RGBA8U:
								this._glFormat = gl.RGBA_INTEGER;
								this._glInternalFormat = gl.RGBA8UI;
								this._glPixelType = gl.UNSIGNED_BYTE;
								break;
						case PIXELFORMAT_RGBA16I:
								this._glFormat = gl.RGBA_INTEGER;
								this._glInternalFormat = gl.RGBA16I;
								this._glPixelType = gl.SHORT;
								break;
						case PIXELFORMAT_RGBA16U:
								this._glFormat = gl.RGBA_INTEGER;
								this._glInternalFormat = gl.RGBA16UI;
								this._glPixelType = gl.UNSIGNED_SHORT;
								break;
						case PIXELFORMAT_RGBA32I:
								this._glFormat = gl.RGBA_INTEGER;
								this._glInternalFormat = gl.RGBA32I;
								this._glPixelType = gl.INT;
								break;
						case PIXELFORMAT_RGBA32U:
								this._glFormat = gl.RGBA_INTEGER;
								this._glInternalFormat = gl.RGBA32UI;
								this._glPixelType = gl.UNSIGNED_INT;
								break;
				}
				this._glCreated = false;
		}
		upload(device, texture) {
				var gl = device.gl;
				if (!texture._needsUpload && (texture._needsMipmapsUpload && texture._mipmapsUploaded || !texture.pot)) {
						return;
				}
				var mipLevel = 0;
				var mipObject;
				var resMult;
				var requiredMipLevels = texture.numLevels;
				if (texture.array) {
						gl.texStorage3D(gl.TEXTURE_2D_ARRAY, requiredMipLevels, this._glInternalFormat, texture._width, texture._height, texture._arrayLength);
				}
				while(texture._levels[mipLevel] || mipLevel === 0){
						if (!texture._needsUpload && mipLevel === 0) {
								mipLevel++;
								continue;
						} else if (mipLevel && (!texture._needsMipmapsUpload || !texture._mipmaps)) {
								break;
						}
						mipObject = texture._levels[mipLevel];
						resMult = 1 / Math.pow(2, mipLevel);
						if (mipLevel === 1 && !texture._compressed && !texture._integerFormat && texture._levels.length < requiredMipLevels) {
								gl.generateMipmap(this._glTarget);
								texture._mipmapsUploaded = true;
						}
						if (texture._cubemap) {
								var face = void 0;
								if (device._isBrowserInterface(mipObject[0])) {
										for(face = 0; face < 6; face++){
												if (!texture._levelsUpdated[0][face]) {
														continue;
												}
												var src = mipObject[face];
												if (device._isImageBrowserInterface(src)) {
														if (src.width > device.maxCubeMapSize || src.height > device.maxCubeMapSize) {
																src = downsampleImage(src, device.maxCubeMapSize);
																if (mipLevel === 0) {
																		texture._width = src.width;
																		texture._height = src.height;
																}
														}
												}
												device.setUnpackFlipY(false);
												device.setUnpackPremultiplyAlpha(texture._premultiplyAlpha);
												if (this._glCreated) {
														gl.texSubImage2D(gl.TEXTURE_CUBE_MAP_POSITIVE_X + face, mipLevel, 0, 0, this._glFormat, this._glPixelType, src);
												} else {
														gl.texImage2D(gl.TEXTURE_CUBE_MAP_POSITIVE_X + face, mipLevel, this._glInternalFormat, this._glFormat, this._glPixelType, src);
												}
										}
								} else {
										resMult = 1 / Math.pow(2, mipLevel);
										for(face = 0; face < 6; face++){
												if (!texture._levelsUpdated[0][face]) {
														continue;
												}
												var texData = mipObject[face];
												if (texture._compressed) {
														if (this._glCreated && texData) {
																gl.compressedTexSubImage2D(gl.TEXTURE_CUBE_MAP_POSITIVE_X + face, mipLevel, 0, 0, Math.max(texture._width * resMult, 1), Math.max(texture._height * resMult, 1), this._glInternalFormat, texData);
														} else {
																gl.compressedTexImage2D(gl.TEXTURE_CUBE_MAP_POSITIVE_X + face, mipLevel, this._glInternalFormat, Math.max(texture._width * resMult, 1), Math.max(texture._height * resMult, 1), 0, texData);
														}
												} else {
														device.setUnpackFlipY(false);
														device.setUnpackPremultiplyAlpha(texture._premultiplyAlpha);
														if (this._glCreated && texData) {
																gl.texSubImage2D(gl.TEXTURE_CUBE_MAP_POSITIVE_X + face, mipLevel, 0, 0, Math.max(texture._width * resMult, 1), Math.max(texture._height * resMult, 1), this._glFormat, this._glPixelType, texData);
														} else {
																gl.texImage2D(gl.TEXTURE_CUBE_MAP_POSITIVE_X + face, mipLevel, this._glInternalFormat, Math.max(texture._width * resMult, 1), Math.max(texture._height * resMult, 1), 0, this._glFormat, this._glPixelType, texData);
														}
												}
										}
								}
						} else if (texture._volume) {
								if (texture._compressed) {
										gl.compressedTexImage3D(gl.TEXTURE_3D, mipLevel, this._glInternalFormat, Math.max(texture._width * resMult, 1), Math.max(texture._height * resMult, 1), Math.max(texture._depth * resMult, 1), 0, mipObject);
								} else {
										device.setUnpackFlipY(false);
										device.setUnpackPremultiplyAlpha(texture._premultiplyAlpha);
										gl.texImage3D(gl.TEXTURE_3D, mipLevel, this._glInternalFormat, Math.max(texture._width * resMult, 1), Math.max(texture._height * resMult, 1), Math.max(texture._depth * resMult, 1), 0, this._glFormat, this._glPixelType, mipObject);
								}
						} else if (texture.array && typeof mipObject === 'object') {
								if (texture._arrayLength === mipObject.length) {
										if (texture._compressed) {
												for(var index = 0; index < texture._arrayLength; index++){
														gl.compressedTexSubImage3D(gl.TEXTURE_2D_ARRAY, mipLevel, 0, 0, index, Math.max(Math.floor(texture._width * resMult), 1), Math.max(Math.floor(texture._height * resMult), 1), 1, this._glInternalFormat, mipObject[index]);
												}
										} else {
												for(var index1 = 0; index1 < texture._arrayLength; index1++){
														gl.texSubImage3D(gl.TEXTURE_2D_ARRAY, mipLevel, 0, 0, index1, Math.max(Math.floor(texture._width * resMult), 1), Math.max(Math.floor(texture._height * resMult), 1), 1, this._glFormat, this._glPixelType, mipObject[index1]);
												}
										}
								}
						} else {
								if (device._isBrowserInterface(mipObject)) {
										if (device._isImageBrowserInterface(mipObject)) {
												if (mipObject.width > device.maxTextureSize || mipObject.height > device.maxTextureSize) {
														mipObject = downsampleImage(mipObject, device.maxTextureSize);
														if (mipLevel === 0) {
																texture._width = mipObject.width;
																texture._height = mipObject.height;
														}
												}
										}
										var w = mipObject.width || mipObject.videoWidth;
										var h = mipObject.height || mipObject.videoHeight;
										device.setUnpackFlipY(texture._flipY);
										device.setUnpackPremultiplyAlpha(texture._premultiplyAlpha);
										if (this._glCreated && texture._width === w && texture._height === h && !device._isImageVideoInterface(mipObject)) {
												gl.texSubImage2D(gl.TEXTURE_2D, mipLevel, 0, 0, this._glFormat, this._glPixelType, mipObject);
										} else {
												gl.texImage2D(gl.TEXTURE_2D, mipLevel, this._glInternalFormat, this._glFormat, this._glPixelType, mipObject);
												if (mipLevel === 0) {
														texture._width = w;
														texture._height = h;
												}
										}
								} else {
										resMult = 1 / Math.pow(2, mipLevel);
										if (texture._compressed) {
												if (this._glCreated && mipObject) {
														gl.compressedTexSubImage2D(gl.TEXTURE_2D, mipLevel, 0, 0, Math.max(Math.floor(texture._width * resMult), 1), Math.max(Math.floor(texture._height * resMult), 1), this._glInternalFormat, mipObject);
												} else {
														gl.compressedTexImage2D(gl.TEXTURE_2D, mipLevel, this._glInternalFormat, Math.max(Math.floor(texture._width * resMult), 1), Math.max(Math.floor(texture._height * resMult), 1), 0, mipObject);
												}
										} else {
												device.setUnpackFlipY(false);
												device.setUnpackPremultiplyAlpha(texture._premultiplyAlpha);
												if (this._glCreated && mipObject) {
														gl.texSubImage2D(gl.TEXTURE_2D, mipLevel, 0, 0, Math.max(texture._width * resMult, 1), Math.max(texture._height * resMult, 1), this._glFormat, this._glPixelType, mipObject);
												} else {
														gl.texImage2D(gl.TEXTURE_2D, mipLevel, this._glInternalFormat, Math.max(texture._width * resMult, 1), Math.max(texture._height * resMult, 1), 0, this._glFormat, this._glPixelType, mipObject);
												}
										}
								}
								if (mipLevel === 0) {
										texture._mipmapsUploaded = false;
								} else {
										texture._mipmapsUploaded = true;
								}
						}
						mipLevel++;
				}
				if (texture._needsUpload) {
						if (texture._cubemap) {
								for(var i = 0; i < 6; i++){
										texture._levelsUpdated[0][i] = false;
								}
						} else {
								texture._levelsUpdated[0] = false;
						}
				}
				if (!texture._compressed && !texture._integerFormat && texture._mipmaps && texture._needsMipmapsUpload && texture._levels.length === 1) {
						gl.generateMipmap(this._glTarget);
						texture._mipmapsUploaded = true;
				}
				if (texture._gpuSize) {
						texture.adjustVramSizeTracking(device._vram, -texture._gpuSize);
				}
				texture._gpuSize = texture.gpuSize;
				texture.adjustVramSizeTracking(device._vram, texture._gpuSize);
				this._glCreated = true;
		}
		read(x, y, width, height, options) {
				var texture = this.texture;
				var device = texture.device;
				return device.readTextureAsync(texture, x, y, width, height, options);
		}
		constructor(texture){
				this._glTexture = null;
				this.dirtyParameterFlags = 0;
				this.texture = texture;
		}
}

class FramebufferPair {
		destroy(gl) {
				if (this.msaaFB) {
						gl.deleteRenderbuffer(this.msaaFB);
						this.msaaFB = null;
				}
				if (this.resolveFB) {
						gl.deleteRenderbuffer(this.resolveFB);
						this.resolveFB = null;
				}
		}
		constructor(msaaFB, resolveFB){
				this.msaaFB = msaaFB;
				this.resolveFB = resolveFB;
		}
}
class WebglRenderTarget {
		destroy(device) {
				var _this_colorMrtFramebuffers;
				var gl = device.gl;
				this._isInitialized = false;
				if (this._glFrameBuffer) {
						if (this._glFrameBuffer !== this.suppliedColorFramebuffer) {
								gl.deleteFramebuffer(this._glFrameBuffer);
						}
						this._glFrameBuffer = null;
				}
				if (this._glDepthBuffer) {
						gl.deleteRenderbuffer(this._glDepthBuffer);
						this._glDepthBuffer = null;
				}
				if (this._glResolveFrameBuffer) {
						if (this._glResolveFrameBuffer !== this.suppliedColorFramebuffer) {
								gl.deleteFramebuffer(this._glResolveFrameBuffer);
						}
						this._glResolveFrameBuffer = null;
				}
				this._glMsaaColorBuffers.forEach((buffer)=>{
						gl.deleteRenderbuffer(buffer);
				});
				this._glMsaaColorBuffers.length = 0;
				(_this_colorMrtFramebuffers = this.colorMrtFramebuffers) == null ? void 0 : _this_colorMrtFramebuffers.forEach((framebuffer)=>{
						framebuffer.destroy(gl);
				});
				this.colorMrtFramebuffers = null;
				if (this._glMsaaDepthBuffer) {
						this._glMsaaDepthBuffer = null;
						if (this.msaaDepthBufferKey) {
								getMultisampledTextureCache(device).release(this.msaaDepthBufferKey);
						}
				}
				this.suppliedColorFramebuffer = undefined;
		}
		get initialized() {
				return this._isInitialized;
		}
		init(device, target) {
				var gl = device.gl;
				this._isInitialized = true;
				var buffers = [];
				if (this.suppliedColorFramebuffer !== undefined) {
						this._glFrameBuffer = this.suppliedColorFramebuffer;
				} else {
						var _target__colorBuffers;
						this._glFrameBuffer = gl.createFramebuffer();
						device.setFramebuffer(this._glFrameBuffer);
						var _target__colorBuffers_length;
						var colorBufferCount = (_target__colorBuffers_length = (_target__colorBuffers = target._colorBuffers) == null ? void 0 : _target__colorBuffers.length) != null ? _target__colorBuffers_length : 0;
						var attachmentBaseConstant = gl.COLOR_ATTACHMENT0;
						for(var i = 0; i < colorBufferCount; ++i){
								var colorBuffer = target.getColorBuffer(i);
								if (colorBuffer) {
										if (!colorBuffer.impl._glTexture) {
												colorBuffer._width = Math.min(colorBuffer.width, device.maxRenderBufferSize);
												colorBuffer._height = Math.min(colorBuffer.height, device.maxRenderBufferSize);
												device.setTexture(colorBuffer, 0);
										}
										gl.framebufferTexture2D(gl.FRAMEBUFFER, attachmentBaseConstant + i, colorBuffer._cubemap ? gl.TEXTURE_CUBE_MAP_POSITIVE_X + target._face : gl.TEXTURE_2D, colorBuffer.impl._glTexture, target.mipLevel);
										buffers.push(attachmentBaseConstant + i);
								}
						}
						gl.drawBuffers(buffers);
						var depthBuffer = target._depthBuffer;
						if (depthBuffer || target._depth) {
								var attachmentPoint = target._stencil ? gl.DEPTH_STENCIL_ATTACHMENT : gl.DEPTH_ATTACHMENT;
								if (depthBuffer) {
										if (!depthBuffer.impl._glTexture) {
												depthBuffer._width = Math.min(depthBuffer.width, device.maxRenderBufferSize);
												depthBuffer._height = Math.min(depthBuffer.height, device.maxRenderBufferSize);
												device.setTexture(depthBuffer, 0);
										}
										gl.framebufferTexture2D(gl.FRAMEBUFFER, attachmentPoint, depthBuffer._cubemap ? gl.TEXTURE_CUBE_MAP_POSITIVE_X + target._face : gl.TEXTURE_2D, target._depthBuffer.impl._glTexture, target.mipLevel);
								} else {
										var willRenderMsaa = target._samples > 1;
										if (!willRenderMsaa) {
												if (!this._glDepthBuffer) {
														this._glDepthBuffer = gl.createRenderbuffer();
												}
												var internalFormat = target._stencil ? gl.DEPTH24_STENCIL8 : gl.DEPTH_COMPONENT32F;
												gl.bindRenderbuffer(gl.RENDERBUFFER, this._glDepthBuffer);
												gl.renderbufferStorage(gl.RENDERBUFFER, internalFormat, target.width, target.height);
												gl.framebufferRenderbuffer(gl.FRAMEBUFFER, attachmentPoint, gl.RENDERBUFFER, this._glDepthBuffer);
												gl.bindRenderbuffer(gl.RENDERBUFFER, null);
										}
								}
						}
				}
				if (target._samples > 1) {
						var _target__colorBuffers1;
						this._glResolveFrameBuffer = this._glFrameBuffer;
						this._glFrameBuffer = gl.createFramebuffer();
						device.setFramebuffer(this._glFrameBuffer);
						var _target__colorBuffers_length1;
						var colorBufferCount1 = (_target__colorBuffers_length1 = (_target__colorBuffers1 = target._colorBuffers) == null ? void 0 : _target__colorBuffers1.length) != null ? _target__colorBuffers_length1 : 0;
						if (this.suppliedColorFramebuffer !== undefined) {
								var buffer = gl.createRenderbuffer();
								this._glMsaaColorBuffers.push(buffer);
								var internalFormat1 = device.backBufferFormat === PIXELFORMAT_RGBA8 ? gl.RGBA8 : gl.RGB8;
								gl.bindRenderbuffer(gl.RENDERBUFFER, buffer);
								gl.renderbufferStorageMultisample(gl.RENDERBUFFER, target._samples, internalFormat1, target.width, target.height);
								gl.framebufferRenderbuffer(gl.FRAMEBUFFER, gl.COLOR_ATTACHMENT0, gl.RENDERBUFFER, buffer);
						} else {
								for(var i1 = 0; i1 < colorBufferCount1; ++i1){
										var colorBuffer1 = target.getColorBuffer(i1);
										if (colorBuffer1) {
												var buffer1 = gl.createRenderbuffer();
												this._glMsaaColorBuffers.push(buffer1);
												gl.bindRenderbuffer(gl.RENDERBUFFER, buffer1);
												gl.renderbufferStorageMultisample(gl.RENDERBUFFER, target._samples, colorBuffer1.impl._glInternalFormat, target.width, target.height);
												gl.framebufferRenderbuffer(gl.FRAMEBUFFER, gl.COLOR_ATTACHMENT0 + i1, gl.RENDERBUFFER, buffer1);
										}
								}
						}
						if (target._depth) {
								var internalFormat2 = target._stencil ? gl.DEPTH24_STENCIL8 : gl.DEPTH_COMPONENT32F;
								var attachmentPoint1 = target._stencil ? gl.DEPTH_STENCIL_ATTACHMENT : gl.DEPTH_ATTACHMENT;
								var key;
								var depthBuffer1 = target._depthBuffer;
								if (depthBuffer1) {
										key = depthBuffer1.id + ":" + target.width + ":" + target.height + ":" + target._samples + ":" + internalFormat2 + ":" + attachmentPoint1;
										this._glMsaaDepthBuffer = getMultisampledTextureCache(device).get(key);
								}
								if (!this._glMsaaDepthBuffer) {
										this._glMsaaDepthBuffer = gl.createRenderbuffer();
										gl.bindRenderbuffer(gl.RENDERBUFFER, this._glMsaaDepthBuffer);
										gl.renderbufferStorageMultisample(gl.RENDERBUFFER, target._samples, internalFormat2, target.width, target.height);
										this._glMsaaDepthBuffer.destroy = function() {
												gl.deleteRenderbuffer(this);
										};
										if (depthBuffer1) {
												getMultisampledTextureCache(device).set(key, this._glMsaaDepthBuffer);
										}
								}
								this.msaaDepthBufferKey = key;
								gl.framebufferRenderbuffer(gl.FRAMEBUFFER, attachmentPoint1, gl.RENDERBUFFER, this._glMsaaDepthBuffer);
						}
						if (colorBufferCount1 > 1) {
								this._createMsaaMrtFramebuffers(device, target, colorBufferCount1);
								device.setFramebuffer(this._glFrameBuffer);
								gl.drawBuffers(buffers);
						}
				}
		}
		_createMsaaMrtFramebuffers(device, target, colorBufferCount) {
				var gl = device.gl;
				this.colorMrtFramebuffers = [];
				for(var i = 0; i < colorBufferCount; ++i){
						var colorBuffer = target.getColorBuffer(i);
						var srcFramebuffer = gl.createFramebuffer();
						device.setFramebuffer(srcFramebuffer);
						var buffer = this._glMsaaColorBuffers[i];
						gl.bindRenderbuffer(gl.RENDERBUFFER, buffer);
						gl.renderbufferStorageMultisample(gl.RENDERBUFFER, target._samples, colorBuffer.impl._glInternalFormat, target.width, target.height);
						gl.framebufferRenderbuffer(gl.FRAMEBUFFER, gl.COLOR_ATTACHMENT0, gl.RENDERBUFFER, buffer);
						gl.drawBuffers([
								gl.COLOR_ATTACHMENT0
						]);
						var dstFramebuffer = gl.createFramebuffer();
						device.setFramebuffer(dstFramebuffer);
						gl.framebufferTexture2D(gl.FRAMEBUFFER, gl.COLOR_ATTACHMENT0, colorBuffer._cubemap ? gl.TEXTURE_CUBE_MAP_POSITIVE_X + target._face : gl.TEXTURE_2D, colorBuffer.impl._glTexture, 0);
						this.colorMrtFramebuffers[i] = new FramebufferPair(srcFramebuffer, dstFramebuffer);
				}
		}
		_checkFbo(device, target, type) {
				var gl = device.gl;
				var status = gl.checkFramebufferStatus(gl.FRAMEBUFFER);
				switch(status){
						case gl.FRAMEBUFFER_INCOMPLETE_ATTACHMENT:
								break;
						case gl.FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT:
								break;
						case gl.FRAMEBUFFER_INCOMPLETE_DIMENSIONS:
								break;
						case gl.FRAMEBUFFER_UNSUPPORTED:
								break;
				}
		}
		loseContext() {
				this._glFrameBuffer = null;
				this._glDepthBuffer = null;
				this._glResolveFrameBuffer = null;
				this._glMsaaColorBuffers.length = 0;
				this._glMsaaDepthBuffer = null;
				this.msaaDepthBufferKey = undefined;
				this.colorMrtFramebuffers = null;
				this.suppliedColorFramebuffer = undefined;
				this._isInitialized = false;
		}
		internalResolve(device, src, dst, target, mask) {
				device.setScissor(0, 0, target.width, target.height);
				var gl = device.gl;
				gl.bindFramebuffer(gl.READ_FRAMEBUFFER, src);
				gl.bindFramebuffer(gl.DRAW_FRAMEBUFFER, dst);
				gl.blitFramebuffer(0, 0, target.width, target.height, 0, 0, target.width, target.height, mask, gl.NEAREST);
		}
		resolve(device, target, color, depth) {
				var gl = device.gl;
				if (this.colorMrtFramebuffers) {
						if (color) {
								for(var i = 0; i < this.colorMrtFramebuffers.length; i++){
										var fbPair = this.colorMrtFramebuffers[i];
										this.internalResolve(device, fbPair.msaaFB, fbPair.resolveFB, target, gl.COLOR_BUFFER_BIT);
								}
						}
						if (depth) {
								this.internalResolve(device, this._glFrameBuffer, this._glResolveFrameBuffer, target, gl.DEPTH_BUFFER_BIT);
						}
				} else {
						this.internalResolve(device, this._glFrameBuffer, this._glResolveFrameBuffer, target, (color ? gl.COLOR_BUFFER_BIT : 0) | (depth ? gl.DEPTH_BUFFER_BIT : 0));
				}
				gl.bindFramebuffer(gl.FRAMEBUFFER, this._glFrameBuffer);
		}
		constructor(){
				this._glFrameBuffer = null;
				this._glDepthBuffer = null;
				this._glResolveFrameBuffer = null;
				this.colorMrtFramebuffers = null;
				this._glMsaaColorBuffers = [];
				this._glMsaaDepthBuffer = null;
				this._isInitialized = false;
		}
}

class FrameQueriesInfo {
		destroy(gl) {
				this.queries.forEach((query)=>gl.deleteQuery(query));
				this.queries = null;
		}
		constructor(){
				this.queries = [];
		}
}
class WebglGpuProfiler extends GpuProfiler {
		destroy() {
				this.freeQueries.forEach((query)=>this.device.gl.deleteQuery(query));
				this.frameQueries.forEach((query)=>this.device.gl.deleteQuery(query));
				this.previousFrameQueries.forEach((frameQueriesInfo)=>frameQueriesInfo.destroy(this.device.gl));
				this.freeQueries = null;
				this.frameQueries = null;
				this.previousFrameQueries = null;
		}
		loseContext() {
				super.loseContext();
				this.freeQueries = [];
				this.frameQueries = [];
				this.previousFrameQueries = [];
		}
		restoreContext() {
				this.ext = this.device.extDisjointTimerQuery;
		}
		getQuery() {
				var _this_freeQueries_pop;
				return (_this_freeQueries_pop = this.freeQueries.pop()) != null ? _this_freeQueries_pop : this.device.gl.createQuery();
		}
		start(name) {
				if (this.ext) {
						var slot = this.getSlot(name);
						var query = this.getQuery();
						this.frameQueries[slot] = query;
						this.device.gl.beginQuery(this.ext.TIME_ELAPSED_EXT, query);
						return slot;
				}
				return undefined;
		}
		end(slot) {
				if (slot !== undefined) {
						this.device.gl.endQuery(this.ext.TIME_ELAPSED_EXT);
				}
		}
		frameStart() {
				this.processEnableRequest();
				if (this._enabled) {
						this.frameGPUMarkerSlot = this.start('GpuFrame');
				}
		}
		frameEnd() {
				if (this._enabled) {
						this.end(this.frameGPUMarkerSlot);
				}
		}
		request() {
				if (this._enabled) {
						var ext = this.ext;
						var gl = this.device.gl;
						var renderVersion = this.device.renderVersion;
						var frameQueries = this.frameQueries;
						if (frameQueries.length > 0) {
								this.frameQueries = [];
								var frameQueriesInfo = new FrameQueriesInfo();
								frameQueriesInfo.queries = frameQueries;
								frameQueriesInfo.renderVersion = renderVersion;
								this.previousFrameQueries.push(frameQueriesInfo);
						}
						if (this.previousFrameQueries.length > 0) {
								var previousQueriesInfo = this.previousFrameQueries[0];
								var previousQueries = previousQueriesInfo.queries;
								var lastQuery = previousQueries[previousQueries.length - 1];
								var available = gl.getQueryParameter(lastQuery, gl.QUERY_RESULT_AVAILABLE);
								var disjoint = gl.getParameter(ext.GPU_DISJOINT_EXT);
								if (available && !disjoint) {
										this.previousFrameQueries.shift();
										var timings = this.timings;
										timings.length = 0;
										for(var i = 0; i < previousQueries.length; i++){
												var query = previousQueries[i];
												var duration = gl.getQueryParameter(query, gl.QUERY_RESULT);
												timings[i] = duration * 0.000001;
												this.freeQueries.push(query);
										}
										this.report(previousQueriesInfo.renderVersion, timings);
								}
								if (disjoint) {
										this.previousFrameQueries.forEach((frameQueriesInfo)=>{
												this.report(frameQueriesInfo.renderVersion, null);
												frameQueriesInfo.destroy(gl);
										});
										this.previousFrameQueries.length = 0;
								}
						}
						super.request(renderVersion);
				}
		}
		constructor(device){
				super(), this.freeQueries = [], this.frameQueries = [], this.previousFrameQueries = [], this.timings = [];
				this.device = device;
				this.ext = device.extDisjointTimerQuery;
		}
}

function asyncGeneratorStep$2(gen, resolve, reject, _next, _throw, key, arg) {
		try {
				var info = gen[key](arg);
				var value = info.value;
		} catch (error) {
				reject(error);
				return;
		}
		if (info.done) {
				resolve(value);
		} else {
				Promise.resolve(value).then(_next, _throw);
		}
}
function _async_to_generator$2(fn) {
		return function() {
				var self = this, args = arguments;
				return new Promise(function(resolve, reject) {
						var gen = fn.apply(self, args);
						function _next(value) {
								asyncGeneratorStep$2(gen, resolve, reject, _next, _throw, "next", value);
						}
						function _throw(err) {
								asyncGeneratorStep$2(gen, resolve, reject, _next, _throw, "throw", err);
						}
						_next(undefined);
				});
		};
}
var invalidateAttachments = [];
class WebglGraphicsDevice extends GraphicsDevice {
		postInit() {
				super.postInit();
				this.gpuProfiler = new WebglGpuProfiler(this);
		}
		destroy() {
				super.destroy();
				var gl = this.gl;
				if (this.feedback) {
						gl.deleteTransformFeedback(this.feedback);
				}
				this.clearVertexArrayObjectCache();
				this.canvas.removeEventListener('webglcontextlost', this._contextLostHandler, false);
				this.canvas.removeEventListener('webglcontextrestored', this._contextRestoredHandler, false);
				this._contextLostHandler = null;
				this._contextRestoredHandler = null;
				this.gl = null;
				super.postDestroy();
		}
		createBackbuffer(frameBuffer) {
				this.supportsStencil = this.initOptions.stencil;
				this.backBuffer = new RenderTarget({
						name: 'WebglFramebuffer',
						graphicsDevice: this,
						depth: this.initOptions.depth,
						stencil: this.supportsStencil,
						samples: this.samples
				});
				this.backBuffer.impl.suppliedColorFramebuffer = frameBuffer;
		}
		updateBackbufferFormat(framebuffer) {
				var gl = this.gl;
				gl.bindFramebuffer(gl.FRAMEBUFFER, framebuffer);
				var alphaBits = this.gl.getParameter(this.gl.ALPHA_BITS);
				this.backBufferFormat = alphaBits ? PIXELFORMAT_RGBA8 : PIXELFORMAT_RGB8;
		}
		updateBackbuffer() {
				var resolutionChanged = this.canvas.width !== this.backBufferSize.x || this.canvas.height !== this.backBufferSize.y;
				if (this._defaultFramebufferChanged || resolutionChanged) {
						if (this._defaultFramebufferChanged) {
								this.updateBackbufferFormat(this._defaultFramebuffer);
						}
						this._defaultFramebufferChanged = false;
						this.backBufferSize.set(this.canvas.width, this.canvas.height);
						this.backBuffer.destroy();
						this.createBackbuffer(this._defaultFramebuffer);
				}
		}
		createVertexBufferImpl(vertexBuffer, format) {
				return new WebglVertexBuffer();
		}
		createIndexBufferImpl(indexBuffer) {
				return new WebglIndexBuffer(indexBuffer);
		}
		createShaderImpl(shader) {
				return new WebglShader(shader);
		}
		createTextureImpl(texture) {
				return new WebglTexture(texture);
		}
		createRenderTargetImpl(renderTarget) {
				return new WebglRenderTarget();
		}
		getPrecision() {
				var gl = this.gl;
				var precision = 'highp';
				if (gl.getShaderPrecisionFormat) {
						var vertexShaderPrecisionHighpFloat = gl.getShaderPrecisionFormat(gl.VERTEX_SHADER, gl.HIGH_FLOAT);
						var vertexShaderPrecisionMediumpFloat = gl.getShaderPrecisionFormat(gl.VERTEX_SHADER, gl.MEDIUM_FLOAT);
						var fragmentShaderPrecisionHighpFloat = gl.getShaderPrecisionFormat(gl.FRAGMENT_SHADER, gl.HIGH_FLOAT);
						var fragmentShaderPrecisionMediumpFloat = gl.getShaderPrecisionFormat(gl.FRAGMENT_SHADER, gl.MEDIUM_FLOAT);
						if (vertexShaderPrecisionHighpFloat && vertexShaderPrecisionMediumpFloat && fragmentShaderPrecisionHighpFloat && fragmentShaderPrecisionMediumpFloat) {
								var highpAvailable = vertexShaderPrecisionHighpFloat.precision > 0 && fragmentShaderPrecisionHighpFloat.precision > 0;
								var mediumpAvailable = vertexShaderPrecisionMediumpFloat.precision > 0 && fragmentShaderPrecisionMediumpFloat.precision > 0;
								if (!highpAvailable) {
										if (mediumpAvailable) {
												precision = 'mediump';
										} else {
												precision = 'lowp';
										}
								}
						}
				}
				return precision;
		}
		getExtension() {
				for(var i = 0; i < arguments.length; i++){
						if (this.supportedExtensions.indexOf(arguments[i]) !== -1) {
								return this.gl.getExtension(arguments[i]);
						}
				}
				return null;
		}
		get extDisjointTimerQuery() {
				if (!this._extDisjointTimerQuery) {
						this._extDisjointTimerQuery = this.getExtension('EXT_disjoint_timer_query_webgl2', 'EXT_disjoint_timer_query');
				}
				return this._extDisjointTimerQuery;
		}
		initializeExtensions() {
				var gl = this.gl;
				var _gl_getSupportedExtensions;
				this.supportedExtensions = (_gl_getSupportedExtensions = gl.getSupportedExtensions()) != null ? _gl_getSupportedExtensions : [];
				this._extDisjointTimerQuery = null;
				this.textureRG11B10Renderable = true;
				this.extColorBufferFloat = this.getExtension('EXT_color_buffer_float');
				this.textureFloatRenderable = !!this.extColorBufferFloat;
				this.extColorBufferHalfFloat = this.getExtension('EXT_color_buffer_half_float');
				this.textureHalfFloatRenderable = !!this.extColorBufferHalfFloat || !!this.extColorBufferFloat;
				this.extDebugRendererInfo = this.getExtension('WEBGL_debug_renderer_info');
				this.extTextureFloatLinear = this.getExtension('OES_texture_float_linear');
				this.textureFloatFilterable = !!this.extTextureFloatLinear;
				this.extFloatBlend = this.getExtension('EXT_float_blend');
				this.extTextureFilterAnisotropic = this.getExtension('EXT_texture_filter_anisotropic', 'WEBKIT_EXT_texture_filter_anisotropic');
				this.extParallelShaderCompile = this.getExtension('KHR_parallel_shader_compile');
				this.extCompressedTextureETC1 = this.getExtension('WEBGL_compressed_texture_etc1');
				this.extCompressedTextureETC = this.getExtension('WEBGL_compressed_texture_etc');
				this.extCompressedTexturePVRTC = this.getExtension('WEBGL_compressed_texture_pvrtc', 'WEBKIT_WEBGL_compressed_texture_pvrtc');
				this.extCompressedTextureS3TC = this.getExtension('WEBGL_compressed_texture_s3tc', 'WEBKIT_WEBGL_compressed_texture_s3tc');
				this.extCompressedTextureS3TC_SRGB = this.getExtension('WEBGL_compressed_texture_s3tc_srgb');
				this.extCompressedTextureATC = this.getExtension('WEBGL_compressed_texture_atc');
				this.extCompressedTextureASTC = this.getExtension('WEBGL_compressed_texture_astc');
				this.extTextureCompressionBPTC = this.getExtension('EXT_texture_compression_bptc');
		}
		initializeCapabilities() {
				var gl = this.gl;
				var ext;
				var userAgent = typeof navigator !== 'undefined' ? navigator.userAgent : '';
				this.maxPrecision = this.precision = this.getPrecision();
				var contextAttribs = gl.getContextAttributes();
				var _contextAttribs_antialias;
				this.supportsMsaa = (_contextAttribs_antialias = contextAttribs == null ? void 0 : contextAttribs.antialias) != null ? _contextAttribs_antialias : false;
				var _contextAttribs_stencil;
				this.supportsStencil = (_contextAttribs_stencil = contextAttribs == null ? void 0 : contextAttribs.stencil) != null ? _contextAttribs_stencil : false;
				this.maxTextureSize = gl.getParameter(gl.MAX_TEXTURE_SIZE);
				this.maxCubeMapSize = gl.getParameter(gl.MAX_CUBE_MAP_TEXTURE_SIZE);
				this.maxRenderBufferSize = gl.getParameter(gl.MAX_RENDERBUFFER_SIZE);
				this.maxTextures = gl.getParameter(gl.MAX_TEXTURE_IMAGE_UNITS);
				this.maxCombinedTextures = gl.getParameter(gl.MAX_COMBINED_TEXTURE_IMAGE_UNITS);
				this.maxVertexTextures = gl.getParameter(gl.MAX_VERTEX_TEXTURE_IMAGE_UNITS);
				this.vertexUniformsCount = gl.getParameter(gl.MAX_VERTEX_UNIFORM_VECTORS);
				this.fragmentUniformsCount = gl.getParameter(gl.MAX_FRAGMENT_UNIFORM_VECTORS);
				this.maxColorAttachments = gl.getParameter(gl.MAX_COLOR_ATTACHMENTS);
				this.maxVolumeSize = gl.getParameter(gl.MAX_3D_TEXTURE_SIZE);
				ext = this.extDebugRendererInfo;
				this.unmaskedRenderer = ext ? gl.getParameter(ext.UNMASKED_RENDERER_WEBGL) : '';
				this.unmaskedVendor = ext ? gl.getParameter(ext.UNMASKED_VENDOR_WEBGL) : '';
				var maliRendererRegex = /\bMali-G52+/;
				var samsungModelRegex = /SM-[a-zA-Z0-9]+/;
				this.supportsGpuParticles = !(this.unmaskedVendor === 'ARM' && userAgent.match(samsungModelRegex)) && !this.unmaskedRenderer.match(maliRendererRegex);
				ext = this.extTextureFilterAnisotropic;
				this.maxAnisotropy = ext ? gl.getParameter(ext.MAX_TEXTURE_MAX_ANISOTROPY_EXT) : 1;
				var antialiasSupported = !this.forceDisableMultisampling;
				this.maxSamples = antialiasSupported ? gl.getParameter(gl.MAX_SAMPLES) : 1;
				this.maxSamples = Math.min(this.maxSamples, 4);
				this.samples = antialiasSupported && this.backBufferAntialias ? this.maxSamples : 1;
				this.supportsAreaLights = !platform.android;
				if (this.maxTextures <= 8) {
						this.supportsAreaLights = false;
				}
				this.initCapsDefines();
		}
		initializeRenderState() {
				super.initializeRenderState();
				var gl = this.gl;
				gl.disable(gl.BLEND);
				gl.blendFunc(gl.ONE, gl.ZERO);
				gl.blendEquation(gl.FUNC_ADD);
				gl.colorMask(true, true, true, true);
				gl.blendColor(0, 0, 0, 0);
				gl.enable(gl.CULL_FACE);
				this.cullFace = gl.BACK;
				gl.cullFace(gl.BACK);
				gl.enable(gl.DEPTH_TEST);
				gl.depthFunc(gl.LEQUAL);
				gl.depthMask(true);
				this.stencil = false;
				gl.disable(gl.STENCIL_TEST);
				this.stencilFuncFront = this.stencilFuncBack = FUNC_ALWAYS;
				this.stencilRefFront = this.stencilRefBack = 0;
				this.stencilMaskFront = this.stencilMaskBack = 0xFF;
				gl.stencilFunc(gl.ALWAYS, 0, 0xFF);
				this.stencilFailFront = this.stencilFailBack = STENCILOP_KEEP;
				this.stencilZfailFront = this.stencilZfailBack = STENCILOP_KEEP;
				this.stencilZpassFront = this.stencilZpassBack = STENCILOP_KEEP;
				this.stencilWriteMaskFront = 0xFF;
				this.stencilWriteMaskBack = 0xFF;
				gl.stencilOp(gl.KEEP, gl.KEEP, gl.KEEP);
				gl.stencilMask(0xFF);
				this.alphaToCoverage = false;
				this.raster = true;
				gl.disable(gl.SAMPLE_ALPHA_TO_COVERAGE);
				gl.disable(gl.RASTERIZER_DISCARD);
				this.depthBiasEnabled = false;
				gl.disable(gl.POLYGON_OFFSET_FILL);
				this.clearDepth = 1;
				gl.clearDepth(1);
				this.clearColor = new Color(0, 0, 0, 0);
				gl.clearColor(0, 0, 0, 0);
				this.clearStencil = 0;
				gl.clearStencil(0);
				gl.hint(gl.FRAGMENT_SHADER_DERIVATIVE_HINT, gl.NICEST);
				gl.enable(gl.SCISSOR_TEST);
				gl.pixelStorei(gl.UNPACK_COLORSPACE_CONVERSION_WEBGL, gl.NONE);
				this.unpackFlipY = false;
				gl.pixelStorei(gl.UNPACK_FLIP_Y_WEBGL, false);
				this.unpackPremultiplyAlpha = false;
				gl.pixelStorei(gl.UNPACK_PREMULTIPLY_ALPHA_WEBGL, false);
				gl.pixelStorei(gl.UNPACK_ALIGNMENT, 1);
		}
		initTextureUnits(count) {
				if (count === void 0) count = 16;
				this.textureUnits = [];
				for(var i = 0; i < count; i++){
						this.textureUnits.push([
								null,
								null,
								null
						]);
				}
		}
		initializeContextCaches() {
				super.initializeContextCaches();
				this._vaoMap = new Map();
				this.boundVao = null;
				this.activeFramebuffer = null;
				this.feedback = null;
				this.transformFeedbackBuffer = null;
				this.textureUnit = 0;
				this.initTextureUnits(this.maxCombinedTextures);
		}
		loseContext() {
				super.loseContext();
				for (var shader of this.shaders){
						shader.loseContext();
				}
		}
		restoreContext() {
				this.initializeExtensions();
				this.initializeCapabilities();
				super.restoreContext();
				for (var shader of this.shaders){
						shader.restoreContext();
				}
		}
		setViewport(x, y, w, h) {
				if (this.vx !== x || this.vy !== y || this.vw !== w || this.vh !== h) {
						this.gl.viewport(x, y, w, h);
						this.vx = x;
						this.vy = y;
						this.vw = w;
						this.vh = h;
				}
		}
		setScissor(x, y, w, h) {
				if (this.sx !== x || this.sy !== y || this.sw !== w || this.sh !== h) {
						this.gl.scissor(x, y, w, h);
						this.sx = x;
						this.sy = y;
						this.sw = w;
						this.sh = h;
				}
		}
		setFramebuffer(fb) {
				if (this.activeFramebuffer !== fb) {
						var gl = this.gl;
						gl.bindFramebuffer(gl.FRAMEBUFFER, fb);
						this.activeFramebuffer = fb;
				}
		}
		copyRenderTarget(source, dest, color, depth) {
				var _this_backBuffer, _this_backBuffer1;
				var gl = this.gl;
				if (source === this.backBuffer) {
						source = null;
				}
				if (color) {
						if (!dest) {
								if (!source._colorBuffer) {
										return false;
								}
						} else if (source) {
								if (!source._colorBuffer || !dest._colorBuffer) {
										return false;
								}
								if (source._colorBuffer._format !== dest._colorBuffer._format) {
										return false;
								}
						}
				}
				if (depth && source) {
						if (!source._depth) {
								if (!source._depthBuffer || !dest._depthBuffer) {
										return false;
								}
								if (source._depthBuffer._format !== dest._depthBuffer._format) {
										return false;
								}
						}
				}
				var prevRt = this.renderTarget;
				this.renderTarget = dest;
				this.updateBegin();
				var src = source ? source.impl._glFrameBuffer : (_this_backBuffer = this.backBuffer) == null ? void 0 : _this_backBuffer.impl._glFrameBuffer;
				var dst = dest ? dest.impl._glFrameBuffer : (_this_backBuffer1 = this.backBuffer) == null ? void 0 : _this_backBuffer1.impl._glFrameBuffer;
				gl.bindFramebuffer(gl.READ_FRAMEBUFFER, src);
				gl.bindFramebuffer(gl.DRAW_FRAMEBUFFER, dst);
				var w = source ? source.width : dest ? dest.width : this.width;
				var h = source ? source.height : dest ? dest.height : this.height;
				gl.blitFramebuffer(0, 0, w, h, 0, 0, w, h, (color ? gl.COLOR_BUFFER_BIT : 0) | (depth ? gl.DEPTH_BUFFER_BIT : 0), gl.NEAREST);
				this.renderTarget = prevRt;
				gl.bindFramebuffer(gl.FRAMEBUFFER, prevRt ? prevRt.impl._glFrameBuffer : null);
				return true;
		}
		frameStart() {
				super.frameStart();
				this.updateBackbuffer();
				this.gpuProfiler.frameStart();
		}
		frameEnd() {
				super.frameEnd();
				this.gpuProfiler.frameEnd();
				this.gpuProfiler.request();
		}
		startRenderPass(renderPass) {
				var _renderPass_renderTarget;
				var rt = (_renderPass_renderTarget = renderPass.renderTarget) != null ? _renderPass_renderTarget : this.backBuffer;
				this.renderTarget = rt;
				this.updateBegin();
				var { width, height } = rt;
				this.setViewport(0, 0, width, height);
				this.setScissor(0, 0, width, height);
				var colorOps = renderPass.colorOps;
				var depthStencilOps = renderPass.depthStencilOps;
				if ((colorOps == null ? void 0 : colorOps.clear) || depthStencilOps.clearDepth || depthStencilOps.clearStencil) {
						var clearFlags = 0;
						var clearOptions = {};
						if (colorOps == null ? void 0 : colorOps.clear) {
								clearFlags |= CLEARFLAG_COLOR;
								clearOptions.color = [
										colorOps.clearValue.r,
										colorOps.clearValue.g,
										colorOps.clearValue.b,
										colorOps.clearValue.a
								];
						}
						if (depthStencilOps.clearDepth) {
								clearFlags |= CLEARFLAG_DEPTH;
								clearOptions.depth = depthStencilOps.clearDepthValue;
						}
						if (depthStencilOps.clearStencil) {
								clearFlags |= CLEARFLAG_STENCIL;
								clearOptions.stencil = depthStencilOps.clearStencilValue;
						}
						clearOptions.flags = clearFlags;
						this.clear(clearOptions);
				}
				this.insideRenderPass = true;
		}
		endRenderPass(renderPass) {
				this.unbindVertexArray();
				var target = this.renderTarget;
				var colorBufferCount = renderPass.colorArrayOps.length;
				if (target) {
						var _renderPass_colorOps;
						invalidateAttachments.length = 0;
						var gl = this.gl;
						for(var i = 0; i < colorBufferCount; i++){
								var colorOps = renderPass.colorArrayOps[i];
								if (!(colorOps.store || colorOps.resolve)) {
										invalidateAttachments.push(gl.COLOR_ATTACHMENT0 + i);
								}
						}
						if (target !== this.backBuffer) {
								if (!renderPass.depthStencilOps.storeDepth) {
										invalidateAttachments.push(gl.DEPTH_ATTACHMENT);
								}
								if (!renderPass.depthStencilOps.storeStencil) {
										invalidateAttachments.push(gl.STENCIL_ATTACHMENT);
								}
						}
						if (invalidateAttachments.length > 0) {
								if (renderPass.fullSizeClearRect) {
										gl.invalidateFramebuffer(gl.DRAW_FRAMEBUFFER, invalidateAttachments);
								}
						}
						if (colorBufferCount && ((_renderPass_colorOps = renderPass.colorOps) == null ? void 0 : _renderPass_colorOps.resolve)) {
								if (renderPass.samples > 1 && target.autoResolve) {
										target.resolve(true, false);
								}
						}
						if (target.depthBuffer && renderPass.depthStencilOps.resolveDepth) {
								if (renderPass.samples > 1 && target.autoResolve) {
										target.resolve(false, true);
								}
						}
						for(var i1 = 0; i1 < colorBufferCount; i1++){
								var colorOps1 = renderPass.colorArrayOps[i1];
								if (colorOps1.genMipmaps) {
										var colorBuffer = target._colorBuffers[i1];
										if (colorBuffer && colorBuffer.impl._glTexture && colorBuffer.mipmaps) {
												this.activeTexture(this.maxCombinedTextures - 1);
												this.bindTexture(colorBuffer);
												this.gl.generateMipmap(colorBuffer.impl._glTarget);
										}
								}
						}
				}
				this.insideRenderPass = false;
		}
		set defaultFramebuffer(value) {
				if (this._defaultFramebuffer !== value) {
						this._defaultFramebuffer = value;
						this._defaultFramebufferChanged = true;
				}
		}
		get defaultFramebuffer() {
				return this._defaultFramebuffer;
		}
		updateBegin() {
				this.boundVao = null;
				if (this._tempEnableSafariTextureUnitWorkaround) {
						for(var unit = 0; unit < this.textureUnits.length; ++unit){
								for(var slot = 0; slot < 3; ++slot){
										this.textureUnits[unit][slot] = null;
								}
						}
				}
				var _this_renderTarget;
				var target = (_this_renderTarget = this.renderTarget) != null ? _this_renderTarget : this.backBuffer;
				var targetImpl = target.impl;
				if (!targetImpl.initialized) {
						this.initRenderTarget(target);
				}
				this.setFramebuffer(targetImpl._glFrameBuffer);
		}
		updateEnd() {
				this.unbindVertexArray();
				var target = this.renderTarget;
				if (target && target !== this.backBuffer) {
						if (target._samples > 1 && target.autoResolve) {
								target.resolve();
						}
						var colorBuffer = target._colorBuffer;
						if (colorBuffer && colorBuffer.impl._glTexture && colorBuffer.mipmaps) {
								this.activeTexture(this.maxCombinedTextures - 1);
								this.bindTexture(colorBuffer);
								this.gl.generateMipmap(colorBuffer.impl._glTarget);
						}
				}
		}
		setUnpackFlipY(flipY) {
				if (this.unpackFlipY !== flipY) {
						this.unpackFlipY = flipY;
						var gl = this.gl;
						gl.pixelStorei(gl.UNPACK_FLIP_Y_WEBGL, flipY);
				}
		}
		setUnpackPremultiplyAlpha(premultiplyAlpha) {
				if (this.unpackPremultiplyAlpha !== premultiplyAlpha) {
						this.unpackPremultiplyAlpha = premultiplyAlpha;
						var gl = this.gl;
						gl.pixelStorei(gl.UNPACK_PREMULTIPLY_ALPHA_WEBGL, premultiplyAlpha);
				}
		}
		activeTexture(textureUnit) {
				if (this.textureUnit !== textureUnit) {
						this.gl.activeTexture(this.gl.TEXTURE0 + textureUnit);
						this.textureUnit = textureUnit;
				}
		}
		bindTexture(texture) {
				var impl = texture.impl;
				var textureTarget = impl._glTarget;
				var textureObject = impl._glTexture;
				var textureUnit = this.textureUnit;
				var slot = this.targetToSlot[textureTarget];
				if (this.textureUnits[textureUnit][slot] !== textureObject) {
						this.gl.bindTexture(textureTarget, textureObject);
						this.textureUnits[textureUnit][slot] = textureObject;
				}
		}
		bindTextureOnUnit(texture, textureUnit) {
				var impl = texture.impl;
				var textureTarget = impl._glTarget;
				var textureObject = impl._glTexture;
				var slot = this.targetToSlot[textureTarget];
				if (this.textureUnits[textureUnit][slot] !== textureObject) {
						this.activeTexture(textureUnit);
						this.gl.bindTexture(textureTarget, textureObject);
						this.textureUnits[textureUnit][slot] = textureObject;
				}
		}
		setTextureParameters(texture) {
				var gl = this.gl;
				var flags = texture.impl.dirtyParameterFlags;
				var target = texture.impl._glTarget;
				if (flags & TEXPROPERTY_MIN_FILTER) {
						var filter = texture._minFilter;
						if (!texture._mipmaps || texture._compressed && texture._levels.length === 1) {
								if (filter === FILTER_NEAREST_MIPMAP_NEAREST || filter === FILTER_NEAREST_MIPMAP_LINEAR) {
										filter = FILTER_NEAREST;
								} else if (filter === FILTER_LINEAR_MIPMAP_NEAREST || filter === FILTER_LINEAR_MIPMAP_LINEAR) {
										filter = FILTER_LINEAR;
								}
						}
						gl.texParameteri(target, gl.TEXTURE_MIN_FILTER, this.glFilter[filter]);
				}
				if (flags & TEXPROPERTY_MAG_FILTER) {
						gl.texParameteri(target, gl.TEXTURE_MAG_FILTER, this.glFilter[texture._magFilter]);
				}
				if (flags & TEXPROPERTY_ADDRESS_U) {
						gl.texParameteri(target, gl.TEXTURE_WRAP_S, this.glAddress[texture._addressU]);
				}
				if (flags & TEXPROPERTY_ADDRESS_V) {
						gl.texParameteri(target, gl.TEXTURE_WRAP_T, this.glAddress[texture._addressV]);
				}
				if (flags & TEXPROPERTY_ADDRESS_W) {
						gl.texParameteri(target, gl.TEXTURE_WRAP_R, this.glAddress[texture._addressW]);
				}
				if (flags & TEXPROPERTY_COMPARE_ON_READ) {
						gl.texParameteri(target, gl.TEXTURE_COMPARE_MODE, texture._compareOnRead ? gl.COMPARE_REF_TO_TEXTURE : gl.NONE);
				}
				if (flags & TEXPROPERTY_COMPARE_FUNC) {
						gl.texParameteri(target, gl.TEXTURE_COMPARE_FUNC, this.glComparison[texture._compareFunc]);
				}
				if (flags & TEXPROPERTY_ANISOTROPY) {
						var ext = this.extTextureFilterAnisotropic;
						if (ext) {
								gl.texParameterf(target, ext.TEXTURE_MAX_ANISOTROPY_EXT, math.clamp(Math.round(texture._anisotropy), 1, this.maxAnisotropy));
						}
				}
		}
		setTexture(texture, textureUnit) {
				var impl = texture.impl;
				if (!impl._glTexture) {
						impl.initialize(this, texture);
				}
				if (impl.dirtyParameterFlags > 0 || texture._needsUpload || texture._needsMipmapsUpload) {
						this.activeTexture(textureUnit);
						this.bindTexture(texture);
						if (impl.dirtyParameterFlags) {
								this.setTextureParameters(texture);
								impl.dirtyParameterFlags = 0;
						}
						if (texture._needsUpload || texture._needsMipmapsUpload) {
								impl.upload(this, texture);
								texture._needsUpload = false;
								texture._needsMipmapsUpload = false;
						}
				} else {
						this.bindTextureOnUnit(texture, textureUnit);
				}
		}
		createVertexArray(vertexBuffers) {
				var key, vao;
				var useCache = vertexBuffers.length > 1;
				if (useCache) {
						key = '';
						for(var i = 0; i < vertexBuffers.length; i++){
								var vertexBuffer = vertexBuffers[i];
								key += vertexBuffer.id + vertexBuffer.format.renderingHash;
						}
						vao = this._vaoMap.get(key);
				}
				if (!vao) {
						var gl = this.gl;
						vao = gl.createVertexArray();
						gl.bindVertexArray(vao);
						gl.bindBuffer(gl.ELEMENT_ARRAY_BUFFER, null);
						for(var i1 = 0; i1 < vertexBuffers.length; i1++){
								var vertexBuffer1 = vertexBuffers[i1];
								gl.bindBuffer(gl.ARRAY_BUFFER, vertexBuffer1.impl.bufferId);
								var elements = vertexBuffer1.format.elements;
								for(var j = 0; j < elements.length; j++){
										var e = elements[j];
										var loc = semanticToLocation[e.name];
										if (e.asInt) {
												gl.vertexAttribIPointer(loc, e.numComponents, this.glType[e.dataType], e.stride, e.offset);
										} else {
												gl.vertexAttribPointer(loc, e.numComponents, this.glType[e.dataType], e.normalize, e.stride, e.offset);
										}
										gl.enableVertexAttribArray(loc);
										if (vertexBuffer1.format.instancing) {
												gl.vertexAttribDivisor(loc, 1);
										}
								}
						}
						gl.bindVertexArray(null);
						gl.bindBuffer(gl.ARRAY_BUFFER, null);
						if (useCache) {
								this._vaoMap.set(key, vao);
						}
				}
				return vao;
		}
		unbindVertexArray() {
				if (this.boundVao) {
						this.boundVao = null;
						this.gl.bindVertexArray(null);
				}
		}
		setBuffers() {
				var gl = this.gl;
				var vao;
				if (this.vertexBuffers.length === 1) {
						var vertexBuffer = this.vertexBuffers[0];
						if (!vertexBuffer.impl.vao) {
								vertexBuffer.impl.vao = this.createVertexArray(this.vertexBuffers);
						}
						vao = vertexBuffer.impl.vao;
				} else {
						vao = this.createVertexArray(this.vertexBuffers);
				}
				if (this.boundVao !== vao) {
						this.boundVao = vao;
						gl.bindVertexArray(vao);
				}
				this.clearVertexBuffer();
				var bufferId = this.indexBuffer ? this.indexBuffer.impl.bufferId : null;
				gl.bindBuffer(gl.ELEMENT_ARRAY_BUFFER, bufferId);
		}
		draw(primitive, numInstances, keepBuffers) {
				var gl = this.gl;
				this.activateShader(this);
				if (!this.shaderValid) {
						return;
				}
				var sampler, samplerValue, texture, numTextures;
				var uniform, scopeId, uniformVersion, programVersion;
				var shader = this.shader;
				if (!shader) {
						return;
				}
				var samplers = shader.impl.samplers;
				var uniforms = shader.impl.uniforms;
				if (!keepBuffers) {
						this.setBuffers();
				}
				var textureUnit = 0;
				for(var i = 0, len = samplers.length; i < len; i++){
						sampler = samplers[i];
						samplerValue = sampler.scopeId.value;
						if (!samplerValue) {
								var samplerName = sampler.scopeId.name;
								if (samplerName === 'uSceneDepthMap') {
										samplerValue = getBuiltInTexture(this, 'white');
								}
								if (samplerName === 'uSceneColorMap') {
										samplerValue = getBuiltInTexture(this, 'pink');
								}
								if (!samplerValue) {
										samplerValue = getBuiltInTexture(this, 'pink');
								}
						}
						if (samplerValue instanceof Texture) {
								texture = samplerValue;
								this.setTexture(texture, textureUnit);
								if (sampler.slot !== textureUnit) {
										gl.uniform1i(sampler.locationId, textureUnit);
										sampler.slot = textureUnit;
								}
								textureUnit++;
						} else {
								sampler.array.length = 0;
								numTextures = samplerValue.length;
								for(var j = 0; j < numTextures; j++){
										texture = samplerValue[j];
										this.setTexture(texture, textureUnit);
										sampler.array[j] = textureUnit;
										textureUnit++;
								}
								gl.uniform1iv(sampler.locationId, sampler.array);
						}
				}
				for(var i1 = 0, len1 = uniforms.length; i1 < len1; i1++){
						uniform = uniforms[i1];
						scopeId = uniform.scopeId;
						uniformVersion = uniform.version;
						programVersion = scopeId.versionObject.version;
						if (uniformVersion.globalId !== programVersion.globalId || uniformVersion.revision !== programVersion.revision) {
								uniformVersion.globalId = programVersion.globalId;
								uniformVersion.revision = programVersion.revision;
								if (scopeId.value !== null) {
										this.commitFunction[uniform.dataType](uniform, scopeId.value);
								}
						}
				}
				if (this.transformFeedbackBuffer) {
						gl.bindBufferBase(gl.TRANSFORM_FEEDBACK_BUFFER, 0, this.transformFeedbackBuffer.impl.bufferId);
						gl.beginTransformFeedback(gl.POINTS);
				}
				var mode = this.glPrimitive[primitive.type];
				var count = primitive.count;
				if (primitive.indexed) {
						var indexBuffer = this.indexBuffer;
						var format = indexBuffer.impl.glFormat;
						var offset = primitive.base * indexBuffer.bytesPerIndex;
						if (numInstances > 0) {
								gl.drawElementsInstanced(mode, count, format, offset, numInstances);
						} else {
								gl.drawElements(mode, count, format, offset);
						}
				} else {
						var first = primitive.base;
						if (numInstances > 0) {
								gl.drawArraysInstanced(mode, first, count, numInstances);
						} else {
								gl.drawArrays(mode, first, count);
						}
				}
				if (this.transformFeedbackBuffer) {
						gl.endTransformFeedback();
						gl.bindBufferBase(gl.TRANSFORM_FEEDBACK_BUFFER, 0, null);
				}
				this._drawCallsPerFrame++;
		}
		clear(options) {
				var defaultOptions = this.defaultClearOptions;
				options = options || defaultOptions;
				var _options_flags;
				var flags = (_options_flags = options.flags) != null ? _options_flags : defaultOptions.flags;
				if (flags !== 0) {
						var gl = this.gl;
						if (flags & CLEARFLAG_COLOR) {
								var _options_color;
								var color = (_options_color = options.color) != null ? _options_color : defaultOptions.color;
								var r = color[0];
								var g = color[1];
								var b = color[2];
								var a = color[3];
								var c = this.clearColor;
								if (r !== c.r || g !== c.g || b !== c.b || a !== c.a) {
										this.gl.clearColor(r, g, b, a);
										this.clearColor.set(r, g, b, a);
								}
								this.setBlendState(BlendState.NOBLEND);
						}
						if (flags & CLEARFLAG_DEPTH) {
								var _options_depth;
								var depth = (_options_depth = options.depth) != null ? _options_depth : defaultOptions.depth;
								if (depth !== this.clearDepth) {
										this.gl.clearDepth(depth);
										this.clearDepth = depth;
								}
								this.setDepthState(DepthState.WRITEDEPTH);
						}
						if (flags & CLEARFLAG_STENCIL) {
								var _options_stencil;
								var stencil = (_options_stencil = options.stencil) != null ? _options_stencil : defaultOptions.stencil;
								if (stencil !== this.clearStencil) {
										this.gl.clearStencil(stencil);
										this.clearStencil = stencil;
								}
								gl.stencilMask(0xFF);
								this.stencilWriteMaskFront = 0xFF;
								this.stencilWriteMaskBack = 0xFF;
						}
						gl.clear(this.glClearFlag[flags]);
				}
		}
		submit() {
				this.gl.flush();
		}
		readPixels(x, y, w, h, pixels) {
				var gl = this.gl;
				gl.readPixels(x, y, w, h, gl.RGBA, gl.UNSIGNED_BYTE, pixels);
		}
		readPixelsAsync(x, y, w, h, pixels) {
				var _this = this;
				return _async_to_generator$2(function*() {
						var _this_renderTarget_colorBuffer;
						var gl = _this.gl;
						var clientWaitAsync = (flags, interval_ms)=>{
								var sync = gl.fenceSync(gl.SYNC_GPU_COMMANDS_COMPLETE, 0);
								_this.submit();
								return new Promise((resolve, reject)=>{
										function test() {
												var res = gl.clientWaitSync(sync, flags, 0);
												if (res === gl.WAIT_FAILED) {
														gl.deleteSync(sync);
														reject(new Error('webgl clientWaitSync sync failed'));
												} else if (res === gl.TIMEOUT_EXPIRED) {
														setTimeout(test, interval_ms);
												} else {
														gl.deleteSync(sync);
														resolve();
												}
										}
										test();
								});
						};
						var impl = (_this_renderTarget_colorBuffer = _this.renderTarget.colorBuffer) == null ? void 0 : _this_renderTarget_colorBuffer.impl;
						var _impl__glFormat;
						var format = (_impl__glFormat = impl == null ? void 0 : impl._glFormat) != null ? _impl__glFormat : gl.RGBA;
						var _impl__glPixelType;
						var pixelType = (_impl__glPixelType = impl == null ? void 0 : impl._glPixelType) != null ? _impl__glPixelType : gl.UNSIGNED_BYTE;
						var buf = gl.createBuffer();
						gl.bindBuffer(gl.PIXEL_PACK_BUFFER, buf);
						gl.bufferData(gl.PIXEL_PACK_BUFFER, pixels.byteLength, gl.STREAM_READ);
						gl.readPixels(x, y, w, h, format, pixelType, 0);
						gl.bindBuffer(gl.PIXEL_PACK_BUFFER, null);
						yield clientWaitAsync(0, 20);
						gl.bindBuffer(gl.PIXEL_PACK_BUFFER, buf);
						gl.getBufferSubData(gl.PIXEL_PACK_BUFFER, 0, pixels);
						gl.bindBuffer(gl.PIXEL_PACK_BUFFER, null);
						gl.deleteBuffer(buf);
						return pixels;
				})();
		}
		readTextureAsync(texture, x, y, width, height, options) {
				var _options_face;
				var face = (_options_face = options.face) != null ? _options_face : 0;
				var _options_renderTarget;
				var renderTarget = (_options_renderTarget = options.renderTarget) != null ? _options_renderTarget : new RenderTarget({
						colorBuffer: texture,
						depth: false,
						face: face
				});
				var buffer = new ArrayBuffer(TextureUtils.calcLevelGpuSize(width, height, 1, texture._format));
				var _options_data;
				var data = (_options_data = options.data) != null ? _options_data : new (getPixelFormatArrayType(texture._format))(buffer);
				this.setRenderTarget(renderTarget);
				this.initRenderTarget(renderTarget);
				return new Promise((resolve, reject)=>{
						this.readPixelsAsync(x, y, width, height, data).then((data)=>{
								if (!options.renderTarget) {
										renderTarget.destroy();
								}
								resolve(data);
						}).catch(reject);
				});
		}
		setAlphaToCoverage(state) {
				if (this.alphaToCoverage !== state) {
						this.alphaToCoverage = state;
						if (state) {
								this.gl.enable(this.gl.SAMPLE_ALPHA_TO_COVERAGE);
						} else {
								this.gl.disable(this.gl.SAMPLE_ALPHA_TO_COVERAGE);
						}
				}
		}
		setTransformFeedbackBuffer(tf) {
				if (this.transformFeedbackBuffer !== tf) {
						this.transformFeedbackBuffer = tf;
						var gl = this.gl;
						if (tf) {
								if (!this.feedback) {
										this.feedback = gl.createTransformFeedback();
								}
								gl.bindTransformFeedback(gl.TRANSFORM_FEEDBACK, this.feedback);
						} else {
								gl.bindTransformFeedback(gl.TRANSFORM_FEEDBACK, null);
						}
				}
		}
		setRaster(on) {
				if (this.raster !== on) {
						this.raster = on;
						if (on) {
								this.gl.disable(this.gl.RASTERIZER_DISCARD);
						} else {
								this.gl.enable(this.gl.RASTERIZER_DISCARD);
						}
				}
		}
		setStencilTest(enable) {
				if (this.stencil !== enable) {
						var gl = this.gl;
						if (enable) {
								gl.enable(gl.STENCIL_TEST);
						} else {
								gl.disable(gl.STENCIL_TEST);
						}
						this.stencil = enable;
				}
		}
		setStencilFunc(func, ref, mask) {
				if (this.stencilFuncFront !== func || this.stencilRefFront !== ref || this.stencilMaskFront !== mask || this.stencilFuncBack !== func || this.stencilRefBack !== ref || this.stencilMaskBack !== mask) {
						this.gl.stencilFunc(this.glComparison[func], ref, mask);
						this.stencilFuncFront = this.stencilFuncBack = func;
						this.stencilRefFront = this.stencilRefBack = ref;
						this.stencilMaskFront = this.stencilMaskBack = mask;
				}
		}
		setStencilFuncFront(func, ref, mask) {
				if (this.stencilFuncFront !== func || this.stencilRefFront !== ref || this.stencilMaskFront !== mask) {
						var gl = this.gl;
						gl.stencilFuncSeparate(gl.FRONT, this.glComparison[func], ref, mask);
						this.stencilFuncFront = func;
						this.stencilRefFront = ref;
						this.stencilMaskFront = mask;
				}
		}
		setStencilFuncBack(func, ref, mask) {
				if (this.stencilFuncBack !== func || this.stencilRefBack !== ref || this.stencilMaskBack !== mask) {
						var gl = this.gl;
						gl.stencilFuncSeparate(gl.BACK, this.glComparison[func], ref, mask);
						this.stencilFuncBack = func;
						this.stencilRefBack = ref;
						this.stencilMaskBack = mask;
				}
		}
		setStencilOperation(fail, zfail, zpass, writeMask) {
				if (this.stencilFailFront !== fail || this.stencilZfailFront !== zfail || this.stencilZpassFront !== zpass || this.stencilFailBack !== fail || this.stencilZfailBack !== zfail || this.stencilZpassBack !== zpass) {
						this.gl.stencilOp(this.glStencilOp[fail], this.glStencilOp[zfail], this.glStencilOp[zpass]);
						this.stencilFailFront = this.stencilFailBack = fail;
						this.stencilZfailFront = this.stencilZfailBack = zfail;
						this.stencilZpassFront = this.stencilZpassBack = zpass;
				}
				if (this.stencilWriteMaskFront !== writeMask || this.stencilWriteMaskBack !== writeMask) {
						this.gl.stencilMask(writeMask);
						this.stencilWriteMaskFront = writeMask;
						this.stencilWriteMaskBack = writeMask;
				}
		}
		setStencilOperationFront(fail, zfail, zpass, writeMask) {
				if (this.stencilFailFront !== fail || this.stencilZfailFront !== zfail || this.stencilZpassFront !== zpass) {
						this.gl.stencilOpSeparate(this.gl.FRONT, this.glStencilOp[fail], this.glStencilOp[zfail], this.glStencilOp[zpass]);
						this.stencilFailFront = fail;
						this.stencilZfailFront = zfail;
						this.stencilZpassFront = zpass;
				}
				if (this.stencilWriteMaskFront !== writeMask) {
						this.gl.stencilMaskSeparate(this.gl.FRONT, writeMask);
						this.stencilWriteMaskFront = writeMask;
				}
		}
		setStencilOperationBack(fail, zfail, zpass, writeMask) {
				if (this.stencilFailBack !== fail || this.stencilZfailBack !== zfail || this.stencilZpassBack !== zpass) {
						this.gl.stencilOpSeparate(this.gl.BACK, this.glStencilOp[fail], this.glStencilOp[zfail], this.glStencilOp[zpass]);
						this.stencilFailBack = fail;
						this.stencilZfailBack = zfail;
						this.stencilZpassBack = zpass;
				}
				if (this.stencilWriteMaskBack !== writeMask) {
						this.gl.stencilMaskSeparate(this.gl.BACK, writeMask);
						this.stencilWriteMaskBack = writeMask;
				}
		}
		setBlendState(blendState) {
				var currentBlendState = this.blendState;
				if (!currentBlendState.equals(blendState)) {
						var gl = this.gl;
						var { blend, colorOp, alphaOp, colorSrcFactor, colorDstFactor, alphaSrcFactor, alphaDstFactor } = blendState;
						if (currentBlendState.blend !== blend) {
								if (blend) {
										gl.enable(gl.BLEND);
								} else {
										gl.disable(gl.BLEND);
								}
						}
						if (currentBlendState.colorOp !== colorOp || currentBlendState.alphaOp !== alphaOp) {
								var glBlendEquation = this.glBlendEquation;
								gl.blendEquationSeparate(glBlendEquation[colorOp], glBlendEquation[alphaOp]);
						}
						if (currentBlendState.colorSrcFactor !== colorSrcFactor || currentBlendState.colorDstFactor !== colorDstFactor || currentBlendState.alphaSrcFactor !== alphaSrcFactor || currentBlendState.alphaDstFactor !== alphaDstFactor) {
								gl.blendFuncSeparate(this.glBlendFunctionColor[colorSrcFactor], this.glBlendFunctionColor[colorDstFactor], this.glBlendFunctionAlpha[alphaSrcFactor], this.glBlendFunctionAlpha[alphaDstFactor]);
						}
						if (currentBlendState.allWrite !== blendState.allWrite) {
								this.gl.colorMask(blendState.redWrite, blendState.greenWrite, blendState.blueWrite, blendState.alphaWrite);
						}
						currentBlendState.copy(blendState);
				}
		}
		setBlendColor(r, g, b, a) {
				var c = this.blendColor;
				if (r !== c.r || g !== c.g || b !== c.b || a !== c.a) {
						this.gl.blendColor(r, g, b, a);
						c.set(r, g, b, a);
				}
		}
		setStencilState(stencilFront, stencilBack) {
				if (stencilFront || stencilBack) {
						this.setStencilTest(true);
						if (stencilFront === stencilBack) {
								this.setStencilFunc(stencilFront.func, stencilFront.ref, stencilFront.readMask);
								this.setStencilOperation(stencilFront.fail, stencilFront.zfail, stencilFront.zpass, stencilFront.writeMask);
						} else {
								stencilFront != null ? stencilFront : stencilFront = StencilParameters.DEFAULT;
								this.setStencilFuncFront(stencilFront.func, stencilFront.ref, stencilFront.readMask);
								this.setStencilOperationFront(stencilFront.fail, stencilFront.zfail, stencilFront.zpass, stencilFront.writeMask);
								stencilBack != null ? stencilBack : stencilBack = StencilParameters.DEFAULT;
								this.setStencilFuncBack(stencilBack.func, stencilBack.ref, stencilBack.readMask);
								this.setStencilOperationBack(stencilBack.fail, stencilBack.zfail, stencilBack.zpass, stencilBack.writeMask);
						}
				} else {
						this.setStencilTest(false);
				}
		}
		setDepthState(depthState) {
				var currentDepthState = this.depthState;
				if (!currentDepthState.equals(depthState)) {
						var gl = this.gl;
						var write = depthState.write;
						if (currentDepthState.write !== write) {
								gl.depthMask(write);
						}
						var { func, test } = depthState;
						if (!test && write) {
								test = true;
								func = FUNC_ALWAYS;
						}
						if (currentDepthState.func !== func) {
								gl.depthFunc(this.glComparison[func]);
						}
						if (currentDepthState.test !== test) {
								if (test) {
										gl.enable(gl.DEPTH_TEST);
								} else {
										gl.disable(gl.DEPTH_TEST);
								}
						}
						var { depthBias, depthBiasSlope } = depthState;
						if (depthBias || depthBiasSlope) {
								if (!this.depthBiasEnabled) {
										this.depthBiasEnabled = true;
										this.gl.enable(this.gl.POLYGON_OFFSET_FILL);
								}
								gl.polygonOffset(depthBiasSlope, depthBias);
						} else {
								if (this.depthBiasEnabled) {
										this.depthBiasEnabled = false;
										this.gl.disable(this.gl.POLYGON_OFFSET_FILL);
								}
						}
						currentDepthState.copy(depthState);
				}
		}
		setCullMode(cullMode) {
				if (this.cullMode !== cullMode) {
						if (cullMode === CULLFACE_NONE) {
								this.gl.disable(this.gl.CULL_FACE);
						} else {
								if (this.cullMode === CULLFACE_NONE) {
										this.gl.enable(this.gl.CULL_FACE);
								}
								var mode = this.glCull[cullMode];
								if (this.cullFace !== mode) {
										this.gl.cullFace(mode);
										this.cullFace = mode;
								}
						}
						this.cullMode = cullMode;
				}
		}
		setShader(shader, asyncCompile) {
				if (asyncCompile === void 0) asyncCompile = false;
				if (shader !== this.shader) {
						this.shader = shader;
						this.shaderAsyncCompile = asyncCompile;
						this.shaderValid = undefined;
				}
		}
		activateShader(device) {
				var { shader } = this;
				var { impl } = shader;
				if (this.shaderValid === undefined) {
						if (shader.failed) {
								this.shaderValid = false;
						} else if (!shader.ready) {
								if (this.shaderAsyncCompile) {
										if (impl.isLinked(device)) {
												if (!impl.finalize(this, shader)) {
														shader.failed = true;
														this.shaderValid = false;
												}
										} else {
												this.shaderValid = false;
										}
								} else {
										if (!impl.finalize(this, shader)) {
												shader.failed = true;
												this.shaderValid = false;
										}
								}
						}
				}
				if (this.shaderValid === undefined) {
						this.gl.useProgram(impl.glProgram);
						this.shaderValid = true;
				}
		}
		clearVertexArrayObjectCache() {
				var gl = this.gl;
				this._vaoMap.forEach((item, key, mapObj)=>{
						gl.deleteVertexArray(item);
				});
				this._vaoMap.clear();
		}
		set fullscreen(fullscreen) {
				if (fullscreen) {
						var canvas = this.gl.canvas;
						canvas.requestFullscreen();
				} else {
						document.exitFullscreen();
				}
		}
		get fullscreen() {
				return !!document.fullscreenElement;
		}
		constructor(canvas, options = {}){
				super(canvas, options), this._defaultFramebuffer = null, this._defaultFramebufferChanged = false;
				options = this.initOptions;
				this.updateClientRect();
				this.initTextureUnits();
				this.contextLost = false;
				this._contextLostHandler = (event)=>{
						event.preventDefault();
						this.loseContext();
						this.fire('devicelost');
				};
				this._contextRestoredHandler = ()=>{
						this.restoreContext();
						this.fire('devicerestored');
				};
				var ua = typeof navigator !== 'undefined' && navigator.userAgent;
				this.forceDisableMultisampling = ua && ua.includes('AppleWebKit') && (ua.includes('15.4') || ua.includes('15_4'));
				if (this.forceDisableMultisampling) {
						options.antialias = false;
				}
				if (platform.browserName === 'firefox') {
						var ua1 = typeof navigator !== 'undefined' ? navigator.userAgent : '';
						var match = ua1.match(/Firefox\/(\d+(\.\d+)*)/);
						var firefoxVersion = match ? match[1] : null;
						if (firefoxVersion) {
								var version = parseFloat(firefoxVersion);
								var disableAntialias = platform.name === 'windows' && (version >= 120 || version === 115) || platform.name === 'android' && version >= 132;
								if (disableAntialias) {
										options.antialias = false;
								}
						}
				}
				var _options_antialias;
				this.backBufferAntialias = (_options_antialias = options.antialias) != null ? _options_antialias : false;
				options.antialias = false;
				var _options_gl;
				var gl = (_options_gl = options.gl) != null ? _options_gl : canvas.getContext('webgl2', options);
				if (!gl) {
						throw new Error('WebGL not supported');
				}
				this.gl = gl;
				this.isWebGL2 = true;
				this._deviceType = DEVICETYPE_WEBGL2;
				this.updateBackbufferFormat(null);
				var isChrome = platform.browserName === 'chrome';
				var isSafari = platform.browserName === 'safari';
				var isMac = platform.browser && navigator.appVersion.indexOf('Mac') !== -1;
				this._tempEnableSafariTextureUnitWorkaround = isSafari;
				this._tempMacChromeBlitFramebufferWorkaround = isMac && isChrome && !options.alpha;
				canvas.addEventListener('webglcontextlost', this._contextLostHandler, false);
				canvas.addEventListener('webglcontextrestored', this._contextRestoredHandler, false);
				this.initializeExtensions();
				this.initializeCapabilities();
				this.initializeRenderState();
				this.initializeContextCaches();
				this.createBackbuffer(null);
				this.supportsImageBitmap = !isSafari && typeof ImageBitmap !== 'undefined';
				this._samplerTypes = new Set([
						gl.SAMPLER_2D,
						gl.SAMPLER_CUBE,
						gl.UNSIGNED_INT_SAMPLER_2D,
						gl.INT_SAMPLER_2D,
						gl.SAMPLER_2D_SHADOW,
						gl.SAMPLER_CUBE_SHADOW,
						gl.SAMPLER_3D,
						gl.INT_SAMPLER_3D,
						gl.UNSIGNED_INT_SAMPLER_3D,
						gl.SAMPLER_2D_ARRAY,
						gl.INT_SAMPLER_2D_ARRAY,
						gl.UNSIGNED_INT_SAMPLER_2D_ARRAY
				]);
				this.glAddress = [
						gl.REPEAT,
						gl.CLAMP_TO_EDGE,
						gl.MIRRORED_REPEAT
				];
				this.glBlendEquation = [
						gl.FUNC_ADD,
						gl.FUNC_SUBTRACT,
						gl.FUNC_REVERSE_SUBTRACT,
						gl.MIN,
						gl.MAX
				];
				this.glBlendFunctionColor = [
						gl.ZERO,
						gl.ONE,
						gl.SRC_COLOR,
						gl.ONE_MINUS_SRC_COLOR,
						gl.DST_COLOR,
						gl.ONE_MINUS_DST_COLOR,
						gl.SRC_ALPHA,
						gl.SRC_ALPHA_SATURATE,
						gl.ONE_MINUS_SRC_ALPHA,
						gl.DST_ALPHA,
						gl.ONE_MINUS_DST_ALPHA,
						gl.CONSTANT_COLOR,
						gl.ONE_MINUS_CONSTANT_COLOR
				];
				this.glBlendFunctionAlpha = [
						gl.ZERO,
						gl.ONE,
						gl.SRC_COLOR,
						gl.ONE_MINUS_SRC_COLOR,
						gl.DST_COLOR,
						gl.ONE_MINUS_DST_COLOR,
						gl.SRC_ALPHA,
						gl.SRC_ALPHA_SATURATE,
						gl.ONE_MINUS_SRC_ALPHA,
						gl.DST_ALPHA,
						gl.ONE_MINUS_DST_ALPHA,
						gl.CONSTANT_ALPHA,
						gl.ONE_MINUS_CONSTANT_ALPHA
				];
				this.glComparison = [
						gl.NEVER,
						gl.LESS,
						gl.EQUAL,
						gl.LEQUAL,
						gl.GREATER,
						gl.NOTEQUAL,
						gl.GEQUAL,
						gl.ALWAYS
				];
				this.glStencilOp = [
						gl.KEEP,
						gl.ZERO,
						gl.REPLACE,
						gl.INCR,
						gl.INCR_WRAP,
						gl.DECR,
						gl.DECR_WRAP,
						gl.INVERT
				];
				this.glClearFlag = [
						0,
						gl.COLOR_BUFFER_BIT,
						gl.DEPTH_BUFFER_BIT,
						gl.COLOR_BUFFER_BIT | gl.DEPTH_BUFFER_BIT,
						gl.STENCIL_BUFFER_BIT,
						gl.STENCIL_BUFFER_BIT | gl.COLOR_BUFFER_BIT,
						gl.STENCIL_BUFFER_BIT | gl.DEPTH_BUFFER_BIT,
						gl.STENCIL_BUFFER_BIT | gl.COLOR_BUFFER_BIT | gl.DEPTH_BUFFER_BIT
				];
				this.glCull = [
						0,
						gl.BACK,
						gl.FRONT,
						gl.FRONT_AND_BACK
				];
				this.glFilter = [
						gl.NEAREST,
						gl.LINEAR,
						gl.NEAREST_MIPMAP_NEAREST,
						gl.NEAREST_MIPMAP_LINEAR,
						gl.LINEAR_MIPMAP_NEAREST,
						gl.LINEAR_MIPMAP_LINEAR
				];
				this.glPrimitive = [
						gl.POINTS,
						gl.LINES,
						gl.LINE_LOOP,
						gl.LINE_STRIP,
						gl.TRIANGLES,
						gl.TRIANGLE_STRIP,
						gl.TRIANGLE_FAN
				];
				this.glType = [
						gl.BYTE,
						gl.UNSIGNED_BYTE,
						gl.SHORT,
						gl.UNSIGNED_SHORT,
						gl.INT,
						gl.UNSIGNED_INT,
						gl.FLOAT,
						gl.HALF_FLOAT
				];
				this.pcUniformType = {};
				this.pcUniformType[gl.BOOL] = UNIFORMTYPE_BOOL;
				this.pcUniformType[gl.INT] = UNIFORMTYPE_INT;
				this.pcUniformType[gl.FLOAT] = UNIFORMTYPE_FLOAT;
				this.pcUniformType[gl.FLOAT_VEC2] = UNIFORMTYPE_VEC2;
				this.pcUniformType[gl.FLOAT_VEC3] = UNIFORMTYPE_VEC3;
				this.pcUniformType[gl.FLOAT_VEC4] = UNIFORMTYPE_VEC4;
				this.pcUniformType[gl.INT_VEC2] = UNIFORMTYPE_IVEC2;
				this.pcUniformType[gl.INT_VEC3] = UNIFORMTYPE_IVEC3;
				this.pcUniformType[gl.INT_VEC4] = UNIFORMTYPE_IVEC4;
				this.pcUniformType[gl.BOOL_VEC2] = UNIFORMTYPE_BVEC2;
				this.pcUniformType[gl.BOOL_VEC3] = UNIFORMTYPE_BVEC3;
				this.pcUniformType[gl.BOOL_VEC4] = UNIFORMTYPE_BVEC4;
				this.pcUniformType[gl.FLOAT_MAT2] = UNIFORMTYPE_MAT2;
				this.pcUniformType[gl.FLOAT_MAT3] = UNIFORMTYPE_MAT3;
				this.pcUniformType[gl.FLOAT_MAT4] = UNIFORMTYPE_MAT4;
				this.pcUniformType[gl.SAMPLER_2D] = UNIFORMTYPE_TEXTURE2D;
				this.pcUniformType[gl.SAMPLER_CUBE] = UNIFORMTYPE_TEXTURECUBE;
				this.pcUniformType[gl.UNSIGNED_INT] = UNIFORMTYPE_UINT;
				this.pcUniformType[gl.UNSIGNED_INT_VEC2] = UNIFORMTYPE_UVEC2;
				this.pcUniformType[gl.UNSIGNED_INT_VEC3] = UNIFORMTYPE_UVEC3;
				this.pcUniformType[gl.UNSIGNED_INT_VEC4] = UNIFORMTYPE_UVEC4;
				this.pcUniformType[gl.SAMPLER_2D_SHADOW] = UNIFORMTYPE_TEXTURE2D_SHADOW;
				this.pcUniformType[gl.SAMPLER_CUBE_SHADOW] = UNIFORMTYPE_TEXTURECUBE_SHADOW;
				this.pcUniformType[gl.SAMPLER_2D_ARRAY] = UNIFORMTYPE_TEXTURE2D_ARRAY;
				this.pcUniformType[gl.SAMPLER_3D] = UNIFORMTYPE_TEXTURE3D;
				this.pcUniformType[gl.INT_SAMPLER_2D] = UNIFORMTYPE_ITEXTURE2D;
				this.pcUniformType[gl.UNSIGNED_INT_SAMPLER_2D] = UNIFORMTYPE_UTEXTURE2D;
				this.pcUniformType[gl.INT_SAMPLER_CUBE] = UNIFORMTYPE_ITEXTURECUBE;
				this.pcUniformType[gl.UNSIGNED_INT_SAMPLER_2D] = UNIFORMTYPE_UTEXTURECUBE;
				this.pcUniformType[gl.INT_SAMPLER_3D] = UNIFORMTYPE_ITEXTURE3D;
				this.pcUniformType[gl.UNSIGNED_INT_SAMPLER_3D] = UNIFORMTYPE_UTEXTURE3D;
				this.pcUniformType[gl.INT_SAMPLER_2D_ARRAY] = UNIFORMTYPE_ITEXTURE2D_ARRAY;
				this.pcUniformType[gl.UNSIGNED_INT_SAMPLER_2D_ARRAY] = UNIFORMTYPE_UTEXTURE2D_ARRAY;
				this.targetToSlot = {};
				this.targetToSlot[gl.TEXTURE_2D] = 0;
				this.targetToSlot[gl.TEXTURE_CUBE_MAP] = 1;
				this.targetToSlot[gl.TEXTURE_3D] = 2;
				var scopeX, scopeY, scopeZ, scopeW;
				var uniformValue;
				this.commitFunction = [];
				this.commitFunction[UNIFORMTYPE_BOOL] = function(uniform, value) {
						if (uniform.value !== value) {
								gl.uniform1i(uniform.locationId, value);
								uniform.value = value;
						}
				};
				this.commitFunction[UNIFORMTYPE_INT] = this.commitFunction[UNIFORMTYPE_BOOL];
				this.commitFunction[UNIFORMTYPE_FLOAT] = function(uniform, value) {
						if (uniform.value !== value) {
								gl.uniform1f(uniform.locationId, value);
								uniform.value = value;
						}
				};
				this.commitFunction[UNIFORMTYPE_VEC2] = function(uniform, value) {
						uniformValue = uniform.value;
						scopeX = value[0];
						scopeY = value[1];
						if (uniformValue[0] !== scopeX || uniformValue[1] !== scopeY) {
								gl.uniform2fv(uniform.locationId, value);
								uniformValue[0] = scopeX;
								uniformValue[1] = scopeY;
						}
				};
				this.commitFunction[UNIFORMTYPE_VEC3] = function(uniform, value) {
						uniformValue = uniform.value;
						scopeX = value[0];
						scopeY = value[1];
						scopeZ = value[2];
						if (uniformValue[0] !== scopeX || uniformValue[1] !== scopeY || uniformValue[2] !== scopeZ) {
								gl.uniform3fv(uniform.locationId, value);
								uniformValue[0] = scopeX;
								uniformValue[1] = scopeY;
								uniformValue[2] = scopeZ;
						}
				};
				this.commitFunction[UNIFORMTYPE_VEC4] = function(uniform, value) {
						uniformValue = uniform.value;
						scopeX = value[0];
						scopeY = value[1];
						scopeZ = value[2];
						scopeW = value[3];
						if (uniformValue[0] !== scopeX || uniformValue[1] !== scopeY || uniformValue[2] !== scopeZ || uniformValue[3] !== scopeW) {
								gl.uniform4fv(uniform.locationId, value);
								uniformValue[0] = scopeX;
								uniformValue[1] = scopeY;
								uniformValue[2] = scopeZ;
								uniformValue[3] = scopeW;
						}
				};
				this.commitFunction[UNIFORMTYPE_IVEC2] = function(uniform, value) {
						uniformValue = uniform.value;
						scopeX = value[0];
						scopeY = value[1];
						if (uniformValue[0] !== scopeX || uniformValue[1] !== scopeY) {
								gl.uniform2iv(uniform.locationId, value);
								uniformValue[0] = scopeX;
								uniformValue[1] = scopeY;
						}
				};
				this.commitFunction[UNIFORMTYPE_BVEC2] = this.commitFunction[UNIFORMTYPE_IVEC2];
				this.commitFunction[UNIFORMTYPE_IVEC3] = function(uniform, value) {
						uniformValue = uniform.value;
						scopeX = value[0];
						scopeY = value[1];
						scopeZ = value[2];
						if (uniformValue[0] !== scopeX || uniformValue[1] !== scopeY || uniformValue[2] !== scopeZ) {
								gl.uniform3iv(uniform.locationId, value);
								uniformValue[0] = scopeX;
								uniformValue[1] = scopeY;
								uniformValue[2] = scopeZ;
						}
				};
				this.commitFunction[UNIFORMTYPE_BVEC3] = this.commitFunction[UNIFORMTYPE_IVEC3];
				this.commitFunction[UNIFORMTYPE_IVEC4] = function(uniform, value) {
						uniformValue = uniform.value;
						scopeX = value[0];
						scopeY = value[1];
						scopeZ = value[2];
						scopeW = value[3];
						if (uniformValue[0] !== scopeX || uniformValue[1] !== scopeY || uniformValue[2] !== scopeZ || uniformValue[3] !== scopeW) {
								gl.uniform4iv(uniform.locationId, value);
								uniformValue[0] = scopeX;
								uniformValue[1] = scopeY;
								uniformValue[2] = scopeZ;
								uniformValue[3] = scopeW;
						}
				};
				this.commitFunction[UNIFORMTYPE_BVEC4] = this.commitFunction[UNIFORMTYPE_IVEC4];
				this.commitFunction[UNIFORMTYPE_MAT2] = function(uniform, value) {
						gl.uniformMatrix2fv(uniform.locationId, false, value);
				};
				this.commitFunction[UNIFORMTYPE_MAT3] = function(uniform, value) {
						gl.uniformMatrix3fv(uniform.locationId, false, value);
				};
				this.commitFunction[UNIFORMTYPE_MAT4] = function(uniform, value) {
						gl.uniformMatrix4fv(uniform.locationId, false, value);
				};
				this.commitFunction[UNIFORMTYPE_FLOATARRAY] = function(uniform, value) {
						gl.uniform1fv(uniform.locationId, value);
				};
				this.commitFunction[UNIFORMTYPE_VEC2ARRAY] = function(uniform, value) {
						gl.uniform2fv(uniform.locationId, value);
				};
				this.commitFunction[UNIFORMTYPE_VEC3ARRAY] = function(uniform, value) {
						gl.uniform3fv(uniform.locationId, value);
				};
				this.commitFunction[UNIFORMTYPE_VEC4ARRAY] = function(uniform, value) {
						gl.uniform4fv(uniform.locationId, value);
				};
				this.commitFunction[UNIFORMTYPE_UINT] = function(uniform, value) {
						if (uniform.value !== value) {
								gl.uniform1ui(uniform.locationId, value);
								uniform.value = value;
						}
				};
				this.commitFunction[UNIFORMTYPE_UVEC2] = function(uniform, value) {
						uniformValue = uniform.value;
						scopeX = value[0];
						scopeY = value[1];
						if (uniformValue[0] !== scopeX || uniformValue[1] !== scopeY) {
								gl.uniform2uiv(uniform.locationId, value);
								uniformValue[0] = scopeX;
								uniformValue[1] = scopeY;
						}
				};
				this.commitFunction[UNIFORMTYPE_UVEC3] = function(uniform, value) {
						uniformValue = uniform.value;
						scopeX = value[0];
						scopeY = value[1];
						scopeZ = value[2];
						if (uniformValue[0] !== scopeX || uniformValue[1] !== scopeY || uniformValue[2] !== scopeZ) {
								gl.uniform3uiv(uniform.locationId, value);
								uniformValue[0] = scopeX;
								uniformValue[1] = scopeY;
								uniformValue[2] = scopeZ;
						}
				};
				this.commitFunction[UNIFORMTYPE_UVEC4] = function(uniform, value) {
						uniformValue = uniform.value;
						scopeX = value[0];
						scopeY = value[1];
						scopeZ = value[2];
						scopeW = value[3];
						if (uniformValue[0] !== scopeX || uniformValue[1] !== scopeY || uniformValue[2] !== scopeZ || uniformValue[3] !== scopeW) {
								gl.uniform4uiv(uniform.locationId, value);
								uniformValue[0] = scopeX;
								uniformValue[1] = scopeY;
								uniformValue[2] = scopeZ;
								uniformValue[3] = scopeW;
						}
				};
				this.commitFunction[UNIFORMTYPE_INTARRAY] = function(uniform, value) {
						gl.uniform1iv(uniform.locationId, value);
				};
				this.commitFunction[UNIFORMTYPE_UINTARRAY] = function(uniform, value) {
						gl.uniform1uiv(uniform.locationId, value);
				};
				this.commitFunction[UNIFORMTYPE_BOOLARRAY] = this.commitFunction[UNIFORMTYPE_INTARRAY];
				this.commitFunction[UNIFORMTYPE_IVEC2ARRAY] = function(uniform, value) {
						gl.uniform2iv(uniform.locationId, value);
				};
				this.commitFunction[UNIFORMTYPE_UVEC2ARRAY] = function(uniform, value) {
						gl.uniform2uiv(uniform.locationId, value);
				};
				this.commitFunction[UNIFORMTYPE_BVEC2ARRAY] = this.commitFunction[UNIFORMTYPE_IVEC2ARRAY];
				this.commitFunction[UNIFORMTYPE_IVEC3ARRAY] = function(uniform, value) {
						gl.uniform3iv(uniform.locationId, value);
				};
				this.commitFunction[UNIFORMTYPE_UVEC3ARRAY] = function(uniform, value) {
						gl.uniform3uiv(uniform.locationId, value);
				};
				this.commitFunction[UNIFORMTYPE_BVEC3ARRAY] = this.commitFunction[UNIFORMTYPE_IVEC3ARRAY];
				this.commitFunction[UNIFORMTYPE_IVEC4ARRAY] = function(uniform, value) {
						gl.uniform4iv(uniform.locationId, value);
				};
				this.commitFunction[UNIFORMTYPE_UVEC4ARRAY] = function(uniform, value) {
						gl.uniform4uiv(uniform.locationId, value);
				};
				this.commitFunction[UNIFORMTYPE_BVEC4ARRAY] = this.commitFunction[UNIFORMTYPE_IVEC4ARRAY];
				this.commitFunction[UNIFORMTYPE_MAT4ARRAY] = function(uniform, value) {
						gl.uniformMatrix4fv(uniform.locationId, false, value);
				};
				this.constantTexSource = this.scope.resolve('source');
				this.postInit();
		}
}

var id$4 = 0;
class IndexBuffer {
		destroy() {
				var device = this.device;
				var idx = device.buffers.indexOf(this);
				if (idx !== -1) {
						device.buffers.splice(idx, 1);
				}
				if (this.device.indexBuffer === this) {
						this.device.indexBuffer = null;
				}
				if (this.impl.initialized) {
						this.impl.destroy(device);
						this.adjustVramSizeTracking(device._vram, -this.storage.byteLength);
				}
		}
		adjustVramSizeTracking(vram, size) {
				vram.ib += size;
		}
		loseContext() {
				this.impl.loseContext();
		}
		getFormat() {
				return this.format;
		}
		getNumIndices() {
				return this.numIndices;
		}
		lock() {
				return this.storage;
		}
		unlock() {
				this.impl.unlock(this);
		}
		setData(data) {
				if (data.byteLength !== this.numBytes) {
						return false;
				}
				this.storage = data;
				this.unlock();
				return true;
		}
		_lockTypedArray() {
				var lock = this.lock();
				var indices = this.format === INDEXFORMAT_UINT32 ? new Uint32Array(lock) : this.format === INDEXFORMAT_UINT16 ? new Uint16Array(lock) : new Uint8Array(lock);
				return indices;
		}
		writeData(data, count) {
				var indices = this._lockTypedArray();
				if (data.length > count) {
						if (ArrayBuffer.isView(data)) {
								data = data.subarray(0, count);
								indices.set(data);
						} else {
								for(var i = 0; i < count; i++){
										indices[i] = data[i];
								}
						}
				} else {
						indices.set(data);
				}
				this.unlock();
		}
		readData(data) {
				var indices = this._lockTypedArray();
				var count = this.numIndices;
				if (ArrayBuffer.isView(data)) {
						data.set(indices);
				} else {
						data.length = 0;
						for(var i = 0; i < count; i++){
								data[i] = indices[i];
						}
				}
				return count;
		}
		constructor(graphicsDevice, format, numIndices, usage = BUFFER_STATIC, initialData, options){
				this.device = graphicsDevice;
				this.format = format;
				this.numIndices = numIndices;
				this.usage = usage;
				this.id = id$4++;
				this.impl = graphicsDevice.createIndexBufferImpl(this, options);
				var bytesPerIndex = typedArrayIndexFormatsByteSize[format];
				this.bytesPerIndex = bytesPerIndex;
				this.numBytes = this.numIndices * bytesPerIndex;
				if (initialData) {
						this.setData(initialData);
				} else {
						this.storage = new ArrayBuffer(this.numBytes);
				}
				this.adjustVramSizeTracking(graphicsDevice._vram, this.numBytes);
				this.device.buffers.push(this);
		}
}

class ColorAttachmentOps {
		constructor(){
				this.clearValue = new Color(0, 0, 0, 1);
				this.clearValueLinear = new Color(0, 0, 0, 1);
				this.clear = false;
				this.store = false;
				this.resolve = true;
				this.genMipmaps = false;
		}
}
class DepthStencilAttachmentOps {
		constructor(){
				this.clearDepthValue = 1;
				this.clearStencilValue = 0;
				this.clearDepth = false;
				this.clearStencil = false;
				this.storeDepth = false;
				this.resolveDepth = false;
				this.storeStencil = false;
		}
}
class RenderPass {
		get colorOps() {
				return this.colorArrayOps[0];
		}
		set name(value) {
				this._name = value;
		}
		get name() {
				if (!this._name) {
						this._name = this.constructor.name;
				}
				return this._name;
		}
		set scaleX(value) {
				this._options.scaleX = value;
		}
		get scaleX() {
				return this._options.scaleX;
		}
		set scaleY(value) {
				this._options.scaleY = value;
		}
		get scaleY() {
				return this._options.scaleY;
		}
		set options(value) {
				this._options = value;
				if (value) {
						var _this_scaleX;
						this.scaleX = (_this_scaleX = this.scaleX) != null ? _this_scaleX : 1;
						var _this_scaleY;
						this.scaleY = (_this_scaleY = this.scaleY) != null ? _this_scaleY : 1;
				}
		}
		get options() {
				return this._options;
		}
		init(renderTarget, options) {
				if (renderTarget === void 0) renderTarget = null;
				this.options = options;
				this.renderTarget = renderTarget;
				this.samples = Math.max(this.renderTarget ? this.renderTarget.samples : this.device.samples, 1);
				this.allocateAttachments();
				this.postInit();
		}
		allocateAttachments() {
				var _rt__colorBuffers;
				var rt = this.renderTarget;
				this.depthStencilOps = new DepthStencilAttachmentOps();
				if (rt == null ? void 0 : rt.depthBuffer) {
						this.depthStencilOps.storeDepth = true;
				}
				var _rt__colorBuffers_length;
				var numColorOps = rt ? (_rt__colorBuffers_length = (_rt__colorBuffers = rt._colorBuffers) == null ? void 0 : _rt__colorBuffers.length) != null ? _rt__colorBuffers_length : 0 : 1;
				this.colorArrayOps.length = 0;
				for(var i = 0; i < numColorOps; i++){
						var _this_renderTarget__colorBuffers, _this_renderTarget, _this_renderTarget1;
						var colorOps = new ColorAttachmentOps();
						this.colorArrayOps[i] = colorOps;
						if (this.samples === 1) {
								colorOps.store = true;
								colorOps.resolve = false;
						}
						var colorBuffer = (_this_renderTarget = this.renderTarget) == null ? void 0 : (_this_renderTarget__colorBuffers = _this_renderTarget._colorBuffers) == null ? void 0 : _this_renderTarget__colorBuffers[i];
						if (((_this_renderTarget1 = this.renderTarget) == null ? void 0 : _this_renderTarget1.mipmaps) && (colorBuffer == null ? void 0 : colorBuffer.mipmaps)) {
								var intFormat = isIntegerPixelFormat(colorBuffer._format);
								colorOps.genMipmaps = !intFormat;
						}
				}
		}
		destroy() {}
		postInit() {}
		frameUpdate() {
				if (this._options && this.renderTarget) {
						var _this__options_resizeSource;
						var resizeSource = (_this__options_resizeSource = this._options.resizeSource) != null ? _this__options_resizeSource : this.device.backBuffer;
						var width = Math.floor(resizeSource.width * this.scaleX);
						var height = Math.floor(resizeSource.height * this.scaleY);
						this.renderTarget.resize(width, height);
				}
		}
		before() {}
		execute() {}
		after() {}
		onEnable() {}
		onDisable() {}
		set enabled(value) {
				if (this._enabled !== value) {
						this._enabled = value;
						if (value) {
								this.onEnable();
						} else {
								this.onDisable();
						}
				}
		}
		get enabled() {
				return this._enabled;
		}
		setClearColor(color) {
				var count = this.colorArrayOps.length;
				for(var i = 0; i < count; i++){
						var colorOps = this.colorArrayOps[i];
						if (color) {
								colorOps.clearValue.copy(color);
								colorOps.clearValueLinear.linear(color);
						}
						colorOps.clear = !!color;
				}
		}
		setClearDepth(depthValue) {
				if (depthValue) {
						this.depthStencilOps.clearDepthValue = depthValue;
				}
				this.depthStencilOps.clearDepth = depthValue !== undefined;
		}
		setClearStencil(stencilValue) {
				if (stencilValue) {
						this.depthStencilOps.clearStencilValue = stencilValue;
				}
				this.depthStencilOps.clearStencil = stencilValue !== undefined;
		}
		render() {
				if (this.enabled) {
						var device = this.device;
						var realPass = this.renderTarget !== undefined;
						this.before();
						if (this.executeEnabled) {
								if (realPass && !this._skipStart) {
										device.startRenderPass(this);
								}
								this.execute();
								if (realPass && !this._skipEnd) {
										device.endRenderPass(this);
								}
						}
						this.after();
						device.renderPassIndex++;
				}
		}
		constructor(graphicsDevice){
				this._enabled = true;
				this._skipStart = false;
				this._skipEnd = false;
				this.executeEnabled = true;
				this.samples = 0;
				this.colorArrayOps = [];
				this.requiresCubemaps = true;
				this.fullSizeClearRect = true;
				this.beforePasses = [];
				this.afterPasses = [];
				this.device = graphicsDevice;
		}
}

function set1(a) {
		this.array[this.index] = a;
}
function set2(a, b) {
		this.array[this.index] = a;
		this.array[this.index + 1] = b;
}
function set3(a, b, c) {
		this.array[this.index] = a;
		this.array[this.index + 1] = b;
		this.array[this.index + 2] = c;
}
function set4(a, b, c, d) {
		this.array[this.index] = a;
		this.array[this.index + 1] = b;
		this.array[this.index + 2] = c;
		this.array[this.index + 3] = d;
}
function arraySet1(index, inputArray, inputIndex) {
		this.array[index] = inputArray[inputIndex];
}
function arraySet2(index, inputArray, inputIndex) {
		this.array[index] = inputArray[inputIndex];
		this.array[index + 1] = inputArray[inputIndex + 1];
}
function arraySet3(index, inputArray, inputIndex) {
		this.array[index] = inputArray[inputIndex];
		this.array[index + 1] = inputArray[inputIndex + 1];
		this.array[index + 2] = inputArray[inputIndex + 2];
}
function arraySet4(index, inputArray, inputIndex) {
		this.array[index] = inputArray[inputIndex];
		this.array[index + 1] = inputArray[inputIndex + 1];
		this.array[index + 2] = inputArray[inputIndex + 2];
		this.array[index + 3] = inputArray[inputIndex + 3];
}
function arrayGet1(offset, outputArray, outputIndex) {
		outputArray[outputIndex] = this.array[offset];
}
function arrayGet2(offset, outputArray, outputIndex) {
		outputArray[outputIndex] = this.array[offset];
		outputArray[outputIndex + 1] = this.array[offset + 1];
}
function arrayGet3(offset, outputArray, outputIndex) {
		outputArray[outputIndex] = this.array[offset];
		outputArray[outputIndex + 1] = this.array[offset + 1];
		outputArray[outputIndex + 2] = this.array[offset + 2];
}
function arrayGet4(offset, outputArray, outputIndex) {
		outputArray[outputIndex] = this.array[offset];
		outputArray[outputIndex + 1] = this.array[offset + 1];
		outputArray[outputIndex + 2] = this.array[offset + 2];
		outputArray[outputIndex + 3] = this.array[offset + 3];
}
class VertexIteratorAccessor {
		get(offset) {
				return this.array[this.index + offset];
		}
		set(a, b, c, d) {}
		getToArray(offset, outputArray, outputIndex) {}
		setFromArray(index, inputArray, inputIndex) {}
		constructor(buffer, vertexElement, vertexFormat){
				this.index = 0;
				this.numComponents = vertexElement.numComponents;
				if (vertexFormat.interleaved) {
						this.array = new typedArrayTypes[vertexElement.dataType](buffer, vertexElement.offset);
				} else {
						this.array = new typedArrayTypes[vertexElement.dataType](buffer, vertexElement.offset, vertexFormat.vertexCount * vertexElement.numComponents);
				}
				this.stride = vertexElement.stride / this.array.constructor.BYTES_PER_ELEMENT;
				switch(vertexElement.numComponents){
						case 1:
								this.set = set1;
								this.getToArray = arrayGet1;
								this.setFromArray = arraySet1;
								break;
						case 2:
								this.set = set2;
								this.getToArray = arrayGet2;
								this.setFromArray = arraySet2;
								break;
						case 3:
								this.set = set3;
								this.getToArray = arrayGet3;
								this.setFromArray = arraySet3;
								break;
						case 4:
								this.set = set4;
								this.getToArray = arrayGet4;
								this.setFromArray = arraySet4;
								break;
				}
		}
}
class VertexIterator {
		next(count) {
				if (count === void 0) count = 1;
				var i = 0;
				var accessors = this.accessors;
				var numAccessors = this.accessors.length;
				while(i < numAccessors){
						var accessor = accessors[i++];
						accessor.index += count * accessor.stride;
				}
		}
		end() {
				this.vertexBuffer.unlock();
		}
		writeData(semantic, data, numVertices) {
				var element = this.element[semantic];
				if (element) {
						if (numVertices > this.vertexBuffer.numVertices) {
								numVertices = this.vertexBuffer.numVertices;
						}
						var numComponents = element.numComponents;
						if (this.vertexBuffer.getFormat().interleaved) {
								var index = 0;
								for(var i = 0; i < numVertices; i++){
										element.setFromArray(index, data, i * numComponents);
										index += element.stride;
								}
						} else {
								if (data.length > numVertices * numComponents) {
										var copyCount = numVertices * numComponents;
										if (ArrayBuffer.isView(data)) {
												data = data.subarray(0, copyCount);
												element.array.set(data);
										} else {
												for(var i1 = 0; i1 < copyCount; i1++){
														element.array[i1] = data[i1];
												}
										}
								} else {
										element.array.set(data);
								}
						}
				}
		}
		readData(semantic, data) {
				var element = this.element[semantic];
				var count = 0;
				if (element) {
						count = this.vertexBuffer.numVertices;
						var i;
						var numComponents = element.numComponents;
						if (this.vertexBuffer.getFormat().interleaved) {
								if (Array.isArray(data)) {
										data.length = 0;
								}
								element.index = 0;
								var offset = 0;
								for(i = 0; i < count; i++){
										element.getToArray(offset, data, i * numComponents);
										offset += element.stride;
								}
						} else {
								if (ArrayBuffer.isView(data)) {
										data.set(element.array);
								} else {
										data.length = 0;
										var copyCount = count * numComponents;
										for(i = 0; i < copyCount; i++){
												data[i] = element.array[i];
										}
								}
						}
				}
				return count;
		}
		constructor(vertexBuffer){
				this.vertexBuffer = vertexBuffer;
				this.vertexFormatSize = vertexBuffer.getFormat().size;
				this.buffer = this.vertexBuffer.lock();
				this.accessors = [];
				this.element = {};
				var vertexFormat = this.vertexBuffer.getFormat();
				for(var i = 0; i < vertexFormat.elements.length; i++){
						var vertexElement = vertexFormat.elements[i];
						this.accessors[i] = new VertexIteratorAccessor(this.buffer, vertexElement, vertexFormat);
						this.element[vertexElement.name] = this.accessors[i];
				}
		}
}

var EVENT_MOUSEDOWN = 'mousedown';
var EVENT_MOUSEMOVE = 'mousemove';
var EVENT_MOUSEUP = 'mouseup';
var EVENT_MOUSEWHEEL = 'mousewheel';
var MOUSEBUTTON_NONE = -1;

class KeyboardEvent {
		constructor(keyboard, event){
				this.key = null;
				this.element = null;
				this.event = null;
				if (event) {
						this.key = event.keyCode;
						this.element = event.target;
						this.event = event;
				}
		}
}

var _keyboardEvent = new KeyboardEvent();
function makeKeyboardEvent(event) {
		_keyboardEvent.key = event.keyCode;
		_keyboardEvent.element = event.target;
		_keyboardEvent.event = event;
		return _keyboardEvent;
}
function toKeyCode(s) {
		if (typeof s === 'string') {
				return s.toUpperCase().charCodeAt(0);
		}
		return s;
}
var _keyCodeToKeyIdentifier = {
		'9': 'Tab',
		'13': 'Enter',
		'16': 'Shift',
		'17': 'Control',
		'18': 'Alt',
		'27': 'Escape',
		'37': 'Left',
		'38': 'Up',
		'39': 'Right',
		'40': 'Down',
		'46': 'Delete',
		'91': 'Win'
};
class Keyboard extends EventHandler {
		attach(element) {
				if (this._element) {
						this.detach();
				}
				this._element = element;
				this._element.addEventListener('keydown', this._keyDownHandler, false);
				this._element.addEventListener('keypress', this._keyPressHandler, false);
				this._element.addEventListener('keyup', this._keyUpHandler, false);
				document.addEventListener('visibilitychange', this._visibilityChangeHandler, false);
				window.addEventListener('blur', this._windowBlurHandler, false);
		}
		detach() {
				if (!this._element) {
						return;
				}
				this._element.removeEventListener('keydown', this._keyDownHandler);
				this._element.removeEventListener('keypress', this._keyPressHandler);
				this._element.removeEventListener('keyup', this._keyUpHandler);
				this._element = null;
				document.removeEventListener('visibilitychange', this._visibilityChangeHandler, false);
				window.removeEventListener('blur', this._windowBlurHandler, false);
		}
		toKeyIdentifier(keyCode) {
				keyCode = toKeyCode(keyCode);
				var id = _keyCodeToKeyIdentifier[keyCode.toString()];
				if (id) {
						return id;
				}
				var hex = keyCode.toString(16).toUpperCase();
				var length = hex.length;
				for(var count = 0; count < 4 - length; count++){
						hex = "0" + hex;
				}
				return "U+" + hex;
		}
		_handleKeyDown(event) {
				var code = event.keyCode || event.charCode;
				if (code === undefined) return;
				var id = this.toKeyIdentifier(code);
				this._keymap[id] = true;
				this.fire('keydown', makeKeyboardEvent(event));
				if (this.preventDefault) {
						event.preventDefault();
				}
				if (this.stopPropagation) {
						event.stopPropagation();
				}
		}
		_handleKeyUp(event) {
				var code = event.keyCode || event.charCode;
				if (code === undefined) return;
				var id = this.toKeyIdentifier(code);
				delete this._keymap[id];
				this.fire('keyup', makeKeyboardEvent(event));
				if (this.preventDefault) {
						event.preventDefault();
				}
				if (this.stopPropagation) {
						event.stopPropagation();
				}
		}
		_handleKeyPress(event) {
				this.fire('keypress', makeKeyboardEvent(event));
				if (this.preventDefault) {
						event.preventDefault();
				}
				if (this.stopPropagation) {
						event.stopPropagation();
				}
		}
		_handleVisibilityChange() {
				if (document.visibilityState === 'hidden') {
						this._handleWindowBlur();
				}
		}
		_handleWindowBlur() {
				this._keymap = {};
				this._lastmap = {};
		}
		update() {
				for(var prop in this._lastmap){
						delete this._lastmap[prop];
				}
				for(var prop1 in this._keymap){
						if (this._keymap.hasOwnProperty(prop1)) {
								this._lastmap[prop1] = this._keymap[prop1];
						}
				}
		}
		isPressed(key) {
				var keyCode = toKeyCode(key);
				var id = this.toKeyIdentifier(keyCode);
				return !!this._keymap[id];
		}
		wasPressed(key) {
				var keyCode = toKeyCode(key);
				var id = this.toKeyIdentifier(keyCode);
				return !!this._keymap[id] && !!!this._lastmap[id];
		}
		wasReleased(key) {
				var keyCode = toKeyCode(key);
				var id = this.toKeyIdentifier(keyCode);
				return !!!this._keymap[id] && !!this._lastmap[id];
		}
		constructor(element, options = {}){
				super(), this._element = null, this._keymap = {}, this._lastmap = {};
				this._keyDownHandler = this._handleKeyDown.bind(this);
				this._keyUpHandler = this._handleKeyUp.bind(this);
				this._keyPressHandler = this._handleKeyPress.bind(this);
				this._visibilityChangeHandler = this._handleVisibilityChange.bind(this);
				this._windowBlurHandler = this._handleWindowBlur.bind(this);
				if (element) {
						this.attach(element);
				}
				this.preventDefault = options.preventDefault || false;
				this.stopPropagation = options.stopPropagation || false;
		}
}
Keyboard.EVENT_KEYDOWN = 'keydown';
Keyboard.EVENT_KEYUP = 'keyup';

function isMousePointerLocked() {
		return !!(document.pointerLockElement || document.mozPointerLockElement || document.webkitPointerLockElement);
}
class MouseEvent {
		constructor(mouse, event){
				this.x = 0;
				this.y = 0;
				this.dx = 0;
				this.dy = 0;
				this.button = MOUSEBUTTON_NONE;
				this.wheelDelta = 0;
				this.ctrlKey = false;
				this.altKey = false;
				this.shiftKey = false;
				this.metaKey = false;
				var coords = {
						x: 0,
						y: 0
				};
				if (event) {
						if (event instanceof MouseEvent) {
								throw Error('Expected MouseEvent');
						}
						coords = mouse._getTargetCoords(event);
				} else {
						event = {};
				}
				if (coords) {
						this.x = coords.x;
						this.y = coords.y;
				} else if (isMousePointerLocked()) {
						this.x = 0;
						this.y = 0;
				} else {
						return;
				}
				if (event.type === 'wheel') {
						if (event.deltaY > 0) {
								this.wheelDelta = 1;
						} else if (event.deltaY < 0) {
								this.wheelDelta = -1;
						}
				}
				if (isMousePointerLocked()) {
						this.dx = event.movementX || event.webkitMovementX || event.mozMovementX || 0;
						this.dy = event.movementY || event.webkitMovementY || event.mozMovementY || 0;
				} else {
						this.dx = this.x - mouse._lastX;
						this.dy = this.y - mouse._lastY;
				}
				if (event.type === 'mousedown' || event.type === 'mouseup') {
						this.button = event.button;
				}
				this.buttons = mouse._buttons.slice(0);
				this.element = event.target;
				var _event_ctrlKey;
				this.ctrlKey = (_event_ctrlKey = event.ctrlKey) != null ? _event_ctrlKey : false;
				var _event_altKey;
				this.altKey = (_event_altKey = event.altKey) != null ? _event_altKey : false;
				var _event_shiftKey;
				this.shiftKey = (_event_shiftKey = event.shiftKey) != null ? _event_shiftKey : false;
				var _event_metaKey;
				this.metaKey = (_event_metaKey = event.metaKey) != null ? _event_metaKey : false;
				this.event = event;
		}
}

class Mouse extends EventHandler {
		static isPointerLocked() {
				return isMousePointerLocked();
		}
		attach(element) {
				this._target = element;
				if (this._attached) return;
				this._attached = true;
				var passiveOptions = {
						passive: false
				};
				var options = platform.passiveEvents ? passiveOptions : false;
				window.addEventListener('mouseup', this._upHandler, options);
				window.addEventListener('mousedown', this._downHandler, options);
				window.addEventListener('mousemove', this._moveHandler, options);
				window.addEventListener('wheel', this._wheelHandler, options);
		}
		detach() {
				if (!this._attached) return;
				this._attached = false;
				this._target = null;
				var passiveOptions = {
						passive: false
				};
				var options = platform.passiveEvents ? passiveOptions : false;
				window.removeEventListener('mouseup', this._upHandler, options);
				window.removeEventListener('mousedown', this._downHandler, options);
				window.removeEventListener('mousemove', this._moveHandler, options);
				window.removeEventListener('wheel', this._wheelHandler, options);
		}
		disableContextMenu() {
				if (!this._target) return;
				this._target.addEventListener('contextmenu', this._contextMenuHandler);
		}
		enableContextMenu() {
				if (!this._target) return;
				this._target.removeEventListener('contextmenu', this._contextMenuHandler);
		}
		enablePointerLock(success, error) {
				if (!document.body.requestPointerLock) {
						if (error) {
								error();
						}
						return;
				}
				var s = ()=>{
						success();
						document.removeEventListener('pointerlockchange', s);
				};
				var e = ()=>{
						error();
						document.removeEventListener('pointerlockerror', e);
				};
				if (success) {
						document.addEventListener('pointerlockchange', s, false);
				}
				if (error) {
						document.addEventListener('pointerlockerror', e, false);
				}
				document.body.requestPointerLock();
		}
		disablePointerLock(success) {
				if (!document.exitPointerLock) {
						return;
				}
				var s = ()=>{
						success();
						document.removeEventListener('pointerlockchange', s);
				};
				if (success) {
						document.addEventListener('pointerlockchange', s, false);
				}
				document.exitPointerLock();
		}
		update() {
				this._lastbuttons[0] = this._buttons[0];
				this._lastbuttons[1] = this._buttons[1];
				this._lastbuttons[2] = this._buttons[2];
		}
		isPressed(button) {
				return this._buttons[button];
		}
		wasPressed(button) {
				return this._buttons[button] && !this._lastbuttons[button];
		}
		wasReleased(button) {
				return !this._buttons[button] && this._lastbuttons[button];
		}
		_handleUp(event) {
				this._buttons[event.button] = false;
				var e = new MouseEvent(this, event);
				if (!e.event) return;
				this.fire(EVENT_MOUSEUP, e);
		}
		_handleDown(event) {
				this._buttons[event.button] = true;
				var e = new MouseEvent(this, event);
				if (!e.event) return;
				this.fire(EVENT_MOUSEDOWN, e);
		}
		_handleMove(event) {
				var e = new MouseEvent(this, event);
				if (!e.event) return;
				this.fire(EVENT_MOUSEMOVE, e);
				this._lastX = e.x;
				this._lastY = e.y;
		}
		_handleWheel(event) {
				var e = new MouseEvent(this, event);
				if (!e.event) return;
				this.fire(EVENT_MOUSEWHEEL, e);
		}
		_getTargetCoords(event) {
				var rect = this._target.getBoundingClientRect();
				var left = Math.floor(rect.left);
				var top = Math.floor(rect.top);
				if (event.clientX < left || event.clientX >= left + this._target.clientWidth || event.clientY < top || event.clientY >= top + this._target.clientHeight) {
						return null;
				}
				return {
						x: event.clientX - left,
						y: event.clientY - top
				};
		}
		constructor(element){
				super(), this._lastX = 0, this._lastY = 0, this._buttons = [
						false,
						false,
						false
				], this._lastbuttons = [
						false,
						false,
						false
				], this._target = null, this._attached = false;
				this._upHandler = this._handleUp.bind(this);
				this._downHandler = this._handleDown.bind(this);
				this._moveHandler = this._handleMove.bind(this);
				this._wheelHandler = this._handleWheel.bind(this);
				this._contextMenuHandler = (event)=>{
						event.preventDefault();
				};
				this.attach(element);
		}
}
Mouse.EVENT_MOUSEMOVE = EVENT_MOUSEMOVE;
Mouse.EVENT_MOUSEDOWN = EVENT_MOUSEDOWN;
Mouse.EVENT_MOUSEUP = EVENT_MOUSEUP;
Mouse.EVENT_MOUSEWHEEL = EVENT_MOUSEWHEEL;

class Http {
		get(url, options, callback) {
				if (typeof options === 'function') {
						callback = options;
						options = {};
				}
				return this.request('GET', url, options, callback);
		}
		post(url, data, options, callback) {
				if (typeof options === 'function') {
						callback = options;
						options = {};
				}
				options.postdata = data;
				return this.request('POST', url, options, callback);
		}
		put(url, data, options, callback) {
				if (typeof options === 'function') {
						callback = options;
						options = {};
				}
				options.postdata = data;
				return this.request('PUT', url, options, callback);
		}
		del(url, options, callback) {
				if (typeof options === 'function') {
						callback = options;
						options = {};
				}
				return this.request('DELETE', url, options, callback);
		}
		request(method, url, options, callback) {
				var uri, query, postdata;
				var errored = false;
				if (typeof options === 'function') {
						callback = options;
						options = {};
				}
				if (options.retry) {
						options = Object.assign({
								retries: 0,
								maxRetries: 5
						}, options);
				}
				options.callback = callback;
				if (options.async == null) {
						options.async = true;
				}
				if (options.headers == null) {
						options.headers = {};
				}
				if (options.postdata != null) {
						if (options.postdata instanceof Document) {
								postdata = options.postdata;
						} else if (options.postdata instanceof FormData) {
								postdata = options.postdata;
						} else if (options.postdata instanceof Object) {
								var contentType = options.headers['Content-Type'];
								if (contentType === undefined) {
										options.headers['Content-Type'] = Http.ContentType.FORM_URLENCODED;
										contentType = options.headers['Content-Type'];
								}
								switch(contentType){
										case Http.ContentType.FORM_URLENCODED:
												{
														postdata = '';
														var bFirstItem = true;
														for(var key in options.postdata){
																if (options.postdata.hasOwnProperty(key)) {
																		if (bFirstItem) {
																				bFirstItem = false;
																		} else {
																				postdata += '&';
																		}
																		var encodedKey = encodeURIComponent(key);
																		var encodedValue = encodeURIComponent(options.postdata[key]);
																		postdata += encodedKey + "=" + encodedValue;
																}
														}
														break;
												}
										default:
										case Http.ContentType.JSON:
												if (contentType == null) {
														options.headers['Content-Type'] = Http.ContentType.JSON;
												}
												postdata = JSON.stringify(options.postdata);
												break;
								}
						} else {
								postdata = options.postdata;
						}
				}
				if (options.cache === false) {
						var timestamp = now();
						uri = new URI(url);
						if (!uri.query) {
								uri.query = "ts=" + timestamp;
						} else {
								uri.query = uri.query + "&ts=" + timestamp;
						}
						url = uri.toString();
				}
				if (options.query) {
						uri = new URI(url);
						query = extend(uri.getQuery(), options.query);
						uri.setQuery(query);
						url = uri.toString();
				}
				var xhr = new XMLHttpRequest();
				xhr.open(method, url, options.async);
				xhr.withCredentials = options.withCredentials !== undefined ? options.withCredentials : false;
				xhr.responseType = options.responseType || this._guessResponseType(url);
				for(var header in options.headers){
						if (options.headers.hasOwnProperty(header)) {
								xhr.setRequestHeader(header, options.headers[header]);
						}
				}
				xhr.onreadystatechange = ()=>{
						this._onReadyStateChange(method, url, options, xhr);
				};
				xhr.onerror = ()=>{
						this._onError(method, url, options, xhr);
						errored = true;
				};
				try {
						xhr.send(postdata);
				} catch (e) {
						if (!errored) {
								options.error(xhr.status, xhr, e);
						}
				}
				return xhr;
		}
		_guessResponseType(url) {
				var uri = new URI(url);
				var ext = path.getExtension(uri.path).toLowerCase();
				if (Http.binaryExtensions.indexOf(ext) >= 0) {
						return Http.ResponseType.ARRAY_BUFFER;
				} else if (ext === '.json') {
						return Http.ResponseType.JSON;
				} else if (ext === '.xml') {
						return Http.ResponseType.DOCUMENT;
				}
				return Http.ResponseType.TEXT;
		}
		_isBinaryContentType(contentType) {
				var binTypes = [
						Http.ContentType.BASIS,
						Http.ContentType.BIN,
						Http.ContentType.DDS,
						Http.ContentType.GLB,
						Http.ContentType.MP3,
						Http.ContentType.MP4,
						Http.ContentType.OGG,
						Http.ContentType.OPUS,
						Http.ContentType.WAV
				];
				if (binTypes.indexOf(contentType) >= 0) {
						return true;
				}
				return false;
		}
		_isBinaryResponseType(responseType) {
				return responseType === Http.ResponseType.ARRAY_BUFFER || responseType === Http.ResponseType.BLOB || responseType === Http.ResponseType.JSON;
		}
		_onReadyStateChange(method, url, options, xhr) {
				if (xhr.readyState === 4) {
						switch(xhr.status){
								case 0:
										{
												if (xhr.responseURL && xhr.responseURL.startsWith('file:///')) {
														this._onSuccess(method, url, options, xhr);
												} else {
														this._onError(method, url, options, xhr);
												}
												break;
										}
								case 200:
								case 201:
								case 206:
								case 304:
										{
												this._onSuccess(method, url, options, xhr);
												break;
										}
								default:
										{
												this._onError(method, url, options, xhr);
												break;
										}
						}
				}
		}
		_onSuccess(method, url, options, xhr) {
				var response;
				var contentType;
				var header = xhr.getResponseHeader('Content-Type');
				if (header) {
						var parts = header.split(';');
						contentType = parts[0].trim();
				}
				try {
						if (this._isBinaryContentType(contentType) || this._isBinaryResponseType(xhr.responseType)) {
								response = xhr.response;
						} else if (contentType === Http.ContentType.JSON || url.split('?')[0].endsWith('.json')) {
								response = JSON.parse(xhr.responseText);
						} else if (xhr.responseType === Http.ResponseType.DOCUMENT || contentType === Http.ContentType.XML) {
								response = xhr.responseXML;
						} else {
								response = xhr.responseText;
						}
						options.callback(null, response);
				} catch (err) {
						options.callback(err);
				}
		}
		_onError(method, url, options, xhr) {
				if (options.retrying) {
						return;
				}
				if (options.retry && options.retries < options.maxRetries) {
						options.retries++;
						options.retrying = true;
						var retryDelay = math.clamp(Math.pow(2, options.retries) * Http.retryDelay, 0, options.maxRetryDelay || 5000);
						console.log(method + ": " + url + " - Error " + xhr.status + ". Retrying in " + retryDelay + " ms");
						setTimeout(()=>{
								options.retrying = false;
								this.request(method, url, options, options.callback);
						}, retryDelay);
				} else {
						options.callback(xhr.status === 0 ? 'Network error' : xhr.status, null);
				}
		}
}
Http.ContentType = {
		AAC: 'audio/aac',
		BASIS: 'image/basis',
		BIN: 'application/octet-stream',
		DDS: 'image/dds',
		FORM_URLENCODED: 'application/x-www-form-urlencoded',
		GIF: 'image/gif',
		GLB: 'model/gltf-binary',
		JPEG: 'image/jpeg',
		JSON: 'application/json',
		MP3: 'audio/mpeg',
		MP4: 'audio/mp4',
		OGG: 'audio/ogg',
		OPUS: 'audio/ogg; codecs="opus"',
		PNG: 'image/png',
		TEXT: 'text/plain',
		WAV: 'audio/x-wav',
		XML: 'application/xml'
};
Http.ResponseType = {
		TEXT: 'text',
		ARRAY_BUFFER: 'arraybuffer',
		BLOB: 'blob',
		DOCUMENT: 'document',
		JSON: 'json'
};
Http.binaryExtensions = [
		'.model',
		'.wav',
		'.ogg',
		'.mp3',
		'.mp4',
		'.m4a',
		'.aac',
		'.dds',
		'.basis',
		'.glb',
		'.opus'
];
Http.retryDelay = 100;
var http = new Http();

function hasAudioContext() {
		return !!(typeof AudioContext !== 'undefined' || typeof webkitAudioContext !== 'undefined');
}

class Channel {
		getVolume() {
				return this.volume;
		}
		getLoop() {
				return this.loop;
		}
		setLoop(loop) {
				this.loop = loop;
				if (this.source) {
						this.source.loop = loop;
				}
		}
		getPitch() {
				return this.pitch;
		}
		onManagerVolumeChange() {
				this.setVolume(this.getVolume());
		}
		onManagerSuspend() {
				if (this.isPlaying() && !this.suspended) {
						this.suspended = true;
						this.pause();
				}
		}
		onManagerResume() {
				if (this.suspended) {
						this.suspended = false;
						this.unpause();
				}
		}
		play() {
				if (this.source) {
						throw new Error('Call stop() before calling play()');
				}
				this._createSource();
				if (!this.source) {
						return;
				}
				this.startTime = this.manager.context.currentTime;
				this.source.start(0, this.startOffset % this.source.buffer.duration);
				this.setVolume(this.volume);
				this.setLoop(this.loop);
				this.setPitch(this.pitch);
				this.manager.on('volumechange', this.onManagerVolumeChange, this);
				this.manager.on('suspend', this.onManagerSuspend, this);
				this.manager.on('resume', this.onManagerResume, this);
				if (this.manager.suspended) {
						this.onManagerSuspend();
				}
		}
		pause() {
				if (this.source) {
						this.paused = true;
						this.startOffset += this.manager.context.currentTime - this.startTime;
						this.source.stop(0);
						this.source = null;
				}
		}
		unpause() {
				if (this.source || !this.paused) {
						console.warn('Call pause() before unpausing.');
						return;
				}
				this._createSource();
				if (!this.source) {
						return;
				}
				this.startTime = this.manager.context.currentTime;
				this.source.start(0, this.startOffset % this.source.buffer.duration);
				this.setVolume(this.volume);
				this.setLoop(this.loop);
				this.setPitch(this.pitch);
				this.paused = false;
		}
		stop() {
				if (this.source) {
						this.source.stop(0);
						this.source = null;
				}
				this.manager.off('volumechange', this.onManagerVolumeChange, this);
				this.manager.off('suspend', this.onManagerSuspend, this);
				this.manager.off('resume', this.onManagerResume, this);
		}
		setVolume(volume) {
				volume = math.clamp(volume, 0, 1);
				this.volume = volume;
				if (this.gain) {
						this.gain.gain.value = volume * this.manager.volume;
				}
		}
		setPitch(pitch) {
				this.pitch = pitch;
				if (this.source) {
						this.source.playbackRate.value = pitch;
				}
		}
		isPlaying() {
				return !this.paused && this.source.playbackState === this.source.PLAYING_STATE;
		}
		getDuration() {
				return this.source ? this.source.buffer.duration : 0;
		}
		_createSource() {
				var context = this.manager.context;
				if (this.sound.buffer) {
						this.source = context.createBufferSource();
						this.source.buffer = this.sound.buffer;
						this.source.connect(this.gain);
						this.gain.connect(context.destination);
						if (!this.loop) {
								this.source.onended = this.pause.bind(this);
						}
				}
		}
		constructor(manager, sound, options = {}){
				var _options_volume;
				this.volume = (_options_volume = options.volume) != null ? _options_volume : 1;
				var _options_loop;
				this.loop = (_options_loop = options.loop) != null ? _options_loop : false;
				var _options_pitch;
				this.pitch = (_options_pitch = options.pitch) != null ? _options_pitch : 1;
				this.sound = sound;
				this.paused = false;
				this.suspended = false;
				this.manager = manager;
				this.source = null;
				if (hasAudioContext()) {
						this.startTime = 0;
						this.startOffset = 0;
						var context = manager.context;
						this.gain = context.createGain();
				} else if (sound.audio) {
						this.source = sound.audio.cloneNode(false);
						this.source.pause();
				}
		}
}
if (!hasAudioContext()) {
		Object.assign(Channel.prototype, {
				play: function play() {
						if (this.source) {
								this.paused = false;
								this.setVolume(this.volume);
								this.setLoop(this.loop);
								this.setPitch(this.pitch);
								this.source.play();
						}
						this.manager.on('volumechange', this.onManagerVolumeChange, this);
						this.manager.on('suspend', this.onManagerSuspend, this);
						this.manager.on('resume', this.onManagerResume, this);
						if (this.manager.suspended) {
								this.onManagerSuspend();
						}
				},
				pause: function pause() {
						if (this.source) {
								this.paused = true;
								this.source.pause();
						}
				},
				unpause: function unpause() {
						if (this.source) {
								this.paused = false;
								this.source.play();
						}
				},
				stop: function stop() {
						if (this.source) {
								this.source.pause();
						}
						this.manager.off('volumechange', this.onManagerVolumeChange, this);
						this.manager.off('suspend', this.onManagerSuspend, this);
						this.manager.off('resume', this.onManagerResume, this);
				},
				setVolume: function setVolume(volume) {
						volume = math.clamp(volume, 0, 1);
						this.volume = volume;
						if (this.source) {
								this.source.volume = volume * this.manager.volume;
						}
				},
				setPitch: function setPitch(pitch) {
						this.pitch = pitch;
						if (this.source) {
								this.source.playbackRate = pitch;
						}
				},
				getDuration: function getDuration() {
						return this.source && !isNaN(this.source.duration) ? this.source.duration : 0;
				},
				isPlaying: function isPlaying() {
						return !this.source.paused;
				}
		});
}

var MAX_DISTANCE$1 = 10000;
class Channel3d extends Channel {
		getPosition() {
				return this.position;
		}
		setPosition(position) {
				this.position.copy(position);
				var panner = this.panner;
				if ('positionX' in panner) {
						panner.positionX.value = position.x;
						panner.positionY.value = position.y;
						panner.positionZ.value = position.z;
				} else if (panner.setPosition) {
						panner.setPosition(position.x, position.y, position.z);
				}
		}
		getVelocity() {
				return this.velocity;
		}
		setVelocity(velocity) {
				this.velocity.copy(velocity);
		}
		getMaxDistance() {
				return this.panner.maxDistance;
		}
		setMaxDistance(max) {
				this.panner.maxDistance = max;
		}
		getMinDistance() {
				return this.panner.refDistance;
		}
		setMinDistance(min) {
				this.panner.refDistance = min;
		}
		getRollOffFactor() {
				return this.panner.rolloffFactor;
		}
		setRollOffFactor(factor) {
				this.panner.rolloffFactor = factor;
		}
		getDistanceModel() {
				return this.panner.distanceModel;
		}
		setDistanceModel(distanceModel) {
				this.panner.distanceModel = distanceModel;
		}
		_createSource() {
				var context = this.manager.context;
				this.source = context.createBufferSource();
				this.source.buffer = this.sound.buffer;
				this.source.connect(this.panner);
				this.panner.connect(this.gain);
				this.gain.connect(context.destination);
				if (!this.loop) {
						this.source.onended = this.pause.bind(this);
				}
		}
		constructor(manager, sound, options){
				super(manager, sound, options);
				this.position = new Vec3();
				this.velocity = new Vec3();
				if (hasAudioContext()) {
						this.panner = manager.context.createPanner();
				} else {
						this.maxDistance = MAX_DISTANCE$1;
						this.minDistance = 1;
						this.rollOffFactor = 1;
						this.distanceModel = DISTANCE_INVERSE;
				}
		}
}
if (!hasAudioContext()) {
		var offset$1 = new Vec3();
		var fallOff$1 = function fallOff(posOne, posTwo, refDistance, maxDistance, rolloffFactor, distanceModel) {
				offset$1 = offset$1.sub2(posOne, posTwo);
				var distance = offset$1.length();
				if (distance < refDistance) {
						return 1;
				} else if (distance > maxDistance) {
						return 0;
				}
				var result = 0;
				if (distanceModel === DISTANCE_LINEAR) {
						result = 1 - rolloffFactor * (distance - refDistance) / (maxDistance - refDistance);
				} else if (distanceModel === DISTANCE_INVERSE) {
						result = refDistance / (refDistance + rolloffFactor * (distance - refDistance));
				} else if (distanceModel === DISTANCE_EXPONENTIAL) {
						result = Math.pow(distance / refDistance, -rolloffFactor);
				}
				return math.clamp(result, 0, 1);
		};
		Object.assign(Channel3d.prototype, {
				setPosition: function setPosition(position) {
						this.position.copy(position);
						if (this.source) {
								var listener = this.manager.listener;
								var lpos = listener.getPosition();
								var factor = fallOff$1(lpos, this.position, this.minDistance, this.maxDistance, this.rollOffFactor, this.distanceModel);
								var v = this.getVolume();
								this.source.volume = v * factor;
						}
				},
				getMaxDistance: function getMaxDistance() {
						return this.maxDistance;
				},
				setMaxDistance: function setMaxDistance(max) {
						this.maxDistance = max;
				},
				getMinDistance: function getMinDistance() {
						return this.minDistance;
				},
				setMinDistance: function setMinDistance(min) {
						this.minDistance = min;
				},
				getRollOffFactor: function getRollOffFactor() {
						return this.rollOffFactor;
				},
				setRollOffFactor: function setRollOffFactor(factor) {
						this.rollOffFactor = factor;
				},
				getDistanceModel: function getDistanceModel() {
						return this.distanceModel;
				},
				setDistanceModel: function setDistanceModel(distanceModel) {
						this.distanceModel = distanceModel;
				}
		});
}

class Listener {
		getPosition() {
				return this.position;
		}
		setPosition(position) {
				this.position.copy(position);
				var listener = this.listener;
				if (listener) {
						if ('positionX' in listener) {
								listener.positionX.value = position.x;
								listener.positionY.value = position.y;
								listener.positionZ.value = position.z;
						} else if (listener.setPosition) {
								listener.setPosition(position.x, position.y, position.z);
						}
				}
		}
		setOrientation(orientation) {
				this.orientation.copy(orientation);
				var listener = this.listener;
				if (listener) {
						var m = orientation.data;
						if ('forwardX' in listener) {
								listener.forwardX.value = -m[8];
								listener.forwardY.value = -m[9];
								listener.forwardZ.value = -m[10];
								listener.upX.value = m[4];
								listener.upY.value = m[5];
								listener.upZ.value = m[6];
						} else if (listener.setOrientation) {
								listener.setOrientation(-m[8], -m[9], -m[10], m[4], m[5], m[6]);
						}
				}
		}
		getOrientation() {
				return this.orientation;
		}
		get listener() {
				var context = this._manager.context;
				return context ? context.listener : null;
		}
		constructor(manager){
				this.position = new Vec3();
				this.orientation = new Mat4();
				this._manager = manager;
		}
}

var CONTEXT_STATE_RUNNING = 'running';
var USER_INPUT_EVENTS = [
		'click',
		'touchstart',
		'mousedown'
];
class SoundManager extends EventHandler {
		set volume(volume) {
				volume = math.clamp(volume, 0, 1);
				this._volume = volume;
				this.fire('volumechange', volume);
		}
		get volume() {
				return this._volume;
		}
		get suspended() {
				return this._userSuspended;
		}
		get context() {
				if (!this._context && this.AudioContext) {
						this._context = new this.AudioContext();
						if (this._context.state !== CONTEXT_STATE_RUNNING) {
								this._registerUnlockListeners();
						}
				}
				return this._context;
		}
		suspend() {
				if (!this._userSuspended) {
						this._userSuspended = true;
						if (this._context && this._context.state === CONTEXT_STATE_RUNNING) {
								this._suspend();
						}
				}
		}
		resume() {
				if (this._userSuspended) {
						this._userSuspended = false;
						if (this._context && this._context.state !== CONTEXT_STATE_RUNNING) {
								this._resume();
						}
				}
		}
		destroy() {
				this.fire('destroy');
				if (this._context) {
						var _this__context;
						this._removeUnlockListeners();
						(_this__context = this._context) == null ? void 0 : _this__context.close();
						this._context = null;
				}
		}
		playSound(sound, options) {
				if (options === void 0) options = {};
				var channel = null;
				if (Channel) {
						channel = new Channel(this, sound, options);
						channel.play();
				}
				return channel;
		}
		playSound3d(sound, position, options) {
				if (options === void 0) options = {};
				var channel = null;
				if (Channel3d) {
						channel = new Channel3d(this, sound, options);
						channel.setPosition(position);
						if (options.volume) {
								channel.setVolume(options.volume);
						}
						if (options.loop) {
								channel.setLoop(options.loop);
						}
						if (options.maxDistance) {
								channel.setMaxDistance(options.maxDistance);
						}
						if (options.minDistance) {
								channel.setMinDistance(options.minDistance);
						}
						if (options.rollOffFactor) {
								channel.setRollOffFactor(options.rollOffFactor);
						}
						if (options.distanceModel) {
								channel.setDistanceModel(options.distanceModel);
						}
						channel.play();
				}
				return channel;
		}
		_resume() {
				this._context.resume().then(()=>{
						var source = this._context.createBufferSource();
						source.buffer = this._context.createBuffer(1, 1, this._context.sampleRate);
						source.connect(this._context.destination);
						source.start(0);
						source.onended = (event)=>{
								source.disconnect(0);
								this.fire('resume');
						};
				}, (e)=>{}).catch((e)=>{});
		}
		_suspend() {
				this._context.suspend().then(()=>{
						this.fire('suspend');
				}, (e)=>{}).catch((e)=>{});
		}
		_unlockHandler() {
				this._removeUnlockListeners();
				if (!this._userSuspended && this._context.state !== CONTEXT_STATE_RUNNING) {
						this._resume();
				}
		}
		_registerUnlockListeners() {
				USER_INPUT_EVENTS.forEach((eventName)=>{
						window.addEventListener(eventName, this._unlockHandlerFunc, false);
				});
		}
		_removeUnlockListeners() {
				USER_INPUT_EVENTS.forEach((eventName)=>{
						window.removeEventListener(eventName, this._unlockHandlerFunc, false);
				});
		}
		constructor(){
				super();
				this._context = null;
				this.AudioContext = typeof AudioContext !== 'undefined' && AudioContext || typeof webkitAudioContext !== 'undefined' && webkitAudioContext;
				if (!this.AudioContext) ;
				this._unlockHandlerFunc = this._unlockHandler.bind(this);
				this._userSuspended = false;
				this.listener = new Listener(this);
				this._volume = 1;
		}
}

class Sound {
		get duration() {
				var duration = 0;
				if (this.buffer) {
						duration = this.buffer.duration;
				} else if (this.audio) {
						duration = this.audio.duration;
				}
				return duration || 0;
		}
		constructor(resource){
				if (resource instanceof Audio) {
						this.audio = resource;
				} else {
						this.buffer = resource;
				}
		}
}

var STATE_PLAYING = 0;
var STATE_PAUSED = 1;
var STATE_STOPPED = 2;
function capTime(time, duration) {
		return time % duration || 0;
}
class SoundInstance extends EventHandler {
		set currentTime(value) {
				if (value < 0) return;
				if (this._state === STATE_PLAYING) {
						var suspend = this._suspendInstanceEvents;
						this._suspendInstanceEvents = true;
						this.stop();
						this._startOffset = value;
						this.play();
						this._suspendInstanceEvents = suspend;
				} else {
						this._startOffset = value;
						this._currentTime = value;
				}
		}
		get currentTime() {
				if (this._startOffset !== null) {
						return this._startOffset;
				}
				if (this._state === STATE_PAUSED) {
						return this._currentTime;
				}
				if (this._state === STATE_STOPPED || !this.source) {
						return 0;
				}
				this._updateCurrentTime();
				return this._currentTime;
		}
		set duration(value) {
				this._duration = Math.max(0, Number(value) || 0);
				var isPlaying = this._state === STATE_PLAYING;
				this.stop();
				if (isPlaying) {
						this.play();
				}
		}
		get duration() {
				if (!this._sound) {
						return 0;
				}
				if (this._duration) {
						return capTime(this._duration, this._sound.duration);
				}
				return this._sound.duration;
		}
		get isPaused() {
				return this._state === STATE_PAUSED;
		}
		get isPlaying() {
				return this._state === STATE_PLAYING;
		}
		get isStopped() {
				return this._state === STATE_STOPPED;
		}
		get isSuspended() {
				return this._suspended;
		}
		set loop(value) {
				this._loop = !!value;
				if (this.source) {
						this.source.loop = this._loop;
				}
		}
		get loop() {
				return this._loop;
		}
		set pitch(pitch) {
				this._currentOffset = this.currentTime;
				this._startedAt = this._manager.context.currentTime;
				this._pitch = Math.max(Number(pitch) || 0, 0.01);
				if (this.source) {
						this.source.playbackRate.value = this._pitch;
				}
		}
		get pitch() {
				return this._pitch;
		}
		set sound(value) {
				this._sound = value;
				if (this._state !== STATE_STOPPED) {
						this.stop();
				} else {
						this._createSource();
				}
		}
		get sound() {
				return this._sound;
		}
		set startTime(value) {
				this._startTime = Math.max(0, Number(value) || 0);
				var isPlaying = this._state === STATE_PLAYING;
				this.stop();
				if (isPlaying) {
						this.play();
				}
		}
		get startTime() {
				return this._startTime;
		}
		set volume(volume) {
				volume = math.clamp(volume, 0, 1);
				this._volume = volume;
				if (this.gain) {
						this.gain.gain.value = volume * this._manager.volume;
				}
		}
		get volume() {
				return this._volume;
		}
		_onPlay() {
				this.fire('play');
				if (this._onPlayCallback) {
						this._onPlayCallback(this);
				}
		}
		_onPause() {
				this.fire('pause');
				if (this._onPauseCallback) {
						this._onPauseCallback(this);
				}
		}
		_onResume() {
				this.fire('resume');
				if (this._onResumeCallback) {
						this._onResumeCallback(this);
				}
		}
		_onStop() {
				this.fire('stop');
				if (this._onStopCallback) {
						this._onStopCallback(this);
				}
		}
		_onEnded() {
				if (this._suspendEndEvent > 0) {
						this._suspendEndEvent--;
						return;
				}
				this.fire('end');
				if (this._onEndCallback) {
						this._onEndCallback(this);
				}
				this.stop();
		}
		_onManagerVolumeChange() {
				this.volume = this._volume;
		}
		_onManagerSuspend() {
				if (this._state === STATE_PLAYING && !this._suspended) {
						this._suspended = true;
						this.pause();
				}
		}
		_onManagerResume() {
				if (this._suspended) {
						this._suspended = false;
						this.resume();
				}
		}
		_initializeNodes() {
				this.gain = this._manager.context.createGain();
				this._inputNode = this.gain;
				this._connectorNode = this.gain;
				this._connectorNode.connect(this._manager.context.destination);
		}
		play() {
				if (this._state !== STATE_STOPPED) {
						this.stop();
				}
				this._state = STATE_PLAYING;
				this._playWhenLoaded = false;
				if (this._waitingContextSuspension) {
						return false;
				}
				if (this._manager.suspended) {
						this._manager.once('resume', this._playAudioImmediate, this);
						this._waitingContextSuspension = true;
						return false;
				}
				this._playAudioImmediate();
				return true;
		}
		_playAudioImmediate() {
				this._waitingContextSuspension = false;
				if (this._state !== STATE_PLAYING) {
						return;
				}
				if (!this.source) {
						this._createSource();
				}
				var offset = capTime(this._startOffset, this.duration);
				offset = capTime(this._startTime + offset, this._sound.duration);
				this._startOffset = null;
				if (this._duration) {
						this.source.start(0, offset, this._duration);
				} else {
						this.source.start(0, offset);
				}
				this._startedAt = this._manager.context.currentTime;
				this._currentTime = 0;
				this._currentOffset = offset;
				this.volume = this._volume;
				this.loop = this._loop;
				this.pitch = this._pitch;
				this._manager.on('volumechange', this._onManagerVolumeChange, this);
				this._manager.on('suspend', this._onManagerSuspend, this);
				this._manager.on('resume', this._onManagerResume, this);
				this._manager.on('destroy', this._onManagerDestroy, this);
				if (!this._suspendInstanceEvents) {
						this._onPlay();
				}
		}
		pause() {
				this._playWhenLoaded = false;
				if (this._state !== STATE_PLAYING) {
						return false;
				}
				this._state = STATE_PAUSED;
				if (this._waitingContextSuspension) {
						return true;
				}
				this._updateCurrentTime();
				this._suspendEndEvent++;
				this.source.stop(0);
				this.source = null;
				this._startOffset = null;
				if (!this._suspendInstanceEvents) {
						this._onPause();
				}
				return true;
		}
		resume() {
				if (this._state !== STATE_PAUSED) {
						return false;
				}
				var offset = this.currentTime;
				this._state = STATE_PLAYING;
				if (this._waitingContextSuspension) {
						return true;
				}
				if (!this.source) {
						this._createSource();
				}
				if (this._startOffset !== null) {
						offset = capTime(this._startOffset, this.duration);
						offset = capTime(this._startTime + offset, this._sound.duration);
						this._startOffset = null;
				}
				if (this._duration) {
						this.source.start(0, offset, this._duration);
				} else {
						this.source.start(0, offset);
				}
				this._startedAt = this._manager.context.currentTime;
				this._currentOffset = offset;
				this.volume = this._volume;
				this.loop = this._loop;
				this.pitch = this._pitch;
				this._playWhenLoaded = false;
				if (!this._suspendInstanceEvents) {
						this._onResume();
				}
				return true;
		}
		stop() {
				this._playWhenLoaded = false;
				if (this._state === STATE_STOPPED) {
						return false;
				}
				var wasPlaying = this._state === STATE_PLAYING;
				this._state = STATE_STOPPED;
				if (this._waitingContextSuspension) {
						return true;
				}
				this._manager.off('volumechange', this._onManagerVolumeChange, this);
				this._manager.off('suspend', this._onManagerSuspend, this);
				this._manager.off('resume', this._onManagerResume, this);
				this._manager.off('destroy', this._onManagerDestroy, this);
				this._startedAt = 0;
				this._currentTime = 0;
				this._currentOffset = 0;
				this._startOffset = null;
				this._suspendEndEvent++;
				if (wasPlaying && this.source) {
						this.source.stop(0);
				}
				this.source = null;
				if (!this._suspendInstanceEvents) {
						this._onStop();
				}
				return true;
		}
		setExternalNodes(firstNode, lastNode) {
				if (!firstNode) {
						console.error('The firstNode must be a valid Audio Node');
						return;
				}
				if (!lastNode) {
						lastNode = firstNode;
				}
				var speakers = this._manager.context.destination;
				if (this._firstNode !== firstNode) {
						if (this._firstNode) {
								this._connectorNode.disconnect(this._firstNode);
						} else {
								this._connectorNode.disconnect(speakers);
						}
						this._firstNode = firstNode;
						this._connectorNode.connect(firstNode);
				}
				if (this._lastNode !== lastNode) {
						if (this._lastNode) {
								this._lastNode.disconnect(speakers);
						}
						this._lastNode = lastNode;
						this._lastNode.connect(speakers);
				}
		}
		clearExternalNodes() {
				var speakers = this._manager.context.destination;
				if (this._firstNode) {
						this._connectorNode.disconnect(this._firstNode);
						this._firstNode = null;
				}
				if (this._lastNode) {
						this._lastNode.disconnect(speakers);
						this._lastNode = null;
				}
				this._connectorNode.connect(speakers);
		}
		getExternalNodes() {
				return [
						this._firstNode,
						this._lastNode
				];
		}
		_createSource() {
				if (!this._sound) {
						return null;
				}
				var context = this._manager.context;
				if (this._sound.buffer) {
						this.source = context.createBufferSource();
						this.source.buffer = this._sound.buffer;
						this.source.connect(this._inputNode);
						this.source.onended = this._endedHandler;
						this.source.loopStart = capTime(this._startTime, this.source.buffer.duration);
						if (this._duration) {
								this.source.loopEnd = Math.max(this.source.loopStart, capTime(this._startTime + this._duration, this.source.buffer.duration));
						}
				}
				return this.source;
		}
		_updateCurrentTime() {
				this._currentTime = capTime((this._manager.context.currentTime - this._startedAt) * this._pitch + this._currentOffset, this.duration);
		}
		_onManagerDestroy() {
				if (this.source && this._state === STATE_PLAYING) {
						this.source.stop(0);
						this.source = null;
				}
		}
		constructor(manager, sound, options){
				super(), this.source = null;
				this._manager = manager;
				this._volume = options.volume !== undefined ? math.clamp(Number(options.volume) || 0, 0, 1) : 1;
				this._pitch = options.pitch !== undefined ? Math.max(0.01, Number(options.pitch) || 0) : 1;
				this._loop = !!(options.loop !== undefined ? options.loop : false);
				this._sound = sound;
				this._state = STATE_STOPPED;
				this._suspended = false;
				this._suspendEndEvent = 0;
				this._suspendInstanceEvents = false;
				this._playWhenLoaded = true;
				this._startTime = Math.max(0, Number(options.startTime) || 0);
				this._duration = Math.max(0, Number(options.duration) || 0);
				this._startOffset = null;
				this._onPlayCallback = options.onPlay;
				this._onPauseCallback = options.onPause;
				this._onResumeCallback = options.onResume;
				this._onStopCallback = options.onStop;
				this._onEndCallback = options.onEnd;
				if (hasAudioContext()) {
						this._startedAt = 0;
						this._currentTime = 0;
						this._currentOffset = 0;
						this._inputNode = null;
						this._connectorNode = null;
						this._firstNode = null;
						this._lastNode = null;
						this._waitingContextSuspension = false;
						this._initializeNodes();
						this._endedHandler = this._onEnded.bind(this);
				} else {
						this._isReady = false;
						this._loadedMetadataHandler = this._onLoadedMetadata.bind(this);
						this._timeUpdateHandler = this._onTimeUpdate.bind(this);
						this._endedHandler = this._onEnded.bind(this);
						this._createSource();
				}
		}
}
SoundInstance.EVENT_PLAY = 'play';
SoundInstance.EVENT_PAUSE = 'pause';
SoundInstance.EVENT_RESUME = 'resume';
SoundInstance.EVENT_STOP = 'stop';
SoundInstance.EVENT_END = 'end';
if (!hasAudioContext()) {
		Object.assign(SoundInstance.prototype, {
				play: function play() {
						if (this._state !== STATE_STOPPED) {
								this.stop();
						}
						if (!this.source) {
								if (!this._createSource()) {
										return false;
								}
						}
						this.volume = this._volume;
						this.pitch = this._pitch;
						this.loop = this._loop;
						this.source.play();
						this._state = STATE_PLAYING;
						this._playWhenLoaded = false;
						this._manager.on('volumechange', this._onManagerVolumeChange, this);
						this._manager.on('suspend', this._onManagerSuspend, this);
						this._manager.on('resume', this._onManagerResume, this);
						this._manager.on('destroy', this._onManagerDestroy, this);
						if (this._manager.suspended) {
								this._onManagerSuspend();
						}
						if (!this._suspendInstanceEvents) {
								this._onPlay();
						}
						return true;
				},
				pause: function pause() {
						if (!this.source || this._state !== STATE_PLAYING) {
								return false;
						}
						this._suspendEndEvent++;
						this.source.pause();
						this._playWhenLoaded = false;
						this._state = STATE_PAUSED;
						this._startOffset = null;
						if (!this._suspendInstanceEvents) {
								this._onPause();
						}
						return true;
				},
				resume: function resume() {
						if (!this.source || this._state !== STATE_PAUSED) {
								return false;
						}
						this._state = STATE_PLAYING;
						this._playWhenLoaded = false;
						if (this.source.paused) {
								this.source.play();
								if (!this._suspendInstanceEvents) {
										this._onResume();
								}
						}
						return true;
				},
				stop: function stop() {
						if (!this.source || this._state === STATE_STOPPED) {
								return false;
						}
						this._manager.off('volumechange', this._onManagerVolumeChange, this);
						this._manager.off('suspend', this._onManagerSuspend, this);
						this._manager.off('resume', this._onManagerResume, this);
						this._manager.off('destroy', this._onManagerDestroy, this);
						this._suspendEndEvent++;
						this.source.pause();
						this._playWhenLoaded = false;
						this._state = STATE_STOPPED;
						this._startOffset = null;
						if (!this._suspendInstanceEvents) {
								this._onStop();
						}
						return true;
				},
				setExternalNodes: function setExternalNodes() {},
				clearExternalNodes: function clearExternalNodes() {},
				getExternalNodes: function getExternalNodes() {
						return [
								null,
								null
						];
				},
				_onLoadedMetadata: function _onLoadedMetadata() {
						this.source.removeEventListener('loadedmetadata', this._loadedMetadataHandler);
						this._isReady = true;
						var offset = capTime(this._startOffset, this.duration);
						offset = capTime(this._startTime + offset, this._sound.duration);
						this._startOffset = null;
						this.source.currentTime = offset;
				},
				_createSource: function _createSource() {
						if (this._sound && this._sound.audio) {
								this._isReady = false;
								this.source = this._sound.audio.cloneNode(true);
								this.source.addEventListener('loadedmetadata', this._loadedMetadataHandler);
								this.source.addEventListener('timeupdate', this._timeUpdateHandler);
								this.source.onended = this._endedHandler;
						}
						return this.source;
				},
				_onTimeUpdate: function _onTimeUpdate() {
						if (!this._duration) {
								return;
						}
						if (this.source.currentTime > capTime(this._startTime + this._duration, this.source.duration)) {
								if (this.loop) {
										this.source.currentTime = capTime(this._startTime, this.source.duration);
								} else {
										this.source.removeEventListener('timeupdate', this._timeUpdateHandler);
										this.source.pause();
										this._onEnded();
								}
						}
				},
				_onManagerDestroy: function _onManagerDestroy() {
						if (this.source) {
								this.source.pause();
						}
				}
		});
		Object.defineProperty(SoundInstance.prototype, 'volume', {
				get: function get() {
						return this._volume;
				},
				set: function set(volume) {
						volume = math.clamp(volume, 0, 1);
						this._volume = volume;
						if (this.source) {
								this.source.volume = volume * this._manager.volume;
						}
				}
		});
		Object.defineProperty(SoundInstance.prototype, 'pitch', {
				get: function get() {
						return this._pitch;
				},
				set: function set(pitch) {
						this._pitch = Math.max(Number(pitch) || 0, 0.01);
						if (this.source) {
								this.source.playbackRate = this._pitch;
						}
				}
		});
		Object.defineProperty(SoundInstance.prototype, 'sound', {
				get: function get() {
						return this._sound;
				},
				set: function set(value) {
						this.stop();
						this._sound = value;
				}
		});
		Object.defineProperty(SoundInstance.prototype, 'currentTime', {
				get: function get() {
						if (this._startOffset !== null) {
								return this._startOffset;
						}
						if (this._state === STATE_STOPPED || !this.source) {
								return 0;
						}
						return this.source.currentTime - this._startTime;
				},
				set: function set(value) {
						if (value < 0) return;
						this._startOffset = value;
						if (this.source && this._isReady) {
								this.source.currentTime = capTime(this._startTime + capTime(value, this.duration), this._sound.duration);
								this._startOffset = null;
						}
				}
		});
}

var MAX_DISTANCE = 10000;
class SoundInstance3d extends SoundInstance {
		_initializeNodes() {
				this.gain = this._manager.context.createGain();
				this.panner = this._manager.context.createPanner();
				this.panner.connect(this.gain);
				this._inputNode = this.panner;
				this._connectorNode = this.gain;
				this._connectorNode.connect(this._manager.context.destination);
		}
		set position(value) {
				this._position.copy(value);
				var panner = this.panner;
				if ('positionX' in panner) {
						panner.positionX.value = value.x;
						panner.positionY.value = value.y;
						panner.positionZ.value = value.z;
				} else if (panner.setPosition) {
						panner.setPosition(value.x, value.y, value.z);
				}
		}
		get position() {
				return this._position;
		}
		set velocity(velocity) {
				this._velocity.copy(velocity);
		}
		get velocity() {
				return this._velocity;
		}
		set maxDistance(value) {
				this.panner.maxDistance = value;
		}
		get maxDistance() {
				return this.panner.maxDistance;
		}
		set refDistance(value) {
				this.panner.refDistance = value;
		}
		get refDistance() {
				return this.panner.refDistance;
		}
		set rollOffFactor(value) {
				this.panner.rolloffFactor = value;
		}
		get rollOffFactor() {
				return this.panner.rolloffFactor;
		}
		set distanceModel(value) {
				this.panner.distanceModel = value;
		}
		get distanceModel() {
				return this.panner.distanceModel;
		}
		constructor(manager, sound, options = {}){
				super(manager, sound, options), this._position = new Vec3(), this._velocity = new Vec3();
				if (options.position) {
						this.position = options.position;
				}
				this.maxDistance = options.maxDistance !== undefined ? Number(options.maxDistance) : MAX_DISTANCE;
				this.refDistance = options.refDistance !== undefined ? Number(options.refDistance) : 1;
				this.rollOffFactor = options.rollOffFactor !== undefined ? Number(options.rollOffFactor) : 1;
				this.distanceModel = options.distanceModel !== undefined ? options.distanceModel : DISTANCE_LINEAR;
		}
}
if (!hasAudioContext()) {
		var offset = new Vec3();
		var fallOff = function fallOff(posOne, posTwo, refDistance, maxDistance, rollOffFactor, distanceModel) {
				offset = offset.sub2(posOne, posTwo);
				var distance = offset.length();
				if (distance < refDistance) {
						return 1;
				} else if (distance > maxDistance) {
						return 0;
				}
				var result = 0;
				if (distanceModel === DISTANCE_LINEAR) {
						result = 1 - rollOffFactor * (distance - refDistance) / (maxDistance - refDistance);
				} else if (distanceModel === DISTANCE_INVERSE) {
						result = refDistance / (refDistance + rollOffFactor * (distance - refDistance));
				} else if (distanceModel === DISTANCE_EXPONENTIAL) {
						result = Math.pow(distance / refDistance, -rollOffFactor);
				}
				return math.clamp(result, 0, 1);
		};
		Object.defineProperty(SoundInstance3d.prototype, 'position', {
				get: function get() {
						return this._position;
				},
				set: function set(position) {
						this._position.copy(position);
						if (this.source) {
								var listener = this._manager.listener;
								var lpos = listener.getPosition();
								var factor = fallOff(lpos, this._position, this.refDistance, this.maxDistance, this.rollOffFactor, this.distanceModel);
								var v = this.volume;
								this.source.volume = v * factor * this._manager.volume;
						}
				}
		});
		Object.defineProperty(SoundInstance3d.prototype, 'maxDistance', {
				get: function get() {
						return this._maxDistance;
				},
				set: function set(value) {
						this._maxDistance = value;
				}
		});
		Object.defineProperty(SoundInstance3d.prototype, 'refDistance', {
				get: function get() {
						return this._refDistance;
				},
				set: function set(value) {
						this._refDistance = value;
				}
		});
		Object.defineProperty(SoundInstance3d.prototype, 'rollOffFactor', {
				get: function get() {
						return this._rollOffFactor;
				},
				set: function set(value) {
						this._rollOffFactor = value;
				}
		});
		Object.defineProperty(SoundInstance3d.prototype, 'distanceModel', {
				get: function get() {
						return this._distanceModel;
				},
				set: function set(value) {
						this._distanceModel = value;
				}
		});
}

var BLEND_SUBTRACTIVE = 0;
var BLEND_ADDITIVE = 1;
var BLEND_NORMAL = 2;
var BLEND_NONE = 3;
var BLEND_PREMULTIPLIED = 4;
var BLEND_MULTIPLICATIVE = 5;
var BLEND_ADDITIVEALPHA = 6;
var BLEND_MULTIPLICATIVE2X = 7;
var BLEND_SCREEN = 8;
var BLEND_MIN = 9;
var BLEND_MAX = 10;
var blendNames = {
		[BLEND_SUBTRACTIVE]: 'SUBTRACTIVE',
		[BLEND_ADDITIVE]: 'ADDITIVE',
		[BLEND_NORMAL]: 'NORMAL',
		[BLEND_NONE]: 'NONE',
		[BLEND_PREMULTIPLIED]: 'PREMULTIPLIED',
		[BLEND_MULTIPLICATIVE]: 'MULTIPLICATIVE',
		[BLEND_ADDITIVEALPHA]: 'ADDITIVEALPHA',
		[BLEND_MULTIPLICATIVE2X]: 'MULTIPLICATIVE2X',
		[BLEND_SCREEN]: 'SCREEN',
		[BLEND_MIN]: 'MIN',
		[BLEND_MAX]: 'MAX'
};
var FOG_NONE = 'none';
var FOG_LINEAR = 'linear';
var FRESNEL_NONE = 0;
var FRESNEL_SCHLICK = 2;
var fresnelNames = {
		[FRESNEL_NONE]: 'NONE',
		[FRESNEL_SCHLICK]: 'SCHLICK'
};
var LAYER_HUD = 0;
var LAYER_WORLD = 15;
var LAYERID_WORLD = 0;
var LAYERID_DEPTH = 1;
var LAYERID_SKYBOX = 2;
var LAYERID_IMMEDIATE = 3;
var LAYERID_UI = 4;
var LIGHTTYPE_DIRECTIONAL = 0;
var LIGHTTYPE_OMNI = 1;
var LIGHTTYPE_SPOT = 2;
var lightTypeNames = {
		[LIGHTTYPE_DIRECTIONAL]: 'DIRECTIONAL',
		[LIGHTTYPE_OMNI]: 'OMNI',
		[LIGHTTYPE_SPOT]: 'SPOT'
};
var LIGHTSHAPE_PUNCTUAL = 0;
var LIGHTSHAPE_RECT = 1;
var LIGHTSHAPE_DISK = 2;
var LIGHTSHAPE_SPHERE = 3;
var lightShapeNames = {
		[LIGHTSHAPE_PUNCTUAL]: 'PUNCTUAL',
		[LIGHTSHAPE_RECT]: 'RECT',
		[LIGHTSHAPE_DISK]: 'DISK',
		[LIGHTSHAPE_SPHERE]: 'SPHERE'
};
var LIGHTFALLOFF_LINEAR = 0;
var LIGHTFALLOFF_INVERSESQUARED = 1;
var lightFalloffNames = {
		[LIGHTFALLOFF_LINEAR]: 'LINEAR',
		[LIGHTFALLOFF_INVERSESQUARED]: 'INVERSESQUARED'
};
var SHADOW_PCF3_32F = 0;
var SHADOW_VSM_16F = 2;
var SHADOW_VSM_32F = 3;
var SHADOW_PCF5_32F = 4;
var SHADOW_PCF1_32F = 5;
var SHADOW_PCSS_32F = 6;
var SHADOW_PCF1_16F = 7;
var SHADOW_PCF3_16F = 8;
var SHADOW_PCF5_16F = 9;
var shadowTypeInfo = new Map([
		[
				SHADOW_PCF1_32F,
				{
						name: 'PCF1_32F',
						kind: 'PCF1',
						format: PIXELFORMAT_DEPTH,
						pcf: true
				}
		],
		[
				SHADOW_PCF3_32F,
				{
						name: 'PCF3_32F',
						kind: 'PCF3',
						format: PIXELFORMAT_DEPTH,
						pcf: true
				}
		],
		[
				SHADOW_PCF5_32F,
				{
						name: 'PCF5_32F',
						kind: 'PCF5',
						format: PIXELFORMAT_DEPTH,
						pcf: true
				}
		],
		[
				SHADOW_PCF1_16F,
				{
						name: 'PCF1_16F',
						kind: 'PCF1',
						format: PIXELFORMAT_DEPTH16,
						pcf: true
				}
		],
		[
				SHADOW_PCF3_16F,
				{
						name: 'PCF3_16F',
						kind: 'PCF3',
						format: PIXELFORMAT_DEPTH16,
						pcf: true
				}
		],
		[
				SHADOW_PCF5_16F,
				{
						name: 'PCF5_16F',
						kind: 'PCF5',
						format: PIXELFORMAT_DEPTH16,
						pcf: true
				}
		],
		[
				SHADOW_VSM_16F,
				{
						name: 'VSM_16F',
						kind: 'VSM',
						format: PIXELFORMAT_RGBA16F,
						vsm: true
				}
		],
		[
				SHADOW_VSM_32F,
				{
						name: 'VSM_32F',
						kind: 'VSM',
						format: PIXELFORMAT_RGBA32F,
						vsm: true
				}
		],
		[
				SHADOW_PCSS_32F,
				{
						name: 'PCSS_32F',
						kind: 'PCSS',
						format: PIXELFORMAT_R32F,
						pcss: true
				}
		]
]);
var BLUR_GAUSSIAN = 1;
var PARTICLESORT_NONE = 0;
var PARTICLEMODE_GPU = 0;
var EMITTERSHAPE_BOX = 0;
var EMITTERSHAPE_SPHERE = 1;
var PARTICLEORIENTATION_SCREEN = 0;
var PARTICLEORIENTATION_WORLD = 1;
var PROJECTION_PERSPECTIVE = 0;
var PROJECTION_ORTHOGRAPHIC = 1;
var RENDERSTYLE_SOLID = 0;
var RENDERSTYLE_WIREFRAME = 1;
var RENDERSTYLE_POINTS = 2;
var CUBEPROJ_NONE = 0;
var CUBEPROJ_BOX = 1;
var cubemaProjectionNames = {
		[CUBEPROJ_NONE]: 'NONE',
		[CUBEPROJ_BOX]: 'BOX'
};
var DETAILMODE_MUL = 'mul';
var GAMMA_NONE = 0;
var GAMMA_SRGB = 1;
var gammaNames = {
		[GAMMA_NONE]: 'NONE',
		[GAMMA_SRGB]: 'SRGB'
};
var TONEMAP_LINEAR = 0;
var TONEMAP_FILMIC = 1;
var TONEMAP_HEJL = 2;
var TONEMAP_ACES = 3;
var TONEMAP_ACES2 = 4;
var TONEMAP_NEUTRAL = 5;
var TONEMAP_NONE = 6;
var tonemapNames = [
		'LINEAR',
		'FILMIC',
		'HEJL',
		'ACES',
		'ACES2',
		'NEUTRAL',
		'NONE'
];
var SPECOCC_NONE = 0;
var SPECOCC_AO = 1;
var SPECOCC_GLOSSDEPENDENT = 2;
var specularOcclusionNames = {
		[SPECOCC_NONE]: 'NONE',
		[SPECOCC_AO]: 'AO',
		[SPECOCC_GLOSSDEPENDENT]: 'GLOSSDEPENDENT'
};
var REFLECTIONSRC_NONE = 'none';
var REFLECTIONSRC_ENVATLAS = 'envAtlas';
var REFLECTIONSRC_ENVATLASHQ = 'envAtlasHQ';
var REFLECTIONSRC_CUBEMAP = 'cubeMap';
var REFLECTIONSRC_SPHEREMAP = 'sphereMap';
var reflectionSrcNames = {
		[REFLECTIONSRC_NONE]: 'NONE',
		[REFLECTIONSRC_ENVATLAS]: 'ENVATLAS',
		[REFLECTIONSRC_ENVATLASHQ]: 'ENVATLASHQ',
		[REFLECTIONSRC_CUBEMAP]: 'CUBEMAP',
		[REFLECTIONSRC_SPHEREMAP]: 'SPHEREMAP'
};
var AMBIENTSRC_AMBIENTSH = 'ambientSH';
var AMBIENTSRC_ENVALATLAS = 'envAtlas';
var AMBIENTSRC_CONSTANT = 'constant';
var ambientSrcNames = {
		[AMBIENTSRC_AMBIENTSH]: 'AMBIENTSH',
		[AMBIENTSRC_ENVALATLAS]: 'ENVALATLAS',
		[AMBIENTSRC_CONSTANT]: 'CONSTANT'
};
var SHADERDEF_NOSHADOW = 1;
var SHADERDEF_SKIN = 2;
var SHADERDEF_UV0 = 4;
var SHADERDEF_UV1 = 8;
var SHADERDEF_VCOLOR = 16;
var SHADERDEF_INSTANCING = 32;
var SHADERDEF_LM = 64;
var SHADERDEF_DIRLM = 128;
var SHADERDEF_SCREENSPACE = 256;
var SHADERDEF_TANGENTS = 512;
var SHADERDEF_MORPH_POSITION = 1024;
var SHADERDEF_MORPH_NORMAL = 2048;
var SHADERDEF_LMAMBIENT = 4096;
var SHADERDEF_MORPH_TEXTURE_BASED_INT = 8192;
var SHADERDEF_BATCH = 16384;
var SHADOWUPDATE_NONE = 0;
var SHADOWUPDATE_THISFRAME = 1;
var SHADOWUPDATE_REALTIME = 2;
var MASK_AFFECT_DYNAMIC = 1;
var MASK_AFFECT_LIGHTMAPPED = 2;
var MASK_BAKE = 4;
var SHADER_FORWARD = 0;
var SHADER_PREPASS = 1;
var SHADER_DEPTH = 2;
var SHADER_PICK = 3;
var SHADER_SHADOW = 4;
var SPRITE_RENDERMODE_SIMPLE = 0;
var SPRITE_RENDERMODE_SLICED = 1;
var SPRITE_RENDERMODE_TILED = 2;
var spriteRenderModeNames = {
		[SPRITE_RENDERMODE_SIMPLE]: 'SIMPLE',
		[SPRITE_RENDERMODE_SLICED]: 'SLICED',
		[SPRITE_RENDERMODE_TILED]: 'TILED'
};
var BAKE_COLORDIR = 1;
var VIEW_CENTER = 0;
var SORTMODE_NONE = 0;
var SORTMODE_MANUAL = 1;
var SORTMODE_MATERIALMESH = 2;
var SORTMODE_BACK2FRONT = 3;
var SORTMODE_FRONT2BACK = 4;
var SORTMODE_CUSTOM = 5;
var ASPECT_AUTO = 0;
var ASPECT_MANUAL = 1;
var ORIENTATION_HORIZONTAL = 0;
var ORIENTATION_VERTICAL = 1;
var SKYTYPE_INFINITE = 'infinite';
var SKYTYPE_BOX = 'box';
var SKYTYPE_DOME = 'dome';
var DITHER_NONE = 'none';
var DITHER_BAYER8 = 'bayer8';
var EVENT_PRERENDER = 'prerender';
var EVENT_POSTRENDER = 'postrender';
var EVENT_PRERENDER_LAYER = 'prerender:layer';
var EVENT_POSTRENDER_LAYER = 'postrender:layer';
var EVENT_PRECULL = 'precull';
var EVENT_POSTCULL = 'postcull';

class ShaderProcessorOptions {
		hasUniform(name) {
				for(var i = 0; i < this.uniformFormats.length; i++){
						var uniformFormat = this.uniformFormats[i];
						if (uniformFormat == null ? void 0 : uniformFormat.get(name)) {
								return true;
						}
				}
				return false;
		}
		hasTexture(name) {
				for(var i = 0; i < this.bindGroupFormats.length; i++){
						var groupFormat = this.bindGroupFormats[i];
						if (groupFormat == null ? void 0 : groupFormat.getTexture(name)) {
								return true;
						}
				}
				return false;
		}
		getVertexElement(semantic) {
				var _this_vertexFormat;
				return (_this_vertexFormat = this.vertexFormat) == null ? void 0 : _this_vertexFormat.elements.find((element)=>element.name === semantic);
		}
		generateKey(device) {
				var key = JSON.stringify(this.uniformFormats) + JSON.stringify(this.bindGroupFormats);
				if (device.isWebGPU) {
						var _this_vertexFormat;
						key += (_this_vertexFormat = this.vertexFormat) == null ? void 0 : _this_vertexFormat.shaderProcessingHashString;
				}
				return key;
		}
		constructor(viewUniformFormat, viewBindGroupFormat, vertexFormat){
				this.uniformFormats = [];
				this.bindGroupFormats = [];
				this.uniformFormats[BINDGROUP_VIEW] = viewUniformFormat;
				this.bindGroupFormats[BINDGROUP_VIEW] = viewBindGroupFormat;
				this.vertexFormat = vertexFormat;
		}
}

var alphaTestPS = "\nuniform float alpha_ref;\nvoid alphaTest(float a) {\n	if (a < alpha_ref) discard;\n}\n";

var ambientPS = '\n#ifdef LIT_AMBIENT_SOURCE == AMBIENTSH\n	uniform vec3 ambientSH[9];\n#endif\n#if LIT_AMBIENT_SOURCE == ENVALATLAS\n	#include "envAtlasPS"\n	#ifndef ENV_ATLAS\n	#define ENV_ATLAS\n	uniform sampler2D texture_envAtlas;\n	#endif\n#endif\nvoid addAmbient(vec3 worldNormal) {\n	#ifdef LIT_AMBIENT_SOURCE == AMBIENTSH\n		vec3 n = cubeMapRotate(worldNormal);\n		vec3 color =\n			ambientSH[0] +\n			ambientSH[1] * n.x +\n			ambientSH[2] * n.y +\n			ambientSH[3] * n.z +\n			ambientSH[4] * n.x * n.z +\n			ambientSH[5] * n.z * n.y +\n			ambientSH[6] * n.y * n.x +\n			ambientSH[7] * (3.0 * n.z * n.z - 1.0) +\n			ambientSH[8] * (n.x * n.x - n.y * n.y);\n		dDiffuseLight += processEnvironment(max(color, vec3(0.0)));\n	#endif\n	#if LIT_AMBIENT_SOURCE == ENVALATLAS\n		vec3 dir = normalize(cubeMapRotate(worldNormal) * vec3(-1.0, 1.0, 1.0));\n		vec2 uv = mapUv(toSphericalUv(dir), vec4(128.0, 256.0 + 128.0, 64.0, 32.0) / atlasSize);\n		vec4 raw = texture2D(texture_envAtlas, uv);\n		vec3 linear = {ambientDecode}(raw);\n		dDiffuseLight += processEnvironment(linear);\n	#endif\n	#if LIT_AMBIENT_SOURCE == CONSTANT\n		dDiffuseLight += light_globalAmbient;\n	#endif\n}\n';

var aoPS = "\n#ifdef MAPTEXTURE\n	#define AO_INTENSITY\n#endif\n#ifdef MAPVERTEX\n	#define AO_INTENSITY\n#endif\n#ifdef AO_INTENSITY\n	uniform float material_aoIntensity;\n#endif\nvoid getAO() {\n	dAo = 1.0;\n	#ifdef MAPTEXTURE\n		float aoBase = texture2DBias($SAMPLER, $UV, textureBias).$CH;\n		dAo *= addAoDetail(aoBase);\n	#endif\n	#ifdef MAPVERTEX\n		dAo *= saturate(vVertexColor.$VC);\n	#endif\n	#ifdef AO_INTENSITY\n		dAo = mix(1.0, dAo, material_aoIntensity);\n	#endif\n}\n";

var aoDetailMapPS = "\nfloat addAoDetail(float ao) {\n#ifdef MAPTEXTURE\n	float aoDetail = texture2DBias($SAMPLER, $UV, textureBias).$CH;\n	return detailMode_$DETAILMODE(vec3(ao), vec3(aoDetail)).r;\n#else\n	return ao;\n#endif\n}\n";

var aoDiffuseOccPS = "\nvoid occludeDiffuse(float ao) {\n	dDiffuseLight *= ao;\n}\n";

var aoSpecOccPS = "\n#if LIT_OCCLUDE_SPECULAR != NONE\n	#ifdef LIT_OCCLUDE_SPECULAR_FLOAT\n		uniform float material_occludeSpecularIntensity;\n	#endif\n#endif\nvoid occludeSpecular(float gloss, float ao, vec3 worldNormal, vec3 viewDir) {\n	#if LIT_OCCLUDE_SPECULAR == AO\n		#ifdef LIT_OCCLUDE_SPECULAR_FLOAT\n			float specOcc = mix(1.0, ao, material_occludeSpecularIntensity);\n		#else\n			float specOcc = ao;\n		#endif\n	#endif\n	#if LIT_OCCLUDE_SPECULAR == GLOSSDEPENDENT\n		float specPow = exp2(gloss * 11.0);\n		float specOcc = saturate(pow(dot(worldNormal, viewDir) + ao, 0.01*specPow) - 1.0 + ao);\n		#ifdef LIT_OCCLUDE_SPECULAR_FLOAT\n			specOcc = mix(1.0, specOcc, material_occludeSpecularIntensity);\n		#endif\n	#endif\n	#if LIT_OCCLUDE_SPECULAR != NONE\n		dSpecularLight *= specOcc;\n		dReflection *= specOcc;\n		#ifdef LIT_SHEEN\n			sSpecularLight *= specOcc;\n			sReflection *= specOcc;\n		#endif\n	#endif\n}\n";

var basePS = "\nuniform vec3 view_position;\nuniform vec3 light_globalAmbient;\nfloat square(float x) {\n	return x*x;\n}\nfloat saturate(float x) {\n	return clamp(x, 0.0, 1.0);\n}\nvec3 saturate(vec3 x) {\n	return clamp(x, vec3(0.0), vec3(1.0));\n}\n";

var baseNineSlicedPS = "\n#define NINESLICED\nvarying vec2 vMask;\nvarying vec2 vTiledUv;\nuniform mediump vec4 innerOffset;\nuniform mediump vec2 outerScale;\nuniform mediump vec4 atlasRect;\nvec2 nineSlicedUv;\n";

var baseNineSlicedTiledPS = "\n#define NINESLICED\n#define NINESLICETILED\nvarying vec2 vMask;\nvarying vec2 vTiledUv;\nuniform mediump vec4 innerOffset;\nuniform mediump vec2 outerScale;\nuniform mediump vec4 atlasRect;\nvec2 nineSlicedUv;\n";

var bayerPS = "\nfloat bayer2(vec2 p) {\n	return mod(2.0 * p.y + p.x + 1.0, 4.0);\n}\nfloat bayer4(vec2 p) {\n	vec2 p1 = mod(p, 2.0);\n	vec2 p2 = floor(0.5 * mod(p, 4.0));\n	return 4.0 * bayer2(p1) + bayer2(p2);\n}\nfloat bayer8(vec2 p) {\n	vec2 p1 = mod(p, 2.0);\n	vec2 p2 = floor(0.5 * mod(p, 4.0));\n	vec2 p4 = floor(0.25 * mod(p, 8.0));\n	return 4.0 * (4.0 * bayer2(p1) + bayer2(p2)) + bayer2(p4);\n}\n";

var blurVSMPS = "\nvarying vec2 vUv0;\nuniform sampler2D source;\nuniform vec2 pixelOffset;\n#ifdef GAUSS\nuniform float weight[SAMPLES];\n#endif\nvoid main(void) {\n	vec3 moments = vec3(0.0);\n	vec2 uv = vUv0 - pixelOffset * (float(SAMPLES) * 0.5);\n	for (int i=0; i<SAMPLES; i++) {\n		vec4 c = texture2D(source, uv + pixelOffset * float(i));\n		#ifdef GAUSS\n		moments += c.xyz * weight[i];\n		#else\n		moments += c.xyz;\n		#endif\n	}\n	#ifndef GAUSS\n	moments /= float(SAMPLES);\n	#endif\n	gl_FragColor = vec4(moments.x, moments.y, moments.z, 1.0);\n}\n";

var clearCoatPS = "\n#ifdef MAPFLOAT\nuniform float material_clearCoat;\n#endif\nvoid getClearCoat() {\n	ccSpecularity = 1.0;\n	#ifdef MAPFLOAT\n	ccSpecularity *= material_clearCoat;\n	#endif\n	#ifdef MAPTEXTURE\n	ccSpecularity *= texture2DBias($SAMPLER, $UV, textureBias).$CH;\n	#endif\n	#ifdef MAPVERTEX\n	ccSpecularity *= saturate(vVertexColor.$VC);\n	#endif\n}\n";

var clearCoatGlossPS = "\n#ifdef MAPFLOAT\nuniform float material_clearCoatGloss;\n#endif\nvoid getClearCoatGlossiness() {\n	ccGlossiness = 1.0;\n	#ifdef MAPFLOAT\n	ccGlossiness *= material_clearCoatGloss;\n	#endif\n	#ifdef MAPTEXTURE\n	ccGlossiness *= texture2DBias($SAMPLER, $UV, textureBias).$CH;\n	#endif\n	#ifdef MAPVERTEX\n	ccGlossiness *= saturate(vVertexColor.$VC);\n	#endif\n	#ifdef MAPINVERT\n	ccGlossiness = 1.0 - ccGlossiness;\n	#endif\n	ccGlossiness += 0.0000001;\n}\n";

var clearCoatNormalPS = "\n#ifdef MAPTEXTURE\nuniform float material_clearCoatBumpiness;\n#endif\nvoid getClearCoatNormal() {\n#ifdef MAPTEXTURE\n	vec3 normalMap = unpackNormal(texture2DBias($SAMPLER, $UV, textureBias));\n	normalMap = mix(vec3(0.0, 0.0, 1.0), normalMap, material_clearCoatBumpiness);\n	ccNormalW = normalize(dTBN * normalMap);\n#else\n	ccNormalW = dVertexNormalW;\n#endif\n}\n";

var clusteredLightUtilsPS = "\nvec2 getCubemapFaceCoordinates(const vec3 dir, out float faceIndex, out vec2 tileOffset)\n{\n	vec3 vAbs = abs(dir);\n	float ma;\n	vec2 uv;\n	if (vAbs.z >= vAbs.x && vAbs.z >= vAbs.y) {\n		faceIndex = dir.z < 0.0 ? 5.0 : 4.0;\n		ma = 0.5 / vAbs.z;\n		uv = vec2(dir.z < 0.0 ? -dir.x : dir.x, -dir.y);\n		tileOffset.x = 2.0;\n		tileOffset.y = dir.z < 0.0 ? 1.0 : 0.0;\n	} else if(vAbs.y >= vAbs.x) {\n		faceIndex = dir.y < 0.0 ? 3.0 : 2.0;\n		ma = 0.5 / vAbs.y;\n		uv = vec2(dir.x, dir.y < 0.0 ? -dir.z : dir.z);\n		tileOffset.x = 1.0;\n		tileOffset.y = dir.y < 0.0 ? 1.0 : 0.0;\n	} else {\n		faceIndex = dir.x < 0.0 ? 1.0 : 0.0;\n		ma = 0.5 / vAbs.x;\n		uv = vec2(dir.x < 0.0 ? dir.z : -dir.z, -dir.y);\n		tileOffset.x = 0.0;\n		tileOffset.y = dir.x < 0.0 ? 1.0 : 0.0;\n	}\n	return uv * ma + 0.5;\n}\nvec2 getCubemapAtlasCoordinates(const vec3 omniAtlasViewport, float shadowEdgePixels, float shadowTextureResolution, const vec3 dir) {\n	float faceIndex;\n	vec2 tileOffset;\n	vec2 uv = getCubemapFaceCoordinates(dir, faceIndex, tileOffset);\n	float atlasFaceSize = omniAtlasViewport.z;\n	float tileSize = shadowTextureResolution * atlasFaceSize;\n	float offset = shadowEdgePixels / tileSize;\n	uv = uv * vec2(1.0 - offset * 2.0) + vec2(offset * 1.0);\n	uv *= atlasFaceSize;\n	uv += tileOffset * atlasFaceSize;\n	uv += omniAtlasViewport.xy;\n	return uv;\n}\n";

var clusteredLightCookiesPS = "\nvec3 _getCookieClustered(TEXTURE_ACCEPT(tex), vec2 uv, float intensity, bool isRgb, vec4 cookieChannel) {\n	vec4 pixel = mix(vec4(1.0), texture2DLod(tex, uv, 0.0), intensity);\n	return isRgb == true ? pixel.rgb : vec3(dot(pixel, cookieChannel));\n}\nvec3 getCookie2DClustered(TEXTURE_ACCEPT(tex), mat4 transform, vec3 worldPosition, float intensity, bool isRgb, vec4 cookieChannel) {\n	vec4 projPos = transform * vec4(worldPosition, 1.0);\n	return _getCookieClustered(TEXTURE_PASS(tex), projPos.xy / projPos.w, intensity, isRgb, cookieChannel);\n}\nvec3 getCookieCubeClustered(TEXTURE_ACCEPT(tex), vec3 dir, float intensity, bool isRgb, vec4 cookieChannel, float shadowTextureResolution, float shadowEdgePixels, vec3 omniAtlasViewport) {\n	vec2 uv = getCubemapAtlasCoordinates(omniAtlasViewport, shadowEdgePixels, shadowTextureResolution, dir);\n	return _getCookieClustered(TEXTURE_PASS(tex), uv, intensity, isRgb, cookieChannel);\n}\n";

var clusteredLightShadowsPS = "\nvec3 _getShadowCoordPerspZbuffer(mat4 shadowMatrix, vec4 shadowParams, vec3 wPos) {\n	vec4 projPos = shadowMatrix * vec4(wPos, 1.0);\n	projPos.xyz /= projPos.w;\n	return projPos.xyz;\n}\nvec3 getShadowCoordPerspZbufferNormalOffset(mat4 shadowMatrix, vec4 shadowParams, vec3 normal) {\n	vec3 wPos = vPositionW + normal * shadowParams.y;\n	return _getShadowCoordPerspZbuffer(shadowMatrix, shadowParams, wPos);\n}\nvec3 normalOffsetPointShadow(vec4 shadowParams, vec3 lightPos, inout vec3 lightDir, vec3 lightDirNorm, vec3 normal) {\n	float distScale = length(lightDir);\n	vec3 wPos = vPositionW + normal * shadowParams.y * clamp(1.0 - dot(normal, -lightDirNorm), 0.0, 1.0) * distScale;\n	vec3 dir = wPos - lightPos;\n	return dir;\n}\n#if defined(CLUSTER_SHADOW_TYPE_PCF1)\nfloat getShadowOmniClusteredPCF1(SHADOWMAP_ACCEPT(shadowMap), vec4 shadowParams, vec3 omniAtlasViewport, float shadowEdgePixels, vec3 lightDir) {\n	float shadowTextureResolution = shadowParams.x;\n	vec2 uv = getCubemapAtlasCoordinates(omniAtlasViewport, shadowEdgePixels, shadowTextureResolution, lightDir);\n	float shadowZ = length(lightDir) * shadowParams.w + shadowParams.z;\n	return textureShadow(shadowMap, vec3(uv, shadowZ));\n}\n#endif\n#if defined(CLUSTER_SHADOW_TYPE_PCF3)\nfloat getShadowOmniClusteredPCF3(SHADOWMAP_ACCEPT(shadowMap), vec4 shadowParams, vec3 omniAtlasViewport, float shadowEdgePixels, vec3 lightDir) {\n	float shadowTextureResolution = shadowParams.x;\n	vec2 uv = getCubemapAtlasCoordinates(omniAtlasViewport, shadowEdgePixels, shadowTextureResolution, lightDir);\n	float shadowZ = length(lightDir) * shadowParams.w + shadowParams.z;\n	vec3 shadowCoord = vec3(uv, shadowZ);\n	return getShadowPCF3x3(SHADOWMAP_PASS(shadowMap), shadowCoord, shadowParams);\n}\n#endif\n#if defined(CLUSTER_SHADOW_TYPE_PCF5)\nfloat getShadowOmniClusteredPCF5(SHADOWMAP_ACCEPT(shadowMap), vec4 shadowParams, vec3 omniAtlasViewport, float shadowEdgePixels, vec3 lightDir) {\n	float shadowTextureResolution = shadowParams.x;\n	vec2 uv = getCubemapAtlasCoordinates(omniAtlasViewport, shadowEdgePixels, shadowTextureResolution, lightDir);\n	float shadowZ = length(lightDir) * shadowParams.w + shadowParams.z;\n	vec3 shadowCoord = vec3(uv, shadowZ);\n	return getShadowPCF5x5(SHADOWMAP_PASS(shadowMap), shadowCoord, shadowParams);\n}\n#endif\n#if defined(CLUSTER_SHADOW_TYPE_PCF1)\nfloat getShadowSpotClusteredPCF1(SHADOWMAP_ACCEPT(shadowMap), vec3 shadowCoord, vec4 shadowParams) {\n	return textureShadow(shadowMap, shadowCoord);\n}\n#endif\n#if defined(CLUSTER_SHADOW_TYPE_PCF3)\nfloat getShadowSpotClusteredPCF3(SHADOWMAP_ACCEPT(shadowMap), vec3 shadowCoord, vec4 shadowParams) {\n	return getShadowSpotPCF3x3(SHADOWMAP_PASS(shadowMap), shadowCoord, shadowParams);\n}\n#endif\n#if defined(CLUSTER_SHADOW_TYPE_PCF5)\nfloat getShadowSpotClusteredPCF5(SHADOWMAP_ACCEPT(shadowMap), vec3 shadowCoord, vec4 shadowParams) {\n	return getShadowPCF5x5(SHADOWMAP_PASS(shadowMap), shadowCoord, shadowParams);\n}\n#endif\n";

var clusteredLightPS = "\nuniform highp sampler2D clusterWorldTexture;\nuniform highp sampler2D lightsTexture8;\nuniform highp sampler2D lightsTextureFloat;\n#ifdef CLUSTER_SHADOWS\n	uniform sampler2DShadow shadowAtlasTexture;\n#endif\n#ifdef CLUSTER_COOKIES\n	uniform sampler2D cookieAtlasTexture;\n#endif\nuniform int clusterMaxCells;\nuniform float clusterSkip;\nuniform vec3 clusterCellsCountByBoundsSize;\nuniform vec3 clusterTextureSize;\nuniform vec3 clusterBoundsMin;\nuniform vec3 clusterBoundsDelta;\nuniform vec3 clusterCellsDot;\nuniform vec3 clusterCellsMax;\nuniform vec2 clusterCompressionLimit0;\nuniform vec2 shadowAtlasParams;\nstruct ClusterLightData {\n	vec3 halfWidth;\n	float lightType;\n	vec3 halfHeight;\n	int lightIndex;\n	vec3 position;\n	float shape;\n	vec3 direction;\n	float falloffMode;\n	vec3 color;\n	float shadowIntensity;\n	vec3 omniAtlasViewport;\n	float range;\n	vec4 cookieChannelMask;\n	float shadowBias;\n	float shadowNormalBias;\n	float innerConeAngleCos;\n	float outerConeAngleCos;\n	float cookie;\n	float cookieRgb;\n	float cookieIntensity;\n	float mask;\n};\nmat4 lightProjectionMatrix;\nbool isClusteredLightCastShadow(in ClusterLightData light) {\n  return light.shadowIntensity > 0.0;\n}\nbool isClusteredLightCookie(in ClusterLightData light) {\n  return light.cookie > 0.5;\n}\nbool isClusteredLightCookieRgb(in ClusterLightData light) {\n  return light.cookieRgb > 0.5;\n}\nbool isClusteredLightSpot(in ClusterLightData light) {\n  return light.lightType > 0.5;\n}\nbool isClusteredLightFalloffLinear(in ClusterLightData light) {\n  return light.falloffMode < 0.5;\n}\nbool isClusteredLightArea(in ClusterLightData light) {\n  return light.shape > 0.1;\n}\nbool isClusteredLightRect(in ClusterLightData light) {\n  return light.shape < 0.3;\n}\nbool isClusteredLightDisk(in ClusterLightData light) {\n  return light.shape < 0.6;\n}\n#ifdef CLUSTER_MESH_DYNAMIC_LIGHTS\n	bool acceptLightMask(in ClusterLightData light) {\n		return light.mask < 0.75;\n	}\n#else\n	bool acceptLightMask(in ClusterLightData light) {\n		return light.mask > 0.25;\n	}\n#endif\nvec4 decodeClusterLowRange4Vec4(vec4 d0, vec4 d1, vec4 d2, vec4 d3) {\n	return vec4(\n		bytes2floatRange4(d0, -2.0, 2.0),\n		bytes2floatRange4(d1, -2.0, 2.0),\n		bytes2floatRange4(d2, -2.0, 2.0),\n		bytes2floatRange4(d3, -2.0, 2.0)\n	);\n}\nvec4 sampleLightsTexture8(const ClusterLightData clusterLightData, int index) {\n	return texelFetch(lightsTexture8, ivec2(index, clusterLightData.lightIndex), 0);\n}\nvec4 sampleLightTextureF(const ClusterLightData clusterLightData, int index) {\n	return texelFetch(lightsTextureFloat, ivec2(index, clusterLightData.lightIndex), 0);\n}\nvoid decodeClusterLightCore(inout ClusterLightData clusterLightData, float lightIndex) {\n	clusterLightData.lightIndex = int(lightIndex);\n	vec4 lightInfo = sampleLightsTexture8(clusterLightData, CLUSTER_TEXTURE_8_FLAGS);\n	clusterLightData.lightType = lightInfo.x;\n	clusterLightData.shape = lightInfo.y;\n	clusterLightData.falloffMode = lightInfo.z;\n	clusterLightData.shadowIntensity = lightInfo.w;\n	vec4 colorA = sampleLightsTexture8(clusterLightData, CLUSTER_TEXTURE_8_COLOR_A);\n	vec4 colorB = sampleLightsTexture8(clusterLightData, CLUSTER_TEXTURE_8_COLOR_B);\n	clusterLightData.color = vec3(bytes2float2(colorA.xy), bytes2float2(colorA.zw), bytes2float2(colorB.xy)) * clusterCompressionLimit0.y;\n	clusterLightData.cookie = colorB.z;\n	clusterLightData.mask = colorB.w;\n	vec4 lightPosRange = sampleLightTextureF(clusterLightData, CLUSTER_TEXTURE_F_POSITION_RANGE);\n	clusterLightData.position = lightPosRange.xyz;\n	clusterLightData.range = lightPosRange.w;\n	vec4 lightDir_Unused = sampleLightTextureF(clusterLightData, CLUSTER_TEXTURE_F_SPOT_DIRECTION);\n	clusterLightData.direction = lightDir_Unused.xyz;\n}\nvoid decodeClusterLightSpot(inout ClusterLightData clusterLightData) {\n	vec4 coneAngle = sampleLightsTexture8(clusterLightData, CLUSTER_TEXTURE_8_SPOT_ANGLES);\n	clusterLightData.innerConeAngleCos = bytes2float2(coneAngle.xy) * 2.0 - 1.0;\n	clusterLightData.outerConeAngleCos = bytes2float2(coneAngle.zw) * 2.0 - 1.0;\n}\nvoid decodeClusterLightOmniAtlasViewport(inout ClusterLightData clusterLightData) {\n	clusterLightData.omniAtlasViewport = sampleLightTextureF(clusterLightData, CLUSTER_TEXTURE_F_PROJ_MAT_0).xyz;\n}\nvoid decodeClusterLightAreaData(inout ClusterLightData clusterLightData) {\n	clusterLightData.halfWidth = sampleLightTextureF(clusterLightData, CLUSTER_TEXTURE_F_AREA_DATA_WIDTH).xyz;\n	clusterLightData.halfHeight = sampleLightTextureF(clusterLightData, CLUSTER_TEXTURE_F_AREA_DATA_HEIGHT).xyz;\n}\nvoid decodeClusterLightProjectionMatrixData(inout ClusterLightData clusterLightData) {\n	\n	vec4 m0 = sampleLightTextureF(clusterLightData, CLUSTER_TEXTURE_F_PROJ_MAT_0);\n	vec4 m1 = sampleLightTextureF(clusterLightData, CLUSTER_TEXTURE_F_PROJ_MAT_1);\n	vec4 m2 = sampleLightTextureF(clusterLightData, CLUSTER_TEXTURE_F_PROJ_MAT_2);\n	vec4 m3 = sampleLightTextureF(clusterLightData, CLUSTER_TEXTURE_F_PROJ_MAT_3);\n	lightProjectionMatrix = mat4(m0, m1, m2, m3);\n}\nvoid decodeClusterLightShadowData(inout ClusterLightData clusterLightData) {\n	\n	vec4 biases = sampleLightsTexture8(clusterLightData, CLUSTER_TEXTURE_8_SHADOW_BIAS);\n	clusterLightData.shadowBias = bytes2floatRange2(biases.xy, -1.0, 20.0),\n	clusterLightData.shadowNormalBias = bytes2float2(biases.zw);\n}\nvoid decodeClusterLightCookieData(inout ClusterLightData clusterLightData) {\n	vec4 cookieA = sampleLightsTexture8(clusterLightData, CLUSTER_TEXTURE_8_COOKIE_A);\n	clusterLightData.cookieIntensity = cookieA.x;\n	clusterLightData.cookieRgb = cookieA.y;\n	clusterLightData.cookieChannelMask = sampleLightsTexture8(clusterLightData, CLUSTER_TEXTURE_8_COOKIE_B);\n}\nvoid evaluateLight(\n	ClusterLightData light, \n	vec3 worldNormal, \n	vec3 viewDir, \n	vec3 reflectionDir,\n#if defined(LIT_CLEARCOAT)\n	vec3 clearcoatReflectionDir,\n#endif\n	float gloss, \n	vec3 specularity, \n	vec3 geometricNormal, \n	mat3 tbn, \n#if defined(LIT_IRIDESCENCE)\n	vec3 iridescenceFresnel,\n#endif\n	vec3 clearcoat_worldNormal,\n	float clearcoat_gloss,\n	float sheen_gloss,\n	float iridescence_intensity\n) {\n	vec3 cookieAttenuation = vec3(1.0);\n	float diffuseAttenuation = 1.0;\n	float falloffAttenuation = 1.0;\n	vec3 lightDirW;\n	vec3 lightDirNormW;\n	evalOmniLight(light.position, lightDirW, lightDirNormW);\n	#ifdef CLUSTER_AREALIGHTS\n	if (isClusteredLightArea(light)) {\n		decodeClusterLightAreaData(light);\n		if (isClusteredLightRect(light)) {\n			calcRectLightValues(light.position, light.halfWidth, light.halfHeight);\n		} else if (isClusteredLightDisk(light)) {\n			calcDiskLightValues(light.position, light.halfWidth, light.halfHeight);\n		} else {\n			calcSphereLightValues(light.position, light.halfWidth, light.halfHeight);\n		}\n		falloffAttenuation = getFalloffWindow(light.range, lightDirW);\n	} else\n	#endif\n	{\n		if (isClusteredLightFalloffLinear(light))\n			falloffAttenuation = getFalloffLinear(light.range, lightDirW);\n		else\n			falloffAttenuation = getFalloffInvSquared(light.range, lightDirW);\n	}\n	if (falloffAttenuation > 0.00001) {\n		#ifdef CLUSTER_AREALIGHTS\n		if (isClusteredLightArea(light)) {\n			if (isClusteredLightRect(light)) {\n				diffuseAttenuation = getRectLightDiffuse(worldNormal, viewDir, lightDirW, lightDirNormW) * 16.0;\n			} else if (isClusteredLightDisk(light)) {\n				diffuseAttenuation = getDiskLightDiffuse(worldNormal, viewDir, lightDirW, lightDirNormW) * 16.0;\n			} else {\n				diffuseAttenuation = getSphereLightDiffuse(worldNormal, viewDir, lightDirW, lightDirNormW) * 16.0;\n			}\n		} else\n		#endif\n		{\n			falloffAttenuation *= getLightDiffuse(worldNormal, viewDir, lightDirNormW); \n		}\n		if (isClusteredLightSpot(light)) {\n			decodeClusterLightSpot(light);\n			falloffAttenuation *= getSpotEffect(light.direction, light.innerConeAngleCos, light.outerConeAngleCos, lightDirNormW);\n		}\n		#if defined(CLUSTER_COOKIES) || defined(CLUSTER_SHADOWS)\n		if (falloffAttenuation > 0.00001) {\n			if (isClusteredLightCastShadow(light) || isClusteredLightCookie(light)) {\n				if (isClusteredLightSpot(light)) {\n					decodeClusterLightProjectionMatrixData(light);\n				} else {\n					decodeClusterLightOmniAtlasViewport(light);\n				}\n				float shadowTextureResolution = shadowAtlasParams.x;\n				float shadowEdgePixels = shadowAtlasParams.y;\n				#ifdef CLUSTER_COOKIES\n				if (isClusteredLightCookie(light)) {\n					decodeClusterLightCookieData(light);\n					if (isClusteredLightSpot(light)) {\n						cookieAttenuation = getCookie2DClustered(TEXTURE_PASS(cookieAtlasTexture), lightProjectionMatrix, vPositionW, light.cookieIntensity, isClusteredLightCookieRgb(light), light.cookieChannelMask);\n					} else {\n						cookieAttenuation = getCookieCubeClustered(TEXTURE_PASS(cookieAtlasTexture), lightDirW, light.cookieIntensity, isClusteredLightCookieRgb(light), light.cookieChannelMask, shadowTextureResolution, shadowEdgePixels, light.omniAtlasViewport);\n					}\n				}\n				#endif\n				#ifdef CLUSTER_SHADOWS\n				if (isClusteredLightCastShadow(light)) {\n					decodeClusterLightShadowData(light);\n					vec4 shadowParams = vec4(shadowTextureResolution, light.shadowNormalBias, light.shadowBias, 1.0 / light.range);\n					if (isClusteredLightSpot(light)) {\n						vec3 shadowCoord = getShadowCoordPerspZbufferNormalOffset(lightProjectionMatrix, shadowParams, geometricNormal);\n						\n						#if defined(CLUSTER_SHADOW_TYPE_PCF1)\n							float shadow = getShadowSpotClusteredPCF1(SHADOWMAP_PASS(shadowAtlasTexture), shadowCoord, shadowParams);\n						#elif defined(CLUSTER_SHADOW_TYPE_PCF3)\n							float shadow = getShadowSpotClusteredPCF3(SHADOWMAP_PASS(shadowAtlasTexture), shadowCoord, shadowParams);\n						#elif defined(CLUSTER_SHADOW_TYPE_PCF5)\n							float shadow = getShadowSpotClusteredPCF5(SHADOWMAP_PASS(shadowAtlasTexture), shadowCoord, shadowParams);\n						#elif defined(CLUSTER_SHADOW_TYPE_PCSS)\n							float shadow = getShadowSpotClusteredPCSS(SHADOWMAP_PASS(shadowAtlasTexture), shadowCoord, shadowParams);\n						#endif\n						falloffAttenuation *= mix(1.0, shadow, light.shadowIntensity);\n					} else {\n						vec3 dir = normalOffsetPointShadow(shadowParams, light.position, lightDirW, lightDirNormW, geometricNormal);\n						#if defined(CLUSTER_SHADOW_TYPE_PCF1)\n							float shadow = getShadowOmniClusteredPCF1(SHADOWMAP_PASS(shadowAtlasTexture), shadowParams, light.omniAtlasViewport, shadowEdgePixels, dir);\n						#elif defined(CLUSTER_SHADOW_TYPE_PCF3)\n							float shadow = getShadowOmniClusteredPCF3(SHADOWMAP_PASS(shadowAtlasTexture), shadowParams, light.omniAtlasViewport, shadowEdgePixels, dir);\n						#elif defined(CLUSTER_SHADOW_TYPE_PCF5)\n							float shadow = getShadowOmniClusteredPCF5(SHADOWMAP_PASS(shadowAtlasTexture), shadowParams, light.omniAtlasViewport, shadowEdgePixels, dir);\n						#endif\n						falloffAttenuation *= mix(1.0, shadow, light.shadowIntensity);\n					}\n				}\n				#endif\n			}\n		}\n		#endif\n		#ifdef CLUSTER_AREALIGHTS\n		if (isClusteredLightArea(light)) {\n			{\n				vec3 areaDiffuse = (diffuseAttenuation * falloffAttenuation) * light.color * cookieAttenuation;\n				#if defined(LIT_SPECULAR)\n					areaDiffuse = mix(areaDiffuse, vec3(0), dLTCSpecFres);\n				#endif\n				dDiffuseLight += areaDiffuse;\n			}\n			#ifdef LIT_SPECULAR\n				float areaLightSpecular;\n				if (isClusteredLightRect(light)) {\n					areaLightSpecular = getRectLightSpecular(worldNormal, viewDir);\n				} else if (isClusteredLightDisk(light)) {\n					areaLightSpecular = getDiskLightSpecular(worldNormal, viewDir);\n				} else {\n					areaLightSpecular = getSphereLightSpecular(worldNormal, viewDir);\n				}\n				dSpecularLight += dLTCSpecFres * areaLightSpecular * falloffAttenuation * light.color * cookieAttenuation;\n				#ifdef LIT_CLEARCOAT\n					float areaLightSpecularCC;\n					if (isClusteredLightRect(light)) {\n						areaLightSpecularCC = getRectLightSpecular(clearcoat_worldNormal, viewDir);\n					} else if (isClusteredLightDisk(light)) {\n						areaLightSpecularCC = getDiskLightSpecular(clearcoat_worldNormal, viewDir);\n					} else {\n						areaLightSpecularCC = getSphereLightSpecular(clearcoat_worldNormal, viewDir);\n					}\n					ccSpecularLight += ccLTCSpecFres * areaLightSpecularCC * falloffAttenuation * light.color  * cookieAttenuation;\n				#endif\n			#endif\n		} else\n		#endif\n		{\n			{\n				vec3 punctualDiffuse = falloffAttenuation * light.color * cookieAttenuation;\n				#if defined(CLUSTER_AREALIGHTS)\n				#if defined(LIT_SPECULAR)\n					punctualDiffuse = mix(punctualDiffuse, vec3(0), specularity);\n				#endif\n				#endif\n				dDiffuseLight += punctualDiffuse;\n			}\n   \n			#ifdef LIT_SPECULAR\n				vec3 halfDir = normalize(-lightDirNormW + viewDir);\n				\n				#ifdef LIT_SPECULAR_FRESNEL\n					dSpecularLight += \n						getLightSpecular(halfDir, reflectionDir, worldNormal, viewDir, lightDirNormW, gloss, tbn) * falloffAttenuation * light.color * cookieAttenuation * \n						getFresnel(\n							dot(viewDir, halfDir), \n							gloss, \n							specularity\n						#if defined(LIT_IRIDESCENCE)\n							, iridescenceFresnel,\n							iridescence_intensity\n						#endif\n							);\n				#else\n					dSpecularLight += getLightSpecular(halfDir, reflectionDir, worldNormal, viewDir, lightDirNormW, gloss, tbn) * falloffAttenuation * light.color * cookieAttenuation * specularity;\n				#endif\n				#ifdef LIT_CLEARCOAT\n					#ifdef LIT_SPECULAR_FRESNEL\n						ccSpecularLight += getLightSpecular(halfDir, clearcoatReflectionDir, clearcoat_worldNormal, viewDir, lightDirNormW, clearcoat_gloss, tbn) * falloffAttenuation * light.color * cookieAttenuation * getFresnelCC(dot(viewDir, halfDir));\n					#else\n						ccSpecularLight += getLightSpecular(halfDir, clearcoatReflectionDir, clearcoat_worldNormal, viewDir, lightDirNormW, clearcoat_gloss, tbn) * falloffAttenuation * light.color * cookieAttenuation; \n					#endif\n				#endif\n				#ifdef LIT_SHEEN\n					sSpecularLight += getLightSpecularSheen(halfDir, worldNormal, viewDir, lightDirNormW, sheen_gloss) * falloffAttenuation * light.color * cookieAttenuation;\n				#endif\n			#endif\n		}\n	}\n	dAtten = falloffAttenuation;\n	dLightDirNormW = lightDirNormW;\n}\nvoid evaluateClusterLight(\n	float lightIndex, \n	vec3 worldNormal, \n	vec3 viewDir, \n	vec3 reflectionDir, \n#if defined(LIT_CLEARCOAT)\n	vec3 clearcoatReflectionDir,\n#endif\n	float gloss, \n	vec3 specularity, \n	vec3 geometricNormal, \n	mat3 tbn, \n#if defined(LIT_IRIDESCENCE)\n	vec3 iridescenceFresnel,\n#endif\n	vec3 clearcoat_worldNormal,\n	float clearcoat_gloss,\n	float sheen_gloss,\n	float iridescence_intensity\n) {\n	ClusterLightData clusterLightData;\n	decodeClusterLightCore(clusterLightData, lightIndex);\n	if (acceptLightMask(clusterLightData))\n		evaluateLight(\n			clusterLightData, \n			worldNormal, \n			viewDir, \n			reflectionDir, \n#if defined(LIT_CLEARCOAT)\n			clearcoatReflectionDir, \n#endif\n			gloss, \n			specularity, \n			geometricNormal, \n			tbn, \n#if defined(LIT_IRIDESCENCE)\n			iridescenceFresnel,\n#endif\n			clearcoat_worldNormal,\n			clearcoat_gloss,\n			sheen_gloss,\n			iridescence_intensity\n		);\n}\nvoid addClusteredLights(\n	vec3 worldNormal, \n	vec3 viewDir, \n	vec3 reflectionDir, \n#if defined(LIT_CLEARCOAT)\n	vec3 clearcoatReflectionDir,\n#endif\n	float gloss, \n	vec3 specularity, \n	vec3 geometricNormal, \n	mat3 tbn, \n#if defined(LIT_IRIDESCENCE)\n	vec3 iridescenceFresnel,\n#endif\n	vec3 clearcoat_worldNormal,\n	float clearcoat_gloss,\n	float sheen_gloss,\n	float iridescence_intensity\n) {\n	if (clusterSkip > 0.5)\n		return;\n	vec3 cellCoords = floor((vPositionW - clusterBoundsMin) * clusterCellsCountByBoundsSize);\n	if (!(any(lessThan(cellCoords, vec3(0.0))) || any(greaterThanEqual(cellCoords, clusterCellsMax)))) {\n		float cellIndex = dot(clusterCellsDot, cellCoords);\n		float clusterV = floor(cellIndex * clusterTextureSize.y);\n		float clusterU = cellIndex - (clusterV * clusterTextureSize.x);\n		for (int lightCellIndex = 0; lightCellIndex < clusterMaxCells; lightCellIndex++) {\n			float lightIndex = texelFetch(clusterWorldTexture, ivec2(int(clusterU) + lightCellIndex, clusterV), 0).x;\n			if (lightIndex <= 0.0)\n					return;\n			evaluateClusterLight(\n				lightIndex * 255.0, \n				worldNormal, \n				viewDir, \n				reflectionDir,\n#if defined(LIT_CLEARCOAT)\n				clearcoatReflectionDir,\n#endif\n				gloss, \n				specularity, \n				geometricNormal, \n				tbn, \n#if defined(LIT_IRIDESCENCE)\n				iridescenceFresnel,\n#endif\n				clearcoat_worldNormal,\n				clearcoat_gloss,\n				sheen_gloss,\n				iridescence_intensity\n			); \n		}\n	}\n}\n";

var combinePS = "\nvec3 combineColor(vec3 albedo, vec3 sheenSpecularity, float clearcoatSpecularity) {\n	vec3 ret = vec3(0);\n#ifdef LIT_OLD_AMBIENT\n	ret += (dDiffuseLight - light_globalAmbient) * albedo + material_ambient * light_globalAmbient;\n#else\n	ret += albedo * dDiffuseLight;\n#endif\n#ifdef LIT_SPECULAR\n	ret += dSpecularLight;\n#endif\n#ifdef LIT_REFLECTIONS\n	ret += dReflection.rgb * dReflection.a;\n#endif\n#ifdef LIT_SHEEN\n	float sheenScaling = 1.0 - max(max(sheenSpecularity.r, sheenSpecularity.g), sheenSpecularity.b) * 0.157;\n	ret = ret * sheenScaling + (sSpecularLight + sReflection.rgb) * sheenSpecularity;\n#endif\n#ifdef LIT_CLEARCOAT\n	float clearCoatScaling = 1.0 - ccFresnel * clearcoatSpecularity;\n	ret = ret * clearCoatScaling + (ccSpecularLight + ccReflection.rgb) * clearcoatSpecularity;\n#endif\n	return ret;\n}\n";

var cookiePS = "\nvec4 getCookie2D(sampler2D tex, mat4 transform, float intensity) {\n	vec4 projPos = transform * vec4(vPositionW, 1.0);\n	projPos.xy /= projPos.w;\n	return mix(vec4(1.0), texture2D(tex, projPos.xy), intensity);\n}\nvec4 getCookie2DClip(sampler2D tex, mat4 transform, float intensity) {\n	vec4 projPos = transform * vec4(vPositionW, 1.0);\n	projPos.xy /= projPos.w;\n	if (projPos.x < 0.0 || projPos.x > 1.0 || projPos.y < 0.0 || projPos.y > 1.0 || projPos.z < 0.0) return vec4(0.0);\n	return mix(vec4(1.0), texture2D(tex, projPos.xy), intensity);\n}\nvec4 getCookie2DXform(sampler2D tex, mat4 transform, float intensity, vec4 cookieMatrix, vec2 cookieOffset) {\n	vec4 projPos = transform * vec4(vPositionW, 1.0);\n	projPos.xy /= projPos.w;\n	projPos.xy += cookieOffset;\n	vec2 uv = mat2(cookieMatrix) * (projPos.xy-vec2(0.5)) + vec2(0.5);\n	return mix(vec4(1.0), texture2D(tex, uv), intensity);\n}\nvec4 getCookie2DClipXform(sampler2D tex, mat4 transform, float intensity, vec4 cookieMatrix, vec2 cookieOffset) {\n	vec4 projPos = transform * vec4(vPositionW, 1.0);\n	projPos.xy /= projPos.w;\n	projPos.xy += cookieOffset;\n	if (projPos.x < 0.0 || projPos.x > 1.0 || projPos.y < 0.0 || projPos.y > 1.0 || projPos.z < 0.0) return vec4(0.0);\n	vec2 uv = mat2(cookieMatrix) * (projPos.xy-vec2(0.5)) + vec2(0.5);\n	return mix(vec4(1.0), texture2D(tex, uv), intensity);\n}\nvec4 getCookieCube(samplerCube tex, mat4 transform, float intensity) {\n	return mix(vec4(1.0), textureCube(tex, dLightDirNormW * mat3(transform)), intensity);\n}\n";

var cubeMapProjectPS = "\n#if LIT_CUBEMAP_PROJECTION == BOX\n	uniform vec3 envBoxMin;\n	uniform vec3 envBoxMax;\n#endif\nvec3 cubeMapProject(vec3 nrdir) {\n	#if LIT_CUBEMAP_PROJECTION == NONE\n		return cubeMapRotate(nrdir);\n	#endif\n	#if LIT_CUBEMAP_PROJECTION == BOX\n		nrdir = cubeMapRotate(nrdir);\n		vec3 rbmax = (envBoxMax - vPositionW) / nrdir;\n		vec3 rbmin = (envBoxMin - vPositionW) / nrdir;\n		vec3 rbminmax;\n		rbminmax.x = nrdir.x>0.0? rbmax.x : rbmin.x;\n		rbminmax.y = nrdir.y>0.0? rbmax.y : rbmin.y;\n		rbminmax.z = nrdir.z>0.0? rbmax.z : rbmin.z;\n		float fa = min(min(rbminmax.x, rbminmax.y), rbminmax.z);\n		vec3 posonbox = vPositionW + nrdir * fa;\n		vec3 envBoxPos = (envBoxMin + envBoxMax) * 0.5;\n		return normalize(posonbox - envBoxPos);\n	#endif\n}\n";

var cubeMapRotatePS = "\n#ifdef CUBEMAP_ROTATION\nuniform mat3 cubeMapRotationMatrix;\n#endif\nvec3 cubeMapRotate(vec3 refDir) {\n#ifdef CUBEMAP_ROTATION\n	return refDir * cubeMapRotationMatrix;\n#else\n	return refDir;\n#endif\n}\n";

var debugOutputPS = "\n#ifdef DEBUG_ALBEDO_PASS\ngl_FragColor = vec4(gammaCorrectOutput(dAlbedo), 1.0);\n#endif\n#ifdef DEBUG_UV0_PASS\ngl_FragColor = vec4(litArgs_albedo , 1.0);\n#endif\n#ifdef DEBUG_WORLD_NORMAL_PASS\ngl_FragColor = vec4(litArgs_worldNormal * 0.5 + 0.5, 1.0);\n#endif\n#ifdef DEBUG_OPACITY_PASS\ngl_FragColor = vec4(vec3(litArgs_opacity) , 1.0);\n#endif\n#ifdef DEBUG_SPECULARITY_PASS\ngl_FragColor = vec4(litArgs_specularity, 1.0);\n#endif\n#ifdef DEBUG_GLOSS_PASS\ngl_FragColor = vec4(vec3(litArgs_gloss) , 1.0);\n#endif\n#ifdef DEBUG_METALNESS_PASS\ngl_FragColor = vec4(vec3(litArgs_metalness) , 1.0);\n#endif\n#ifdef DEBUG_AO_PASS\ngl_FragColor = vec4(vec3(litArgs_ao) , 1.0);\n#endif\n#ifdef DEBUG_EMISSION_PASS\ngl_FragColor = vec4(gammaCorrectOutput(litArgs_emission), 1.0);\n#endif\n";

var debugProcessFrontendPS = "\n#ifdef DEBUG_LIGHTING_PASS\nlitArgs_albedo = vec3(0.5);\n#endif\n#ifdef DEBUG_UV0_PASS\n#ifdef VARYING_VUV0\nlitArgs_albedo = vec3(vUv0, 0);\n#else\nlitArgs_albedo = vec3(0);\n#endif\n#endif\n";

var decodePS$1 = "\n#ifndef _DECODE_INCLUDED_\n#define _DECODE_INCLUDED_\nvec3 decodeLinear(vec4 raw) {\n	return raw.rgb;\n}\nfloat decodeGamma(float raw) {\n	return pow(raw, 2.2);\n}\nvec3 decodeGamma(vec3 raw) {\n	return pow(raw, vec3(2.2));\n}\nvec3 decodeGamma(vec4 raw) {\n	return pow(raw.xyz, vec3(2.2));\n}\nvec3 decodeRGBM(vec4 raw) {\n	vec3 color = (8.0 * raw.a) * raw.rgb;\n	return color * color;\n}\nvec3 decodeRGBP(vec4 raw) {\n	vec3 color = raw.rgb * (-raw.a * 7.0 + 8.0);\n	return color * color;\n}\nvec3 decodeRGBE(vec4 raw) {\n	if (raw.a == 0.0) {\n		return vec3(0.0, 0.0, 0.0);\n	} else {\n		return raw.xyz * pow(2.0, raw.w * 255.0 - 128.0);\n	}\n}\nvec4 passThrough(vec4 raw) {\n	return raw;\n}\n#endif\n";

var detailModesPS = "\nvec3 detailMode_mul(vec3 c1, vec3 c2) {\n	return c1 * c2;\n}\nvec3 detailMode_add(vec3 c1, vec3 c2) {\n	return c1 + c2;\n}\nvec3 detailMode_screen(vec3 c1, vec3 c2) {\n	return 1.0 - (1.0 - c1)*(1.0 - c2);\n}\nvec3 detailMode_overlay(vec3 c1, vec3 c2) {\n	return mix(1.0 - 2.0*(1.0 - c1)*(1.0 - c2), 2.0*c1*c2, step(c1, vec3(0.5)));\n}\nvec3 detailMode_min(vec3 c1, vec3 c2) {\n	return min(c1, c2);\n}\nvec3 detailMode_max(vec3 c1, vec3 c2) {\n	return max(c1, c2);\n}\n";

var diffusePS = "\nuniform vec3 material_diffuse;\nvoid getAlbedo() {\n	dAlbedo = material_diffuse.rgb;\n#ifdef MAPTEXTURE\n	vec3 albedoBase = $DECODE(texture2DBias($SAMPLER, $UV, textureBias)).$CH;\n	dAlbedo *= addAlbedoDetail(albedoBase);\n#endif\n#ifdef MAPVERTEX\n	dAlbedo *= gammaCorrectInput(saturate(vVertexColor.$VC));\n#endif\n}\n";

var diffuseDetailMapPS = "\nvec3 addAlbedoDetail(vec3 albedo) {\n#ifdef MAPTEXTURE\n	vec3 albedoDetail = $DECODE(texture2DBias($SAMPLER, $UV, textureBias)).$CH;\n	return detailMode_$DETAILMODE(albedo, albedoDetail);\n#else\n	return albedo;\n#endif\n}\n";

var emissivePS = "\nuniform vec3 material_emissive;\nuniform float material_emissiveIntensity;\nvoid getEmission() {\n	dEmission = material_emissive * material_emissiveIntensity;\n	#ifdef MAPTEXTURE\n	dEmission *= $DECODE(texture2DBias($SAMPLER, $UV, textureBias)).$CH;\n	#endif\n	#ifdef MAPVERTEX\n	dEmission *= gammaCorrectInput(saturate(vVertexColor.$VC));\n	#endif\n}\n";

var encodePS$1 = "\nvec4 encodeLinear(vec3 source) {\n	return vec4(source, 1.0);\n}\nvec4 encodeGamma(vec3 source) {\n	return vec4(pow(source + 0.0000001, vec3(1.0 / 2.2)), 1.0);\n}\nvec4 encodeRGBM(vec3 source) {\n	vec4 result;\n	result.rgb = pow(source.rgb, vec3(0.5));\n	result.rgb *= 1.0 / 8.0;\n	result.a = saturate( max( max( result.r, result.g ), max( result.b, 1.0 / 255.0 ) ) );\n	result.a = ceil(result.a * 255.0) / 255.0;\n	result.rgb /= result.a;\n	return result;\n}\nvec4 encodeRGBP(vec3 source) {\n	vec3 gamma = pow(source, vec3(0.5));\n	float maxVal = min(8.0, max(1.0, max(gamma.x, max(gamma.y, gamma.z))));\n	float v = 1.0 - ((maxVal - 1.0) / 7.0);\n	v = ceil(v * 255.0) / 255.0;\n	return vec4(gamma / (-v * 7.0 + 8.0), v);	\n}\nvec4 encodeRGBE(vec3 source) {\n	float maxVal = max(source.x, max(source.y, source.z));\n	if (maxVal < 1e-32) {\n		return vec4(0, 0, 0, 0);\n	} else {\n		float e = ceil(log2(maxVal));\n		return vec4(source / pow(2.0, e), (e + 128.0) / 255.0);\n	}\n}\n";

var endPS = "\n	gl_FragColor.rgb = combineColor(litArgs_albedo, litArgs_sheen_specularity, litArgs_clearcoat_specularity);\n	gl_FragColor.rgb += litArgs_emission;\n	gl_FragColor.rgb = addFog(gl_FragColor.rgb);\n	gl_FragColor.rgb = toneMap(gl_FragColor.rgb);\n	gl_FragColor.rgb = gammaCorrectOutput(gl_FragColor.rgb);\n";

var envAtlasPS$1 = "\n#ifndef _ENVATLAS_INCLUDED_\n#define _ENVATLAS_INCLUDED_\nconst float atlasSize = 512.0;\nconst float seamSize = 1.0 / atlasSize;\nvec2 mapUv(vec2 uv, vec4 rect) {\n	return vec2(mix(rect.x + seamSize, rect.x + rect.z - seamSize, uv.x),\n				mix(rect.y + seamSize, rect.y + rect.w - seamSize, uv.y));\n}\nvec2 mapRoughnessUv(vec2 uv, float level) {\n	float t = 1.0 / exp2(level);\n	return mapUv(uv, vec4(0, 1.0 - t, t, t * 0.5));\n}\nvec2 mapShinyUv(vec2 uv, float level) {\n	float t = 1.0 / exp2(level);\n	return mapUv(uv, vec4(1.0 - t, 1.0 - t, t, t * 0.5));\n}\n#endif\n";

var envProcPS$1 = "\n#ifdef LIT_SKYBOX_INTENSITY\n	uniform float skyboxIntensity;\n#endif\nvec3 processEnvironment(vec3 color) {\n	#ifdef LIT_SKYBOX_INTENSITY\n		return color * skyboxIntensity;\n	#else\n		return color;\n	#endif\n}\n";

var falloffInvSquaredPS = "\nfloat getFalloffWindow(float lightRadius, vec3 lightDir) {\n	float sqrDist = dot(lightDir, lightDir);\n	float invRadius = 1.0 / lightRadius;\n	return square( saturate( 1.0 - square( sqrDist * square(invRadius) ) ) );\n}\nfloat getFalloffInvSquared(float lightRadius, vec3 lightDir) {\n	float sqrDist = dot(lightDir, lightDir);\n	float falloff = 1.0 / (sqrDist + 1.0);\n	float invRadius = 1.0 / lightRadius;\n	falloff *= 16.0;\n	falloff *= square( saturate( 1.0 - square( sqrDist * square(invRadius) ) ) );\n	return falloff;\n}\n";

var falloffLinearPS = "\nfloat getFalloffLinear(float lightRadius, vec3 lightDir) {\n	float d = length(lightDir);\n	return max(((lightRadius - d) / lightRadius), 0.0);\n}\n";

var floatUnpackingPS = "\nfloat bytes2float2(vec2 data) {\n	return dot(data, vec2(1.0, 1.0 / 255.0));\n}\nfloat bytes2float3(vec3 data) {\n	return dot(data, vec3(1.0, 1.0 / 255.0, 1.0 / 65025.0));\n}\nfloat bytes2float4(vec4 data) {\n	return dot(data, vec4(1.0, 1.0 / 255.0, 1.0 / 65025.0, 1.0 / 16581375.0));\n}\nfloat bytes2floatRange2(vec2 data, float min, float max) {\n	return mix(min, max, bytes2float2(data));\n}\nfloat bytes2floatRange3(vec3 data, float min, float max) {\n	return mix(min, max, bytes2float3(data));\n}\nfloat bytes2floatRange4(vec4 data, float min, float max) {\n	return mix(min, max, bytes2float4(data));\n}\nfloat mantissaExponent2Float(vec4 pack)\n{\n	float value = bytes2floatRange3(pack.xyz, -1.0, 1.0);\n	float exponent = floor(pack.w * 255.0 - 127.0);\n	return value * exp2(exponent);\n}\n";

var floatAsUintPS = "\n#ifndef FLOAT_AS_UINT\n#define FLOAT_AS_UINT\nvec4 float2uint(float value) {\n	uint intBits = floatBitsToUint(value);\n	return vec4(\n		float((intBits >> 24u) & 0xFFu) / 255.0,\n		float((intBits >> 16u) & 0xFFu) / 255.0,\n		float((intBits >> 8u) & 0xFFu) / 255.0,\n		float(intBits & 0xFFu) / 255.0\n	);\n}\nfloat uint2float(vec4 value) {\n	uint intBits = \n		(uint(value.r * 255.0) << 24u) |\n		(uint(value.g * 255.0) << 16u) |\n		(uint(value.b * 255.0) << 8u) |\n		uint(value.a * 255.0);\n	return uintBitsToFloat(intBits);\n}\n#endif\n";

var fogPS$1 = "\nfloat dBlendModeFogFactor = 1.0;\n#if (FOG != NONE)\n	uniform vec3 fog_color;\n	#if (FOG == LINEAR)\n		uniform float fog_start;\n		uniform float fog_end;\n	#else\n		uniform float fog_density;\n	#endif\n#endif\nfloat getFogFactor() {\n	float depth = gl_FragCoord.z / gl_FragCoord.w;\n	float fogFactor = 0.0;\n	#if (FOG == LINEAR)\n		fogFactor = (fog_end - depth) / (fog_end - fog_start);\n	#elif (FOG == EXP)\n		fogFactor = exp(-depth * fog_density);\n	#elif (FOG == EXP2)\n		fogFactor = exp(-depth * depth * fog_density * fog_density);\n	#endif\n	return clamp(fogFactor, 0.0, 1.0);\n}\nvec3 addFog(vec3 color) {\n	#if (FOG != NONE)\n		return mix(fog_color * dBlendModeFogFactor, color, getFogFactor());\n	#endif\n	return color;\n}\n";

var fresnelSchlickPS = "\nvec3 getFresnel(\n		float cosTheta, \n		float gloss, \n		vec3 specularity\n#if defined(LIT_IRIDESCENCE)\n		, vec3 iridescenceFresnel, \n		float iridescenceIntensity\n#endif\n	) {\n	float fresnel = pow(1.0 - max(cosTheta, 0.0), 5.0);\n	float glossSq = gloss * gloss;\n	vec3 ret = specularity + (max(vec3(glossSq), specularity) - specularity) * fresnel;\n#if defined(LIT_IRIDESCENCE)\n	return mix(ret, iridescenceFresnel, iridescenceIntensity);\n#else\n	return ret;\n#endif	\n}\nfloat getFresnelCC(float cosTheta) {\n	float fresnel = pow(1.0 - max(cosTheta, 0.0), 5.0);\n	return 0.04 + (1.0 - 0.04) * fresnel;\n}\n";

var fullscreenQuadPS = "\nvarying vec2 vUv0;\nuniform sampler2D source;\nvoid main(void) {\n	gl_FragColor = texture2D(source, vUv0);\n}\n";

var fullscreenQuadVS = "\nattribute vec2 vertex_position;\nvarying vec2 vUv0;\nvoid main(void)\n{\n	gl_Position = vec4(vertex_position, 0.5, 1.0);\n	vUv0 = vertex_position.xy*0.5+0.5;\n}\n";

var gammaPS$1 = '\n#include "decodePS"\n#if (GAMMA == SRGB)\n	float gammaCorrectInput(float color) {\n		return decodeGamma(color);\n	}\n	vec3 gammaCorrectInput(vec3 color) {\n		return decodeGamma(color);\n	}\n	vec4 gammaCorrectInput(vec4 color) {\n		return vec4(decodeGamma(color.xyz), color.w);\n	}\n	vec3 gammaCorrectOutput(vec3 color) {\n		return pow(color + 0.0000001, vec3(1.0 / 2.2));\n	}\n#else\n	float gammaCorrectInput(float color) {\n		return color;\n	}\n	vec3 gammaCorrectInput(vec3 color) {\n		return color;\n	}\n	vec4 gammaCorrectInput(vec4 color) {\n		return color;\n	}\n	vec3 gammaCorrectOutput(vec3 color) {\n		return color;\n	}\n#endif\n';

var glossPS = "\n#ifdef MAPFLOAT\nuniform float material_gloss;\n#endif\nvoid getGlossiness() {\n	dGlossiness = 1.0;\n	#ifdef MAPFLOAT\n	dGlossiness *= material_gloss;\n	#endif\n	#ifdef MAPTEXTURE\n	dGlossiness *= texture2DBias($SAMPLER, $UV, textureBias).$CH;\n	#endif\n	#ifdef MAPVERTEX\n	dGlossiness *= saturate(vVertexColor.$VC);\n	#endif\n	#ifdef MAPINVERT\n	dGlossiness = 1.0 - dGlossiness;\n	#endif\n	dGlossiness += 0.0000001;\n}\n";

var gsplatCenterVS = "\nuniform mat4 matrix_model;\nuniform mat4 matrix_view;\nuniform mat4 matrix_projection;\nbool initCenter(vec3 modelCenter, out SplatCenter center) {\n	mat4 modelView = matrix_view * matrix_model;\n	vec4 centerView = modelView * vec4(modelCenter, 1.0);\n	if (centerView.z > 0.0) {\n		return false;\n	}\n	vec4 centerProj = matrix_projection * centerView;\n	centerProj.z = clamp(centerProj.z, -abs(centerProj.w), abs(centerProj.w));\n	center.view = centerView.xyz / centerView.w;\n	center.proj = centerProj;\n	center.projMat00 = matrix_projection[0][0];\n	center.modelView = modelView;\n	return true;\n}\n";

var gsplatColorVS = "\nuniform mediump sampler2D splatColor;\nvec4 readColor(in SplatSource source) {\n	return texelFetch(splatColor, source.uv, 0);\n}\n";

var gsplatCommonVS = '\nstruct SplatSource {\n	uint order;\n	uint id;\n	ivec2 uv;\n	vec2 cornerUV;\n};\nstruct SplatCenter {\n	vec3 view;\n	vec4 proj;\n	mat4 modelView;\n	float projMat00;\n};\nstruct SplatCorner {\n	vec2 offset;\n	vec2 uv;\n};\n#if SH_BANDS > 0\n	#if SH_BANDS == 1\n		#define SH_COEFFS 3\n	#elif SH_BANDS == 2\n		#define SH_COEFFS 8\n	#elif SH_BANDS == 3\n		#define SH_COEFFS 15\n	#endif\n#endif\n#if GSPLAT_COMPRESSED_DATA == true\n	#include "gsplatCompressedDataVS"\n	#include "gsplatCompressedSHVS"\n#else\n	#include "gsplatDataVS"\n	#include "gsplatColorVS"\n	#include "gsplatSHVS"\n#endif\n#include "gsplatSourceVS"\n#include "gsplatCenterVS"\n#include "gsplatCornerVS"\n#include "gsplatOutputVS"\nvoid clipCorner(inout SplatCorner corner, float alpha) {\n	float clip = min(1.0, sqrt(-log(1.0 / 255.0 / alpha)) / 2.0);\n	corner.offset *= clip;\n	corner.uv *= clip;\n}\n#if SH_BANDS > 0\n#define SH_C1 0.4886025119029199f\n#if SH_BANDS > 1\n	#define SH_C2_0 1.0925484305920792f\n	#define SH_C2_1 -1.0925484305920792f\n	#define SH_C2_2 0.31539156525252005f\n	#define SH_C2_3 -1.0925484305920792f\n	#define SH_C2_4 0.5462742152960396f\n#endif\n#if SH_BANDS > 2\n	#define SH_C3_0 -0.5900435899266435f\n	#define SH_C3_1 2.890611442640554f\n	#define SH_C3_2 -0.4570457994644658f\n	#define SH_C3_3 0.3731763325901154f\n	#define SH_C3_4 -0.4570457994644658f\n	#define SH_C3_5 1.445305721320277f\n	#define SH_C3_6 -0.5900435899266435f\n#endif\nvec3 evalSH(in SplatSource source, in vec3 dir) {\n	vec3 sh[SH_COEFFS];\n	float scale;\n	readSHData(source, sh, scale);\n	float x = dir.x;\n	float y = dir.y;\n	float z = dir.z;\n	vec3 result = SH_C1 * (-sh[0] * y + sh[1] * z - sh[2] * x);\n#if SH_BANDS > 1\n	float xx = x * x;\n	float yy = y * y;\n	float zz = z * z;\n	float xy = x * y;\n	float yz = y * z;\n	float xz = x * z;\n	result +=\n		sh[3] * (SH_C2_0 * xy) *  +\n		sh[4] * (SH_C2_1 * yz) +\n		sh[5] * (SH_C2_2 * (2.0 * zz - xx - yy)) +\n		sh[6] * (SH_C2_3 * xz) +\n		sh[7] * (SH_C2_4 * (xx - yy));\n#endif\n#if SH_BANDS > 2\n	result +=\n		sh[8]  * (SH_C3_0 * y * (3.0 * xx - yy)) +\n		sh[9]  * (SH_C3_1 * xy * z) +\n		sh[10] * (SH_C3_2 * y * (4.0 * zz - xx - yy)) +\n		sh[11] * (SH_C3_3 * z * (2.0 * zz - 3.0 * xx - 3.0 * yy)) +\n		sh[12] * (SH_C3_4 * x * (4.0 * zz - xx - yy)) +\n		sh[13] * (SH_C3_5 * z * (xx - yy)) +\n		sh[14] * (SH_C3_6 * x * (xx - 3.0 * yy));\n#endif\n	return result * scale;\n}\n#endif\n';

var gsplatCompressedDataVS = "\nuniform highp usampler2D packedTexture;\nuniform highp sampler2D chunkTexture;\nvec4 chunkDataA;\nvec4 chunkDataB;\nvec4 chunkDataC;\nvec4 chunkDataD;\nvec4 chunkDataE;\nuvec4 packedData;\nvec3 unpack111011(uint bits) {\n	return vec3(\n		float(bits >> 21u) / 2047.0,\n		float((bits >> 11u) & 0x3ffu) / 1023.0,\n		float(bits & 0x7ffu) / 2047.0\n	);\n}\nvec4 unpack8888(uint bits) {\n	return vec4(\n		float(bits >> 24u) / 255.0,\n		float((bits >> 16u) & 0xffu) / 255.0,\n		float((bits >> 8u) & 0xffu) / 255.0,\n		float(bits & 0xffu) / 255.0\n	);\n}\nconst float norm = 1.0 / (sqrt(2.0) * 0.5);\nvec4 unpackRotation(uint bits) {\n	float a = (float((bits >> 20u) & 0x3ffu) / 1023.0 - 0.5) * norm;\n	float b = (float((bits >> 10u) & 0x3ffu) / 1023.0 - 0.5) * norm;\n	float c = (float(bits & 0x3ffu) / 1023.0 - 0.5) * norm;\n	float m = sqrt(1.0 - (a * a + b * b + c * c));\n	uint mode = bits >> 30u;\n	if (mode == 0u) return vec4(m, a, b, c);\n	if (mode == 1u) return vec4(a, m, b, c);\n	if (mode == 2u) return vec4(a, b, m, c);\n	return vec4(a, b, c, m);\n}\nmat3 quatToMat3(vec4 R) {\n	float x = R.x;\n	float y = R.y;\n	float z = R.z;\n	float w = R.w;\n	return mat3(\n		1.0 - 2.0 * (z * z + w * w),\n			  2.0 * (y * z + x * w),\n			  2.0 * (y * w - x * z),\n			  2.0 * (y * z - x * w),\n		1.0 - 2.0 * (y * y + w * w),\n			  2.0 * (z * w + x * y),\n			  2.0 * (y * w + x * z),\n			  2.0 * (z * w - x * y),\n		1.0 - 2.0 * (y * y + z * z)\n	);\n}\nvec3 readCenter(SplatSource source) {\n	uint w = uint(textureSize(chunkTexture, 0).x) / 5u;\n	uint chunkId = source.id / 256u;\n	ivec2 chunkUV = ivec2((chunkId % w) * 5u, chunkId / w);\n	chunkDataA = texelFetch(chunkTexture, chunkUV, 0);\n	chunkDataB = texelFetch(chunkTexture, chunkUV + ivec2(1, 0), 0);\n	chunkDataC = texelFetch(chunkTexture, chunkUV + ivec2(2, 0), 0);\n	chunkDataD = texelFetch(chunkTexture, chunkUV + ivec2(3, 0), 0);\n	chunkDataE = texelFetch(chunkTexture, chunkUV + ivec2(4, 0), 0);\n	packedData = texelFetch(packedTexture, source.uv, 0);\n	return mix(chunkDataA.xyz, vec3(chunkDataA.w, chunkDataB.xy), unpack111011(packedData.x));\n}\nvec4 readColor(in SplatSource source) {\n	vec4 r = unpack8888(packedData.w);\n	return vec4(mix(chunkDataD.xyz, vec3(chunkDataD.w, chunkDataE.xy), r.rgb), r.w);\n}\nvec4 getRotation() {\n	return unpackRotation(packedData.y);\n}\nvec3 getScale() {\n	return exp(mix(vec3(chunkDataB.zw, chunkDataC.x), chunkDataC.yzw, unpack111011(packedData.z)));\n}\nvoid readCovariance(in SplatSource source, out vec3 covA, out vec3 covB) {\n	mat3 rot = quatToMat3(getRotation());\n	vec3 scale = getScale();\n	mat3 M = transpose(mat3(\n		scale.x * rot[0],\n		scale.y * rot[1],\n		scale.z * rot[2]\n	));\n	covA = vec3(dot(M[0], M[0]), dot(M[0], M[1]), dot(M[0], M[2]));\n	covB = vec3(dot(M[1], M[1]), dot(M[1], M[2]), dot(M[2], M[2]));\n}\n";

var gsplatCompressedSHVS = "\n#if SH_BANDS > 0\nuniform highp usampler2D shTexture0;\nuniform highp usampler2D shTexture1;\nuniform highp usampler2D shTexture2;\nvec4 unpack8888s(in uint bits) {\n	return vec4((uvec4(bits) >> uvec4(0u, 8u, 16u, 24u)) & 0xffu) * (8.0 / 255.0) - 4.0;\n}\nvoid readSHData(in SplatSource source, out vec3 sh[15], out float scale) {\n	uvec4 shData0 = texelFetch(shTexture0, source.uv, 0);\n	uvec4 shData1 = texelFetch(shTexture1, source.uv, 0);\n	uvec4 shData2 = texelFetch(shTexture2, source.uv, 0);\n	vec4 r0 = unpack8888s(shData0.x);\n	vec4 r1 = unpack8888s(shData0.y);\n	vec4 r2 = unpack8888s(shData0.z);\n	vec4 r3 = unpack8888s(shData0.w);\n	vec4 g0 = unpack8888s(shData1.x);\n	vec4 g1 = unpack8888s(shData1.y);\n	vec4 g2 = unpack8888s(shData1.z);\n	vec4 g3 = unpack8888s(shData1.w);\n	vec4 b0 = unpack8888s(shData2.x);\n	vec4 b1 = unpack8888s(shData2.y);\n	vec4 b2 = unpack8888s(shData2.z);\n	vec4 b3 = unpack8888s(shData2.w);\n	sh[0] =  vec3(r0.x, g0.x, b0.x);\n	sh[1] =  vec3(r0.y, g0.y, b0.y);\n	sh[2] =  vec3(r0.z, g0.z, b0.z);\n	sh[3] =  vec3(r0.w, g0.w, b0.w);\n	sh[4] =  vec3(r1.x, g1.x, b1.x);\n	sh[5] =  vec3(r1.y, g1.y, b1.y);\n	sh[6] =  vec3(r1.z, g1.z, b1.z);\n	sh[7] =  vec3(r1.w, g1.w, b1.w);\n	sh[8] =  vec3(r2.x, g2.x, b2.x);\n	sh[9] =  vec3(r2.y, g2.y, b2.y);\n	sh[10] = vec3(r2.z, g2.z, b2.z);\n	sh[11] = vec3(r2.w, g2.w, b2.w);\n	sh[12] = vec3(r3.x, g3.x, b3.x);\n	sh[13] = vec3(r3.y, g3.y, b3.y);\n	sh[14] = vec3(r3.z, g3.z, b3.z);\n	scale = 1.0;\n}\n#endif\n";

var gsplatCornerVS = "\nuniform vec2 viewport;\nuniform vec4 camera_params;\nbool initCorner(SplatSource source, SplatCenter center, out SplatCorner corner) {\n	vec3 covA, covB;\n	readCovariance(source, covA, covB);\n	mat3 Vrk = mat3(\n		covA.x, covA.y, covA.z, \n		covA.y, covB.x, covB.y,\n		covA.z, covB.y, covB.z\n	);\n	float focal = viewport.x * center.projMat00;\n	vec3 v = camera_params.w == 1.0 ? vec3(0.0, 0.0, 1.0) : center.view.xyz;\n	float J1 = focal / v.z;\n	vec2 J2 = -J1 / v.z * v.xy;\n	mat3 J = mat3(\n		J1, 0.0, J2.x, \n		0.0, J1, J2.y, \n		0.0, 0.0, 0.0\n	);\n	mat3 W = transpose(mat3(center.modelView));\n	mat3 T = W * J;\n	mat3 cov = transpose(T) * Vrk * T;\n	float diagonal1 = cov[0][0] + 0.3;\n	float offDiagonal = cov[0][1];\n	float diagonal2 = cov[1][1] + 0.3;\n	float mid = 0.5 * (diagonal1 + diagonal2);\n	float radius = length(vec2((diagonal1 - diagonal2) / 2.0, offDiagonal));\n	float lambda1 = mid + radius;\n	float lambda2 = max(mid - radius, 0.1);\n	float l1 = 2.0 * min(sqrt(2.0 * lambda1), 1024.0);\n	float l2 = 2.0 * min(sqrt(2.0 * lambda2), 1024.0);\n	if (l1 < 2.0 && l2 < 2.0) {\n		return false;\n	}\n	vec2 c = center.proj.ww / viewport;\n	if (any(greaterThan(abs(center.proj.xy) - vec2(max(l1, l2)) * c, center.proj.ww))) {\n		return false;\n	}\n	vec2 diagonalVector = normalize(vec2(offDiagonal, lambda1 - diagonal1));\n	vec2 v1 = l1 * diagonalVector;\n	vec2 v2 = l2 * vec2(diagonalVector.y, -diagonalVector.x);\n	corner.offset = (source.cornerUV.x * v1 + source.cornerUV.y * v2) * c;\n	corner.uv = source.cornerUV;\n	return true;\n}\n";

var gsplatDataVS = "\nuniform highp usampler2D transformA;\nuniform highp sampler2D transformB;\nuint tAw;\nvec3 readCenter(SplatSource source) {\n	uvec4 tA = texelFetch(transformA, source.uv, 0);\n	tAw = tA.w;\n	return uintBitsToFloat(tA.xyz);\n}\nmat3 quatToMat3(vec4 R) {\n	float x = R.w;\n	float y = R.x;\n	float z = R.y;\n	float w = R.z;\n	return mat3(\n		1.0 - 2.0 * (z * z + w * w),\n			  2.0 * (y * z + x * w),\n			  2.0 * (y * w - x * z),\n			  2.0 * (y * z - x * w),\n		1.0 - 2.0 * (y * y + w * w),\n			  2.0 * (z * w + x * y),\n			  2.0 * (y * w + x * z),\n			  2.0 * (z * w - x * y),\n		1.0 - 2.0 * (y * y + z * z)\n	);\n}\nvec4 unpackRotation(vec3 packed) {\n	return vec4(packed.xyz, sqrt(1.0 - dot(packed, packed)));\n}\nvoid readCovariance(in SplatSource source, out vec3 covA, out vec3 covB) {\n	vec4 tB = texelFetch(transformB, source.uv, 0);\n	mat3 rot = quatToMat3(unpackRotation(vec3(unpackHalf2x16(tAw), tB.w)));\n	vec3 scale = tB.xyz;\n	\n	mat3 M = transpose(mat3(\n		scale.x * rot[0],\n		scale.y * rot[1],\n		scale.z * rot[2]\n	));\n	covA = vec3(dot(M[0], M[0]), dot(M[0], M[1]), dot(M[0], M[2]));\n	covB = vec3(dot(M[1], M[1]), dot(M[1], M[2]), dot(M[2], M[2]));\n}\n";

var gsplatOutputVS = '\n#include "tonemappingPS"\n#include "decodePS"\n#include "gammaPS"\nvec3 prepareOutputFromGamma(vec3 gammaColor) {\n	#if TONEMAP == NONE\n		#if GAMMA == NONE\n			return decodeGamma(gammaColor);\n		#else\n			return gammaColor;\n		#endif\n	#else\n		return gammaCorrectOutput(toneMap(decodeGamma(gammaColor)));\n	#endif\n}\n';

var gsplatPS = '\n#ifndef DITHER_NONE\n	#include "bayerPS"\n	#include "opacityDitherPS"\n	varying float id;\n#endif\n#ifdef PICK_PASS\n	uniform vec4 uColor;\n#endif\nvarying mediump vec2 gaussianUV;\nvarying mediump vec4 gaussianColor;\nvoid main(void) {\n	mediump float A = dot(gaussianUV, gaussianUV);\n	if (A > 1.0) {\n		discard;\n	}\n	mediump float alpha = exp(-A * 4.0) * gaussianColor.a;\n	#ifdef PICK_PASS\n		if (alpha < 0.3) {\n			discard;\n		}\n		gl_FragColor = uColor;\n	#else\n		if (alpha < 1.0 / 255.0) {\n			discard;\n		}\n		#ifndef DITHER_NONE\n			opacityDither(alpha, id * 0.013);\n		#endif\n		gl_FragColor = vec4(gaussianColor.xyz * alpha, alpha);\n	#endif\n}\n';

var gsplatSHVS = "\n#if SH_BANDS > 0\nvec3 unpack111011s(uint bits) {\n	return vec3((uvec3(bits) >> uvec3(21u, 11u, 0u)) & uvec3(0x7ffu, 0x3ffu, 0x7ffu)) / vec3(2047.0, 1023.0, 2047.0) * 2.0 - 1.0;\n}\nvoid fetchScale(in uvec4 t, out float scale, out vec3 a, out vec3 b, out vec3 c) {\n	scale = uintBitsToFloat(t.x);\n	a = unpack111011s(t.y);\n	b = unpack111011s(t.z);\n	c = unpack111011s(t.w);\n}\nvoid fetch(in uvec4 t, out vec3 a, out vec3 b, out vec3 c, out vec3 d) {\n	a = unpack111011s(t.x);\n	b = unpack111011s(t.y);\n	c = unpack111011s(t.z);\n	d = unpack111011s(t.w);\n}\nvoid fetch(in uint t, out vec3 a) {\n	a = unpack111011s(t);\n}\n#if SH_BANDS == 1\n	uniform highp usampler2D splatSH_1to3;\n	void readSHData(in SplatSource source, out vec3 sh[3], out float scale) {\n		fetchScale(texelFetch(splatSH_1to3, source.uv, 0), scale, sh[0], sh[1], sh[2]);\n	}\n#elif SH_BANDS == 2\n	uniform highp usampler2D splatSH_1to3;\n	uniform highp usampler2D splatSH_4to7;\n	uniform highp usampler2D splatSH_8to11;\n	void readSHData(in SplatSource source, out vec3 sh[8], out float scale) {\n		fetchScale(texelFetch(splatSH_1to3, source.uv, 0), scale, sh[0], sh[1], sh[2]);\n		fetch(texelFetch(splatSH_4to7, source.uv, 0), sh[3], sh[4], sh[5], sh[6]);\n		fetch(texelFetch(splatSH_8to11, source.uv, 0).x, sh[7]);\n	}\n#else\n	uniform highp usampler2D splatSH_1to3;\n	uniform highp usampler2D splatSH_4to7;\n	uniform highp usampler2D splatSH_8to11;\n	uniform highp usampler2D splatSH_12to15;\n	void readSHData(in SplatSource source, out vec3 sh[15], out float scale) {\n		fetchScale(texelFetch(splatSH_1to3, source.uv, 0), scale, sh[0], sh[1], sh[2]);\n		fetch(texelFetch(splatSH_4to7, source.uv, 0), sh[3], sh[4], sh[5], sh[6]);\n		fetch(texelFetch(splatSH_8to11, source.uv, 0), sh[7], sh[8], sh[9], sh[10]);\n		fetch(texelFetch(splatSH_12to15, source.uv, 0), sh[11], sh[12], sh[13], sh[14]);\n	}\n#endif\n#endif\n";

var gsplatSourceVS = "\nattribute vec3 vertex_position;\nattribute uint vertex_id_attrib;\nuniform uint numSplats;\nuniform highp usampler2D splatOrder;\nbool initSource(out SplatSource source) {\n	uint w = uint(textureSize(splatOrder, 0).x);\n	source.order = vertex_id_attrib + uint(vertex_position.z);\n	if (source.order >= numSplats) {\n		return false;\n	}\n	ivec2 orderUV = ivec2(source.order % w, source.order / w);\n	source.id = texelFetch(splatOrder, orderUV, 0).r;\n	source.uv = ivec2(source.id % w, source.id / w);\n	source.cornerUV = vertex_position.xy;\n	return true;\n}\n";

var gsplatVS = '\n#include "gsplatCommonVS"\nvarying mediump vec2 gaussianUV;\nvarying mediump vec4 gaussianColor;\n#ifndef DITHER_NONE\n	varying float id;\n#endif\nmediump vec4 discardVec = vec4(0.0, 0.0, 2.0, 1.0);\nvoid main(void) {\n	SplatSource source;\n	if (!initSource(source)) {\n		gl_Position = discardVec;\n		return;\n	}\n	vec3 modelCenter = readCenter(source);\n	SplatCenter center;\n	if (!initCenter(modelCenter, center)) {\n		gl_Position = discardVec;\n		return;\n	}\n	SplatCorner corner;\n	if (!initCorner(source, center, corner)) {\n		gl_Position = discardVec;\n		return;\n	}\n	vec4 clr = readColor(source);\n	#if SH_BANDS > 0\n		vec3 dir = normalize(center.view * mat3(center.modelView));\n		clr.xyz += evalSH(source, dir);\n	#endif\n	clipCorner(corner, clr.w);\n	gl_Position = center.proj + vec4(corner.offset, 0, 0);\n	gaussianUV = corner.uv;\n	gaussianColor = vec4(prepareOutputFromGamma(max(clr.xyz, 0.0)), clr.w);\n	#ifndef DITHER_NONE\n		id = float(source.id);\n	#endif\n}\n';

var immediateLinePS$1 = '\n		#include "gammaPS"\n		varying vec4 color;\n		void main(void) {\n			gl_FragColor = vec4(gammaCorrectOutput(decodeGamma(color.rgb)), color.a);\n		}\n';

var immediateLineVS$1 = "\n	attribute vec4 vertex_position;\n	attribute vec4 vertex_color;\n	uniform mat4 matrix_model;\n	uniform mat4 matrix_viewProjection;\n	varying vec4 color;\n	void main(void) {\n		color = vertex_color;\n		gl_Position = matrix_viewProjection * matrix_model * vertex_position;\n	}\n";

var iridescenceDiffractionPS = "\nuniform float material_iridescenceRefractionIndex;\n#ifndef PI\n#define PI 3.14159265\n#endif\nfloat iridescence_iorToFresnel(float transmittedIor, float incidentIor) {\n	return pow((transmittedIor - incidentIor) / (transmittedIor + incidentIor), 2.0);\n}\nvec3 iridescence_iorToFresnel(vec3 transmittedIor, float incidentIor) {\n	return pow((transmittedIor - vec3(incidentIor)) / (transmittedIor + vec3(incidentIor)), vec3(2.0));\n}\nvec3 iridescence_fresnelToIor(vec3 f0) {\n	vec3 sqrtF0 = sqrt(f0);\n	return (vec3(1.0) + sqrtF0) / (vec3(1.0) - sqrtF0);\n}\nvec3 iridescence_sensitivity(float opd, vec3 shift) {\n	float phase = 2.0 * PI * opd * 1.0e-9;\n	const vec3 val = vec3(5.4856e-13, 4.4201e-13, 5.2481e-13);\n	const vec3 pos = vec3(1.6810e+06, 1.7953e+06, 2.2084e+06);\n	const vec3 var = vec3(4.3278e+09, 9.3046e+09, 6.6121e+09);\n	vec3 xyz = val * sqrt(2.0 * PI * var) * cos(pos * phase + shift) * exp(-pow(phase, 2.0) * var);\n	xyz.x += 9.7470e-14 * sqrt(2.0 * PI * 4.5282e+09) * cos(2.2399e+06 * phase + shift[0]) * exp(-4.5282e+09 * pow(phase, 2.0));\n	xyz /= vec3(1.0685e-07);\n	const mat3 XYZ_TO_REC709 = mat3(\n		3.2404542, -0.9692660,  0.0556434,\n	   -1.5371385,  1.8760108, -0.2040259,\n	   -0.4985314,  0.0415560,  1.0572252\n	);\n	return XYZ_TO_REC709 * xyz;\n}\nfloat iridescence_fresnel(float cosTheta, float f0) {\n	float x = clamp(1.0 - cosTheta, 0.0, 1.0);\n	float x2 = x * x;\n	float x5 = x * x2 * x2;\n	return f0 + (1.0 - f0) * x5;\n} \nvec3 iridescence_fresnel(float cosTheta, vec3 f0) {\n	float x = clamp(1.0 - cosTheta, 0.0, 1.0);\n	float x2 = x * x;\n	float x5 = x * x2 * x2; \n	return f0 + (vec3(1.0) - f0) * x5;\n}\nvec3 calcIridescence(float outsideIor, float cosTheta, vec3 base_f0, float iridescenceThickness) {\n	float iridescenceIor = mix(outsideIor, material_iridescenceRefractionIndex, smoothstep(0.0, 0.03, iridescenceThickness));\n	float sinTheta2Sq = pow(outsideIor / iridescenceIor, 2.0) * (1.0 - pow(cosTheta, 2.0));\n	float cosTheta2Sq = 1.0 - sinTheta2Sq;\n	if (cosTheta2Sq < 0.0) {\n		return vec3(1.0);\n	}\n	float cosTheta2 = sqrt(cosTheta2Sq);\n	float r0 = iridescence_iorToFresnel(iridescenceIor, outsideIor);\n	float r12 = iridescence_fresnel(cosTheta, r0);\n	float r21 = r12;\n	float t121 = 1.0 - r12;\n	float phi12 = iridescenceIor < outsideIor ? PI : 0.0;\n	float phi21 = PI - phi12;\n	vec3 baseIor = iridescence_fresnelToIor(base_f0 + vec3(0.0001));\n	vec3 r1 = iridescence_iorToFresnel(baseIor, iridescenceIor);\n	vec3 r23 = iridescence_fresnel(cosTheta2, r1);\n	vec3 phi23 = vec3(0.0);\n	if (baseIor[0] < iridescenceIor) phi23[0] = PI;\n	if (baseIor[1] < iridescenceIor) phi23[1] = PI;\n	if (baseIor[2] < iridescenceIor) phi23[2] = PI;\n	float opd = 2.0 * iridescenceIor * iridescenceThickness * cosTheta2;\n	vec3 phi = vec3(phi21) + phi23; \n	vec3 r123Sq = clamp(r12 * r23, 1e-5, 0.9999);\n	vec3 r123 = sqrt(r123Sq);\n	vec3 rs = pow(t121, 2.0) * r23 / (1.0 - r123Sq);\n	vec3 c0 = r12 + rs;\n	vec3 i = c0;\n	vec3 cm = rs - t121;\n	for (int m = 1; m <= 2; m++) {\n		cm *= r123;\n		vec3 sm = 2.0 * iridescence_sensitivity(float(m) * opd, float(m) * phi);\n		i += cm * sm;\n	}\n	return max(i, vec3(0.0));\n}\nvec3 getIridescence(float cosTheta, vec3 specularity, float iridescenceThickness) {\n	return calcIridescence(1.0, cosTheta, specularity, iridescenceThickness);\n}\n";

var iridescencePS = "\n#ifdef MAPFLOAT\nuniform float material_iridescence;\n#endif\nvoid getIridescence() {\n	float iridescence = 1.0;\n	#ifdef MAPFLOAT\n	iridescence *= material_iridescence;\n	#endif\n	#ifdef MAPTEXTURE\n	iridescence *= texture2DBias($SAMPLER, $UV, textureBias).$CH;\n	#endif\n	dIridescence = iridescence; \n}\n";

var iridescenceThicknessPS = "\nuniform float material_iridescenceThicknessMax;\n#ifdef MAPTEXTURE\nuniform float material_iridescenceThicknessMin;\n#endif\nvoid getIridescenceThickness() {\n	#ifdef MAPTEXTURE\n	float blend = texture2DBias($SAMPLER, $UV, textureBias).$CH;\n	float iridescenceThickness = mix(material_iridescenceThicknessMin, material_iridescenceThicknessMax, blend);\n	#else\n	float iridescenceThickness = material_iridescenceThicknessMax;\n	#endif\n	dIridescenceThickness = iridescenceThickness; \n}\n";

var iorPS = "\n#ifdef MAPFLOAT\nuniform float material_refractionIndex;\n#endif\nvoid getIor() {\n#ifdef MAPFLOAT\n	dIor = material_refractionIndex;\n#else\n	dIor = 1.0 / 1.5;\n#endif\n}\n";

var lightDeclarationPS = "\n#if defined(LIGHT{i})\n	uniform vec3 light{i}_color;\n	#if LIGHT{i}TYPE == DIRECTIONAL\n		uniform vec3 light{i}_direction;\n	#else\n		#define LIT_CODE_LIGHTS_POINT\n		uniform vec3 light{i}_position;\n		uniform float light{i}_radius;\n		#if LIGHT{i}TYPE == SPOT\n			#define LIT_CODE_LIGHTS_SPOT\n			uniform vec3 light{i}_direction;\n			uniform float light{i}_innerConeAngle;\n			uniform float light{i}_outerConeAngle;\n		#endif\n	#endif\n	#if LIGHT{i}SHAPE != PUNCTUAL\n		#define LIT_CODE_FALLOFF_SQUARED\n		#if LIGHT{i}TYPE == DIRECTIONAL\n			uniform vec3 light{i}_position;\n		#endif\n		uniform vec3 light{i}_halfWidth;\n		uniform vec3 light{i}_halfHeight;\n	#else\n		#if LIGHT{i}FALLOFF == LINEAR\n			#define LIT_CODE_FALLOFF_LINEAR\n		#endif\n		#if LIGHT{i}FALLOFF == INVERSESQUARED\n			#define LIT_CODE_FALLOFF_SQUARED\n		#endif\n	#endif\n	#if defined(LIGHT{i}CASTSHADOW)\n		uniform mat4 light{i}_shadowMatrix;\n		uniform float light{i}_shadowIntensity;\n		uniform vec4 light{i}_shadowParams;\n		#if LIGHT{i}SHADOWTYPE == PCSS_32F\n			uniform float light{i}_shadowSearchArea;\n			uniform vec4 light{i}_cameraParams;\n			#if LIGHT{i}TYPE == DIRECTIONAL\n				uniform vec4 light{i}_softShadowParams;\n			#endif\n		#endif\n		#if LIGHT{i}TYPE == DIRECTIONAL\n			uniform mat4 light{i}_shadowMatrixPalette[4];\n			uniform vec4 light{i}_shadowCascadeDistances;\n			uniform int light{i}_shadowCascadeCount;\n			uniform float light{i}_shadowCascadeBlend;\n		#endif\n		#if LIGHT{i}TYPE == OMNI\n			#if defined(LIGHT{i}SHADOW_PCF)\n				uniform samplerCubeShadow light{i}_shadowMap;\n			#else\n				uniform samplerCube light{i}_shadowMap;\n			#endif\n		#else\n			#if defined(LIGHT{i}SHADOW_PCF)\n				uniform sampler2DShadow light{i}_shadowMap;\n			#else\n				uniform sampler2D light{i}_shadowMap;\n			#endif\n		#endif\n	#endif\n	#if defined(LIGHT{i}COOKIE)\n		#define LIT_CODE_COOKIE\n		#if LIGHT{i}TYPE == OMNI\n			uniform samplerCube light{i}_cookie;\n			uniform float light{i}_cookieIntensity;\n			#if !defined(LIGHT{i}CASTSHADOW)\n				uniform mat4 light{i}_shadowMatrix;\n			#endif\n		#endif\n		#if LIGHT{i}TYPE == SPOT\n			uniform sampler2D light{i}_cookie;\n			uniform float light{i}_cookieIntensity;\n			#if !defined(LIGHT{i}CASTSHADOW)\n				uniform mat4 light{i}_shadowMatrix;\n			#endif\n			#if defined(LIGHT{i}COOKIE_TRANSFORM)\n				uniform vec4 light{i}_cookieMatrix;\n				uniform vec2 light{i}_cookieOffset;\n			#endif\n		#endif\n	#endif\n#endif\n";

var lightDiffuseLambertPS = "\nfloat getLightDiffuse(vec3 worldNormal, vec3 viewDir, vec3 lightDirNorm) {\n	return max(dot(worldNormal, -lightDirNorm), 0.0);\n}\n";

var lightDirPointPS = "\nvoid evalOmniLight(vec3 lightPosW, out vec3 lightDirW, out vec3 lightDirNormW) {\n	lightDirW = vPositionW - lightPosW;\n	lightDirNormW = normalize(lightDirW);\n}\n";

var lightEvaluationPS = "\n#if defined(LIGHT{i})\n	evaluateLight{i}();\n#endif\n";

var lightFunctionLightPS = "\n#if defined(LIGHT{i})\nvoid evaluateLight{i}() {\n	vec3 lightColor = light{i}_color;\n	#if LIGHT{i}TYPE == DIRECTIONAL && !defined(LIT_SHADOW_CATCHER)\n		if (all(equal(lightColor, vec3(0.0)))) {\n			return;\n		}\n	#endif\n	#if LIGHT{i}TYPE == DIRECTIONAL\n		dLightDirNormW = light{i}_direction;\n		dAtten = 1.0;\n	#else\n		\n		vec3 lightDirW;\n		evalOmniLight(light{i}_position, lightDirW, dLightDirNormW);\n		#if defined(LIGHT{i}COOKIE)\n			#if LIGHT{i}TYPE == SPOT\n				#ifdef LIGHT{i}COOKIE_FALLOFF\n					#ifdef LIGHT{i}COOKIE_TRANSFORM\n						vec3 cookieAttenuation = getCookie2DXform(light{i}_cookie, light{i}_shadowMatrix, light{i}_cookieIntensity, light{i}_cookieMatrix, light{i}_cookieOffset).{LIGHT{i}COOKIE_CHANNEL};\n					#else\n						vec3 cookieAttenuation = getCookie2D(light{i}_cookie, light{i}_shadowMatrix, light{i}_cookieIntensity).{LIGHT{i}COOKIE_CHANNEL};\n					#endif\n				#else\n					#ifdef LIGHT{i}COOKIE_TRANSFORM\n						vec3 cookieAttenuation = getCookie2DClipXform(light{i}_cookie, light{i}_shadowMatrix, light{i}_cookieIntensity, light{i}_cookieMatrix, light{i}_cookieOffset).{LIGHT{i}COOKIE_CHANNEL};\n					#else\n						vec3 cookieAttenuation = getCookie2DClip(light{i}_cookie, light{i}_shadowMatrix, light{i}_cookieIntensity).{LIGHT{i}COOKIE_CHANNEL};\n					#endif\n				#endif\n			#endif\n			#if LIGHT{i}TYPE == OMNI\n				vec3 cookieAttenuation = getCookieCube(light{i}_cookie, light{i}_shadowMatrix, light{i}_cookieIntensity).{LIGHT{i}COOKIE_CHANNEL};\n			#endif\n			lightColor *= cookieAttenuation;\n		#endif\n		#if LIGHT{i}SHAPE == PUNCTUAL\n			#if LIGHT{i}FALLOFF == LINEAR\n				dAtten = getFalloffLinear(light{i}_radius, lightDirW);\n			#else\n				dAtten = getFalloffInvSquared(light{i}_radius, lightDirW);\n			#endif\n		#else\n			dAtten = getFalloffWindow(light{i}_radius, lightDirW);\n		#endif\n		#if LIGHT{i}TYPE == SPOT\n			#if !defined(LIGHT{i}COOKIE) || defined(LIGHT{i}COOKIE_FALLOFF)\n				dAtten *= getSpotEffect(light{i}_direction, light{i}_innerConeAngle, light{i}_outerConeAngle, dLightDirNormW);\n			#endif\n		#endif\n	#endif\n	if (dAtten < 0.00001) {\n		return;\n	}\n	#if LIGHT{i}SHAPE != PUNCTUAL\n		#if LIGHT{i}SHAPE == RECT\n			calcRectLightValues(light{i}_position, light{i}_halfWidth, light{i}_halfHeight);\n		#elif LIGHT{i}SHAPE == DISK\n			calcDiskLightValues(light{i}_position, light{i}_halfWidth, light{i}_halfHeight);\n		#elif LIGHT{i}SHAPE == SPHERE\n			calcSphereLightValues(light{i}_position, light{i}_halfWidth, light{i}_halfHeight);\n		#endif\n	#endif\n	#if LIGHT{i}SHAPE != PUNCTUAL\n		#if LIGHT{i}TYPE == DIRECTIONAL\n			float attenDiffuse = getLightDiffuse(litArgs_worldNormal, dViewDirW, dLightDirNormW);\n		#else\n			#if LIGHT{i}SHAPE == RECT\n				float attenDiffuse = getRectLightDiffuse(litArgs_worldNormal, dViewDirW, lightDirW, dLightDirNormW) * 16.0;\n			#elif LIGHT{i}SHAPE == DISK\n				float attenDiffuse = getDiskLightDiffuse(litArgs_worldNormal, dViewDirW, lightDirW, dLightDirNormW) * 16.0;\n			#elif LIGHT{i}SHAPE == SPHERE\n				float attenDiffuse = getSphereLightDiffuse(litArgs_worldNormal, dViewDirW, lightDirW, dLightDirNormW) * 16.0;\n			#endif\n		#endif\n	#else\n		dAtten *= getLightDiffuse(litArgs_worldNormal, vec3(0.0), dLightDirNormW);\n	#endif\n	#ifdef LIGHT{i}CASTSHADOW\n		#if LIGHT{i}TYPE == DIRECTIONAL\n			float shadow = getShadow{i}(vec3(0.0));\n		#else\n			float shadow = getShadow{i}(lightDirW);\n		#endif\n		shadow = mix(1.0, shadow, light{i}_shadowIntensity);\n		dAtten *= shadow;\n		#if defined(LIT_SHADOW_CATCHER) && LIGHT{i}TYPE == DIRECTIONAL\n			dShadowCatcher *= shadow;\n		#endif			\n	#endif\n	#if LIGHT{i}SHAPE != PUNCTUAL\n		#ifdef LIT_SPECULAR\n			dDiffuseLight += ((attenDiffuse * dAtten) * lightColor) * (1.0 - dLTCSpecFres);\n		#else\n			dDiffuseLight += (attenDiffuse * dAtten) * lightColor;\n		#endif						\n	#else\n		#if defined(AREA_LIGHTS) && defined(LIT_SPECULAR)\n			dDiffuseLight += (dAtten * lightColor) * (1.0 - litArgs_specularity);\n		#else\n			dDiffuseLight += dAtten * lightColor;\n		#endif\n	#endif\n	#ifdef LIGHT{i}AFFECT_SPECULARITY\n		#if LIGHT{i}SHAPE != PUNCTUAL\n			#ifdef LIT_CLEARCOAT\n				#if LIGHT{i}SHAPE == RECT\n					ccSpecularLight += ccLTCSpecFres * getRectLightSpecular(litArgs_clearcoat_worldNormal, dViewDirW) * dAtten * lightColor;\n				#elif LIGHT{i}SHAPE == DISK\n					ccSpecularLight += ccLTCSpecFres * getDiskLightSpecular(litArgs_clearcoat_worldNormal, dViewDirW) * dAtten * lightColor;\n				#elif LIGHT{i}SHAPE == SPHERE\n					ccSpecularLight += ccLTCSpecFres * getSphereLightSpecular(litArgs_clearcoat_worldNormal, dViewDirW) * dAtten * lightColor;\n				#endif\n			#endif\n			#ifdef LIT_SPECULAR\n				#if LIGHT{i}SHAPE == RECT\n					dSpecularLight += dLTCSpecFres * getRectLightSpecular(litArgs_worldNormal, dViewDirW) * dAtten * lightColor;\n				#elif LIGHT{i}SHAPE == DISK\n					dSpecularLight += dLTCSpecFres * getDiskLightSpecular(litArgs_worldNormal, dViewDirW) * dAtten * lightColor;\n				#elif LIGHT{i}SHAPE == SPHERE\n					dSpecularLight += dLTCSpecFres * getSphereLightSpecular(litArgs_worldNormal, dViewDirW) * dAtten * lightColor;\n				#endif\n			#endif\n		#else\n			#if LIGHT{i}TYPE == DIRECTIONAL && LIT_FRESNEL_MODEL != NONE\n				#define LIGHT{i}FRESNEL\n			#endif\n			#ifdef LIT_SPECULAR\n				vec3 halfDirW = normalize(-dLightDirNormW + dViewDirW);\n			#endif\n			#ifdef LIT_CLEARCOAT\n				vec3 lightspecularCC = getLightSpecular(halfDirW, ccReflDirW, litArgs_clearcoat_worldNormal, dViewDirW, dLightDirNormW, litArgs_clearcoat_gloss, dTBN) * dAtten * lightColor;\n				#ifdef LIGHT{i}FRESNEL\n					lightspecularCC *= getFresnelCC(dot(dViewDirW, halfDirW));\n				#endif\n				ccSpecularLight += lightspecularCC;\n			#endif\n			#ifdef LIT_SHEEN\n				sSpecularLight += getLightSpecularSheen(halfDirW, litArgs_worldNormal, dViewDirW, dLightDirNormW, litArgs_sheen_gloss) * dAtten * lightColor;\n			#endif\n			#ifdef LIT_SPECULAR\n				vec3 lightSpecular = getLightSpecular(halfDirW, dReflDirW, litArgs_worldNormal, dViewDirW, dLightDirNormW, litArgs_gloss, dTBN) * dAtten * lightColor;\n				#ifdef LIGHT{i}FRESNEL\n					#if defined(LIT_IRIDESCENCE)\n						lightSpecular *= getFresnel(dot(dViewDirW, halfDirW), litArgs_gloss, litArgs_specularity, iridescenceFresnel, litArgs_iridescence_intensity);\n					#else\n						lightSpecular *= getFresnel(dot(dViewDirW, halfDirW), litArgs_gloss, litArgs_specularity);\n					#endif\n				#else\n					lightSpecular *= litArgs_specularity;\n				#endif\n				\n				dSpecularLight += lightSpecular;\n			#endif\n		#endif\n	#endif\n}\n#endif\n";

var lightFunctionShadowPS = "\n#ifdef LIGHT{i}CASTSHADOW\n	vec3 getShadowSampleCoord{i}(mat4 shadowTransform, vec4 shadowParams, vec3 worldPosition, vec3 lightPos, inout vec3 lightDir, vec3 lightDirNorm, vec3 normal) {\n		vec3 surfacePosition = worldPosition;\n		#ifdef LIGHT{i}_SHADOW_SAMPLE_POINT\n			#ifdef LIGHT{i}_SHADOW_SAMPLE_NORMAL_OFFSET\n				float distScale = length(lightDir);\n				surfacePosition = surfacePosition + normal * shadowParams.y * clamp(1.0 - dot(normal, -lightDirNorm), 0.0, 1.0) * distScale;\n				lightDir = surfacePosition - lightPos;\n				return lightDir;\n			#endif\n		#else\n			#ifdef LIGHT{i}_SHADOW_SAMPLE_SOURCE_ZBUFFER\n				#ifdef LIGHT{i}_SHADOW_SAMPLE_NORMAL_OFFSET\n					surfacePosition = surfacePosition + normal * shadowParams.y;\n				#endif\n			#else\n				#ifdef LIGHT{i}_SHADOW_SAMPLE_NORMAL_OFFSET\n					#ifdef LIGHT{i}_SHADOW_SAMPLE_ORTHO\n						float distScale = 1.0;\n					#else\n						float distScale = abs(dot(vPositionW - lightPos, lightDirNorm));\n					#endif\n					surfacePosition = surfacePosition + normal * shadowParams.y * clamp(1.0 - dot(normal, -lightDirNorm), 0.0, 1.0) * distScale;\n				#endif\n			#endif\n			vec4 positionInShadowSpace = shadowTransform * vec4(surfacePosition, 1.0);\n			#ifdef LIGHT{i}_SHADOW_SAMPLE_ORTHO\n				positionInShadowSpace.z = saturate(positionInShadowSpace.z) - 0.0001;\n			#else\n				#ifdef LIGHT{i}_SHADOW_SAMPLE_SOURCE_ZBUFFER\n					positionInShadowSpace.xyz /= positionInShadowSpace.w;\n				#else\n					positionInShadowSpace.xy /= positionInShadowSpace.w;\n					positionInShadowSpace.z = length(lightDir) * shadowParams.w;\n				#endif\n			#endif\n			surfacePosition = positionInShadowSpace.xyz;\n		#endif\n		return surfacePosition;\n	}\n	float getShadow{i}(vec3 lightDirW) {\n		#ifdef LIGHT{i}_SHADOW_CASCADES\n			int cascadeIndex = getShadowCascadeIndex(light{i}_shadowCascadeDistances, light{i}_shadowCascadeCount);\n			#ifdef LIGHT{i}_SHADOW_CASCADE_BLEND\n				cascadeIndex = ditherShadowCascadeIndex(cascadeIndex, light{i}_shadowCascadeDistances, light{i}_shadowCascadeCount, light{i}_shadowCascadeBlend);\n			#endif\n			mat4 shadowMatrix = light{i}_shadowMatrixPalette[cascadeIndex];\n		#else\n			mat4 shadowMatrix = light{i}_shadowMatrix;\n		#endif\n		#if LIGHT{i}TYPE == DIRECTIONAL\n			vec3 shadowCoord = getShadowSampleCoord{i}(shadowMatrix, light{i}_shadowParams, vPositionW, vec3(0.0), lightDirW, dLightDirNormW, dVertexNormalW);\n		#else\n			vec3 shadowCoord = getShadowSampleCoord{i}(shadowMatrix, light{i}_shadowParams, vPositionW, light{i}_position, lightDirW, dLightDirNormW, dVertexNormalW);\n		#endif\n		#if LIGHT{i}TYPE == DIRECTIONAL\n			shadowCoord = fadeShadow(shadowCoord, light{i}_shadowCascadeDistances);\n		#endif\n		#if LIGHT{i}TYPE == DIRECTIONAL\n			#if LIGHT{i}SHADOWTYPE == VSM_16F\n				return getShadowVSM16(SHADOWMAP_PASS(light{i}_shadowMap), shadowCoord, light{i}_shadowParams, 5.54);\n			#endif\n			#if LIGHT{i}SHADOWTYPE == VSM_32F\n				return getShadowVSM32(SHADOWMAP_PASS(light{i}_shadowMap), shadowCoord, light{i}_shadowParams, 15.0);\n			#endif\n			#if LIGHT{i}SHADOWTYPE == PCSS_32F\n				#if LIGHT{i}SHAPE != PUNCTUAL\n					vec2 shadowSearchArea = vec2(length(light{i}_halfWidth), length(light{i}_halfHeight)) * light{i}_shadowSearchArea;\n					return getShadowPCSS(SHADOWMAP_PASS(light{i}_shadowMap), shadowCoord, light{i}_shadowParams, light{i}_cameraParams, shadowSearchArea, lightDirW);\n				#else\n					return getShadowPCSS(SHADOWMAP_PASS(light{i}_shadowMap), shadowCoord, light{i}_shadowParams, light{i}_cameraParams, light{i}_softShadowParams, lightDirW);\n				#endif\n			#endif\n			#if LIGHT{i}SHADOWTYPE == PCF1_16F || LIGHT{i}SHADOWTYPE == PCF1_32F\n				return getShadowPCF1x1(SHADOWMAP_PASS(light{i}_shadowMap), shadowCoord, light{i}_shadowParams);\n			#endif\n			#if LIGHT{i}SHADOWTYPE == PCF3_16F || LIGHT{i}SHADOWTYPE == PCF3_32F\n				return getShadowPCF3x3(SHADOWMAP_PASS(light{i}_shadowMap), shadowCoord, light{i}_shadowParams);\n			#endif\n			#if LIGHT{i}SHADOWTYPE == PCF5_16F || LIGHT{i}SHADOWTYPE == PCF5_32F\n				return getShadowPCF5x5(SHADOWMAP_PASS(light{i}_shadowMap), shadowCoord, light{i}_shadowParams);\n			#endif\n		#endif\n		#if LIGHT{i}TYPE == SPOT\n			#if LIGHT{i}SHADOWTYPE == VSM_16F\n				return getShadowSpotVSM16(SHADOWMAP_PASS(light{i}_shadowMap), shadowCoord, light{i}_shadowParams, 5.54, lightDirW);\n			#endif\n			#if LIGHT{i}SHADOWTYPE == VSM_32F\n				return getShadowSpotVSM32(SHADOWMAP_PASS(light{i}_shadowMap), shadowCoord, light{i}_shadowParams, 15.0, lightDirW);\n			#endif\n			#if LIGHT{i}SHADOWTYPE == PCSS_32F\n				#if LIGHT{i}SHAPE != PUNCTUAL\n					vec2 shadowSearchArea = vec2(length(light{i}_halfWidth), length(light{i}_halfHeight)) * light{i}_shadowSearchArea;\n				#else\n					vec2 shadowSearchArea = vec2(light{i}_shadowSearchArea);\n				#endif\n				return getShadowSpotPCSS(SHADOWMAP_PASS(light{i}_shadowMap), shadowCoord, light{i}_shadowParams, light{i}_cameraParams, shadowSearchArea, lightDirW);\n			#endif\n			#if LIGHT{i}SHADOWTYPE == PCF1_16F || LIGHT{i}SHADOWTYPE == PCF1_32F\n				return getShadowSpotPCF1x1(SHADOWMAP_PASS(light{i}_shadowMap), shadowCoord, light{i}_shadowParams);\n			#endif\n			#if LIGHT{i}SHADOWTYPE == PCF3_16F || LIGHT{i}SHADOWTYPE == PCF3_32F\n				return getShadowSpotPCF3x3(SHADOWMAP_PASS(light{i}_shadowMap), shadowCoord, light{i}_shadowParams);\n			#endif\n			#if LIGHT{i}SHADOWTYPE == PCF5_16F || LIGHT{i}SHADOWTYPE == PCF5_32F\n				return getShadowSpotPCF5x5(SHADOWMAP_PASS(light{i}_shadowMap), shadowCoord, light{i}_shadowParams);\n			#endif\n		#endif\n		#if LIGHT{i}TYPE == OMNI\n			#if LIGHT{i}SHADOWTYPE == PCSS_32F\n				#if LIGHT{i}SHAPE != PUNCTUAL\n					vec2 shadowSearchArea = vec2(length(light{i}_halfWidth), length(light{i}_halfHeight)) * light{i}_shadowSearchArea;\n				#else\n					vec2 shadowSearchArea = vec2(light{i}_shadowSearchArea);\n				#endif\n				return getShadowOmniPCSS(SHADOWMAP_PASS(light{i}_shadowMap), shadowCoord, light{i}_shadowParams, light{i}_cameraParams, shadowSearchArea, lightDirW);\n			#endif\n			#if LIGHT{i}SHADOWTYPE == PCF1_16F || LIGHT{i}SHADOWTYPE == PCF1_32F\n				return getShadowOmniPCF1x1(SHADOWMAP_PASS(light{i}_shadowMap), shadowCoord, light{i}_shadowParams, lightDirW);\n			#endif\n			#if LIGHT{i}SHADOWTYPE == PCF3_16F || LIGHT{i}SHADOWTYPE == PCF3_32F\n				return getShadowOmniPCF3x3(SHADOWMAP_PASS(light{i}_shadowMap), shadowCoord, light{i}_shadowParams, lightDirW);\n			#endif\n		#endif\n	}\n#endif\n";

var lightingPS = '\n#ifdef LIT_CLUSTERED_LIGHTS\n	#define LIT_CODE_FALLOFF_LINEAR\n	#define LIT_CODE_FALLOFF_SQUARED\n	#define LIT_CODE_LIGHTS_POINT\n	#define LIT_CODE_LIGHTS_SPOT\n#endif\n#ifdef AREA_LIGHTS\n	uniform highp sampler2D areaLightsLutTex1;\n	uniform highp sampler2D areaLightsLutTex2;\n#endif\n#ifdef LIT_LIGHTING\n	#include "lightDiffuseLambertPS"\n	#if defined(AREA_LIGHTS) || defined(LIT_CLUSTERED_AREA_LIGHTS)\n		#include "ltcPS"\n	#endif\n#endif\n#ifdef SHADOW_DIRECTIONAL\n	#include "shadowCascadesPS"\n#endif\n#if defined(SHADOW_KIND_PCF1)\n	#include "shadowPCF1PS"\n#endif\n#if defined(SHADOW_KIND_PCF3)\n	#include "shadowPCF3PS"\n#endif\n#if defined(SHADOW_KIND_PCF5)\n	#include "shadowPCF5PS"\n#endif\n#if defined(SHADOW_KIND_PCSS)\n	#include "linearizeDepthPS"\n	#include "shadowPCSSPS"\n	#include "shadowSoftPS"\n#endif\n#if defined(SHADOW_KIND_VSM)\n	#include "shadowEVSMPS"\n#endif\n#ifdef LIT_CODE_FALLOFF_LINEAR\n	#include "falloffLinearPS"\n#endif\n#ifdef LIT_CODE_FALLOFF_SQUARED\n	#include "falloffInvSquaredPS"\n#endif\n#ifdef LIT_CODE_LIGHTS_POINT\n	#include "lightDirPointPS"\n#endif\n#ifdef LIT_CODE_LIGHTS_SPOT\n	#include "spotPS"\n#endif\n#ifdef LIT_CODE_COOKIE\n	#include "cookiePS"\n#endif\n#ifdef LIT_CLUSTERED_LIGHTS\n	#include "lightBufferDefinesPS"\n	#include "clusteredLightUtilsPS"\n	#ifdef CLUSTER_COOKIES\n		#include "clusteredLightCookiesPS"\n	#endif\n	#ifdef CLUSTER_SHADOWS\n		#include "clusteredLightShadowsPS"\n	#endif\n	#include "floatUnpackingPS"\n	#include "clusteredLightPS"\n#endif\n#include "lightFunctionShadowPS, LIGHT_COUNT"\n#include "lightFunctionLightPS, LIGHT_COUNT"\n';

var lightmapAddPS = "\nvoid addLightMap(\n	vec3 lightmap, \n	vec3 dir, \n	vec3 worldNormal, \n	vec3 viewDir, \n	vec3 reflectionDir, \n	float gloss, \n	vec3 specularity, \n	vec3 vertexNormal, \n	mat3 tbn\n#if defined(LIT_IRIDESCENCE)\n	vec3 iridescenceFresnel, \n	float iridescenceIntensity\n#endif\n) {\n	#if defined(LIT_SPECULAR) && defined(LIT_DIR_LIGHTMAP)\n		if (dot(dir, dir) < 0.0001) {\n				dDiffuseLight += lightmap;\n		} else {\n			float vlight = saturate(dot(dir, -vertexNormal));\n			float flight = saturate(dot(dir, -worldNormal));\n			float nlight = (flight / max(vlight, 0.01)) * 0.5;\n			dDiffuseLight += lightmap * nlight * 2.0;\n			vec3 halfDir = normalize(-dir + viewDir);\n			vec3 specularLight = lightmap * getLightSpecular(halfDir, reflectionDir, worldNormal, viewDir, dir, gloss, tbn);\n			#ifdef LIT_SPECULAR_FRESNEL\n				specularLight *= \n					getFresnel(dot(viewDir, halfDir), \n					gloss, \n					specularity\n				#if defined(LIT_IRIDESCENCE)\n					, iridescenceFresnel,\n					iridescenceIntensity\n				#endif\n					);\n			#endif\n			dSpecularLight += specularLight;\n		}\n	#else\n		dDiffuseLight += lightmap;\n	#endif\n}\n";

var lightmapDirPS = "\nuniform sampler2D texture_lightMap;\nuniform sampler2D texture_dirLightMap;\nvoid getLightMap() {\n	dLightmap = $DECODE(texture2DBias(texture_lightMap, $UV, textureBias)).$CH;\n	vec3 dir = texture2DBias(texture_dirLightMap, $UV, textureBias).xyz * 2.0 - 1.0;\n	float dirDot = dot(dir, dir);\n	dLightmapDir = (dirDot > 0.001) ? dir / sqrt(dirDot) : vec3(0.0);\n}\n";

var lightmapSinglePS = "\nvoid getLightMap() {\n	dLightmap = vec3(1.0);\n	#ifdef MAPTEXTURE\n	dLightmap *= $DECODE(texture2DBias($SAMPLER, $UV, textureBias)).$CH;\n	#endif\n	#ifdef MAPVERTEX\n	dLightmap *= saturate(vVertexColor.$VC);\n	#endif\n}\n";

var lightSpecularAnisoGGXPS = "\nfloat calcLightSpecular(float gloss, vec3 worldNormal, vec3 viewDir, vec3 h, vec3 lightDirNorm, mat3 tbn) {\n	float PI = 3.141592653589793;\n	float roughness = max((1.0 - gloss) * (1.0 - gloss), 0.001);\n	float anisotropy = material_anisotropy * roughness;\n \n	float at = max((roughness + anisotropy), roughness / 4.0);\n	float ab = max((roughness - anisotropy), roughness / 4.0);\n	float NoH = dot(worldNormal, h);\n	float ToH = dot(tbn[0], h);\n	float BoH = dot(tbn[1], h);\n	float a2 = at * ab;\n	vec3 v = vec3(ab * ToH, at * BoH, a2 * NoH);\n	float v2 = dot(v, v);\n	float w2 = a2 / v2;\n	float D = a2 * w2 * w2 * (1.0 / PI);\n	float ToV = dot(tbn[0], viewDir);\n	float BoV = dot(tbn[1], viewDir);\n	float ToL = dot(tbn[0], -lightDirNorm);\n	float BoL = dot(tbn[1], -lightDirNorm);\n	float NoV = dot(worldNormal, viewDir);\n	float NoL = dot(worldNormal, -lightDirNorm);\n	float lambdaV = NoL * length(vec3(at * ToV, ab * BoV, NoV));\n	float lambdaL = NoV * length(vec3(at * ToL, ab * BoL, NoL));\n	float G = 0.5 / (lambdaV + lambdaL);\n	return D * G;\n}\nfloat getLightSpecular(vec3 h, vec3 reflDir, vec3 worldNormal, vec3 viewDir, vec3 lightDirNorm, float gloss, mat3 tbn) {\n	return calcLightSpecular(gloss, worldNormal, viewDir, h, lightDirNorm, tbn);\n}\n";

var lightSpecularBlinnPS = "\nfloat calcLightSpecular(float gloss, vec3 worldNormal, vec3 h) {\n	float nh = max( dot( h, worldNormal ), 0.0 );\n	float specPow = exp2(gloss * 11.0);\n	specPow = max(specPow, 0.0001);\n	return pow(nh, specPow) * (specPow + 2.0) / 8.0;\n}\nfloat getLightSpecular(vec3 h, vec3 reflDir, vec3 worldNormal, vec3 viewDir, vec3 lightDirNorm, float gloss, mat3 tbn) {\n	return calcLightSpecular(gloss, worldNormal, h);\n}\n";

var lightSheenPS = "\nfloat sheenD(vec3 normal, vec3 h, float roughness) {\n	const float PI = 3.141592653589793;\n	float invR = 1.0 / (roughness * roughness);\n	float cos2h = max(dot(normal, h), 0.0);\n	cos2h *= cos2h;\n	float sin2h = max(1.0 - cos2h, 0.0078125);\n	return (2.0 + invR) * pow(sin2h, invR * 0.5) / (2.0 * PI);\n}\nfloat sheenV(vec3 normal, vec3 viewDir, vec3 light) {\n	float NoV = max(dot(normal, viewDir), 0.000001);\n	float NoL = max(dot(normal, light), 0.000001);\n	return 1.0 / (4.0 * (NoL + NoV - NoL * NoV));\n}\nfloat getLightSpecularSheen(vec3 h, vec3 worldNormal, vec3 viewDir, vec3 lightDirNorm, float sheenGloss) {\n	float D = sheenD(worldNormal, h, sheenGloss);\n	float V = sheenV(worldNormal, viewDir, -lightDirNorm);\n	return D * V;\n}\n";

var linearizeDepthPS = "\n#ifndef LINEARIZE_DEPTH\n#define LINEARIZE_DEPTH\nfloat linearizeDepth(float z, vec4 cameraParams) {\n	if (cameraParams.w == 0.0)\n		return (cameraParams.z * cameraParams.y) / (cameraParams.y + z * (cameraParams.z - cameraParams.y));\n	else\n		return cameraParams.z + z * (cameraParams.y - cameraParams.z);\n}\n#ifndef CAMERAPLANES\n#define CAMERAPLANES\nuniform vec4 camera_params;\n#endif\nfloat linearizeDepth(float z) {\n	return linearizeDepth(z, camera_params);\n}\n#endif\n";

var litForwardBackendPS = '\nvoid evaluateBackend() {\n	#ifdef LIT_SSAO\n		litArgs_ao *= texture2DLod(ssaoTexture, gl_FragCoord.xy * ssaoTextureSizeInv, 0.0).r;\n	#endif\n	#ifdef LIT_NEEDS_NORMAL\n		#ifdef LIT_SPECULAR\n			getReflDir(litArgs_worldNormal, dViewDirW, litArgs_gloss, dTBN);\n		#endif\n		#ifdef LIT_CLEARCOAT\n			ccReflDirW = normalize(-reflect(dViewDirW, litArgs_clearcoat_worldNormal));\n		#endif\n	#endif\n	#ifdef LIT_SPECULAR_OR_REFLECTION\n		#ifdef LIT_METALNESS\n			float f0 = 1.0 / litArgs_ior; f0 = (f0 - 1.0) / (f0 + 1.0); f0 *= f0;\n			litArgs_specularity = getSpecularModulate(litArgs_specularity, litArgs_albedo, litArgs_metalness, f0);\n			litArgs_albedo = getAlbedoModulate(litArgs_albedo, litArgs_metalness);\n		#endif\n		#ifdef LIT_IRIDESCENCE\n			vec3 iridescenceFresnel = getIridescence(saturate(dot(dViewDirW, litArgs_worldNormal)), litArgs_specularity, litArgs_iridescence_thickness);\n		#endif\n	#endif\n	#ifdef LIT_ADD_AMBIENT\n		addAmbient(litArgs_worldNormal);\n		#ifdef LIT_SPECULAR\n			dDiffuseLight = dDiffuseLight * (1.0 - litArgs_specularity);\n		#endif\n		#ifdef LIT_SEPARATE_AMBIENT\n			vec3 dAmbientLight = dDiffuseLight;\n			dDiffuseLight = vec3(0);\n		#endif\n	#endif\n	#ifndef LIT_OLD_AMBIENT\n		dDiffuseLight *= material_ambient;\n	#endif\n	#ifdef LIT_AO\n		#ifndef LIT_OCCLUDE_DIRECT\n			occludeDiffuse(litArgs_ao);\n		#endif\n	#endif\n	#ifdef LIT_LIGHTMAP\n		addLightMap(\n			litArgs_lightmap, \n			litArgs_lightmapDir, \n			litArgs_worldNormal, \n			dViewDirW, \n			dReflDirW, \n			litArgs_gloss, \n			litArgs_specularity, \n			dVertexNormalW,\n			dTBN\n		#if defined(LIT_IRIDESCENCE)\n			, iridescenceFresnel,\n			litArgs_iridescence_intensity\n		#endif\n		);\n	#endif\n	#ifdef LIT_LIGHTING || LIT_REFLECTIONS\n		#ifdef LIT_REFLECTIONS\n			#ifdef LIT_CLEARCOAT\n				addReflectionCC(ccReflDirW, litArgs_clearcoat_gloss);\n			\n				#ifdef LIT_SPECULAR_FRESNEL\n					ccFresnel = getFresnelCC(dot(dViewDirW, litArgs_clearcoat_worldNormal));\n					ccReflection.rgb *= ccFresnel;\n				#else\n					ccFresnel = 0.0;\n				#endif\n			#endif\n			#ifdef LIT_SPECULARITY_FACTOR\n				ccReflection.rgb *= litArgs_specularityFactor;\n			#endif\n			#ifdef LIT_SHEEN\n				addReflectionSheen(litArgs_worldNormal, dViewDirW, litArgs_sheen_gloss);\n			#endif\n			addReflection(dReflDirW, litArgs_gloss);\n			#ifdef LIT_FRESNEL_MODEL\n				dReflection.rgb *= getFresnel(\n					dot(dViewDirW, litArgs_worldNormal), \n					litArgs_gloss, \n					litArgs_specularity\n				#if defined(LIT_IRIDESCENCE)\n					, iridescenceFresnel,\n					litArgs_iridescence_intensity\n				#endif\n					);\n			#else\n				dReflection.rgb *= litArgs_specularity;\n			#endif\n			#ifdef LIT_SPECULARITY_FACTOR\n				dReflection.rgb *= litArgs_specularityFactor;\n			#endif\n		#endif\n		#ifdef AREA_LIGHTS\n			dSpecularLight *= litArgs_specularity;\n			#ifdef LIT_SPECULAR\n				calcLTCLightValues(litArgs_gloss, litArgs_worldNormal, dViewDirW, litArgs_specularity, litArgs_clearcoat_gloss, litArgs_clearcoat_worldNormal, litArgs_clearcoat_specularity);\n			#endif\n		#endif\n		\n		#include "lightEvaluationPS, LIGHT_COUNT"\n		#ifdef LIT_CLUSTERED_LIGHTS\n			addClusteredLights(litArgs_worldNormal, dViewDirW, dReflDirW,\n				#if defined(LIT_CLEARCOAT)\n						ccReflDirW,\n				#endif\n						litArgs_gloss, litArgs_specularity, dVertexNormalW, dTBN, \n				#if defined(LIT_IRIDESCENCE)\n						iridescenceFresnel,\n				#endif\n						litArgs_clearcoat_worldNormal, litArgs_clearcoat_gloss, litArgs_sheen_gloss, litArgs_iridescence_intensity\n			);\n		#endif\n		#ifdef AREA_LIGHTS\n			#ifdef LIT_CLEARCOAT\n				litArgs_clearcoat_specularity = 1.0;\n			#endif\n			#ifdef LIT_SPECULAR\n				litArgs_specularity = vec3(1);\n			#endif\n		#endif\n		#ifdef LIT_REFRACTION\n			addRefraction(\n				litArgs_worldNormal, \n				dViewDirW, \n				litArgs_thickness, \n				litArgs_gloss, \n				litArgs_specularity, \n				litArgs_albedo, \n				litArgs_transmission,\n				litArgs_ior,\n				litArgs_dispersion\n				#if defined(LIT_IRIDESCENCE)\n					, iridescenceFresnel, \n					litArgs_iridescence_intensity\n				#endif\n			);\n		#endif\n	#endif\n	#ifdef LIT_AO\n		#ifdef LIT_OCCLUDE_DIRECT\n			occludeDiffuse(litArgs_ao);\n		#endif\n		#if LIT_OCCLUDE_SPECULAR != NONE\n			occludeSpecular(litArgs_gloss, litArgs_ao, litArgs_worldNormal, dViewDirW);\n		#endif\n	#endif\n	#ifdef LIT_SPECULARITY_FACTOR\n		dSpecularLight *= litArgs_specularityFactor;\n	#endif\n	#if !defined(LIT_OPACITY_FADES_SPECULAR)\n		#if LIT_BLEND_TYPE == NORMAL || LIT_BLEND_TYPE == PREMULTIPLIED\n			float specLum = dot((dSpecularLight + dReflection.rgb * dReflection.a), vec3( 0.2126, 0.7152, 0.0722 ));\n			#ifdef LIT_CLEARCOAT\n				specLum += dot(ccSpecularLight * litArgs_clearcoat_specularity + ccReflection.rgb * litArgs_clearcoat_specularity, vec3( 0.2126, 0.7152, 0.0722 ));\n			#endif\n			litArgs_opacity = clamp(litArgs_opacity + gammaCorrectInput(specLum), 0.0, 1.0);\n		#endif\n		litArgs_opacity *= material_alphaFade;\n	#endif\n	#include "endPS"\n	#include "outputAlphaPS"\n	#ifdef LIT_MSDF\n		gl_FragColor = applyMsdf(gl_FragColor);\n	#endif\n	#include "outputPS"\n	#include "debugOutputPS"\n	#ifdef LIT_SHADOW_CATCHER\n		gl_FragColor.rgb = vec3(dShadowCatcher);\n	#endif\n}\n';

var litForwardDeclarationPS = '\nvec3 sReflection;\nvec3 dVertexNormalW;\nvec3 dTangentW;\nvec3 dBinormalW;\nvec3 dViewDirW;\nvec3 dReflDirW;\nvec3 ccReflDirW;\nvec3 dLightDirNormW;\nfloat dAtten;\nmat3 dTBN;\nvec4 dReflection;\nvec3 dDiffuseLight;\nvec3 dSpecularLight;\nfloat ccFresnel;\nvec3 ccReflection;\nvec3 ccSpecularLight;\nfloat ccSpecularityNoFres;\nvec3 sSpecularLight;\n#ifdef LIT_DISPERSION\n	uniform float material_dispersion;\n#endif\n#ifndef LIT_OPACITY_FADES_SPECULAR\n	uniform float material_alphaFade;\n#endif\n#ifdef LIT_SSAO\n	uniform sampler2D ssaoTexture;\n	uniform vec2 ssaoTextureSizeInv;\n#endif\n#ifdef LIT_SHADOW_CATCHER\n	float dShadowCatcher = 1.0;\n#endif\n#include "lightDeclarationPS, LIGHT_COUNT"\n#ifdef LIT_SPECULAR\n	#if LIT_FRESNEL_MODEL == NONE && !defined(LIT_REFLECTIONS) && !defined(LIT_DIFFUSE_MAP) \n		#define LIT_OLD_AMBIENT\n	#endif\n#endif\n';

var litForwardMainPS = '\nvoid main(void) {\n	dReflection = vec4(0);\n	#ifdef LIT_CLEARCOAT\n		ccSpecularLight = vec3(0);\n		ccReflection = vec3(0);\n	#endif\n	#if LIT_NONE_SLICE_MODE == SLICED\n		#include "startNineSlicedPS"\n	#elif LIT_NONE_SLICE_MODE == TILED\n		#include "startNineSlicedTiledPS"\n	#endif\n	#ifdef LIT_NEEDS_NORMAL\n		dVertexNormalW = normalize(vNormalW);\n		#ifdef LIT_TANGENTS\n			#if defined(LIT_HEIGHTS) || defined(LIT_USE_NORMALS)\n				dTangentW = vTangentW;\n				dBinormalW = vBinormalW;\n			#endif\n		#endif\n		getViewDir();\n		#ifdef LIT_TBN\n			getTBN(dTangentW, dBinormalW, dVertexNormalW);\n			#ifdef LIT_TWO_SIDED_LIGHTING\n				handleTwoSidedLighting();\n			#endif\n		#endif\n	#endif\n	evaluateFrontend();\n	#include "debugProcessFrontendPS"\n	evaluateBackend();\n}\n';

var litForwardPostCodePS = '\n#ifdef LIT_NEEDS_NORMAL\n	#include "cubeMapRotatePS"\n	#include "cubeMapProjectPS"\n	#include "envProcPS"\n#endif\n#if defined(LIT_LIGHTING) && defined(LIT_SPECULAR)\n	#define LIT_SPECULAR_OR_REFLECTION\n#elif defined(LIT_REFLECTIONS)\n	#define LIT_SPECULAR_OR_REFLECTION\n#endif\n#ifdef LIT_SPECULAR_OR_REFLECTION\n	#ifdef LIT_METALNESS\n		#include "metalnessModulatePS"\n	#endif\n	#if LIT_FRESNEL_MODEL == SCHLICK\n		#include "fresnelSchlickPS"\n	#endif\n	#ifdef LIT_IRIDESCENCE\n		#include "iridescenceDiffractionPS"\n	#endif\n#endif\n#ifdef LIT_AO\n	#include "aoDiffuseOccPS"\n	#include "aoSpecOccPS"\n#endif\n#if LIT_REFLECTION_SOURCE == ENVATLASHQ\n	#include "envAtlasPS"\n	#include "reflectionEnvHQPS"\n#elif LIT_REFLECTION_SOURCE == ENVATLAS\n	#include "envAtlasPS"\n	#include "reflectionEnvPS"\n#elif LIT_REFLECTION_SOURCE == CUBEMAP\n	#include "reflectionCubePS"\n#elif LIT_REFLECTION_SOURCE == SPHEREMAP\n	#include "reflectionSpherePS"\n#endif\n#ifdef LIT_REFLECTIONS\n	#ifdef LIT_CLEARCOAT\n		#include "reflectionCCPS"\n	#endif\n	#ifdef LIT_SHEEN\n		#include "reflectionSheenPS"\n	#endif\n#endif\n#ifdef LIT_REFRACTION\n	#if defined(LIT_DYNAMIC_REFRACTION)\n		#include "refractionDynamicPS"\n	#elif defined(LIT_REFLECTIONS)\n		#include "refractionCubePS"\n	#endif\n#endif\n#ifdef LIT_SHEEN\n	#include "lightSheenPS"\n#endif\n#ifdef LIT_GGX_SPECULAR\n	uniform float material_anisotropy;\n#endif\nuniform vec3 material_ambient;\n#ifdef LIT_SPECULAR\n	#ifdef LIT_LIGHTING\n		#ifdef LIT_GGX_SPECULAR\n			#include "lightSpecularAnisoGGXPS"\n		#else\n			#include "lightSpecularBlinnPS"\n		#endif\n	#endif\n#endif\n#include "combinePS"\n#ifdef LIT_LIGHTMAP\n	#include "lightmapAddPS"\n#endif\n#ifdef LIT_ADD_AMBIENT\n	#include "ambientPS"\n#endif\n#ifdef LIT_MSDF\n	#include "msdfPS"\n#endif\n#ifdef LIT_NEEDS_NORMAL\n	#include "viewDirPS"\n	#ifdef LIT_SPECULAR\n		#ifdef LIT_GGX_SPECULAR\n			#include "reflDirAnisoPS"\n		#else\n			#include "reflDirPS"\n		#endif\n	#endif\n#endif\n#include "lightingPS"\n';

var litForwardPreCodePS = '\n#include "basePS"\n#include "sphericalPS"\n#include "decodePS"\n#include "gammaPS"\n#include "tonemappingPS"\n#include "fogPS"\n#if LIT_NONE_SLICE_MODE == SLICED\n	#include "baseNineSlicedPS"\n#elif LIT_NONE_SLICE_MODE == TILED\n	#include "baseNineSlicedTiledPS"\n#endif\n#ifdef LIT_TBN\n	#include "TBNPS"\n	#ifdef LIT_TWO_SIDED_LIGHTING\n		#include "twoSidedLightingPS"\n	#endif\n#endif\n';

var litMainVS = '\n#ifdef VERTEX_COLOR\n	attribute vec4 vertex_color;\n#endif\n#ifdef NINESLICED\n	varying vec2 vMask;\n	varying vec2 vTiledUv;\n	uniform mediump vec4 innerOffset;\n	uniform mediump vec2 outerScale;\n	uniform mediump vec4 atlasRect;\n#endif\nvec3 dPositionW;\nmat4 dModelMatrix;\n#include "transformCoreVS"\n#ifdef UV0\n	attribute vec2 vertex_texCoord0;\n	#include "uv0VS"\n#endif\n#ifdef UV1\n	attribute vec2 vertex_texCoord1;\n	#include "uv1VS"\n#endif\n#ifdef LINEAR_DEPTH\n	#ifndef VIEWMATRIX\n	#define VIEWMATRIX\n		uniform mat4 matrix_view;\n	#endif\n#endif\n#include "transformVS"\n#ifdef NORMALS\n	#include "normalCoreVS"\n	#include "normalVS"\n#endif\n#ifdef TANGENTS\n	attribute vec4 vertex_tangent;\n	#include "tangentBinormalVS"\n#endif\n#include "uvTransformUniformsPS, UV_TRANSFORMS_COUNT"\n#ifdef MSDF\n	#include "msdfVS"\n#endif\nvoid main(void) {\n	gl_Position = getPosition();\n	vPositionW = getWorldPosition();\n	#ifdef NORMALS\n		vNormalW = getNormal();\n	#endif\n	#ifdef TANGENTS\n		vTangentW = getTangent();\n		vBinormalW = getBinormal();\n	#elif defined(GGX_SPECULAR)\n		vObjectSpaceUpW = normalize(dNormalMatrix * vec3(0, 1, 0));\n	#endif\n	#ifdef UV0\n		vec2 uv0 = getUv0();\n		#ifdef UV0_UNMODIFIED\n			vUv0 = uv0;\n		#endif\n	#endif\n	#ifdef UV1\n		vec2 uv1 = getUv1();\n		#ifdef UV1_UNMODIFIED\n			vUv1 = uv1;\n		#endif\n	#endif\n	#include "uvTransformPS, UV_TRANSFORMS_COUNT"\n	#ifdef VERTEX_COLOR\n		vVertexColor = vertex_color;\n	#endif\n	#ifdef LINEAR_DEPTH\n		vLinearDepth = -(matrix_view * vec4(vPositionW, 1.0)).z;\n	#endif\n	#ifdef MSDF\n		unpackMsdfParams();\n	#endif\n}\n';

var litOtherMainPS = '\n#ifdef PICK_PASS\n	#include "pickPS"\n#endif\n#ifdef PREPASS_PASS\n	#include "floatAsUintPS"\n#endif\nvoid main(void) {\n	evaluateFrontend();\n	#ifdef PICK_PASS\n		gl_FragColor = getPickOutput();\n	#endif\n	#ifdef DEPTH_PASS\n		gl_FragColor = vec4(1.0, 1.0, 1.0, 1.0);\n	#endif\n	#ifdef PREPASS_PASS\n		#if defined(CAPS_TEXTURE_FLOAT_RENDERABLE)\n			gl_FragColor = vec4(vLinearDepth, 1.0, 1.0, 1.0);\n		#else\n			gl_FragColor = float2uint(vLinearDepth);\n		#endif\n	#endif\n}\n';

var litShaderArgsPS = "\nvec3 litArgs_albedo;\nfloat litArgs_opacity;\nvec3 litArgs_emission;\nvec3 litArgs_worldNormal;\nfloat litArgs_ao;\nvec3 litArgs_lightmap;\nvec3 litArgs_lightmapDir;\nfloat litArgs_metalness;\nvec3 litArgs_specularity;\nfloat litArgs_specularityFactor;\nfloat litArgs_gloss;\nfloat litArgs_sheen_gloss;\nvec3 litArgs_sheen_specularity;\nfloat litArgs_transmission;\nfloat litArgs_thickness;\nfloat litArgs_ior;\nfloat litArgs_dispersion;\nfloat litArgs_iridescence_intensity;\nfloat litArgs_iridescence_thickness;\nvec3 litArgs_clearcoat_worldNormal;\nfloat litArgs_clearcoat_specularity;\nfloat litArgs_clearcoat_gloss;\n";

var litShadowMainPS = '\n#if LIGHT_TYPE != DIRECTIONAL\n	uniform vec3 view_position;\n	uniform float light_radius;\n#endif\n#if SHADOW_TYPE == PCSS_32F\n	#include "linearizeDepthPS"\n#endif\nvoid main(void) {\n	evaluateFrontend();\n	#ifdef PERSPECTIVE_DEPTH\n		float depth = gl_FragCoord.z;\n		#if SHADOW_TYPE == PCSS_32F\n			#if LIGHT_TYPE != DIRECTIONAL\n				depth = linearizeDepth(depth, camera_params);\n			#endif\n		#endif\n	#else\n		float depth = min(distance(view_position, vPositionW) / light_radius, 0.99999);\n		#define MODIFIED_DEPTH\n	#endif\n	#if SHADOW_TYPE == VSM_16F || SHADOW_TYPE == VSM_32F\n		#if SHADOW_TYPE == VSM_32F\n			float exponent = 15.0;\n		#else\n			float exponent = 5.54;\n		#endif\n		depth = 2.0 * depth - 1.0;\n		depth =  exp(exponent * depth);\n		gl_FragColor = vec4(depth, depth*depth, 1.0, 1.0);\n	#else\n		#if SHADOW_TYPE == PCSS_32F\n			gl_FragColor.r = depth;\n		#else\n			#ifdef MODIFIED_DEPTH\n				gl_FragDepth = depth;\n			#endif\n			gl_FragColor = vec4(1.0);\n		#endif\n	#endif\n}\n';

var ltcPS = "\nmat3 transposeMat3( const in mat3 m ) {\n	mat3 tmp;\n	tmp[ 0 ] = vec3( m[ 0 ].x, m[ 1 ].x, m[ 2 ].x );\n	tmp[ 1 ] = vec3( m[ 0 ].y, m[ 1 ].y, m[ 2 ].y );\n	tmp[ 2 ] = vec3( m[ 0 ].z, m[ 1 ].z, m[ 2 ].z );\n	return tmp;\n}\nvec2 LTC_Uv( const in vec3 N, const in vec3 V, const in float roughness ) {\n	const float LUT_SIZE = 64.0;\n	const float LUT_SCALE = ( LUT_SIZE - 1.0 ) / LUT_SIZE;\n	const float LUT_BIAS = 0.5 / LUT_SIZE;\n	float dotNV = saturate( dot( N, V ) );\n	vec2 uv = vec2( roughness, sqrt( 1.0 - dotNV ) );\n	uv = uv * LUT_SCALE + LUT_BIAS;\n	return uv;\n}\nfloat LTC_ClippedSphereFormFactor( const in vec3 f ) {\n	float l = length( f );\n	return max( ( l * l + f.z ) / ( l + 1.0 ), 0.0 );\n}\nvec3 LTC_EdgeVectorFormFactor( const in vec3 v1, const in vec3 v2 ) {\n	float x = dot( v1, v2 );\n	float y = abs( x );\n	float a = 0.8543985 + ( 0.4965155 + 0.0145206 * y ) * y;\n	float b = 3.4175940 + ( 4.1616724 + y ) * y;\n	float v = a / b;\n	float theta_sintheta = ( x > 0.0 ) ? v : 0.5 * inversesqrt( max( 1.0 - x * x, 1e-7 ) ) - v;\n	return cross( v1, v2 ) * theta_sintheta;\n}\nstruct Coords {\n	vec3 coord0;\n	vec3 coord1;\n	vec3 coord2;\n	vec3 coord3;\n};\nfloat LTC_EvaluateRect( const in vec3 N, const in vec3 V, const in vec3 P, const in mat3 mInv, const in Coords rectCoords) {\n	vec3 v1 = rectCoords.coord1 - rectCoords.coord0;\n	vec3 v2 = rectCoords.coord3 - rectCoords.coord0;\n	\n	vec3 lightNormal = cross( v1, v2 );\n	float factor = sign(-dot( lightNormal, P - rectCoords.coord0 ));\n	vec3 T1, T2;\n	T1 = normalize( V - N * dot( V, N ) );\n	T2 =  factor * cross( N, T1 );\n	mat3 mat = mInv * transposeMat3( mat3( T1, T2, N ) );\n	vec3 coords[ 4 ];\n	coords[ 0 ] = mat * ( rectCoords.coord0 - P );\n	coords[ 1 ] = mat * ( rectCoords.coord1 - P );\n	coords[ 2 ] = mat * ( rectCoords.coord2 - P );\n	coords[ 3 ] = mat * ( rectCoords.coord3 - P );\n	coords[ 0 ] = normalize( coords[ 0 ] );\n	coords[ 1 ] = normalize( coords[ 1 ] );\n	coords[ 2 ] = normalize( coords[ 2 ] );\n	coords[ 3 ] = normalize( coords[ 3 ] );\n	vec3 vectorFormFactor = vec3( 0.0 );\n	vectorFormFactor += LTC_EdgeVectorFormFactor( coords[ 0 ], coords[ 1 ] );\n	vectorFormFactor += LTC_EdgeVectorFormFactor( coords[ 1 ], coords[ 2 ] );\n	vectorFormFactor += LTC_EdgeVectorFormFactor( coords[ 2 ], coords[ 3 ] );\n	vectorFormFactor += LTC_EdgeVectorFormFactor( coords[ 3 ], coords[ 0 ] );\n	float result = LTC_ClippedSphereFormFactor( vectorFormFactor );\n	return result;\n}\nCoords dLTCCoords;\nCoords getLTCLightCoords(vec3 lightPos, vec3 halfWidth, vec3 halfHeight){\n	Coords coords;\n	coords.coord0 = lightPos + halfWidth - halfHeight;\n	coords.coord1 = lightPos - halfWidth - halfHeight;\n	coords.coord2 = lightPos - halfWidth + halfHeight;\n	coords.coord3 = lightPos + halfWidth + halfHeight;\n	return coords;\n}\nfloat dSphereRadius;\nCoords getSphereLightCoords(vec3 lightPos, vec3 halfWidth, vec3 halfHeight){\n	dSphereRadius = max(length(halfWidth), length(halfHeight));\n	vec3 f = reflect(normalize(lightPos - view_position), vNormalW);\n	vec3 w = normalize(cross(f, halfHeight));\n	vec3 h = normalize(cross(f, w));\n	return getLTCLightCoords(lightPos, w * dSphereRadius, h * dSphereRadius);\n}\nvec2 dLTCUV;\n#ifdef LIT_CLEARCOAT\nvec2 ccLTCUV;\n#endif\nvec2 getLTCLightUV(float gloss, vec3 worldNormal, vec3 viewDir)\n{\n	float roughness = max((1.0 - gloss) * (1.0 - gloss), 0.001);\n	return LTC_Uv( worldNormal, viewDir, roughness );\n}\nvec3 dLTCSpecFres;\n#ifdef LIT_CLEARCOAT\nvec3 ccLTCSpecFres;\n#endif\nvec3 getLTCLightSpecFres(vec2 uv, vec3 specularity)\n{\n	vec4 t2 = texture2DLod(areaLightsLutTex2, uv, 0.0);\n	return specularity * t2.x + ( vec3( 1.0 ) - specularity) * t2.y;\n}\nvoid calcLTCLightValues(float gloss, vec3 worldNormal, vec3 viewDir, vec3 specularity, float clearcoatGloss, vec3 clearcoatWorldNormal, float clearcoatSpecularity)\n{\n	dLTCUV = getLTCLightUV(gloss, worldNormal, viewDir);\n	dLTCSpecFres = getLTCLightSpecFres(dLTCUV, specularity); \n#ifdef LIT_CLEARCOAT\n	ccLTCUV = getLTCLightUV(clearcoatGloss, clearcoatWorldNormal, viewDir);\n	ccLTCSpecFres = getLTCLightSpecFres(ccLTCUV, vec3(clearcoatSpecularity));\n#endif\n}\nvoid calcRectLightValues(vec3 lightPos, vec3 halfWidth, vec3 halfHeight)\n{\n	dLTCCoords = getLTCLightCoords(lightPos, halfWidth, halfHeight);\n}\nvoid calcDiskLightValues(vec3 lightPos, vec3 halfWidth, vec3 halfHeight)\n{\n	calcRectLightValues(lightPos, halfWidth, halfHeight);\n}\nvoid calcSphereLightValues(vec3 lightPos, vec3 halfWidth, vec3 halfHeight)\n{\n	dLTCCoords = getSphereLightCoords(lightPos, halfWidth, halfHeight);\n}\nvec3 SolveCubic(vec4 Coefficient)\n{\n	float pi = 3.14159;\n	Coefficient.xyz /= Coefficient.w;\n	Coefficient.yz /= 3.0;\n	float A = Coefficient.w;\n	float B = Coefficient.z;\n	float C = Coefficient.y;\n	float D = Coefficient.x;\n	vec3 Delta = vec3(\n		-Coefficient.z * Coefficient.z + Coefficient.y,\n		-Coefficient.y * Coefficient.z + Coefficient.x,\n		dot(vec2(Coefficient.z, -Coefficient.y), Coefficient.xy)\n	);\n	float Discriminant = dot(vec2(4.0 * Delta.x, -Delta.y), Delta.zy);\n	vec3 RootsA, RootsD;\n	vec2 xlc, xsc;\n	{\n		float A_a = 1.0;\n		float C_a = Delta.x;\n		float D_a = -2.0 * B * Delta.x + Delta.y;\n		float Theta = atan(sqrt(Discriminant), -D_a) / 3.0;\n		float x_1a = 2.0 * sqrt(-C_a) * cos(Theta);\n		float x_3a = 2.0 * sqrt(-C_a) * cos(Theta + (2.0 / 3.0) * pi);\n		float xl;\n		if ((x_1a + x_3a) > 2.0 * B)\n			xl = x_1a;\n		else\n			xl = x_3a;\n		xlc = vec2(xl - B, A);\n	}\n	{\n		float A_d = D;\n		float C_d = Delta.z;\n		float D_d = -D * Delta.y + 2.0 * C * Delta.z;\n		float Theta = atan(D * sqrt(Discriminant), -D_d) / 3.0;\n		float x_1d = 2.0 * sqrt(-C_d) * cos(Theta);\n		float x_3d = 2.0 * sqrt(-C_d) * cos(Theta + (2.0 / 3.0) * pi);\n		float xs;\n		if (x_1d + x_3d < 2.0 * C)\n			xs = x_1d;\n		else\n			xs = x_3d;\n		xsc = vec2(-D, xs + C);\n	}\n	float E =  xlc.y * xsc.y;\n	float F = -xlc.x * xsc.y - xlc.y * xsc.x;\n	float G =  xlc.x * xsc.x;\n	vec2 xmc = vec2(C * F - B * G, -B * F + C * E);\n	vec3 Root = vec3(xsc.x / xsc.y, xmc.x / xmc.y, xlc.x / xlc.y);\n	if (Root.x < Root.y && Root.x < Root.z)\n		Root.xyz = Root.yxz;\n	else if (Root.z < Root.x && Root.z < Root.y)\n		Root.xyz = Root.xzy;\n	return Root;\n}\nfloat LTC_EvaluateDisk(vec3 N, vec3 V, vec3 P, mat3 Minv, Coords points)\n{\n	vec3 T1, T2;\n	T1 = normalize(V - N * dot(V, N));\n	T2 = cross(N, T1);\n	mat3 R = transposeMat3( mat3( T1, T2, N ) );\n	vec3 L_[ 3 ];\n	L_[ 0 ] = R * ( points.coord0 - P );\n	L_[ 1 ] = R * ( points.coord1 - P );\n	L_[ 2 ] = R * ( points.coord2 - P );\n	vec3 Lo_i = vec3(0);\n	vec3 C  = 0.5 * (L_[0] + L_[2]);\n	vec3 V1 = 0.5 * (L_[1] - L_[2]);\n	vec3 V2 = 0.5 * (L_[1] - L_[0]);\n	C  = Minv * C;\n	V1 = Minv * V1;\n	V2 = Minv * V2;\n	float a, b;\n	float d11 = dot(V1, V1);\n	float d22 = dot(V2, V2);\n	float d12 = dot(V1, V2);\n	if (abs(d12) / sqrt(d11 * d22) > 0.0001)\n	{\n		float tr = d11 + d22;\n		float det = -d12 * d12 + d11 * d22;\n		det = sqrt(det);\n		float u = 0.5 * sqrt(tr - 2.0 * det);\n		float v = 0.5 * sqrt(tr + 2.0 * det);\n		float e_max = (u + v) * (u + v);\n		float e_min = (u - v) * (u - v);\n		vec3 V1_, V2_;\n		if (d11 > d22)\n		{\n			V1_ = d12 * V1 + (e_max - d11) * V2;\n			V2_ = d12 * V1 + (e_min - d11) * V2;\n		}\n		else\n		{\n			V1_ = d12*V2 + (e_max - d22)*V1;\n			V2_ = d12*V2 + (e_min - d22)*V1;\n		}\n		a = 1.0 / e_max;\n		b = 1.0 / e_min;\n		V1 = normalize(V1_);\n		V2 = normalize(V2_);\n	}\n	else\n	{\n		a = 1.0 / dot(V1, V1);\n		b = 1.0 / dot(V2, V2);\n		V1 *= sqrt(a);\n		V2 *= sqrt(b);\n	}\n	vec3 V3 = normalize(cross(V1, V2));\n	if (dot(C, V3) < 0.0)\n		V3 *= -1.0;\n	float L  = dot(V3, C);\n	float x0 = dot(V1, C) / L;\n	float y0 = dot(V2, C) / L;\n	float E1 = inversesqrt(a);\n	float E2 = inversesqrt(b);\n	a *= L * L;\n	b *= L * L;\n	float c0 = a * b;\n	float c1 = a * b * (1.0 + x0 * x0 + y0 * y0) - a - b;\n	float c2 = 1.0 - a * (1.0 + x0 * x0) - b * (1.0 + y0 * y0);\n	float c3 = 1.0;\n	vec3 roots = SolveCubic(vec4(c0, c1, c2, c3));\n	float e1 = roots.x;\n	float e2 = roots.y;\n	float e3 = roots.z;\n	vec3 avgDir = vec3(a * x0 / (a - e2), b * y0 / (b - e2), 1.0);\n	mat3 rotate = mat3(V1, V2, V3);\n	avgDir = rotate * avgDir;\n	avgDir = normalize(avgDir);\n	float L1 = sqrt(-e2 / e3);\n	float L2 = sqrt(-e2 / e1);\n	float formFactor = max(0.0, L1 * L2 * inversesqrt((1.0 + L1 * L1) * (1.0 + L2 * L2)));\n	\n	const float LUT_SIZE = 64.0;\n	const float LUT_SCALE = ( LUT_SIZE - 1.0 ) / LUT_SIZE;\n	const float LUT_BIAS = 0.5 / LUT_SIZE;\n	vec2 uv = vec2(avgDir.z * 0.5 + 0.5, formFactor);\n	uv = uv*LUT_SCALE + LUT_BIAS;\n	float scale = texture2DLod(areaLightsLutTex2, uv, 0.0).w;\n	return formFactor*scale;\n}\nfloat getRectLightDiffuse(vec3 worldNormal, vec3 viewDir, vec3 lightDir, vec3 lightDirNorm) {\n	return LTC_EvaluateRect( worldNormal, viewDir, vPositionW, mat3( 1.0 ), dLTCCoords );\n}\nfloat getDiskLightDiffuse(vec3 worldNormal, vec3 viewDir, vec3 lightDir, vec3 lightDirNorm) {\n	return LTC_EvaluateDisk( worldNormal, viewDir, vPositionW, mat3( 1.0 ), dLTCCoords );\n}\nfloat getSphereLightDiffuse(vec3 worldNormal, vec3 viewDir, vec3 lightDir, vec3 lightDirNorm) {\n	float falloff = dSphereRadius / (dot(lightDir, lightDir) + dSphereRadius);\n	return getLightDiffuse(worldNormal, viewDir, lightDirNorm) * falloff;\n}\nmat3 getLTCLightInvMat(vec2 uv)\n{\n	vec4 t1 = texture2DLod(areaLightsLutTex1, uv, 0.0);\n	return mat3(\n		vec3( t1.x, 0, t1.y ),\n		vec3(	0, 1,	0 ),\n		vec3( t1.z, 0, t1.w )\n	);\n}\nfloat calcRectLightSpecular(vec3 worldNormal, vec3 viewDir, vec2 uv) {\n	mat3 mInv = getLTCLightInvMat(uv);\n	return LTC_EvaluateRect( worldNormal, viewDir, vPositionW, mInv, dLTCCoords );\n}\nfloat getRectLightSpecular(vec3 worldNormal, vec3 viewDir) {\n	return calcRectLightSpecular(worldNormal, viewDir, dLTCUV);\n}\nfloat calcDiskLightSpecular(vec3 worldNormal, vec3 viewDir, vec2 uv) {\n	mat3 mInv = getLTCLightInvMat(uv);\n	return LTC_EvaluateDisk( worldNormal, viewDir, vPositionW, mInv, dLTCCoords );\n}\nfloat getDiskLightSpecular(vec3 worldNormal, vec3 viewDir) {\n	return calcDiskLightSpecular(worldNormal, viewDir, dLTCUV);\n}\nfloat getSphereLightSpecular(vec3 worldNormal, vec3 viewDir) {\n	return calcDiskLightSpecular(worldNormal, viewDir, dLTCUV);\n}\n";

var metalnessPS = "\n#ifdef MAPFLOAT\nuniform float material_metalness;\n#endif\nvoid getMetalness() {\n	float metalness = 1.0;\n	#ifdef MAPFLOAT\n	metalness *= material_metalness;\n	#endif\n	#ifdef MAPTEXTURE\n	metalness *= texture2DBias($SAMPLER, $UV, textureBias).$CH;\n	#endif\n	#ifdef MAPVERTEX\n	metalness *= saturate(vVertexColor.$VC);\n	#endif\n	dMetalness = metalness;\n}\n";

var msdfPS = "\nuniform sampler2D texture_msdfMap;\nfloat median(float r, float g, float b) {\n	return max(min(r, g), min(max(r, g), b));\n}\nfloat map (float min, float max, float v) {\n	return (v - min) / (max - min);\n}\nuniform float font_sdfIntensity;\nuniform float font_pxrange;\nuniform float font_textureWidth;\n#ifndef LIT_MSDF_TEXT_ATTRIBUTE\n	uniform vec4 outline_color;\n	uniform float outline_thickness;\n	uniform vec4 shadow_color;\n	uniform vec2 shadow_offset;\n#else\n	varying vec4 outline_color;\n	varying float outline_thickness;\n	varying vec4 shadow_color;\n	varying vec2 shadow_offset;\n#endif\nvec4 applyMsdf(vec4 color) {\n	color.rgb = gammaCorrectInput(color.rgb);\n	vec3 tsample = texture2D(texture_msdfMap, vUv0).rgb;\n	vec2 uvShdw = vUv0 - shadow_offset;\n	vec3 ssample = texture2D(texture_msdfMap, uvShdw).rgb;\n	float sigDist = median(tsample.r, tsample.g, tsample.b);\n	float sigDistShdw = median(ssample.r, ssample.g, ssample.b);\n	float smoothingMax = 0.2;\n	vec2 w = fwidth(vUv0);\n	float smoothing = clamp(w.x * font_textureWidth / font_pxrange, 0.0, smoothingMax);\n	float mapMin = 0.05;\n	float mapMax = clamp(1.0 - font_sdfIntensity, mapMin, 1.0);\n	float sigDistInner = map(mapMin, mapMax, sigDist);\n	float sigDistOutline = map(mapMin, mapMax, sigDist + outline_thickness);\n	sigDistShdw = map(mapMin, mapMax, sigDistShdw + outline_thickness);\n	float center = 0.5;\n	float inside = smoothstep(center-smoothing, center+smoothing, sigDistInner);\n	float outline = smoothstep(center-smoothing, center+smoothing, sigDistOutline);\n	float shadow = smoothstep(center-smoothing, center+smoothing, sigDistShdw);\n	vec4 tcolor = (outline > inside) ? outline * vec4(outline_color.a * outline_color.rgb, outline_color.a) : vec4(0.0);\n	tcolor = mix(tcolor, color, inside);\n	vec4 scolor = (shadow > outline) ? shadow * vec4(shadow_color.a * shadow_color.rgb, shadow_color.a) : tcolor;\n	tcolor = mix(scolor, tcolor, outline);\n	tcolor.rgb = gammaCorrectOutput(tcolor.rgb);\n	\n	return tcolor;\n}\n";

var metalnessModulatePS = "\nvec3 getSpecularModulate(in vec3 specularity, in vec3 albedo, in float metalness, in float f0) {\n	vec3 dielectricF0 = f0 * specularity;\n	return mix(dielectricF0, albedo, metalness);\n}\nvec3 getAlbedoModulate(in vec3 albedo, in float metalness) {\n	return albedo * (1.0 - metalness);\n}\n";

var morphEvaluationPS$1 = "\n	color.xyz += morphFactor[{i}] * texture2DLod(morphBlendTex{i}, uv0, 0.0).xyz;\n";

var morphDeclarationPS$1 = "\n	uniform highp sampler2D morphBlendTex{i};\n";

var morphPS$1 = '\n	varying vec2 uv0;\n	#include "morphDeclarationPS, MORPH_TEXTURE_COUNT"\n	#if MORPH_TEXTURE_COUNT > 0\n		uniform highp float morphFactor[{MORPH_TEXTURE_COUNT}];\n	#endif\n	#ifdef MORPH_INT\n		uniform vec3 aabbSize;\n		uniform vec3 aabbMin;\n	#endif\n	void main (void) {\n		highp vec4 color = vec4(0, 0, 0, 1);\n		#include "morphEvaluationPS, MORPH_TEXTURE_COUNT"\n		#ifdef MORPH_INT\n			color.xyz = (color.xyz - aabbMin) / aabbSize * 65535.0;\n			gl_FragColor = uvec4(color);\n		#else\n			gl_FragColor = color;\n		#endif\n	}\n';

var morphVS$1 = "\n	attribute vec2 vertex_position;\n	varying vec2 uv0;\n	void main(void) {\n		gl_Position = vec4(vertex_position, 0.5, 1.0);\n		uv0 = vertex_position.xy * 0.5 + 0.5;\n	}\n";

var msdfVS = "\nattribute vec3 vertex_outlineParameters;\nattribute vec3 vertex_shadowParameters;\nvarying vec4 outline_color;\nvarying float outline_thickness;\nvarying vec4 shadow_color;\nvarying vec2 shadow_offset;\nvoid unpackMsdfParams() {\n	vec3 little = mod(vertex_outlineParameters, 256.);\n	vec3 big = (vertex_outlineParameters - little) / 256.;\n	outline_color.rb = little.xy / 255.;\n	outline_color.ga = big.xy / 255.;\n	outline_thickness = little.z / 255. * 0.2;\n	little = mod(vertex_shadowParameters, 256.);\n	big = (vertex_shadowParameters - little) / 256.;\n	shadow_color.rb = little.xy / 255.;\n	shadow_color.ga = big.xy / 255.;\n	shadow_offset = (vec2(little.z, big.z) / 127. - 1.) * 0.005;\n}\n";

var normalVS = "\nmat3 dNormalMatrix;\nvec3 getNormal() {\n	dNormalMatrix = getNormalMatrix(dModelMatrix);\n	vec3 localNormal = getLocalNormal(vertex_normal);\n	return normalize(dNormalMatrix * localNormal);\n}\n";

var normalCoreVS = "\nattribute vec3 vertex_normal;\n#ifdef MORPHING_NORMAL\n	#ifdef MORPHING_INT\n		uniform highp usampler2D morphNormalTex;\n	#else\n		uniform highp sampler2D morphNormalTex;\n	#endif\n#endif\nvec3 getLocalNormal(vec3 vertexNormal) {\n	vec3 localNormal = vertex_normal;\n	#ifdef MORPHING_NORMAL\n		ivec2 morphUV = getTextureMorphCoords();\n		#ifdef MORPHING_INT\n			vec3 morphNormal = vec3(texelFetch(morphNormalTex, ivec2(morphUV), 0).xyz) / 65535.0 * 2.0 - 1.0;\n		#else\n			vec3 morphNormal = texelFetch(morphNormalTex, ivec2(morphUV), 0).xyz;\n		#endif\n		localNormal += morphNormal;\n	#endif\n	return localNormal;\n}\n#ifdef SKIN\n	mat3 getNormalMatrix(mat4 modelMatrix) {\n		return mat3(modelMatrix[0].xyz, modelMatrix[1].xyz, modelMatrix[2].xyz);\n	}\n#elif defined(INSTANCING)\n	mat3 getNormalMatrix(mat4 modelMatrix) {\n		return mat3(modelMatrix[0].xyz, modelMatrix[1].xyz, modelMatrix[2].xyz);\n	}\n#else\n	mat3 getNormalMatrix(mat4 modelMatrix) {\n		return matrix_normal;\n	}\n#endif\n";

var normalDetailMapPS = "\n#ifdef MAPTEXTURE\nuniform float material_normalDetailMapBumpiness;\nvec3 blendNormals(vec3 n1, vec3 n2) {\n	n1 += vec3(0, 0, 1);\n	n2 *= vec3(-1, -1, 1);\n	return n1 * dot(n1, n2) / n1.z - n2;\n}\n#endif\nvec3 addNormalDetail(vec3 normalMap) {\n#ifdef MAPTEXTURE\n	vec3 normalDetailMap = unpackNormal(texture2DBias($SAMPLER, $UV, textureBias));\n	normalDetailMap = mix(vec3(0.0, 0.0, 1.0), normalDetailMap, material_normalDetailMapBumpiness);\n	return blendNormals(normalMap, normalDetailMap);\n#else\n	return normalMap;\n#endif\n}\n";

var normalMapPS = "\n#ifdef MAPTEXTURE\nuniform float material_bumpiness;\n#endif\nvoid getNormal() {\n#ifdef MAPTEXTURE\n	vec3 normalMap = unpackNormal(texture2DBias($SAMPLER, $UV, textureBias));\n	normalMap = mix(vec3(0.0, 0.0, 1.0), normalMap, material_bumpiness);\n	dNormalW = normalize(dTBN * addNormalDetail(normalMap));\n#else\n	dNormalW = dVertexNormalW;\n#endif\n}\n";

var normalXYPS = "\nvec3 unpackNormal(vec4 nmap) {\n	vec3 normal;\n	normal.xy = nmap.wy * 2.0 - 1.0;\n	normal.z = sqrt(1.0 - saturate(dot(normal.xy, normal.xy)));\n	return normal;\n}\n";

var normalXYZPS = "\nvec3 unpackNormal(vec4 nmap) {\n	return nmap.xyz * 2.0 - 1.0;\n}\n";

var opacityPS = "\nuniform float material_opacity;\nvoid getOpacity() {\n	dAlpha = material_opacity;\n	#ifdef MAPTEXTURE\n	dAlpha *= texture2DBias($SAMPLER, $UV, textureBias).$CH;\n	#endif\n	#ifdef MAPVERTEX\n	dAlpha *= clamp(vVertexColor.$VC, 0.0, 1.0);\n	#endif\n}\n";

var opacityDitherPS = "\nuniform vec4 blueNoiseJitter;\n#ifdef DITHER_BLUENOISE\n	uniform sampler2D blueNoiseTex32;\n#endif\nvoid opacityDither(float alpha, float id) {\n	#ifdef DITHER_BAYER8\n		float noise = bayer8(floor(mod(gl_FragCoord.xy + blueNoiseJitter.xy + id, 8.0))) / 64.0;\n	#else\n		#ifdef DITHER_BLUENOISE\n			vec2 uv = fract(gl_FragCoord.xy / 32.0 + blueNoiseJitter.xy + id);\n			float noise = texture2DLod(blueNoiseTex32, uv, 0.0).y;\n		#endif\n		#ifdef DITHER_IGNNOISE\n			vec3 magic = vec3(0.06711056, 0.00583715, 52.9829189);\n			float noise = fract(magic.z * fract(dot(gl_FragCoord.xy + blueNoiseJitter.xy + id, magic.xy)));\n		#endif\n	#endif\n	noise = pow(noise, 2.2);\n	if (alpha < noise)\n		discard;\n}\n";

var outputPS = "\n";

var outputAlphaPS = "\n#if LIT_BLEND_TYPE == NORMAL || LIT_BLEND_TYPE == ADDITIVEALPHA || defined(LIT_ALPHA_TO_COVERAGE)\n	gl_FragColor.a = litArgs_opacity;\n#elif LIT_BLEND_TYPE == PREMULTIPLIED\n	gl_FragColor.rgb *= litArgs_opacity;\n	gl_FragColor.a = litArgs_opacity;\n#else\n	gl_FragColor.a = 1.0;\n#endif\n";

var outputTex2DPS = "\nvarying vec2 vUv0;\nuniform sampler2D source;\nvoid main(void) {\n	gl_FragColor = texture2D(source, vUv0);\n}\n";

var sheenPS = "\nuniform vec3 material_sheen;\nvoid getSheen() {\n	vec3 sheenColor = material_sheen;\n	#ifdef MAPTEXTURE\n	sheenColor *= $DECODE(texture2DBias($SAMPLER, $UV, textureBias)).$CH;\n	#endif\n	#ifdef MAPVERTEX\n	sheenColor *= saturate(vVertexColor.$VC);\n	#endif\n	sSpecularity = sheenColor;\n}\n";

var sheenGlossPS = "\nuniform float material_sheenGloss;\nvoid getSheenGlossiness() {\n	float sheenGlossiness = material_sheenGloss;\n	#ifdef MAPTEXTURE\n	sheenGlossiness *= texture2DBias($SAMPLER, $UV, textureBias).$CH;\n	#endif\n	#ifdef MAPVERTEX\n	sheenGlossiness *= saturate(vVertexColor.$VC);\n	#endif\n	#ifdef MAPINVERT\n	sheenGlossiness = 1.0 - sheenGlossiness;\n	#endif\n	sheenGlossiness += 0.0000001;\n	sGlossiness = sheenGlossiness;\n}\n";

var parallaxPS = "\nuniform float material_heightMapFactor;\nvoid getParallax() {\n	float parallaxScale = material_heightMapFactor;\n	float height = texture2DBias($SAMPLER, $UV, textureBias).$CH;\n	height = height * parallaxScale - parallaxScale*0.5;\n	vec3 viewDirT = dViewDirW * dTBN;\n	viewDirT.z += 0.42;\n	dUvOffset = height * (viewDirT.xy / viewDirT.z);\n}\n";

var particlePS = "\nvarying vec4 texCoordsAlphaLife;\nuniform sampler2D colorMap;\nuniform sampler2D colorParam;\nuniform float graphSampleSize;\nuniform float graphNumSamples;\n#ifndef CAMERAPLANES\n#define CAMERAPLANES\nuniform vec4 camera_params;\n#endif\nuniform float softening;\nuniform float colorMult;\nfloat saturate(float x) {\n	return clamp(x, 0.0, 1.0);\n}\nvoid main(void) {\n	vec4 tex  = texture2D(colorMap, vec2(texCoordsAlphaLife.x, 1.0 - texCoordsAlphaLife.y));\n	vec4 ramp = texture2D(colorParam, vec2(texCoordsAlphaLife.w, 0.0));\n	ramp.rgb *= colorMult;\n	ramp.a += texCoordsAlphaLife.z;\n	vec3 rgb = tex.rgb * ramp.rgb;\n	float a  = tex.a * ramp.a;\n";

var particleVS = "\nvec3 unpack3NFloats(float src) {\n	float r = fract(src);\n	float g = fract(src * 256.0);\n	float b = fract(src * 65536.0);\n	return vec3(r, g, b);\n}\nfloat saturate(float x) {\n	return clamp(x, 0.0, 1.0);\n}\nvec4 tex1Dlod_lerp(TEXTURE_ACCEPT_HIGHP(tex), vec2 tc) {\n	return mix( texture2D(tex,tc), texture2D(tex,tc + graphSampleSize), fract(tc.x*graphNumSamples) );\n}\nvec4 tex1Dlod_lerp(TEXTURE_ACCEPT_HIGHP(tex), vec2 tc, out vec3 w) {\n	vec4 a = texture2D(tex,tc);\n	vec4 b = texture2D(tex,tc + graphSampleSize);\n	float c = fract(tc.x*graphNumSamples);\n	vec3 unpackedA = unpack3NFloats(a.w);\n	vec3 unpackedB = unpack3NFloats(b.w);\n	w = mix(unpackedA, unpackedB, c);\n	return mix(a, b, c);\n}\nvec2 rotate(vec2 quadXY, float pRotation, out mat2 rotMatrix) {\n	float c = cos(pRotation);\n	float s = sin(pRotation);\n	mat2 m = mat2(c, -s, s, c);\n	rotMatrix = m;\n	return m * quadXY;\n}\nvec3 billboard(vec3 InstanceCoords, vec2 quadXY) {\n	#ifdef SCREEN_SPACE\n		vec3 pos = vec3(-1, 0, 0) * quadXY.x + vec3(0, -1, 0) * quadXY.y;\n	#else\n		vec3 pos = -matrix_viewInverse[0].xyz * quadXY.x + -matrix_viewInverse[1].xyz * quadXY.y;\n	#endif\n	return pos;\n}\nvec3 customFace(vec3 InstanceCoords, vec2 quadXY) {\n	vec3 pos = faceTangent * quadXY.x + faceBinorm * quadXY.y;\n	return pos;\n}\nvec2 safeNormalize(vec2 v) {\n	float l = length(v);\n	return (l > 1e-06) ? v / l : v;\n}\nvoid main(void) {\n	vec3 meshLocalPos = particle_vertexData.xyz;\n	float id = floor(particle_vertexData.w);\n	float rndFactor = fract(sin(id + 1.0 + seed));\n	vec3 rndFactor3 = vec3(rndFactor, fract(rndFactor*10.0), fract(rndFactor*100.0));\n	float uv = id / numParticlesPot;\n	readInput(uv);\n#ifdef LOCAL_SPACE\n	inVel = mat3(matrix_model) * inVel;\n#endif\n	vec2 velocityV = safeNormalize((mat3(matrix_view) * inVel).xy);\n	float particleLifetime = lifetime;\n	if (inLife <= 0.0 || inLife > particleLifetime || !inShow) meshLocalPos = vec3(0.0);\n	vec2 quadXY = meshLocalPos.xy;\n	float nlife = clamp(inLife / particleLifetime, 0.0, 1.0);\n	vec3 paramDiv;\n	vec4 params = tex1Dlod_lerp(TEXTURE_PASS(internalTex2), vec2(nlife, 0), paramDiv);\n	float scale = params.y;\n	float scaleDiv = paramDiv.x;\n	float alphaDiv = paramDiv.z;\n	scale += (scaleDiv * 2.0 - 1.0) * scaleDivMult * fract(rndFactor*10000.0);\n#ifndef USE_MESH\n	texCoordsAlphaLife = vec4(quadXY * -0.5 + 0.5, (alphaDiv * 2.0 - 1.0) * alphaDivMult * fract(rndFactor*1000.0), nlife);\n#else\n	texCoordsAlphaLife = vec4(particle_uv, (alphaDiv * 2.0 - 1.0) * alphaDivMult * fract(rndFactor*1000.0), nlife);\n#endif\n	vec3 particlePos = inPos;\n	vec3 particlePosMoved = vec3(0.0);\n	mat2 rotMatrix;\n";

var particleAnimFrameClampVS = "\n	float animFrame = min(floor(texCoordsAlphaLife.w * animTexParams.y) + animTexParams.x, animTexParams.z);\n";

var particleAnimFrameLoopVS = "\n	float animFrame = floor(mod(texCoordsAlphaLife.w * animTexParams.y + animTexParams.x, animTexParams.z + 1.0));\n";

var particleAnimTexVS = "\n	float animationIndex;\n	if (animTexIndexParams.y == 1.0) {\n		animationIndex = floor((animTexParams.w + 1.0) * rndFactor3.z) * (animTexParams.z + 1.0);\n	} else {\n		animationIndex = animTexIndexParams.x * (animTexParams.z + 1.0);\n	}\n	float atlasX = (animationIndex + animFrame) * animTexTilesParams.x;\n	float atlasY = 1.0 - floor(atlasX + 1.0) * animTexTilesParams.y;\n	atlasX = fract(atlasX);\n	texCoordsAlphaLife.xy *= animTexTilesParams.xy;\n	texCoordsAlphaLife.xy += vec2(atlasX, atlasY);\n";

var particleInputFloatPS = "\nvoid readInput(float uv) {\n	vec4 tex = texture2D(particleTexIN, vec2(uv, 0.25));\n	vec4 tex2 = texture2D(particleTexIN, vec2(uv, 0.75));\n	inPos = tex.xyz;\n	inVel = tex2.xyz;\n	inAngle = (tex.w < 0.0? -tex.w : tex.w) - 1000.0;\n	inShow = tex.w >= 0.0;\n	inLife = tex2.w;\n}\n";

var particleInputRgba8PS = "\n#define PI2 6.283185307179586\nuniform vec3 inBoundsSize;\nuniform vec3 inBoundsCenter;\nuniform float maxVel;\nfloat decodeFloatRG(vec2 rg) {\n	return rg.y*(1.0/255.0) + rg.x;\n}\nfloat decodeFloatRGBA( vec4 rgba ) {\n  return dot( rgba, vec4(1.0, 1.0/255.0, 1.0/65025.0, 1.0/160581375.0) );\n}\nvoid readInput(float uv) {\n	vec4 tex0 = texture2D(particleTexIN, vec2(uv, 0.125));\n	vec4 tex1 = texture2D(particleTexIN, vec2(uv, 0.375));\n	vec4 tex2 = texture2D(particleTexIN, vec2(uv, 0.625));\n	vec4 tex3 = texture2D(particleTexIN, vec2(uv, 0.875));\n	inPos = vec3(decodeFloatRG(tex0.rg), decodeFloatRG(tex0.ba), decodeFloatRG(tex1.rg));\n	inPos = (inPos - vec3(0.5)) * inBoundsSize + inBoundsCenter;\n	inVel = tex2.xyz;\n	inVel = (inVel - vec3(0.5)) * maxVel;\n	inAngle = decodeFloatRG(tex1.ba) * PI2;\n	inShow = tex2.a > 0.5;\n	inLife = decodeFloatRGBA(tex3);\n	float maxNegLife = max(lifetime, (numParticles - 1.0) * (rate+rateDiv));\n	float maxPosLife = lifetime+1.0;\n	inLife = inLife * (maxNegLife + maxPosLife) - maxNegLife;\n}\n";

var particleOutputFloatPS = "\nvoid writeOutput() {\n	if (gl_FragCoord.y<1.0) {\n		gl_FragColor = vec4(outPos, (outAngle + 1000.0) * visMode);\n	} else {\n		gl_FragColor = vec4(outVel, outLife);\n	}\n}\n";

var particleOutputRgba8PS = "\nuniform vec3 outBoundsMul;\nuniform vec3 outBoundsAdd;\nvec2 encodeFloatRG( float v ) {\n	vec2 enc = vec2(1.0, 255.0) * v;\n	enc = fract(enc);\n	enc -= enc.yy * vec2(1.0/255.0, 1.0/255.0);\n	return enc;\n}\nvec4 encodeFloatRGBA( float v ) {\n	vec4 enc = vec4(1.0, 255.0, 65025.0, 160581375.0) * v;\n	enc = fract(enc);\n	enc -= enc.yzww * vec4(1.0/255.0,1.0/255.0,1.0/255.0,0.0);\n	return enc;\n}\nvoid writeOutput() {\n	outPos = outPos * outBoundsMul + outBoundsAdd;\n	outAngle = fract(outAngle / PI2);\n	outVel = (outVel / maxVel) + vec3(0.5);\n	float maxNegLife = max(lifetime, (numParticles - 1.0) * (rate+rateDiv));\n	float maxPosLife = lifetime+1.0;\n	outLife = (outLife + maxNegLife) / (maxNegLife + maxPosLife);\n	if (gl_FragCoord.y < 1.0) {\n		gl_FragColor = vec4(encodeFloatRG(outPos.x), encodeFloatRG(outPos.y));\n	} else if (gl_FragCoord.y < 2.0) {\n		gl_FragColor = vec4(encodeFloatRG(outPos.z), encodeFloatRG(outAngle));\n	} else if (gl_FragCoord.y < 3.0) {\n		gl_FragColor = vec4(outVel, visMode*0.5+0.5);\n	} else {\n		gl_FragColor = encodeFloatRGBA(outLife);\n	}\n}\n";

var particleUpdaterAABBPS = "\nuniform mat3 spawnBounds;\nuniform vec3 spawnPosInnerRatio;\nvec3 calcSpawnPosition(vec3 inBounds, float rndFactor) {\n	vec3 pos = inBounds - vec3(0.5);\n	vec3 posAbs = abs(pos);\n	vec3 maxPos = vec3(max(posAbs.x, max(posAbs.y, posAbs.z)));\n	vec3 edge = maxPos + (vec3(0.5) - maxPos) * spawnPosInnerRatio;\n	pos.x = edge.x * (maxPos.x == posAbs.x ? sign(pos.x) : 2.0 * pos.x);\n	pos.y = edge.y * (maxPos.y == posAbs.y ? sign(pos.y) : 2.0 * pos.y);\n	pos.z = edge.z * (maxPos.z == posAbs.z ? sign(pos.z) : 2.0 * pos.z);\n#ifndef LOCAL_SPACE\n	return emitterPos + spawnBounds * pos;\n#else\n	return spawnBounds * pos;\n#endif\n}\nvoid addInitialVelocity(inout vec3 localVelocity, vec3 inBounds) {\n	localVelocity -= vec3(0, 0, initialVelocity);\n}\n";

var particleUpdaterEndPS = "\n	writeOutput();\n}\n";

var particleUpdaterInitPS = "\nvarying vec2 vUv0;\nuniform highp sampler2D particleTexIN;\nuniform highp sampler2D internalTex0;\nuniform highp sampler2D internalTex1;\nuniform highp sampler2D internalTex2;\nuniform highp sampler2D internalTex3;\nuniform mat3 emitterMatrix;\nuniform mat3 emitterMatrixInv;\nuniform vec3 emitterScale;\nuniform vec3 emitterPos;\nuniform vec3 frameRandom;\nuniform vec3 localVelocityDivMult;\nuniform vec3 velocityDivMult;\nuniform float delta;\nuniform float rate;\nuniform float rateDiv;\nuniform float lifetime;\nuniform float numParticles;\nuniform float rotSpeedDivMult;\nuniform float radialSpeedDivMult;\nuniform float seed;\nuniform float startAngle;\nuniform float startAngle2;\nuniform float initialVelocity;\nuniform float graphSampleSize;\nuniform float graphNumSamples;\nvec3 inPos;\nvec3 inVel;\nfloat inAngle;\nbool inShow;\nfloat inLife;\nfloat visMode;\nvec3 outPos;\nvec3 outVel;\nfloat outAngle;\nbool outShow;\nfloat outLife;\n";

var particleUpdaterNoRespawnPS = "\n	if (outLife >= lifetime) {\n		outLife -= max(lifetime, (numParticles - 1.0) * particleRate);\n		visMode = -1.0;\n	}\n";

var particleUpdaterOnStopPS = "\n	visMode = outLife < 0.0? -1.0: visMode;\n";

var particleUpdaterRespawnPS = "\n	if (outLife >= lifetime) {\n		outLife -= max(lifetime, (numParticles - 1.0) * particleRate);\n		visMode = 1.0;\n	}\n	visMode = outLife < 0.0? 1.0: visMode;\n";

var particleUpdaterSpherePS = "\nuniform float spawnBoundsSphere;\nuniform float spawnBoundsSphereInnerRatio;\nvec3 calcSpawnPosition(vec3 inBounds, float rndFactor) {\n	float rnd4 = fract(rndFactor * 1000.0);\n	vec3 norm = normalize(inBounds.xyz - vec3(0.5));\n	float r = rnd4 * (1.0 - spawnBoundsSphereInnerRatio) + spawnBoundsSphereInnerRatio;\n#ifndef LOCAL_SPACE\n	return emitterPos + norm * r * spawnBoundsSphere;\n#else\n	return norm * r * spawnBoundsSphere;\n#endif\n}\nvoid addInitialVelocity(inout vec3 localVelocity, vec3 inBounds) {\n	localVelocity += normalize(inBounds - vec3(0.5)) * initialVelocity;\n}\n";

var particleUpdaterStartPS = "\nfloat saturate(float x) {\n	return clamp(x, 0.0, 1.0);\n}\nvec3 unpack3NFloats(float src) {\n	float r = fract(src);\n	float g = fract(src * 256.0);\n	float b = fract(src * 65536.0);\n	return vec3(r, g, b);\n}\nvec3 tex1Dlod_lerp(TEXTURE_ACCEPT_HIGHP(tex), vec2 tc, out vec3 w) {\n	vec4 a = texture2D(tex, tc);\n	vec4 b = texture2D(tex, tc + graphSampleSize);\n	float c = fract(tc.x * graphNumSamples);\n	vec3 unpackedA = unpack3NFloats(a.w);\n	vec3 unpackedB = unpack3NFloats(b.w);\n	w = mix(unpackedA, unpackedB, c);\n	return mix(a.xyz, b.xyz, c);\n}\n#define HASHSCALE4 vec4(1031, .1030, .0973, .1099)\nvec4 hash41(float p) {\n	vec4 p4 = fract(vec4(p) * HASHSCALE4);\n	p4 += dot(p4, p4.wzxy+19.19);\n	return fract(vec4((p4.x + p4.y)*p4.z, (p4.x + p4.z)*p4.y, (p4.y + p4.z)*p4.w, (p4.z + p4.w)*p4.x));\n}\nvoid main(void) {\n	if (gl_FragCoord.x > numParticles) discard;\n	readInput(vUv0.x);\n	visMode = inShow? 1.0 : -1.0;\n	vec4 rndFactor = hash41(gl_FragCoord.x + seed);\n	float particleRate = rate + rateDiv * rndFactor.x;\n	outLife = inLife + delta;\n	float nlife = clamp(outLife / lifetime, 0.0, 1.0);\n	vec3 localVelocityDiv;\n	vec3 velocityDiv;\n	vec3 paramDiv;\n	vec3 localVelocity = tex1Dlod_lerp(TEXTURE_PASS(internalTex0), vec2(nlife, 0), localVelocityDiv);\n	vec3 velocity =	  tex1Dlod_lerp(TEXTURE_PASS(internalTex1), vec2(nlife, 0), velocityDiv);\n	vec3 params =		tex1Dlod_lerp(TEXTURE_PASS(internalTex2), vec2(nlife, 0), paramDiv);\n	float rotSpeed = params.x;\n	float rotSpeedDiv = paramDiv.y;\n	vec3 radialParams = tex1Dlod_lerp(TEXTURE_PASS(internalTex3), vec2(nlife, 0), paramDiv);\n	float radialSpeed = radialParams.x;\n	float radialSpeedDiv = radialParams.y;\n	bool respawn = inLife <= 0.0 || outLife >= lifetime;\n	inPos = respawn ? calcSpawnPosition(rndFactor.xyz, rndFactor.x) : inPos;\n	inAngle = respawn ? mix(startAngle, startAngle2, rndFactor.x) : inAngle;\n#ifndef LOCAL_SPACE\n	vec3 radialVel = inPos - emitterPos;\n#else\n	vec3 radialVel = inPos;\n#endif\n	radialVel = (dot(radialVel, radialVel) > 1.0E-8) ? radialSpeed * normalize(radialVel) : vec3(0.0);\n	radialVel += (radialSpeedDiv * vec3(2.0) - vec3(1.0)) * radialSpeedDivMult * rndFactor.xyz;\n	localVelocity +=	(localVelocityDiv * vec3(2.0) - vec3(1.0)) * localVelocityDivMult * rndFactor.xyz;\n	velocity +=		 (velocityDiv * vec3(2.0) - vec3(1.0)) * velocityDivMult * rndFactor.xyz;\n	rotSpeed +=		 (rotSpeedDiv * 2.0 - 1.0) * rotSpeedDivMult * rndFactor.y;\n	addInitialVelocity(localVelocity, rndFactor.xyz);\n#ifndef LOCAL_SPACE\n	outVel = emitterMatrix * localVelocity + (radialVel + velocity) * emitterScale;\n#else\n	outVel = (localVelocity + radialVel) / emitterScale + emitterMatrixInv * velocity;\n#endif\n	outPos = inPos + outVel * delta;\n	outAngle = inAngle + rotSpeed * delta;\n";

var particle_billboardVS = "\n	quadXY = rotate(quadXY, inAngle, rotMatrix);\n	vec3 localPos = billboard(particlePos, quadXY);\n";

var particle_blendAddPS = "\n	dBlendModeFogFactor = 0.0;\n	rgb *= saturate(gammaCorrectInput(max(a, 0.0)));\n	if ((rgb.r + rgb.g + rgb.b) < 0.000001) discard;\n";

var particle_blendMultiplyPS = "\n	rgb = mix(vec3(1.0), rgb, vec3(a));\n	if (rgb.r + rgb.g + rgb.b > 2.99) discard;\n";

var particle_blendNormalPS = "\n	if (a < 0.01) discard;\n";

var particle_cpuVS = "\nattribute vec4 particle_vertexData;\nattribute vec4 particle_vertexData2;\nattribute vec4 particle_vertexData3;\nattribute float particle_vertexData4;\n#ifndef USE_MESH\nattribute vec2 particle_vertexData5;\n#else\nattribute vec4 particle_vertexData5;\n#endif\nuniform mat4 matrix_viewProjection;\nuniform mat4 matrix_model;\n#ifndef VIEWMATRIX\n#define VIEWMATRIX\nuniform mat4 matrix_view;\n#endif\nuniform mat3 matrix_normal;\nuniform mat4 matrix_viewInverse;\nuniform float numParticles;\nuniform float lifetime;\nuniform float stretch;\nuniform float seed;\nuniform vec3 wrapBounds;\nuniform vec3 emitterScale;\nuniform vec3 faceTangent;\nuniform vec3 faceBinorm;\n#ifdef PARTICLE_GPU\n	uniform highp sampler2D internalTex0;\n	uniform highp sampler2D internalTex1;\n	uniform highp sampler2D internalTex2;\n#endif\nuniform vec3 emitterPos;\nvarying vec4 texCoordsAlphaLife;\nvec2 rotate(vec2 quadXY, float pRotation, out mat2 rotMatrix)\n{\n	float c = cos(pRotation);\n	float s = sin(pRotation);\n	mat2 m = mat2(c, -s, s, c);\n	rotMatrix = m;\n	return m * quadXY;\n}\nvec3 billboard(vec3 InstanceCoords, vec2 quadXY)\n{\n	vec3 pos = -matrix_viewInverse[0].xyz * quadXY.x + -matrix_viewInverse[1].xyz * quadXY.y;\n	return pos;\n}\nvec3 customFace(vec3 InstanceCoords, vec2 quadXY)\n{\n	vec3 pos = faceTangent * quadXY.x + faceBinorm * quadXY.y;\n	return pos;\n}\nvoid main(void)\n{\n	vec3 particlePos = particle_vertexData.xyz;\n	vec3 inPos = particlePos;\n	vec3 vertPos = particle_vertexData3.xyz;\n	vec3 inVel = vec3(particle_vertexData2.w, particle_vertexData3.w, particle_vertexData5.x);\n	float id = floor(particle_vertexData4);\n	float rndFactor = fract(sin(id + 1.0 + seed));\n	vec3 rndFactor3 = vec3(rndFactor, fract(rndFactor*10.0), fract(rndFactor*100.0));\n#ifdef LOCAL_SPACE\n	inVel = mat3(matrix_model) * inVel;\n#endif\n	vec2 velocityV = normalize((mat3(matrix_view) * inVel).xy);\n	vec2 quadXY = vertPos.xy;\n#ifdef USE_MESH\n	texCoordsAlphaLife = vec4(particle_vertexData5.zw, particle_vertexData2.z, particle_vertexData.w);\n#else\n	texCoordsAlphaLife = vec4(quadXY * -0.5 + 0.5, particle_vertexData2.z, particle_vertexData.w);\n#endif\n	mat2 rotMatrix;\n	float inAngle = particle_vertexData2.x;\n	vec3 particlePosMoved = vec3(0.0);\n	vec3 meshLocalPos = particle_vertexData3.xyz;\n";

var particle_cpu_endVS = "\n	localPos *= particle_vertexData2.y * emitterScale;\n	localPos += particlePos;\n	gl_Position = matrix_viewProjection * vec4(localPos, 1.0);\n";

var particle_customFaceVS = "\n	quadXY = rotate(quadXY, inAngle, rotMatrix);\n	vec3 localPos = customFace(particlePos, quadXY);\n";

var particle_endPS = "\n	rgb = addFog(rgb);\n	rgb = toneMap(rgb);\n	rgb = gammaCorrectOutput(rgb);\n	gl_FragColor = vec4(rgb, a);\n}\n";

var particle_endVS = "\n	localPos *= scale * emitterScale;\n	localPos += particlePos;\n	#ifdef SCREEN_SPACE\n	gl_Position = vec4(localPos.x, localPos.y, 0.0, 1.0);\n	#else\n	gl_Position = matrix_viewProjection * vec4(localPos.xyz, 1.0);\n	#endif\n";

var particle_halflambertPS = "\n	vec3 negNormal = normal*0.5+0.5;\n	vec3 posNormal = -normal*0.5+0.5;\n	negNormal *= negNormal;\n	posNormal *= posNormal;\n";

var particle_initVS = "\nattribute vec4 particle_vertexData;\n#ifdef USE_MESH\nattribute vec2 particle_uv;\n#endif\nuniform mat4 matrix_viewProjection;\nuniform mat4 matrix_model;\nuniform mat3 matrix_normal;\nuniform mat4 matrix_viewInverse;\n#ifndef VIEWMATRIX\n#define VIEWMATRIX\nuniform mat4 matrix_view;\n#endif\nuniform float numParticles;\nuniform float numParticlesPot;\nuniform float graphSampleSize;\nuniform float graphNumSamples;\nuniform float stretch;\nuniform vec3 wrapBounds;\nuniform vec3 emitterScale;\nuniform vec3 emitterPos;\nuniform vec3 faceTangent;\nuniform vec3 faceBinorm;\nuniform float rate;\nuniform float rateDiv;\nuniform float lifetime;\nuniform float deltaRandomnessStatic;\nuniform float scaleDivMult;\nuniform float alphaDivMult;\nuniform float seed;\nuniform float delta;\nuniform sampler2D particleTexOUT;\nuniform sampler2D particleTexIN;\n#ifdef PARTICLE_GPU\n	uniform highp sampler2D internalTex0;\n	uniform highp sampler2D internalTex1;\n	uniform highp sampler2D internalTex2;\n#endif\n#ifndef CAMERAPLANES\n#define CAMERAPLANES\nuniform vec4 camera_params;\n#endif\nvarying vec4 texCoordsAlphaLife;\nvec3 inPos;\nvec3 inVel;\nfloat inAngle;\nbool inShow;\nfloat inLife;\n";

var particle_lambertPS = "\n	vec3 negNormal = max(normal, vec3(0.0));\n	vec3 posNormal = max(-normal, vec3(0.0));\n";

var particle_lightingPS = "\n	vec3 light = negNormal.x*lightCube[0] + posNormal.x*lightCube[1] +\n						negNormal.y*lightCube[2] + posNormal.y*lightCube[3] +\n						negNormal.z*lightCube[4] + posNormal.z*lightCube[5];\n	rgb *= light;\n";

var particle_localShiftVS = "\n	particlePos = (matrix_model * vec4(particlePos, 1.0)).xyz;\n";

var particle_meshVS = "\n	vec3 localPos = meshLocalPos;\n	localPos.xy = rotate(localPos.xy, inAngle, rotMatrix);\n	localPos.yz = rotate(localPos.yz, inAngle, rotMatrix);\n	billboard(particlePos, quadXY);\n";

var particle_normalVS = "\n	Normal = normalize(localPos + matrix_viewInverse[2].xyz);\n";

var particle_normalMapPS = "\n	vec3 normalMap = normalize(texture2D(normalMap, vec2(texCoordsAlphaLife.x, 1.0 - texCoordsAlphaLife.y)).xyz * 2.0 - 1.0);\n	vec3 normal = ParticleMat * normalMap;\n";

var particle_pointAlongVS = "\n	inAngle = atan(velocityV.x, velocityV.y);\n";

var particle_softPS = "\n	float depth = getLinearScreenDepth();\n	float particleDepth = vDepth;\n	float depthDiff = saturate(abs(particleDepth - depth) * softening);\n	a *= depthDiff;\n";

var particle_softVS = "\n	vDepth = getLinearDepth(localPos);\n";

var particle_stretchVS = "\n	vec3 moveDir = inVel * stretch;\n	vec3 posPrev = particlePos - moveDir;\n	posPrev += particlePosMoved;\n	vec2 centerToVertexV = normalize((mat3(matrix_view) * localPos).xy);\n	float interpolation = dot(-velocityV, centerToVertexV) * 0.5 + 0.5;\n	particlePos = mix(particlePos, posPrev, interpolation);\n";

var particle_TBNVS = "\n	mat3 rot3 = mat3(rotMatrix[0][0], rotMatrix[0][1], 0.0, rotMatrix[1][0], rotMatrix[1][1], 0.0, 0.0, 0.0, 1.0);\n	ParticleMat = mat3(-matrix_viewInverse[0].xyz, -matrix_viewInverse[1].xyz, matrix_viewInverse[2].xyz) * rot3;\n";

var particle_wrapVS = "\n	vec3 origParticlePos = particlePos;\n	particlePos -= matrix_model[3].xyz;\n	particlePos = mod(particlePos, wrapBounds) - wrapBounds * 0.5;\n	particlePos += matrix_model[3].xyz;\n	particlePosMoved = particlePos - origParticlePos;\n";

var pickPS = "\nuniform uint meshInstanceId;\nvec4 getPickOutput() {\n	const vec4 inv = vec4(1.0 / 255.0, 1.0 / 255.0, 1.0 / 255.0, 1.0 / 255.0);\n	const uvec4 shifts = uvec4(16, 8, 0, 24);\n	uvec4 col = (uvec4(meshInstanceId) >> shifts) & uvec4(0xff);\n	return vec4(col) * inv;\n}\n";

var reflDirPS = "\nvoid getReflDir(vec3 worldNormal, vec3 viewDir, float gloss, mat3 tbn) {\n	dReflDirW = normalize(-reflect(viewDir, worldNormal));\n}\n";

var reflDirAnisoPS = "\nvoid getReflDir(vec3 worldNormal, vec3 viewDir, float gloss, mat3 tbn) {\n	float roughness = sqrt(1.0 - min(gloss, 1.0));\n	float anisotropy = material_anisotropy * roughness;\n	vec3 anisotropicDirection = anisotropy >= 0.0 ? tbn[1] : tbn[0];\n	vec3 anisotropicTangent = cross(anisotropicDirection, viewDir);\n	vec3 anisotropicNormal = cross(anisotropicTangent, anisotropicDirection);\n	vec3 bentNormal = normalize(mix(normalize(worldNormal), normalize(anisotropicNormal), anisotropy));\n	dReflDirW = reflect(-viewDir, bentNormal);\n}\n";

var reflectionCCPS = "\n#ifdef LIT_CLEARCOAT\nvoid addReflectionCC(vec3 reflDir, float gloss) {\n	ccReflection += calcReflection(reflDir, gloss);\n}\n#endif\n";

var reflectionCubePS = "\nuniform samplerCube texture_cubeMap;\nuniform float material_reflectivity;\nvec3 calcReflection(vec3 reflDir, float gloss) {\n	vec3 lookupVec = cubeMapProject(reflDir);\n	lookupVec.x *= -1.0;\n	return {reflectionDecode}(textureCube(texture_cubeMap, lookupVec));\n}\nvoid addReflection(vec3 reflDir, float gloss) {   \n	dReflection += vec4(calcReflection(reflDir, gloss), material_reflectivity);\n}\n";

var reflectionEnvHQPS = "\n#ifndef ENV_ATLAS\n#define ENV_ATLAS\nuniform sampler2D texture_envAtlas;\n#endif\nuniform samplerCube texture_cubeMap;\nuniform float material_reflectivity;\nvec3 calcReflection(vec3 reflDir, float gloss) {\n	vec3 dir = cubeMapProject(reflDir) * vec3(-1.0, 1.0, 1.0);\n	vec2 uv = toSphericalUv(dir);\n	float level = saturate(1.0 - gloss) * 5.0;\n	float ilevel = floor(level);\n	float flevel = level - ilevel;\n	vec3 sharp = {reflectionCubemapDecode}(textureCube(texture_cubeMap, dir));\n	vec3 roughA = {reflectionDecode}(texture2D(texture_envAtlas, mapRoughnessUv(uv, ilevel)));\n	vec3 roughB = {reflectionDecode}(texture2D(texture_envAtlas, mapRoughnessUv(uv, ilevel + 1.0)));\n	return processEnvironment(mix(sharp, mix(roughA, roughB, flevel), min(level, 1.0)));\n}\nvoid addReflection(vec3 reflDir, float gloss) {   \n	dReflection += vec4(calcReflection(reflDir, gloss), material_reflectivity);\n}\n";

var reflectionEnvPS = "\n#ifndef ENV_ATLAS\n#define ENV_ATLAS\nuniform sampler2D texture_envAtlas;\n#endif\nuniform float material_reflectivity;\nfloat shinyMipLevel(vec2 uv) {\n	vec2 dx = dFdx(uv);\n	vec2 dy = dFdy(uv);\n	vec2 uv2 = vec2(fract(uv.x + 0.5), uv.y);\n	vec2 dx2 = dFdx(uv2);\n	vec2 dy2 = dFdy(uv2);\n	float maxd = min(max(dot(dx, dx), dot(dy, dy)), max(dot(dx2, dx2), dot(dy2, dy2)));\n	return clamp(0.5 * log2(maxd) - 1.0 + textureBias, 0.0, 5.0);\n}\nvec3 calcReflection(vec3 reflDir, float gloss) {\n	vec3 dir = cubeMapProject(reflDir) * vec3(-1.0, 1.0, 1.0);\n	vec2 uv = toSphericalUv(dir);\n	float level = saturate(1.0 - gloss) * 5.0;\n	float ilevel = floor(level);\n	float level2 = shinyMipLevel(uv * atlasSize);\n	float ilevel2 = floor(level2);\n	vec2 uv0, uv1;\n	float weight;\n	if (ilevel == 0.0) {\n		uv0 = mapShinyUv(uv, ilevel2);\n		uv1 = mapShinyUv(uv, ilevel2 + 1.0);\n		weight = level2 - ilevel2;\n	} else {\n		uv0 = uv1 = mapRoughnessUv(uv, ilevel);\n		weight = 0.0;\n	}\n	vec3 linearA = {reflectionDecode}(texture2D(texture_envAtlas, uv0));\n	vec3 linearB = {reflectionDecode}(texture2D(texture_envAtlas, uv1));\n	vec3 linear0 = mix(linearA, linearB, weight);\n	vec3 linear1 = {reflectionDecode}(texture2D(texture_envAtlas, mapRoughnessUv(uv, ilevel + 1.0)));\n	return processEnvironment(mix(linear0, linear1, level - ilevel));\n}\nvoid addReflection(vec3 reflDir, float gloss) {   \n	dReflection += vec4(calcReflection(reflDir, gloss), material_reflectivity);\n}\n";

var reflectionSpherePS = "\n#ifndef VIEWMATRIX\n#define VIEWMATRIX\nuniform mat4 matrix_view;\n#endif\nuniform sampler2D texture_sphereMap;\nuniform float material_reflectivity;\nvec3 calcReflection(vec3 reflDir, float gloss) {\n	vec3 reflDirV = (mat3(matrix_view) * reflDir).xyz;\n	float m = 2.0 * sqrt( dot(reflDirV.xy, reflDirV.xy) + (reflDirV.z+1.0)*(reflDirV.z+1.0) );\n	vec2 sphereMapUv = reflDirV.xy / m + 0.5;\n	return {reflectionDecode}(texture2D(texture_sphereMap, sphereMapUv));\n}\nvoid addReflection(vec3 reflDir, float gloss) {   \n	dReflection += vec4(calcReflection(reflDir, gloss), material_reflectivity);\n}\n";

var reflectionSheenPS = "\nvoid addReflectionSheen(vec3 worldNormal, vec3 viewDir, float gloss) {\n	float NoV = dot(worldNormal, viewDir);\n	float alphaG = gloss * gloss;\n	float a = gloss < 0.25 ? -339.2 * alphaG + 161.4 * gloss - 25.9 : -8.48 * alphaG + 14.3 * gloss - 9.95;\n	float b = gloss < 0.25 ? 44.0 * alphaG - 23.7 * gloss + 3.26 : 1.97 * alphaG - 3.27 * gloss + 0.72;\n	float DG = exp( a * NoV + b ) + ( gloss < 0.25 ? 0.0 : 0.1 * ( gloss - 0.25 ) );\n	sReflection += calcReflection(worldNormal, 0.0) * saturate(DG);\n}\n";

var refractionCubePS = "\nvec3 refract2(vec3 viewVec, vec3 normal, float IOR) {\n	float vn = dot(viewVec, normal);\n	float k = 1.0 - IOR * IOR * (1.0 - vn * vn);\n	vec3 refrVec = IOR * viewVec - (IOR * vn + sqrt(k)) * normal;\n	return refrVec;\n}\nvoid addRefraction(\n	vec3 worldNormal, \n	vec3 viewDir, \n	float thickness, \n	float gloss, \n	vec3 specularity, \n	vec3 albedo, \n	float transmission,\n	float refractionIndex,\n	float dispersion\n#if defined(LIT_IRIDESCENCE)\n	, vec3 iridescenceFresnel,\n	float iridescenceIntensity\n#endif \n) {\n	vec4 tmpRefl = dReflection;\n	vec3 reflectionDir = refract2(-viewDir, worldNormal, refractionIndex);\n	dReflection = vec4(0);\n	addReflection(reflectionDir, gloss);\n	dDiffuseLight = mix(dDiffuseLight, dReflection.rgb * albedo, transmission);\n	dReflection = tmpRefl;\n}\n";

var refractionDynamicPS = "\nuniform float material_invAttenuationDistance;\nuniform vec3 material_attenuation;\nvec3 evalRefractionColor(vec3 refractionVector, float gloss, float refractionIndex) {\n	vec4 pointOfRefraction = vec4(vPositionW + refractionVector, 1.0);\n	vec4 projectionPoint = matrix_viewProjection * pointOfRefraction;\n	vec2 uv = getGrabScreenPos(projectionPoint);\n	float iorToRoughness = (1.0 - gloss) * clamp((1.0 / refractionIndex) * 2.0 - 2.0, 0.0, 1.0);\n	float refractionLod = log2(uScreenSize.x) * iorToRoughness;\n	vec3 refraction = texture2DLod(uSceneColorMap, uv, refractionLod).rgb;\n	return refraction;\n}\nvoid addRefraction(\n	vec3 worldNormal, \n	vec3 viewDir, \n	float thickness, \n	float gloss, \n	vec3 specularity, \n	vec3 albedo, \n	float transmission,\n	float refractionIndex,\n	float dispersion\n#if defined(LIT_IRIDESCENCE)\n	, vec3 iridescenceFresnel,\n	float iridescenceIntensity\n#endif\n) {\n	vec3 modelScale;\n	modelScale.x = length(vec3(matrix_model[0].xyz));\n	modelScale.y = length(vec3(matrix_model[1].xyz));\n	modelScale.z = length(vec3(matrix_model[2].xyz));\n	vec3 scale = thickness * modelScale;\n	vec3 refractionVector = normalize(refract(-viewDir, worldNormal, refractionIndex)) * scale;\n	vec3 refraction = evalRefractionColor(refractionVector, gloss, refractionIndex);\n	#ifdef LIT_DISPERSION\n		float halfSpread = (1.0 / refractionIndex - 1.0) * 0.025 * dispersion;\n		float refractionIndexR = refractionIndex - halfSpread;\n		refractionVector = normalize(refract(-viewDir, worldNormal, refractionIndexR)) * scale;\n		refraction.r = evalRefractionColor(refractionVector, gloss, refractionIndexR).r;\n		float refractionIndexB = refractionIndex + halfSpread;\n		refractionVector = normalize(refract(-viewDir, worldNormal, refractionIndexB)) * scale;\n		refraction.b = evalRefractionColor(refractionVector, gloss, refractionIndexB).b;\n	#endif\n	vec3 transmittance;\n	if (material_invAttenuationDistance != 0.0)\n	{\n		vec3 attenuation = -log(material_attenuation) * material_invAttenuationDistance;\n		transmittance = exp(-attenuation * length(refractionVector));\n	}\n	else\n	{\n		transmittance = refraction;\n	}\n	vec3 fresnel = vec3(1.0) - \n		getFresnel(\n			dot(viewDir, worldNormal), \n			gloss, \n			specularity\n		#if defined(LIT_IRIDESCENCE)\n			, iridescenceFresnel,\n			iridescenceIntensity\n		#endif\n		);\n	dDiffuseLight = mix(dDiffuseLight, refraction * transmittance * fresnel, transmission);\n}\n";

var reprojectPS$1 = '\nvarying vec2 vUv0;\n#ifdef CUBEMAP_SOURCE\n	uniform samplerCube sourceCube;\n#else\n	uniform sampler2D sourceTex;\n#endif\n#ifdef USE_SAMPLES_TEX\n	uniform sampler2D samplesTex;\n	uniform vec2 samplesTexInverseSize;\n#endif\nuniform vec3 params;\nfloat targetFace() { return params.x; }\nfloat targetTotalPixels() { return params.y; }\nfloat sourceTotalPixels() { return params.z; }\nfloat PI = 3.141592653589793;\nfloat saturate(float x) {\n	return clamp(x, 0.0, 1.0);\n}\n#include "decodePS"\n#include "encodePS"\nvec3 modifySeams(vec3 dir, float scale) {\n	vec3 adir = abs(dir);\n	float M = max(max(adir.x, adir.y), adir.z);\n	return dir / M * vec3(\n		adir.x == M ? 1.0 : scale,\n		adir.y == M ? 1.0 : scale,\n		adir.z == M ? 1.0 : scale\n	);\n}\nvec2 toSpherical(vec3 dir) {\n	return vec2(dir.xz == vec2(0.0) ? 0.0 : atan(dir.x, dir.z), asin(dir.y));\n}\nvec3 fromSpherical(vec2 uv) {\n	return vec3(cos(uv.y) * sin(uv.x),\n				sin(uv.y),\n				cos(uv.y) * cos(uv.x));\n}\nvec3 getDirectionEquirect() {\n	return fromSpherical((vec2(vUv0.x, 1.0 - vUv0.y) * 2.0 - 1.0) * vec2(PI, PI * 0.5));\n}\nfloat signNotZero(float k){\n	return(k >= 0.0) ? 1.0 : -1.0;\n}\nvec2 signNotZero(vec2 v) {\n	return vec2(signNotZero(v.x), signNotZero(v.y));\n}\nvec3 octDecode(vec2 o) {\n	vec3 v = vec3(o.x, 1.0 - abs(o.x) - abs(o.y), o.y);\n	if (v.y < 0.0) {\n		v.xz = (1.0 - abs(v.zx)) * signNotZero(v.xz);\n	}\n	return normalize(v);\n}\nvec3 getDirectionOctahedral() {\n	return octDecode(vec2(vUv0.x, 1.0 - vUv0.y) * 2.0 - 1.0);\n}\nvec2 octEncode(in vec3 v) {\n	float l1norm = abs(v.x) + abs(v.y) + abs(v.z);\n	vec2 result = v.xz * (1.0 / l1norm);\n	if (v.y < 0.0) {\n		result = (1.0 - abs(result.yx)) * signNotZero(result.xy);\n	}\n	return result;\n}\n#ifdef CUBEMAP_SOURCE\n	vec4 sampleCubemap(vec3 dir) {\n		return textureCube(sourceCube, modifySeams(dir, 1.0));\n	}\n	vec4 sampleCubemap(vec2 sph) {\n		return sampleCubemap(fromSpherical(sph));\n	}\n	vec4 sampleCubemap(vec3 dir, float mipLevel) {\n		return textureCubeLod(sourceCube, modifySeams(dir, 1.0), mipLevel);\n	}\n	vec4 sampleCubemap(vec2 sph, float mipLevel) {\n		return sampleCubemap(fromSpherical(sph), mipLevel);\n	}\n#else\n	vec4 sampleEquirect(vec2 sph) {\n		vec2 uv = sph / vec2(PI * 2.0, PI) + 0.5;\n		return texture2D(sourceTex, vec2(uv.x, 1.0 - uv.y));\n	}\n	vec4 sampleEquirect(vec3 dir) {\n		return sampleEquirect(toSpherical(dir));\n	}\n	vec4 sampleEquirect(vec2 sph, float mipLevel) {\n		vec2 uv = sph / vec2(PI * 2.0, PI) + 0.5;\n		return texture2DLod(sourceTex, vec2(uv.x, 1.0 - uv.y), mipLevel);\n	}\n	vec4 sampleEquirect(vec3 dir, float mipLevel) {\n		return sampleEquirect(toSpherical(dir), mipLevel);\n	}\n	vec4 sampleOctahedral(vec3 dir) {\n		vec2 uv = octEncode(dir) * 0.5 + 0.5;\n		return texture2D(sourceTex, vec2(uv.x, 1.0 - uv.y));\n	}\n	vec4 sampleOctahedral(vec2 sph) {\n		return sampleOctahedral(fromSpherical(sph));\n	}\n	vec4 sampleOctahedral(vec3 dir, float mipLevel) {\n		vec2 uv = octEncode(dir) * 0.5 + 0.5;\n		return texture2DLod(sourceTex, vec2(uv.x, 1.0 - uv.y), mipLevel);\n	}\n	vec4 sampleOctahedral(vec2 sph, float mipLevel) {\n		return sampleOctahedral(fromSpherical(sph), mipLevel);\n	}\n#endif\nvec3 getDirectionCubemap() {\n	vec2 st = vUv0 * 2.0 - 1.0;\n	float face = targetFace();\n	vec3 vec;\n	if (face == 0.0) {\n		vec = vec3(1, -st.y, -st.x);\n	} else if (face == 1.0) {\n		vec = vec3(-1, -st.y, st.x);\n	} else if (face == 2.0) {\n		vec = vec3(st.x, 1, st.y);\n	} else if (face == 3.0) {\n		vec = vec3(st.x, -1, -st.y);\n	} else if (face == 4.0) {\n		vec = vec3(st.x, -st.y, 1);\n	} else {\n		vec = vec3(-st.x, -st.y, -1);\n	}\n	return normalize(modifySeams(vec, 1.0));\n}\nmat3 matrixFromVector(vec3 n) {\n	float a = 1.0 / (1.0 + n.z);\n	float b = -n.x * n.y * a;\n	vec3 b1 = vec3(1.0 - n.x * n.x * a, b, -n.x);\n	vec3 b2 = vec3(b, 1.0 - n.y * n.y * a, -n.y);\n	return mat3(b1, b2, n);\n}\nmat3 matrixFromVectorSlow(vec3 n) {\n	vec3 up = (1.0 - abs(n.y) <= 0.0000001) ? vec3(0.0, 0.0, n.y > 0.0 ? 1.0 : -1.0) : vec3(0.0, 1.0, 0.0);\n	vec3 x = normalize(cross(up, n));\n	vec3 y = cross(n, x);\n	return mat3(x, y, n);\n}\nvec4 reproject() {\n	if ({NUM_SAMPLES} <= 1) {\n		return {ENCODE_FUNC}({DECODE_FUNC}({SOURCE_FUNC}({TARGET_FUNC}())));\n	} else {\n		vec3 t = {TARGET_FUNC}();\n		vec3 tu = dFdx(t);\n		vec3 tv = dFdy(t);\n		vec3 result = vec3(0.0);\n		for (float u = 0.0; u < {NUM_SAMPLES_SQRT}; ++u) {\n			for (float v = 0.0; v < {NUM_SAMPLES_SQRT}; ++v) {\n				result += {DECODE_FUNC}({SOURCE_FUNC}(normalize(t +\n															tu * (u / {NUM_SAMPLES_SQRT} - 0.5) +\n															tv * (v / {NUM_SAMPLES_SQRT} - 0.5))));\n			}\n		}\n		return {ENCODE_FUNC}(result / ({NUM_SAMPLES_SQRT} * {NUM_SAMPLES_SQRT}));\n	}\n}\nvec4 unpackFloat = vec4(1.0, 1.0 / 255.0, 1.0 / 65025.0, 1.0 / 16581375.0);\n#ifdef USE_SAMPLES_TEX\n	void unpackSample(int i, out vec3 L, out float mipLevel) {\n		float u = (float(i * 4) + 0.5) * samplesTexInverseSize.x;\n		float v = (floor(u) + 0.5) * samplesTexInverseSize.y;\n		vec4 raw;\n		raw.x = dot(texture2D(samplesTex, vec2(u, v)), unpackFloat); u += samplesTexInverseSize.x;\n		raw.y = dot(texture2D(samplesTex, vec2(u, v)), unpackFloat); u += samplesTexInverseSize.x;\n		raw.z = dot(texture2D(samplesTex, vec2(u, v)), unpackFloat); u += samplesTexInverseSize.x;\n		raw.w = dot(texture2D(samplesTex, vec2(u, v)), unpackFloat);\n		L.xyz = raw.xyz * 2.0 - 1.0;\n		mipLevel = raw.w * 8.0;\n	}\n	vec4 prefilterSamples() {\n		mat3 vecSpace = matrixFromVectorSlow({TARGET_FUNC}());\n		vec3 L;\n		float mipLevel;\n		vec3 result = vec3(0.0);\n		float totalWeight = 0.0;\n		for (int i = 0; i < {NUM_SAMPLES}; ++i) {\n			unpackSample(i, L, mipLevel);\n			result += {DECODE_FUNC}({SOURCE_FUNC}(vecSpace * L, mipLevel)) * L.z;\n			totalWeight += L.z;\n		}\n		return {ENCODE_FUNC}(result / totalWeight);\n	}\n	vec4 prefilterSamplesUnweighted() {\n		mat3 vecSpace = matrixFromVectorSlow({TARGET_FUNC}());\n		vec3 L;\n		float mipLevel;\n		vec3 result = vec3(0.0);\n		float totalWeight = 0.0;\n		for (int i = 0; i < {NUM_SAMPLES}; ++i) {\n			unpackSample(i, L, mipLevel);\n			result += {DECODE_FUNC}({SOURCE_FUNC}(vecSpace * L, mipLevel));\n		}\n		return {ENCODE_FUNC}(result / float({NUM_SAMPLES}));\n	}\n#endif\nvoid main(void) {\n	gl_FragColor = {PROCESS_FUNC}();\n}\n';

var reprojectVS$1 = "\nattribute vec2 vertex_position;\nuniform vec4 uvMod;\nvarying vec2 vUv0;\nvoid main(void) {\n	gl_Position = vec4(vertex_position, 0.5, 1.0);\n	vUv0 = getImageEffectUV((vertex_position.xy * 0.5 + 0.5) * uvMod.xy + uvMod.zw);\n}\n";

var sampleCatmullRomPS = "\nvec4 SampleTextureCatmullRom(TEXTURE_ACCEPT(tex), vec2 uv, vec2 texSize) {\n	vec2 samplePos = uv * texSize;\n	vec2 texPos1 = floor(samplePos - 0.5) + 0.5;\n	vec2 f = samplePos - texPos1;\n	vec2 w0 = f * (-0.5 + f * (1.0 - 0.5 * f));\n	vec2 w1 = 1.0 + f * f * (-2.5 + 1.5 * f);\n	vec2 w2 = f * (0.5 + f * (2.0 - 1.5 * f));\n	vec2 w3 = f * f * (-0.5 + 0.5 * f);\n	vec2 w12 = w1 + w2;\n	vec2 offset12 = w2 / (w1 + w2);\n	vec2 texPos0 = (texPos1 - 1.0) / texSize;\n	vec2 texPos3 = (texPos1 + 2.0) / texSize;\n	vec2 texPos12 = (texPos1 + offset12) / texSize;\n	vec4 result = vec4(0.0);\n	result += texture2DLod(tex, vec2(texPos0.x, texPos0.y), 0.0) * w0.x * w0.y;\n	result += texture2DLod(tex, vec2(texPos12.x, texPos0.y), 0.0) * w12.x * w0.y;\n	result += texture2DLod(tex, vec2(texPos3.x, texPos0.y), 0.0) * w3.x * w0.y;\n	result += texture2DLod(tex, vec2(texPos0.x, texPos12.y), 0.0) * w0.x * w12.y;\n	result += texture2DLod(tex, vec2(texPos12.x, texPos12.y), 0.0) * w12.x * w12.y;\n	result += texture2DLod(tex, vec2(texPos3.x, texPos12.y), 0.0) * w3.x * w12.y;\n	result += texture2DLod(tex, vec2(texPos0.x, texPos3.y), 0.0) * w0.x * w3.y;\n	result += texture2DLod(tex, vec2(texPos12.x, texPos3.y), 0.0) * w12.x * w3.y;\n	result += texture2DLod(tex, vec2(texPos3.x, texPos3.y), 0.0) * w3.x * w3.y;\n	return result;\n}\n";

var screenDepthPS = "\nuniform highp sampler2D uSceneDepthMap;\n#ifndef SCREENSIZE\n#define SCREENSIZE\nuniform vec4 uScreenSize;\n#endif\n#ifndef VIEWMATRIX\n#define VIEWMATRIX\nuniform mat4 matrix_view;\n#endif\n#ifndef LINEARIZE_DEPTH\n#ifndef CAMERAPLANES\n#define CAMERAPLANES\nuniform vec4 camera_params;\n#endif\n#define LINEARIZE_DEPTH\nfloat linearizeDepth(float z) {\n	if (camera_params.w == 0.0)\n		return (camera_params.z * camera_params.y) / (camera_params.y + z * (camera_params.z - camera_params.y));\n	else\n		return camera_params.z + z * (camera_params.y - camera_params.z);\n}\n#endif\nfloat delinearizeDepth(float linearDepth) {\n	if (camera_params.w == 0.0) {\n		return (camera_params.y * (camera_params.z - linearDepth)) / (linearDepth * (camera_params.z - camera_params.y));\n	} else {\n		return (linearDepth - camera_params.z) / (camera_params.y - camera_params.z);\n	}\n}\nfloat getLinearScreenDepth(vec2 uv) {\n	#ifdef SCENE_DEPTHMAP_LINEAR\n		#ifdef SCENE_DEPTHMAP_FLOAT\n			return texture2D(uSceneDepthMap, uv).r;\n		#else\n			ivec2 textureSize = textureSize(uSceneDepthMap, 0);\n			ivec2 texel = ivec2(uv * vec2(textureSize));\n			vec4 data = texelFetch(uSceneDepthMap, texel, 0);\n			uint intBits = \n				(uint(data.r * 255.0) << 24u) |\n				(uint(data.g * 255.0) << 16u) |\n				(uint(data.b * 255.0) << 8u) |\n				uint(data.a * 255.0);\n			return uintBitsToFloat(intBits);\n		#endif\n	#else\n		return linearizeDepth(texture2D(uSceneDepthMap, uv).r);\n	#endif\n}\n#ifndef VERTEXSHADER\nfloat getLinearScreenDepth() {\n	vec2 uv = gl_FragCoord.xy * uScreenSize.zw;\n	return getLinearScreenDepth(uv);\n}\n#endif\nfloat getLinearDepth(vec3 pos) {\n	return -(matrix_view * vec4(pos, 1.0)).z;\n}\n";

var shadowCascadesPS = "\nint getShadowCascadeIndex(vec4 shadowCascadeDistances, int shadowCascadeCount) {\n	float depth = 1.0 / gl_FragCoord.w;\n	vec4 comparisons = step(shadowCascadeDistances, vec4(depth));\n	int cascadeIndex = int(dot(comparisons, vec4(1.0)));\n	return min(cascadeIndex, shadowCascadeCount - 1);\n}\nint ditherShadowCascadeIndex(int cascadeIndex, vec4 shadowCascadeDistances, int shadowCascadeCount, float blendFactor) {\n \n	if (cascadeIndex < shadowCascadeCount - 1) {\n		float currentRangeEnd = shadowCascadeDistances[cascadeIndex];\n		float transitionStart = blendFactor * currentRangeEnd;\n		float depth = 1.0 / gl_FragCoord.w;\n		if (depth > transitionStart) {\n			float transitionFactor = smoothstep(transitionStart, currentRangeEnd, depth);\n			float dither = fract(sin(dot(gl_FragCoord.xy, vec2(12.9898, 78.233))) * 43758.5453);\n			if (dither < transitionFactor) {\n				cascadeIndex += 1;\n			}\n		}\n	}\n	return cascadeIndex;\n}\nvec3 fadeShadow(vec3 shadowCoord, vec4 shadowCascadeDistances) {				  \n	float depth = 1.0 / gl_FragCoord.w;\n	if (depth > shadowCascadeDistances.w) {\n		shadowCoord.z = -9999999.0;\n	}\n	return shadowCoord;\n}\n";

var shadowEVSMPS = "\nfloat linstep(float a, float b, float v) {\n	return saturate((v - a) / (b - a));\n}\nfloat reduceLightBleeding(float pMax, float amount) {\n   return linstep(amount, 1.0, pMax);\n}\nfloat chebyshevUpperBound(vec2 moments, float mean, float minVariance, float lightBleedingReduction) {\n	float variance = moments.y - (moments.x * moments.x);\n	variance = max(variance, minVariance);\n	float d = mean - moments.x;\n	float pMax = variance / (variance + (d * d));\n	pMax = reduceLightBleeding(pMax, lightBleedingReduction);\n	return (mean <= moments.x ? 1.0 : pMax);\n}\nfloat calculateEVSM(vec3 moments, float Z, float vsmBias, float exponent) {\n	Z = 2.0 * Z - 1.0;\n	float warpedDepth = exp(exponent * Z);\n	moments.xy += vec2(warpedDepth, warpedDepth*warpedDepth) * (1.0 - moments.z);\n	float VSMBias = vsmBias;\n	float depthScale = VSMBias * exponent * warpedDepth;\n	float minVariance1 = depthScale * depthScale;\n	return chebyshevUpperBound(moments.xy, warpedDepth, minVariance1, 0.1);\n}\nfloat VSM16(TEXTURE_ACCEPT(tex), vec2 texCoords, float resolution, float Z, float vsmBias, float exponent) {\n	vec3 moments = texture2DLod(tex, texCoords, 0.0).xyz;\n	return calculateEVSM(moments, Z, vsmBias, exponent);\n}\nfloat getShadowVSM16(TEXTURE_ACCEPT(shadowMap), vec3 shadowCoord, vec4 shadowParams, float exponent) {\n	return VSM16(TEXTURE_PASS(shadowMap), shadowCoord.xy, shadowParams.x, shadowCoord.z, shadowParams.y, exponent);\n}\nfloat getShadowSpotVSM16(TEXTURE_ACCEPT(shadowMap), vec3 shadowCoord, vec4 shadowParams, float exponent, vec3 lightDir) {\n	return VSM16(TEXTURE_PASS(shadowMap), shadowCoord.xy, shadowParams.x, length(lightDir) * shadowParams.w + shadowParams.z, shadowParams.y, exponent);\n}\nfloat VSM32(TEXTURE_ACCEPT(tex), vec2 texCoords, float resolution, float Z, float vsmBias, float exponent) {\n	#ifdef CAPS_TEXTURE_FLOAT_FILTERABLE\n		vec3 moments = texture2DLod(tex, texCoords, 0.0).xyz;\n	#else\n		float pixelSize = 1.0 / resolution;\n		texCoords -= vec2(pixelSize);\n		vec3 s00 = texture2DLod(tex, texCoords, 0.0).xyz;\n		vec3 s10 = texture2DLod(tex, texCoords + vec2(pixelSize, 0), 0.0).xyz;\n		vec3 s01 = texture2DLod(tex, texCoords + vec2(0, pixelSize), 0.0).xyz;\n		vec3 s11 = texture2DLod(tex, texCoords + vec2(pixelSize), 0.0).xyz;\n		vec2 fr = fract(texCoords * resolution);\n		vec3 h0 = mix(s00, s10, fr.x);\n		vec3 h1 = mix(s01, s11, fr.x);\n		vec3 moments = mix(h0, h1, fr.y);\n	#endif\n	return calculateEVSM(moments, Z, vsmBias, exponent);\n}\nfloat getShadowVSM32(TEXTURE_ACCEPT(shadowMap), vec3 shadowCoord, vec4 shadowParams, float exponent) {\n	return VSM32(TEXTURE_PASS(shadowMap), shadowCoord.xy, shadowParams.x, shadowCoord.z, shadowParams.y, exponent);\n}\nfloat getShadowSpotVSM32(TEXTURE_ACCEPT(shadowMap), vec3 shadowCoord, vec4 shadowParams, float exponent, vec3 lightDir) {\n	return VSM32(TEXTURE_PASS(shadowMap), shadowCoord.xy, shadowParams.x, length(lightDir) * shadowParams.w + shadowParams.z, shadowParams.y, exponent);\n}\n";

var shadowPCF1PS = "\nfloat getShadowPCF1x1(SHADOWMAP_ACCEPT(shadowMap), vec3 shadowCoord, vec4 shadowParams) {\n	return textureShadow(shadowMap, shadowCoord);\n}\nfloat getShadowSpotPCF1x1(SHADOWMAP_ACCEPT(shadowMap), vec3 shadowCoord, vec4 shadowParams) {\n	return textureShadow(shadowMap, shadowCoord);\n}\n#ifndef WEBGPU\nfloat getShadowOmniPCF1x1(samplerCubeShadow shadowMap, vec3 shadowCoord, vec4 shadowParams, vec3 lightDir) {\n	float shadowZ = length(lightDir) * shadowParams.w + shadowParams.z;\n	return texture(shadowMap, vec4(lightDir, shadowZ));\n}\n#endif\n";

var shadowPCF3PS = "\nfloat _getShadowPCF3x3(SHADOWMAP_ACCEPT(shadowMap), vec3 shadowCoord, vec3 shadowParams) {\n	float z = shadowCoord.z;\n	vec2 uv = shadowCoord.xy * shadowParams.x;\n	float shadowMapSizeInv = 1.0 / shadowParams.x;\n	vec2 base_uv = floor(uv + 0.5);\n	float s = (uv.x + 0.5 - base_uv.x);\n	float t = (uv.y + 0.5 - base_uv.y);\n	base_uv -= vec2(0.5);\n	base_uv *= shadowMapSizeInv;\n	float sum = 0.0;\n	float uw0 = (3.0 - 2.0 * s);\n	float uw1 = (1.0 + 2.0 * s);\n	float u0 = (2.0 - s) / uw0 - 1.0;\n	float u1 = s / uw1 + 1.0;\n	float vw0 = (3.0 - 2.0 * t);\n	float vw1 = (1.0 + 2.0 * t);\n	float v0 = (2.0 - t) / vw0 - 1.0;\n	float v1 = t / vw1 + 1.0;\n	u0 = u0 * shadowMapSizeInv + base_uv.x;\n	v0 = v0 * shadowMapSizeInv + base_uv.y;\n	u1 = u1 * shadowMapSizeInv + base_uv.x;\n	v1 = v1 * shadowMapSizeInv + base_uv.y;\n	sum += uw0 * vw0 * textureShadow(shadowMap, vec3(u0, v0, z));\n	sum += uw1 * vw0 * textureShadow(shadowMap, vec3(u1, v0, z));\n	sum += uw0 * vw1 * textureShadow(shadowMap, vec3(u0, v1, z));\n	sum += uw1 * vw1 * textureShadow(shadowMap, vec3(u1, v1, z));\n	sum *= 1.0f / 16.0;\n	return sum;\n}\nfloat getShadowPCF3x3(SHADOWMAP_ACCEPT(shadowMap), vec3 shadowCoord, vec4 shadowParams) {\n	return _getShadowPCF3x3(SHADOWMAP_PASS(shadowMap), shadowCoord, shadowParams.xyz);\n}\nfloat getShadowSpotPCF3x3(SHADOWMAP_ACCEPT(shadowMap), vec3 shadowCoord, vec4 shadowParams) {\n	return _getShadowPCF3x3(SHADOWMAP_PASS(shadowMap), shadowCoord, shadowParams.xyz);\n}\n#ifndef WEBGPU\nfloat getShadowOmniPCF3x3(samplerCubeShadow shadowMap, vec4 shadowParams, vec3 dir) {\n	\n	float shadowZ = length(dir) * shadowParams.w + shadowParams.z;\n	float z = 1.0 / float(textureSize(shadowMap, 0));\n	vec3 tc = normalize(dir);\n	mediump vec4 shadows;\n	shadows.x = texture(shadowMap, vec4(tc + vec3( z, z, z), shadowZ));\n	shadows.y = texture(shadowMap, vec4(tc + vec3(-z,-z, z), shadowZ));\n	shadows.z = texture(shadowMap, vec4(tc + vec3(-z, z,-z), shadowZ));\n	shadows.w = texture(shadowMap, vec4(tc + vec3( z,-z,-z), shadowZ));\n	return dot(shadows, vec4(0.25));\n}\nfloat getShadowOmniPCF3x3(samplerCubeShadow shadowMap, vec3 shadowCoord, vec4 shadowParams, vec3 lightDir) {\n	return getShadowOmniPCF3x3(shadowMap, shadowParams, lightDir);\n}\n#endif\n";

var shadowPCF5PS = "\nfloat _getShadowPCF5x5(SHADOWMAP_ACCEPT(shadowMap), vec3 shadowCoord, vec3 shadowParams) {\n	float z = shadowCoord.z;\n	vec2 uv = shadowCoord.xy * shadowParams.x;\n	float shadowMapSizeInv = 1.0 / shadowParams.x;\n	vec2 base_uv = floor(uv + 0.5);\n	float s = (uv.x + 0.5 - base_uv.x);\n	float t = (uv.y + 0.5 - base_uv.y);\n	base_uv -= vec2(0.5);\n	base_uv *= shadowMapSizeInv;\n	float uw0 = (4.0 - 3.0 * s);\n	float uw1 = 7.0;\n	float uw2 = (1.0 + 3.0 * s);\n	float u0 = (3.0 - 2.0 * s) / uw0 - 2.0;\n	float u1 = (3.0 + s) / uw1;\n	float u2 = s / uw2 + 2.0;\n	float vw0 = (4.0 - 3.0 * t);\n	float vw1 = 7.0;\n	float vw2 = (1.0 + 3.0 * t);\n	float v0 = (3.0 - 2.0 * t) / vw0 - 2.0;\n	float v1 = (3.0 + t) / vw1;\n	float v2 = t / vw2 + 2.0;\n	float sum = 0.0;\n	u0 = u0 * shadowMapSizeInv + base_uv.x;\n	v0 = v0 * shadowMapSizeInv + base_uv.y;\n	u1 = u1 * shadowMapSizeInv + base_uv.x;\n	v1 = v1 * shadowMapSizeInv + base_uv.y;\n	u2 = u2 * shadowMapSizeInv + base_uv.x;\n	v2 = v2 * shadowMapSizeInv + base_uv.y;\n	sum += uw0 * vw0 * textureShadow(shadowMap, vec3(u0, v0, z));\n	sum += uw1 * vw0 * textureShadow(shadowMap, vec3(u1, v0, z));\n	sum += uw2 * vw0 * textureShadow(shadowMap, vec3(u2, v0, z));\n	sum += uw0 * vw1 * textureShadow(shadowMap, vec3(u0, v1, z));\n	sum += uw1 * vw1 * textureShadow(shadowMap, vec3(u1, v1, z));\n	sum += uw2 * vw1 * textureShadow(shadowMap, vec3(u2, v1, z));\n	sum += uw0 * vw2 * textureShadow(shadowMap, vec3(u0, v2, z));\n	sum += uw1 * vw2 * textureShadow(shadowMap, vec3(u1, v2, z));\n	sum += uw2 * vw2 * textureShadow(shadowMap, vec3(u2, v2, z));\n	sum *= 1.0f / 144.0;\n	sum = saturate(sum);\n	return sum;\n}\nfloat getShadowPCF5x5(SHADOWMAP_ACCEPT(shadowMap), vec3 shadowCoord, vec4 shadowParams) {\n	return _getShadowPCF5x5(SHADOWMAP_PASS(shadowMap), shadowCoord, shadowParams.xyz);\n}\nfloat getShadowSpotPCF5x5(SHADOWMAP_ACCEPT(shadowMap), vec3 shadowCoord, vec4 shadowParams) {\n	return _getShadowPCF5x5(SHADOWMAP_PASS(shadowMap), shadowCoord, shadowParams.xyz);\n}\n";

var shadowPCSSPS = "\n#define PCSS_SAMPLE_COUNT 16\nuniform float pcssDiskSamples[PCSS_SAMPLE_COUNT];\nuniform float pcssSphereSamples[PCSS_SAMPLE_COUNT];\nvec2 vogelDisk(int sampleIndex, float count, float phi, float r) {\n	const float GoldenAngle = 2.4;\n	float theta = float(sampleIndex) * GoldenAngle + phi;\n	float sine = sin(theta);\n	float cosine = cos(theta);\n	return vec2(r * cosine, r * sine);\n}\nvec3 vogelSphere(int sampleIndex, float count, float phi, float r) {\n	const float GoldenAngle = 2.4;\n	float theta = float(sampleIndex) * GoldenAngle + phi;\n	float weight = float(sampleIndex) / count;\n	return vec3(cos(theta) * r, weight, sin(theta) * r);\n}\nfloat noise(vec2 screenPos) {\n	const float PHI = 1.61803398874989484820459;\n	return fract(sin(dot(screenPos * PHI, screenPos)) * screenPos.x);\n}\nfloat viewSpaceDepth(float depth, mat4 invProjection) {\n	float z = depth * 2.0 - 1.0;\n	vec4 clipSpace = vec4(0.0, 0.0, z, 1.0);\n	vec4 viewSpace = invProjection * clipSpace;\n	return viewSpace.z;\n}\nfloat PCSSBlockerDistance(TEXTURE_ACCEPT(shadowMap), vec2 sampleCoords[PCSS_SAMPLE_COUNT], vec2 shadowCoords, vec2 searchSize, float z, vec4 cameraParams) {\n	float blockers = 0.0;\n	float averageBlocker = 0.0;\n	for (int i = 0; i < PCSS_SAMPLE_COUNT; i++) {\n		vec2 offset = sampleCoords[i] * searchSize;\n		vec2 sampleUV = shadowCoords + offset;\n		float blocker = texture2DLod(shadowMap, sampleUV, 0.0).r;\n		float isBlocking = step(blocker, z);\n		blockers += isBlocking;\n		averageBlocker += blocker * isBlocking;\n	}\n	if (blockers > 0.0)\n		return averageBlocker / blockers;\n	return -1.0;\n}\nfloat PCSS(TEXTURE_ACCEPT(shadowMap), vec3 shadowCoords, vec4 cameraParams, vec2 shadowSearchArea) {\n	float receiverDepth = linearizeDepth(shadowCoords.z, cameraParams);\n	vec2 samplePoints[PCSS_SAMPLE_COUNT];\n	const float PI = 3.141592653589793;\n	float noise = noise( gl_FragCoord.xy ) * 2.0 * PI;\n	for (int i = 0; i < PCSS_SAMPLE_COUNT; i++) {\n		float pcssPresample = pcssDiskSamples[i];\n		samplePoints[i] = vogelDisk(i, float(PCSS_SAMPLE_COUNT), noise, pcssPresample);\n	}\n	float averageBlocker = PCSSBlockerDistance(TEXTURE_PASS(shadowMap), samplePoints, shadowCoords.xy, shadowSearchArea, receiverDepth, cameraParams);\n	if (averageBlocker == -1.0) {\n		return 1.0;\n	} else {\n		float depthDifference = (receiverDepth - averageBlocker) / 3.0;\n		vec2 filterRadius = depthDifference * shadowSearchArea;\n		float shadow = 0.0;\n		for (int i = 0; i < PCSS_SAMPLE_COUNT; i ++)\n		{\n			vec2 sampleUV = samplePoints[i] * filterRadius;\n			sampleUV = shadowCoords.xy + sampleUV;\n			float depth = texture2DLod(shadowMap, sampleUV, 0.0).r;\n			shadow += step(receiverDepth, depth);\n		}\n		return shadow / float(PCSS_SAMPLE_COUNT);\n	} \n}\n#ifndef WEBGPU\nfloat PCSSCubeBlockerDistance(samplerCube shadowMap, vec3 lightDirNorm, vec3 samplePoints[PCSS_SAMPLE_COUNT], float z, float shadowSearchArea) {\n	float blockers = 0.0;\n	float averageBlocker = 0.0;\n	for (int i = 0; i < PCSS_SAMPLE_COUNT; i++) {\n		vec3 sampleDir = lightDirNorm + samplePoints[i] * shadowSearchArea;\n		sampleDir = normalize(sampleDir);\n		float blocker = textureCubeLod(shadowMap, sampleDir, 0.0).r;\n		float isBlocking = step(blocker, z);\n		blockers += isBlocking;\n		averageBlocker += blocker * isBlocking;\n	}\n	if (blockers > 0.0)\n		return averageBlocker / blockers;\n	return -1.0;\n}\nfloat PCSSCube(samplerCube shadowMap, vec4 shadowParams, vec3 shadowCoords, vec4 cameraParams, float shadowSearchArea, vec3 lightDir) {\n	\n	vec3 samplePoints[PCSS_SAMPLE_COUNT];\n	const float PI = 3.141592653589793;\n	float noise = noise( gl_FragCoord.xy ) * 2.0 * PI;\n	for (int i = 0; i < PCSS_SAMPLE_COUNT; i++) {\n		float r = pcssSphereSamples[i];\n		samplePoints[i] = vogelSphere(i, float(PCSS_SAMPLE_COUNT), noise, r);\n	}\n	float receiverDepth = length(lightDir) * shadowParams.w + shadowParams.z;\n	vec3 lightDirNorm = normalize(lightDir);\n	\n	float averageBlocker = PCSSCubeBlockerDistance(shadowMap, lightDirNorm, samplePoints, receiverDepth, shadowSearchArea);\n	if (averageBlocker == -1.0) {\n		return 1.0;\n	} else {\n		float filterRadius = ((receiverDepth - averageBlocker) / averageBlocker) * shadowSearchArea;\n		float shadow = 0.0;\n		for (int i = 0; i < PCSS_SAMPLE_COUNT; i++)\n		{\n			vec3 offset = samplePoints[i] * filterRadius;\n			vec3 sampleDir = lightDirNorm + offset;\n			sampleDir = normalize(sampleDir);\n			float depth = textureCubeLod(shadowMap, sampleDir, 0.0).r;\n			shadow += step(receiverDepth, depth);\n		}\n		return shadow / float(PCSS_SAMPLE_COUNT);\n	}\n}\nfloat getShadowOmniPCSS(samplerCube shadowMap, vec3 shadowCoord, vec4 shadowParams, vec4 cameraParams, vec2 shadowSearchArea, vec3 lightDir) {\n	return PCSSCube(shadowMap, shadowParams, shadowCoord, cameraParams, shadowSearchArea.x, lightDir);\n}\n#endif\nfloat getShadowSpotPCSS(TEXTURE_ACCEPT(shadowMap), vec3 shadowCoord, vec4 shadowParams, vec4 cameraParams, vec2 shadowSearchArea, vec3 lightDir) {\n	return PCSS(TEXTURE_PASS(shadowMap), shadowCoord, cameraParams, shadowSearchArea);\n}\n";

var shadowSoftPS = "\nhighp float fractSinRand( const in vec2 uv ) {\n	const float PI = 3.141592653589793;\n	const highp float a = 12.9898, b = 78.233, c = 43758.5453;\n	highp float dt = dot(uv.xy, vec2(a, b)), sn = mod(dt, PI);\n	return fract(sin(sn) * c);\n}\nstruct VogelDiskData {\n	float invNumSamples;\n	float initialAngle;\n	float currentPointId;\n};\nvoid prepareDiskConstants(out VogelDiskData data, int sampleCount, int numRings, float randomSeed) {\n	const float pi2 = 6.28318530718;\n	data.invNumSamples = 1.0 / float(sampleCount);\n	data.initialAngle = randomSeed * pi2;\n	data.currentPointId = 0.0;\n}\n#define GOLDEN_ANGLE 2.399963\nvec2 generateDiskSample(inout VogelDiskData data) {\n	float r = sqrt((data.currentPointId + 0.5) * data.invNumSamples);\n	float theta = data.currentPointId * GOLDEN_ANGLE + data.initialAngle;\n	vec2 offset = vec2(cos(theta), sin(theta)) * pow(r, 1.33);\n	data.currentPointId += 1.0;\n	return offset;\n}\nvoid PCSSFindBlocker(TEXTURE_ACCEPT(shadowMap), out float avgBlockerDepth, out int numBlockers,\n	vec2 shadowCoords, float z, int shadowBlockerSamples, float penumbraSize, float invShadowMapSize, float randomSeed) {\n	VogelDiskData diskData;\n	prepareDiskConstants(diskData, shadowBlockerSamples, 11, randomSeed);\n	float searchWidth = penumbraSize * invShadowMapSize;\n	float blockerSum = 0.0;\n	numBlockers = 0;\n	for( int i = 0; i < shadowBlockerSamples; ++i ) {\n		vec2 diskUV = generateDiskSample(diskData);\n		vec2 sampleUV = shadowCoords + diskUV * searchWidth;\n		float shadowMapDepth = texture2DLod(shadowMap, sampleUV, 0.0).r;\n		if ( shadowMapDepth < z ) {\n			blockerSum += shadowMapDepth;\n			numBlockers++;\n		}\n	}\n	avgBlockerDepth = blockerSum / float(numBlockers);\n}\nfloat PCSSFilter(TEXTURE_ACCEPT(shadowMap), vec2 uv, float receiverDepth, int shadowSamples, float filterRadius, float randomSeed) {\n	VogelDiskData diskData;\n	prepareDiskConstants(diskData, shadowSamples, 11, randomSeed);\n	float sum = 0.0;\n	for (int i = 0; i < shadowSamples; i++) {\n		vec2 offsetUV = generateDiskSample(diskData) * filterRadius;\n		float depth = texture2DLod(shadowMap, uv + offsetUV, 0.0).r;\n		sum += step(receiverDepth, depth);\n	}\n	return sum / float(shadowSamples);\n}\nfloat getPenumbra(float dblocker, float dreceiver, float penumbraSize, float penumbraFalloff) {\n	float dist = dreceiver - dblocker;\n	float penumbra = 1.0 - pow(1.0 - dist, penumbraFalloff);\n	return penumbra * penumbraSize;\n}\nfloat PCSSDirectional(TEXTURE_ACCEPT(shadowMap), vec3 shadowCoords, vec4 cameraParams, vec4 softShadowParams) {\n	float receiverDepth = shadowCoords.z;\n	float randomSeed = fractSinRand(gl_FragCoord.xy);\n	int shadowSamples = int(softShadowParams.x);\n	int shadowBlockerSamples = int(softShadowParams.y);\n	float penumbraSize = softShadowParams.z;\n	float penumbraFalloff = softShadowParams.w;\n	int shadowMapSize = textureSize(shadowMap, 0).x;\n	float invShadowMapSize = 1.0 / float(shadowMapSize);\n	invShadowMapSize *= float(shadowMapSize) / 2048.0;\n	float penumbra;\n	if (shadowBlockerSamples > 0) {\n		float avgBlockerDepth = 0.0;\n		int numBlockers = 0;\n		PCSSFindBlocker(TEXTURE_PASS(shadowMap), avgBlockerDepth, numBlockers, shadowCoords.xy, receiverDepth, shadowBlockerSamples, penumbraSize, invShadowMapSize, randomSeed);\n		if (numBlockers < 1)\n			return 1.0f;\n		penumbra = getPenumbra(avgBlockerDepth, shadowCoords.z, penumbraSize, penumbraFalloff);\n	} else {\n		penumbra = penumbraSize;\n	}\n	float filterRadius = penumbra * invShadowMapSize;\n	return PCSSFilter(TEXTURE_PASS(shadowMap), shadowCoords.xy, receiverDepth, shadowSamples, filterRadius, randomSeed);\n}\nfloat getShadowPCSS(TEXTURE_ACCEPT(shadowMap), vec3 shadowCoord, vec4 shadowParams, vec4 cameraParams, vec4 softShadowParams, vec3 lightDir) {\n	return PCSSDirectional(TEXTURE_PASS(shadowMap), shadowCoord, cameraParams, softShadowParams);\n}\n";

var skinBatchVS = "\nattribute float vertex_boneIndices;\nuniform highp sampler2D texture_poseMap;\nuniform vec4 texture_poseMapSize;\nmat4 getBoneMatrix(const in float i) {\n	float j = i * 3.0;\n	float dx = texture_poseMapSize.z;\n	float dy = texture_poseMapSize.w;\n	float y = floor(j * dx);\n	float x = j - (y * texture_poseMapSize.x);\n	y = dy * (y + 0.5);\n	vec4 v1 = texture2D(texture_poseMap, vec2(dx * (x + 0.5), y));\n	vec4 v2 = texture2D(texture_poseMap, vec2(dx * (x + 1.5), y));\n	vec4 v3 = texture2D(texture_poseMap, vec2(dx * (x + 2.5), y));\n	return mat4(\n		v1.x, v2.x, v3.x, 0,\n		v1.y, v2.y, v3.y, 0,\n		v1.z, v2.z, v3.z, 0,\n		v1.w, v2.w, v3.w, 1\n	);\n}\n";

var skinVS = "\nattribute vec4 vertex_boneWeights;\nattribute vec4 vertex_boneIndices;\nuniform highp sampler2D texture_poseMap;\nuniform vec4 texture_poseMapSize;\nvoid getBoneMatrix(const in float index, out vec4 v1, out vec4 v2, out vec4 v3) {\n	float i = float(index);\n	float j = i * 3.0;\n	float dx = texture_poseMapSize.z;\n	float dy = texture_poseMapSize.w;\n	\n	float y = floor(j * dx);\n	float x = j - (y * texture_poseMapSize.x);\n	y = dy * (y + 0.5);\n	v1 = texture2D(texture_poseMap, vec2(dx * (x + 0.5), y));\n	v2 = texture2D(texture_poseMap, vec2(dx * (x + 1.5), y));\n	v3 = texture2D(texture_poseMap, vec2(dx * (x + 2.5), y));\n}\nmat4 getSkinMatrix(const in vec4 indices, const in vec4 weights) {\n	vec4 a1, a2, a3;\n	getBoneMatrix(indices.x, a1, a2, a3);\n	vec4 b1, b2, b3;\n	getBoneMatrix(indices.y, b1, b2, b3);\n	vec4 c1, c2, c3;\n	getBoneMatrix(indices.z, c1, c2, c3);\n	vec4 d1, d2, d3;\n	getBoneMatrix(indices.w, d1, d2, d3);\n	vec4 v1 = a1 * weights.x + b1 * weights.y + c1 * weights.z + d1 * weights.w;\n	vec4 v2 = a2 * weights.x + b2 * weights.y + c2 * weights.z + d2 * weights.w;\n	vec4 v3 = a3 * weights.x + b3 * weights.y + c3 * weights.z + d3 * weights.w;\n	float one = dot(weights, vec4(1.0));\n	return mat4(\n		v1.x, v2.x, v3.x, 0,\n		v1.y, v2.y, v3.y, 0,\n		v1.z, v2.z, v3.z, 0,\n		v1.w, v2.w, v3.w, one\n	);\n}\n";

var skyboxPS$1 = '\n	#define LIT_SKYBOX_INTENSITY\n	#include "envProcPS"\n	#include "gammaPS"\n	#include "tonemappingPS"\n	varying vec3 vViewDir;\n	uniform float skyboxHighlightMultiplier;\n	#ifdef SKY_CUBEMAP\n		uniform samplerCube texture_cubeMap;\n		#ifdef SKYMESH\n			varying vec3 vWorldPos;\n			uniform mat3 cubeMapRotationMatrix;\n			uniform vec3 projectedSkydomeCenter;\n		#endif\n	#else\n		#include "sphericalPS"\n		#include "envAtlasPS"\n		uniform sampler2D texture_envAtlas;\n		uniform float mipLevel;\n	#endif\n	void main(void) {\n		#ifdef SKY_CUBEMAP\n			#ifdef SKYMESH\n				vec3 envDir = normalize(vWorldPos - projectedSkydomeCenter);\n				vec3 dir = envDir * cubeMapRotationMatrix;\n			#else\n				vec3 dir = vViewDir;\n			#endif\n			dir.x *= -1.0;\n			vec3 linear = {SKYBOX_DECODE_FNC}(textureCube(texture_cubeMap, dir));\n		#else\n			vec3 dir = vViewDir * vec3(-1.0, 1.0, 1.0);\n			vec2 uv = toSphericalUv(normalize(dir));\n			vec3 linear = {SKYBOX_DECODE_FNC}(texture2D(texture_envAtlas, mapRoughnessUv(uv, mipLevel)));\n		#endif\n		if (any(greaterThanEqual(linear, vec3(64.0)))) {\n			linear *= skyboxHighlightMultiplier;\n		}\n		gl_FragColor = vec4(gammaCorrectOutput(toneMap(processEnvironment(linear))), 1.0);\n	}\n';

var skyboxVS$1 = "\nattribute vec4 aPosition;\n#ifndef VIEWMATRIX\n#define VIEWMATRIX\nuniform mat4 matrix_view;\n#endif\nuniform mat4 matrix_projectionSkybox;\nuniform mat3 cubeMapRotationMatrix;\nvarying vec3 vViewDir;\n#ifdef SKYMESH\n	uniform mat4 matrix_model;\n	varying vec3 vWorldPos;\n#endif\nvoid main(void) {\n	mat4 view = matrix_view;\n	#ifdef SKYMESH\n		vec4 worldPos = matrix_model * aPosition;\n		vWorldPos = worldPos.xyz;\n		gl_Position = matrix_projectionSkybox * (view * worldPos);\n	#else\n		view[3][0] = view[3][1] = view[3][2] = 0.0;\n		gl_Position = matrix_projectionSkybox * (view * aPosition);\n		vViewDir = aPosition.xyz * cubeMapRotationMatrix;\n	#endif\n	gl_Position.z = gl_Position.w - 1.0e-7;\n}\n";

var specularPS = "\n#ifdef MAPCOLOR\nuniform vec3 material_specular;\n#endif\nvoid getSpecularity() {\n	vec3 specularColor = vec3(1,1,1);\n	#ifdef MAPCOLOR\n	specularColor *= material_specular;\n	#endif\n	#ifdef MAPTEXTURE\n	specularColor *= $DECODE(texture2DBias($SAMPLER, $UV, textureBias)).$CH;\n	#endif\n	#ifdef MAPVERTEX\n	specularColor *= saturate(vVertexColor.$VC);\n	#endif\n	dSpecularity = specularColor;\n}\n";

var sphericalPS$1 = "\nvec2 toSpherical(vec3 dir) {\n	return vec2(dir.xz == vec2(0.0) ? 0.0 : atan(dir.x, dir.z), asin(dir.y));\n}\nvec2 toSphericalUv(vec3 dir) {\n	const float PI = 3.141592653589793;\n	vec2 uv = toSpherical(dir) / vec2(PI * 2.0, PI) + 0.5;\n	return vec2(uv.x, 1.0 - uv.y);\n}\n";

var specularityFactorPS = "\n#ifdef MAPFLOAT\nuniform float material_specularityFactor;\n#endif\nvoid getSpecularityFactor() {\n	float specularityFactor = 1.0;\n	#ifdef MAPFLOAT\n	specularityFactor *= material_specularityFactor;\n	#endif\n	#ifdef MAPTEXTURE\n	specularityFactor *= texture2DBias($SAMPLER, $UV, textureBias).$CH;\n	#endif\n	#ifdef MAPVERTEX\n	specularityFactor *= saturate(vVertexColor.$VC);\n	#endif\n	dSpecularityFactor = specularityFactor;\n}\n";

var spotPS = "\nfloat getSpotEffect(vec3 lightSpotDir, float lightInnerConeAngle, float lightOuterConeAngle, vec3 lightDirNorm) {\n	float cosAngle = dot(lightDirNorm, lightSpotDir);\n	return smoothstep(lightOuterConeAngle, lightInnerConeAngle, cosAngle);\n}\n";

var startNineSlicedPS = "\n	nineSlicedUv = vUv0;\n	nineSlicedUv.y = 1.0 - nineSlicedUv.y;\n";

var startNineSlicedTiledPS = "\n	vec2 tileMask = step(vMask, vec2(0.99999));\n	vec2 tileSize = 0.5 * (innerOffset.xy + innerOffset.zw);\n	vec2 tileScale = vec2(1.0) / (vec2(1.0) - tileSize);\n	vec2 clampedUv = mix(innerOffset.xy * 0.5, vec2(1.0) - innerOffset.zw * 0.5, fract((vTiledUv - tileSize) * tileScale));\n	clampedUv = clampedUv * atlasRect.zw + atlasRect.xy;\n	nineSlicedUv = vUv0 * tileMask + clampedUv * (vec2(1.0) - tileMask);\n	nineSlicedUv.y = 1.0 - nineSlicedUv.y;\n	\n";

var tangentBinormalVS = "\nvec3 getTangent() {\n	return normalize(dNormalMatrix * vertex_tangent.xyz);\n}\nvec3 getBinormal() {\n	return cross(vNormalW, vTangentW) * vertex_tangent.w;\n}\n";

var TBNPS = "\n#ifdef LIT_TANGENTS\n	#define TBN_TANGENTS\n#else\n	#if defined(LIT_USE_NORMALS) || defined(LIT_USE_CLEARCOAT_NORMALS)\n		#define TBN_DERIVATIVES\n	#endif\n#endif\n#if defined(TBN_DERIVATIVES)\n	uniform float tbnBasis;\n#endif\nvoid getTBN(vec3 tangent, vec3 binormal, vec3 normal) {\n	#ifdef TBN_TANGENTS\n		dTBN = mat3(normalize(tangent), normalize(binormal), normalize(normal));\n	#elif defined(TBN_DERIVATIVES)\n		vec2 uv = {lightingUv};\n		vec3 dp1 = dFdx( vPositionW );\n		vec3 dp2 = dFdy( vPositionW );\n		vec2 duv1 = dFdx( uv );\n		vec2 duv2 = dFdy( uv );\n		vec3 dp2perp = cross( dp2, normal );\n		vec3 dp1perp = cross( normal, dp1 );\n		vec3 T = dp2perp * duv1.x + dp1perp * duv2.x;\n		vec3 B = dp2perp * duv1.y + dp1perp * duv2.y;\n		float denom = max( dot(T,T), dot(B,B) );\n		float invmax = (denom == 0.0) ? 0.0 : tbnBasis / sqrt( denom );\n		dTBN = mat3(T * invmax, -B * invmax, normal );\n	#else\n		vec3 B = cross(normal, vObjectSpaceUpW);\n		vec3 T = cross(normal, B);\n		if (dot(B,B)==0.0)\n		{\n			float major=max(max(normal.x, normal.y), normal.z);\n			if (normal.x == major)\n			{\n				B = cross(normal, vec3(0,1,0));\n				T = cross(normal, B);\n			}\n			else if (normal.y == major)\n			{\n				B = cross(normal, vec3(0,0,1));\n				T = cross(normal, B);\n			}\n			else if (normal.z == major)\n			{\n				B = cross(normal, vec3(1,0,0));\n				T = cross(normal, B);\n			}\n		}\n		dTBN = mat3(normalize(T), normalize(B), normalize(normal));\n	#endif\n}\n";

var thicknessPS = "\n#ifdef MAPFLOAT\nuniform float material_thickness;\n#endif\nvoid getThickness() {\n	dThickness = 1.0;\n	#ifdef MAPFLOAT\n	dThickness *= material_thickness;\n	#endif\n	#ifdef MAPTEXTURE\n	dThickness *= texture2DBias($SAMPLER, $UV, textureBias).$CH;\n	#endif\n	#ifdef MAPVERTEX\n	dThickness *= saturate(vVertexColor.$VC);\n	#endif\n}\n";

var tonemappingPS$1 = '\n#if (TONEMAP == NONE)\n	#include "tonemappingNonePS"\n#elif TONEMAP == FILMIC\n	#include "tonemappingFilmicPS"\n#elif TONEMAP == LINEAR\n	#include "tonemappingLinearPS"\n#elif TONEMAP == HEJL\n	#include "tonemappingHejlPS"\n#elif TONEMAP == ACES\n	#include "tonemappingAcesPS"\n#elif TONEMAP == ACES2\n	#include "tonemappingAces2PS"\n#elif TONEMAP == NEUTRAL\n	#include "tonemappingNeutralPS"\n#endif\n';

var tonemappingAcesPS$1 = "\nuniform float exposure;\nvec3 toneMap(vec3 color) {\n	float tA = 2.51;\n	float tB = 0.03;\n	float tC = 2.43;\n	float tD = 0.59;\n	float tE = 0.14;\n	vec3 x = color * exposure;\n	return (x*(tA*x+tB))/(x*(tC*x+tD)+tE);\n}\n";

var tonemappingAces2PS$1 = "\nuniform float exposure;\nconst mat3 ACESInputMat = mat3(\n	0.59719, 0.35458, 0.04823,\n	0.07600, 0.90834, 0.01566,\n	0.02840, 0.13383, 0.83777\n);\nconst mat3 ACESOutputMat = mat3(\n	 1.60475, -0.53108, -0.07367,\n	-0.10208,  1.10813, -0.00605,\n	-0.00327, -0.07276,  1.07602\n);\nvec3 RRTAndODTFit(vec3 v) {\n	vec3 a = v * (v + 0.0245786) - 0.000090537;\n	vec3 b = v * (0.983729 * v + 0.4329510) + 0.238081;\n	return a / b;\n}\nvec3 toneMap(vec3 color) {\n	color *= exposure / 0.6;\n	color = color * ACESInputMat;\n	color = RRTAndODTFit(color);\n	color = color * ACESOutputMat;\n	color = clamp(color, 0.0, 1.0);\n	return color;\n}\n";

var tonemappingFilmicPS$1 = "\nconst float A =  0.15;\nconst float B =  0.50;\nconst float C =  0.10;\nconst float D =  0.20;\nconst float E =  0.02;\nconst float F =  0.30;\nconst float W =  11.2;\nuniform float exposure;\nvec3 uncharted2Tonemap(vec3 x) {\n   return ((x*(A*x+C*B)+D*E)/(x*(A*x+B)+D*F))-E/F;\n}\nvec3 toneMap(vec3 color) {\n	color = uncharted2Tonemap(color * exposure);\n	vec3 whiteScale = 1.0 / uncharted2Tonemap(vec3(W,W,W));\n	color = color * whiteScale;\n	return color;\n}\n";

var tonemappingHejlPS$1 = "\nuniform float exposure;\nvec3 toneMap(vec3 color) {\n	color *= exposure;\n	const float  A = 0.22, B = 0.3, C = .1, D = 0.2, E = .01, F = 0.3;\n	const float Scl = 1.25;\n	vec3 h = max( vec3(0.0), color - vec3(0.004) );\n	return (h*((Scl*A)*h+Scl*vec3(C*B,C*B,C*B))+Scl*vec3(D*E,D*E,D*E)) / (h*(A*h+vec3(B,B,B))+vec3(D*F,D*F,D*F)) - Scl*vec3(E/F,E/F,E/F);\n}\n";

var tonemappingLinearPS$1 = "\nuniform float exposure;\nvec3 toneMap(vec3 color) {\n	return color * exposure;\n}\n";

var tonemappingNeutralPS$1 = "\nuniform float exposure;\nvec3 toneMap(vec3 color) {\n	color *= exposure;\n	float startCompression = 0.8 - 0.04;\n	float desaturation = 0.15;\n	float x = min(color.r, min(color.g, color.b));\n	float offset = x < 0.08 ? x - 6.25 * x * x : 0.04;\n	color -= offset;\n	float peak = max(color.r, max(color.g, color.b));\n	if (peak < startCompression) return color;\n	float d = 1. - startCompression;\n	float newPeak = 1. - d * d / (peak + d - startCompression);\n	color *= newPeak / peak;\n	float g = 1. - 1. / (desaturation * (peak - newPeak) + 1.);\n	return mix(color, newPeak * vec3(1, 1, 1), g);\n}\n";

var tonemappingNonePS$1 = "\nvec3 toneMap(vec3 color) {\n	return color;\n}\n";

var transformVS = "\n#ifdef PIXELSNAP\nuniform vec4 uScreenSize;\n#endif\n#ifdef SCREENSPACE\nuniform float projectionFlipY;\n#endif\nvec4 evalWorldPosition(vec3 vertexPosition, mat4 modelMatrix) {\n	vec3 localPos = getLocalPosition(vertexPosition);\n	#ifdef NINESLICED\n		localPos.xz *= outerScale;\n		vec2 positiveUnitOffset = clamp(vertexPosition.xz, vec2(0.0), vec2(1.0));\n		vec2 negativeUnitOffset = clamp(-vertexPosition.xz, vec2(0.0), vec2(1.0));\n		localPos.xz += (-positiveUnitOffset * innerOffset.xy + negativeUnitOffset * innerOffset.zw) * vertex_texCoord0.xy;\n		vTiledUv = (localPos.xz - outerScale + innerOffset.xy) * -0.5 + 1.0;\n		localPos.xz *= -0.5;\n		localPos = localPos.xzy;\n	#endif\n	vec4 posW = modelMatrix * vec4(localPos, 1.0);\n	#ifdef SCREENSPACE\n		posW.zw = vec2(0.0, 1.0);\n	#endif\n	return posW;\n}\nvec4 getPosition() {\n	dModelMatrix = getModelMatrix();\n	vec4 posW = evalWorldPosition(vertex_position.xyz, dModelMatrix);\n	dPositionW = posW.xyz;\n	vec4 screenPos;\n	#ifdef UV1LAYOUT\n	screenPos = vec4(vertex_texCoord1.xy * 2.0 - 1.0, 0.5, 1);\n		#ifdef WEBGPU\n		screenPos.y *= -1.0;\n		#endif\n	#else\n	#ifdef SCREENSPACE\n	screenPos = posW;\n	screenPos.y *= projectionFlipY;\n	#else\n	screenPos = matrix_viewProjection * posW;\n	#endif\n	#ifdef PIXELSNAP\n	screenPos.xy = (screenPos.xy * 0.5) + 0.5;\n	screenPos.xy *= uScreenSize.xy;\n	screenPos.xy = floor(screenPos.xy);\n	screenPos.xy *= uScreenSize.zw;\n	screenPos.xy = (screenPos.xy * 2.0) - 1.0;\n	#endif\n	#endif\n	return screenPos;\n}\nvec3 getWorldPosition() {\n	return dPositionW;\n}\n";

var transformCoreVS = '\nattribute vec4 vertex_position;\nuniform mat4 matrix_viewProjection;\nuniform mat4 matrix_model;\nuniform mat3 matrix_normal;\n#ifdef MORPHING\n	uniform vec2 morph_tex_params;\n	attribute uint morph_vertex_id;\n	ivec2 getTextureMorphCoords() {\n		ivec2 textureSize = ivec2(morph_tex_params);\n		int morphGridV = int(morph_vertex_id) / textureSize.x;\n		int morphGridU = int(morph_vertex_id) - (morphGridV * textureSize.x);\n		#ifdef WEBGPU\n			morphGridV = textureSize.y - morphGridV - 1;\n		#endif\n		return ivec2(morphGridU, morphGridV);\n	}\n	#ifdef MORPHING_POSITION\n		#ifdef MORPHING_INT\n			uniform vec3 aabbSize;\n			uniform vec3 aabbMin;\n			uniform usampler2D morphPositionTex;\n		#else\n			uniform highp sampler2D morphPositionTex;\n		#endif\n	#endif\n#endif\n#ifdef defined(BATCH)\n	#include "skinBatchVS"\n	mat4 getModelMatrix() {\n		return getBoneMatrix(vertex_boneIndices);\n	}\n#elif defined(SKIN)\n	#include "skinVS"\n	mat4 getModelMatrix() {\n		return matrix_model * getSkinMatrix(vertex_boneIndices, vertex_boneWeights);\n	}\n#elif defined(INSTANCING)\n	#include "transformInstancingVS"\n#else\n	mat4 getModelMatrix() {\n		return matrix_model;\n	}\n#endif\nvec3 getLocalPosition(vec3 vertexPosition) {\n	vec3 localPos = vertexPosition;\n	#ifdef MORPHING_POSITION\n		ivec2 morphUV = getTextureMorphCoords();\n		#ifdef MORPHING_INT\n			vec3 morphPos = vec3(texelFetch(morphPositionTex, ivec2(morphUV), 0).xyz) / 65535.0 * aabbSize + aabbMin;\n		#else\n			vec3 morphPos = texelFetch(morphPositionTex, ivec2(morphUV), 0).xyz;\n		#endif\n		localPos += morphPos;\n	#endif\n	return localPos;\n}\n';

var transformInstancingVS = "\nattribute vec4 instance_line1;\nattribute vec4 instance_line2;\nattribute vec4 instance_line3;\nattribute vec4 instance_line4;\nmat4 getModelMatrix() {\n	return matrix_model * mat4(instance_line1, instance_line2, instance_line3, instance_line4);\n}\n";

var transmissionPS = "\n#ifdef MAPFLOAT\nuniform float material_refraction;\n#endif\nvoid getRefraction() {\n	float refraction = 1.0;\n	#ifdef MAPFLOAT\n	refraction = material_refraction;\n	#endif\n	#ifdef MAPTEXTURE\n	refraction *= texture2DBias($SAMPLER, $UV, textureBias).$CH;\n	#endif\n	#ifdef MAPVERTEX\n	refraction *= saturate(vVertexColor.$VC);\n	#endif\n	dTransmission = refraction;\n}\n";

var twoSidedLightingPS = "\nuniform float twoSidedLightingNegScaleFactor;\nvoid handleTwoSidedLighting() {\n	dTBN[2] *= gl_FrontFacing ? twoSidedLightingNegScaleFactor : -twoSidedLightingNegScaleFactor;\n}\n";

var uv0VS = "\n#ifdef NINESLICED\nvec2 getUv0() {\n	vec2 uv = vertex_position.xz;\n	vec2 positiveUnitOffset = clamp(vertex_position.xz, vec2(0.0), vec2(1.0));\n	vec2 negativeUnitOffset = clamp(-vertex_position.xz, vec2(0.0), vec2(1.0));\n	uv += (-positiveUnitOffset * innerOffset.xy + negativeUnitOffset * innerOffset.zw) * vertex_texCoord0.xy;\n	uv = uv * -0.5 + 0.5;\n	uv = uv * atlasRect.zw + atlasRect.xy;\n	vMask = vertex_texCoord0.xy;\n	return uv;\n}\n#else\nvec2 getUv0() {\n	return vertex_texCoord0;\n}\n#endif\n";

var uv1VS = "\nvec2 getUv1() {\n	return vertex_texCoord1;\n}\n";

var uvTransformPS = "\nvUV{TRANSFORM_UV_{i}}_{TRANSFORM_ID_{i}} = vec2(\n	dot(vec3(uv{TRANSFORM_UV_{i}}, 1), {TRANSFORM_NAME_{i}}0),\n	dot(vec3(uv{TRANSFORM_UV_{i}}, 1), {TRANSFORM_NAME_{i}}1)\n);\n";

var uvTransformUniformsPS = "\n	uniform vec3 {TRANSFORM_NAME_{i}}0;\n	uniform vec3 {TRANSFORM_NAME_{i}}1;\n";

var viewDirPS = "\nvoid getViewDir() {\n	dViewDirW = normalize(view_position - vPositionW);\n}\n";

var shaderChunks = {
		alphaTestPS,
		ambientPS,
		aoPS,
		aoDetailMapPS,
		aoDiffuseOccPS,
		aoSpecOccPS,
		basePS,
		baseNineSlicedPS,
		baseNineSlicedTiledPS,
		bayerPS,
		blurVSMPS,
		clearCoatPS,
		clearCoatGlossPS,
		clearCoatNormalPS,
		clusteredLightCookiesPS,
		clusteredLightShadowsPS,
		clusteredLightUtilsPS,
		clusteredLightPS,
		combinePS,
		cookiePS,
		cubeMapProjectPS,
		cubeMapRotatePS,
		debugOutputPS,
		debugProcessFrontendPS,
		detailModesPS,
		diffusePS,
		diffuseDetailMapPS,
		decodePS: decodePS$1,
		emissivePS,
		encodePS: encodePS$1,
		endPS,
		envAtlasPS: envAtlasPS$1,
		envProcPS: envProcPS$1,
		falloffInvSquaredPS,
		falloffLinearPS,
		floatUnpackingPS,
		floatAsUintPS,
		fogPS: fogPS$1,
		fresnelSchlickPS,
		fullscreenQuadPS,
		fullscreenQuadVS,
		gammaPS: gammaPS$1,
		gles3PS,
		gles3VS,
		glossPS,
		gsplatCenterVS,
		gsplatCornerVS,
		gsplatColorVS,
		gsplatCommonVS,
		gsplatCompressedDataVS,
		gsplatCompressedSHVS,
		gsplatDataVS,
		gsplatOutputVS,
		gsplatPS,
		gsplatSHVS,
		gsplatSourceVS,
		gsplatVS,
		immediateLinePS: immediateLinePS$1,
		immediateLineVS: immediateLineVS$1,
		iridescenceDiffractionPS,
		iridescencePS,
		iridescenceThicknessPS,
		iorPS,
		lightBufferDefinesPS: '',
		lightDeclarationPS,
		lightDiffuseLambertPS,
		lightDirPointPS,
		lightEvaluationPS,
		lightFunctionLightPS,
		lightFunctionShadowPS,
		lightingPS,
		lightmapAddPS,
		lightmapDirPS,
		lightmapSinglePS,
		lightSpecularAnisoGGXPS,
		lightSpecularBlinnPS,
		lightSheenPS,
		linearizeDepthPS,
		litForwardBackendPS,
		litForwardDeclarationPS,
		litForwardMainPS,
		litForwardPostCodePS,
		litForwardPreCodePS,
		litMainVS,
		litOtherMainPS,
		litShaderArgsPS,
		litShadowMainPS,
		ltcPS,
		metalnessPS,
		metalnessModulatePS,
		morphEvaluationPS: morphEvaluationPS$1,
		morphDeclarationPS: morphDeclarationPS$1,
		morphPS: morphPS$1,
		morphVS: morphVS$1,
		msdfPS,
		msdfVS,
		normalVS,
		normalCoreVS,
		normalDetailMapPS,
		normalMapPS,
		normalXYPS,
		normalXYZPS,
		opacityPS,
		opacityDitherPS,
		outputPS,
		outputAlphaPS,
		outputTex2DPS,
		sheenPS,
		sheenGlossPS,
		parallaxPS,
		particlePS,
		particleVS,
		particleAnimFrameClampVS,
		particleAnimFrameLoopVS,
		particleAnimTexVS,
		particleInputFloatPS,
		particleInputRgba8PS,
		particleOutputFloatPS,
		particleOutputRgba8PS,
		particleUpdaterAABBPS,
		particleUpdaterEndPS,
		particleUpdaterInitPS,
		particleUpdaterNoRespawnPS,
		particleUpdaterOnStopPS,
		particleUpdaterRespawnPS,
		particleUpdaterSpherePS,
		particleUpdaterStartPS,
		particle_billboardVS,
		particle_blendAddPS,
		particle_blendMultiplyPS,
		particle_blendNormalPS,
		particle_cpuVS,
		particle_cpu_endVS,
		particle_customFaceVS,
		particle_endPS,
		particle_endVS,
		particle_halflambertPS,
		particle_initVS,
		particle_lambertPS,
		particle_lightingPS,
		particle_localShiftVS,
		particle_meshVS,
		particle_normalVS,
		particle_normalMapPS,
		particle_pointAlongVS,
		particle_softPS,
		particle_softVS,
		particle_stretchVS,
		particle_TBNVS,
		particle_wrapVS,
		pickPS,
		reflDirPS,
		reflDirAnisoPS,
		reflectionCCPS,
		reflectionCubePS,
		reflectionEnvHQPS,
		reflectionEnvPS,
		reflectionSpherePS,
		reflectionSheenPS,
		refractionCubePS,
		refractionDynamicPS,
		reprojectPS: reprojectPS$1,
		reprojectVS: reprojectVS$1,
		sampleCatmullRomPS,
		screenDepthPS,
		shadowCascadesPS,
		shadowEVSMPS,
		shadowPCF1PS,
		shadowPCF3PS,
		shadowPCF5PS,
		shadowPCSSPS,
		shadowSoftPS,
		skinBatchVS,
		skinVS,
		skyboxPS: skyboxPS$1,
		skyboxVS: skyboxVS$1,
		specularPS,
		sphericalPS: sphericalPS$1,
		specularityFactorPS,
		spotPS,
		startNineSlicedPS,
		startNineSlicedTiledPS,
		tangentBinormalVS,
		TBNPS,
		thicknessPS,
		tonemappingPS: tonemappingPS$1,
		tonemappingAcesPS: tonemappingAcesPS$1,
		tonemappingAces2PS: tonemappingAces2PS$1,
		tonemappingFilmicPS: tonemappingFilmicPS$1,
		tonemappingHejlPS: tonemappingHejlPS$1,
		tonemappingLinearPS: tonemappingLinearPS$1,
		tonemappingNeutralPS: tonemappingNeutralPS$1,
		tonemappingNonePS: tonemappingNonePS$1,
		transformVS,
		transformCoreVS,
		transformInstancingVS,
		transmissionPS,
		twoSidedLightingPS,
		uv0VS,
		uv1VS,
		uvTransformPS,
		uvTransformUniformsPS,
		viewDirPS,
		webgpuPS,
		webgpuVS
};

var programLibraryDeviceCache = new DeviceCache();
function getProgramLibrary(device) {
		var library = programLibraryDeviceCache.get(device);
		return library;
}
function setProgramLibrary(device, library) {
		programLibraryDeviceCache.get(device, ()=>{
				return library;
		});
}

class ShaderGenerator {
		static definesHash(defines) {
				var sortedArray = Array.from(defines).sort((a, b)=>a[0] > b[0] ? 1 : -1);
				return hashCode(JSON.stringify(sortedArray));
		}
}

var shaderPassDeviceCache = new DeviceCache();
class ShaderPassInfo {
		buildShaderDefines() {
				var keyword;
				if (this.isShadow) {
						keyword = 'SHADOW';
				} else if (this.isForward) {
						keyword = 'FORWARD';
				} else if (this.index === SHADER_DEPTH) {
						keyword = 'DEPTH';
				} else if (this.index === SHADER_PICK) {
						keyword = 'PICK';
				}
				this.defines.set("" + keyword + "_PASS", '');
				this.defines.set("" + this.name.toUpperCase() + "_PASS", '');
		}
		constructor(name, index, options = {}){
				this.defines = new Map();
				this.name = name;
				this.index = index;
				Object.assign(this, options);
				this.buildShaderDefines();
		}
}
class ShaderPass {
		static get(device) {
				return shaderPassDeviceCache.get(device, ()=>{
						return new ShaderPass();
				});
		}
		allocate(name, options) {
				var info = this.passesNamed.get(name);
				if (info === undefined) {
						info = new ShaderPassInfo(name, this.nextIndex, options);
						this.passesNamed.set(info.name, info);
						this.passesIndexed[info.index] = info;
						this.nextIndex++;
				}
				return info;
		}
		getByIndex(index) {
				var info = this.passesIndexed[index];
				return info;
		}
		getByName(name) {
				return this.passesNamed.get(name);
		}
		constructor(){
				this.passesNamed = new Map();
				this.passesIndexed = [];
				this.nextIndex = 0;
				var add = (name, index, options)=>{
						this.allocate(name, options);
				};
				add('forward', SHADER_FORWARD, {
						isForward: true
				});
				add('prepass');
				add('depth');
				add('pick');
				add('shadow');
		}
}

function _extends$h() {
		_extends$h = Object.assign || function(target) {
				for(var i = 1; i < arguments.length; i++){
						var source = arguments[i];
						for(var key in source){
								if (Object.prototype.hasOwnProperty.call(source, key)) {
										target[key] = source[key];
								}
						}
				}
				return target;
		};
		return _extends$h.apply(this, arguments);
}
function createShaderFromCode(device, vsCode, fsCode, uniqueName, attributes, useTransformFeedback, shaderDefinitionOptions) {
		if (useTransformFeedback === void 0) useTransformFeedback = false;
		if (shaderDefinitionOptions === void 0) shaderDefinitionOptions = {};
		if (typeof useTransformFeedback === 'boolean') {
				shaderDefinitionOptions.useTransformFeedback = useTransformFeedback;
		} else if (typeof useTransformFeedback === 'object') {
				shaderDefinitionOptions = _extends$h({}, shaderDefinitionOptions, useTransformFeedback);
		}
		var programLibrary = getProgramLibrary(device);
		var shader = programLibrary.getCachedShader(uniqueName);
		if (!shader) {
				shader = new Shader(device, ShaderUtils.createDefinition(device, _extends$h({}, shaderDefinitionOptions, {
						name: uniqueName,
						vertexCode: vsCode,
						fragmentCode: fsCode,
						attributes: attributes
				})));
				programLibrary.setCachedShader(uniqueName, shader);
		}
		return shader;
}
class ShaderGeneratorPassThrough extends ShaderGenerator {
		generateKey(options) {
				return this.key;
		}
		createShaderDefinition(device, options) {
				return this.shaderDefinition;
		}
		constructor(key, shaderDefinition){
				super();
				this.key = key;
				this.shaderDefinition = shaderDefinition;
		}
}
function processShader(shader, processingOptions) {
		var shaderDefinition = shader.definition;
		var _shaderDefinition_name;
		var name = (_shaderDefinition_name = shaderDefinition.name) != null ? _shaderDefinition_name : 'shader';
		var key = name + "-id-" + shader.id;
		var materialGenerator = new ShaderGeneratorPassThrough(key, shaderDefinition);
		var libraryModuleName = 'shader';
		var library = getProgramLibrary(shader.device);
		library.register(libraryModuleName, materialGenerator);
		var variant = library.getProgram(libraryModuleName, {}, processingOptions);
		library.unregister(libraryModuleName);
		return variant;
}
var getCoreDefines = (material, params)=>{
		var defines = new Map(material.defines);
		params.cameraShaderParams.defines.forEach((value, key)=>defines.set(key, value));
		var shaderPassInfo = ShaderPass.get(params.device).getByIndex(params.pass);
		shaderPassInfo.defines.forEach((value, key)=>defines.set(key, value));
		return defines;
};

var _quadPrimitive = {
		type: PRIMITIVE_TRISTRIP,
		base: 0,
		count: 4,
		indexed: false
};
var _tempViewport = new Vec4();
var _tempScissor = new Vec4();
var _dynamicBindGroup$1 = new DynamicBindGroup();
class QuadRender {
		destroy() {
				var _this_uniformBuffer, _this_bindGroup;
				(_this_uniformBuffer = this.uniformBuffer) == null ? void 0 : _this_uniformBuffer.destroy();
				this.uniformBuffer = null;
				(_this_bindGroup = this.bindGroup) == null ? void 0 : _this_bindGroup.destroy();
				this.bindGroup = null;
		}
		render(viewport, scissor) {
				var device = this.shader.device;
				if (viewport) {
						_tempViewport.set(device.vx, device.vy, device.vw, device.vh);
						_tempScissor.set(device.sx, device.sy, device.sw, device.sh);
						scissor = scissor != null ? scissor : viewport;
						device.setViewport(viewport.x, viewport.y, viewport.z, viewport.w);
						device.setScissor(scissor.x, scissor.y, scissor.z, scissor.w);
				}
				device.setVertexBuffer(device.quadVertexBuffer, 0);
				var shader = this.shader;
				device.setShader(shader);
				if (device.supportsUniformBuffers) {
						device.setBindGroup(BINDGROUP_VIEW, device.emptyBindGroup);
						var bindGroup = this.bindGroup;
						bindGroup.update();
						device.setBindGroup(BINDGROUP_MESH, bindGroup);
						var uniformBuffer = this.uniformBuffer;
						if (uniformBuffer) {
								uniformBuffer.update(_dynamicBindGroup$1);
								device.setBindGroup(BINDGROUP_MESH_UB, _dynamicBindGroup$1.bindGroup, _dynamicBindGroup$1.offsets);
						} else {
								device.setBindGroup(BINDGROUP_MESH_UB, device.emptyBindGroup);
						}
				}
				device.draw(_quadPrimitive);
				if (viewport) {
						device.setViewport(_tempViewport.x, _tempViewport.y, _tempViewport.z, _tempViewport.w);
						device.setScissor(_tempScissor.x, _tempScissor.y, _tempScissor.z, _tempScissor.w);
				}
		}
		constructor(shader){
				var device = shader.device;
				this.shader = shader;
				if (device.supportsUniformBuffers) {
						var processingOptions = new ShaderProcessorOptions();
						this.shader = processShader(shader, processingOptions);
						var ubFormat = this.shader.meshUniformBufferFormat;
						if (ubFormat) {
								this.uniformBuffer = new UniformBuffer(device, ubFormat, false);
						}
						var bindGroupFormat = this.shader.meshBindGroupFormat;
						this.bindGroup = new BindGroup(device, bindGroupFormat);
				}
		}
}

class RenderPassQuad extends RenderPass {
		execute() {
				var { device } = this;
				device.setCullMode(CULLFACE_NONE);
				device.setDepthState(DepthState.NODEPTH);
				device.setStencilState(null, null);
				this.quad.render(this.rect, this.scissorRect);
		}
		constructor(device, quad, rect, scissorRect){
				super(device);
				this.quad = quad;
				this.rect = rect;
				this.scissorRect = scissorRect;
		}
}

var _tempRect = new Vec4();
function drawQuadWithShader(device, target, shader, rect, scissorRect) {
		var quad = new QuadRender(shader);
		if (!rect) {
				rect = _tempRect;
				rect.x = 0;
				rect.y = 0;
				rect.z = target ? target.width : device.width;
				rect.w = target ? target.height : device.height;
		}
		var renderPass = new RenderPassQuad(device, quad, rect, scissorRect);
		renderPass.init(target);
		renderPass.colorOps.clear = false;
		renderPass.depthStencilOps.clearDepth = false;
		if (device.isWebGPU && target === null && device.samples > 1) {
				renderPass.colorOps.store = true;
		}
		renderPass.render();
		quad.destroy();
}

class Batch {
		destroy(scene, layers) {
				if (this.meshInstance) {
						this.removeFromLayers(scene, layers);
						this.meshInstance.destroy();
						this.meshInstance = null;
				}
		}
		addToLayers(scene, layers) {
				for(var i = 0; i < layers.length; i++){
						var layer = scene.layers.getLayerById(layers[i]);
						if (layer) {
								layer.addMeshInstances([
										this.meshInstance
								]);
						}
				}
		}
		removeFromLayers(scene, layers) {
				for(var i = 0; i < layers.length; i++){
						var layer = scene.layers.getLayerById(layers[i]);
						if (layer) {
								layer.removeMeshInstances([
										this.meshInstance
								]);
						}
				}
		}
		updateBoundingBox() {
				this._aabb.copy(this.origMeshInstances[0].aabb);
				for(var i = 1; i < this.origMeshInstances.length; i++){
						this._aabb.add(this.origMeshInstances[i].aabb);
				}
				this.meshInstance.aabb = this._aabb;
				this.meshInstance._aabbVer = 0;
		}
		get model() {
				return undefined;
		}
		constructor(meshInstances, dynamic, batchGroupId){
				this._aabb = new BoundingBox();
				this.meshInstance = null;
				this.origMeshInstances = meshInstances;
				this.dynamic = dynamic;
				this.batchGroupId = batchGroupId;
		}
}

class BatchGroup {
		constructor(id, name, dynamic, maxAabbSize, layers = [
				LAYERID_WORLD
		]){
				this._ui = false;
				this._sprite = false;
				this._obj = {
						model: [],
						element: [],
						sprite: [],
						render: []
				};
				this.id = id;
				this.name = name;
				this.dynamic = dynamic;
				this.maxAabbSize = maxAabbSize;
				this.layers = layers;
		}
}
BatchGroup.MODEL = 'model';
BatchGroup.ELEMENT = 'element';
BatchGroup.SPRITE = 'sprite';
BatchGroup.RENDER = 'render';

var _invMatrix = new Mat4();
class SkinInstance {
		set rootBone(rootBone) {
				this._rootBone = rootBone;
		}
		get rootBone() {
				return this._rootBone;
		}
		init(device, numBones) {
				var numPixels = numBones * 3;
				var width = Math.ceil(Math.sqrt(numPixels));
				width = math.roundUp(width, 3);
				var height = Math.ceil(numPixels / width);
				this.boneTexture = new Texture(device, {
						width: width,
						height: height,
						format: PIXELFORMAT_RGBA32F,
						mipmaps: false,
						minFilter: FILTER_NEAREST,
						magFilter: FILTER_NEAREST,
						name: 'skin'
				});
				this.boneTextureSize = [
						width,
						height,
						1.0 / width,
						1.0 / height
				];
				this.matrixPalette = this.boneTexture.lock({
						mode: TEXTURELOCK_READ
				});
				this.boneTexture.unlock();
		}
		destroy() {
				if (this.boneTexture) {
						this.boneTexture.destroy();
						this.boneTexture = null;
				}
		}
		resolve(rootBone, entity) {
				this.rootBone = rootBone;
				var skin = this.skin;
				var bones = [];
				for(var j = 0; j < skin.boneNames.length; j++){
						var boneName = skin.boneNames[j];
						var bone = rootBone.findByName(boneName);
						if (!bone) {
								bone = entity;
						}
						bones.push(bone);
				}
				this.bones = bones;
		}
		initSkin(skin) {
				this.skin = skin;
				this.bones = [];
				var numBones = skin.inverseBindPose.length;
				this.init(skin.device, numBones);
				this.matrices = [];
				for(var i = 0; i < numBones; i++){
						this.matrices[i] = new Mat4();
				}
		}
		uploadBones(device) {
				this.boneTexture.upload();
		}
		_updateMatrices(rootNode, skinUpdateIndex) {
				if (this._skinUpdateIndex !== skinUpdateIndex) {
						this._skinUpdateIndex = skinUpdateIndex;
						_invMatrix.copy(rootNode.getWorldTransform()).invert();
						for(var i = this.bones.length - 1; i >= 0; i--){
								this.matrices[i].mulAffine2(_invMatrix, this.bones[i].getWorldTransform());
								this.matrices[i].mulAffine2(this.matrices[i], this.skin.inverseBindPose[i]);
						}
				}
		}
		updateMatrices(rootNode, skinUpdateIndex) {
				if (this._updateBeforeCull) {
						this._updateMatrices(rootNode, skinUpdateIndex);
				}
		}
		updateMatrixPalette(rootNode, skinUpdateIndex) {
				this._updateMatrices(rootNode, skinUpdateIndex);
				var mp = this.matrixPalette;
				var count = this.bones.length;
				for(var i = 0; i < count; i++){
						var pe = this.matrices[i].data;
						var base = i * 12;
						mp[base] = pe[0];
						mp[base + 1] = pe[4];
						mp[base + 2] = pe[8];
						mp[base + 3] = pe[12];
						mp[base + 4] = pe[1];
						mp[base + 5] = pe[5];
						mp[base + 6] = pe[9];
						mp[base + 7] = pe[13];
						mp[base + 8] = pe[2];
						mp[base + 9] = pe[6];
						mp[base + 10] = pe[10];
						mp[base + 11] = pe[14];
				}
				this.uploadBones(this.skin.device);
		}
		constructor(skin){
				this._dirty = true;
				this._rootBone = null;
				this._skinUpdateIndex = -1;
				this._updateBeforeCull = true;
				if (skin) {
						this.initSkin(skin);
				}
		}
}

class SkinBatchInstance extends SkinInstance {
		updateMatrices(rootNode, skinUpdateIndex) {}
		updateMatrixPalette(rootNode, skinUpdateIndex) {
				var mp = this.matrixPalette;
				var count = this.bones.length;
				for(var i = 0; i < count; i++){
						var pe = this.bones[i].getWorldTransform().data;
						var base = i * 12;
						mp[base] = pe[0];
						mp[base + 1] = pe[4];
						mp[base + 2] = pe[8];
						mp[base + 3] = pe[12];
						mp[base + 4] = pe[1];
						mp[base + 5] = pe[5];
						mp[base + 6] = pe[9];
						mp[base + 7] = pe[13];
						mp[base + 8] = pe[2];
						mp[base + 9] = pe[6];
						mp[base + 10] = pe[10];
						mp[base + 11] = pe[14];
				}
				this.uploadBones(this.device);
		}
		constructor(device, nodes, rootNode){
				super();
				var numBones = nodes.length;
				this.init(device, numBones);
				this.device = device;
				this.rootNode = rootNode;
				this.bones = nodes;
		}
}

var id$3 = 0;
class GeometryData {
		initDefaults() {
				this.recreate = false;
				this.verticesUsage = BUFFER_STATIC;
				this.indicesUsage = BUFFER_STATIC;
				this.maxVertices = 0;
				this.maxIndices = 0;
				this.vertexCount = 0;
				this.indexCount = 0;
				this.vertexStreamsUpdated = false;
				this.indexStreamUpdated = false;
				this.vertexStreamDictionary = {};
				this.indices = null;
		}
		_changeVertexCount(count, semantic) {
				if (!this.vertexCount) {
						this.vertexCount = count;
				}
		}
		constructor(){
				this.initDefaults();
		}
}
GeometryData.DEFAULT_COMPONENTS_POSITION = 3;
GeometryData.DEFAULT_COMPONENTS_NORMAL = 3;
GeometryData.DEFAULT_COMPONENTS_UV = 2;
GeometryData.DEFAULT_COMPONENTS_COLORS = 4;
class GeometryVertexStream {
		constructor(data, componentCount, dataType, dataTypeNormalize, asInt){
				this.data = data;
				this.componentCount = componentCount;
				this.dataType = dataType;
				this.dataTypeNormalize = dataTypeNormalize;
				this.asInt = asInt;
		}
}
class Mesh extends RefCountedObject {
		static fromGeometry(graphicsDevice, geometry, options) {
				if (options === void 0) options = {};
				var mesh = new Mesh(graphicsDevice, options);
				var { positions, normals, tangents, colors, uvs, uvs1, blendIndices, blendWeights, indices } = geometry;
				if (positions) {
						mesh.setPositions(positions);
				}
				if (normals) {
						mesh.setNormals(normals);
				}
				if (tangents) {
						mesh.setVertexStream(SEMANTIC_TANGENT, tangents, 4);
				}
				if (colors) {
						mesh.setColors32(colors);
				}
				if (uvs) {
						mesh.setUvs(0, uvs);
				}
				if (uvs1) {
						mesh.setUvs(1, uvs1);
				}
				if (blendIndices) {
						mesh.setVertexStream(SEMANTIC_BLENDINDICES, blendIndices, 4, blendIndices.length / 4, TYPE_UINT8);
				}
				if (blendWeights) {
						mesh.setVertexStream(SEMANTIC_BLENDWEIGHT, blendWeights, 4);
				}
				if (indices) {
						mesh.setIndices(indices);
				}
				mesh.update();
				return mesh;
		}
		set morph(morph) {
				if (morph !== this._morph) {
						if (this._morph) {
								this._morph.decRefCount();
						}
						this._morph = morph;
						if (morph) {
								morph.incRefCount();
						}
				}
		}
		get morph() {
				return this._morph;
		}
		set aabb(aabb) {
				this._aabb = aabb;
				this._aabbVer++;
		}
		get aabb() {
				return this._aabb;
		}
		destroy() {
				var morph = this.morph;
				if (morph) {
						this.morph = null;
						if (morph.refCount < 1) {
								morph.destroy();
						}
				}
				if (this.vertexBuffer) {
						this.vertexBuffer.destroy();
						this.vertexBuffer = null;
				}
				for(var j = 0; j < this.indexBuffer.length; j++){
						this._destroyIndexBuffer(j);
				}
				this.indexBuffer.length = 0;
				this._geometryData = null;
		}
		_destroyIndexBuffer(index) {
				if (this.indexBuffer[index]) {
						this.indexBuffer[index].destroy();
						this.indexBuffer[index] = null;
				}
		}
		_initBoneAabbs(morphTargets) {
				this.boneAabb = [];
				this.boneUsed = [];
				var x, y, z;
				var bMax, bMin;
				var boneMin = [];
				var boneMax = [];
				var boneUsed = this.boneUsed;
				var numBones = this.skin.boneNames.length;
				var maxMorphX, maxMorphY, maxMorphZ;
				for(var i = 0; i < numBones; i++){
						boneMin[i] = new Vec3(Number.MAX_VALUE, Number.MAX_VALUE, Number.MAX_VALUE);
						boneMax[i] = new Vec3(-Number.MAX_VALUE, -Number.MAX_VALUE, -Number.MAX_VALUE);
				}
				var iterator = new VertexIterator(this.vertexBuffer);
				var posElement = iterator.element[SEMANTIC_POSITION];
				var weightsElement = iterator.element[SEMANTIC_BLENDWEIGHT];
				var indicesElement = iterator.element[SEMANTIC_BLENDINDICES];
				var numVerts = this.vertexBuffer.numVertices;
				for(var j = 0; j < numVerts; j++){
						for(var k = 0; k < 4; k++){
								var boneWeight = weightsElement.array[weightsElement.index + k];
								if (boneWeight > 0) {
										var boneIndex = indicesElement.array[indicesElement.index + k];
										boneUsed[boneIndex] = true;
										x = posElement.array[posElement.index];
										y = posElement.array[posElement.index + 1];
										z = posElement.array[posElement.index + 2];
										bMax = boneMax[boneIndex];
										bMin = boneMin[boneIndex];
										if (bMin.x > x) bMin.x = x;
										if (bMin.y > y) bMin.y = y;
										if (bMin.z > z) bMin.z = z;
										if (bMax.x < x) bMax.x = x;
										if (bMax.y < y) bMax.y = y;
										if (bMax.z < z) bMax.z = z;
										if (morphTargets) {
												var minMorphX = maxMorphX = x;
												var minMorphY = maxMorphY = y;
												var minMorphZ = maxMorphZ = z;
												for(var l = 0; l < morphTargets.length; l++){
														var target = morphTargets[l];
														var dx = target.deltaPositions[j * 3];
														var dy = target.deltaPositions[j * 3 + 1];
														var dz = target.deltaPositions[j * 3 + 2];
														if (dx < 0) {
																minMorphX += dx;
														} else {
																maxMorphX += dx;
														}
														if (dy < 0) {
																minMorphY += dy;
														} else {
																maxMorphY += dy;
														}
														if (dz < 0) {
																minMorphZ += dz;
														} else {
																maxMorphZ += dz;
														}
												}
												if (bMin.x > minMorphX) bMin.x = minMorphX;
												if (bMin.y > minMorphY) bMin.y = minMorphY;
												if (bMin.z > minMorphZ) bMin.z = minMorphZ;
												if (bMax.x < maxMorphX) bMax.x = maxMorphX;
												if (bMax.y < maxMorphY) bMax.y = maxMorphY;
												if (bMax.z < maxMorphZ) bMax.z = maxMorphZ;
										}
								}
						}
						iterator.next();
				}
				var positionElement = this.vertexBuffer.getFormat().elements.find((e)=>e.name === SEMANTIC_POSITION);
				if (positionElement && positionElement.normalize) {
						var func = (()=>{
								switch(positionElement.dataType){
										case TYPE_INT8:
												return (x)=>Math.max(x / 127.0, -1);
										case TYPE_UINT8:
												return (x)=>x / 255.0;
										case TYPE_INT16:
												return (x)=>Math.max(x / 32767.0, -1);
										case TYPE_UINT16:
												return (x)=>x / 65535.0;
										default:
												return (x)=>x;
								}
						})();
						for(var i1 = 0; i1 < numBones; i1++){
								if (boneUsed[i1]) {
										var min = boneMin[i1];
										var max = boneMax[i1];
										min.set(func(min.x), func(min.y), func(min.z));
										max.set(func(max.x), func(max.y), func(max.z));
								}
						}
				}
				for(var i2 = 0; i2 < numBones; i2++){
						var aabb = new BoundingBox();
						aabb.setMinMax(boneMin[i2], boneMax[i2]);
						this.boneAabb.push(aabb);
				}
		}
		_initGeometryData() {
				if (!this._geometryData) {
						this._geometryData = new GeometryData();
						if (this.vertexBuffer) {
								this._geometryData.vertexCount = this.vertexBuffer.numVertices;
								this._geometryData.maxVertices = this.vertexBuffer.numVertices;
						}
						if (this.indexBuffer.length > 0 && this.indexBuffer[0]) {
								this._geometryData.indexCount = this.indexBuffer[0].numIndices;
								this._geometryData.maxIndices = this.indexBuffer[0].numIndices;
						}
				}
		}
		clear(verticesDynamic, indicesDynamic, maxVertices, maxIndices) {
				if (maxVertices === void 0) maxVertices = 0;
				if (maxIndices === void 0) maxIndices = 0;
				this._initGeometryData();
				this._geometryData.initDefaults();
				this._geometryData.recreate = true;
				this._geometryData.maxVertices = maxVertices;
				this._geometryData.maxIndices = maxIndices;
				this._geometryData.verticesUsage = verticesDynamic ? BUFFER_STATIC : BUFFER_DYNAMIC;
				this._geometryData.indicesUsage = indicesDynamic ? BUFFER_STATIC : BUFFER_DYNAMIC;
		}
		setVertexStream(semantic, data, componentCount, numVertices, dataType, dataTypeNormalize, asInt) {
				if (dataType === void 0) dataType = TYPE_FLOAT32;
				if (dataTypeNormalize === void 0) dataTypeNormalize = false;
				if (asInt === void 0) asInt = false;
				this._initGeometryData();
				var vertexCount = numVertices || data.length / componentCount;
				this._geometryData._changeVertexCount(vertexCount, semantic);
				this._geometryData.vertexStreamsUpdated = true;
				this._geometryData.vertexStreamDictionary[semantic] = new GeometryVertexStream(data, componentCount, dataType, dataTypeNormalize, asInt);
		}
		getVertexStream(semantic, data) {
				var count = 0;
				var done = false;
				if (this._geometryData) {
						var stream = this._geometryData.vertexStreamDictionary[semantic];
						if (stream) {
								done = true;
								count = this._geometryData.vertexCount;
								if (ArrayBuffer.isView(data)) {
										data.set(stream.data);
								} else {
										data.length = 0;
										data.push(stream.data);
								}
						}
				}
				if (!done) {
						if (this.vertexBuffer) {
								var iterator = new VertexIterator(this.vertexBuffer);
								count = iterator.readData(semantic, data);
						}
				}
				return count;
		}
		setPositions(positions, componentCount, numVertices) {
				if (componentCount === void 0) componentCount = GeometryData.DEFAULT_COMPONENTS_POSITION;
				this.setVertexStream(SEMANTIC_POSITION, positions, componentCount, numVertices, TYPE_FLOAT32, false);
		}
		setNormals(normals, componentCount, numVertices) {
				if (componentCount === void 0) componentCount = GeometryData.DEFAULT_COMPONENTS_NORMAL;
				this.setVertexStream(SEMANTIC_NORMAL, normals, componentCount, numVertices, TYPE_FLOAT32, false);
		}
		setUvs(channel, uvs, componentCount, numVertices) {
				if (componentCount === void 0) componentCount = GeometryData.DEFAULT_COMPONENTS_UV;
				this.setVertexStream(SEMANTIC_TEXCOORD + channel, uvs, componentCount, numVertices, TYPE_FLOAT32, false);
		}
		setColors(colors, componentCount, numVertices) {
				if (componentCount === void 0) componentCount = GeometryData.DEFAULT_COMPONENTS_COLORS;
				this.setVertexStream(SEMANTIC_COLOR, colors, componentCount, numVertices, TYPE_FLOAT32, false);
		}
		setColors32(colors, numVertices) {
				this.setVertexStream(SEMANTIC_COLOR, colors, GeometryData.DEFAULT_COMPONENTS_COLORS, numVertices, TYPE_UINT8, true);
		}
		setIndices(indices, numIndices) {
				this._initGeometryData();
				this._geometryData.indexStreamUpdated = true;
				this._geometryData.indices = indices;
				this._geometryData.indexCount = numIndices || indices.length;
		}
		getPositions(positions) {
				return this.getVertexStream(SEMANTIC_POSITION, positions);
		}
		getNormals(normals) {
				return this.getVertexStream(SEMANTIC_NORMAL, normals);
		}
		getUvs(channel, uvs) {
				return this.getVertexStream(SEMANTIC_TEXCOORD + channel, uvs);
		}
		getColors(colors) {
				return this.getVertexStream(SEMANTIC_COLOR, colors);
		}
		getIndices(indices) {
				var count = 0;
				if (this._geometryData && this._geometryData.indices) {
						var streamIndices = this._geometryData.indices;
						count = this._geometryData.indexCount;
						if (ArrayBuffer.isView(indices)) {
								indices.set(streamIndices);
						} else {
								indices.length = 0;
								for(var i = 0, il = streamIndices.length; i < il; i++){
										indices.push(streamIndices[i]);
								}
						}
				} else {
						if (this.indexBuffer.length > 0 && this.indexBuffer[0]) {
								var indexBuffer = this.indexBuffer[0];
								count = indexBuffer.readData(indices);
						}
				}
				return count;
		}
		update(primitiveType, updateBoundingBox) {
				if (primitiveType === void 0) primitiveType = PRIMITIVE_TRIANGLES;
				if (updateBoundingBox === void 0) updateBoundingBox = true;
				if (this._geometryData) {
						if (updateBoundingBox) {
								var stream = this._geometryData.vertexStreamDictionary[SEMANTIC_POSITION];
								if (stream) {
										if (stream.componentCount === 3) {
												this._aabb.compute(stream.data, this._geometryData.vertexCount);
												this._aabbVer++;
										}
								}
						}
						var destroyVB = this._geometryData.recreate;
						if (this._geometryData.vertexCount > this._geometryData.maxVertices) {
								destroyVB = true;
								this._geometryData.maxVertices = this._geometryData.vertexCount;
						}
						if (destroyVB) {
								if (this.vertexBuffer) {
										this.vertexBuffer.destroy();
										this.vertexBuffer = null;
								}
						}
						var destroyIB = this._geometryData.recreate;
						if (this._geometryData.indexCount > this._geometryData.maxIndices) {
								destroyIB = true;
								this._geometryData.maxIndices = this._geometryData.indexCount;
						}
						if (destroyIB) {
								if (this.indexBuffer.length > 0 && this.indexBuffer[0]) {
										this.indexBuffer[0].destroy();
										this.indexBuffer[0] = null;
								}
						}
						if (this._geometryData.vertexStreamsUpdated) {
								this._updateVertexBuffer();
						}
						if (this._geometryData.indexStreamUpdated) {
								this._updateIndexBuffer();
						}
						this.primitive[0].type = primitiveType;
						if (this.indexBuffer.length > 0 && this.indexBuffer[0]) {
								if (this._geometryData.indexStreamUpdated) {
										this.primitive[0].count = this._geometryData.indexCount;
										this.primitive[0].indexed = true;
								}
						} else {
								if (this._geometryData.vertexStreamsUpdated) {
										this.primitive[0].count = this._geometryData.vertexCount;
										this.primitive[0].indexed = false;
								}
						}
						this._geometryData.vertexCount = 0;
						this._geometryData.indexCount = 0;
						this._geometryData.vertexStreamsUpdated = false;
						this._geometryData.indexStreamUpdated = false;
						this._geometryData.recreate = false;
						this.updateRenderStates();
				}
		}
		_buildVertexFormat(vertexCount) {
				var vertexDesc = [];
				for(var semantic in this._geometryData.vertexStreamDictionary){
						var stream = this._geometryData.vertexStreamDictionary[semantic];
						vertexDesc.push({
								semantic: semantic,
								components: stream.componentCount,
								type: stream.dataType,
								normalize: stream.dataTypeNormalize,
								asInt: stream.asInt
						});
				}
				return new VertexFormat(this.device, vertexDesc, vertexCount);
		}
		_updateVertexBuffer() {
				if (!this.vertexBuffer) {
						var allocateVertexCount = this._geometryData.maxVertices;
						var format = this._buildVertexFormat(allocateVertexCount);
						this.vertexBuffer = new VertexBuffer(this.device, format, allocateVertexCount, {
								usage: this._geometryData.verticesUsage,
								storage: this._storageVertex
						});
				}
				var iterator = new VertexIterator(this.vertexBuffer);
				var numVertices = this._geometryData.vertexCount;
				for(var semantic in this._geometryData.vertexStreamDictionary){
						var stream = this._geometryData.vertexStreamDictionary[semantic];
						iterator.writeData(semantic, stream.data, numVertices);
						delete this._geometryData.vertexStreamDictionary[semantic];
				}
				iterator.end();
		}
		_updateIndexBuffer() {
				if (this.indexBuffer.length <= 0 || !this.indexBuffer[0]) {
						var maxVertices = this._geometryData.maxVertices;
						var createFormat = maxVertices > 0xffff || maxVertices === 0 ? INDEXFORMAT_UINT32 : INDEXFORMAT_UINT16;
						var options = this._storageIndex ? {
								storage: true
						} : undefined;
						this.indexBuffer[0] = new IndexBuffer(this.device, createFormat, this._geometryData.maxIndices, this._geometryData.indicesUsage, undefined, options);
				}
				var srcIndices = this._geometryData.indices;
				if (srcIndices) {
						var indexBuffer = this.indexBuffer[0];
						indexBuffer.writeData(srcIndices, this._geometryData.indexCount);
						this._geometryData.indices = null;
				}
		}
		prepareRenderState(renderStyle) {
				if (renderStyle === RENDERSTYLE_WIREFRAME) {
						this.generateWireframe();
				} else if (renderStyle === RENDERSTYLE_POINTS) {
						this.primitive[RENDERSTYLE_POINTS] = {
								type: PRIMITIVE_POINTS,
								base: 0,
								count: this.vertexBuffer ? this.vertexBuffer.numVertices : 0,
								indexed: false
						};
				}
		}
		updateRenderStates() {
				if (this.primitive[RENDERSTYLE_POINTS]) {
						this.prepareRenderState(RENDERSTYLE_POINTS);
				}
				if (this.primitive[RENDERSTYLE_WIREFRAME]) {
						this.prepareRenderState(RENDERSTYLE_WIREFRAME);
				}
		}
		generateWireframe() {
				this._destroyIndexBuffer(RENDERSTYLE_WIREFRAME);
				var numVertices = this.vertexBuffer.numVertices;
				var lines = [];
				var format;
				if (this.indexBuffer.length > 0 && this.indexBuffer[0]) {
						var offsets = [
								[
										0,
										1
								],
								[
										1,
										2
								],
								[
										2,
										0
								]
						];
						var base = this.primitive[RENDERSTYLE_SOLID].base;
						var count = this.primitive[RENDERSTYLE_SOLID].count;
						var indexBuffer = this.indexBuffer[RENDERSTYLE_SOLID];
						var srcIndices = new typedArrayIndexFormats[indexBuffer.format](indexBuffer.storage);
						var seen = new Set();
						for(var j = base; j < base + count; j += 3){
								for(var k = 0; k < 3; k++){
										var i1 = srcIndices[j + offsets[k][0]];
										var i2 = srcIndices[j + offsets[k][1]];
										var hash = i1 > i2 ? i2 * numVertices + i1 : i1 * numVertices + i2;
										if (!seen.has(hash)) {
												seen.add(hash);
												lines.push(i1, i2);
										}
								}
						}
						format = indexBuffer.format;
				} else {
						for(var i = 0; i < numVertices; i += 3){
								lines.push(i, i + 1, i + 1, i + 2, i + 2, i);
						}
						format = lines.length > 65535 ? INDEXFORMAT_UINT32 : INDEXFORMAT_UINT16;
				}
				var wireBuffer = new IndexBuffer(this.vertexBuffer.device, format, lines.length);
				var dstIndices = new typedArrayIndexFormats[wireBuffer.format](wireBuffer.storage);
				dstIndices.set(lines);
				wireBuffer.unlock();
				this.primitive[RENDERSTYLE_WIREFRAME] = {
						type: PRIMITIVE_LINES,
						base: 0,
						count: lines.length,
						indexed: true
				};
				this.indexBuffer[RENDERSTYLE_WIREFRAME] = wireBuffer;
		}
		constructor(graphicsDevice, options){
				super(), this.indexBuffer = [
						null
				], this.vertexBuffer = null, this.primitive = [
						{
								type: 0,
								base: 0,
								count: 0
						}
				], this.skin = null, this.boneAabb = null, this._aabbVer = 0, this._aabb = new BoundingBox(), this._geometryData = null, this._morph = null, this._storageIndex = false, this._storageVertex = false;
				this.id = id$3++;
				this.device = graphicsDevice;
				this._storageIndex = (options == null ? void 0 : options.storageIndex) || false;
				this._storageVertex = (options == null ? void 0 : options.storageVertex) || false;
		}
}

var defaultMaterialDeviceCache = new DeviceCache();
function getDefaultMaterial(device) {
		var material = defaultMaterialDeviceCache.get(device);
		return material;
}
function setDefaultMaterial(device, material) {
		defaultMaterialDeviceCache.get(device, ()=>{
				return material;
		});
}

class RefCountedCache {
		destroy() {
				this.cache.forEach((refCount, object)=>{
						object.destroy();
				});
				this.cache.clear();
		}
		incRef(object) {
				var refCount = (this.cache.get(object) || 0) + 1;
				this.cache.set(object, refCount);
		}
		decRef(object) {
				if (object) {
						var refCount = this.cache.get(object);
						if (refCount) {
								refCount--;
								if (refCount === 0) {
										this.cache.delete(object);
										object.destroy();
								} else {
										this.cache.set(object, refCount);
								}
						}
				}
		}
		constructor(){
				this.cache = new Map();
		}
}

class LightmapCache {
		static incRef(texture) {
				this.cache.incRef(texture);
		}
		static decRef(texture) {
				this.cache.decRef(texture);
		}
		static destroy() {
				this.cache.destroy();
		}
}
LightmapCache.cache = new RefCountedCache();

var id$2 = 0;
var _tmpAabb = new BoundingBox();
var _tempBoneAabb = new BoundingBox();
var _tempSphere = new BoundingSphere();
var _meshSet = new Set();
var lookupHashes = new Uint32Array(4);
class InstancingData {
		destroy() {
				if (this._destroyVertexBuffer) {
						var _this_vertexBuffer;
						(_this_vertexBuffer = this.vertexBuffer) == null ? void 0 : _this_vertexBuffer.destroy();
				}
				this.vertexBuffer = null;
		}
		constructor(numObjects){
				this.vertexBuffer = null;
				this._destroyVertexBuffer = false;
				this.count = numObjects;
		}
}
class ShaderInstance {
		getBindGroup(device) {
				if (!this.bindGroup) {
						var shader = this.shader;
						var bindGroupFormat = shader.meshBindGroupFormat;
						this.bindGroup = new BindGroup(device, bindGroupFormat);
				}
				return this.bindGroup;
		}
		getUniformBuffer(device) {
				if (!this.uniformBuffer) {
						var shader = this.shader;
						var ubFormat = shader.meshUniformBufferFormat;
						this.uniformBuffer = new UniformBuffer(device, ubFormat, false);
				}
				return this.uniformBuffer;
		}
		destroy() {
				var _this_bindGroup, _this_uniformBuffer;
				(_this_bindGroup = this.bindGroup) == null ? void 0 : _this_bindGroup.destroy();
				this.bindGroup = null;
				(_this_uniformBuffer = this.uniformBuffer) == null ? void 0 : _this_uniformBuffer.destroy();
				this.uniformBuffer = null;
		}
		constructor(){
				this.bindGroup = null;
				this.uniformBuffer = null;
		}
}
class MeshInstance {
		set drawBucket(bucket) {
				this._drawBucket = Math.floor(bucket) & 0xff;
				this.updateKey();
		}
		get drawBucket() {
				return this._drawBucket;
		}
		set renderStyle(renderStyle) {
				this._renderStyle = renderStyle;
				this.mesh.prepareRenderState(renderStyle);
		}
		get renderStyle() {
				return this._renderStyle;
		}
		set mesh(mesh) {
				if (mesh === this._mesh) {
						return;
				}
				if (this._mesh) {
						this._mesh.decRefCount();
				}
				this._mesh = mesh;
				if (mesh) {
						mesh.incRefCount();
				}
		}
		get mesh() {
				return this._mesh;
		}
		set aabb(aabb) {
				this._aabb = aabb;
		}
		get aabb() {
				if (!this._updateAabb) {
						return this._aabb;
				}
				if (this._updateAabbFunc) {
						return this._updateAabbFunc(this._aabb);
				}
				var localAabb = this._customAabb;
				var toWorldSpace = !!localAabb;
				if (!localAabb) {
						localAabb = _tmpAabb;
						if (this.skinInstance) {
								if (!this.mesh.boneAabb) {
										var morphTargets = this._morphInstance ? this._morphInstance.morph._targets : null;
										this.mesh._initBoneAabbs(morphTargets);
								}
								var boneUsed = this.mesh.boneUsed;
								var first = true;
								for(var i = 0; i < this.mesh.boneAabb.length; i++){
										if (boneUsed[i]) {
												_tempBoneAabb.setFromTransformedAabb(this.mesh.boneAabb[i], this.skinInstance.matrices[i]);
												if (first) {
														first = false;
														localAabb.center.copy(_tempBoneAabb.center);
														localAabb.halfExtents.copy(_tempBoneAabb.halfExtents);
												} else {
														localAabb.add(_tempBoneAabb);
												}
										}
								}
								toWorldSpace = true;
						} else if (this.node._aabbVer !== this._aabbVer || this.mesh._aabbVer !== this._aabbMeshVer) {
								if (this.mesh) {
										localAabb.center.copy(this.mesh.aabb.center);
										localAabb.halfExtents.copy(this.mesh.aabb.halfExtents);
								} else {
										localAabb.center.set(0, 0, 0);
										localAabb.halfExtents.set(0, 0, 0);
								}
								if (this.mesh && this.mesh.morph) {
										var morphAabb = this.mesh.morph.aabb;
										localAabb._expand(morphAabb.getMin(), morphAabb.getMax());
								}
								toWorldSpace = true;
								this._aabbVer = this.node._aabbVer;
								this._aabbMeshVer = this.mesh._aabbVer;
						}
				}
				if (toWorldSpace) {
						this._aabb.setFromTransformedAabb(localAabb, this.node.getWorldTransform());
				}
				return this._aabb;
		}
		clearShaders() {
				this._shaderCache.forEach((shaderInstance)=>{
						shaderInstance.destroy();
				});
				this._shaderCache.clear();
		}
		getShaderInstance(shaderPass, lightHash, scene, cameraShaderParams, viewUniformFormat, viewBindGroupFormat, sortedLights) {
				var shaderDefs = this._shaderDefs;
				lookupHashes[0] = shaderPass;
				lookupHashes[1] = lightHash;
				lookupHashes[2] = shaderDefs;
				lookupHashes[3] = cameraShaderParams.hash;
				var hash = hash32Fnv1a(lookupHashes);
				var shaderInstance = this._shaderCache.get(hash);
				if (!shaderInstance) {
						var mat = this._material;
						shaderInstance = new ShaderInstance();
						shaderInstance.shader = mat.variants.get(hash);
						shaderInstance.hashes = new Uint32Array(lookupHashes);
						if (!shaderInstance.shader) {
								var _this_mesh_vertexBuffer;
								var shader = mat.getShaderVariant({
										device: this.mesh.device,
										scene: scene,
										objDefs: shaderDefs,
										cameraShaderParams: cameraShaderParams,
										pass: shaderPass,
										sortedLights: sortedLights,
										viewUniformFormat: viewUniformFormat,
										viewBindGroupFormat: viewBindGroupFormat,
										vertexFormat: (_this_mesh_vertexBuffer = this.mesh.vertexBuffer) == null ? void 0 : _this_mesh_vertexBuffer.format
								});
								mat.variants.set(hash, shader);
								shaderInstance.shader = shader;
						}
						this._shaderCache.set(hash, shaderInstance);
				}
				return shaderInstance;
		}
		set material(material) {
				this.clearShaders();
				var prevMat = this._material;
				if (prevMat) {
						prevMat.removeMeshInstanceRef(this);
				}
				this._material = material;
				if (material) {
						material.addMeshInstanceRef(this);
						this.transparent = material.transparent;
						this.updateKey();
				}
		}
		get material() {
				return this._material;
		}
		_updateShaderDefs(shaderDefs) {
				if (shaderDefs !== this._shaderDefs) {
						this._shaderDefs = shaderDefs;
						this.clearShaders();
				}
		}
		set calculateSortDistance(calculateSortDistance) {
				this._calculateSortDistance = calculateSortDistance;
		}
		get calculateSortDistance() {
				return this._calculateSortDistance;
		}
		set receiveShadow(val) {
				if (this._receiveShadow !== val) {
						this._receiveShadow = val;
						this._updateShaderDefs(val ? this._shaderDefs & -2 : this._shaderDefs | SHADERDEF_NOSHADOW);
				}
		}
		get receiveShadow() {
				return this._receiveShadow;
		}
		set batching(val) {
				this._updateShaderDefs(val ? this._shaderDefs | SHADERDEF_BATCH : this._shaderDefs & -16385);
		}
		get batching() {
				return (this._shaderDefs & SHADERDEF_BATCH) !== 0;
		}
		set skinInstance(val) {
				this._skinInstance = val;
				this._updateShaderDefs(val ? this._shaderDefs | SHADERDEF_SKIN : this._shaderDefs & -3);
				this._setupSkinUpdate();
		}
		get skinInstance() {
				return this._skinInstance;
		}
		set morphInstance(val) {
				var _this__morphInstance;
				(_this__morphInstance = this._morphInstance) == null ? void 0 : _this__morphInstance.destroy();
				this._morphInstance = val;
				var shaderDefs = this._shaderDefs;
				shaderDefs = val && val.morph.morphPositions ? shaderDefs | SHADERDEF_MORPH_POSITION : shaderDefs & -1025;
				shaderDefs = val && val.morph.morphNormals ? shaderDefs | SHADERDEF_MORPH_NORMAL : shaderDefs & -2049;
				shaderDefs = val && val.morph.intRenderFormat ? shaderDefs | SHADERDEF_MORPH_TEXTURE_BASED_INT : shaderDefs & -8193;
				this._updateShaderDefs(shaderDefs);
		}
		get morphInstance() {
				return this._morphInstance;
		}
		set screenSpace(val) {
				if (this._screenSpace !== val) {
						this._screenSpace = val;
						this._updateShaderDefs(val ? this._shaderDefs | SHADERDEF_SCREENSPACE : this._shaderDefs & -257);
				}
		}
		get screenSpace() {
				return this._screenSpace;
		}
		set key(val) {
				this._sortKeyForward = val;
		}
		get key() {
				return this._sortKeyForward;
		}
		set mask(val) {
				var toggles = this._shaderDefs & 0x0000FFFF;
				this._updateShaderDefs(toggles | val << 16);
		}
		get mask() {
				return this._shaderDefs >> 16;
		}
		set instancingCount(value) {
				if (this.instancingData) {
						this.instancingData.count = value;
				}
		}
		get instancingCount() {
				return this.instancingData ? this.instancingData.count : 0;
		}
		destroy() {
				var _this__skinInstance, _this_morphInstance, _this_instancingData;
				var mesh = this.mesh;
				if (mesh) {
						this.mesh = null;
						if (mesh.refCount < 1) {
								mesh.destroy();
						}
				}
				this.setRealtimeLightmap(MeshInstance.lightmapParamNames[0], null);
				this.setRealtimeLightmap(MeshInstance.lightmapParamNames[1], null);
				(_this__skinInstance = this._skinInstance) == null ? void 0 : _this__skinInstance.destroy();
				this._skinInstance = null;
				(_this_morphInstance = this.morphInstance) == null ? void 0 : _this_morphInstance.destroy();
				this.morphInstance = null;
				this.clearShaders();
				this.material = null;
				(_this_instancingData = this.instancingData) == null ? void 0 : _this_instancingData.destroy();
		}
		static _prepareRenderStyleForArray(meshInstances, renderStyle) {
				if (meshInstances) {
						for(var i = 0; i < meshInstances.length; i++){
								meshInstances[i]._renderStyle = renderStyle;
								var mesh = meshInstances[i].mesh;
								if (!_meshSet.has(mesh)) {
										_meshSet.add(mesh);
										mesh.prepareRenderState(renderStyle);
								}
						}
						_meshSet.clear();
				}
		}
		_isVisible(camera) {
				if (this.visible) {
						if (this.isVisibleFunc) {
								return this.isVisibleFunc(camera);
						}
						_tempSphere.center = this.aabb.center;
						_tempSphere.radius = this._aabb.halfExtents.length();
						return camera.frustum.containsSphere(_tempSphere) > 0;
				}
				return false;
		}
		updateKey() {
				var { material } = this;
				this._sortKeyForward = this._drawBucket << 25 | (material.alphaToCoverage || material.alphaTest ? 0x1000000 : 0) | material.id & 0xffffff;
		}
		setInstancing(vertexBuffer, cull) {
				if (cull === void 0) cull = false;
				if (vertexBuffer) {
						this.instancingData = new InstancingData(vertexBuffer.numVertices);
						this.instancingData.vertexBuffer = vertexBuffer;
						vertexBuffer.format.instancing = true;
						this.cull = cull;
				} else {
						this.instancingData = null;
						this.cull = true;
				}
				this._updateShaderDefs(vertexBuffer ? this._shaderDefs | SHADERDEF_INSTANCING : this._shaderDefs & -33);
		}
		ensureMaterial(device) {
				if (!this.material) {
						this.material = getDefaultMaterial(device);
				}
		}
		clearParameters() {
				this.parameters = {};
		}
		getParameters() {
				return this.parameters;
		}
		getParameter(name) {
				return this.parameters[name];
		}
		setParameter(name, data, passFlags) {
				if (passFlags === void 0) passFlags = 0xFFFFFFFF;
				var param = this.parameters[name];
				if (param) {
						param.data = data;
						param.passFlags = passFlags;
				} else {
						this.parameters[name] = {
								scopeId: null,
								data: data,
								passFlags: passFlags
						};
				}
		}
		setRealtimeLightmap(name, texture) {
				var old = this.getParameter(name);
				if (old === texture) {
						return;
				}
				if (old) {
						LightmapCache.decRef(old.data);
				}
				if (texture) {
						LightmapCache.incRef(texture);
						this.setParameter(name, texture);
				} else {
						this.deleteParameter(name);
				}
		}
		deleteParameter(name) {
				if (this.parameters[name]) {
						delete this.parameters[name];
				}
		}
		setParameters(device, passFlag) {
				var parameters = this.parameters;
				for(var paramName in parameters){
						var parameter = parameters[paramName];
						if (parameter.passFlags & passFlag) {
								if (!parameter.scopeId) {
										parameter.scopeId = device.scope.resolve(paramName);
								}
								parameter.scopeId.setValue(parameter.data);
						}
				}
		}
		setLightmapped(value) {
				if (value) {
						this.mask = (this.mask | MASK_AFFECT_LIGHTMAPPED) & -6;
				} else {
						this.setRealtimeLightmap(MeshInstance.lightmapParamNames[0], null);
						this.setRealtimeLightmap(MeshInstance.lightmapParamNames[1], null);
						this._shaderDefs &= -4289;
						this.mask = (this.mask | MASK_AFFECT_DYNAMIC) & -7;
				}
		}
		setCustomAabb(aabb) {
				if (aabb) {
						if (this._customAabb) {
								this._customAabb.copy(aabb);
						} else {
								this._customAabb = aabb.clone();
						}
				} else {
						this._customAabb = null;
						this._aabbVer = -1;
				}
				this._setupSkinUpdate();
		}
		_setupSkinUpdate() {
				if (this._skinInstance) {
						this._skinInstance._updateBeforeCull = !this._customAabb;
				}
		}
		constructor(mesh, material, node = null){
				this.castShadow = false;
				this.cull = true;
				this.drawOrder = 0;
				this._drawBucket = 127;
				this.visible = true;
				this.visibleThisFrame = false;
				this.flipFacesFactor = 1;
				this.gsplatInstance = null;
				this.id = id$2++;
				this.isVisibleFunc = null;
				this.instancingData = null;
				this.parameters = {};
				this.pick = true;
				this.stencilFront = null;
				this.stencilBack = null;
				this.transparent = false;
				this._aabb = new BoundingBox();
				this._aabbVer = -1;
				this._aabbMeshVer = -1;
				this._customAabb = null;
				this._updateAabb = true;
				this._updateAabbFunc = null;
				this._sortKeyShadow = 0;
				this._sortKeyForward = 0;
				this._sortKeyDynamic = 0;
				this._layer = LAYER_WORLD;
				this._material = null;
				this._skinInstance = null;
				this._morphInstance = null;
				this._receiveShadow = true;
				this._renderStyle = RENDERSTYLE_SOLID;
				this._screenSpace = false;
				this._shaderCache = new Map();
				this._shaderDefs = MASK_AFFECT_DYNAMIC << 16;
				this._calculateSortDistance = null;
				this.node = node;
				this._mesh = mesh;
				mesh.incRefCount();
				this.material = material;
				if (mesh.vertexBuffer) {
						var format = mesh.vertexBuffer.format;
						this._shaderDefs |= format.hasUv0 ? SHADERDEF_UV0 : 0;
						this._shaderDefs |= format.hasUv1 ? SHADERDEF_UV1 : 0;
						this._shaderDefs |= format.hasColor ? SHADERDEF_VCOLOR : 0;
						this._shaderDefs |= format.hasTangents ? SHADERDEF_TANGENTS : 0;
				}
				this.updateKey();
		}
}
MeshInstance.lightmapParamNames = [
		'texture_lightMap',
		'texture_dirLightMap'
];

var _triFanIndices = [
		0,
		1,
		3,
		2,
		3,
		1
];
var _triStripIndices = [
		0,
		1,
		3,
		0,
		3,
		2
];
var mat3 = new Mat3();
function paramsIdentical(a, b) {
		if (a && !b) return false;
		if (!a && b) return false;
		a = a.data;
		b = b.data;
		if (a === b) return true;
		if (a instanceof Float32Array && b instanceof Float32Array) {
				if (a.length !== b.length) return false;
				for(var i = 0; i < a.length; i++){
						if (a[i] !== b[i]) return false;
				}
				return true;
		}
		return false;
}
function equalParamSets(params1, params2) {
		for(var param in params1){
				if (params1.hasOwnProperty(param) && !paramsIdentical(params1[param], params2[param])) {
						return false;
				}
		}
		for(var param1 in params2){
				if (params2.hasOwnProperty(param1) && !paramsIdentical(params2[param1], params1[param1])) {
						return false;
				}
		}
		return true;
}
function getScaleSign(mi) {
		return mi.node.worldTransform.scaleSign;
}
class BatchManager {
		destroy() {
				this.device = null;
				this.rootNode = null;
				this.scene = null;
				this._batchGroups = {};
				this._batchList = [];
				this._dirtyGroups = [];
		}
		addGroup(name, dynamic, maxAabbSize, id, layers) {
				if (id === undefined) {
						id = this._batchGroupCounter;
						this._batchGroupCounter++;
				}
				if (this._batchGroups[id]) {
						return undefined;
				}
				var group = new BatchGroup(id, name, dynamic, maxAabbSize, layers);
				this._batchGroups[id] = group;
				return group;
		}
		removeGroup(id) {
				if (!this._batchGroups[id]) {
						return;
				}
				var newBatchList = [];
				for(var i = 0; i < this._batchList.length; i++){
						if (this._batchList[i].batchGroupId === id) {
								this.destroyBatch(this._batchList[i]);
						} else {
								newBatchList.push(this._batchList[i]);
						}
				}
				this._batchList = newBatchList;
				this._removeModelsFromBatchGroup(this.rootNode, id);
				delete this._batchGroups[id];
		}
		markGroupDirty(id) {
				if (this._dirtyGroups.indexOf(id) < 0) {
						this._dirtyGroups.push(id);
				}
		}
		getGroupByName(name) {
				var groups = this._batchGroups;
				for(var group in groups){
						if (!groups.hasOwnProperty(group)) continue;
						if (groups[group].name === name) {
								return groups[group];
						}
				}
				return null;
		}
		getBatches(batchGroupId) {
				var results = [];
				var len = this._batchList.length;
				for(var i = 0; i < len; i++){
						var batch = this._batchList[i];
						if (batch.batchGroupId === batchGroupId) {
								results.push(batch);
						}
				}
				return results;
		}
		_removeModelsFromBatchGroup(node, id) {
				if (!node.enabled) return;
				if (node.model && node.model.batchGroupId === id) {
						node.model.batchGroupId = -1;
				}
				if (node.render && node.render.batchGroupId === id) {
						node.render.batchGroupId = -1;
				}
				if (node.element && node.element.batchGroupId === id) {
						node.element.batchGroupId = -1;
				}
				if (node.sprite && node.sprite.batchGroupId === id) {
						node.sprite.batchGroupId = -1;
				}
				for(var i = 0; i < node._children.length; i++){
						this._removeModelsFromBatchGroup(node._children[i], id);
				}
		}
		insert(type, groupId, node) {
				var group = this._batchGroups[groupId];
				if (group) {
						if (group._obj[type].indexOf(node) < 0) {
								group._obj[type].push(node);
								this.markGroupDirty(groupId);
						}
				}
		}
		remove(type, groupId, node) {
				var group = this._batchGroups[groupId];
				if (group) {
						var idx = group._obj[type].indexOf(node);
						if (idx >= 0) {
								group._obj[type].splice(idx, 1);
								this.markGroupDirty(groupId);
						}
				}
		}
		_extractRender(node, arr, group, groupMeshInstances) {
				if (node.render) {
						arr = groupMeshInstances[node.render.batchGroupId] = arr.concat(node.render.meshInstances);
						node.render.removeFromLayers();
				}
				return arr;
		}
		_extractModel(node, arr, group, groupMeshInstances) {
				if (node.model && node.model.model) {
						arr = groupMeshInstances[node.model.batchGroupId] = arr.concat(node.model.meshInstances);
						node.model.removeModelFromLayers();
				}
				return arr;
		}
		_extractElement(node, arr, group) {
				if (!node.element) return;
				var valid = false;
				if (node.element._text && node.element._text._model.meshInstances.length > 0) {
						arr.push(node.element._text._model.meshInstances[0]);
						node.element.removeModelFromLayers(node.element._text._model);
						valid = true;
				} else if (node.element._image) {
						arr.push(node.element._image._renderable.meshInstance);
						node.element.removeModelFromLayers(node.element._image._renderable.model);
						if (node.element._image._renderable.unmaskMeshInstance) {
								arr.push(node.element._image._renderable.unmaskMeshInstance);
								if (!node.element._image._renderable.unmaskMeshInstance.stencilFront || !node.element._image._renderable.unmaskMeshInstance.stencilBack) {
										node.element._dirtifyMask();
										node.element._onPrerender();
								}
						}
						valid = true;
				}
				if (valid) {
						group._ui = true;
				}
		}
		_collectAndRemoveMeshInstances(groupMeshInstances, groupIds) {
				for(var g = 0; g < groupIds.length; g++){
						var id = groupIds[g];
						var group = this._batchGroups[id];
						if (!group) continue;
						var arr = groupMeshInstances[id];
						if (!arr) arr = groupMeshInstances[id] = [];
						for(var m = 0; m < group._obj.model.length; m++){
								arr = this._extractModel(group._obj.model[m], arr, group, groupMeshInstances);
						}
						for(var r = 0; r < group._obj.render.length; r++){
								arr = this._extractRender(group._obj.render[r], arr, group, groupMeshInstances);
						}
						for(var e = 0; e < group._obj.element.length; e++){
								this._extractElement(group._obj.element[e], arr, group);
						}
						for(var s = 0; s < group._obj.sprite.length; s++){
								var node = group._obj.sprite[s];
								if (node.sprite && node.sprite._meshInstance && (group.dynamic || node.sprite.sprite._renderMode === SPRITE_RENDERMODE_SIMPLE)) {
										arr.push(node.sprite._meshInstance);
										node.sprite.removeModelFromLayers();
										group._sprite = true;
										node.sprite._batchGroup = group;
								}
						}
				}
		}
		generate(groupIds) {
				var groupMeshInstances = {};
				if (!groupIds) {
						groupIds = Object.keys(this._batchGroups);
				}
				var newBatchList = [];
				for(var i = 0; i < this._batchList.length; i++){
						if (groupIds.indexOf(this._batchList[i].batchGroupId) < 0) {
								newBatchList.push(this._batchList[i]);
								continue;
						}
						this.destroyBatch(this._batchList[i]);
				}
				this._batchList = newBatchList;
				this._collectAndRemoveMeshInstances(groupMeshInstances, groupIds);
				if (groupIds === this._dirtyGroups) {
						this._dirtyGroups.length = 0;
				} else {
						var newDirtyGroups = [];
						for(var i1 = 0; i1 < this._dirtyGroups.length; i1++){
								if (groupIds.indexOf(this._dirtyGroups[i1]) < 0) newDirtyGroups.push(this._dirtyGroups[i1]);
						}
						this._dirtyGroups = newDirtyGroups;
				}
				var group, lists, groupData, batch;
				for(var groupId in groupMeshInstances){
						if (!groupMeshInstances.hasOwnProperty(groupId)) continue;
						group = groupMeshInstances[groupId];
						groupData = this._batchGroups[groupId];
						if (!groupData) {
								continue;
						}
						lists = this.prepare(group, groupData.dynamic, groupData.maxAabbSize, groupData._ui || groupData._sprite);
						for(var i2 = 0; i2 < lists.length; i2++){
								batch = this.create(lists[i2], groupData.dynamic, parseInt(groupId, 10));
								if (batch) {
										batch.addToLayers(this.scene, groupData.layers);
								}
						}
				}
		}
		prepare(meshInstances, dynamic, maxAabbSize, translucent) {
				if (maxAabbSize === void 0) maxAabbSize = Number.POSITIVE_INFINITY;
				if (meshInstances.length === 0) return [];
				var halfMaxAabbSize = maxAabbSize * 0.5;
				var maxInstanceCount = 1024;
				var maxNumVertices = 0xffffffff;
				var aabb = new BoundingBox();
				var testAabb = new BoundingBox();
				var skipTranslucentAabb = null;
				var sf;
				var lists = [];
				var j = 0;
				if (translucent) {
						meshInstances.sort((a, b)=>{
								return a.drawOrder - b.drawOrder;
						});
				}
				var meshInstancesLeftA = meshInstances;
				var meshInstancesLeftB;
				var skipMesh = translucent ? function skipMesh(mi) {
						if (skipTranslucentAabb) {
								skipTranslucentAabb.add(mi.aabb);
						} else {
								skipTranslucentAabb = mi.aabb.clone();
						}
						meshInstancesLeftB.push(mi);
				} : function(mi) {
						meshInstancesLeftB.push(mi);
				};
				while(meshInstancesLeftA.length > 0){
						lists[j] = [
								meshInstancesLeftA[0]
						];
						meshInstancesLeftB = [];
						var material = meshInstancesLeftA[0].material;
						var layer = meshInstancesLeftA[0].layer;
						var defs = meshInstancesLeftA[0]._shaderDefs;
						var params = meshInstancesLeftA[0].parameters;
						var stencil = meshInstancesLeftA[0].stencilFront;
						var vertCount = meshInstancesLeftA[0].mesh.vertexBuffer.getNumVertices();
						var drawOrder = meshInstancesLeftA[0].drawOrder;
						aabb.copy(meshInstancesLeftA[0].aabb);
						var scaleSign = getScaleSign(meshInstancesLeftA[0]);
						var vertexFormatBatchingHash = meshInstancesLeftA[0].mesh.vertexBuffer.format.batchingHash;
						var indexed = meshInstancesLeftA[0].mesh.primitive[0].indexed;
						skipTranslucentAabb = null;
						for(var i = 1; i < meshInstancesLeftA.length; i++){
								var mi = meshInstancesLeftA[i];
								if (dynamic && lists[j].length >= maxInstanceCount) {
										meshInstancesLeftB = meshInstancesLeftB.concat(meshInstancesLeftA.slice(i));
										break;
								}
								if (material !== mi.material || layer !== mi.layer || vertexFormatBatchingHash !== mi.mesh.vertexBuffer.format.batchingHash || indexed !== mi.mesh.primitive[0].indexed || defs !== mi._shaderDefs || vertCount + mi.mesh.vertexBuffer.getNumVertices() > maxNumVertices) {
										skipMesh(mi);
										continue;
								}
								testAabb.copy(aabb);
								testAabb.add(mi.aabb);
								if (testAabb.halfExtents.x > halfMaxAabbSize || testAabb.halfExtents.y > halfMaxAabbSize || testAabb.halfExtents.z > halfMaxAabbSize) {
										skipMesh(mi);
										continue;
								}
								if (stencil) {
										if (!(sf = mi.stencilFront) || stencil.func !== sf.func || stencil.zpass !== sf.zpass) {
												skipMesh(mi);
												continue;
										}
								}
								if (scaleSign !== getScaleSign(mi)) {
										skipMesh(mi);
										continue;
								}
								if (!equalParamSets(params, mi.parameters)) {
										skipMesh(mi);
										continue;
								}
								if (translucent && skipTranslucentAabb && skipTranslucentAabb.intersects(mi.aabb) && mi.drawOrder !== drawOrder) {
										skipMesh(mi);
										continue;
								}
								aabb.add(mi.aabb);
								vertCount += mi.mesh.vertexBuffer.getNumVertices();
								lists[j].push(mi);
						}
						j++;
						meshInstancesLeftA = meshInstancesLeftB;
				}
				return lists;
		}
		collectBatchedMeshData(meshInstances, dynamic) {
				var streams = null;
				var batchNumVerts = 0;
				var batchNumIndices = 0;
				var material = null;
				for(var i = 0; i < meshInstances.length; i++){
						if (meshInstances[i].visible) {
								var mesh = meshInstances[i].mesh;
								var numVerts = mesh.vertexBuffer.numVertices;
								batchNumVerts += numVerts;
								if (mesh.primitive[0].indexed) {
										batchNumIndices += mesh.primitive[0].count;
								} else {
										var primitiveType = mesh.primitive[0].type;
										if (primitiveType === PRIMITIVE_TRIFAN || primitiveType === PRIMITIVE_TRISTRIP) {
												if (mesh.primitive[0].count === 4) {
														batchNumIndices += 6;
												}
										}
								}
								if (!streams) {
										material = meshInstances[i].material;
										streams = {};
										var elems = mesh.vertexBuffer.format.elements;
										for(var j = 0; j < elems.length; j++){
												var semantic = elems[j].name;
												streams[semantic] = {
														numComponents: elems[j].numComponents,
														dataType: elems[j].dataType,
														normalize: elems[j].normalize,
														count: 0
												};
										}
										if (dynamic) {
												streams[SEMANTIC_BLENDINDICES] = {
														numComponents: 1,
														dataType: TYPE_FLOAT32,
														normalize: false,
														count: 0
												};
										}
								}
						}
				}
				return {
						streams: streams,
						batchNumVerts: batchNumVerts,
						batchNumIndices: batchNumIndices,
						material: material
				};
		}
		create(meshInstances, dynamic, batchGroupId) {
				if (!this._init) {
						this.vertexFormats = {};
						this._init = true;
				}
				var stream = null;
				var semantic;
				var mesh, numVerts;
				var batch = null;
				var batchData = this.collectBatchedMeshData(meshInstances, dynamic);
				if (batchData.streams) {
						var streams = batchData.streams;
						var material = batchData.material;
						var batchNumVerts = batchData.batchNumVerts;
						var batchNumIndices = batchData.batchNumIndices;
						batch = new Batch(meshInstances, dynamic, batchGroupId);
						this._batchList.push(batch);
						var indexBase, numIndices, indexData;
						var verticesOffset = 0;
						var indexOffset = 0;
						var transform;
						var indexArrayType = batchNumVerts <= 0xffff ? Uint16Array : Uint32Array;
						var indices = new indexArrayType(batchNumIndices);
						for(semantic in streams){
								stream = streams[semantic];
								stream.typeArrayType = typedArrayTypes[stream.dataType];
								stream.elementByteSize = typedArrayTypesByteSize[stream.dataType];
								stream.buffer = new stream.typeArrayType(batchNumVerts * stream.numComponents);
						}
						for(var i = 0; i < meshInstances.length; i++){
								if (!meshInstances[i].visible) {
										continue;
								}
								mesh = meshInstances[i].mesh;
								numVerts = mesh.vertexBuffer.numVertices;
								if (!dynamic) {
										transform = meshInstances[i].node.getWorldTransform();
								}
								for(semantic in streams){
										if (semantic !== SEMANTIC_BLENDINDICES) {
												stream = streams[semantic];
												var subarray = new stream.typeArrayType(stream.buffer.buffer, stream.elementByteSize * stream.count);
												var totalComponents = mesh.getVertexStream(semantic, subarray) * stream.numComponents;
												stream.count += totalComponents;
												if (!dynamic && stream.numComponents >= 3) {
														if (semantic === SEMANTIC_POSITION) {
																var m = transform.data;
																var m0 = m[0];
																var m1 = m[1];
																var m2 = m[2];
																var m4 = m[4];
																var m5 = m[5];
																var m6 = m[6];
																var m8 = m[8];
																var m9 = m[9];
																var m10 = m[10];
																var m12 = m[12];
																var m13 = m[13];
																var m14 = m[14];
																var x = void 0, y = void 0, z = void 0;
																for(var j = 0; j < totalComponents; j += stream.numComponents){
																		x = subarray[j];
																		y = subarray[j + 1];
																		z = subarray[j + 2];
																		subarray[j] = x * m0 + y * m4 + z * m8 + m12;
																		subarray[j + 1] = x * m1 + y * m5 + z * m9 + m13;
																		subarray[j + 2] = x * m2 + y * m6 + z * m10 + m14;
																}
														} else if (semantic === SEMANTIC_NORMAL || semantic === SEMANTIC_TANGENT) {
																mat3.invertMat4(transform).transpose();
																var [m01, m11, m21, m3, m41, m51, m61, m7, m81] = mat3.data;
																var x1 = void 0, y1 = void 0, z1 = void 0;
																for(var j1 = 0; j1 < totalComponents; j1 += stream.numComponents){
																		x1 = subarray[j1];
																		y1 = subarray[j1 + 1];
																		z1 = subarray[j1 + 2];
																		subarray[j1] = x1 * m01 + y1 * m3 + z1 * m61;
																		subarray[j1 + 1] = x1 * m11 + y1 * m41 + z1 * m7;
																		subarray[j1 + 2] = x1 * m21 + y1 * m51 + z1 * m81;
																}
														}
												}
										}
								}
								if (dynamic) {
										stream = streams[SEMANTIC_BLENDINDICES];
										for(var j2 = 0; j2 < numVerts; j2++){
												stream.buffer[stream.count++] = i;
										}
								}
								if (mesh.primitive[0].indexed) {
										indexBase = mesh.primitive[0].base;
										numIndices = mesh.primitive[0].count;
										var srcFormat = mesh.indexBuffer[0].getFormat();
										indexData = new typedArrayIndexFormats[srcFormat](mesh.indexBuffer[0].storage);
								} else {
										var primitiveType = mesh.primitive[0].type;
										if (primitiveType === PRIMITIVE_TRIFAN || primitiveType === PRIMITIVE_TRISTRIP) {
												if (mesh.primitive[0].count === 4) {
														indexBase = 0;
														numIndices = 6;
														indexData = primitiveType === PRIMITIVE_TRIFAN ? _triFanIndices : _triStripIndices;
												} else {
														numIndices = 0;
														continue;
												}
										}
								}
								for(var j3 = 0; j3 < numIndices; j3++){
										indices[j3 + indexOffset] = indexData[indexBase + j3] + verticesOffset;
								}
								indexOffset += numIndices;
								verticesOffset += numVerts;
						}
						mesh = new Mesh(this.device);
						for(semantic in streams){
								stream = streams[semantic];
								mesh.setVertexStream(semantic, stream.buffer, stream.numComponents, undefined, stream.dataType, stream.normalize);
						}
						if (indices.length > 0) {
								mesh.setIndices(indices);
						}
						mesh.update(PRIMITIVE_TRIANGLES, false);
						if (dynamic) {
								material = material.clone();
								material.update();
						}
						var meshInstance = new MeshInstance(mesh, material, this.rootNode);
						meshInstance.castShadow = batch.origMeshInstances[0].castShadow;
						meshInstance.parameters = batch.origMeshInstances[0].parameters;
						meshInstance.layer = batch.origMeshInstances[0].layer;
						meshInstance._shaderDefs = batch.origMeshInstances[0]._shaderDefs;
						meshInstance.batching = true;
						meshInstance.cull = batch.origMeshInstances[0].cull;
						var batchGroup = this._batchGroups[batchGroupId];
						if (batchGroup && batchGroup._ui) {
								meshInstance.cull = false;
						}
						if (dynamic) {
								var nodes = [];
								for(var i1 = 0; i1 < batch.origMeshInstances.length; i1++){
										nodes.push(batch.origMeshInstances[i1].node);
								}
								meshInstance.skinInstance = new SkinBatchInstance(this.device, nodes, this.rootNode);
						}
						meshInstance._updateAabb = false;
						meshInstance.drawOrder = batch.origMeshInstances[0].drawOrder;
						meshInstance.stencilFront = batch.origMeshInstances[0].stencilFront;
						meshInstance.stencilBack = batch.origMeshInstances[0].stencilBack;
						meshInstance.flipFacesFactor = getScaleSign(batch.origMeshInstances[0]);
						meshInstance.castShadow = batch.origMeshInstances[0].castShadow;
						batch.meshInstance = meshInstance;
						batch.updateBoundingBox();
				}
				return batch;
		}
		updateAll() {
				if (this._dirtyGroups.length > 0) {
						this.generate(this._dirtyGroups);
				}
				for(var i = 0; i < this._batchList.length; i++){
						if (!this._batchList[i].dynamic) continue;
						this._batchList[i].updateBoundingBox();
				}
		}
		clone(batch, clonedMeshInstances) {
				var batch2 = new Batch(clonedMeshInstances, batch.dynamic, batch.batchGroupId);
				this._batchList.push(batch2);
				var nodes = [];
				for(var i = 0; i < clonedMeshInstances.length; i++){
						nodes.push(clonedMeshInstances[i].node);
				}
				batch2.meshInstance = new MeshInstance(batch.meshInstance.mesh, batch.meshInstance.material, batch.meshInstance.node);
				batch2.meshInstance._updateAabb = false;
				batch2.meshInstance.parameters = clonedMeshInstances[0].parameters;
				batch2.meshInstance.cull = clonedMeshInstances[0].cull;
				batch2.meshInstance.layer = clonedMeshInstances[0].layer;
				if (batch.dynamic) {
						batch2.meshInstance.skinInstance = new SkinBatchInstance(this.device, nodes, this.rootNode);
				}
				batch2.meshInstance.castShadow = batch.meshInstance.castShadow;
				return batch2;
		}
		destroyBatch(batch) {
				batch.destroy(this.scene, this._batchGroups[batch.batchGroupId].layers);
		}
		constructor(device, root, scene){
				this.device = device;
				this.rootNode = root;
				this.scene = scene;
				this._init = false;
				this._batchGroups = {};
				this._batchGroupCounter = 0;
				this._batchList = [];
				this._dirtyGroups = [];
		}
}

var _colorUniformName = 'uSceneColorMap';
class RenderPassColorGrab extends RenderPass {
		destroy() {
				super.destroy();
				this.releaseRenderTarget(this.colorRenderTarget);
		}
		shouldReallocate(targetRT, sourceTexture, sourceFormat) {
				var targetFormat = targetRT == null ? void 0 : targetRT.colorBuffer.format;
				if (targetFormat !== sourceFormat) {
						return true;
				}
				var width = (sourceTexture == null ? void 0 : sourceTexture.width) || this.device.width;
				var height = (sourceTexture == null ? void 0 : sourceTexture.height) || this.device.height;
				return !targetRT || width !== targetRT.width || height !== targetRT.height;
		}
		allocateRenderTarget(renderTarget, sourceRenderTarget, device, format) {
				var texture = new Texture(device, {
						name: _colorUniformName,
						format,
						width: sourceRenderTarget ? sourceRenderTarget.colorBuffer.width : device.width,
						height: sourceRenderTarget ? sourceRenderTarget.colorBuffer.height : device.height,
						mipmaps: true,
						minFilter: FILTER_LINEAR_MIPMAP_LINEAR,
						magFilter: FILTER_LINEAR,
						addressU: ADDRESS_CLAMP_TO_EDGE,
						addressV: ADDRESS_CLAMP_TO_EDGE
				});
				if (renderTarget) {
						renderTarget.destroyFrameBuffers();
						renderTarget._colorBuffer = texture;
						renderTarget._colorBuffers = [
								texture
						];
				} else {
						renderTarget = new RenderTarget({
								name: 'ColorGrabRT',
								colorBuffer: texture,
								depth: false,
								stencil: false,
								autoResolve: false
						});
				}
				return renderTarget;
		}
		releaseRenderTarget(rt) {
				if (rt) {
						rt.destroyTextureBuffers();
						rt.destroy();
				}
		}
		frameUpdate() {
				var device = this.device;
				var sourceRt = this.source;
				var _sourceRt_colorBuffer_format;
				var sourceFormat = (_sourceRt_colorBuffer_format = sourceRt == null ? void 0 : sourceRt.colorBuffer.format) != null ? _sourceRt_colorBuffer_format : this.device.backBufferFormat;
				if (this.shouldReallocate(this.colorRenderTarget, sourceRt == null ? void 0 : sourceRt.colorBuffer, sourceFormat)) {
						this.releaseRenderTarget(this.colorRenderTarget);
						this.colorRenderTarget = this.allocateRenderTarget(this.colorRenderTarget, sourceRt, device, sourceFormat);
				}
				var colorBuffer = this.colorRenderTarget.colorBuffer;
				device.scope.resolve(_colorUniformName).setValue(colorBuffer);
		}
		execute() {
				var device = this.device;
				var sourceRt = this.source;
				var colorBuffer = this.colorRenderTarget.colorBuffer;
				if (device.isWebGPU) {
						device.copyRenderTarget(sourceRt, this.colorRenderTarget, true, false);
						device.mipmapRenderer.generate(this.colorRenderTarget.colorBuffer.impl);
				} else {
						device.copyRenderTarget(sourceRt, this.colorRenderTarget, true, false);
						device.activeTexture(device.maxCombinedTextures - 1);
						device.bindTexture(colorBuffer);
						device.gl.generateMipmap(colorBuffer.impl._glTarget);
				}
		}
		constructor(...args){
				super(...args), this.colorRenderTarget = null, this.source = null;
		}
}

var _depthUniformName = 'uSceneDepthMap';
class RenderPassDepthGrab extends RenderPass {
		destroy() {
				super.destroy();
				this.releaseRenderTarget(this.depthRenderTarget);
		}
		shouldReallocate(targetRT, sourceTexture) {
				var width = (sourceTexture == null ? void 0 : sourceTexture.width) || this.device.width;
				var height = (sourceTexture == null ? void 0 : sourceTexture.height) || this.device.height;
				return !targetRT || width !== targetRT.width || height !== targetRT.height;
		}
		allocateRenderTarget(renderTarget, sourceRenderTarget, device, format, isDepth) {
				var texture = new Texture(device, {
						name: _depthUniformName,
						format,
						width: sourceRenderTarget ? sourceRenderTarget.colorBuffer.width : device.width,
						height: sourceRenderTarget ? sourceRenderTarget.colorBuffer.height : device.height,
						mipmaps: false,
						minFilter: FILTER_NEAREST,
						magFilter: FILTER_NEAREST,
						addressU: ADDRESS_CLAMP_TO_EDGE,
						addressV: ADDRESS_CLAMP_TO_EDGE
				});
				if (renderTarget) {
						renderTarget.destroyFrameBuffers();
						if (isDepth) {
								renderTarget._depthBuffer = texture;
						} else {
								renderTarget._colorBuffer = texture;
								renderTarget._colorBuffers = [
										texture
								];
						}
				} else {
						renderTarget = new RenderTarget({
								name: 'DepthGrabRT',
								colorBuffer: isDepth ? null : texture,
								depthBuffer: isDepth ? texture : null,
								depth: !isDepth,
								stencil: device.supportsStencil,
								autoResolve: false
						});
				}
				return renderTarget;
		}
		releaseRenderTarget(rt) {
				if (rt) {
						rt.destroyTextureBuffers();
						rt.destroy();
				}
		}
		before() {
				var _camera_renderTarget, _camera_renderTarget1;
				var camera = this.camera;
				var device = this.device;
				var _camera_renderTarget2;
				var destinationRt = (_camera_renderTarget2 = camera == null ? void 0 : camera.renderTarget) != null ? _camera_renderTarget2 : device.backBuffer;
				var useDepthBuffer = true;
				var format = destinationRt.stencil ? PIXELFORMAT_DEPTHSTENCIL : PIXELFORMAT_DEPTH;
				if (device.isWebGPU) {
						var numSamples = destinationRt.samples;
						if (numSamples > 1) {
								format = PIXELFORMAT_R32F;
								useDepthBuffer = false;
						}
				}
				var _camera_renderTarget_depthBuffer;
				var sourceTexture = (_camera_renderTarget_depthBuffer = (_camera_renderTarget = camera.renderTarget) == null ? void 0 : _camera_renderTarget.depthBuffer) != null ? _camera_renderTarget_depthBuffer : (_camera_renderTarget1 = camera.renderTarget) == null ? void 0 : _camera_renderTarget1.colorBuffer;
				if (this.shouldReallocate(this.depthRenderTarget, sourceTexture)) {
						this.releaseRenderTarget(this.depthRenderTarget);
						this.depthRenderTarget = this.allocateRenderTarget(this.depthRenderTarget, camera.renderTarget, device, format, useDepthBuffer);
				}
				var colorBuffer = useDepthBuffer ? this.depthRenderTarget.depthBuffer : this.depthRenderTarget.colorBuffer;
				device.scope.resolve(_depthUniformName).setValue(colorBuffer);
		}
		execute() {
				var device = this.device;
				if (device.isWebGL2 && device.renderTarget.samples > 1) {
						var src = device.renderTarget.impl._glFrameBuffer;
						var dest = this.depthRenderTarget;
						device.renderTarget = dest;
						device.updateBegin();
						this.depthRenderTarget.impl.internalResolve(device, src, dest.impl._glFrameBuffer, this.depthRenderTarget, device.gl.DEPTH_BUFFER_BIT);
				} else {
						device.copyRenderTarget(device.renderTarget, this.depthRenderTarget, false, true);
				}
		}
		constructor(device, camera){
				super(device), this.depthRenderTarget = null, this.camera = null;
				this.camera = camera;
		}
}

class CameraShaderParams {
		get hash() {
				if (this._hash === undefined) {
						var key = this.gammaCorrection + "_" + this.toneMapping + "_" + this.srgbRenderTarget + "_" + this.fog + "_" + this.ssaoEnabled + "_" + this.sceneDepthMapLinear;
						this._hash = hashCode(key);
				}
				return this._hash;
		}
		get defines() {
				var defines = this._defines;
				if (this._definesDirty) {
						this._definesDirty = false;
						defines.clear();
						if (this._sceneDepthMapLinear) defines.set('SCENE_DEPTHMAP_LINEAR', true);
						defines.set('FOG', this._fog.toUpperCase());
						defines.set('TONEMAP', tonemapNames[this._toneMapping]);
						defines.set('GAMMA', gammaNames[this.shaderOutputGamma]);
				}
				return defines;
		}
		markDirty() {
				this._hash = undefined;
				this._definesDirty = true;
		}
		set fog(type) {
				if (this._fog !== type) {
						this._fog = type;
						this.markDirty();
				}
		}
		get fog() {
				return this._fog;
		}
		set ssaoEnabled(value) {
				if (this._ssaoEnabled !== value) {
						this._ssaoEnabled = value;
						this.markDirty();
				}
		}
		get ssaoEnabled() {
				return this._ssaoEnabled;
		}
		set gammaCorrection(value) {
				this._gammaCorrectionAssigned = true;
				if (this._gammaCorrection !== value) {
						this._gammaCorrection = value;
						this.markDirty();
				}
		}
		get gammaCorrection() {
				return this._gammaCorrection;
		}
		set toneMapping(value) {
				if (this._toneMapping !== value) {
						this._toneMapping = value;
						this.markDirty();
				}
		}
		get toneMapping() {
				return this._toneMapping;
		}
		set srgbRenderTarget(value) {
				if (this._srgbRenderTarget !== value) {
						this._srgbRenderTarget = value;
						this.markDirty();
				}
		}
		get srgbRenderTarget() {
				return this._srgbRenderTarget;
		}
		set sceneDepthMapLinear(value) {
				if (this._sceneDepthMapLinear !== value) {
						this._sceneDepthMapLinear = value;
						this.markDirty();
				}
		}
		get sceneDepthMapLinear() {
				return this._sceneDepthMapLinear;
		}
		get shaderOutputGamma() {
				var gammaOutput = this._gammaCorrection === GAMMA_SRGB && !this._srgbRenderTarget;
				return gammaOutput ? GAMMA_SRGB : GAMMA_NONE;
		}
		constructor(){
				this._gammaCorrection = GAMMA_SRGB;
				this._toneMapping = TONEMAP_LINEAR;
				this._srgbRenderTarget = false;
				this._ssaoEnabled = false;
				this._fog = FOG_NONE;
				this._sceneDepthMapLinear = false;
				this._defines = new Map();
				this._definesDirty = true;
		}
}

var _deviceCoord = new Vec3();
var _halfSize = new Vec3();
var _point$1 = new Vec3();
var _invViewProjMat = new Mat4();
var _frustumPoints = [
		new Vec3(),
		new Vec3(),
		new Vec3(),
		new Vec3(),
		new Vec3(),
		new Vec3(),
		new Vec3(),
		new Vec3()
];
class Camera {
		destroy() {
				var _this_renderPassColorGrab, _this_renderPassDepthGrab;
				(_this_renderPassColorGrab = this.renderPassColorGrab) == null ? void 0 : _this_renderPassColorGrab.destroy();
				this.renderPassColorGrab = null;
				(_this_renderPassDepthGrab = this.renderPassDepthGrab) == null ? void 0 : _this_renderPassDepthGrab.destroy();
				this.renderPassDepthGrab = null;
				this.renderPasses.length = 0;
		}
		_storeShaderMatrices(viewProjMat, jitterX, jitterY, renderVersion) {
				if (this._shaderMatricesVersion !== renderVersion) {
						this._shaderMatricesVersion = renderVersion;
						var _this__viewProjCurrent;
						this._viewProjPrevious.copy((_this__viewProjCurrent = this._viewProjCurrent) != null ? _this__viewProjCurrent : viewProjMat);
						var _this__viewProjCurrent1;
						(_this__viewProjCurrent1 = this._viewProjCurrent) != null ? _this__viewProjCurrent1 : this._viewProjCurrent = new Mat4();
						this._viewProjCurrent.copy(viewProjMat);
						this._viewProjInverse.invert(viewProjMat);
						this._jitters[2] = this._jitters[0];
						this._jitters[3] = this._jitters[1];
						this._jitters[0] = jitterX;
						this._jitters[1] = jitterY;
				}
		}
		get fullSizeClearRect() {
				var rect = this._scissorRectClear ? this.scissorRect : this._rect;
				return rect.x === 0 && rect.y === 0 && rect.z === 1 && rect.w === 1;
		}
		set aspectRatio(newValue) {
				if (this._aspectRatio !== newValue) {
						this._aspectRatio = newValue;
						this._projMatDirty = true;
				}
		}
		get aspectRatio() {
				var _this_xr;
				return ((_this_xr = this.xr) == null ? void 0 : _this_xr.active) ? this._xrProperties.aspectRatio : this._aspectRatio;
		}
		set aspectRatioMode(newValue) {
				if (this._aspectRatioMode !== newValue) {
						this._aspectRatioMode = newValue;
						this._projMatDirty = true;
				}
		}
		get aspectRatioMode() {
				return this._aspectRatioMode;
		}
		set calculateProjection(newValue) {
				this._calculateProjection = newValue;
				this._projMatDirty = true;
		}
		get calculateProjection() {
				return this._calculateProjection;
		}
		set calculateTransform(newValue) {
				this._calculateTransform = newValue;
		}
		get calculateTransform() {
				return this._calculateTransform;
		}
		set clearColor(newValue) {
				this._clearColor.copy(newValue);
		}
		get clearColor() {
				return this._clearColor;
		}
		set clearColorBuffer(newValue) {
				this._clearColorBuffer = newValue;
		}
		get clearColorBuffer() {
				return this._clearColorBuffer;
		}
		set clearDepth(newValue) {
				this._clearDepth = newValue;
		}
		get clearDepth() {
				return this._clearDepth;
		}
		set clearDepthBuffer(newValue) {
				this._clearDepthBuffer = newValue;
		}
		get clearDepthBuffer() {
				return this._clearDepthBuffer;
		}
		set clearStencil(newValue) {
				this._clearStencil = newValue;
		}
		get clearStencil() {
				return this._clearStencil;
		}
		set clearStencilBuffer(newValue) {
				this._clearStencilBuffer = newValue;
		}
		get clearStencilBuffer() {
				return this._clearStencilBuffer;
		}
		set cullFaces(newValue) {
				this._cullFaces = newValue;
		}
		get cullFaces() {
				return this._cullFaces;
		}
		set farClip(newValue) {
				if (this._farClip !== newValue) {
						this._farClip = newValue;
						this._projMatDirty = true;
				}
		}
		get farClip() {
				var _this_xr;
				return ((_this_xr = this.xr) == null ? void 0 : _this_xr.active) ? this._xrProperties.farClip : this._farClip;
		}
		set flipFaces(newValue) {
				this._flipFaces = newValue;
		}
		get flipFaces() {
				return this._flipFaces;
		}
		set fov(newValue) {
				if (this._fov !== newValue) {
						this._fov = newValue;
						this._projMatDirty = true;
				}
		}
		get fov() {
				var _this_xr;
				return ((_this_xr = this.xr) == null ? void 0 : _this_xr.active) ? this._xrProperties.fov : this._fov;
		}
		set frustumCulling(newValue) {
				this._frustumCulling = newValue;
		}
		get frustumCulling() {
				return this._frustumCulling;
		}
		set horizontalFov(newValue) {
				if (this._horizontalFov !== newValue) {
						this._horizontalFov = newValue;
						this._projMatDirty = true;
				}
		}
		get horizontalFov() {
				var _this_xr;
				return ((_this_xr = this.xr) == null ? void 0 : _this_xr.active) ? this._xrProperties.horizontalFov : this._horizontalFov;
		}
		set layers(newValue) {
				this._layers = newValue.slice(0);
				this._layersSet = new Set(this._layers);
		}
		get layers() {
				return this._layers;
		}
		get layersSet() {
				return this._layersSet;
		}
		set nearClip(newValue) {
				if (this._nearClip !== newValue) {
						this._nearClip = newValue;
						this._projMatDirty = true;
				}
		}
		get nearClip() {
				var _this_xr;
				return ((_this_xr = this.xr) == null ? void 0 : _this_xr.active) ? this._xrProperties.nearClip : this._nearClip;
		}
		set node(newValue) {
				this._node = newValue;
		}
		get node() {
				return this._node;
		}
		set orthoHeight(newValue) {
				if (this._orthoHeight !== newValue) {
						this._orthoHeight = newValue;
						this._projMatDirty = true;
				}
		}
		get orthoHeight() {
				return this._orthoHeight;
		}
		set projection(newValue) {
				if (this._projection !== newValue) {
						this._projection = newValue;
						this._projMatDirty = true;
				}
		}
		get projection() {
				return this._projection;
		}
		get projectionMatrix() {
				this._evaluateProjectionMatrix();
				return this._projMat;
		}
		set rect(newValue) {
				this._rect.copy(newValue);
		}
		get rect() {
				return this._rect;
		}
		set renderTarget(newValue) {
				this._renderTarget = newValue;
		}
		get renderTarget() {
				return this._renderTarget;
		}
		set scissorRect(newValue) {
				this._scissorRect.copy(newValue);
		}
		get scissorRect() {
				return this._scissorRect;
		}
		get viewMatrix() {
				if (this._viewMatDirty) {
						var wtm = this._node.getWorldTransform();
						this._viewMat.copy(wtm).invert();
						this._viewMatDirty = false;
				}
				return this._viewMat;
		}
		set aperture(newValue) {
				this._aperture = newValue;
		}
		get aperture() {
				return this._aperture;
		}
		set sensitivity(newValue) {
				this._sensitivity = newValue;
		}
		get sensitivity() {
				return this._sensitivity;
		}
		set shutter(newValue) {
				this._shutter = newValue;
		}
		get shutter() {
				return this._shutter;
		}
		set xr(newValue) {
				if (this._xr !== newValue) {
						this._xr = newValue;
						this._projMatDirty = true;
				}
		}
		get xr() {
				return this._xr;
		}
		clone() {
				return new Camera().copy(this);
		}
		copy(other) {
				this._aspectRatio = other._aspectRatio;
				this._farClip = other._farClip;
				this._fov = other._fov;
				this._horizontalFov = other._horizontalFov;
				this._nearClip = other._nearClip;
				this._xrProperties.aspectRatio = other._xrProperties.aspectRatio;
				this._xrProperties.farClip = other._xrProperties.farClip;
				this._xrProperties.fov = other._xrProperties.fov;
				this._xrProperties.horizontalFov = other._xrProperties.horizontalFov;
				this._xrProperties.nearClip = other._xrProperties.nearClip;
				this.aspectRatioMode = other.aspectRatioMode;
				this.calculateProjection = other.calculateProjection;
				this.calculateTransform = other.calculateTransform;
				this.clearColor = other.clearColor;
				this.clearColorBuffer = other.clearColorBuffer;
				this.clearDepth = other.clearDepth;
				this.clearDepthBuffer = other.clearDepthBuffer;
				this.clearStencil = other.clearStencil;
				this.clearStencilBuffer = other.clearStencilBuffer;
				this.cullFaces = other.cullFaces;
				this.flipFaces = other.flipFaces;
				this.frustumCulling = other.frustumCulling;
				this.layers = other.layers;
				this.orthoHeight = other.orthoHeight;
				this.projection = other.projection;
				this.rect = other.rect;
				this.renderTarget = other.renderTarget;
				this.scissorRect = other.scissorRect;
				this.aperture = other.aperture;
				this.shutter = other.shutter;
				this.sensitivity = other.sensitivity;
				this.shaderPassInfo = other.shaderPassInfo;
				this.jitter = other.jitter;
				this._projMatDirty = true;
				return this;
		}
		_enableRenderPassColorGrab(device, enable) {
				if (enable) {
						if (!this.renderPassColorGrab) {
								this.renderPassColorGrab = new RenderPassColorGrab(device);
						}
				} else {
						var _this_renderPassColorGrab;
						(_this_renderPassColorGrab = this.renderPassColorGrab) == null ? void 0 : _this_renderPassColorGrab.destroy();
						this.renderPassColorGrab = null;
				}
		}
		_enableRenderPassDepthGrab(device, renderer, enable) {
				if (enable) {
						if (!this.renderPassDepthGrab) {
								this.renderPassDepthGrab = new RenderPassDepthGrab(device, this);
						}
				} else {
						var _this_renderPassDepthGrab;
						(_this_renderPassDepthGrab = this.renderPassDepthGrab) == null ? void 0 : _this_renderPassDepthGrab.destroy();
						this.renderPassDepthGrab = null;
				}
		}
		_updateViewProjMat() {
				if (this._projMatDirty || this._viewMatDirty || this._viewProjMatDirty) {
						this._viewProjMat.mul2(this.projectionMatrix, this.viewMatrix);
						this._viewProjMatDirty = false;
				}
		}
		worldToScreen(worldCoord, cw, ch, screenCoord) {
				if (screenCoord === void 0) screenCoord = new Vec3();
				this._updateViewProjMat();
				this._viewProjMat.transformPoint(worldCoord, screenCoord);
				var vpm = this._viewProjMat.data;
				var w = worldCoord.x * vpm[3] + worldCoord.y * vpm[7] + worldCoord.z * vpm[11] + 1 * vpm[15];
				screenCoord.x = (screenCoord.x / w + 1) * 0.5 * cw;
				screenCoord.y = (1 - screenCoord.y / w) * 0.5 * ch;
				return screenCoord;
		}
		screenToWorld(x, y, z, cw, ch, worldCoord) {
				if (worldCoord === void 0) worldCoord = new Vec3();
				var range = this.farClip - this.nearClip;
				_deviceCoord.set(x / cw, (ch - y) / ch, z / range);
				_deviceCoord.mulScalar(2);
				_deviceCoord.sub(Vec3.ONE);
				if (this._projection === PROJECTION_PERSPECTIVE) {
						Mat4._getPerspectiveHalfSize(_halfSize, this.fov, this.aspectRatio, this.nearClip, this.horizontalFov);
						_halfSize.x *= _deviceCoord.x;
						_halfSize.y *= _deviceCoord.y;
						var invView = this._node.getWorldTransform();
						_halfSize.z = -this.nearClip;
						invView.transformPoint(_halfSize, _point$1);
						var cameraPos = this._node.getPosition();
						worldCoord.sub2(_point$1, cameraPos);
						worldCoord.normalize();
						worldCoord.mulScalar(z);
						worldCoord.add(cameraPos);
				} else {
						this._updateViewProjMat();
						_invViewProjMat.copy(this._viewProjMat).invert();
						_invViewProjMat.transformPoint(_deviceCoord, worldCoord);
				}
				return worldCoord;
		}
		_evaluateProjectionMatrix() {
				if (this._projMatDirty) {
						if (this._projection === PROJECTION_PERSPECTIVE) {
								this._projMat.setPerspective(this.fov, this.aspectRatio, this.nearClip, this.farClip, this.horizontalFov);
								this._projMatSkybox.copy(this._projMat);
						} else {
								var y = this._orthoHeight;
								var x = y * this.aspectRatio;
								this._projMat.setOrtho(-x, x, -y, y, this.nearClip, this.farClip);
								this._projMatSkybox.setPerspective(this.fov, this.aspectRatio, this.nearClip, this.farClip);
						}
						this._projMatDirty = false;
				}
		}
		getProjectionMatrixSkybox() {
				this._evaluateProjectionMatrix();
				return this._projMatSkybox;
		}
		getExposure() {
				var ev100 = Math.log2(this._aperture * this._aperture / this._shutter * 100.0 / this._sensitivity);
				return 1.0 / (Math.pow(2.0, ev100) * 1.2);
		}
		getScreenSize(sphere) {
				if (this._projection === PROJECTION_PERSPECTIVE) {
						var distance = this._node.getPosition().distance(sphere.center);
						if (distance < sphere.radius) {
								return 1;
						}
						var viewAngle = Math.asin(sphere.radius / distance);
						var sphereViewHeight = Math.tan(viewAngle);
						var screenViewHeight = Math.tan(this.fov / 2 * math.DEG_TO_RAD);
						return Math.min(sphereViewHeight / screenViewHeight, 1);
				}
				return math.clamp(sphere.radius / this._orthoHeight, 0, 1);
		}
		getFrustumCorners(near, far) {
				if (near === void 0) near = this.nearClip;
				if (far === void 0) far = this.farClip;
				var fov = this.fov * Math.PI / 180.0;
				var x, y;
				if (this.projection === PROJECTION_PERSPECTIVE) {
						if (this.horizontalFov) {
								x = near * Math.tan(fov / 2.0);
								y = x / this.aspectRatio;
						} else {
								y = near * Math.tan(fov / 2.0);
								x = y * this.aspectRatio;
						}
				} else {
						y = this._orthoHeight;
						x = y * this.aspectRatio;
				}
				var points = _frustumPoints;
				points[0].x = x;
				points[0].y = -y;
				points[0].z = -near;
				points[1].x = x;
				points[1].y = y;
				points[1].z = -near;
				points[2].x = -x;
				points[2].y = y;
				points[2].z = -near;
				points[3].x = -x;
				points[3].y = -y;
				points[3].z = -near;
				if (this._projection === PROJECTION_PERSPECTIVE) {
						if (this.horizontalFov) {
								x = far * Math.tan(fov / 2.0);
								y = x / this.aspectRatio;
						} else {
								y = far * Math.tan(fov / 2.0);
								x = y * this.aspectRatio;
						}
				}
				points[4].x = x;
				points[4].y = -y;
				points[4].z = -far;
				points[5].x = x;
				points[5].y = y;
				points[5].z = -far;
				points[6].x = -x;
				points[6].y = y;
				points[6].z = -far;
				points[7].x = -x;
				points[7].y = -y;
				points[7].z = -far;
				return points;
		}
		setXrProperties(properties) {
				Object.assign(this._xrProperties, properties);
				this._projMatDirty = true;
		}
		constructor(){
				this.shaderPassInfo = null;
				this.renderPassColorGrab = null;
				this.renderPassDepthGrab = null;
				this.fogParams = null;
				this.shaderParams = new CameraShaderParams();
				this.renderPasses = [];
				this.jitter = 0;
				this._aspectRatio = 16 / 9;
				this._aspectRatioMode = ASPECT_AUTO;
				this._calculateProjection = null;
				this._calculateTransform = null;
				this._clearColor = new Color(0.75, 0.75, 0.75, 1);
				this._clearColorBuffer = true;
				this._clearDepth = 1;
				this._clearDepthBuffer = true;
				this._clearStencil = 0;
				this._clearStencilBuffer = true;
				this._cullFaces = true;
				this._farClip = 1000;
				this._flipFaces = false;
				this._fov = 45;
				this._frustumCulling = true;
				this._horizontalFov = false;
				this._layers = [
						LAYERID_WORLD,
						LAYERID_DEPTH,
						LAYERID_SKYBOX,
						LAYERID_UI,
						LAYERID_IMMEDIATE
				];
				this._layersSet = new Set(this._layers);
				this._nearClip = 0.1;
				this._node = null;
				this._orthoHeight = 10;
				this._projection = PROJECTION_PERSPECTIVE;
				this._rect = new Vec4(0, 0, 1, 1);
				this._renderTarget = null;
				this._scissorRect = new Vec4(0, 0, 1, 1);
				this._scissorRectClear = false;
				this._aperture = 16.0;
				this._shutter = 1.0 / 1000.0;
				this._sensitivity = 1000;
				this._projMat = new Mat4();
				this._projMatDirty = true;
				this._projMatSkybox = new Mat4();
				this._viewMat = new Mat4();
				this._viewMatDirty = true;
				this._viewProjMat = new Mat4();
				this._viewProjMatDirty = true;
				this._shaderMatricesVersion = 0;
				this._viewProjInverse = new Mat4();
				this._viewProjCurrent = null;
				this._viewProjPrevious = new Mat4();
				this._jitters = [
						0,
						0,
						0,
						0
				];
				this.frustum = new Frustum();
				this._xr = null;
				this._xrProperties = {
						horizontalFov: this._horizontalFov,
						fov: this._fov,
						aspectRatio: this._aspectRatio,
						farClip: this._farClip,
						nearClip: this._nearClip
				};
		}
}

function _type_of(obj) {
		"@swc/helpers - typeof";
		return obj && typeof Symbol !== "undefined" && obj.constructor === Symbol ? "symbol" : typeof obj;
}
var scaleCompensatePosTransform = new Mat4();
var scaleCompensatePos = new Vec3();
var scaleCompensateRot = new Quat();
var scaleCompensateRot2 = new Quat();
var scaleCompensateScale = new Vec3();
var scaleCompensateScaleForParent = new Vec3();
var tmpMat4 = new Mat4();
var tmpQuat = new Quat();
var position$1 = new Vec3();
var invParentWtm$1 = new Mat4();
var rotation = new Quat();
var invParentRot = new Quat();
var matrix = new Mat4();
var target = new Vec3();
var up$2 = new Vec3();
function createTest(attr, value) {
		if (attr instanceof Function) {
				return attr;
		}
		return (node)=>{
				var x = node[attr];
				if (x instanceof Function) {
						x = x();
				}
				return x === value;
		};
}
function findNode(node, test) {
		if (test(node)) {
				return node;
		}
		var children = node._children;
		var len = children.length;
		for(var i = 0; i < len; ++i){
				var result = findNode(children[i], test);
				if (result) {
						return result;
				}
		}
		return null;
}
class GraphNode extends EventHandler {
		get right() {
				if (!this._right) {
						this._right = new Vec3();
				}
				return this.getWorldTransform().getX(this._right).normalize();
		}
		get up() {
				if (!this._up) {
						this._up = new Vec3();
				}
				return this.getWorldTransform().getY(this._up).normalize();
		}
		get forward() {
				if (!this._forward) {
						this._forward = new Vec3();
				}
				return this.getWorldTransform().getZ(this._forward).normalize().mulScalar(-1);
		}
		get normalMatrix() {
				var normalMat = this._normalMatrix;
				if (this._dirtyNormal) {
						normalMat.invertMat4(this.getWorldTransform()).transpose();
						this._dirtyNormal = false;
				}
				return normalMat;
		}
		set enabled(enabled) {
				if (this._enabled !== enabled) {
						var _this__parent;
						this._enabled = enabled;
						if (enabled && ((_this__parent = this._parent) == null ? void 0 : _this__parent.enabled) || !enabled) {
								this._notifyHierarchyStateChanged(this, enabled);
						}
				}
		}
		get enabled() {
				return this._enabled && this._enabledInHierarchy;
		}
		get parent() {
				return this._parent;
		}
		get path() {
				var node = this._parent;
				if (!node) {
						return '';
				}
				var result = this.name;
				while(node && node._parent){
						result = node.name + "/" + result;
						node = node._parent;
				}
				return result;
		}
		get root() {
				var result = this;
				while(result._parent){
						result = result._parent;
				}
				return result;
		}
		get children() {
				return this._children;
		}
		get graphDepth() {
				return this._graphDepth;
		}
		_notifyHierarchyStateChanged(node, enabled) {
				node._onHierarchyStateChanged(enabled);
				var c = node._children;
				for(var i = 0, len = c.length; i < len; i++){
						if (c[i]._enabled) {
								this._notifyHierarchyStateChanged(c[i], enabled);
						}
				}
		}
		_onHierarchyStateChanged(enabled) {
				this._enabledInHierarchy = enabled;
				if (enabled && !this._frozen) {
						this._unfreezeParentToRoot();
				}
		}
		_cloneInternal(clone) {
				clone.name = this.name;
				var tags = this.tags._list;
				clone.tags.clear();
				for(var i = 0; i < tags.length; i++){
						clone.tags.add(tags[i]);
				}
				clone.localPosition.copy(this.localPosition);
				clone.localRotation.copy(this.localRotation);
				clone.localScale.copy(this.localScale);
				clone.localEulerAngles.copy(this.localEulerAngles);
				clone.position.copy(this.position);
				clone.rotation.copy(this.rotation);
				clone.eulerAngles.copy(this.eulerAngles);
				clone.localTransform.copy(this.localTransform);
				clone._dirtyLocal = this._dirtyLocal;
				clone.worldTransform.copy(this.worldTransform);
				clone._dirtyWorld = this._dirtyWorld;
				clone._dirtyNormal = this._dirtyNormal;
				clone._aabbVer = this._aabbVer + 1;
				clone._enabled = this._enabled;
				clone.scaleCompensation = this.scaleCompensation;
				clone._enabledInHierarchy = false;
		}
		clone() {
				var clone = new this.constructor();
				this._cloneInternal(clone);
				return clone;
		}
		copy(source) {
				source._cloneInternal(this);
				return this;
		}
		destroy() {
				this.remove();
				var children = this._children;
				while(children.length){
						var child = children.pop();
						child._parent = null;
						child.destroy();
				}
				this.fire('destroy', this);
				this.off();
		}
		find(attr, value) {
				var results = [];
				var test = createTest(attr, value);
				this.forEach((node)=>{
						if (test(node)) {
								results.push(node);
						}
				});
				return results;
		}
		findOne(attr, value) {
				var test = createTest(attr, value);
				return findNode(this, test);
		}
		findByTag() {
				for(var _len = arguments.length, query = new Array(_len), _key = 0; _key < _len; _key++){
						query[_key] = arguments[_key];
				}
				var results = [];
				var queryNode = (node, checkNode)=>{
						if (checkNode && node.tags.has(...query)) {
								results.push(node);
						}
						for(var i = 0; i < node._children.length; i++){
								queryNode(node._children[i], true);
						}
				};
				queryNode(this, false);
				return results;
		}
		findByName(name) {
				return this.findOne('name', name);
		}
		findByPath(path) {
				var _loop = function(i, imax) {
						result = result.children.find((c)=>c.name === parts[i]);
						if (!result) {
								return {
										v: null
								};
						}
				};
				var parts = Array.isArray(path) ? path : path.split('/');
				var result = this;
				for(var i = 0, imax = parts.length; i < imax; ++i){
						var _ret = _loop(i);
						if (_type_of(_ret) === "object") return _ret.v;
				}
				return result;
		}
		forEach(callback, thisArg) {
				callback.call(thisArg, this);
				var children = this._children;
				var len = children.length;
				for(var i = 0; i < len; ++i){
						children[i].forEach(callback, thisArg);
				}
		}
		isDescendantOf(node) {
				var parent = this._parent;
				while(parent){
						if (parent === node) {
								return true;
						}
						parent = parent._parent;
				}
				return false;
		}
		isAncestorOf(node) {
				return node.isDescendantOf(this);
		}
		getEulerAngles() {
				this.getWorldTransform().getEulerAngles(this.eulerAngles);
				return this.eulerAngles;
		}
		getLocalEulerAngles() {
				this.localRotation.getEulerAngles(this.localEulerAngles);
				return this.localEulerAngles;
		}
		getLocalPosition() {
				return this.localPosition;
		}
		getLocalRotation() {
				return this.localRotation;
		}
		getLocalScale() {
				return this.localScale;
		}
		getLocalTransform() {
				if (this._dirtyLocal) {
						this.localTransform.setTRS(this.localPosition, this.localRotation, this.localScale);
						this._dirtyLocal = false;
				}
				return this.localTransform;
		}
		getPosition() {
				this.getWorldTransform().getTranslation(this.position);
				return this.position;
		}
		getRotation() {
				this.rotation.setFromMat4(this.getWorldTransform());
				return this.rotation;
		}
		getScale() {
				if (!this._scale) {
						this._scale = new Vec3();
				}
				return this.getWorldTransform().getScale(this._scale);
		}
		getWorldTransform() {
				if (!this._dirtyLocal && !this._dirtyWorld) {
						return this.worldTransform;
				}
				if (this._parent) {
						this._parent.getWorldTransform();
				}
				this._sync();
				return this.worldTransform;
		}
		get worldScaleSign() {
				if (this._worldScaleSign === 0) {
						this._worldScaleSign = this.getWorldTransform().scaleSign;
				}
				return this._worldScaleSign;
		}
		remove() {
				var _this__parent;
				(_this__parent = this._parent) == null ? void 0 : _this__parent.removeChild(this);
		}
		reparent(parent, index) {
				this.remove();
				if (parent) {
						if (index >= 0) {
								parent.insertChild(this, index);
						} else {
								parent.addChild(this);
						}
				}
		}
		setLocalEulerAngles(x, y, z) {
				this.localRotation.setFromEulerAngles(x, y, z);
				if (!this._dirtyLocal) {
						this._dirtifyLocal();
				}
		}
		setLocalPosition(x, y, z) {
				if (x instanceof Vec3) {
						this.localPosition.copy(x);
				} else {
						this.localPosition.set(x, y, z);
				}
				if (!this._dirtyLocal) {
						this._dirtifyLocal();
				}
		}
		setLocalRotation(x, y, z, w) {
				if (x instanceof Quat) {
						this.localRotation.copy(x);
				} else {
						this.localRotation.set(x, y, z, w);
				}
				if (!this._dirtyLocal) {
						this._dirtifyLocal();
				}
		}
		setLocalScale(x, y, z) {
				if (x instanceof Vec3) {
						this.localScale.copy(x);
				} else {
						this.localScale.set(x, y, z);
				}
				if (!this._dirtyLocal) {
						this._dirtifyLocal();
				}
		}
		_dirtifyLocal() {
				if (!this._dirtyLocal) {
						this._dirtyLocal = true;
						if (!this._dirtyWorld) {
								this._dirtifyWorld();
						}
				}
		}
		_unfreezeParentToRoot() {
				var p = this._parent;
				while(p){
						p._frozen = false;
						p = p._parent;
				}
		}
		_dirtifyWorld() {
				if (!this._dirtyWorld) {
						this._unfreezeParentToRoot();
				}
				this._dirtifyWorldInternal();
		}
		_dirtifyWorldInternal() {
				if (!this._dirtyWorld) {
						this._frozen = false;
						this._dirtyWorld = true;
						for(var i = 0; i < this._children.length; i++){
								if (!this._children[i]._dirtyWorld) {
										this._children[i]._dirtifyWorldInternal();
								}
						}
				}
				this._dirtyNormal = true;
				this._worldScaleSign = 0;
				this._aabbVer++;
		}
		setPosition(x, y, z) {
				if (x instanceof Vec3) {
						position$1.copy(x);
				} else {
						position$1.set(x, y, z);
				}
				if (this._parent === null) {
						this.localPosition.copy(position$1);
				} else {
						invParentWtm$1.copy(this._parent.getWorldTransform()).invert();
						invParentWtm$1.transformPoint(position$1, this.localPosition);
				}
				if (!this._dirtyLocal) {
						this._dirtifyLocal();
				}
		}
		setRotation(x, y, z, w) {
				if (x instanceof Quat) {
						rotation.copy(x);
				} else {
						rotation.set(x, y, z, w);
				}
				if (this._parent === null) {
						this.localRotation.copy(rotation);
				} else {
						var parentRot = this._parent.getRotation();
						invParentRot.copy(parentRot).invert();
						this.localRotation.copy(invParentRot).mul(rotation);
				}
				if (!this._dirtyLocal) {
						this._dirtifyLocal();
				}
		}
		setPositionAndRotation(position, rotation) {
				if (this._parent === null) {
						this.localPosition.copy(position);
						this.localRotation.copy(rotation);
				} else {
						var parentWtm = this._parent.getWorldTransform();
						invParentWtm$1.copy(parentWtm).invert();
						invParentWtm$1.transformPoint(position, this.localPosition);
						this.localRotation.setFromMat4(invParentWtm$1).mul(rotation);
				}
				if (!this._dirtyLocal) {
						this._dirtifyLocal();
				}
		}
		setEulerAngles(x, y, z) {
				this.localRotation.setFromEulerAngles(x, y, z);
				if (this._parent !== null) {
						var parentRot = this._parent.getRotation();
						invParentRot.copy(parentRot).invert();
						this.localRotation.mul2(invParentRot, this.localRotation);
				}
				if (!this._dirtyLocal) {
						this._dirtifyLocal();
				}
		}
		addChild(node) {
				this._prepareInsertChild(node);
				this._children.push(node);
				this._onInsertChild(node);
		}
		addChildAndSaveTransform(node) {
				var wPos = node.getPosition();
				var wRot = node.getRotation();
				this._prepareInsertChild(node);
				node.setPosition(tmpMat4.copy(this.worldTransform).invert().transformPoint(wPos));
				node.setRotation(tmpQuat.copy(this.getRotation()).invert().mul(wRot));
				this._children.push(node);
				this._onInsertChild(node);
		}
		insertChild(node, index) {
				this._prepareInsertChild(node);
				this._children.splice(index, 0, node);
				this._onInsertChild(node);
		}
		_prepareInsertChild(node) {
				node.remove();
		}
		_fireOnHierarchy(name, nameHierarchy, parent) {
				this.fire(name, parent);
				for(var i = 0; i < this._children.length; i++){
						this._children[i]._fireOnHierarchy(nameHierarchy, nameHierarchy, parent);
				}
		}
		_onInsertChild(node) {
				node._parent = this;
				var enabledInHierarchy = node._enabled && this.enabled;
				if (node._enabledInHierarchy !== enabledInHierarchy) {
						node._enabledInHierarchy = enabledInHierarchy;
						node._notifyHierarchyStateChanged(node, enabledInHierarchy);
				}
				node._updateGraphDepth();
				node._dirtifyWorld();
				if (this._frozen) {
						node._unfreezeParentToRoot();
				}
				node._fireOnHierarchy('insert', 'inserthierarchy', this);
				if (this.fire) this.fire('childinsert', node);
		}
		_updateGraphDepth() {
				this._graphDepth = this._parent ? this._parent._graphDepth + 1 : 0;
				for(var i = 0, len = this._children.length; i < len; i++){
						this._children[i]._updateGraphDepth();
				}
		}
		removeChild(child) {
				var index = this._children.indexOf(child);
				if (index === -1) {
						return;
				}
				this._children.splice(index, 1);
				child._parent = null;
				child._fireOnHierarchy('remove', 'removehierarchy', this);
				this.fire('childremove', child);
		}
		_sync() {
				if (this._dirtyLocal) {
						this.localTransform.setTRS(this.localPosition, this.localRotation, this.localScale);
						this._dirtyLocal = false;
				}
				if (this._dirtyWorld) {
						if (this._parent === null) {
								this.worldTransform.copy(this.localTransform);
						} else {
								if (this.scaleCompensation) {
										var parentWorldScale;
										var parent = this._parent;
										var scale = this.localScale;
										var parentToUseScaleFrom = parent;
										if (parentToUseScaleFrom) {
												while(parentToUseScaleFrom && parentToUseScaleFrom.scaleCompensation){
														parentToUseScaleFrom = parentToUseScaleFrom._parent;
												}
												if (parentToUseScaleFrom) {
														parentToUseScaleFrom = parentToUseScaleFrom._parent;
														if (parentToUseScaleFrom) {
																parentWorldScale = parentToUseScaleFrom.worldTransform.getScale();
																scaleCompensateScale.mul2(parentWorldScale, this.localScale);
																scale = scaleCompensateScale;
														}
												}
										}
										scaleCompensateRot2.setFromMat4(parent.worldTransform);
										scaleCompensateRot.mul2(scaleCompensateRot2, this.localRotation);
										var tmatrix = parent.worldTransform;
										if (parent.scaleCompensation) {
												scaleCompensateScaleForParent.mul2(parentWorldScale, parent.getLocalScale());
												scaleCompensatePosTransform.setTRS(parent.worldTransform.getTranslation(scaleCompensatePos), scaleCompensateRot2, scaleCompensateScaleForParent);
												tmatrix = scaleCompensatePosTransform;
										}
										tmatrix.transformPoint(this.localPosition, scaleCompensatePos);
										this.worldTransform.setTRS(scaleCompensatePos, scaleCompensateRot, scale);
								} else {
										this.worldTransform.mulAffine2(this._parent.worldTransform, this.localTransform);
								}
						}
						this._dirtyWorld = false;
				}
		}
		syncHierarchy() {
				if (!this._enabled) {
						return;
				}
				if (this._frozen) {
						return;
				}
				this._frozen = true;
				if (this._dirtyLocal || this._dirtyWorld) {
						this._sync();
				}
				var children = this._children;
				for(var i = 0, len = children.length; i < len; i++){
						children[i].syncHierarchy();
				}
		}
		lookAt(x, y, z, ux, uy, uz) {
				if (ux === void 0) ux = 0;
				if (uy === void 0) uy = 1;
				if (uz === void 0) uz = 0;
				if (x instanceof Vec3) {
						target.copy(x);
						if (y instanceof Vec3) {
								up$2.copy(y);
						} else {
								up$2.copy(Vec3.UP);
						}
				} else if (z === undefined) {
						return;
				} else {
						target.set(x, y, z);
						up$2.set(ux, uy, uz);
				}
				matrix.setLookAt(this.getPosition(), target, up$2);
				rotation.setFromMat4(matrix);
				this.setRotation(rotation);
		}
		translate(x, y, z) {
				if (x instanceof Vec3) {
						position$1.copy(x);
				} else {
						position$1.set(x, y, z);
				}
				position$1.add(this.getPosition());
				this.setPosition(position$1);
		}
		translateLocal(x, y, z) {
				if (x instanceof Vec3) {
						position$1.copy(x);
				} else {
						position$1.set(x, y, z);
				}
				this.localRotation.transformVector(position$1, position$1);
				this.localPosition.add(position$1);
				if (!this._dirtyLocal) {
						this._dirtifyLocal();
				}
		}
		rotate(x, y, z) {
				rotation.setFromEulerAngles(x, y, z);
				if (this._parent === null) {
						this.localRotation.mul2(rotation, this.localRotation);
				} else {
						var rot = this.getRotation();
						var parentRot = this._parent.getRotation();
						invParentRot.copy(parentRot).invert();
						rotation.mul2(invParentRot, rotation);
						this.localRotation.mul2(rotation, rot);
				}
				if (!this._dirtyLocal) {
						this._dirtifyLocal();
				}
		}
		rotateLocal(x, y, z) {
				rotation.setFromEulerAngles(x, y, z);
				this.localRotation.mul(rotation);
				if (!this._dirtyLocal) {
						this._dirtifyLocal();
				}
		}
		constructor(name = 'Untitled'){
				super(), this.tags = new Tags(this), this.localPosition = new Vec3(), this.localRotation = new Quat(), this.localScale = new Vec3(1, 1, 1), this.localEulerAngles = new Vec3(), this.position = new Vec3(), this.rotation = new Quat(), this.eulerAngles = new Vec3(), this._scale = null, this.localTransform = new Mat4(), this._dirtyLocal = false, this._aabbVer = 0, this._frozen = false, this.worldTransform = new Mat4(), this._dirtyWorld = false, this._worldScaleSign = 0, this._normalMatrix = new Mat3(), this._dirtyNormal = true, this._right = null, this._up = null, this._forward = null, this._parent = null, this._children = [], this._graphDepth = 0, this._enabled = true, this._enabledInHierarchy = false, this.scaleCompensation = false;
				this.name = name;
		}
}

var _viewMat = new Mat4();
var _viewProjMat = new Mat4();
var _viewportMatrix = new Mat4();
class LightCamera {
		static create(name, lightType, face) {
				var camera = new Camera();
				camera.node = new GraphNode(name);
				camera.aspectRatio = 1;
				camera.aspectRatioMode = ASPECT_MANUAL;
				camera._scissorRectClear = true;
				switch(lightType){
						case LIGHTTYPE_OMNI:
								camera.node.setRotation(LightCamera.pointLightRotations[face]);
								camera.fov = 90;
								camera.projection = PROJECTION_PERSPECTIVE;
								break;
						case LIGHTTYPE_SPOT:
								camera.projection = PROJECTION_PERSPECTIVE;
								break;
						case LIGHTTYPE_DIRECTIONAL:
								camera.projection = PROJECTION_ORTHOGRAPHIC;
								break;
				}
				return camera;
		}
		static evalSpotCookieMatrix(light) {
				var cookieCamera = LightCamera._spotCookieCamera;
				if (!cookieCamera) {
						cookieCamera = LightCamera.create('SpotCookieCamera', LIGHTTYPE_SPOT);
						LightCamera._spotCookieCamera = cookieCamera;
				}
				cookieCamera.fov = light._outerConeAngle * 2;
				var cookieNode = cookieCamera._node;
				cookieNode.setPosition(light._node.getPosition());
				cookieNode.setRotation(light._node.getRotation());
				cookieNode.rotateLocal(-90, 0, 0);
				_viewMat.setTRS(cookieNode.getPosition(), cookieNode.getRotation(), Vec3.ONE).invert();
				_viewProjMat.mul2(cookieCamera.projectionMatrix, _viewMat);
				var cookieMatrix = light.cookieMatrix;
				var rectViewport = light.atlasViewport;
				_viewportMatrix.setViewport(rectViewport.x, rectViewport.y, rectViewport.z, rectViewport.w);
				cookieMatrix.mul2(_viewportMatrix, _viewProjMat);
				return cookieMatrix;
		}
}
LightCamera.pointLightRotations = [
		new Quat().setFromEulerAngles(0, 90, 180),
		new Quat().setFromEulerAngles(0, -90, 180),
		new Quat().setFromEulerAngles(90, 0, 0),
		new Quat().setFromEulerAngles(-90, 0, 0),
		new Quat().setFromEulerAngles(0, 180, 180),
		new Quat().setFromEulerAngles(0, 0, 180)
];
LightCamera._spotCookieCamera = null;

var decodePS = "\n\n#ifndef _DECODE_INCLUDED_\n#define _DECODE_INCLUDED_\n\nfn decodeLinear(raw: vec4f) -> vec3f {\n    return raw.rgb;\n}\n\nfn decodeGammaFloat(raw: f32) -> f32 {\n    return pow(raw, 2.2);\n}\n\nfn decodeGammaVec3(raw: vec3f) -> vec3f {\n    return pow(raw, vec3f(2.2));\n}\n\nfn decodeGamma(raw: vec4f) -> vec3f {\n    return pow(raw.xyz, vec3f(2.2));\n}\n\nfn decodeRGBM(raw: vec4f) -> vec3f {\n    let color = (8.0 * raw.a) * raw.rgb;\n    return color * color;\n}\n\nfn decodeRGBP(raw: vec4f) -> vec3f {\n    let color = raw.rgb * (-raw.a * 7.0 + 8.0);\n    return color * color;\n}\n\nfn decodeRGBE(raw: vec4f) -> vec3f {\n    return select(vec3f(0.0), raw.xyz * pow(2.0, raw.w * 255.0 - 128.0), raw.a != 0.0);\n}\n\nfn passThrough(raw: vec4f) -> vec4f {\n    return raw;\n}\n\n#endif\n";

var encodePS = "\nfn encodeLinear(source: vec3f) -> vec4f {\n    return vec4f(source, 1.0);\n}\n\nfn encodeGamma(source: vec3f) -> vec4f {\n    return vec4f(pow(source + vec3f(0.0000001), vec3f(1.0 / 2.2)), 1.0);\n}\n\nfn encodeRGBM(source: vec3f) -> vec4f {\n    var color: vec3f = pow(source, vec3f(0.5));\n    color *= 1.0 / 8.0;\n\n    var a: f32 = saturate(max(max(color.r, color.g), max(color.b, 1.0 / 255.0)));\n    a = ceil(a * 255.0) / 255.0;\n\n    color /= a;\n    return vec4f(color, a);\n}\n\nfn encodeRGBP(source: vec3f) -> vec4f {\n    // convert incoming linear to gamma(ish)\n    var gamma: vec3f = pow(source, vec3f(0.5));\n\n    // calculate the maximum component clamped to 1..8\n    var maxVal: f32 = min(8.0, max(1.0, max(gamma.x, max(gamma.y, gamma.z))));\n\n    // calculate storage factor\n    var v: f32 = 1.0 - ((maxVal - 1.0) / 7.0);\n\n    // round the value for storage in 8bit channel\n    v = ceil(v * 255.0) / 255.0;\n\n    return vec4f(gamma / (-v * 7.0 + 8.0), v);\n}\n\nfn encodeRGBE(source: vec3f) -> vec4f {\n    var maxVal: f32 = max(source.x, max(source.y, source.z));\n    if (maxVal < 1e-32) {\n        return vec4f(0.0, 0.0, 0.0, 0.0);\n    } else {\n        var e: f32 = ceil(log2(maxVal));\n        return vec4f(source / pow(2.0, e), (e + 128.0) / 255.0);\n    }\n}\n";

var envAtlasPS = "\n// the envAtlas is fixed at 512 pixels. every equirect is generated with 1 pixel boundary.\nconst atlasSize : f32 = 512.0;\nconst seamSize : f32 = 1.0 / atlasSize;\n\n// map a normalized equirect UV to the given rectangle (taking 1 pixel seam into account).\nfn mapUv(uv : vec2f, rect : vec4f) -> vec2f {\n    return vec2f(mix(rect.x + seamSize, rect.x + rect.z - seamSize, uv.x),\n                 mix(rect.y + seamSize, rect.y + rect.w - seamSize, uv.y));\n}\n\n// map a normalized equirect UV and roughness level to the correct atlas rect.\nfn mapRoughnessUv(uv : vec2f, level : f32) -> vec2f {\n    let t : f32 = 1.0 / exp2(level);\n    return mapUv(uv, vec4f(0.0, 1.0 - t, t, t * 0.5));\n}\n\n// map shiny level UV\nfn mapShinyUv(uv : vec2f, level : f32) -> vec2f {\n    let t : f32 = 1.0 / exp2(level);\n    return mapUv(uv, vec4f(1.0 - t, 1.0 - t, t, t * 0.5));\n}\n";

var envProcPS = "\n#ifdef LIT_SKYBOX_INTENSITY\n    uniform skyboxIntensity : f32;\n#endif\n\nfn processEnvironment(color : vec3f) -> vec3f {\n    #ifdef LIT_SKYBOX_INTENSITY\n        return color * uniform.skyboxIntensity;\n    #else\n        return color;\n    #endif\n}\n";

var fogPS = "\n\n#if (FOG != NONE)\n    uniform fog_color : vec3f;\n    \n    #if (FOG == LINEAR)\n        uniform fog_start : f32;\n        uniform fog_end : f32;\n    #else\n        uniform fog_density : f32;\n    #endif\n#endif\n\nuniform dBlendModeFogFactor : f32;\n\nfn getFogFactor() -> f32 {\n\n    // TODO: find a way to do this in WGSL, for now the fog is not working\n    // let depth = gl_FragCoord.z / gl_FragCoord.w;\n    let depth = 1.0;\n\n    var fogFactor : f32 = 0.0;\n\n    #if (FOG == LINEAR)\n        fogFactor = (uniform.fog_end - depth) / (uniform.fog_end - uniform.fog_start);\n    #elif (FOG == EXP)\n        fogFactor = exp(-depth * uniform.fog_density);\n    #elif (FOG == EXP2)\n        fogFactor = exp(-depth * depth * uniform.fog_density * uniform.fog_density);\n    #endif\n\n    return clamp(fogFactor, 0.0, 1.0);\n}\n\nfn addFog(color : vec3f) -> vec3f {\n    #if (FOG != NONE)\n        return mix(uniform.fog_color * uniform.dBlendModeFogFactor, color, getFogFactor());\n    #else\n        return color;\n    #endif\n}\n";

var gammaPS = '\n\n#include "decodePS"\n\n#if (GAMMA == SRGB)\n\n    fn gammaCorrectInput(color: f32) -> f32 {\n        return decodeGammaFloat(color);\n    }\n\n    fn gammaCorrectInputVec3(color: vec3f) -> vec3f {\n        return decodeGammaVec3(color);\n    }\n\n    fn gammaCorrectInputVec4(color: vec4f) -> vec4f {\n        return vec4f(decodeGammaVec3(color.xyz), color.w);\n    }\n\n    fn gammaCorrectOutput(color: vec3f) -> vec3f {\n        return pow(color + 0.0000001, vec3f(1.0 / 2.2));\n    }\n\n#else // NONE\n\n    fn gammaCorrectInput(color: f32) -> f32 {\n        return color;\n    }\n\n    fn gammaCorrectInputVec3(color: vec3f) -> vec3f {\n        return color;\n    }\n\n    fn gammaCorrectInputVec4(color: vec4f) -> vec4f {\n        return color;\n    }\n\n    fn gammaCorrectOutput(color: vec3f) -> vec3f {\n        return color;\n    }\n\n#endif\n';

var immediateLinePS = '\n    #include "gammaPS"\n    varying color: vec4f;\n    @fragment\n    fn fragmentMain(input : FragmentInput) -> FragmentOutput {\n        var output: FragmentOutput;\n        output.color = vec4f(gammaCorrectOutput(decodeGammaVec3(input.color.rgb)), input.color.a);\n        return output;\n    }\n';

var immediateLineVS = "\n    attribute vertex_position: vec4f;\n    attribute vertex_color: vec4f;\n    uniform matrix_model: mat4x4f;\n    uniform matrix_viewProjection: mat4x4f;\n    varying color: vec4f;\n    @vertex\n    fn vertexMain(input : VertexInput) -> VertexOutput {\n        var output : VertexOutput;\n        output.color = input.vertex_color;\n        output.position = uniform.matrix_viewProjection * uniform.matrix_model * input.vertex_position;\n        return output;\n    }\n";

var morphEvaluationPS = "\n    color += uniform.morphFactor[{i}].element * textureSampleLevel(morphBlendTex{i}, morphBlendTex{i}Sampler, input.uv0, 0).xyz;\n";

var morphDeclarationPS = "\n    var morphBlendTex{i}: texture_2d<f32>;\n    var morphBlendTex{i}Sampler : sampler;\n";

var morphPS = '\n\n    varying uv0: vec2f;\n\n    // LOOP - source morph target textures\n    #include "morphDeclarationPS, MORPH_TEXTURE_COUNT"\n\n    #if MORPH_TEXTURE_COUNT > 0\n        uniform morphFactor: array<f32, {MORPH_TEXTURE_COUNT}>;\n    #endif\n\n    @fragment\n    fn fragmentMain(input : FragmentInput) -> FragmentOutput {\n        var output: FragmentOutput;\n\n        var color = vec3f(0, 0, 0);\n\n        // LOOP - source morph target textures\n        #include "morphEvaluationPS, MORPH_TEXTURE_COUNT"\n\n        output.color = vec4f(color, 1.0);\n        return output;\n    }\n';

var morphVS = "\n    attribute vertex_position: vec2f;\n    varying uv0: vec2f;\n\n    @vertex\n    fn vertexMain(input: VertexInput) -> VertexOutput {\n        var output: VertexOutput;\n        output.position = vec4f(input.vertex_position, 0.5, 1.0);\n        output.uv0 = input.vertex_position * 0.5 + vec2f(0.5, 0.5);\n        return output;\n    }\n";

var reprojectPS = '\n\nvarying vUv0: vec2f;\n\n#ifdef CUBEMAP_SOURCE\n    var sourceCube: texture_cube<f32>;\n    var sourceCubeSampler : sampler;\n#else\n    var sourceTex: texture_2d<f32>;\n    var sourceTexSampler : sampler;\n#endif\n\n#ifdef USE_SAMPLES_TEX\n    // samples\n    var samplesTex: texture_2d<f32>;\n    var samplesTexSampler : sampler;\n    uniform samplesTexInverseSize: vec2f;\n#endif\n\n// params:\n// x - target cubemap face 0..6\n// y - target image total pixels\n// z - source cubemap size\nuniform params: vec3f;\n\nfn targetFace() -> f32 { return uniform.params.x; }\nfn targetTotalPixels() -> f32 { return uniform.params.y; }\nfn sourceTotalPixels() -> f32 { return uniform.params.z; }\n\nconst PI: f32 = 3.141592653589793;\n\nfn saturate(x: f32) -> f32 {\n    return clamp(x, 0.0, 1.0);\n}\n\n#include "decodePS"\n#include "encodePS"\n\n//-- supported projections\n\nfn modifySeams(dir: vec3f, scale: f32) -> vec3f {\n    let adir = abs(dir);\n    let M = max(max(adir.x, adir.y), adir.z);\n    return dir / M * vec3f(\n        select(scale, 1.0, adir.x == M),\n        select(scale, 1.0, adir.y == M),\n        select(scale, 1.0, adir.z == M)\n    );\n}\n\nfn toSpherical(dir: vec3f) -> vec2f {\n    let nonZeroXZ = any(dir.xz != vec2f(0.0, 0.0));\n    return vec2f(select(0.0, atan2(dir.x, dir.z), nonZeroXZ), asin(dir.y));\n}\n\nfn fromSpherical(uv: vec2f) -> vec3f {\n    return vec3f(cos(uv.y) * sin(uv.x),\n                sin(uv.y),\n                cos(uv.y) * cos(uv.x));\n}\n\nfn getDirectionEquirect(uv: vec2f) -> vec3f {\n    return fromSpherical((vec2f(uv.x, 1.0 - uv.y) * 2.0 - 1.0) * vec2f(PI, PI * 0.5));\n}\n\n// octahedral code, based on https://jcgt.org/published/0003/02/01/\n// "Survey of Efficient Representations for Independent Unit Vectors" by Cigolle, Donow, Evangelakos, Mara, McGuire, Meyer\n\nfn signNotZero(k: f32) -> f32 {\n    return select(-1.0, 1.0, k >= 0.0);\n}\n\nfn signNotZeroVec2(v: vec2f) -> vec2f {\n    return vec2f(signNotZero(v.x), signNotZero(v.y));\n}\n\n// Returns a unit vector. Argument o is an octahedral vector packed via octEncode, on the [-1, +1] square\nfn octDecode(o: vec2f) -> vec3f {\n    var v = vec3f(o.x, 1.0 - abs(o.x) - abs(o.y), o.y);\n    if (v.y < 0.0) {\n        var temp: vec2f = (1.0 - abs(v.zx)) * signNotZeroVec2(v.xz);\n        v = vec3f(temp.x, v.y, temp.y);\n    }\n    return normalize(v);\n}\n\nfn getDirectionOctahedral(uv: vec2f) -> vec3f {\n    return octDecode(vec2f(uv.x, 1.0 - uv.y) * 2.0 - 1.0);\n}\n\n// Assumes that v is a unit vector. The result is an octahedral vector on the [-1, +1] square\nfn octEncode(v: vec3f) -> vec2f {\n    let l1norm = abs(v.x) + abs(v.y) + abs(v.z);\n    var result = v.xz * (1.0 / l1norm);\n    if (v.y < 0.0) {\n        result = (1.0 - abs(result.yx)) * signNotZeroVec2(result.xy);\n    }\n    return result;\n}\n\n/////////////////////////////////////////////////////////////////////\n\n#ifdef CUBEMAP_SOURCE\n    fn sampleCubemapDir(dir: vec3f) -> vec4f {\n        return textureSample(sourceCube, sourceCubeSampler, modifySeams(dir, 1.0));\n    }\n\n    fn sampleCubemapSph(sph: vec2f) -> vec4f {\n        return sampleCubemapDir(fromSpherical(sph));\n    }\n\n    fn sampleCubemapDirLod(dir: vec3f, mipLevel: f32) -> vec4f {\n        return textureSampleLevel(sourceCube, sourceCubeSampler, modifySeams(dir, 1.0), mipLevel);\n    }\n\n    fn sampleCubemapSphLod(sph: vec2f, mipLevel: f32) -> vec4f {\n        return sampleCubemapDirLod(fromSpherical(sph), mipLevel);\n    }\n#else\n\n    fn sampleEquirectSph(sph: vec2f) -> vec4f {\n        let uv = sph / vec2f(PI * 2.0, PI) + 0.5;\n        return textureSample(sourceTex, sourceTexSampler, vec2f(uv.x, 1.0 - uv.y));\n    }\n\n    fn sampleEquirectDir(dir: vec3f) -> vec4f {\n        return sampleEquirectSph(toSpherical(dir));\n    }\n\n    fn sampleEquirectSphLod(sph: vec2f, mipLevel: f32) -> vec4f {\n        let uv = sph / vec2f(PI * 2.0, PI) + 0.5;\n        return textureSampleLevel(sourceTex, sourceTexSampler, vec2f(uv.x, 1.0 - uv.y), mipLevel);\n    }\n\n    fn sampleEquirectDirLod(dir: vec3f, mipLevel: f32) -> vec4f {\n        return sampleEquirectSphLod(toSpherical(dir), mipLevel);\n    }\n\n    fn sampleOctahedralDir(dir: vec3f) -> vec4f {\n        let uv = octEncode(dir) * 0.5 + 0.5;\n        return textureSample(sourceTex, sourceTexSampler, vec2f(uv.x, 1.0 - uv.y));\n    }\n\n    fn sampleOctahedralSph(sph: vec2f) -> vec4f {\n        return sampleOctahedralDir(fromSpherical(sph));\n    }\n\n    fn sampleOctahedralDirLod(dir: vec3f, mipLevel: f32) -> vec4f {\n        let uv = octEncode(dir) * 0.5 + 0.5;\n        return textureSampleLevel(sourceTex, sourceTexSampler, vec2f(uv.x, 1.0 - uv.y), mipLevel);\n    }\n\n    fn sampleOctahedralSphLod(sph: vec2f, mipLevel: f32) -> vec4f {\n        return sampleOctahedralDirLod(fromSpherical(sph), mipLevel);\n    }\n\n#endif\n\nfn getDirectionCubemap(uv: vec2f) -> vec3f {\n    let st = uv * 2.0 - 1.0;\n    let face = targetFace();\n\n    var vec: vec3f;\n    if (face == 0.0) {\n        vec = vec3f(1, -st.y, -st.x);\n    } else if (face == 1.0) {\n        vec = vec3f(-1, -st.y, st.x);\n    } else if (face == 2.0) {\n        vec = vec3f(st.x, 1, st.y);\n    } else if (face == 3.0) {\n        vec = vec3f(st.x, -1, -st.y);\n    } else if (face == 4.0) {\n        vec = vec3f(st.x, -st.y, 1);\n    } else {\n        vec = vec3f(-st.x, -st.y, -1);\n    }\n\n    return normalize(modifySeams(vec, 1.0));\n}\n\nfn matrixFromVector(n: vec3f) -> mat3x3f {\n    let a = 1.0 / (1.0 + n.z);\n    let b = -n.x * n.y * a;\n    let b1 = vec3f(1.0 - n.x * n.x * a, b, -n.x);\n    let b2 = vec3f(b, 1.0 - n.y * n.y * a, -n.y);\n    return mat3x3f(b1, b2, n);\n}\n\nfn matrixFromVectorSlow(n: vec3f) -> mat3x3f {\n    let up = select(vec3f(0.0, 0.0, select(-1.0, 1.0, n.y > 0.0)), vec3f(0.0, 1.0, 0.0), abs(n.y) > 0.0000001);\n    let x = normalize(cross(up, n));\n    let y = cross(n, x);\n    return mat3x3f(x, y, n);\n}\n\nfn reproject(uv: vec2f) -> vec4f {\n    if ({NUM_SAMPLES} <= 1) {\n        // single sample\n        return {ENCODE_FUNC}({DECODE_FUNC}({SOURCE_FUNC}Dir({TARGET_FUNC}(uv))));\n    } else {\n        // multi sample\n        let t = {TARGET_FUNC}(uv);\n        let tu = dpdx(t);\n        let tv = dpdy(t);\n\n        var result = vec3f(0.0);\n        for (var u = 0.0; u < {NUM_SAMPLES_SQRT}; u += 1.0) {\n            for (var v = 0.0; v < {NUM_SAMPLES_SQRT}; v += 1.0) {\n                result += {DECODE_FUNC}({SOURCE_FUNC}Dir(normalize(t +\n                                                            tu * (u / {NUM_SAMPLES_SQRT} - 0.5) +\n                                                            tv * (v / {NUM_SAMPLES_SQRT} - 0.5))));\n            }\n        }\n        return {ENCODE_FUNC}(result / ({NUM_SAMPLES_SQRT} * {NUM_SAMPLES_SQRT}));\n    }\n}\n\nconst unpackFloat: vec4f = vec4f(1.0, 1.0 / 255.0, 1.0 / 65025.0, 1.0 / 16581375.0);\n\n#ifdef USE_SAMPLES_TEX\n    fn unpackSample(i: i32, L: ptr<function, vec3f>, mipLevel: ptr<function, f32>) {\n        var u = (f32(i * 4) + 0.5) * uniform.samplesTexInverseSize.x;\n        var v = (floor(u) + 0.5) * uniform.samplesTexInverseSize.y;\n\n        var raw: vec4f;\n        raw.x = dot(textureSample(samplesTex, samplesTexSampler, vec2f(u, v)), unpackFloat); u += uniform.samplesTexInverseSize.x;\n        raw.y = dot(textureSample(samplesTex, samplesTexSampler, vec2f(u, v)), unpackFloat); u += uniform.samplesTexInverseSize.x;\n        raw.z = dot(textureSample(samplesTex, samplesTexSampler, vec2f(u, v)), unpackFloat); u += uniform.samplesTexInverseSize.x;\n        raw.w = dot(textureSample(samplesTex, samplesTexSampler, vec2f(u, v)), unpackFloat);\n\n        *L = raw.xyz * 2.0 - 1.0;\n        *mipLevel = raw.w * 8.0;\n    }\n\n    // convolve an environment given pre-generated samples\n    fn prefilterSamples(uv: vec2f) -> vec4f {\n        // construct vector space given target direction\n        let vecSpace = matrixFromVectorSlow({TARGET_FUNC}(uv));\n\n        var L: vec3f;\n        var mipLevel: f32;\n\n        var result = vec3f(0.0);\n        var totalWeight = 0.0;\n        for (var i = 0; i < {NUM_SAMPLES}; i += 1) {\n            unpackSample(i, &L, &mipLevel);\n            result += {DECODE_FUNC}({SOURCE_FUNC}DirLod(vecSpace * L, mipLevel)) * L.z;\n            totalWeight += L.z;\n        }\n\n        return {ENCODE_FUNC}(result / totalWeight);\n    }\n\n    // unweighted version of prefilterSamples\n    fn prefilterSamplesUnweighted(uv: vec2f) -> vec4f {\n        // construct vector space given target direction\n        let vecSpace = matrixFromVectorSlow({TARGET_FUNC}(uv));\n\n        var L: vec3f;\n        var mipLevel: f32;\n\n        var result = vec3f(0.0);\n        for (var i = 0; i < {NUM_SAMPLES}; i += 1) {\n            unpackSample(i, &L, &mipLevel);\n            result += {DECODE_FUNC}({SOURCE_FUNC}DirLod(vecSpace * L, mipLevel));\n        }\n\n        return {ENCODE_FUNC}(result / f32({NUM_SAMPLES}));\n    }\n#endif\n\n@fragment\nfn fragmentMain(input : FragmentInput) -> FragmentOutput {\n    var output: FragmentOutput;\n    output.color = {PROCESS_FUNC}(input.vUv0);\n    return output;\n}\n';

var reprojectVS = "\nattribute vertex_position: vec2f;\nuniform uvMod: vec4f;\nvarying vUv0: vec2f;\n\n@vertex\nfn vertexMain(input: VertexInput) -> VertexOutput {\n  var output: VertexOutput;\n  output.position = vec4f(input.vertex_position, 0.5, 1.0);\n  output.vUv0 = getImageEffectUV((input.vertex_position * 0.5 + vec2f(0.5, 0.5)) * uniform.uvMod.xy + uniform.uvMod.zw);\n  return output;\n}\n";

var skyboxPS = '\n    #define LIT_SKYBOX_INTENSITY\n\n    #include "envProcPS"\n    #include "gammaPS"\n    #include "tonemappingPS"\n\n    // Varying and uniform declarations\n    varying vViewDir : vec3f;\n    uniform skyboxHighlightMultiplier : f32;\n\n    #ifdef SKY_CUBEMAP\n\n        var texture_cubeMap : texture_cube<f32>;\n        var texture_cubeMap_sampler : sampler;\n\n        #ifdef SKYMESH\n            varying vWorldPos : vec3f;\n            uniform cubeMapRotationMatrix : mat3x3f;\n            uniform projectedSkydomeCenter : vec3f;\n        #endif\n\n    #else // env-atlas\n\n        #include "sphericalPS"\n        #include "envAtlasPS"\n\n        var texture_envAtlas : texture_2d<f32>;\n        var texture_envAtlas_sampler : sampler;\n\n        uniform mipLevel : f32;\n\n    #endif\n\n    @fragment\n    fn fragmentMain(input : FragmentInput) -> FragmentOutput {\n\n        var linear : vec3f;\n        var dir : vec3f;\n\n        #ifdef SKY_CUBEMAP\n\n            #ifdef SKYMESH\n                // get vector from world space pos to tripod origin\n                var envDir : vec3f = normalize(input.vWorldPos - uniform.projectedSkydomeCenter);\n                dir = envDir * uniform.cubeMapRotationMatrix;\n            #else\n                dir = input.vViewDir;\n            #endif\n\n            dir.x *= -1.0;\n            linear = {SKYBOX_DECODE_FNC}(textureSample(texture_cubeMap, texture_cubeMap_sampler, dir));\n\n        #else // env-atlas\n\n            dir = input.vViewDir * vec3f(-1.0, 1.0, 1.0);\n            let uv : vec2f = toSphericalUv(normalize(dir));\n            linear = {SKYBOX_DECODE_FNC}(textureSample(texture_envAtlas, texture_envAtlas_sampler, mapRoughnessUv(uv, uniform.mipLevel)));\n\n        #endif\n\n        // our HDR encodes values up to 64, so allow extra brightness for the clipped values\n        if (any(linear >= vec3f(64.0))) {\n            linear *= uniform.skyboxHighlightMultiplier;\n        }\n        \n        var output: FragmentOutput;\n        output.color = vec4f(gammaCorrectOutput(toneMap(processEnvironment(linear))), 1.0);\n        return output;\n    }\n';

var skyboxVS = "\n    // Attribute\n    attribute aPosition : vec4f;\n\n    #ifndef VIEWMATRIX\n    #define VIEWMATRIX\n    uniform matrix_view : mat4x4f;\n    #endif\n\n    uniform matrix_projectionSkybox : mat4x4f;\n    uniform cubeMapRotationMatrix : mat3x3f;\n\n    varying vViewDir : vec3f;\n\n    #ifdef SKYMESH\n        uniform matrix_model : mat4x4f;\n        varying vWorldPos : vec3f;\n    #endif\n\n    @vertex\n    fn vertexMain(input : VertexInput) -> VertexOutput {\n\n        var output : VertexOutput;\n        var view : mat4x4f = uniform.matrix_view;\n\n        #ifdef SKYMESH\n\n            var worldPos : vec4f = uniform.matrix_model * input.aPosition;\n            output.vWorldPos = worldPos.xyz;\n            output.position = uniform.matrix_projectionSkybox * (view * worldPos);\n\n        #else\n\n            view[3][0] = 0.0;\n            view[3][1] = 0.0;\n            view[3][2] = 0.0;\n            output.position = uniform.matrix_projectionSkybox * (view * input.aPosition);\n            output.vViewDir = input.aPosition.xyz * uniform.cubeMapRotationMatrix;\n\n        #endif\n\n        // Force skybox to far Z, regardless of the clip planes on the camera\n        // Subtract a tiny fudge factor to ensure floating point errors don't\n        // still push pixels beyond far Z. See:\n        // https://community.khronos.org/t/skybox-problem/61857\n\n        output.position.z = output.position.w - 1.0e-7;\n\n        return output;\n    }\n";

var sphericalPS = "\n// equirectangular helper functions\nconst PI : f32 = 3.141592653589793;\n\nfn toSpherical(dir: vec3f) -> vec2f {\n    let angle_xz = select(0.0, atan2(dir.x, dir.z), any(dir.xz != vec2f(0.0)));\n    return vec2f(angle_xz, asin(dir.y));\n}\n\nfn toSphericalUv(dir : vec3f) -> vec2f {\n    let uv : vec2f = toSpherical(dir) / vec2f(PI * 2.0, PI) + vec2f(0.5, 0.5);\n    return vec2f(uv.x, 1.0 - uv.y);\n}\n";

var tonemappingPS = '\n#if (TONEMAP == NONE)\n    #include "tonemappingNonePS"\n#elif TONEMAP == FILMIC\n    #include "tonemappingFilmicPS"\n#elif TONEMAP == LINEAR\n    #include "tonemappingLinearPS"\n#elif TONEMAP == HEJL\n    #include "tonemappingHejlPS"\n#elif TONEMAP == ACES\n    #include "tonemappingAcesPS"\n#elif TONEMAP == ACES2\n    #include "tonemappingAces2PS"\n#elif TONEMAP == NEUTRAL\n    #include "tonemappingNeutralPS"\n#endif\n';

var tonemappingAcesPS = "\nuniform exposure: f32;\n\nfn toneMap(color: vec3f) -> vec3f {\n    let tA: f32 = 2.51;\n    let tB: f32 = 0.03;\n    let tC: f32 = 2.43;\n    let tD: f32 = 0.59;\n    let tE: f32 = 0.14;\n    let x: vec3f = color * uniform.exposure;\n    return (x * (tA * x + tB)) / (x * (tC * x + tD) + tE);\n}\n";

var tonemappingAces2PS = "\nuniform exposure: f32;\n\n// ACES approximation by Stephen Hill\n\n// sRGB => XYZ => D65_2_D60 => AP1 => RRT_SAT\nconst ACESInputMat: mat3x3f = mat3x3f(\n    vec3f(0.59719, 0.35458, 0.04823),\n    vec3f(0.07600, 0.90834, 0.01566),\n    vec3f(0.02840, 0.13383, 0.83777)\n);\n\n// ODT_SAT => XYZ => D60_2_D65 => sRGB\nconst ACESOutputMat: mat3x3f = mat3x3f(\n    vec3f( 1.60475, -0.53108, -0.07367),\n    vec3f(-0.10208,  1.10813, -0.00605),\n    vec3f(-0.00327, -0.07276,  1.07602)\n);\n\nfn RRTAndODTFit(v: vec3f) -> vec3f {\n    let a: vec3f = v * (v + vec3f(0.0245786)) - vec3f(0.000090537);\n    let b: vec3f = v * (vec3f(0.983729) * v + vec3f(0.4329510)) + vec3f(0.238081);\n    return a / b;\n}\n\nfn toneMap(color: vec3f) -> vec3f {\n    var c: vec3f = color * (uniform.exposure / 0.6);\n    c = ACESInputMat * c;\n\n    // Apply RRT and ODT\n    c = RRTAndODTFit(c);\n    c = ACESOutputMat * c;\n\n    // Clamp to [0, 1]\n    return clamp(c, vec3f(0.0), vec3f(1.0));\n}\n";

var tonemappingFilmicPS = "\nconst A: f32 = 0.15;\nconst B: f32 = 0.50;\nconst C: f32 = 0.10;\nconst D: f32 = 0.20;\nconst E: f32 = 0.02;\nconst F: f32 = 0.30;\nconst W: f32 = 11.2;\n\nuniform exposure: f32;\n\nfn uncharted2Tonemap(x: vec3f) -> vec3f {\n    return ((x * (A * x + C * B) + D * E) / (x * (A * x + B) + D * F)) - vec3f(E / F);\n}\n\nfn toneMap(color: vec3f) -> vec3f {\n    var c: vec3f = uncharted2Tonemap(color * uniform.exposure);\n    let whiteScale: vec3f = vec3f(1.0) / uncharted2Tonemap(vec3f(W, W, W));\n    c *= whiteScale;\n    return c;\n}\n";

var tonemappingHejlPS = "\nuniform exposure: f32;\n\nfn toneMap(color: vec3f) -> vec3f {\n    let A: f32 = 0.22;\n    let B: f32 = 0.3;\n    let C: f32 = 0.1;\n    let D: f32 = 0.2;\n    let E: f32 = 0.01;\n    let F: f32 = 0.3;\n    let Scl: f32 = 1.25;\n\n    let adjusted_color = color * uniform.exposure;\n    let h = max(vec3f(0.0), adjusted_color - vec3f(0.004));\n\n    return (h * ((Scl * A) * h + Scl * vec3f(C * B)) + Scl * vec3f(D * E)) /\n           (h * (A * h + vec3f(B)) + vec3f(D * F)) -\n           Scl * vec3f(E / F);\n}\n";

var tonemappingLinearPS = "\nuniform exposure: f32;\n\nfn toneMap(color: vec3f) -> vec3f {\n    return color * uniform.exposure;\n}\n";

var tonemappingNeutralPS = "\nuniform exposure: f32;\n\nfn toneMap(col: vec3f) -> vec3f {\n    var color = col * uniform.exposure;\n\n    let startCompression = 0.8 - 0.04;\n    let desaturation = 0.15;\n\n    let x = min(color.r, min(color.g, color.b));\n    let offset = select(0.04, x - 6.25 * x * x, x < 0.08);\n    color -= vec3f(offset);\n\n    let peak = max(color.r, max(color.g, color.b));\n    if (peak < startCompression) {\n        return color;\n    }\n\n    let d = 1.0 - startCompression;\n    let newPeak = 1.0 - d * d / (peak + d - startCompression);\n    color *= newPeak / peak;\n\n    let g = 1.0 - 1.0 / (desaturation * (peak - newPeak) + 1.0);\n    return mix(color, vec3f(newPeak), vec3f(g));\n}\n";

var tonemappingNonePS = "\nfn toneMap(color: vec3f) -> vec3f {\n    return color;\n}\n";

var shaderChunksWGSL = {
		decodePS,
		encodePS,
		envAtlasPS,
		envProcPS,
		fogPS,
		gammaPS,
		immediateLinePS,
		immediateLineVS,
		lightBufferDefinesPS: '',
		morphEvaluationPS,
		morphDeclarationPS,
		morphPS,
		morphVS,
		reprojectPS,
		reprojectVS,
		skyboxPS,
		skyboxVS,
		sphericalPS,
		tonemappingPS,
		tonemappingAcesPS,
		tonemappingAces2PS,
		tonemappingFilmicPS,
		tonemappingHejlPS,
		tonemappingLinearPS,
		tonemappingNeutralPS,
		tonemappingNonePS
};

var epsilon$1 = 0.000001;
var tempVec3$1 = new Vec3();
var tempAreaLightSizes = new Float32Array(6);
var areaHalfAxisWidth = new Vec3(-0.5, 0, 0);
var areaHalfAxisHeight = new Vec3(0, 0, 0.5);
var TextureIndex8 = {
		FLAGS: 0,
		COLOR_A: 1,
		COLOR_B: 2,
		SPOT_ANGLES: 3,
		SHADOW_BIAS: 4,
		COOKIE_A: 5,
		COOKIE_B: 6,
		COUNT: 7
};
var TextureIndexFloat = {
		POSITION_RANGE: 0,
		SPOT_DIRECTION: 1,
		PROJ_MAT_0: 2,
		ATLAS_VIEWPORT: 2,
		PROJ_MAT_1: 3,
		PROJ_MAT_2: 4,
		PROJ_MAT_3: 5,
		AREA_DATA_WIDTH: 6,
		AREA_DATA_HEIGHT: 7,
		COUNT: 8
};
var buildShaderDefines = (object, prefix)=>{
		return Object.keys(object).map((key)=>"#define " + prefix + key + " " + object[key]).join('\n');
};
shaderChunks.lightBufferDefinesPS = shaderChunksWGSL.lightBufferDefinesPS = "\n\n    " + buildShaderDefines(TextureIndex8, 'CLUSTER_TEXTURE_8_') + "\n    " + buildShaderDefines(TextureIndexFloat, 'CLUSTER_TEXTURE_F_') + "\n";
class LightsBuffer {
		destroy() {
				var _this_lightsTexture8, _this_lightsTextureFloat;
				(_this_lightsTexture8 = this.lightsTexture8) == null ? void 0 : _this_lightsTexture8.destroy();
				this.lightsTexture8 = null;
				(_this_lightsTextureFloat = this.lightsTextureFloat) == null ? void 0 : _this_lightsTextureFloat.destroy();
				this.lightsTextureFloat = null;
		}
		createTexture(device, width, height, format, name) {
				var tex = new Texture(device, {
						name: name,
						width: width,
						height: height,
						mipmaps: false,
						format: format,
						addressU: ADDRESS_CLAMP_TO_EDGE,
						addressV: ADDRESS_CLAMP_TO_EDGE,
						type: TEXTURETYPE_DEFAULT,
						magFilter: FILTER_NEAREST,
						minFilter: FILTER_NEAREST,
						anisotropy: 1
				});
				return tex;
		}
		setCompressionRanges(maxAttenuation, maxColorValue) {
				this.invMaxColorValue = 1 / maxColorValue;
				this.invMaxAttenuation = 1 / maxAttenuation;
		}
		setBounds(min, delta) {
				this.boundsMin.copy(min);
				this.boundsDelta.copy(delta);
		}
		uploadTextures() {
				this.lightsTextureFloat.lock().set(this.lightsFloat);
				this.lightsTextureFloat.unlock();
				this.lightsTexture8.lock().set(this.lights8);
				this.lightsTexture8.unlock();
		}
		updateUniforms() {
				this._lightsTexture8Id.setValue(this.lightsTexture8);
				this._lightsTextureFloatId.setValue(this.lightsTextureFloat);
		}
		getSpotDirection(direction, spot) {
				var mat = spot._node.getWorldTransform();
				mat.getY(direction).mulScalar(-1);
				direction.normalize();
		}
		getLightAreaSizes(light) {
				var mat = light._node.getWorldTransform();
				mat.transformVector(areaHalfAxisWidth, tempVec3$1);
				tempAreaLightSizes[0] = tempVec3$1.x;
				tempAreaLightSizes[1] = tempVec3$1.y;
				tempAreaLightSizes[2] = tempVec3$1.z;
				mat.transformVector(areaHalfAxisHeight, tempVec3$1);
				tempAreaLightSizes[3] = tempVec3$1.x;
				tempAreaLightSizes[4] = tempVec3$1.y;
				tempAreaLightSizes[5] = tempVec3$1.z;
				return tempAreaLightSizes;
		}
		addLightDataFlags(data8, index, light, isSpot, castShadows, shadowIntensity) {
				data8[index + 0] = isSpot ? 255 : 0;
				data8[index + 1] = this.areaLightsEnabled ? light._shape * 64 : 0;
				data8[index + 2] = light._falloffMode * 255;
				data8[index + 3] = castShadows ? shadowIntensity * 255 : 0;
		}
		addLightDataColor(data8, index, light, isCookie) {
				var invMaxColorValue = this.invMaxColorValue;
				var color = light._colorLinear;
				FloatPacking.float2Bytes(color[0] * invMaxColorValue, data8, index + 0, 2);
				FloatPacking.float2Bytes(color[1] * invMaxColorValue, data8, index + 2, 2);
				FloatPacking.float2Bytes(color[2] * invMaxColorValue, data8, index + 4, 2);
				data8[index + 6] = isCookie ? 255 : 0;
				var isDynamic = !!(light.mask & MASK_AFFECT_DYNAMIC);
				var isLightmapped = !!(light.mask & MASK_AFFECT_LIGHTMAPPED);
				data8[index + 7] = isDynamic && isLightmapped ? 127 : isLightmapped ? 255 : 0;
		}
		addLightDataSpotAngles(data8, index, light) {
				FloatPacking.float2Bytes(light._innerConeAngleCos * (0.5 - epsilon$1) + 0.5, data8, index + 0, 2);
				FloatPacking.float2Bytes(light._outerConeAngleCos * (0.5 - epsilon$1) + 0.5, data8, index + 2, 2);
		}
		addLightDataShadowBias(data8, index, light) {
				var lightRenderData = light.getRenderData(null, 0);
				var biases = light._getUniformBiasValues(lightRenderData);
				FloatPacking.float2BytesRange(biases.bias, data8, index, -1, 20, 2);
				FloatPacking.float2Bytes(biases.normalBias, data8, index + 2, 2);
		}
		addLightDataCookies(data8, index, light) {
				var isRgb = light._cookieChannel === 'rgb';
				data8[index + 0] = Math.floor(light.cookieIntensity * 255);
				data8[index + 1] = isRgb ? 255 : 0;
				if (!isRgb) {
						var channel = light._cookieChannel;
						data8[index + 4] = channel === 'rrr' ? 255 : 0;
						data8[index + 5] = channel === 'ggg' ? 255 : 0;
						data8[index + 6] = channel === 'bbb' ? 255 : 0;
						data8[index + 7] = channel === 'aaa' ? 255 : 0;
				}
		}
		addLightData(light, lightIndex) {
				var isSpot = light._type === LIGHTTYPE_SPOT;
				var hasAtlasViewport = light.atlasViewportAllocated;
				var isCookie = this.cookiesEnabled && !!light._cookie && hasAtlasViewport;
				var isArea = this.areaLightsEnabled && light.shape !== LIGHTSHAPE_PUNCTUAL;
				var castShadows = this.shadowsEnabled && light.castShadows && hasAtlasViewport;
				var pos = light._node.getPosition();
				var lightProjectionMatrix = null;
				var atlasViewport = null;
				if (isSpot) {
						if (castShadows) {
								var lightRenderData = light.getRenderData(null, 0);
								lightProjectionMatrix = lightRenderData.shadowMatrix;
						} else if (isCookie) {
								lightProjectionMatrix = LightCamera.evalSpotCookieMatrix(light);
						}
				} else {
						if (castShadows || isCookie) {
								atlasViewport = light.atlasViewport;
						}
				}
				var data8 = this.lights8;
				var data8Start = lightIndex * this.lightsTexture8.width * 4;
				this.addLightDataFlags(data8, data8Start + 4 * TextureIndex8.FLAGS, light, isSpot, castShadows, light.shadowIntensity);
				this.addLightDataColor(data8, data8Start + 4 * TextureIndex8.COLOR_A, light, isCookie);
				if (isSpot) {
						this.addLightDataSpotAngles(data8, data8Start + 4 * TextureIndex8.SPOT_ANGLES, light);
				}
				if (light.castShadows) {
						this.addLightDataShadowBias(data8, data8Start + 4 * TextureIndex8.SHADOW_BIAS, light);
				}
				if (isCookie) {
						this.addLightDataCookies(data8, data8Start + 4 * TextureIndex8.COOKIE_A, light);
				}
				var dataFloat = this.lightsFloat;
				var dataFloatStart = lightIndex * this.lightsTextureFloat.width * 4;
				dataFloat[dataFloatStart + 4 * TextureIndexFloat.POSITION_RANGE + 0] = pos.x;
				dataFloat[dataFloatStart + 4 * TextureIndexFloat.POSITION_RANGE + 1] = pos.y;
				dataFloat[dataFloatStart + 4 * TextureIndexFloat.POSITION_RANGE + 2] = pos.z;
				dataFloat[dataFloatStart + 4 * TextureIndexFloat.POSITION_RANGE + 3] = light.attenuationEnd;
				if (isSpot) {
						this.getSpotDirection(tempVec3$1, light);
						dataFloat[dataFloatStart + 4 * TextureIndexFloat.SPOT_DIRECTION + 0] = tempVec3$1.x;
						dataFloat[dataFloatStart + 4 * TextureIndexFloat.SPOT_DIRECTION + 1] = tempVec3$1.y;
						dataFloat[dataFloatStart + 4 * TextureIndexFloat.SPOT_DIRECTION + 2] = tempVec3$1.z;
				}
				if (lightProjectionMatrix) {
						var matData = lightProjectionMatrix.data;
						for(var m = 0; m < 16; m++){
								dataFloat[dataFloatStart + 4 * TextureIndexFloat.PROJ_MAT_0 + m] = matData[m];
						}
				}
				if (atlasViewport) {
						dataFloat[dataFloatStart + 4 * TextureIndexFloat.ATLAS_VIEWPORT + 0] = atlasViewport.x;
						dataFloat[dataFloatStart + 4 * TextureIndexFloat.ATLAS_VIEWPORT + 1] = atlasViewport.y;
						dataFloat[dataFloatStart + 4 * TextureIndexFloat.ATLAS_VIEWPORT + 2] = atlasViewport.z / 3;
				}
				if (isArea) {
						var areaSizes = this.getLightAreaSizes(light);
						dataFloat[dataFloatStart + 4 * TextureIndexFloat.AREA_DATA_WIDTH + 0] = areaSizes[0];
						dataFloat[dataFloatStart + 4 * TextureIndexFloat.AREA_DATA_WIDTH + 1] = areaSizes[1];
						dataFloat[dataFloatStart + 4 * TextureIndexFloat.AREA_DATA_WIDTH + 2] = areaSizes[2];
						dataFloat[dataFloatStart + 4 * TextureIndexFloat.AREA_DATA_HEIGHT + 0] = areaSizes[3];
						dataFloat[dataFloatStart + 4 * TextureIndexFloat.AREA_DATA_HEIGHT + 1] = areaSizes[4];
						dataFloat[dataFloatStart + 4 * TextureIndexFloat.AREA_DATA_HEIGHT + 2] = areaSizes[5];
				}
		}
		constructor(device){
				this.areaLightsEnabled = false;
				this.device = device;
				this.cookiesEnabled = false;
				this.shadowsEnabled = false;
				this.areaLightsEnabled = false;
				this.maxLights = 255;
				var pixelsPerLight8 = TextureIndex8.COUNT;
				this.lights8 = new Uint8ClampedArray(4 * pixelsPerLight8 * this.maxLights);
				this.lightsTexture8 = this.createTexture(this.device, pixelsPerLight8, this.maxLights, PIXELFORMAT_RGBA8, 'LightsTexture8');
				this._lightsTexture8Id = this.device.scope.resolve('lightsTexture8');
				var pixelsPerLightFloat = TextureIndexFloat.COUNT;
				this.lightsFloat = new Float32Array(4 * pixelsPerLightFloat * this.maxLights);
				this.lightsTextureFloat = this.createTexture(this.device, pixelsPerLightFloat, this.maxLights, PIXELFORMAT_RGBA32F, 'LightsTextureFloat');
				this._lightsTextureFloatId = this.device.scope.resolve('lightsTextureFloat');
				this.invMaxColorValue = 0;
				this.invMaxAttenuation = 0;
				this.boundsMin = new Vec3();
				this.boundsDelta = new Vec3();
		}
}

var tempVec3 = new Vec3();
var tempMin3 = new Vec3();
var tempMax3 = new Vec3();
var tempBox = new BoundingBox();
var epsilon = 0.000001;
class ClusterLight {
		constructor(){
				this.light = null;
				this.min = new Vec3();
				this.max = new Vec3();
		}
}
class WorldClusters {
		set maxCellLightCount(count) {
				if (count !== this._maxCellLightCount) {
						this._maxCellLightCount = count;
						this._cellsDirty = true;
				}
		}
		get maxCellLightCount() {
				return this._maxCellLightCount;
		}
		set cells(value) {
				tempVec3.copy(value).floor();
				if (!this._cells.equals(tempVec3)) {
						this._cells.copy(tempVec3);
						this._cellsLimit.copy(tempVec3).sub(Vec3.ONE);
						this._cellsDirty = true;
				}
		}
		get cells() {
				return this._cells;
		}
		destroy() {
				this.lightsBuffer.destroy();
				this.releaseClusterTexture();
		}
		releaseClusterTexture() {
				if (this.clusterTexture) {
						this.clusterTexture.destroy();
						this.clusterTexture = null;
				}
		}
		registerUniforms(device) {
				this._clusterSkipId = device.scope.resolve('clusterSkip');
				this._clusterMaxCellsId = device.scope.resolve('clusterMaxCells');
				this._clusterWorldTextureId = device.scope.resolve('clusterWorldTexture');
				this._clusterTextureSizeId = device.scope.resolve('clusterTextureSize');
				this._clusterTextureSizeData = new Float32Array(3);
				this._clusterBoundsMinId = device.scope.resolve('clusterBoundsMin');
				this._clusterBoundsMinData = new Float32Array(3);
				this._clusterBoundsDeltaId = device.scope.resolve('clusterBoundsDelta');
				this._clusterBoundsDeltaData = new Float32Array(3);
				this._clusterCellsCountByBoundsSizeId = device.scope.resolve('clusterCellsCountByBoundsSize');
				this._clusterCellsCountByBoundsSizeData = new Float32Array(3);
				this._clusterCellsDotId = device.scope.resolve('clusterCellsDot');
				this._clusterCellsDotData = new Float32Array(3);
				this._clusterCellsMaxId = device.scope.resolve('clusterCellsMax');
				this._clusterCellsMaxData = new Float32Array(3);
				this._clusterCompressionLimit0Id = device.scope.resolve('clusterCompressionLimit0');
				this._clusterCompressionLimit0Data = new Float32Array(2);
		}
		updateParams(lightingParams) {
				if (lightingParams) {
						this.cells = lightingParams.cells;
						this.maxCellLightCount = lightingParams.maxLightsPerCell;
						this.lightsBuffer.cookiesEnabled = lightingParams.cookiesEnabled;
						this.lightsBuffer.shadowsEnabled = lightingParams.shadowsEnabled;
						this.lightsBuffer.areaLightsEnabled = lightingParams.areaLightsEnabled;
				}
		}
		updateCells() {
				if (this._cellsDirty) {
						this._cellsDirty = false;
						var cx = this._cells.x;
						var cy = this._cells.y;
						var cz = this._cells.z;
						var numCells = cx * cy * cz;
						var totalPixels = this.maxCellLightCount * numCells;
						var width = Math.ceil(Math.sqrt(totalPixels));
						width = math.roundUp(width, this.maxCellLightCount);
						var height = Math.ceil(totalPixels / width);
						this._clusterCellsMaxData[0] = cx;
						this._clusterCellsMaxData[1] = cy;
						this._clusterCellsMaxData[2] = cz;
						this._clusterCellsDotData[0] = this.maxCellLightCount;
						this._clusterCellsDotData[1] = cx * cz * this.maxCellLightCount;
						this._clusterCellsDotData[2] = cx * this.maxCellLightCount;
						this.clusters = new Uint8ClampedArray(totalPixels);
						this.counts = new Int32Array(numCells);
						this._clusterTextureSizeData[0] = width;
						this._clusterTextureSizeData[1] = 1.0 / width;
						this._clusterTextureSizeData[2] = 1.0 / height;
						this.releaseClusterTexture();
						this.clusterTexture = this.lightsBuffer.createTexture(this.device, width, height, PIXELFORMAT_R8, 'ClusterTexture');
				}
		}
		uploadTextures() {
				this.clusterTexture.lock().set(this.clusters);
				this.clusterTexture.unlock();
				this.lightsBuffer.uploadTextures();
		}
		updateUniforms() {
				this._clusterSkipId.setValue(this._usedLights.length > 1 ? 0 : 1);
				this.lightsBuffer.updateUniforms();
				this._clusterWorldTextureId.setValue(this.clusterTexture);
				this._clusterMaxCellsId.setValue(this.maxCellLightCount);
				var boundsDelta = this.boundsDelta;
				this._clusterCellsCountByBoundsSizeData[0] = this._cells.x / boundsDelta.x;
				this._clusterCellsCountByBoundsSizeData[1] = this._cells.y / boundsDelta.y;
				this._clusterCellsCountByBoundsSizeData[2] = this._cells.z / boundsDelta.z;
				this._clusterCellsCountByBoundsSizeId.setValue(this._clusterCellsCountByBoundsSizeData);
				this._clusterBoundsMinData[0] = this.boundsMin.x;
				this._clusterBoundsMinData[1] = this.boundsMin.y;
				this._clusterBoundsMinData[2] = this.boundsMin.z;
				this._clusterBoundsDeltaData[0] = boundsDelta.x;
				this._clusterBoundsDeltaData[1] = boundsDelta.y;
				this._clusterBoundsDeltaData[2] = boundsDelta.z;
				this._clusterCompressionLimit0Data[0] = this._maxAttenuation;
				this._clusterCompressionLimit0Data[1] = this._maxColorValue;
				this._clusterTextureSizeId.setValue(this._clusterTextureSizeData);
				this._clusterBoundsMinId.setValue(this._clusterBoundsMinData);
				this._clusterBoundsDeltaId.setValue(this._clusterBoundsDeltaData);
				this._clusterCellsDotId.setValue(this._clusterCellsDotData);
				this._clusterCellsMaxId.setValue(this._clusterCellsMaxData);
				this._clusterCompressionLimit0Id.setValue(this._clusterCompressionLimit0Data);
		}
		evalLightCellMinMax(clusteredLight, min, max) {
				min.copy(clusteredLight.min);
				min.sub(this.boundsMin);
				min.div(this.boundsDelta);
				min.mul2(min, this.cells);
				min.floor();
				max.copy(clusteredLight.max);
				max.sub(this.boundsMin);
				max.div(this.boundsDelta);
				max.mul2(max, this.cells);
				max.ceil();
				min.max(Vec3.ZERO);
				max.min(this._cellsLimit);
		}
		collectLights(lights) {
				var maxLights = this.lightsBuffer.maxLights;
				var usedLights = this._usedLights;
				var lightIndex = 1;
				lights.forEach((light)=>{
						var runtimeLight = !!(light.mask & (MASK_AFFECT_DYNAMIC | MASK_AFFECT_LIGHTMAPPED));
						var zeroAngleSpotlight = light.type === LIGHTTYPE_SPOT && light._outerConeAngle === 0;
						if (light.enabled && light.type !== LIGHTTYPE_DIRECTIONAL && light.visibleThisFrame && light.intensity > 0 && runtimeLight && !zeroAngleSpotlight) {
								if (lightIndex < maxLights) {
										var clusteredLight;
										if (lightIndex < usedLights.length) {
												clusteredLight = usedLights[lightIndex];
										} else {
												clusteredLight = new ClusterLight();
												usedLights.push(clusteredLight);
										}
										clusteredLight.light = light;
										light.getBoundingBox(tempBox);
										clusteredLight.min.copy(tempBox.getMin());
										clusteredLight.max.copy(tempBox.getMax());
										lightIndex++;
								}
						}
				});
				usedLights.length = lightIndex;
		}
		evaluateBounds() {
				var usedLights = this._usedLights;
				var min = this.boundsMin;
				var max = this.boundsMax;
				if (usedLights.length > 1) {
						min.copy(usedLights[1].min);
						max.copy(usedLights[1].max);
						for(var i = 2; i < usedLights.length; i++){
								min.min(usedLights[i].min);
								max.max(usedLights[i].max);
						}
				} else {
						min.set(0, 0, 0);
						max.set(1, 1, 1);
				}
				this.boundsDelta.sub2(max, min);
				this.lightsBuffer.setBounds(min, this.boundsDelta);
		}
		evaluateCompressionLimits() {
				var maxAttenuation = 0;
				var maxColorValue = 0;
				var usedLights = this._usedLights;
				for(var i = 1; i < usedLights.length; i++){
						var light = usedLights[i].light;
						maxAttenuation = Math.max(light.attenuationEnd, maxAttenuation);
						var color = light._colorLinear;
						maxColorValue = Math.max(color[0], maxColorValue);
						maxColorValue = Math.max(color[1], maxColorValue);
						maxColorValue = Math.max(color[2], maxColorValue);
				}
				this._maxAttenuation = maxAttenuation + epsilon;
				this._maxColorValue = maxColorValue + epsilon;
				this.lightsBuffer.setCompressionRanges(this._maxAttenuation, this._maxColorValue);
		}
		updateClusters(lightingParams) {
				this.counts.fill(0);
				this.clusters.fill(0);
				this.lightsBuffer.areaLightsEnabled = lightingParams ? lightingParams.areaLightsEnabled : false;
				var divX = this._cells.x;
				var divZ = this._cells.z;
				var counts = this.counts;
				var limit = this._maxCellLightCount;
				var clusters = this.clusters;
				var pixelsPerCellCount = this.maxCellLightCount;
				var usedLights = this._usedLights;
				for(var i = 1; i < usedLights.length; i++){
						var clusteredLight = usedLights[i];
						var light = clusteredLight.light;
						this.lightsBuffer.addLightData(light, i);
						this.evalLightCellMinMax(clusteredLight, tempMin3, tempMax3);
						var xStart = tempMin3.x;
						var xEnd = tempMax3.x;
						var yStart = tempMin3.y;
						var yEnd = tempMax3.y;
						var zStart = tempMin3.z;
						var zEnd = tempMax3.z;
						for(var x = xStart; x <= xEnd; x++){
								for(var z = zStart; z <= zEnd; z++){
										for(var y = yStart; y <= yEnd; y++){
												var clusterIndex = x + divX * (z + y * divZ);
												var count = counts[clusterIndex];
												if (count < limit) {
														clusters[pixelsPerCellCount * clusterIndex + count] = i;
														counts[clusterIndex] = count + 1;
												}
										}
								}
						}
				}
		}
		update(lights, lightingParams) {
				if (lightingParams === void 0) lightingParams = null;
				this.updateParams(lightingParams);
				this.updateCells();
				this.collectLights(lights);
				this.evaluateBounds();
				this.evaluateCompressionLimits();
				this.updateClusters(lightingParams);
				this.uploadTextures();
		}
		activate() {
				this.updateUniforms();
		}
		constructor(device){
				this.device = device;
				this.name = 'Untitled';
				this.reportCount = 0;
				this.boundsMin = new Vec3();
				this.boundsMax = new Vec3();
				this.boundsDelta = new Vec3();
				this._cells = new Vec3(1, 1, 1);
				this._cellsLimit = new Vec3();
				this.cells = this._cells;
				this.maxCellLightCount = 4;
				this._maxAttenuation = 0;
				this._maxColorValue = 0;
				this._usedLights = [];
				this._usedLights.push(new ClusterLight());
				this.lightsBuffer = new LightsBuffer(device);
				this.registerUniforms(device);
		}
}

var base64String = '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';
var data = null;
var initData = ()=>{
		if (!data) {
				var binaryString = atob(base64String);
				data = Uint8Array.from(binaryString, (char)=>char.charCodeAt(0));
		}
};
var blueNoiseData = ()=>{
		initData();
		return data;
};
class BlueNoise {
		_next() {
				this.seed = (this.seed + 4) % data.length;
		}
		value() {
				this._next();
				return data[this.seed] / 255;
		}
		vec4(dest) {
				if (dest === void 0) dest = new Vec4();
				this._next();
				return dest.set(data[this.seed], data[this.seed + 1], data[this.seed + 2], data[this.seed + 3]).mulScalar(1 / 255);
		}
		constructor(seed = 0){
				this.seed = 0;
				this.seed = seed * 4;
				initData();
		}
}

var lightCubeDir = [
		new Vec3(-1, 0, 0),
		new Vec3(1, 0, 0),
		new Vec3(0, -1, 0),
		new Vec3(0, 1, 0),
		new Vec3(0, 0, -1),
		new Vec3(0, 0, 1)
];
class LightCube {
		update(ambientLight, lights) {
				var colors = this.colors;
				var { r, g, b } = ambientLight;
				for(var j = 0; j < 6; j++){
						colors[j * 3] = r;
						colors[j * 3 + 1] = g;
						colors[j * 3 + 2] = b;
				}
				for(var j1 = 0; j1 < lights.length; j1++){
						var light = lights[j1];
						if (light._type === LIGHTTYPE_DIRECTIONAL) {
								for(var c = 0; c < 6; c++){
										var weight = Math.max(lightCubeDir[c].dot(light._direction), 0) * light._intensity;
										var lightColor = light._color;
										colors[c * 3] += lightColor.r * weight;
										colors[c * 3 + 1] += lightColor.g * weight;
										colors[c * 3 + 2] += lightColor.b * weight;
								}
						}
				}
		}
		constructor(){
				this.colors = new Float32Array(6 * 3);
		}
}

var createTexture = (device, namePrefix, size, data)=>{
		var texture = new Texture(device, {
				name: "" + namePrefix + size,
				width: size,
				height: size,
				format: PIXELFORMAT_RGBA8,
				addressU: ADDRESS_REPEAT,
				addressV: ADDRESS_REPEAT,
				type: TEXTURETYPE_DEFAULT,
				magFilter: FILTER_NEAREST,
				minFilter: FILTER_NEAREST,
				anisotropy: 1,
				mipmaps: false
		});
		texture.lock().set(data);
		texture.unlock();
		return texture;
};
var deviceCacheBlueNoise = new DeviceCache();
var getBlueNoiseTexture = (device)=>{
		return deviceCacheBlueNoise.get(device, ()=>{
				var data = blueNoiseData();
				var size = Math.sqrt(data.length / 4);
				return createTexture(device, 'BlueNoise', size, data);
		});
};

class ShadowMap {
		destroy() {
				if (this.texture) {
						this.texture.destroy();
						this.texture = null;
				}
				var targets = this.renderTargets;
				for(var i = 0; i < targets.length; i++){
						targets[i].destroy();
				}
				this.renderTargets.length = 0;
		}
		static create(device, light) {
				var shadowMap = null;
				if (light._type === LIGHTTYPE_OMNI) {
						shadowMap = this.createCubemap(device, light._shadowResolution, light._shadowType);
				} else {
						shadowMap = this.create2dMap(device, light._shadowResolution, light._shadowType);
				}
				return shadowMap;
		}
		static createAtlas(device, resolution, shadowType) {
				var shadowMap = this.create2dMap(device, resolution, shadowType);
				var targets = shadowMap.renderTargets;
				var rt = targets[0];
				for(var i = 0; i < 5; i++){
						targets.push(rt);
				}
				return shadowMap;
		}
		static create2dMap(device, size, shadowType) {
				var _pixelFormatInfo_get;
				var shadowInfo = shadowTypeInfo.get(shadowType);
				var format = shadowInfo.format;
				if (format === PIXELFORMAT_R32F && !device.textureFloatRenderable && device.textureHalfFloatRenderable) {
						format = PIXELFORMAT_R16F;
				}
				var formatName = (_pixelFormatInfo_get = pixelFormatInfo.get(format)) == null ? void 0 : _pixelFormatInfo_get.name;
				var filter = FILTER_LINEAR;
				if (shadowType === SHADOW_VSM_32F) {
						filter = device.extTextureFloatLinear ? FILTER_LINEAR : FILTER_NEAREST;
				}
				if (shadowType === SHADOW_PCSS_32F) {
						filter = FILTER_NEAREST;
				}
				var texture = new Texture(device, {
						format: format,
						width: size,
						height: size,
						mipmaps: false,
						minFilter: filter,
						magFilter: filter,
						addressU: ADDRESS_CLAMP_TO_EDGE,
						addressV: ADDRESS_CLAMP_TO_EDGE,
						name: "ShadowMap2D_" + formatName
				});
				var target = null;
				if (shadowInfo == null ? void 0 : shadowInfo.pcf) {
						texture.compareOnRead = true;
						texture.compareFunc = FUNC_LESS;
						target = new RenderTarget({
								depthBuffer: texture
						});
				} else {
						target = new RenderTarget({
								colorBuffer: texture,
								depth: true
						});
				}
				if (device.isWebGPU) {
						target.flipY = true;
				}
				return new ShadowMap(texture, [
						target
				]);
		}
		static createCubemap(device, size, shadowType) {
				var _pixelFormatInfo_get;
				var shadowInfo = shadowTypeInfo.get(shadowType);
				var formatName = (_pixelFormatInfo_get = pixelFormatInfo.get(shadowInfo.format)) == null ? void 0 : _pixelFormatInfo_get.name;
				var isPcss = shadowType === SHADOW_PCSS_32F;
				var filter = isPcss ? FILTER_NEAREST : FILTER_LINEAR;
				var cubemap = new Texture(device, {
						format: shadowInfo == null ? void 0 : shadowInfo.format,
						width: size,
						height: size,
						cubemap: true,
						mipmaps: false,
						minFilter: filter,
						magFilter: filter,
						addressU: ADDRESS_CLAMP_TO_EDGE,
						addressV: ADDRESS_CLAMP_TO_EDGE,
						name: "ShadowMapCube_" + formatName
				});
				if (!isPcss) {
						cubemap.compareOnRead = true;
						cubemap.compareFunc = FUNC_LESS;
				}
				var targets = [];
				for(var i = 0; i < 6; i++){
						if (isPcss) {
								targets.push(new RenderTarget({
										colorBuffer: cubemap,
										face: i,
										depth: true
								}));
						} else {
								targets.push(new RenderTarget({
										depthBuffer: cubemap,
										face: i
								}));
						}
				}
				return new ShadowMap(cubemap, targets);
		}
		constructor(texture, targets){
				this.texture = texture;
				this.cached = false;
				this.renderTargets = targets;
		}
}

var _tempArray = [];
var _tempArray2 = [];
var _viewport$1 = new Vec4();
var _scissor = new Vec4();
class Slot {
		constructor(rect){
				this.size = Math.floor(rect.w * 1024);
				this.used = false;
				this.lightId = -1;
				this.rect = rect;
		}
}
class LightTextureAtlas {
		destroy() {
				this.destroyShadowAtlas();
				this.destroyCookieAtlas();
		}
		destroyShadowAtlas() {
				var _this_shadowAtlas;
				(_this_shadowAtlas = this.shadowAtlas) == null ? void 0 : _this_shadowAtlas.destroy();
				this.shadowAtlas = null;
		}
		destroyCookieAtlas() {
				var _this_cookieAtlas, _this_cookieRenderTarget;
				(_this_cookieAtlas = this.cookieAtlas) == null ? void 0 : _this_cookieAtlas.destroy();
				this.cookieAtlas = null;
				(_this_cookieRenderTarget = this.cookieRenderTarget) == null ? void 0 : _this_cookieRenderTarget.destroy();
				this.cookieRenderTarget = null;
		}
		allocateShadowAtlas(resolution, shadowType) {
				if (shadowType === void 0) shadowType = SHADOW_PCF3_32F;
				var _this_shadowAtlas;
				var existingFormat = (_this_shadowAtlas = this.shadowAtlas) == null ? void 0 : _this_shadowAtlas.texture.format;
				var requiredFormat = shadowTypeInfo.get(shadowType).format;
				if (!this.shadowAtlas || this.shadowAtlas.texture.width !== resolution || existingFormat !== requiredFormat) {
						this.version++;
						this.destroyShadowAtlas();
						this.shadowAtlas = ShadowMap.createAtlas(this.device, resolution, shadowType);
						this.shadowAtlas.cached = true;
						var scissorOffset = 4 / this.shadowAtlasResolution;
						this.scissorVec.set(scissorOffset, scissorOffset, -2 * scissorOffset, -2 * scissorOffset);
				}
		}
		allocateCookieAtlas(resolution) {
				if (this.cookieAtlas.width !== resolution) {
						this.cookieRenderTarget.resize(resolution, resolution);
						this.version++;
				}
		}
		allocateUniforms() {
				this._shadowAtlasTextureId = this.device.scope.resolve('shadowAtlasTexture');
				this._shadowAtlasParamsId = this.device.scope.resolve('shadowAtlasParams');
				this._shadowAtlasParams = new Float32Array(2);
				this._cookieAtlasTextureId = this.device.scope.resolve('cookieAtlasTexture');
		}
		updateUniforms() {
				var rt = this.shadowAtlas.renderTargets[0];
				var shadowBuffer = rt.depthBuffer;
				this._shadowAtlasTextureId.setValue(shadowBuffer);
				this._shadowAtlasParams[0] = this.shadowAtlasResolution;
				this._shadowAtlasParams[1] = this.shadowEdgePixels;
				this._shadowAtlasParamsId.setValue(this._shadowAtlasParams);
				this._cookieAtlasTextureId.setValue(this.cookieAtlas);
		}
		subdivide(numLights, lightingParams) {
				var atlasSplit = lightingParams.atlasSplit;
				if (!atlasSplit) {
						var gridSize = Math.ceil(Math.sqrt(numLights));
						atlasSplit = _tempArray2;
						atlasSplit[0] = gridSize;
						atlasSplit.length = 1;
				}
				var arraysEqual = (a, b)=>a.length === b.length && a.every((v, i)=>v === b[i]);
				if (!arraysEqual(atlasSplit, this.atlasSplit)) {
						this.version++;
						this.slots.length = 0;
						this.atlasSplit.length = 0;
						this.atlasSplit.push(...atlasSplit);
						var splitCount = this.atlasSplit[0];
						if (splitCount > 1) {
								var invSize = 1 / splitCount;
								for(var i = 0; i < splitCount; i++){
										for(var j = 0; j < splitCount; j++){
												var rect = new Vec4(i * invSize, j * invSize, invSize, invSize);
												var nextLevelSplit = this.atlasSplit[1 + i * splitCount + j];
												if (nextLevelSplit > 1) {
														for(var x = 0; x < nextLevelSplit; x++){
																for(var y = 0; y < nextLevelSplit; y++){
																		var invSizeNext = invSize / nextLevelSplit;
																		var rectNext = new Vec4(rect.x + x * invSizeNext, rect.y + y * invSizeNext, invSizeNext, invSizeNext);
																		this.slots.push(new Slot(rectNext));
																}
														}
												} else {
														this.slots.push(new Slot(rect));
												}
										}
								}
						} else {
								this.slots.push(new Slot(new Vec4(0, 0, 1, 1)));
						}
						this.slots.sort((a, b)=>{
								return b.size - a.size;
						});
				}
		}
		collectLights(localLights, lightingParams) {
				var cookiesEnabled = lightingParams.cookiesEnabled;
				var shadowsEnabled = lightingParams.shadowsEnabled;
				var needsShadowAtlas = false;
				var needsCookieAtlas = false;
				var lights = _tempArray;
				lights.length = 0;
				var processLights = (list)=>{
						for(var i = 0; i < list.length; i++){
								var light = list[i];
								if (light.visibleThisFrame) {
										var lightShadow = shadowsEnabled && light.castShadows;
										var lightCookie = cookiesEnabled && !!light.cookie;
										needsShadowAtlas || (needsShadowAtlas = lightShadow);
										needsCookieAtlas || (needsCookieAtlas = lightCookie);
										if (lightShadow || lightCookie) {
												lights.push(light);
										}
								}
						}
				};
				if (cookiesEnabled || shadowsEnabled) {
						processLights(localLights);
				}
				lights.sort((a, b)=>{
						return b.maxScreenSize - a.maxScreenSize;
				});
				if (needsShadowAtlas) {
						this.allocateShadowAtlas(this.shadowAtlasResolution, lightingParams.shadowType);
				}
				if (needsCookieAtlas) {
						this.allocateCookieAtlas(this.cookieAtlasResolution);
				}
				if (needsShadowAtlas || needsCookieAtlas) {
						this.subdivide(lights.length, lightingParams);
				}
				return lights;
		}
		setupSlot(light, rect) {
				light.atlasViewport.copy(rect);
				var faceCount = light.numShadowFaces;
				for(var face = 0; face < faceCount; face++){
						if (light.castShadows || light._cookie) {
								_viewport$1.copy(rect);
								_scissor.copy(rect);
								if (light._type === LIGHTTYPE_SPOT) {
										_viewport$1.add(this.scissorVec);
								}
								if (light._type === LIGHTTYPE_OMNI) {
										var smallSize = _viewport$1.z / 3;
										var offset = this.cubeSlotsOffsets[face];
										_viewport$1.x += smallSize * offset.x;
										_viewport$1.y += smallSize * offset.y;
										_viewport$1.z = smallSize;
										_viewport$1.w = smallSize;
										_scissor.copy(_viewport$1);
								}
								if (light.castShadows) {
										var lightRenderData = light.getRenderData(null, face);
										lightRenderData.shadowViewport.copy(_viewport$1);
										lightRenderData.shadowScissor.copy(_scissor);
								}
						}
				}
		}
		assignSlot(light, slotIndex, slotReassigned) {
				light.atlasViewportAllocated = true;
				var slot = this.slots[slotIndex];
				slot.lightId = light.id;
				slot.used = true;
				if (slotReassigned) {
						light.atlasSlotUpdated = true;
						light.atlasVersion = this.version;
						light.atlasSlotIndex = slotIndex;
				}
		}
		update(localLights, lightingParams) {
				this.shadowAtlasResolution = lightingParams.shadowAtlasResolution;
				this.cookieAtlasResolution = lightingParams.cookieAtlasResolution;
				var lights = this.collectLights(localLights, lightingParams);
				if (lights.length > 0) {
						var slots = this.slots;
						for(var i = 0; i < slots.length; i++){
								slots[i].used = false;
						}
						var assignCount = Math.min(lights.length, slots.length);
						for(var i1 = 0; i1 < assignCount; i1++){
								var light = lights[i1];
								if (light.castShadows) {
										light._shadowMap = this.shadowAtlas;
								}
								var previousSlot = slots[light.atlasSlotIndex];
								if (light.atlasVersion === this.version && light.id === (previousSlot == null ? void 0 : previousSlot.lightId)) {
										var previousSlot1 = slots[light.atlasSlotIndex];
										if (previousSlot1.size === slots[i1].size && !previousSlot1.used) {
												this.assignSlot(light, light.atlasSlotIndex, false);
										}
								}
						}
						var usedCount = 0;
						for(var i2 = 0; i2 < assignCount; i2++){
								while(usedCount < slots.length && slots[usedCount].used){
										usedCount++;
								}
								var light1 = lights[i2];
								if (!light1.atlasViewportAllocated) {
										this.assignSlot(light1, usedCount, true);
								}
								var slot = slots[light1.atlasSlotIndex];
								this.setupSlot(light1, slot.rect);
						}
				}
				this.updateUniforms();
		}
		constructor(device){
				this.device = device;
				this.version = 1;
				this.shadowAtlasResolution = 2048;
				this.shadowAtlas = null;
				this.shadowEdgePixels = 3;
				this.cookieAtlasResolution = 4;
				this.cookieAtlas = new Texture(this.device, {
						name: 'CookieAtlas',
						width: this.cookieAtlasResolution,
						height: this.cookieAtlasResolution,
						format: PIXELFORMAT_SRGBA8,
						cubemap: false,
						mipmaps: false,
						minFilter: FILTER_NEAREST,
						magFilter: FILTER_NEAREST,
						addressU: ADDRESS_CLAMP_TO_EDGE,
						addressV: ADDRESS_CLAMP_TO_EDGE
				});
				this.cookieRenderTarget = new RenderTarget({
						colorBuffer: this.cookieAtlas,
						depth: false,
						flipY: true
				});
				this.slots = [];
				this.atlasSplit = [];
				this.cubeSlotsOffsets = [
						new Vec2(0, 0),
						new Vec2(0, 1),
						new Vec2(1, 0),
						new Vec2(1, 1),
						new Vec2(2, 0),
						new Vec2(2, 1)
				];
				this.scissorVec = new Vec4();
				this.allocateShadowAtlas(1);
				this.allocateCookieAtlas(1);
				this.allocateUniforms();
		}
}

var blendModes = [];
blendModes[BLEND_SUBTRACTIVE] = {
		src: BLENDMODE_ONE,
		dst: BLENDMODE_ONE,
		op: BLENDEQUATION_REVERSE_SUBTRACT
};
blendModes[BLEND_NONE] = {
		src: BLENDMODE_ONE,
		dst: BLENDMODE_ZERO,
		op: BLENDEQUATION_ADD
};
blendModes[BLEND_NORMAL] = {
		src: BLENDMODE_SRC_ALPHA,
		dst: BLENDMODE_ONE_MINUS_SRC_ALPHA,
		op: BLENDEQUATION_ADD,
		alphaSrc: BLENDMODE_ONE
};
blendModes[BLEND_PREMULTIPLIED] = {
		src: BLENDMODE_ONE,
		dst: BLENDMODE_ONE_MINUS_SRC_ALPHA,
		op: BLENDEQUATION_ADD
};
blendModes[BLEND_ADDITIVE] = {
		src: BLENDMODE_ONE,
		dst: BLENDMODE_ONE,
		op: BLENDEQUATION_ADD
};
blendModes[BLEND_ADDITIVEALPHA] = {
		src: BLENDMODE_SRC_ALPHA,
		dst: BLENDMODE_ONE,
		op: BLENDEQUATION_ADD
};
blendModes[BLEND_MULTIPLICATIVE2X] = {
		src: BLENDMODE_DST_COLOR,
		dst: BLENDMODE_SRC_COLOR,
		op: BLENDEQUATION_ADD
};
blendModes[BLEND_SCREEN] = {
		src: BLENDMODE_ONE_MINUS_DST_COLOR,
		dst: BLENDMODE_ONE,
		op: BLENDEQUATION_ADD
};
blendModes[BLEND_MULTIPLICATIVE] = {
		src: BLENDMODE_DST_COLOR,
		dst: BLENDMODE_ZERO,
		op: BLENDEQUATION_ADD
};
blendModes[BLEND_MIN] = {
		src: BLENDMODE_ONE,
		dst: BLENDMODE_ONE,
		op: BLENDEQUATION_MIN
};
blendModes[BLEND_MAX] = {
		src: BLENDMODE_ONE,
		dst: BLENDMODE_ONE,
		op: BLENDEQUATION_MAX
};
var id$1 = 0;
class Material {
		set chunks(value) {
				this._dirtyShader = true;
				this._chunks = value;
		}
		get chunks() {
				this._dirtyShader = true;
				return this._chunks;
		}
		set depthBias(value) {
				this._depthState.depthBias = value;
		}
		get depthBias() {
				return this._depthState.depthBias;
		}
		set slopeDepthBias(value) {
				this._depthState.depthBiasSlope = value;
		}
		get slopeDepthBias() {
				return this._depthState.depthBiasSlope;
		}
		set redWrite(value) {
				this._blendState.redWrite = value;
		}
		get redWrite() {
				return this._blendState.redWrite;
		}
		set greenWrite(value) {
				this._blendState.greenWrite = value;
		}
		get greenWrite() {
				return this._blendState.greenWrite;
		}
		set blueWrite(value) {
				this._blendState.blueWrite = value;
		}
		get blueWrite() {
				return this._blendState.blueWrite;
		}
		set alphaWrite(value) {
				this._blendState.alphaWrite = value;
		}
		get alphaWrite() {
				return this._blendState.alphaWrite;
		}
		get transparent() {
				return this._blendState.blend;
		}
		_updateTransparency() {
				var transparent = this.transparent;
				var meshInstances = this.meshInstances;
				for(var i = 0; i < meshInstances.length; i++){
						meshInstances[i].transparent = transparent;
				}
		}
		set blendState(value) {
				this._blendState.copy(value);
				this._updateTransparency();
		}
		get blendState() {
				return this._blendState;
		}
		set blendType(type) {
				var blendMode = blendModes[type];
				this._blendState.setColorBlend(blendMode.op, blendMode.src, blendMode.dst);
				var _blendMode_alphaOp, _blendMode_alphaSrc, _blendMode_alphaDst;
				this._blendState.setAlphaBlend((_blendMode_alphaOp = blendMode.alphaOp) != null ? _blendMode_alphaOp : blendMode.op, (_blendMode_alphaSrc = blendMode.alphaSrc) != null ? _blendMode_alphaSrc : blendMode.src, (_blendMode_alphaDst = blendMode.alphaDst) != null ? _blendMode_alphaDst : blendMode.dst);
				var blend = type !== BLEND_NONE;
				if (this._blendState.blend !== blend) {
						this._blendState.blend = blend;
						this._updateTransparency();
				}
				this._updateMeshInstanceKeys();
		}
		get blendType() {
				if (!this.transparent) {
						return BLEND_NONE;
				}
				var { colorOp, colorSrcFactor, colorDstFactor, alphaOp, alphaSrcFactor, alphaDstFactor } = this._blendState;
				for(var i = 0; i < blendModes.length; i++){
						var blendMode = blendModes[i];
						if (blendMode.src === colorSrcFactor && blendMode.dst === colorDstFactor && blendMode.op === colorOp && blendMode.src === alphaSrcFactor && blendMode.dst === alphaDstFactor && blendMode.op === alphaOp) {
								return i;
						}
				}
				return BLEND_NORMAL;
		}
		set depthState(value) {
				this._depthState.copy(value);
		}
		get depthState() {
				return this._depthState;
		}
		set depthTest(value) {
				this._depthState.test = value;
		}
		get depthTest() {
				return this._depthState.test;
		}
		set depthFunc(value) {
				this._depthState.func = value;
		}
		get depthFunc() {
				return this._depthState.func;
		}
		set depthWrite(value) {
				this._depthState.write = value;
		}
		get depthWrite() {
				return this._depthState.write;
		}
		copy(source) {
				var _source_stencilFront;
				this.name = source.name;
				this.alphaTest = source.alphaTest;
				this.alphaToCoverage = source.alphaToCoverage;
				this._blendState.copy(source._blendState);
				this._depthState.copy(source._depthState);
				this.cull = source.cull;
				this.stencilFront = (_source_stencilFront = source.stencilFront) == null ? void 0 : _source_stencilFront.clone();
				if (source.stencilBack) {
						this.stencilBack = source.stencilFront === source.stencilBack ? this.stencilFront : source.stencilBack.clone();
				}
				this.clearParameters();
				for(var name in source.parameters){
						if (source.parameters.hasOwnProperty(name)) {
								this._setParameterSimple(name, source.parameters[name].data);
						}
				}
				this.defines.clear();
				source.defines.forEach((value, key)=>this.defines.set(key, value));
				var srcChunks = source._chunks;
				for(var p in srcChunks){
						if (srcChunks.hasOwnProperty(p)) {
								this._chunks[p] = srcChunks[p];
						}
				}
				return this;
		}
		clone() {
				var clone = new this.constructor();
				return clone.copy(this);
		}
		_updateMeshInstanceKeys() {
				var meshInstances = this.meshInstances;
				for(var i = 0; i < meshInstances.length; i++){
						meshInstances[i].updateKey();
				}
		}
		updateUniforms(device, scene) {
				if (this._dirtyShader) {
						this.clearVariants();
				}
		}
		getShaderVariant(params) {}
		update() {
				if (this._definesDirty) {
						this._definesDirty = false;
						this.clearVariants();
				}
				this.dirty = true;
		}
		clearParameters() {
				this.parameters = {};
		}
		getParameters() {
				return this.parameters;
		}
		clearVariants() {
				this.variants.clear();
				var meshInstances = this.meshInstances;
				var count = meshInstances.length;
				for(var i = 0; i < count; i++){
						meshInstances[i].clearShaders();
				}
		}
		getParameter(name) {
				return this.parameters[name];
		}
		_setParameterSimple(name, data) {
				var param = this.parameters[name];
				if (param) {
						param.data = data;
				} else {
						this.parameters[name] = {
								scopeId: null,
								data: data
						};
				}
		}
		setParameter(name, data) {
				if (data === undefined && typeof name === 'object') {
						var uniformObject = name;
						if (uniformObject.length) {
								for(var i = 0; i < uniformObject.length; i++){
										this.setParameter(uniformObject[i]);
								}
								return;
						}
						name = uniformObject.name;
						data = uniformObject.value;
				}
				this._setParameterSimple(name, data);
		}
		deleteParameter(name) {
				if (this.parameters[name]) {
						delete this.parameters[name];
				}
		}
		setParameters(device, names) {
				var parameters = this.parameters;
				if (names === undefined) names = parameters;
				for(var paramName in names){
						var parameter = parameters[paramName];
						if (parameter) {
								if (!parameter.scopeId) {
										parameter.scopeId = device.scope.resolve(paramName);
								}
								parameter.scopeId.setValue(parameter.data);
						}
				}
		}
		setDefine(name, value) {
				var modified = false;
				var { defines } = this;
				if (value !== undefined && value !== false) {
						modified = !defines.has(name) || defines.get(name) !== value;
						defines.set(name, value);
				} else {
						modified = defines.has(name);
						defines.delete(name);
				}
				this._definesDirty || (this._definesDirty = modified);
		}
		getDefine(name) {
				return this.defines.has(name);
		}
		destroy() {
				this.variants.clear();
				for(var i = 0; i < this.meshInstances.length; i++){
						var meshInstance = this.meshInstances[i];
						meshInstance.clearShaders();
						meshInstance._material = null;
						if (meshInstance.mesh) {
								var defaultMaterial = getDefaultMaterial(meshInstance.mesh.device);
								if (this !== defaultMaterial) {
										meshInstance.material = defaultMaterial;
								}
						}
				}
				this.meshInstances.length = 0;
		}
		addMeshInstanceRef(meshInstance) {
				this.meshInstances.push(meshInstance);
		}
		removeMeshInstanceRef(meshInstance) {
				var meshInstances = this.meshInstances;
				var i = meshInstances.indexOf(meshInstance);
				if (i !== -1) {
						meshInstances.splice(i, 1);
				}
		}
		constructor(){
				this.meshInstances = [];
				this.name = 'Untitled';
				this.userId = '';
				this.id = id$1++;
				this.variants = new Map();
				this.defines = new Map();
				this._definesDirty = false;
				this.parameters = {};
				this.alphaTest = 0;
				this.alphaToCoverage = false;
				this._blendState = new BlendState();
				this._depthState = new DepthState();
				this.cull = CULLFACE_BACK;
				this.stencilFront = null;
				this.stencilBack = null;
				this._chunks = {};
				this._dirtyShader = true;
				this._shaderVersion = 0;
				this._scene = null;
				this.dirty = true;
		}
}

class ShadowMapCache {
		destroy() {
				this.clear();
				this.cache = null;
		}
		clear() {
				this.cache.forEach((shadowMaps)=>{
						shadowMaps.forEach((shadowMap)=>{
								shadowMap.destroy();
						});
				});
				this.cache.clear();
		}
		getKey(light) {
				var isCubeMap = light._type === LIGHTTYPE_OMNI;
				var shadowType = light._shadowType;
				var resolution = light._shadowResolution;
				return isCubeMap + "-" + shadowType + "-" + resolution;
		}
		get(device, light) {
				var key = this.getKey(light);
				var shadowMaps = this.cache.get(key);
				if (shadowMaps && shadowMaps.length) {
						return shadowMaps.pop();
				}
				var shadowMap = ShadowMap.create(device, light);
				shadowMap.cached = true;
				return shadowMap;
		}
		add(light, shadowMap) {
				var key = this.getKey(light);
				var shadowMaps = this.cache.get(key);
				if (shadowMaps) {
						shadowMaps.push(shadowMap);
				} else {
						this.cache.set(key, [
								shadowMap
						]);
				}
		}
		constructor(){
				this.cache = new Map();
		}
}

class RenderPassShadowLocalNonClustered extends RenderPass {
		execute() {
				this.shadowRenderer.renderFace(this.light, null, this.face, false);
		}
		after() {
				if (this.applyVsm) {
						this.shadowRenderer.renderVsm(this.light, this.shadowCamera);
				}
		}
		constructor(device, shadowRenderer, light, face, applyVsm){
				super(device);
				this.requiresCubemaps = false;
				this.shadowRenderer = shadowRenderer;
				this.light = light;
				this.face = face;
				this.applyVsm = applyVsm;
				this.shadowCamera = shadowRenderer.prepareFace(light, null, face);
				shadowRenderer.setupRenderPass(this, this.shadowCamera, true);
		}
}

class ShadowRendererLocal {
		cull(light, comp, casters) {
				if (casters === void 0) casters = null;
				var isClustered = this.renderer.scene.clusteredLightingEnabled;
				light.visibleThisFrame = true;
				if (!isClustered) {
						if (!light._shadowMap) {
								light._shadowMap = ShadowMap.create(this.device, light);
						}
				}
				var type = light._type;
				var faceCount = type === LIGHTTYPE_SPOT ? 1 : 6;
				for(var face = 0; face < faceCount; face++){
						var lightRenderData = light.getRenderData(null, face);
						var shadowCam = lightRenderData.shadowCamera;
						shadowCam.nearClip = light.attenuationEnd / 1000;
						shadowCam.farClip = light.attenuationEnd;
						var shadowCamNode = shadowCam._node;
						var lightNode = light._node;
						shadowCamNode.setPosition(lightNode.getPosition());
						if (type === LIGHTTYPE_SPOT) {
								shadowCam.fov = light._outerConeAngle * 2;
								shadowCamNode.setRotation(lightNode.getRotation());
								shadowCamNode.rotateLocal(-90, 0, 0);
						} else if (type === LIGHTTYPE_OMNI) {
								if (isClustered) {
										var tileSize = this.shadowRenderer.lightTextureAtlas.shadowAtlasResolution * light.atlasViewport.z / 3;
										var texelSize = 2 / tileSize;
										var filterSize = texelSize * this.shadowRenderer.lightTextureAtlas.shadowEdgePixels;
										shadowCam.fov = Math.atan(1 + filterSize) * math.RAD_TO_DEG * 2;
								} else {
										shadowCam.fov = 90;
								}
						}
						this.renderer.updateCameraFrustum(shadowCam);
						this.shadowRenderer.cullShadowCasters(comp, light, lightRenderData.visibleCasters, shadowCam, casters);
				}
		}
		prepareLights(shadowLights, lights) {
				var shadowCamera;
				for(var i = 0; i < lights.length; i++){
						var light = lights[i];
						if (this.shadowRenderer.needsShadowRendering(light) && light.atlasViewportAllocated) {
								shadowLights.push(light);
								for(var face = 0; face < light.numShadowFaces; face++){
										shadowCamera = this.shadowRenderer.prepareFace(light, null, face);
								}
						}
				}
				return shadowCamera;
		}
		buildNonClusteredRenderPasses(frameGraph, localLights) {
				for(var i = 0; i < localLights.length; i++){
						var light = localLights[i];
						if (this.shadowRenderer.needsShadowRendering(light)) {
								var applyVsm = light._type === LIGHTTYPE_SPOT;
								var faceCount = light.numShadowFaces;
								for(var face = 0; face < faceCount; face++){
										var renderPass = new RenderPassShadowLocalNonClustered(this.device, this.shadowRenderer, light, face, applyVsm);
										frameGraph.addRenderPass(renderPass);
								}
						}
				}
		}
		constructor(renderer, shadowRenderer){
				this.shadowLights = [];
				this.renderer = renderer;
				this.shadowRenderer = shadowRenderer;
				this.device = renderer.device;
		}
}

class RenderPassShadowDirectional extends RenderPass {
		execute() {
				var { light, camera, shadowRenderer, allCascadesRendering } = this;
				var faceCount = light.numShadowFaces;
				var shadowUpdateOverrides = light.shadowUpdateOverrides;
				for(var face = 0; face < faceCount; face++){
						if ((shadowUpdateOverrides == null ? void 0 : shadowUpdateOverrides[face]) !== SHADOWUPDATE_NONE) {
								shadowRenderer.renderFace(light, camera, face, !allCascadesRendering);
						}
						if ((shadowUpdateOverrides == null ? void 0 : shadowUpdateOverrides[face]) === SHADOWUPDATE_THISFRAME) {
								shadowUpdateOverrides[face] = SHADOWUPDATE_NONE;
						}
				}
		}
		after() {
				this.shadowRenderer.renderVsm(this.light, this.camera);
		}
		constructor(device, shadowRenderer, light, camera, allCascadesRendering){
				super(device);
				this.shadowRenderer = shadowRenderer;
				this.light = light;
				this.camera = camera;
				this.allCascadesRendering = allCascadesRendering;
		}
}

var visibleSceneAabb = new BoundingBox();
var center = new Vec3();
var shadowCamView$1 = new Mat4();
var aabbPoints = [
		new Vec3(),
		new Vec3(),
		new Vec3(),
		new Vec3(),
		new Vec3(),
		new Vec3(),
		new Vec3(),
		new Vec3()
];
var _depthRange = {
		min: 0,
		max: 0
};
function getDepthRange(cameraViewMatrix, aabbMin, aabbMax) {
		aabbPoints[0].x = aabbPoints[1].x = aabbPoints[2].x = aabbPoints[3].x = aabbMin.x;
		aabbPoints[1].y = aabbPoints[3].y = aabbPoints[7].y = aabbPoints[5].y = aabbMin.y;
		aabbPoints[2].z = aabbPoints[3].z = aabbPoints[6].z = aabbPoints[7].z = aabbMin.z;
		aabbPoints[4].x = aabbPoints[5].x = aabbPoints[6].x = aabbPoints[7].x = aabbMax.x;
		aabbPoints[0].y = aabbPoints[2].y = aabbPoints[4].y = aabbPoints[6].y = aabbMax.y;
		aabbPoints[0].z = aabbPoints[1].z = aabbPoints[4].z = aabbPoints[5].z = aabbMax.z;
		var minz = 9999999999;
		var maxz = -9999999999;
		for(var i = 0; i < 8; ++i){
				cameraViewMatrix.transformPoint(aabbPoints[i], aabbPoints[i]);
				var z = aabbPoints[i].z;
				if (z < minz) minz = z;
				if (z > maxz) maxz = z;
		}
		_depthRange.min = minz;
		_depthRange.max = maxz;
		return _depthRange;
}
class ShadowRendererDirectional {
		cull(light, comp, camera, casters) {
				if (casters === void 0) casters = null;
				light.visibleThisFrame = true;
				if (!light._shadowMap) {
						light._shadowMap = ShadowMap.create(this.device, light);
				}
				var nearDist = camera._nearClip;
				this.generateSplitDistances(light, nearDist, Math.min(camera._farClip, light.shadowDistance));
				var shadowUpdateOverrides = light.shadowUpdateOverrides;
				for(var cascade = 0; cascade < light.numCascades; cascade++){
						if ((shadowUpdateOverrides == null ? void 0 : shadowUpdateOverrides[cascade]) === SHADOWUPDATE_NONE) {
								break;
						}
						var lightRenderData = light.getRenderData(camera, cascade);
						var shadowCam = lightRenderData.shadowCamera;
						shadowCam.renderTarget = light._shadowMap.renderTargets[0];
						lightRenderData.shadowViewport.copy(light.cascades[cascade]);
						lightRenderData.shadowScissor.copy(light.cascades[cascade]);
						var shadowCamNode = shadowCam._node;
						var lightNode = light._node;
						shadowCamNode.setPosition(lightNode.getPosition());
						shadowCamNode.setRotation(lightNode.getRotation());
						shadowCamNode.rotateLocal(-90, 0, 0);
						var frustumNearDist = cascade === 0 ? nearDist : light._shadowCascadeDistances[cascade - 1];
						var frustumFarDist = light._shadowCascadeDistances[cascade];
						var frustumPoints = camera.getFrustumCorners(frustumNearDist, frustumFarDist);
						center.set(0, 0, 0);
						var cameraWorldMat = camera.node.getWorldTransform();
						for(var i = 0; i < 8; i++){
								cameraWorldMat.transformPoint(frustumPoints[i], frustumPoints[i]);
								center.add(frustumPoints[i]);
						}
						center.mulScalar(1 / 8);
						var radius = 0;
						for(var i1 = 0; i1 < 8; i1++){
								var dist = frustumPoints[i1].sub(center).length();
								if (dist > radius) {
										radius = dist;
								}
						}
						var right = shadowCamNode.right;
						var up = shadowCamNode.up;
						var lightDir = shadowCamNode.forward;
						var sizeRatio = 0.25 * light._shadowResolution / radius;
						var x = Math.ceil(center.dot(up) * sizeRatio) / sizeRatio;
						var y = Math.ceil(center.dot(right) * sizeRatio) / sizeRatio;
						var scaledUp = up.mulScalar(x);
						var scaledRight = right.mulScalar(y);
						var dot = center.dot(lightDir);
						var scaledDir = lightDir.mulScalar(dot);
						center.add2(scaledUp, scaledRight).add(scaledDir);
						shadowCamNode.setPosition(center);
						shadowCamNode.translateLocal(0, 0, 1000000);
						shadowCam.nearClip = 0.01;
						shadowCam.farClip = 2000000;
						shadowCam.orthoHeight = radius;
						this.renderer.updateCameraFrustum(shadowCam);
						this.shadowRenderer.cullShadowCasters(comp, light, lightRenderData.visibleCasters, shadowCam, casters);
						var emptyAabb = true;
						var visibleCasters = lightRenderData.visibleCasters;
						for(var i2 = 0; i2 < visibleCasters.length; i2++){
								var meshInstance = visibleCasters[i2];
								if (emptyAabb) {
										emptyAabb = false;
										visibleSceneAabb.copy(meshInstance.aabb);
								} else {
										visibleSceneAabb.add(meshInstance.aabb);
								}
						}
						shadowCamView$1.copy(shadowCamNode.getWorldTransform()).invert();
						var depthRange = getDepthRange(shadowCamView$1, visibleSceneAabb.getMin(), visibleSceneAabb.getMax());
						shadowCamNode.translateLocal(0, 0, depthRange.max + 0.1);
						shadowCam.farClip = depthRange.max - depthRange.min + 0.2;
						lightRenderData.projectionCompensation = radius;
				}
		}
		generateSplitDistances(light, nearDist, farDist) {
				light._shadowCascadeDistances.fill(farDist);
				for(var i = 1; i < light.numCascades; i++){
						var fraction = i / light.numCascades;
						var linearDist = nearDist + (farDist - nearDist) * fraction;
						var logDist = nearDist * (farDist / nearDist) ** fraction;
						var dist = math.lerp(linearDist, logDist, light.cascadeDistribution);
						light._shadowCascadeDistances[i - 1] = dist;
				}
		}
		getLightRenderPass(light, camera) {
				var renderPass = null;
				if (this.shadowRenderer.needsShadowRendering(light)) {
						var faceCount = light.numShadowFaces;
						var shadowUpdateOverrides = light.shadowUpdateOverrides;
						var allCascadesRendering = true;
						var shadowCamera;
						for(var face = 0; face < faceCount; face++){
								if ((shadowUpdateOverrides == null ? void 0 : shadowUpdateOverrides[face]) === SHADOWUPDATE_NONE) {
										allCascadesRendering = false;
								}
								shadowCamera = this.shadowRenderer.prepareFace(light, camera, face);
						}
						renderPass = new RenderPassShadowDirectional(this.device, this.shadowRenderer, light, camera, allCascadesRendering);
						this.shadowRenderer.setupRenderPass(renderPass, shadowCamera, allCascadesRendering);
				}
				return renderPass;
		}
		constructor(renderer, shadowRenderer){
				this.renderer = renderer;
				this.shadowRenderer = shadowRenderer;
				this.device = renderer.device;
		}
}

var tempSet$1 = new Set();
var shadowCamView = new Mat4();
var shadowCamViewProj = new Mat4();
var pixelOffset = new Float32Array(2);
var blurScissorRect = new Vec4(1, 1, 0, 0);
var viewportMatrix = new Mat4();
function gauss(x, sigma) {
		return Math.exp(-(x * x) / (2.0 * sigma * sigma));
}
function gaussWeights(kernelSize) {
		var sigma = (kernelSize - 1) / (2 * 3);
		var halfWidth = (kernelSize - 1) * 0.5;
		var values = new Array(kernelSize);
		var sum = 0.0;
		for(var i = 0; i < kernelSize; ++i){
				values[i] = gauss(i - halfWidth, sigma);
				sum += values[i];
		}
		for(var i1 = 0; i1 < kernelSize; ++i1){
				values[i1] /= sum;
		}
		return values;
}
class ShadowRenderer {
		static createShadowCamera(shadowType, type, face) {
				var shadowCam = LightCamera.create('ShadowCamera', type, face);
				var shadowInfo = shadowTypeInfo.get(shadowType);
				var _shadowInfo_vsm;
				var isVsm = (_shadowInfo_vsm = shadowInfo == null ? void 0 : shadowInfo.vsm) != null ? _shadowInfo_vsm : false;
				var _shadowInfo_pcf;
				var isPcf = (_shadowInfo_pcf = shadowInfo == null ? void 0 : shadowInfo.pcf) != null ? _shadowInfo_pcf : false;
				if (isVsm) {
						shadowCam.clearColor = new Color(0, 0, 0, 0);
				} else {
						shadowCam.clearColor = new Color(1, 1, 1, 1);
				}
				shadowCam.clearDepthBuffer = true;
				shadowCam.clearStencilBuffer = false;
				shadowCam.clearColorBuffer = !isPcf;
				return shadowCam;
		}
		_cullShadowCastersInternal(meshInstances, visible, camera) {
				var numInstances = meshInstances.length;
				for(var i = 0; i < numInstances; i++){
						var meshInstance = meshInstances[i];
						if (meshInstance.castShadow) {
								if (!meshInstance.cull || meshInstance._isVisible(camera)) {
										meshInstance.visibleThisFrame = true;
										visible.push(meshInstance);
								}
						}
				}
		}
		cullShadowCasters(comp, light, visible, camera, casters) {
				visible.length = 0;
				if (casters) {
						this._cullShadowCastersInternal(casters, visible, camera);
				} else {
						var layers = comp.layerList;
						var len = layers.length;
						for(var i = 0; i < len; i++){
								var layer = layers[i];
								if (layer._lightsSet.has(light)) {
										if (!tempSet$1.has(layer)) {
												tempSet$1.add(layer);
												this._cullShadowCastersInternal(layer.shadowCasters, visible, camera);
										}
								}
						}
						tempSet$1.clear();
				}
				visible.sort(this.sortCompareShader);
		}
		sortCompareShader(drawCallA, drawCallB) {
				var keyA = drawCallA._sortKeyShadow;
				var keyB = drawCallB._sortKeyShadow;
				if (keyA === keyB) {
						return drawCallB.mesh.id - drawCallA.mesh.id;
				}
				return keyB - keyA;
		}
		setupRenderState(device, light) {
				var isClustered = this.renderer.scene.clusteredLightingEnabled;
				var useShadowSampler = isClustered ? light._isPcf : light._isPcf && light._type !== LIGHTTYPE_OMNI;
				device.setBlendState(useShadowSampler ? this.blendStateNoWrite : this.blendStateWrite);
				device.setDepthState(light.shadowDepthState);
				device.setStencilState(null, null);
		}
		dispatchUniforms(light, shadowCam, lightRenderData, face) {
				var shadowCamNode = shadowCam._node;
				if (light._type !== LIGHTTYPE_DIRECTIONAL) {
						this.renderer.dispatchViewPos(shadowCamNode.getPosition());
						this.shadowMapLightRadiusId.setValue(light.attenuationEnd);
				}
				shadowCamView.setTRS(shadowCamNode.getPosition(), shadowCamNode.getRotation(), Vec3.ONE).invert();
				shadowCamViewProj.mul2(shadowCam.projectionMatrix, shadowCamView);
				var rectViewport = lightRenderData.shadowViewport;
				shadowCam.rect = rectViewport;
				shadowCam.scissorRect = lightRenderData.shadowScissor;
				viewportMatrix.setViewport(rectViewport.x, rectViewport.y, rectViewport.z, rectViewport.w);
				lightRenderData.shadowMatrix.mul2(viewportMatrix, shadowCamViewProj);
				if (light._type === LIGHTTYPE_DIRECTIONAL) {
						light._shadowMatrixPalette.set(lightRenderData.shadowMatrix.data, face * 16);
				}
		}
		getShadowPass(light) {
				var _this_shadowPassCache_lightType;
				var lightType = light._type;
				var shadowType = light._shadowType;
				var shadowPassInfo = (_this_shadowPassCache_lightType = this.shadowPassCache[lightType]) == null ? void 0 : _this_shadowPassCache_lightType[shadowType];
				if (!shadowPassInfo) {
						var shadowPassName = "ShadowPass_" + lightType + "_" + shadowType;
						shadowPassInfo = ShaderPass.get(this.device).allocate(shadowPassName, {
								isShadow: true,
								lightType: lightType,
								shadowType: shadowType
						});
						if (!this.shadowPassCache[lightType]) {
								this.shadowPassCache[lightType] = [];
						}
						this.shadowPassCache[lightType][shadowType] = shadowPassInfo;
				}
				return shadowPassInfo.index;
		}
		submitCasters(visibleCasters, light, camera) {
				var device = this.device;
				var renderer = this.renderer;
				var scene = renderer.scene;
				var passFlags = 1 << SHADER_SHADOW;
				var shadowPass = this.getShadowPass(light);
				var cameraShaderParams = camera.shaderParams;
				var flipFactor = camera.renderTarget.flipY ? -1 : 1;
				var count = visibleCasters.length;
				for(var i = 0; i < count; i++){
						var meshInstance = visibleCasters[i];
						var mesh = meshInstance.mesh;
						meshInstance.ensureMaterial(device);
						var material = meshInstance.material;
						renderer.setBaseConstants(device, material);
						renderer.setSkinning(device, meshInstance);
						if (material.dirty) {
								material.updateUniforms(device, scene);
								material.dirty = false;
						}
						renderer.setupCullMode(true, flipFactor, meshInstance);
						material.setParameters(device);
						meshInstance.setParameters(device, passFlags);
						var shaderInstance = meshInstance.getShaderInstance(shadowPass, 0, scene, cameraShaderParams, this.viewUniformFormat, this.viewBindGroupFormat);
						var shadowShader = shaderInstance.shader;
						meshInstance._sortKeyShadow = shadowShader.id;
						device.setShader(shadowShader);
						renderer.setVertexBuffers(device, mesh);
						renderer.setMorphing(device, meshInstance.morphInstance);
						this.renderer.setupMeshUniformBuffers(shaderInstance, meshInstance);
						var style = meshInstance.renderStyle;
						device.setIndexBuffer(mesh.indexBuffer[style]);
						renderer.drawInstance(device, meshInstance, mesh, style);
						renderer._shadowDrawCalls++;
				}
		}
		needsShadowRendering(light) {
				var needs = light.enabled && light.castShadows && light.shadowUpdateMode !== SHADOWUPDATE_NONE && light.visibleThisFrame;
				if (light.shadowUpdateMode === SHADOWUPDATE_THISFRAME) {
						light.shadowUpdateMode = SHADOWUPDATE_NONE;
				}
				if (needs) {
						this.renderer._shadowMapUpdates += light.numShadowFaces;
				}
				return needs;
		}
		getLightRenderData(light, camera, face) {
				return light.getRenderData(light._type === LIGHTTYPE_DIRECTIONAL ? camera : null, face);
		}
		setupRenderPass(renderPass, shadowCamera, clearRenderTarget) {
				var rt = shadowCamera.renderTarget;
				renderPass.init(rt);
				renderPass.depthStencilOps.clearDepthValue = 1;
				renderPass.depthStencilOps.clearDepth = clearRenderTarget;
				if (rt.depthBuffer) {
						renderPass.depthStencilOps.storeDepth = true;
				} else {
						renderPass.colorOps.clearValue.copy(shadowCamera.clearColor);
						renderPass.colorOps.clear = clearRenderTarget;
						renderPass.depthStencilOps.storeDepth = false;
				}
				renderPass.requiresCubemaps = false;
		}
		prepareFace(light, camera, face) {
				var type = light._type;
				var lightRenderData = this.getLightRenderData(light, camera, face);
				var shadowCam = lightRenderData.shadowCamera;
				var renderTargetIndex = type === LIGHTTYPE_DIRECTIONAL ? 0 : face;
				shadowCam.renderTarget = light._shadowMap.renderTargets[renderTargetIndex];
				return shadowCam;
		}
		renderFace(light, camera, face, clear, insideRenderPass) {
				if (insideRenderPass === void 0) insideRenderPass = true;
				var device = this.device;
				var lightRenderData = this.getLightRenderData(light, camera, face);
				var shadowCam = lightRenderData.shadowCamera;
				this.dispatchUniforms(light, shadowCam, lightRenderData, face);
				var rt = shadowCam.renderTarget;
				var renderer = this.renderer;
				renderer.setCameraUniforms(shadowCam, rt);
				if (device.supportsUniformBuffers) {
						renderer.setupViewUniformBuffers(lightRenderData.viewBindGroups, this.viewUniformFormat, this.viewBindGroupFormat, 1);
				}
				if (insideRenderPass) {
						renderer.setupViewport(shadowCam, rt);
						if (clear) {
								renderer.clear(shadowCam);
						}
				} else {
						renderer.clearView(shadowCam, rt, true, false);
				}
				this.setupRenderState(device, light);
				this.submitCasters(lightRenderData.visibleCasters, light, shadowCam);
		}
		render(light, camera, insideRenderPass) {
				if (insideRenderPass === void 0) insideRenderPass = true;
				if (this.needsShadowRendering(light)) {
						var faceCount = light.numShadowFaces;
						for(var face = 0; face < faceCount; face++){
								this.prepareFace(light, camera, face);
								this.renderFace(light, camera, face, true, insideRenderPass);
						}
						this.renderVsm(light, camera);
				}
		}
		renderVsm(light, camera) {
				if (light._isVsm && light._vsmBlurSize > 1) {
						var isClustered = this.renderer.scene.clusteredLightingEnabled;
						if (!isClustered || light._type === LIGHTTYPE_DIRECTIONAL) {
								this.applyVsmBlur(light, camera);
						}
				}
		}
		getVsmBlurShader(blurMode, filterSize) {
				var cache = this.blurVsmShader;
				var blurShader = cache[blurMode][filterSize];
				if (!blurShader) {
						this.blurVsmWeights[filterSize] = gaussWeights(filterSize);
						var blurVS = shaderChunks.fullscreenQuadVS;
						var blurFS = "#define SAMPLES " + filterSize + "\n";
						blurFS += this.blurVsmShaderCode[blurMode];
						var blurShaderName = "blurVsm" + blurMode + filterSize;
						blurShader = createShaderFromCode(this.device, blurVS, blurFS, blurShaderName);
						cache[blurMode][filterSize] = blurShader;
				}
				return blurShader;
		}
		applyVsmBlur(light, camera) {
				var device = this.device;
				device.setBlendState(BlendState.NOBLEND);
				var lightRenderData = light.getRenderData(light._type === LIGHTTYPE_DIRECTIONAL ? camera : null, 0);
				var shadowCam = lightRenderData.shadowCamera;
				var origShadowMap = shadowCam.renderTarget;
				var tempShadowMap = this.renderer.shadowMapCache.get(device, light);
				var tempRt = tempShadowMap.renderTargets[0];
				var blurMode = light.vsmBlurMode;
				var filterSize = light._vsmBlurSize;
				var blurShader = this.getVsmBlurShader(blurMode, filterSize);
				blurScissorRect.z = light._shadowResolution - 2;
				blurScissorRect.w = blurScissorRect.z;
				this.sourceId.setValue(origShadowMap.colorBuffer);
				pixelOffset[0] = 1 / light._shadowResolution;
				pixelOffset[1] = 0;
				this.pixelOffsetId.setValue(pixelOffset);
				if (blurMode === BLUR_GAUSSIAN) this.weightId.setValue(this.blurVsmWeights[filterSize]);
				drawQuadWithShader(device, tempRt, blurShader, null, blurScissorRect);
				this.sourceId.setValue(tempRt.colorBuffer);
				pixelOffset[1] = pixelOffset[0];
				pixelOffset[0] = 0;
				this.pixelOffsetId.setValue(pixelOffset);
				drawQuadWithShader(device, origShadowMap, blurShader, null, blurScissorRect);
				this.renderer.shadowMapCache.add(light, tempShadowMap);
		}
		initViewBindGroupFormat() {
				if (this.device.supportsUniformBuffers && !this.viewUniformFormat) {
						this.viewUniformFormat = new UniformBufferFormat(this.device, [
								new UniformFormat('matrix_viewProjection', UNIFORMTYPE_MAT4)
						]);
						this.viewBindGroupFormat = new BindGroupFormat(this.device, [
								new BindUniformBufferFormat(UNIFORM_BUFFER_DEFAULT_SLOT_NAME, SHADERSTAGE_VERTEX | SHADERSTAGE_FRAGMENT)
						]);
				}
		}
		frameUpdate() {
				this.initViewBindGroupFormat();
		}
		constructor(renderer, lightTextureAtlas){
				this.shadowPassCache = [];
				this.device = renderer.device;
				this.renderer = renderer;
				this.lightTextureAtlas = lightTextureAtlas;
				var scope = this.device.scope;
				this.sourceId = scope.resolve('source');
				this.pixelOffsetId = scope.resolve('pixelOffset');
				this.weightId = scope.resolve('weight[0]');
				this.blurVsmShaderCode = [
						shaderChunks.blurVSMPS,
						"#define GAUSS\n" + shaderChunks.blurVSMPS
				];
				this.blurVsmShader = [
						{},
						{}
				];
				this.blurVsmWeights = {};
				this.shadowMapLightRadiusId = scope.resolve('light_radius');
				this.viewUniformFormat = null;
				this.viewBindGroupFormat = null;
				this.blendStateWrite = new BlendState();
				this.blendStateNoWrite = new BlendState();
				this.blendStateNoWrite.setColorWrite(false, false, false, false);
		}
}

var tempClusterArray = [];
class WorldClustersAllocator {
		destroy() {
				if (this._empty) {
						this._empty.destroy();
						this._empty = null;
				}
				this._allocated.forEach((cluster)=>{
						cluster.destroy();
				});
				this._allocated.length = 0;
		}
		get count() {
				return this._allocated.length;
		}
		get empty() {
				if (!this._empty) {
						var empty = new WorldClusters(this.device);
						empty.name = 'ClusterEmpty';
						empty.update([]);
						this._empty = empty;
				}
				return this._empty;
		}
		assign(renderPasses) {
				var empty = this.empty;
				tempClusterArray.push(...this._allocated);
				this._allocated.length = 0;
				this._clusters.clear();
				var passCount = renderPasses.length;
				for(var p = 0; p < passCount; p++){
						var renderPass = renderPasses[p];
						var renderActions = renderPass.renderActions;
						if (renderActions) {
								var count = renderActions.length;
								for(var i = 0; i < count; i++){
										var ra = renderActions[i];
										ra.lightClusters = null;
										var layer = ra.layer;
										if (layer.hasClusteredLights && layer.meshInstances.length) {
												var hash = layer.getLightIdHash();
												var existingRenderAction = this._clusters.get(hash);
												var clusters = existingRenderAction == null ? void 0 : existingRenderAction.lightClusters;
												if (!clusters) {
														var _tempClusterArray_pop;
														clusters = (_tempClusterArray_pop = tempClusterArray.pop()) != null ? _tempClusterArray_pop : new WorldClusters(this.device);
														this._allocated.push(clusters);
														this._clusters.set(hash, ra);
												}
												ra.lightClusters = clusters;
										}
										if (!ra.lightClusters) {
												ra.lightClusters = empty;
										}
								}
						}
				}
				tempClusterArray.forEach((item)=>item.destroy());
				tempClusterArray.length = 0;
		}
		update(renderPasses, lighting) {
				this.assign(renderPasses);
				this._clusters.forEach((renderAction)=>{
						var layer = renderAction.layer;
						var cluster = renderAction.lightClusters;
						cluster.update(layer.clusteredLightsSet, lighting);
				});
		}
		constructor(graphicsDevice){
				this._empty = null;
				this._allocated = [];
				this._clusters = new Map();
				this.device = graphicsDevice;
		}
}

var textureBlitVertexShader = "\n	attribute vec2 vertex_position;\n	varying vec2 uv0;\n	void main(void) {\n		gl_Position = vec4(vertex_position, 0.5, 1.0);\n		uv0 = vertex_position.xy * 0.5 + 0.5;\n		#ifndef WEBGPU\n			uv0.y = 1.0 - uv0.y;\n		#endif\n	}";
var textureBlitFragmentShader = "\n	varying vec2 uv0;\n	uniform sampler2D blitTexture;\n	void main(void) {\n		gl_FragColor = texture2D(blitTexture, uv0);\n	}";
var textureCubeBlitFragmentShader = "\n	varying vec2 uv0;\n	uniform samplerCube blitTexture;\n	uniform mat4 invViewProj;\n	void main(void) {\n		vec4 projPos = vec4(uv0 * 2.0 - 1.0, 0.5, 1.0);\n		vec4 worldPos = invViewProj * projPos;\n		gl_FragColor = textureCube(blitTexture, worldPos.xyz);\n	}";
var _viewport = new Vec4();
var _invViewProjMatrices = [];
class RenderPassCookieRenderer extends RenderPass {
		destroy() {
				var _this__quadRenderer2D, _this__quadRendererCube;
				(_this__quadRenderer2D = this._quadRenderer2D) == null ? void 0 : _this__quadRenderer2D.destroy();
				this._quadRenderer2D = null;
				(_this__quadRendererCube = this._quadRendererCube) == null ? void 0 : _this__quadRendererCube.destroy();
				this._quadRendererCube = null;
		}
		static create(renderTarget, cubeSlotsOffsets) {
				var renderPass = new RenderPassCookieRenderer(renderTarget.device, cubeSlotsOffsets);
				renderPass.init(renderTarget);
				renderPass.colorOps.clear = false;
				renderPass.depthStencilOps.clearDepth = false;
				return renderPass;
		}
		update(lights) {
				var filteredLights = this._filteredLights;
				this.filter(lights, filteredLights);
				this.executeEnabled = filteredLights.length > 0;
		}
		filter(lights, filteredLights) {
				for(var i = 0; i < lights.length; i++){
						var light = lights[i];
						if (light._type === LIGHTTYPE_DIRECTIONAL) {
								continue;
						}
						if (!light.atlasViewportAllocated) {
								continue;
						}
						if (!light.atlasSlotUpdated) {
								continue;
						}
						if (light.enabled && light.cookie && light.visibleThisFrame) {
								filteredLights.push(light);
						}
				}
		}
		initInvViewProjMatrices() {
				if (!_invViewProjMatrices.length) {
						for(var face = 0; face < 6; face++){
								var camera = LightCamera.create(null, LIGHTTYPE_OMNI, face);
								var projMat = camera.projectionMatrix;
								var viewMat = camera.node.getLocalTransform().clone().invert();
								_invViewProjMatrices[face] = new Mat4().mul2(projMat, viewMat).invert();
						}
				}
		}
		get quadRenderer2D() {
				if (!this._quadRenderer2D) {
						var shader = createShaderFromCode(this.device, textureBlitVertexShader, textureBlitFragmentShader, 'cookieRenderer2d');
						this._quadRenderer2D = new QuadRender(shader);
				}
				return this._quadRenderer2D;
		}
		get quadRendererCube() {
				if (!this._quadRendererCube) {
						var shader = createShaderFromCode(this.device, textureBlitVertexShader, textureCubeBlitFragmentShader, 'cookieRendererCube');
						this._quadRendererCube = new QuadRender(shader);
				}
				return this._quadRendererCube;
		}
		execute() {
				var device = this.device;
				device.setBlendState(BlendState.NOBLEND);
				device.setCullMode(CULLFACE_NONE);
				device.setDepthState(DepthState.NODEPTH);
				device.setStencilState();
				var renderTargetWidth = this.renderTarget.colorBuffer.width;
				var cubeSlotsOffsets = this._cubeSlotsOffsets;
				var filteredLights = this._filteredLights;
				for(var i = 0; i < filteredLights.length; i++){
						var light = filteredLights[i];
						var faceCount = light.numShadowFaces;
						var quad = faceCount > 1 ? this.quadRendererCube : this.quadRenderer2D;
						if (faceCount > 1) {
								this.initInvViewProjMatrices();
						}
						this.blitTextureId.setValue(light.cookie);
						for(var face = 0; face < faceCount; face++){
								_viewport.copy(light.atlasViewport);
								if (faceCount > 1) {
										var smallSize = _viewport.z / 3;
										var offset = cubeSlotsOffsets[face];
										_viewport.x += smallSize * offset.x;
										_viewport.y += smallSize * offset.y;
										_viewport.z = smallSize;
										_viewport.w = smallSize;
										this.invViewProjId.setValue(_invViewProjMatrices[face].data);
								}
								_viewport.mulScalar(renderTargetWidth);
								quad.render(_viewport);
						}
				}
				filteredLights.length = 0;
		}
		constructor(device, cubeSlotsOffsets){
				super(device), this._quadRenderer2D = null, this._quadRendererCube = null, this._filteredLights = [];
				this._cubeSlotsOffsets = cubeSlotsOffsets;
				this.requiresCubemaps = false;
				this.blitTextureId = device.scope.resolve('blitTexture');
				this.invViewProjId = device.scope.resolve('invViewProj');
		}
}

class RenderPassShadowLocalClustered extends RenderPass {
		update(localLights) {
				var shadowLights = this.shadowRendererLocal.shadowLights;
				var shadowCamera = this.shadowRendererLocal.prepareLights(shadowLights, localLights);
				var count = shadowLights.length;
				this.enabled = count > 0;
				if (count) {
						this.shadowRenderer.setupRenderPass(this, shadowCamera, false);
				}
		}
		execute() {
				var shadowLights = this.shadowRendererLocal.shadowLights;
				var count = shadowLights.length;
				for(var i = 0; i < count; i++){
						var light = shadowLights[i];
						for(var face = 0; face < light.numShadowFaces; face++){
								this.shadowRenderer.renderFace(light, null, face, true);
						}
				}
				shadowLights.length = 0;
		}
		constructor(device, shadowRenderer, shadowRendererLocal){
				super(device);
				this.requiresCubemaps = false;
				this.shadowRenderer = shadowRenderer;
				this.shadowRendererLocal = shadowRendererLocal;
		}
}

class RenderPassUpdateClustered extends RenderPass {
		update(frameGraph, shadowsEnabled, cookiesEnabled, lights, localLights) {
				this.frameGraph = frameGraph;
				this.cookiesRenderPass.enabled = cookiesEnabled;
				if (cookiesEnabled) {
						this.cookiesRenderPass.update(lights);
				}
				this.shadowRenderPass.enabled = shadowsEnabled;
				if (shadowsEnabled) {
						this.shadowRenderPass.update(localLights);
				}
		}
		destroy() {
				this.cookiesRenderPass.destroy();
				this.cookiesRenderPass = null;
		}
		execute() {
				var { renderer } = this;
				var { scene } = renderer;
				renderer.worldClustersAllocator.update(this.frameGraph.renderPasses, scene.lighting);
		}
		constructor(device, renderer, shadowRenderer, shadowRendererLocal, lightTextureAtlas){
				super(device);
				this.renderer = renderer;
				this.frameGraph = null;
				this.cookiesRenderPass = RenderPassCookieRenderer.create(lightTextureAtlas.cookieRenderTarget, lightTextureAtlas.cubeSlotsOffsets);
				this.beforePasses.push(this.cookiesRenderPass);
				this.shadowRenderPass = new RenderPassShadowLocalClustered(device, shadowRenderer, shadowRendererLocal);
				this.beforePasses.push(this.shadowRenderPass);
		}
}

var _skinUpdateIndex = 0;
var viewProjMat = new Mat4();
var viewInvMat = new Mat4();
var viewMat = new Mat4();
var viewMat3 = new Mat3();
var tempSphere$1 = new BoundingSphere();
var _flipYMat = new Mat4().setScale(1, -1, 1);
var _tempLightSet = new Set();
var _tempLayerSet = new Set();
var _dynamicBindGroup = new DynamicBindGroup();
var _fixProjRangeMat = new Mat4().set([
		1,
		0,
		0,
		0,
		0,
		1,
		0,
		0,
		0,
		0,
		0.5,
		0,
		0,
		0,
		0.5,
		1
]);
var _haltonSequence = [
		new Vec2(0.5, 0.333333),
		new Vec2(0.25, 0.666667),
		new Vec2(0.75, 0.111111),
		new Vec2(0.125, 0.444444),
		new Vec2(0.625, 0.777778),
		new Vec2(0.375, 0.222222),
		new Vec2(0.875, 0.555556),
		new Vec2(0.0625, 0.888889),
		new Vec2(0.5625, 0.037037),
		new Vec2(0.3125, 0.370370),
		new Vec2(0.8125, 0.703704),
		new Vec2(0.1875, 0.148148),
		new Vec2(0.6875, 0.481481),
		new Vec2(0.4375, 0.814815),
		new Vec2(0.9375, 0.259259),
		new Vec2(0.03125, 0.592593)
];
var _tempProjMat0 = new Mat4();
var _tempProjMat1 = new Mat4();
var _tempProjMat2 = new Mat4();
var _tempProjMat3 = new Mat4();
var _tempProjMat4 = new Mat4();
var _tempProjMat5 = new Mat4();
var _tempSet = new Set();
var _tempMeshInstances = [];
var _tempMeshInstancesSkinned = [];
class Renderer {
		destroy() {
				this.shadowRenderer = null;
				this._shadowRendererLocal = null;
				this._shadowRendererDirectional = null;
				this.shadowMapCache.destroy();
				this.shadowMapCache = null;
				this._renderPassUpdateClustered.destroy();
				this._renderPassUpdateClustered = null;
				this.lightTextureAtlas.destroy();
				this.lightTextureAtlas = null;
		}
		setupViewport(camera, renderTarget) {
				var device = this.device;
				var pixelWidth = renderTarget ? renderTarget.width : device.width;
				var pixelHeight = renderTarget ? renderTarget.height : device.height;
				var rect = camera.rect;
				var x = Math.floor(rect.x * pixelWidth);
				var y = Math.floor(rect.y * pixelHeight);
				var w = Math.floor(rect.z * pixelWidth);
				var h = Math.floor(rect.w * pixelHeight);
				device.setViewport(x, y, w, h);
				if (camera._scissorRectClear) {
						var scissorRect = camera.scissorRect;
						x = Math.floor(scissorRect.x * pixelWidth);
						y = Math.floor(scissorRect.y * pixelHeight);
						w = Math.floor(scissorRect.z * pixelWidth);
						h = Math.floor(scissorRect.w * pixelHeight);
				}
				device.setScissor(x, y, w, h);
		}
		setCameraUniforms(camera, target) {
				var flipY = target == null ? void 0 : target.flipY;
				var viewCount = 1;
				if (camera.xr && camera.xr.session) {
						var _camera__node_parent, _camera__node;
						var transform = ((_camera__node = camera._node) == null ? void 0 : (_camera__node_parent = _camera__node.parent) == null ? void 0 : _camera__node_parent.getWorldTransform()) || null;
						var views = camera.xr.views;
						viewCount = views.list.length;
						for(var v = 0; v < viewCount; v++){
								var view = views.list[v];
								view.updateTransforms(transform);
								camera.frustum.setFromMat4(view.projViewOffMat);
						}
				} else {
						var projMat = camera.projectionMatrix;
						if (camera.calculateProjection) {
								camera.calculateProjection(projMat, VIEW_CENTER);
						}
						var projMatSkybox = camera.getProjectionMatrixSkybox();
						if (flipY) {
								projMat = _tempProjMat0.mul2(_flipYMat, projMat);
								projMatSkybox = _tempProjMat1.mul2(_flipYMat, projMatSkybox);
						}
						if (this.device.isWebGPU) {
								projMat = _tempProjMat2.mul2(_fixProjRangeMat, projMat);
								projMatSkybox = _tempProjMat3.mul2(_fixProjRangeMat, projMatSkybox);
						}
						var { jitter } = camera;
						var jitterX = 0;
						var jitterY = 0;
						if (jitter > 0) {
								var targetWidth = target ? target.width : this.device.width;
								var targetHeight = target ? target.height : this.device.height;
								var offset = _haltonSequence[this.device.renderVersion % _haltonSequence.length];
								jitterX = jitter * (offset.x * 2 - 1) / targetWidth;
								jitterY = jitter * (offset.y * 2 - 1) / targetHeight;
								projMat = _tempProjMat4.copy(projMat);
								projMat.data[8] = jitterX;
								projMat.data[9] = jitterY;
								projMatSkybox = _tempProjMat5.copy(projMatSkybox);
								projMatSkybox.data[8] = jitterX;
								projMatSkybox.data[9] = jitterY;
								if (this.blueNoiseJitterVersion !== this.device.renderVersion) {
										this.blueNoiseJitterVersion = this.device.renderVersion;
										this.blueNoise.vec4(this.blueNoiseJitterVec);
								}
						}
						var jitterVec = jitter > 0 ? this.blueNoiseJitterVec : Vec4.ZERO;
						this.blueNoiseJitterData[0] = jitterVec.x;
						this.blueNoiseJitterData[1] = jitterVec.y;
						this.blueNoiseJitterData[2] = jitterVec.z;
						this.blueNoiseJitterData[3] = jitterVec.w;
						this.blueNoiseJitterId.setValue(this.blueNoiseJitterData);
						this.projId.setValue(projMat.data);
						this.projSkyboxId.setValue(projMatSkybox.data);
						if (camera.calculateTransform) {
								camera.calculateTransform(viewInvMat, VIEW_CENTER);
						} else {
								var pos = camera._node.getPosition();
								var rot = camera._node.getRotation();
								viewInvMat.setTRS(pos, rot, Vec3.ONE);
						}
						this.viewInvId.setValue(viewInvMat.data);
						viewMat.copy(viewInvMat).invert();
						this.viewId.setValue(viewMat.data);
						viewMat3.setFromMat4(viewMat);
						this.viewId3.setValue(viewMat3.data);
						viewProjMat.mul2(projMat, viewMat);
						this.viewProjId.setValue(viewProjMat.data);
						camera._storeShaderMatrices(viewProjMat, jitterX, jitterY, this.device.renderVersion);
						this.flipYId.setValue(flipY ? -1 : 1);
						this.dispatchViewPos(camera._node.getPosition());
						camera.frustum.setFromMat4(viewProjMat);
				}
				this.tbnBasis.setValue(flipY ? -1 : 1);
				var n = camera._nearClip;
				var f = camera._farClip;
				this.nearClipId.setValue(n);
				this.farClipId.setValue(f);
				this.cameraParams[0] = 1 / f;
				this.cameraParams[1] = f;
				this.cameraParams[2] = n;
				this.cameraParams[3] = camera.projection === PROJECTION_ORTHOGRAPHIC ? 1 : 0;
				this.cameraParamsId.setValue(this.cameraParams);
				this.exposureId.setValue(this.scene.physicalUnits ? camera.getExposure() : this.scene.exposure);
				return viewCount;
		}
		clear(camera, clearColor, clearDepth, clearStencil) {
				var flags = ((clearColor != null ? clearColor : camera._clearColorBuffer) ? CLEARFLAG_COLOR : 0) | ((clearDepth != null ? clearDepth : camera._clearDepthBuffer) ? CLEARFLAG_DEPTH : 0) | ((clearStencil != null ? clearStencil : camera._clearStencilBuffer) ? CLEARFLAG_STENCIL : 0);
				if (flags) {
						var device = this.device;
						device.clear({
								color: [
										camera._clearColor.r,
										camera._clearColor.g,
										camera._clearColor.b,
										camera._clearColor.a
								],
								depth: camera._clearDepth,
								stencil: camera._clearStencil,
								flags: flags
						});
				}
		}
		setCamera(camera, target, clear, renderAction) {
				this.setCameraUniforms(camera, target);
				this.clearView(camera, target, clear, false);
		}
		clearView(camera, target, clear, forceWrite) {
				var device = this.device;
				device.setRenderTarget(target);
				device.updateBegin();
				if (forceWrite) {
						device.setColorWrite(true, true, true, true);
						device.setDepthWrite(true);
				}
				this.setupViewport(camera, target);
				if (clear) {
						var options = camera._clearOptions;
						device.clear(options ? options : {
								color: [
										camera._clearColor.r,
										camera._clearColor.g,
										camera._clearColor.b,
										camera._clearColor.a
								],
								depth: camera._clearDepth,
								flags: (camera._clearColorBuffer ? CLEARFLAG_COLOR : 0) | (camera._clearDepthBuffer ? CLEARFLAG_DEPTH : 0) | (camera._clearStencilBuffer ? CLEARFLAG_STENCIL : 0),
								stencil: camera._clearStencil
						});
				}
		}
		setupCullMode(cullFaces, flipFactor, drawCall) {
				var material = drawCall.material;
				var mode = CULLFACE_NONE;
				if (cullFaces) {
						var flipFaces = 1;
						if (material.cull === CULLFACE_FRONT || material.cull === CULLFACE_BACK) {
								flipFaces = flipFactor * drawCall.flipFacesFactor * drawCall.node.worldScaleSign;
						}
						if (flipFaces < 0) {
								mode = material.cull === CULLFACE_FRONT ? CULLFACE_BACK : CULLFACE_FRONT;
						} else {
								mode = material.cull;
						}
				}
				this.device.setCullMode(mode);
				if (mode === CULLFACE_NONE && material.cull === CULLFACE_NONE) {
						this.twoSidedLightingNegScaleFactorId.setValue(drawCall.node.worldScaleSign);
				}
		}
		updateCameraFrustum(camera) {
				if (camera.xr && camera.xr.views.list.length) {
						var view = camera.xr.views.list[0];
						viewProjMat.mul2(view.projMat, view.viewOffMat);
						camera.frustum.setFromMat4(viewProjMat);
						return;
				}
				var projMat = camera.projectionMatrix;
				if (camera.calculateProjection) {
						camera.calculateProjection(projMat, VIEW_CENTER);
				}
				if (camera.calculateTransform) {
						camera.calculateTransform(viewInvMat, VIEW_CENTER);
				} else {
						var pos = camera._node.getPosition();
						var rot = camera._node.getRotation();
						viewInvMat.setTRS(pos, rot, Vec3.ONE);
						this.viewInvId.setValue(viewInvMat.data);
				}
				viewMat.copy(viewInvMat).invert();
				viewProjMat.mul2(projMat, viewMat);
				camera.frustum.setFromMat4(viewProjMat);
		}
		setBaseConstants(device, material) {
				device.setCullMode(material.cull);
				if (material.opacityMap) {
						this.opacityMapId.setValue(material.opacityMap);
				}
				if (material.opacityMap || material.alphaTest > 0) {
						this.alphaTestId.setValue(material.alphaTest);
				}
		}
		updateCpuSkinMatrices(drawCalls) {
				_skinUpdateIndex++;
				var drawCallsCount = drawCalls.length;
				if (drawCallsCount === 0) return;
				for(var i = 0; i < drawCallsCount; i++){
						var si = drawCalls[i].skinInstance;
						if (si) {
								si.updateMatrices(drawCalls[i].node, _skinUpdateIndex);
								si._dirty = true;
						}
				}
		}
		updateGpuSkinMatrices(drawCalls) {
				for (var drawCall of drawCalls){
						var skin = drawCall.skinInstance;
						if (skin && skin._dirty) {
								skin.updateMatrixPalette(drawCall.node, _skinUpdateIndex);
								skin._dirty = false;
						}
				}
		}
		updateMorphing(drawCalls) {
				for (var drawCall of drawCalls){
						var morphInst = drawCall.morphInstance;
						if (morphInst && morphInst._dirty) {
								morphInst.update();
						}
				}
		}
		updateGSplats(drawCalls) {
				for (var drawCall of drawCalls){
						var _drawCall_gsplatInstance;
						(_drawCall_gsplatInstance = drawCall.gsplatInstance) == null ? void 0 : _drawCall_gsplatInstance.update();
				}
		}
		gpuUpdate(drawCalls) {
				this.updateGpuSkinMatrices(drawCalls);
				this.updateMorphing(drawCalls);
				this.updateGSplats(drawCalls);
		}
		setVertexBuffers(device, mesh) {
				device.setVertexBuffer(mesh.vertexBuffer);
		}
		setMorphing(device, morphInstance) {
				if (morphInstance) {
						morphInstance.prepareRendering(device);
						device.setVertexBuffer(morphInstance.morph.vertexBufferIds);
						this.morphPositionTex.setValue(morphInstance.texturePositions);
						this.morphNormalTex.setValue(morphInstance.textureNormals);
						this.morphTexParams.setValue(morphInstance._textureParams);
				}
		}
		setSkinning(device, meshInstance) {
				var skinInstance = meshInstance.skinInstance;
				if (skinInstance) {
						this._skinDrawCalls++;
						var boneTexture = skinInstance.boneTexture;
						this.boneTextureId.setValue(boneTexture);
						this.boneTextureSizeId.setValue(skinInstance.boneTextureSize);
				}
		}
		dispatchViewPos(position) {
				var vp = this.viewPos;
				vp[0] = position.x;
				vp[1] = position.y;
				vp[2] = position.z;
				this.viewPosId.setValue(vp);
		}
		initViewBindGroupFormat(isClustered) {
				if (this.device.supportsUniformBuffers && !this.viewUniformFormat) {
						var uniforms = [
								new UniformFormat('matrix_viewProjection', UNIFORMTYPE_MAT4),
								new UniformFormat('cubeMapRotationMatrix', UNIFORMTYPE_MAT3),
								new UniformFormat('view_position', UNIFORMTYPE_VEC3),
								new UniformFormat('skyboxIntensity', UNIFORMTYPE_FLOAT),
								new UniformFormat('exposure', UNIFORMTYPE_FLOAT),
								new UniformFormat('textureBias', UNIFORMTYPE_FLOAT)
						];
						if (isClustered) {
								uniforms.push(...[
										new UniformFormat('clusterCellsCountByBoundsSize', UNIFORMTYPE_VEC3),
										new UniformFormat('clusterTextureSize', UNIFORMTYPE_VEC3),
										new UniformFormat('clusterBoundsMin', UNIFORMTYPE_VEC3),
										new UniformFormat('clusterBoundsDelta', UNIFORMTYPE_VEC3),
										new UniformFormat('clusterCellsDot', UNIFORMTYPE_VEC3),
										new UniformFormat('clusterCellsMax', UNIFORMTYPE_VEC3),
										new UniformFormat('clusterCompressionLimit0', UNIFORMTYPE_VEC2),
										new UniformFormat('shadowAtlasParams', UNIFORMTYPE_VEC2),
										new UniformFormat('clusterMaxCells', UNIFORMTYPE_INT),
										new UniformFormat('clusterSkip', UNIFORMTYPE_FLOAT)
								]);
						}
						this.viewUniformFormat = new UniformBufferFormat(this.device, uniforms);
						var formats = [
								new BindUniformBufferFormat(UNIFORM_BUFFER_DEFAULT_SLOT_NAME, SHADERSTAGE_VERTEX | SHADERSTAGE_FRAGMENT),
								new BindTextureFormat('lightsTextureFloat', SHADERSTAGE_FRAGMENT, TEXTUREDIMENSION_2D, SAMPLETYPE_UNFILTERABLE_FLOAT),
								new BindTextureFormat('lightsTexture8', SHADERSTAGE_FRAGMENT, TEXTUREDIMENSION_2D, SAMPLETYPE_UNFILTERABLE_FLOAT),
								new BindTextureFormat('shadowAtlasTexture', SHADERSTAGE_FRAGMENT, TEXTUREDIMENSION_2D, SAMPLETYPE_DEPTH),
								new BindTextureFormat('cookieAtlasTexture', SHADERSTAGE_FRAGMENT, TEXTUREDIMENSION_2D, SAMPLETYPE_FLOAT),
								new BindTextureFormat('areaLightsLutTex1', SHADERSTAGE_FRAGMENT, TEXTUREDIMENSION_2D, SAMPLETYPE_FLOAT),
								new BindTextureFormat('areaLightsLutTex2', SHADERSTAGE_FRAGMENT, TEXTUREDIMENSION_2D, SAMPLETYPE_FLOAT)
						];
						if (isClustered) {
								formats.push(...[
										new BindTextureFormat('clusterWorldTexture', SHADERSTAGE_FRAGMENT, TEXTUREDIMENSION_2D, SAMPLETYPE_UNFILTERABLE_FLOAT)
								]);
						}
						this.viewBindGroupFormat = new BindGroupFormat(this.device, formats);
				}
		}
		setupViewUniformBuffers(viewBindGroups, viewUniformFormat, viewBindGroupFormat, viewCount) {
				var device = this.device;
				while(viewBindGroups.length < viewCount){
						var ub = new UniformBuffer(device, viewUniformFormat, false);
						var bg = new BindGroup(device, viewBindGroupFormat, ub);
						viewBindGroups.push(bg);
				}
				var viewBindGroup = viewBindGroups[0];
				viewBindGroup.defaultUniformBuffer.update();
				viewBindGroup.update();
				device.setBindGroup(BINDGROUP_VIEW, viewBindGroup);
		}
		setupMeshUniformBuffers(shaderInstance, meshInstance) {
				var device = this.device;
				if (device.supportsUniformBuffers) {
						this.modelMatrixId.setValue(meshInstance.node.worldTransform.data);
						this.normalMatrixId.setValue(meshInstance.node.normalMatrix.data);
						var meshBindGroup = shaderInstance.getBindGroup(device);
						meshBindGroup.update();
						device.setBindGroup(BINDGROUP_MESH, meshBindGroup);
						var meshUniformBuffer = shaderInstance.getUniformBuffer(device);
						meshUniformBuffer.update(_dynamicBindGroup);
						device.setBindGroup(BINDGROUP_MESH_UB, _dynamicBindGroup.bindGroup, _dynamicBindGroup.offsets);
				}
		}
		drawInstance(device, meshInstance, mesh, style, normal) {
				var modelMatrix = meshInstance.node.worldTransform;
				this.modelMatrixId.setValue(modelMatrix.data);
				if (normal) {
						this.normalMatrixId.setValue(meshInstance.node.normalMatrix.data);
				}
				var instancingData = meshInstance.instancingData;
				if (instancingData) {
						if (instancingData.count > 0) {
								this._instancedDrawCalls++;
								device.setVertexBuffer(instancingData.vertexBuffer);
								device.draw(mesh.primitive[style], instancingData.count);
						} else {
								device.clearVertexBuffer();
								device.clearIndexBuffer();
						}
				} else {
						device.draw(mesh.primitive[style]);
				}
		}
		drawInstance2(device, meshInstance, mesh, style) {
				var instancingData = meshInstance.instancingData;
				if (instancingData) {
						if (instancingData.count > 0) {
								this._instancedDrawCalls++;
								device.draw(mesh.primitive[style], instancingData.count, true);
						} else {
								device.clearVertexBuffer();
								device.clearIndexBuffer();
						}
				} else {
						device.draw(mesh.primitive[style], undefined, true);
				}
		}
		cull(camera, drawCalls, culledInstances) {
				var opaque = culledInstances.opaque;
				opaque.length = 0;
				var transparent = culledInstances.transparent;
				transparent.length = 0;
				var doCull = camera.frustumCulling;
				var count = drawCalls.length;
				for(var i = 0; i < count; i++){
						var drawCall = drawCalls[i];
						if (drawCall.visible) {
								var visible = !doCull || !drawCall.cull || drawCall._isVisible(camera);
								if (visible) {
										drawCall.visibleThisFrame = true;
										var bucket = drawCall.transparent ? transparent : opaque;
										bucket.push(drawCall);
										if (drawCall.skinInstance || drawCall.morphInstance || drawCall.gsplatInstance) {
												this.processingMeshInstances.add(drawCall);
												if (drawCall.gsplatInstance) {
														drawCall.gsplatInstance.cameras.push(camera);
												}
										}
								}
						}
				}
		}
		collectLights(comp) {
				this.lights.length = 0;
				this.localLights.length = 0;
				var stats = this.scene._stats;
				var count = comp.layerList.length;
				for(var i = 0; i < count; i++){
						var layer = comp.layerList[i];
						if (!_tempLayerSet.has(layer)) {
								_tempLayerSet.add(layer);
								var lights = layer._lights;
								for(var j = 0; j < lights.length; j++){
										var light = lights[j];
										if (!_tempLightSet.has(light)) {
												_tempLightSet.add(light);
												this.lights.push(light);
												if (light._type !== LIGHTTYPE_DIRECTIONAL) {
														this.localLights.push(light);
												}
										}
								}
						}
				}
				stats.lights = this.lights.length;
				_tempLightSet.clear();
				_tempLayerSet.clear();
		}
		cullLights(camera, lights) {
				var clusteredLightingEnabled = this.scene.clusteredLightingEnabled;
				var physicalUnits = this.scene.physicalUnits;
				for(var i = 0; i < lights.length; i++){
						var light = lights[i];
						if (light.enabled) {
								if (light._type !== LIGHTTYPE_DIRECTIONAL) {
										light.getBoundingSphere(tempSphere$1);
										if (camera.frustum.containsSphere(tempSphere$1)) {
												light.visibleThisFrame = true;
												light.usePhysicalUnits = physicalUnits;
												var screenSize = camera.getScreenSize(tempSphere$1);
												light.maxScreenSize = Math.max(light.maxScreenSize, screenSize);
										} else {
												if (!clusteredLightingEnabled) {
														if (light.castShadows && !light.shadowMap) {
																light.visibleThisFrame = true;
														}
												}
										}
								} else {
										light.usePhysicalUnits = this.scene.physicalUnits;
								}
						}
				}
		}
		cullShadowmaps(comp) {
				var isClustered = this.scene.clusteredLightingEnabled;
				for(var i = 0; i < this.localLights.length; i++){
						var light = this.localLights[i];
						if (light._type !== LIGHTTYPE_DIRECTIONAL) {
								if (isClustered) {
										if (light.atlasSlotUpdated && light.shadowUpdateMode === SHADOWUPDATE_NONE) {
												light.shadowUpdateMode = SHADOWUPDATE_THISFRAME;
										}
								} else {
										if (light.shadowUpdateMode === SHADOWUPDATE_NONE && light.castShadows) {
												if (!light.getRenderData(null, 0).shadowCamera.renderTarget) {
														light.shadowUpdateMode = SHADOWUPDATE_THISFRAME;
												}
										}
								}
								if (light.visibleThisFrame && light.castShadows && light.shadowUpdateMode !== SHADOWUPDATE_NONE) {
										this._shadowRendererLocal.cull(light, comp);
								}
						}
				}
				this.cameraDirShadowLights.clear();
				var cameras = comp.cameras;
				for(var i1 = 0; i1 < cameras.length; i1++){
						var cameraComponent = cameras[i1];
						if (cameraComponent.enabled) {
								var camera = cameraComponent.camera;
								var lightList = void 0;
								var cameraLayers = camera.layers;
								for(var l = 0; l < cameraLayers.length; l++){
										var cameraLayer = comp.getLayerById(cameraLayers[l]);
										if (cameraLayer) {
												var layerDirLights = cameraLayer.splitLights[LIGHTTYPE_DIRECTIONAL];
												for(var j = 0; j < layerDirLights.length; j++){
														var light1 = layerDirLights[j];
														if (light1.castShadows && !_tempSet.has(light1)) {
																_tempSet.add(light1);
																lightList = lightList != null ? lightList : [];
																lightList.push(light1);
																this._shadowRendererDirectional.cull(light1, comp, camera);
														}
												}
										}
								}
								if (lightList) {
										this.cameraDirShadowLights.set(camera, lightList);
								}
								_tempSet.clear();
						}
				}
		}
		cullComposition(comp) {
				var { scene } = this;
				this.processingMeshInstances.clear();
				var numCameras = comp.cameras.length;
				this._camerasRendered += numCameras;
				for(var i = 0; i < numCameras; i++){
						var camera = comp.cameras[i];
						scene == null ? void 0 : scene.fire(EVENT_PRECULL, camera);
						var renderTarget = camera.renderTarget;
						camera.frameUpdate(renderTarget);
						this.updateCameraFrustum(camera.camera);
						var layerIds = camera.layers;
						for(var j = 0; j < layerIds.length; j++){
								var layer = comp.getLayerById(layerIds[j]);
								if (layer && layer.enabled) {
										this.cullLights(camera.camera, layer._lights);
										var culledInstances = layer.getCulledInstances(camera.camera);
										this.cull(camera.camera, layer.meshInstances, culledInstances);
								}
						}
						scene == null ? void 0 : scene.fire(EVENT_POSTCULL, camera);
				}
				if (scene.clusteredLightingEnabled) {
						this.updateLightTextureAtlas();
				}
				this.cullShadowmaps(comp);
		}
		updateShaders(drawCalls, onlyLitShaders) {
				var count = drawCalls.length;
				for(var i = 0; i < count; i++){
						var mat = drawCalls[i].material;
						if (mat) {
								if (!_tempSet.has(mat)) {
										_tempSet.add(mat);
										if (mat.getShaderVariant !== Material.prototype.getShaderVariant) {
												if (onlyLitShaders) {
														if (!mat.useLighting || mat.emitter && !mat.emitter.lighting) {
																continue;
														}
												}
												mat.clearVariants();
										}
								}
						}
				}
				_tempSet.clear();
		}
		updateFrameUniforms() {
				this.blueNoiseTextureId.setValue(getBlueNoiseTexture(this.device));
		}
		beginFrame(comp) {
				var scene = this.scene;
				var updateShaders = scene.updateShaders || this.device._shadersDirty;
				var layers = comp.layerList;
				var layerCount = layers.length;
				for(var i = 0; i < layerCount; i++){
						var layer = layers[i];
						var meshInstances = layer.meshInstances;
						var count = meshInstances.length;
						for(var j = 0; j < count; j++){
								var meshInst = meshInstances[j];
								meshInst.visibleThisFrame = false;
								if (updateShaders) {
										_tempMeshInstances.push(meshInst);
								}
								if (meshInst.skinInstance) {
										_tempMeshInstancesSkinned.push(meshInst);
								}
						}
				}
				if (updateShaders) {
						var onlyLitShaders = !scene.updateShaders || !this.device._shadersDirty;
						this.updateShaders(_tempMeshInstances, onlyLitShaders);
						scene.updateShaders = false;
						this.device._shadersDirty = false;
						scene._shaderVersion++;
				}
				this.updateFrameUniforms();
				this.updateCpuSkinMatrices(_tempMeshInstancesSkinned);
				_tempMeshInstances.length = 0;
				_tempMeshInstancesSkinned.length = 0;
				var lights = this.lights;
				var lightCount = lights.length;
				for(var i1 = 0; i1 < lightCount; i1++){
						lights[i1].beginFrame();
				}
		}
		updateLightTextureAtlas() {
				this.lightTextureAtlas.update(this.localLights, this.scene.lighting);
		}
		updateLayerComposition(comp) {
				var len = comp.layerList.length;
				var scene = this.scene;
				var shaderVersion = scene._shaderVersion;
				for(var i = 0; i < len; i++){
						var layer = comp.layerList[i];
						layer._shaderVersion = shaderVersion;
				}
				comp._update();
		}
		frameUpdate() {
				this.clustersDebugRendered = false;
				this.initViewBindGroupFormat(this.scene.clusteredLightingEnabled);
				this.dirLightShadows.clear();
		}
		constructor(graphicsDevice){
				this.clustersDebugRendered = false;
				this.processingMeshInstances = new Set();
				this.lights = [];
				this.localLights = [];
				this.cameraDirShadowLights = new Map();
				this.dirLightShadows = new Map();
				this.blueNoise = new BlueNoise(123);
				this.device = graphicsDevice;
				this.scene = null;
				this.worldClustersAllocator = new WorldClustersAllocator(graphicsDevice);
				this.lightTextureAtlas = new LightTextureAtlas(graphicsDevice);
				this.shadowMapCache = new ShadowMapCache();
				this.shadowRenderer = new ShadowRenderer(this, this.lightTextureAtlas);
				this._shadowRendererLocal = new ShadowRendererLocal(this, this.shadowRenderer);
				this._shadowRendererDirectional = new ShadowRendererDirectional(this, this.shadowRenderer);
				this._renderPassUpdateClustered = new RenderPassUpdateClustered(this.device, this, this.shadowRenderer, this._shadowRendererLocal, this.lightTextureAtlas);
				this.viewUniformFormat = null;
				this.viewBindGroupFormat = null;
				this._skinTime = 0;
				this._morphTime = 0;
				this._cullTime = 0;
				this._shadowMapTime = 0;
				this._lightClustersTime = 0;
				this._layerCompositionUpdateTime = 0;
				this._shadowDrawCalls = 0;
				this._skinDrawCalls = 0;
				this._instancedDrawCalls = 0;
				this._shadowMapUpdates = 0;
				this._numDrawCallsCulled = 0;
				this._camerasRendered = 0;
				this._lightClusters = 0;
				var scope = graphicsDevice.scope;
				this.boneTextureId = scope.resolve('texture_poseMap');
				this.boneTextureSizeId = scope.resolve('texture_poseMapSize');
				this.modelMatrixId = scope.resolve('matrix_model');
				this.normalMatrixId = scope.resolve('matrix_normal');
				this.viewInvId = scope.resolve('matrix_viewInverse');
				this.viewPos = new Float32Array(3);
				this.viewPosId = scope.resolve('view_position');
				this.projId = scope.resolve('matrix_projection');
				this.projSkyboxId = scope.resolve('matrix_projectionSkybox');
				this.viewId = scope.resolve('matrix_view');
				this.viewId3 = scope.resolve('matrix_view3');
				this.viewProjId = scope.resolve('matrix_viewProjection');
				this.flipYId = scope.resolve('projectionFlipY');
				this.tbnBasis = scope.resolve('tbnBasis');
				this.nearClipId = scope.resolve('camera_near');
				this.farClipId = scope.resolve('camera_far');
				this.cameraParams = new Float32Array(4);
				this.cameraParamsId = scope.resolve('camera_params');
				this.viewIndexId = scope.resolve('view_index');
				this.blueNoiseJitterVersion = 0;
				this.blueNoiseJitterVec = new Vec4();
				this.blueNoiseJitterData = new Float32Array(4);
				this.blueNoiseJitterId = scope.resolve('blueNoiseJitter');
				this.blueNoiseTextureId = scope.resolve('blueNoiseTex32');
				this.alphaTestId = scope.resolve('alpha_ref');
				this.opacityMapId = scope.resolve('texture_opacityMap');
				this.exposureId = scope.resolve('exposure');
				this.twoSidedLightingNegScaleFactorId = scope.resolve('twoSidedLightingNegScaleFactor');
				this.twoSidedLightingNegScaleFactorId.setValue(0);
				this.morphPositionTex = scope.resolve('morphPositionTex');
				this.morphNormalTex = scope.resolve('morphNormalTex');
				this.morphTexParams = scope.resolve('morph_tex_params');
				this.lightCube = new LightCube();
				this.constantLightCube = scope.resolve('lightCube[0]');
		}
}

class RenderAction {
		destroy() {
				this.viewBindGroups.forEach((bg)=>{
						bg.defaultUniformBuffer.destroy();
						bg.destroy();
				});
				this.viewBindGroups.length = 0;
		}
		setupClears(camera, layer) {
				this.clearColor = (camera == null ? void 0 : camera.clearColorBuffer) || layer.clearColorBuffer;
				this.clearDepth = (camera == null ? void 0 : camera.clearDepthBuffer) || layer.clearDepthBuffer;
				this.clearStencil = (camera == null ? void 0 : camera.clearStencilBuffer) || layer.clearStencilBuffer;
		}
		constructor(){
				this.camera = null;
				this.layer = null;
				this.transparent = false;
				this.renderTarget = null;
				this.lightClusters = null;
				this.clearColor = false;
				this.clearDepth = false;
				this.clearStencil = false;
				this.triggerPostprocess = false;
				this.firstCameraUse = false;
				this.lastCameraUse = false;
				this.viewBindGroups = [];
				this.useCameraPasses = false;
		}
}

class RenderPassForward extends RenderPass {
		get rendersAnything() {
				return this.renderActions.length > 0;
		}
		addRenderAction(renderAction) {
				this.renderActions.push(renderAction);
		}
		addLayer(cameraComponent, layer, transparent, autoClears) {
				if (autoClears === void 0) autoClears = true;
				var ra = new RenderAction();
				ra.renderTarget = this.renderTarget;
				ra.camera = cameraComponent;
				ra.layer = layer;
				ra.transparent = transparent;
				if (autoClears) {
						var firstRa = this.renderActions.length === 0;
						ra.setupClears(firstRa ? cameraComponent : undefined, layer);
				}
				this.addRenderAction(ra);
		}
		addLayers(composition, cameraComponent, startIndex, firstLayerClears, lastLayerId, lastLayerIsTransparent) {
				if (lastLayerIsTransparent === void 0) lastLayerIsTransparent = true;
				var { layerList, subLayerList } = composition;
				var clearRenderTarget = firstLayerClears;
				var index = startIndex;
				while(index < layerList.length){
						var layer = layerList[index];
						var isTransparent = subLayerList[index];
						var renderedByCamera = cameraComponent.camera.layersSet.has(layer.id);
						if (renderedByCamera) {
								this.addLayer(cameraComponent, layer, isTransparent, clearRenderTarget);
								clearRenderTarget = false;
						}
						index++;
						if (layer.id === lastLayerId && isTransparent === lastLayerIsTransparent) {
								break;
						}
				}
				return index;
		}
		updateDirectionalShadows() {
				var { renderer, renderActions } = this;
				for(var i = 0; i < renderActions.length; i++){
						var renderAction = renderActions[i];
						var cameraComp = renderAction.camera;
						var camera = cameraComp.camera;
						var shadowDirLights = this.renderer.cameraDirShadowLights.get(camera);
						if (shadowDirLights) {
								for(var l = 0; l < shadowDirLights.length; l++){
										var light = shadowDirLights[l];
										if (renderer.dirLightShadows.get(light) !== camera) {
												renderer.dirLightShadows.set(light, camera);
												var shadowPass = renderer._shadowRendererDirectional.getLightRenderPass(light, camera);
												if (shadowPass) {
														this.beforePasses.push(shadowPass);
												}
										}
								}
						}
				}
		}
		updateClears() {
				var renderAction = this.renderActions[0];
				if (renderAction) {
						var cameraComponent = renderAction.camera;
						var camera = cameraComponent.camera;
						var fullSizeClearRect = camera.fullSizeClearRect;
						this.setClearColor(fullSizeClearRect && renderAction.clearColor ? camera.clearColor : undefined);
						this.setClearDepth(fullSizeClearRect && renderAction.clearDepth && !this.noDepthClear ? camera.clearDepth : undefined);
						this.setClearStencil(fullSizeClearRect && renderAction.clearStencil ? camera.clearStencil : undefined);
				}
		}
		frameUpdate() {
				super.frameUpdate();
				this.updateDirectionalShadows();
				this.updateClears();
		}
		before() {
				var { renderActions } = this;
				for(var i = 0; i < renderActions.length; i++){
						var ra = renderActions[i];
						if (ra.firstCameraUse) {
								this.scene.fire(EVENT_PRERENDER, ra.camera);
						}
				}
		}
		execute() {
				var { layerComposition, renderActions } = this;
				for(var i = 0; i < renderActions.length; i++){
						var ra = renderActions[i];
						var layer = ra.layer;
						if (layerComposition.isEnabled(layer, ra.transparent)) {
								this.renderRenderAction(ra, i === 0);
						}
				}
		}
		after() {
				for(var i = 0; i < this.renderActions.length; i++){
						var ra = this.renderActions[i];
						if (ra.lastCameraUse) {
								this.scene.fire(EVENT_POSTRENDER, ra.camera);
						}
				}
				this.beforePasses.length = 0;
		}
		renderRenderAction(renderAction, firstRenderAction) {
				var { renderer, scene } = this;
				var device = renderer.device;
				var { layer, transparent, camera } = renderAction;
				if (camera) {
						var _camera_camera_shaderPassInfo;
						var originalGammaCorrection = camera.gammaCorrection;
						var originalToneMapping = camera.toneMapping;
						if (this.gammaCorrection !== undefined) camera.gammaCorrection = this.gammaCorrection;
						if (this.toneMapping !== undefined) camera.toneMapping = this.toneMapping;
						scene.fire(EVENT_PRERENDER_LAYER, camera, layer, transparent);
						var options = {
								lightClusters: renderAction.lightClusters
						};
						var _camera_camera_shaderPassInfo_index;
						var shaderPass = (_camera_camera_shaderPassInfo_index = (_camera_camera_shaderPassInfo = camera.camera.shaderPassInfo) == null ? void 0 : _camera_camera_shaderPassInfo.index) != null ? _camera_camera_shaderPassInfo_index : SHADER_FORWARD;
						if (!firstRenderAction || !camera.camera.fullSizeClearRect) {
								options.clearColor = renderAction.clearColor;
								options.clearDepth = renderAction.clearDepth;
								options.clearStencil = renderAction.clearStencil;
						}
						var _renderAction_renderTarget;
						var renderTarget = (_renderAction_renderTarget = renderAction.renderTarget) != null ? _renderAction_renderTarget : device.backBuffer;
						renderer.renderForwardLayer(camera.camera, renderTarget, layer, transparent, shaderPass, renderAction.viewBindGroups, options);
						device.setBlendState(BlendState.NOBLEND);
						device.setStencilState(null, null);
						device.setAlphaToCoverage(false);
						scene.fire(EVENT_POSTRENDER_LAYER, camera, layer, transparent);
						if (this.gammaCorrection !== undefined) camera.gammaCorrection = originalGammaCorrection;
						if (this.toneMapping !== undefined) camera.toneMapping = originalToneMapping;
				}
		}
		constructor(device, layerComposition, scene, renderer){
				super(device), this.renderActions = [], this.noDepthClear = false;
				this.layerComposition = layerComposition;
				this.scene = scene;
				this.renderer = renderer;
		}
}

class RenderPassPostprocessing extends RenderPass {
		execute() {
				var renderAction = this.renderAction;
				var camera = renderAction.camera;
				camera.onPostprocessing();
		}
		constructor(device, renderer, renderAction){
				super(device);
				this.renderer = renderer;
				this.renderAction = renderAction;
				this.requiresCubemaps = false;
		}
}

var _noLights = [
		[],
		[],
		[]
];
var tmpColor$1 = new Color();
var _drawCallList = {
		drawCalls: [],
		shaderInstances: [],
		isNewMaterial: [],
		lightMaskChanged: [],
		clear: function clear() {
				this.drawCalls.length = 0;
				this.shaderInstances.length = 0;
				this.isNewMaterial.length = 0;
				this.lightMaskChanged.length = 0;
		}
};
function vogelDiskPrecalculationSamples(numSamples) {
		var samples = [];
		for(var i = 0; i < numSamples; ++i){
				var r = Math.sqrt(i + 0.5) / Math.sqrt(numSamples);
				samples.push(r);
		}
		return samples;
}
function vogelSpherePrecalculationSamples(numSamples) {
		var samples = [];
		for(var i = 0; i < numSamples; i++){
				var weight = i / numSamples;
				var radius = Math.sqrt(weight * weight);
				samples.push(radius);
		}
		return samples;
}
class ForwardRenderer extends Renderer {
		destroy() {
				super.destroy();
		}
		dispatchGlobalLights(scene) {
				var ambientUniform = this.ambientColor;
				tmpColor$1.linear(scene.ambientLight);
				ambientUniform[0] = tmpColor$1.r;
				ambientUniform[1] = tmpColor$1.g;
				ambientUniform[2] = tmpColor$1.b;
				if (scene.physicalUnits) {
						for(var i = 0; i < 3; i++){
								ambientUniform[i] *= scene.ambientLuminance;
						}
				}
				this.ambientId.setValue(ambientUniform);
				this.skyboxIntensityId.setValue(scene.physicalUnits ? scene.skyboxLuminance : scene.skyboxIntensity);
				this.cubeMapRotationMatrixId.setValue(scene._skyboxRotationMat3.data);
		}
		_resolveLight(scope, i) {
				var light = "light" + i;
				this.lightColorId[i] = scope.resolve("" + light + "_color");
				this.lightDir[i] = new Float32Array(3);
				this.lightDirId[i] = scope.resolve("" + light + "_direction");
				this.lightShadowMapId[i] = scope.resolve("" + light + "_shadowMap");
				this.lightShadowMatrixId[i] = scope.resolve("" + light + "_shadowMatrix");
				this.lightShadowParamsId[i] = scope.resolve("" + light + "_shadowParams");
				this.lightShadowIntensity[i] = scope.resolve("" + light + "_shadowIntensity");
				this.lightShadowSearchAreaId[i] = scope.resolve("" + light + "_shadowSearchArea");
				this.lightRadiusId[i] = scope.resolve("" + light + "_radius");
				this.lightPos[i] = new Float32Array(3);
				this.lightPosId[i] = scope.resolve("" + light + "_position");
				this.lightWidth[i] = new Float32Array(3);
				this.lightWidthId[i] = scope.resolve("" + light + "_halfWidth");
				this.lightHeight[i] = new Float32Array(3);
				this.lightHeightId[i] = scope.resolve("" + light + "_halfHeight");
				this.lightInAngleId[i] = scope.resolve("" + light + "_innerConeAngle");
				this.lightOutAngleId[i] = scope.resolve("" + light + "_outerConeAngle");
				this.lightCookieId[i] = scope.resolve("" + light + "_cookie");
				this.lightCookieIntId[i] = scope.resolve("" + light + "_cookieIntensity");
				this.lightCookieMatrixId[i] = scope.resolve("" + light + "_cookieMatrix");
				this.lightCookieOffsetId[i] = scope.resolve("" + light + "_cookieOffset");
				this.lightCameraParamsId[i] = scope.resolve("" + light + "_cameraParams");
				this.lightSoftShadowParamsId[i] = scope.resolve("" + light + "_softShadowParams");
				this.shadowMatrixPaletteId[i] = scope.resolve("" + light + "_shadowMatrixPalette[0]");
				this.shadowCascadeDistancesId[i] = scope.resolve("" + light + "_shadowCascadeDistances");
				this.shadowCascadeCountId[i] = scope.resolve("" + light + "_shadowCascadeCount");
				this.shadowCascadeBlendId[i] = scope.resolve("" + light + "_shadowCascadeBlend");
		}
		setLTCDirectionalLight(wtm, cnt, dir, campos, far) {
				this.lightPos[cnt][0] = campos.x - dir.x * far;
				this.lightPos[cnt][1] = campos.y - dir.y * far;
				this.lightPos[cnt][2] = campos.z - dir.z * far;
				this.lightPosId[cnt].setValue(this.lightPos[cnt]);
				var hWidth = wtm.transformVector(new Vec3(-0.5, 0, 0));
				this.lightWidth[cnt][0] = hWidth.x * far;
				this.lightWidth[cnt][1] = hWidth.y * far;
				this.lightWidth[cnt][2] = hWidth.z * far;
				this.lightWidthId[cnt].setValue(this.lightWidth[cnt]);
				var hHeight = wtm.transformVector(new Vec3(0, 0, 0.5));
				this.lightHeight[cnt][0] = hHeight.x * far;
				this.lightHeight[cnt][1] = hHeight.y * far;
				this.lightHeight[cnt][2] = hHeight.z * far;
				this.lightHeightId[cnt].setValue(this.lightHeight[cnt]);
		}
		dispatchDirectLights(dirs, mask, camera) {
				var cnt = 0;
				var scope = this.device.scope;
				for(var i = 0; i < dirs.length; i++){
						if (!(dirs[i].mask & mask)) continue;
						var directional = dirs[i];
						var wtm = directional._node.getWorldTransform();
						if (!this.lightColorId[cnt]) {
								this._resolveLight(scope, cnt);
						}
						this.lightColorId[cnt].setValue(directional._colorLinear);
						wtm.getY(directional._direction).mulScalar(-1);
						directional._direction.normalize();
						this.lightDir[cnt][0] = directional._direction.x;
						this.lightDir[cnt][1] = directional._direction.y;
						this.lightDir[cnt][2] = directional._direction.z;
						this.lightDirId[cnt].setValue(this.lightDir[cnt]);
						if (directional.shape !== LIGHTSHAPE_PUNCTUAL) {
								this.setLTCDirectionalLight(wtm, cnt, directional._direction, camera._node.getPosition(), camera.farClip);
						}
						if (directional.castShadows) {
								var lightRenderData = directional.getRenderData(camera, 0);
								var biases = directional._getUniformBiasValues(lightRenderData);
								this.lightShadowMapId[cnt].setValue(lightRenderData.shadowBuffer);
								this.lightShadowMatrixId[cnt].setValue(lightRenderData.shadowMatrix.data);
								this.shadowMatrixPaletteId[cnt].setValue(directional._shadowMatrixPalette);
								this.shadowCascadeDistancesId[cnt].setValue(directional._shadowCascadeDistances);
								this.shadowCascadeCountId[cnt].setValue(directional.numCascades);
								this.shadowCascadeBlendId[cnt].setValue(1 - directional.cascadeBlend);
								this.lightShadowIntensity[cnt].setValue(directional.shadowIntensity);
								this.lightSoftShadowParamsId[cnt].setValue(directional._softShadowParams);
								var shadowRT = lightRenderData.shadowCamera.renderTarget;
								if (shadowRT) {
										this.lightShadowSearchAreaId[cnt].setValue(directional.penumbraSize / lightRenderData.shadowCamera.renderTarget.width * lightRenderData.projectionCompensation);
								}
								var cameraParams = directional._shadowCameraParams;
								cameraParams.length = 4;
								cameraParams[0] = 0;
								cameraParams[1] = lightRenderData.shadowCamera._farClip;
								cameraParams[2] = lightRenderData.shadowCamera._nearClip;
								cameraParams[3] = 1;
								this.lightCameraParamsId[cnt].setValue(cameraParams);
								var params = directional._shadowRenderParams;
								params.length = 4;
								params[0] = directional._shadowResolution;
								params[1] = biases.normalBias;
								params[2] = biases.bias;
								params[3] = 0;
								this.lightShadowParamsId[cnt].setValue(params);
						}
						cnt++;
				}
				return cnt;
		}
		setLTCPositionalLight(wtm, cnt) {
				var hWidth = wtm.transformVector(new Vec3(-0.5, 0, 0));
				this.lightWidth[cnt][0] = hWidth.x;
				this.lightWidth[cnt][1] = hWidth.y;
				this.lightWidth[cnt][2] = hWidth.z;
				this.lightWidthId[cnt].setValue(this.lightWidth[cnt]);
				var hHeight = wtm.transformVector(new Vec3(0, 0, 0.5));
				this.lightHeight[cnt][0] = hHeight.x;
				this.lightHeight[cnt][1] = hHeight.y;
				this.lightHeight[cnt][2] = hHeight.z;
				this.lightHeightId[cnt].setValue(this.lightHeight[cnt]);
		}
		dispatchOmniLight(scope, omni, cnt) {
				var wtm = omni._node.getWorldTransform();
				if (!this.lightColorId[cnt]) {
						this._resolveLight(scope, cnt);
				}
				this.lightRadiusId[cnt].setValue(omni.attenuationEnd);
				this.lightColorId[cnt].setValue(omni._colorLinear);
				wtm.getTranslation(omni._position);
				this.lightPos[cnt][0] = omni._position.x;
				this.lightPos[cnt][1] = omni._position.y;
				this.lightPos[cnt][2] = omni._position.z;
				this.lightPosId[cnt].setValue(this.lightPos[cnt]);
				if (omni.shape !== LIGHTSHAPE_PUNCTUAL) {
						this.setLTCPositionalLight(wtm, cnt);
				}
				if (omni.castShadows) {
						var lightRenderData = omni.getRenderData(null, 0);
						this.lightShadowMapId[cnt].setValue(lightRenderData.shadowBuffer);
						var biases = omni._getUniformBiasValues(lightRenderData);
						var params = omni._shadowRenderParams;
						params.length = 4;
						params[0] = omni._shadowResolution;
						params[1] = biases.normalBias;
						params[2] = biases.bias;
						params[3] = 1.0 / omni.attenuationEnd;
						this.lightShadowParamsId[cnt].setValue(params);
						this.lightShadowIntensity[cnt].setValue(omni.shadowIntensity);
						var pixelsPerMeter = omni.penumbraSize / lightRenderData.shadowCamera.renderTarget.width;
						this.lightShadowSearchAreaId[cnt].setValue(pixelsPerMeter);
						var cameraParams = omni._shadowCameraParams;
						cameraParams.length = 4;
						cameraParams[0] = 0;
						cameraParams[1] = lightRenderData.shadowCamera._farClip;
						cameraParams[2] = lightRenderData.shadowCamera._nearClip;
						cameraParams[3] = 0;
						this.lightCameraParamsId[cnt].setValue(cameraParams);
				}
				if (omni._cookie) {
						this.lightCookieId[cnt].setValue(omni._cookie);
						this.lightShadowMatrixId[cnt].setValue(wtm.data);
						this.lightCookieIntId[cnt].setValue(omni.cookieIntensity);
				}
		}
		dispatchSpotLight(scope, spot, cnt) {
				var wtm = spot._node.getWorldTransform();
				if (!this.lightColorId[cnt]) {
						this._resolveLight(scope, cnt);
				}
				this.lightInAngleId[cnt].setValue(spot._innerConeAngleCos);
				this.lightOutAngleId[cnt].setValue(spot._outerConeAngleCos);
				this.lightRadiusId[cnt].setValue(spot.attenuationEnd);
				this.lightColorId[cnt].setValue(spot._colorLinear);
				wtm.getTranslation(spot._position);
				this.lightPos[cnt][0] = spot._position.x;
				this.lightPos[cnt][1] = spot._position.y;
				this.lightPos[cnt][2] = spot._position.z;
				this.lightPosId[cnt].setValue(this.lightPos[cnt]);
				if (spot.shape !== LIGHTSHAPE_PUNCTUAL) {
						this.setLTCPositionalLight(wtm, cnt);
				}
				wtm.getY(spot._direction).mulScalar(-1);
				spot._direction.normalize();
				this.lightDir[cnt][0] = spot._direction.x;
				this.lightDir[cnt][1] = spot._direction.y;
				this.lightDir[cnt][2] = spot._direction.z;
				this.lightDirId[cnt].setValue(this.lightDir[cnt]);
				if (spot.castShadows) {
						var lightRenderData = spot.getRenderData(null, 0);
						this.lightShadowMapId[cnt].setValue(lightRenderData.shadowBuffer);
						this.lightShadowMatrixId[cnt].setValue(lightRenderData.shadowMatrix.data);
						var biases = spot._getUniformBiasValues(lightRenderData);
						var params = spot._shadowRenderParams;
						params.length = 4;
						params[0] = spot._shadowResolution;
						params[1] = biases.normalBias;
						params[2] = biases.bias;
						params[3] = 1.0 / spot.attenuationEnd;
						this.lightShadowParamsId[cnt].setValue(params);
						this.lightShadowIntensity[cnt].setValue(spot.shadowIntensity);
						var pixelsPerMeter = spot.penumbraSize / lightRenderData.shadowCamera.renderTarget.width;
						var fov = lightRenderData.shadowCamera._fov * Math.PI / 180.0;
						var fovRatio = 1.0 / Math.tan(fov / 2.0);
						this.lightShadowSearchAreaId[cnt].setValue(pixelsPerMeter * fovRatio);
						var cameraParams = spot._shadowCameraParams;
						cameraParams.length = 4;
						cameraParams[0] = 0;
						cameraParams[1] = lightRenderData.shadowCamera._farClip;
						cameraParams[2] = lightRenderData.shadowCamera._nearClip;
						cameraParams[3] = 0;
						this.lightCameraParamsId[cnt].setValue(cameraParams);
				}
				if (spot._cookie) {
						if (!spot.castShadows) {
								var cookieMatrix = LightCamera.evalSpotCookieMatrix(spot);
								this.lightShadowMatrixId[cnt].setValue(cookieMatrix.data);
						}
						this.lightCookieId[cnt].setValue(spot._cookie);
						this.lightCookieIntId[cnt].setValue(spot.cookieIntensity);
						if (spot._cookieTransform) {
								spot._cookieTransformUniform[0] = spot._cookieTransform.x;
								spot._cookieTransformUniform[1] = spot._cookieTransform.y;
								spot._cookieTransformUniform[2] = spot._cookieTransform.z;
								spot._cookieTransformUniform[3] = spot._cookieTransform.w;
								this.lightCookieMatrixId[cnt].setValue(spot._cookieTransformUniform);
								spot._cookieOffsetUniform[0] = spot._cookieOffset.x;
								spot._cookieOffsetUniform[1] = spot._cookieOffset.y;
								this.lightCookieOffsetId[cnt].setValue(spot._cookieOffsetUniform);
						}
				}
		}
		dispatchLocalLights(sortedLights, mask, usedDirLights) {
				var cnt = usedDirLights;
				var scope = this.device.scope;
				var omnis = sortedLights[LIGHTTYPE_OMNI];
				var numOmnis = omnis.length;
				for(var i = 0; i < numOmnis; i++){
						var omni = omnis[i];
						if (!(omni.mask & mask)) continue;
						this.dispatchOmniLight(scope, omni, cnt);
						cnt++;
				}
				var spts = sortedLights[LIGHTTYPE_SPOT];
				var numSpts = spts.length;
				for(var i1 = 0; i1 < numSpts; i1++){
						var spot = spts[i1];
						if (!(spot.mask & mask)) continue;
						this.dispatchSpotLight(scope, spot, cnt);
						cnt++;
				}
		}
		renderForwardPrepareMaterials(camera, renderTarget, drawCalls, sortedLights, layer, pass) {
				var _camera_fog;
				var fogParams = (_camera_fog = camera.fog) != null ? _camera_fog : this.scene.fog;
				var shaderParams = camera.shaderParams;
				shaderParams.fog = fogParams.type;
				var _renderTarget_isColorBufferSrgb;
				shaderParams.srgbRenderTarget = (_renderTarget_isColorBufferSrgb = renderTarget == null ? void 0 : renderTarget.isColorBufferSrgb(0)) != null ? _renderTarget_isColorBufferSrgb : false;
				var addCall = (drawCall, shaderInstance, isNewMaterial, lightMaskChanged)=>{
						_drawCallList.drawCalls.push(drawCall);
						_drawCallList.shaderInstances.push(shaderInstance);
						_drawCallList.isNewMaterial.push(isNewMaterial);
						_drawCallList.lightMaskChanged.push(lightMaskChanged);
				};
				_drawCallList.clear();
				var device = this.device;
				var scene = this.scene;
				var clusteredLightingEnabled = scene.clusteredLightingEnabled;
				var _layer_getLightHash;
				var lightHash = (_layer_getLightHash = layer == null ? void 0 : layer.getLightHash(clusteredLightingEnabled)) != null ? _layer_getLightHash : 0;
				var prevMaterial = null, prevObjDefs, prevLightMask;
				var drawCallsCount = drawCalls.length;
				for(var i = 0; i < drawCallsCount; i++){
						var drawCall = drawCalls[i];
						drawCall.ensureMaterial(device);
						var material = drawCall.material;
						var objDefs = drawCall._shaderDefs;
						var lightMask = drawCall.mask;
						if (material && material === prevMaterial && objDefs !== prevObjDefs) {
								prevMaterial = null;
						}
						if (material !== prevMaterial) {
								this._materialSwitches++;
								material._scene = scene;
								if (material.dirty) {
										material.updateUniforms(device, scene);
										material.dirty = false;
								}
						}
						var shaderInstance = drawCall.getShaderInstance(pass, lightHash, scene, shaderParams, this.viewUniformFormat, this.viewBindGroupFormat, sortedLights);
						addCall(drawCall, shaderInstance, material !== prevMaterial, !prevMaterial || lightMask !== prevLightMask);
						prevMaterial = material;
						prevObjDefs = objDefs;
						prevLightMask = lightMask;
				}
				return _drawCallList;
		}
		renderForwardInternal(camera, preparedCalls, sortedLights, pass, drawCallback, flipFaces) {
				var device = this.device;
				var scene = this.scene;
				var passFlag = 1 << pass;
				var flipFactor = flipFaces ? -1 : 1;
				var clusteredLightingEnabled = scene.clusteredLightingEnabled;
				var preparedCallsCount = preparedCalls.drawCalls.length;
				for(var i = 0; i < preparedCallsCount; i++){
						var drawCall = preparedCalls.drawCalls[i];
						var newMaterial = preparedCalls.isNewMaterial[i];
						var lightMaskChanged = preparedCalls.lightMaskChanged[i];
						var shaderInstance = preparedCalls.shaderInstances[i];
						var material = drawCall.material;
						var lightMask = drawCall.mask;
						if (newMaterial) {
								var asyncCompile = false;
								device.setShader(shaderInstance.shader, asyncCompile);
								material.setParameters(device);
								if (lightMaskChanged) {
										var usedDirLights = this.dispatchDirectLights(sortedLights[LIGHTTYPE_DIRECTIONAL], lightMask, camera);
										if (!clusteredLightingEnabled) {
												this.dispatchLocalLights(sortedLights, lightMask, usedDirLights);
										}
								}
								this.alphaTestId.setValue(material.alphaTest);
								device.setBlendState(material.blendState);
								device.setDepthState(material.depthState);
								device.setAlphaToCoverage(material.alphaToCoverage);
						}
						this.setupCullMode(camera._cullFaces, flipFactor, drawCall);
						var _drawCall_stencilFront;
						var stencilFront = (_drawCall_stencilFront = drawCall.stencilFront) != null ? _drawCall_stencilFront : material.stencilFront;
						var _drawCall_stencilBack;
						var stencilBack = (_drawCall_stencilBack = drawCall.stencilBack) != null ? _drawCall_stencilBack : material.stencilBack;
						device.setStencilState(stencilFront, stencilBack);
						drawCall.setParameters(device, passFlag);
						device.scope.resolve('meshInstanceId').setValue(drawCall.id);
						var mesh = drawCall.mesh;
						this.setVertexBuffers(device, mesh);
						this.setMorphing(device, drawCall.morphInstance);
						this.setSkinning(device, drawCall);
						this.setupMeshUniformBuffers(shaderInstance, drawCall);
						var style = drawCall.renderStyle;
						device.setIndexBuffer(mesh.indexBuffer[style]);
						drawCallback == null ? void 0 : drawCallback(drawCall, i);
						if (camera.xr && camera.xr.session && camera.xr.views.list.length) {
								var views = camera.xr.views;
								for(var v = 0; v < views.list.length; v++){
										var view = views.list[v];
										device.setViewport(view.viewport.x, view.viewport.y, view.viewport.z, view.viewport.w);
										this.projId.setValue(view.projMat.data);
										this.projSkyboxId.setValue(view.projMat.data);
										this.viewId.setValue(view.viewOffMat.data);
										this.viewInvId.setValue(view.viewInvOffMat.data);
										this.viewId3.setValue(view.viewMat3.data);
										this.viewProjId.setValue(view.projViewOffMat.data);
										this.viewPosId.setValue(view.positionData);
										this.viewIndexId.setValue(v);
										if (v === 0) {
												this.drawInstance(device, drawCall, mesh, style, true);
										} else {
												this.drawInstance2(device, drawCall, mesh, style);
										}
										this._forwardDrawCalls++;
								}
						} else {
								this.drawInstance(device, drawCall, mesh, style, true);
								this._forwardDrawCalls++;
						}
						if (i < preparedCallsCount - 1 && !preparedCalls.isNewMaterial[i + 1]) {
								material.setParameters(device, drawCall.parameters);
						}
				}
		}
		renderForward(camera, renderTarget, allDrawCalls, sortedLights, pass, drawCallback, layer, flipFaces) {
				var preparedCalls = this.renderForwardPrepareMaterials(camera, renderTarget, allDrawCalls, sortedLights, layer, pass);
				this.renderForwardInternal(camera, preparedCalls, sortedLights, pass, drawCallback, flipFaces);
				_drawCallList.clear();
		}
		renderForwardLayer(camera, renderTarget, layer, transparent, shaderPass, viewBindGroups, options) {
				if (options === void 0) options = {};
				var { scene, device } = this;
				var clusteredLightingEnabled = scene.clusteredLightingEnabled;
				this.setupViewport(camera, renderTarget);
				var visible, splitLights;
				if (layer) {
						layer.sortVisible(camera, transparent);
						var culledInstances = layer.getCulledInstances(camera);
						visible = transparent ? culledInstances.transparent : culledInstances.opaque;
						scene.immediate.onPreRenderLayer(layer, visible, transparent);
						if (layer.requiresLightCube) {
								this.lightCube.update(scene.ambientLight, layer._lights);
								this.constantLightCube.setValue(this.lightCube.colors);
						}
						splitLights = layer.splitLights;
				} else {
						visible = options.meshInstances;
						var _options_splitLights;
						splitLights = (_options_splitLights = options.splitLights) != null ? _options_splitLights : _noLights;
				}
				if (clusteredLightingEnabled) {
						var _options_lightClusters;
						var lightClusters = (_options_lightClusters = options.lightClusters) != null ? _options_lightClusters : this.worldClustersAllocator.empty;
						lightClusters.activate();
						if (layer) {
								if (!this.clustersDebugRendered && scene.lighting.debugLayer === layer.id) {
										this.clustersDebugRendered = true;
								}
						}
				}
				scene._activeCamera = camera;
				var _camera_fog;
				var fogParams = (_camera_fog = camera.fog) != null ? _camera_fog : this.scene.fog;
				this.setFogConstants(fogParams);
				var viewCount = this.setCameraUniforms(camera, renderTarget);
				if (device.supportsUniformBuffers) {
						this.setupViewUniformBuffers(viewBindGroups, this.viewUniformFormat, this.viewBindGroupFormat, viewCount);
				}
				var _options_clearColor;
				var clearColor = (_options_clearColor = options.clearColor) != null ? _options_clearColor : false;
				var _options_clearDepth;
				var clearDepth = (_options_clearDepth = options.clearDepth) != null ? _options_clearDepth : false;
				var _options_clearStencil;
				var clearStencil = (_options_clearStencil = options.clearStencil) != null ? _options_clearStencil : false;
				if (clearColor || clearDepth || clearStencil) {
						this.clear(camera, clearColor, clearDepth, clearStencil);
				}
				var flipFaces = !!(camera._flipFaces ^ (renderTarget == null ? void 0 : renderTarget.flipY));
				var forwardDrawCalls = this._forwardDrawCalls;
				this.renderForward(camera, renderTarget, visible, splitLights, shaderPass, null, layer, flipFaces);
				if (layer) {
						layer._forwardDrawCalls += this._forwardDrawCalls - forwardDrawCalls;
				}
		}
		setFogConstants(fogParams) {
				if (fogParams.type !== FOG_NONE) {
						tmpColor$1.linear(fogParams.color);
						var fogUniform = this.fogColor;
						fogUniform[0] = tmpColor$1.r;
						fogUniform[1] = tmpColor$1.g;
						fogUniform[2] = tmpColor$1.b;
						this.fogColorId.setValue(fogUniform);
						if (fogParams.type === FOG_LINEAR) {
								this.fogStartId.setValue(fogParams.start);
								this.fogEndId.setValue(fogParams.end);
						} else {
								this.fogDensityId.setValue(fogParams.density);
						}
				}
		}
		setSceneConstants() {
				var scene = this.scene;
				this.dispatchGlobalLights(scene);
				var device = this.device;
				this._screenSize[0] = device.width;
				this._screenSize[1] = device.height;
				this._screenSize[2] = 1 / device.width;
				this._screenSize[3] = 1 / device.height;
				this.screenSizeId.setValue(this._screenSize);
				this.pcssDiskSamplesId.setValue(this.pcssDiskSamples);
				this.pcssSphereSamplesId.setValue(this.pcssSphereSamples);
		}
		buildFrameGraph(frameGraph, layerComposition) {
				var scene = this.scene;
				frameGraph.reset();
				if (scene.clusteredLightingEnabled) {
						var { shadowsEnabled, cookiesEnabled } = scene.lighting;
						this._renderPassUpdateClustered.update(frameGraph, shadowsEnabled, cookiesEnabled, this.lights, this.localLights);
						frameGraph.addRenderPass(this._renderPassUpdateClustered);
				} else {
						this._shadowRendererLocal.buildNonClusteredRenderPasses(frameGraph, this.localLights);
				}
				var startIndex = 0;
				var newStart = true;
				var renderTarget = null;
				var renderActions = layerComposition._renderActions;
				for(var i = startIndex; i < renderActions.length; i++){
						var renderAction = renderActions[i];
						var { layer, camera } = renderAction;
						if (renderAction.useCameraPasses) {
								camera.camera.renderPasses.forEach((renderPass)=>{
										frameGraph.addRenderPass(renderPass);
								});
						} else {
								var isDepthLayer = layer.id === LAYERID_DEPTH;
								var isGrabPass = isDepthLayer && (camera.renderSceneColorMap || camera.renderSceneDepthMap);
								if (newStart) {
										newStart = false;
										startIndex = i;
										renderTarget = renderAction.renderTarget;
								}
								var nextRenderAction = renderActions[i + 1];
								var isNextLayerDepth = nextRenderAction ? !nextRenderAction.useCameraPasses && nextRenderAction.layer.id === LAYERID_DEPTH : false;
								var isNextLayerGrabPass = isNextLayerDepth && (camera.renderSceneColorMap || camera.renderSceneDepthMap);
								var nextNeedDirShadows = nextRenderAction ? nextRenderAction.firstCameraUse && this.cameraDirShadowLights.has(nextRenderAction.camera.camera) : false;
								if (!nextRenderAction || nextRenderAction.renderTarget !== renderTarget || nextNeedDirShadows || isNextLayerGrabPass || isGrabPass) {
										var isDepthOnly = isDepthLayer && startIndex === i;
										if (!isDepthOnly) {
												this.addMainRenderPass(frameGraph, layerComposition, renderTarget, startIndex, i);
										}
										if (isDepthLayer) {
												if (camera.renderSceneColorMap) {
														var colorGrabPass = camera.camera.renderPassColorGrab;
														colorGrabPass.source = camera.renderTarget;
														frameGraph.addRenderPass(colorGrabPass);
												}
												if (camera.renderSceneDepthMap) {
														frameGraph.addRenderPass(camera.camera.renderPassDepthGrab);
												}
										}
										if (renderAction.triggerPostprocess && (camera == null ? void 0 : camera.onPostprocessing)) {
												var renderPass = new RenderPassPostprocessing(this.device, this, renderAction);
												frameGraph.addRenderPass(renderPass);
										}
										newStart = true;
								}
						}
				}
		}
		addMainRenderPass(frameGraph, layerComposition, renderTarget, startIndex, endIndex) {
				var renderPass = new RenderPassForward(this.device, layerComposition, this.scene, this);
				renderPass.init(renderTarget);
				var renderActions = layerComposition._renderActions;
				for(var i = startIndex; i <= endIndex; i++){
						renderPass.addRenderAction(renderActions[i]);
				}
				frameGraph.addRenderPass(renderPass);
		}
		update(comp) {
				this.frameUpdate();
				this.shadowRenderer.frameUpdate();
				this.scene._updateSkyMesh();
				this.updateLayerComposition(comp);
				this.collectLights(comp);
				this.beginFrame(comp);
				this.setSceneConstants();
				this.cullComposition(comp);
				this.gpuUpdate(this.processingMeshInstances);
		}
		constructor(graphicsDevice){
				super(graphicsDevice);
				var device = this.device;
				this._forwardDrawCalls = 0;
				this._materialSwitches = 0;
				this._depthMapTime = 0;
				this._forwardTime = 0;
				this._sortTime = 0;
				var scope = device.scope;
				this.fogColorId = scope.resolve('fog_color');
				this.fogStartId = scope.resolve('fog_start');
				this.fogEndId = scope.resolve('fog_end');
				this.fogDensityId = scope.resolve('fog_density');
				this.ambientId = scope.resolve('light_globalAmbient');
				this.skyboxIntensityId = scope.resolve('skyboxIntensity');
				this.cubeMapRotationMatrixId = scope.resolve('cubeMapRotationMatrix');
				this.pcssDiskSamplesId = scope.resolve('pcssDiskSamples[0]');
				this.pcssSphereSamplesId = scope.resolve('pcssSphereSamples[0]');
				this.lightColorId = [];
				this.lightDir = [];
				this.lightDirId = [];
				this.lightShadowMapId = [];
				this.lightShadowMatrixId = [];
				this.lightShadowParamsId = [];
				this.lightShadowIntensity = [];
				this.lightRadiusId = [];
				this.lightPos = [];
				this.lightPosId = [];
				this.lightWidth = [];
				this.lightWidthId = [];
				this.lightHeight = [];
				this.lightHeightId = [];
				this.lightInAngleId = [];
				this.lightOutAngleId = [];
				this.lightCookieId = [];
				this.lightCookieIntId = [];
				this.lightCookieMatrixId = [];
				this.lightCookieOffsetId = [];
				this.lightShadowSearchAreaId = [];
				this.lightCameraParamsId = [];
				this.lightSoftShadowParamsId = [];
				this.shadowMatrixPaletteId = [];
				this.shadowCascadeDistancesId = [];
				this.shadowCascadeCountId = [];
				this.shadowCascadeBlendId = [];
				this.screenSizeId = scope.resolve('uScreenSize');
				this._screenSize = new Float32Array(4);
				this.fogColor = new Float32Array(3);
				this.ambientColor = new Float32Array(3);
				this.pcssDiskSamples = vogelDiskPrecalculationSamples(16);
				this.pcssSphereSamples = vogelSpherePrecalculationSamples(16);
		}
}

var layerCounter = 0;
var lightKeys = [];
var _tempMaterials = new Set();
function sortManual(drawCallA, drawCallB) {
		return drawCallA.drawOrder - drawCallB.drawOrder;
}
function sortMaterialMesh(drawCallA, drawCallB) {
		var keyA = drawCallA._sortKeyForward;
		var keyB = drawCallB._sortKeyForward;
		if (keyA === keyB) {
				return drawCallB.mesh.id - drawCallA.mesh.id;
		}
		return keyB - keyA;
}
function sortBackToFront(drawCallA, drawCallB) {
		return drawCallB._sortKeyDynamic - drawCallA._sortKeyDynamic;
}
function sortFrontToBack(drawCallA, drawCallB) {
		return drawCallA._sortKeyDynamic - drawCallB._sortKeyDynamic;
}
var sortCallbacks = [
		null,
		sortManual,
		sortMaterialMesh,
		sortBackToFront,
		sortFrontToBack
];
class CulledInstances {
		constructor(){
				this.opaque = [];
				this.transparent = [];
		}
}
class Layer {
		set enabled(val) {
				if (val !== this._enabled) {
						this._dirtyComposition = true;
						this._enabled = val;
						if (val) {
								this.incrementCounter();
								if (this.onEnable) this.onEnable();
						} else {
								this.decrementCounter();
								if (this.onDisable) this.onDisable();
						}
				}
		}
		get enabled() {
				return this._enabled;
		}
		set clearColorBuffer(val) {
				this._clearColorBuffer = val;
				this._dirtyComposition = true;
		}
		get clearColorBuffer() {
				return this._clearColorBuffer;
		}
		set clearDepthBuffer(val) {
				this._clearDepthBuffer = val;
				this._dirtyComposition = true;
		}
		get clearDepthBuffer() {
				return this._clearDepthBuffer;
		}
		set clearStencilBuffer(val) {
				this._clearStencilBuffer = val;
				this._dirtyComposition = true;
		}
		get clearStencilBuffer() {
				return this._clearStencilBuffer;
		}
		get hasClusteredLights() {
				return this._clusteredLightsSet.size > 0;
		}
		get clusteredLightsSet() {
				return this._clusteredLightsSet;
		}
		incrementCounter() {
				if (this._refCounter === 0) {
						this._enabled = true;
						if (this.onEnable) this.onEnable();
				}
				this._refCounter++;
		}
		decrementCounter() {
				if (this._refCounter === 1) {
						this._enabled = false;
						if (this.onDisable) this.onDisable();
				} else if (this._refCounter === 0) {
						return;
				}
				this._refCounter--;
		}
		addMeshInstances(meshInstances, skipShadowCasters) {
				var destMeshInstances = this.meshInstances;
				var destMeshInstancesSet = this.meshInstancesSet;
				for(var i = 0; i < meshInstances.length; i++){
						var mi = meshInstances[i];
						if (!destMeshInstancesSet.has(mi)) {
								destMeshInstances.push(mi);
								destMeshInstancesSet.add(mi);
								_tempMaterials.add(mi.material);
						}
				}
				if (!skipShadowCasters) {
						this.addShadowCasters(meshInstances);
				}
				if (_tempMaterials.size > 0) {
						var sceneShaderVer = this._shaderVersion;
						_tempMaterials.forEach((mat)=>{
								if (sceneShaderVer >= 0 && mat._shaderVersion !== sceneShaderVer) {
										if (mat.getShaderVariant !== Material.prototype.getShaderVariant) {
												mat.clearVariants();
										}
										mat._shaderVersion = sceneShaderVer;
								}
						});
						_tempMaterials.clear();
				}
		}
		removeMeshInstances(meshInstances, skipShadowCasters) {
				var destMeshInstances = this.meshInstances;
				var destMeshInstancesSet = this.meshInstancesSet;
				for(var i = 0; i < meshInstances.length; i++){
						var mi = meshInstances[i];
						if (destMeshInstancesSet.has(mi)) {
								destMeshInstancesSet.delete(mi);
								var j = destMeshInstances.indexOf(mi);
								if (j >= 0) {
										destMeshInstances.splice(j, 1);
								}
						}
				}
				if (!skipShadowCasters) {
						this.removeShadowCasters(meshInstances);
				}
		}
		addShadowCasters(meshInstances) {
				var shadowCasters = this.shadowCasters;
				var shadowCastersSet = this.shadowCastersSet;
				for(var i = 0; i < meshInstances.length; i++){
						var mi = meshInstances[i];
						if (mi.castShadow && !shadowCastersSet.has(mi)) {
								shadowCastersSet.add(mi);
								shadowCasters.push(mi);
						}
				}
		}
		removeShadowCasters(meshInstances) {
				var shadowCasters = this.shadowCasters;
				var shadowCastersSet = this.shadowCastersSet;
				for(var i = 0; i < meshInstances.length; i++){
						var mi = meshInstances[i];
						if (shadowCastersSet.has(mi)) {
								shadowCastersSet.delete(mi);
								var j = shadowCasters.indexOf(mi);
								if (j >= 0) {
										shadowCasters.splice(j, 1);
								}
						}
				}
		}
		clearMeshInstances(skipShadowCasters) {
				if (skipShadowCasters === void 0) skipShadowCasters = false;
				this.meshInstances.length = 0;
				this.meshInstancesSet.clear();
				if (!skipShadowCasters) {
						this.shadowCasters.length = 0;
						this.shadowCastersSet.clear();
				}
		}
		markLightsDirty() {
				this._lightHashDirty = true;
				this._lightIdHashDirty = true;
				this._splitLightsDirty = true;
		}
		hasLight(light) {
				return this._lightsSet.has(light);
		}
		addLight(light) {
				var l = light.light;
				if (!this._lightsSet.has(l)) {
						this._lightsSet.add(l);
						this._lights.push(l);
						this.markLightsDirty();
				}
				if (l.type !== LIGHTTYPE_DIRECTIONAL) {
						this._clusteredLightsSet.add(l);
				}
		}
		removeLight(light) {
				var l = light.light;
				if (this._lightsSet.has(l)) {
						this._lightsSet.delete(l);
						this._lights.splice(this._lights.indexOf(l), 1);
						this.markLightsDirty();
				}
				if (l.type !== LIGHTTYPE_DIRECTIONAL) {
						this._clusteredLightsSet.delete(l);
				}
		}
		clearLights() {
				this._lightsSet.forEach((light)=>light.removeLayer(this));
				this._lightsSet.clear();
				this._clusteredLightsSet.clear();
				this._lights.length = 0;
				this.markLightsDirty();
		}
		get splitLights() {
				if (this._splitLightsDirty) {
						this._splitLightsDirty = false;
						var splitLights = this._splitLights;
						for(var i = 0; i < splitLights.length; i++){
								splitLights[i].length = 0;
						}
						var lights = this._lights;
						for(var i1 = 0; i1 < lights.length; i1++){
								var light = lights[i1];
								if (light.enabled) {
										splitLights[light._type].push(light);
								}
						}
						for(var i2 = 0; i2 < splitLights.length; i2++){
								splitLights[i2].sort((a, b)=>a.key - b.key);
						}
				}
				return this._splitLights;
		}
		evaluateLightHash(localLights, directionalLights, useIds) {
				var hash = 0;
				var lights = this._lights;
				for(var i = 0; i < lights.length; i++){
						var isLocalLight = lights[i].type !== LIGHTTYPE_DIRECTIONAL;
						if (localLights && isLocalLight || directionalLights && !isLocalLight) {
								lightKeys.push(useIds ? lights[i].id : lights[i].key);
						}
				}
				if (lightKeys.length > 0) {
						lightKeys.sort();
						hash = hash32Fnv1a(lightKeys);
						lightKeys.length = 0;
				}
				return hash;
		}
		getLightHash(isClustered) {
				if (this._lightHashDirty) {
						this._lightHashDirty = false;
						this._lightHash = this.evaluateLightHash(!isClustered, true, false);
				}
				return this._lightHash;
		}
		getLightIdHash() {
				if (this._lightIdHashDirty) {
						this._lightIdHashDirty = false;
						this._lightIdHash = this.evaluateLightHash(true, false, true);
				}
				return this._lightIdHash;
		}
		addCamera(camera) {
				if (!this.camerasSet.has(camera.camera)) {
						this.camerasSet.add(camera.camera);
						this.cameras.push(camera);
						this._dirtyComposition = true;
				}
		}
		removeCamera(camera) {
				if (this.camerasSet.has(camera.camera)) {
						this.camerasSet.delete(camera.camera);
						var index = this.cameras.indexOf(camera);
						this.cameras.splice(index, 1);
						this._dirtyComposition = true;
				}
		}
		clearCameras() {
				this.cameras.length = 0;
				this.camerasSet.clear();
				this._dirtyComposition = true;
		}
		_calculateSortDistances(drawCalls, camPos, camFwd) {
				var count = drawCalls.length;
				var { x: px, y: py, z: pz } = camPos;
				var { x: fx, y: fy, z: fz } = camFwd;
				for(var i = 0; i < count; i++){
						var drawCall = drawCalls[i];
						var zDist = void 0;
						if (drawCall.calculateSortDistance) {
								zDist = drawCall.calculateSortDistance(drawCall, camPos, camFwd);
						} else {
								var meshPos = drawCall.aabb.center;
								zDist = (meshPos.x - px) * fx + (meshPos.y - py) * fy + (meshPos.z - pz) * fz;
						}
						var bucket = drawCall._drawBucket * 1e9;
						drawCall._sortKeyDynamic = bucket + zDist;
				}
		}
		getCulledInstances(camera) {
				var instances = this._visibleInstances.get(camera);
				if (!instances) {
						instances = new CulledInstances();
						this._visibleInstances.set(camera, instances);
				}
				return instances;
		}
		sortVisible(camera, transparent) {
				var sortMode = transparent ? this.transparentSortMode : this.opaqueSortMode;
				if (sortMode === SORTMODE_NONE) {
						return;
				}
				var culledInstances = this.getCulledInstances(camera);
				var instances = transparent ? culledInstances.transparent : culledInstances.opaque;
				var cameraNode = camera.node;
				if (sortMode === SORTMODE_CUSTOM) {
						var sortPos = cameraNode.getPosition();
						var sortDir = cameraNode.forward;
						if (this.customCalculateSortValues) {
								this.customCalculateSortValues(instances, instances.length, sortPos, sortDir);
						}
						if (this.customSortCallback) {
								instances.sort(this.customSortCallback);
						}
				} else {
						if (sortMode === SORTMODE_BACK2FRONT || sortMode === SORTMODE_FRONT2BACK) {
								var sortPos1 = cameraNode.getPosition();
								var sortDir1 = cameraNode.forward;
								this._calculateSortDistances(instances, sortPos1, sortDir1);
						}
						instances.sort(sortCallbacks[sortMode]);
				}
		}
		constructor(options = {}){
				this.meshInstances = [];
				this.meshInstancesSet = new Set();
				this.shadowCasters = [];
				this.shadowCastersSet = new Set();
				this._visibleInstances = new WeakMap();
				this._lights = [];
				this._lightsSet = new Set();
				this._clusteredLightsSet = new Set();
				this._splitLights = [
						[],
						[],
						[]
				];
				this._splitLightsDirty = true;
				this.requiresLightCube = false;
				this.cameras = [];
				this.camerasSet = new Set();
				this._dirtyComposition = false;
				if (options.id !== undefined) {
						this.id = options.id;
						layerCounter = Math.max(this.id + 1, layerCounter);
				} else {
						this.id = layerCounter++;
				}
				this.name = options.name;
				var _options_enabled;
				this._enabled = (_options_enabled = options.enabled) != null ? _options_enabled : true;
				this._refCounter = this._enabled ? 1 : 0;
				var _options_opaqueSortMode;
				this.opaqueSortMode = (_options_opaqueSortMode = options.opaqueSortMode) != null ? _options_opaqueSortMode : SORTMODE_MATERIALMESH;
				var _options_transparentSortMode;
				this.transparentSortMode = (_options_transparentSortMode = options.transparentSortMode) != null ? _options_transparentSortMode : SORTMODE_BACK2FRONT;
				if (options.renderTarget) {
						this.renderTarget = options.renderTarget;
				}
				this._clearColorBuffer = !!options.clearColorBuffer;
				this._clearDepthBuffer = !!options.clearDepthBuffer;
				this._clearStencilBuffer = !!options.clearStencilBuffer;
				this.onEnable = options.onEnable;
				this.onDisable = options.onDisable;
				if (this._enabled && this.onEnable) {
						this.onEnable();
				}
				this.customSortCallback = null;
				this.customCalculateSortValues = null;
				this._lightHash = 0;
				this._lightHashDirty = false;
				this._lightIdHash = 0;
				this._lightIdHashDirty = false;
				this._shaderVersion = -1;
		}
}

var cmpPriority = (a, b)=>a.priority - b.priority;
var sortPriority = (arr)=>arr.sort(cmpPriority);

class LayerComposition extends EventHandler {
		destroy() {
				this.destroyRenderActions();
		}
		destroyRenderActions() {
				this._renderActions.forEach((ra)=>ra.destroy());
				this._renderActions.length = 0;
		}
		_update() {
				var len = this.layerList.length;
				if (!this._dirty) {
						for(var i = 0; i < len; i++){
								if (this.layerList[i]._dirtyComposition) {
										this._dirty = true;
										break;
								}
						}
				}
				if (this._dirty) {
						this._dirty = false;
						this.cameras.length = 0;
						for(var i1 = 0; i1 < len; i1++){
								var layer = this.layerList[i1];
								layer._dirtyComposition = false;
								for(var j = 0; j < layer.cameras.length; j++){
										var camera = layer.cameras[j];
										var index = this.cameras.indexOf(camera);
										if (index < 0) {
												this.cameras.push(camera);
										}
								}
						}
						if (this.cameras.length > 1) {
								sortPriority(this.cameras);
						}
						var cameraLayers = [];
						var renderActionCount = 0;
						this.destroyRenderActions();
						for(var i2 = 0; i2 < this.cameras.length; i2++){
								var camera1 = this.cameras[i2];
								cameraLayers.length = 0;
								if (camera1.camera.renderPasses.length > 0) {
										this.addDummyRenderAction(renderActionCount, camera1);
										renderActionCount++;
										continue;
								}
								var cameraFirstRenderAction = true;
								var cameraFirstRenderActionIndex = renderActionCount;
								var lastRenderAction = null;
								var postProcessMarked = false;
								for(var j1 = 0; j1 < len; j1++){
										var layer1 = this.layerList[j1];
										var isLayerEnabled = layer1.enabled && this.subLayerEnabled[j1];
										if (isLayerEnabled) {
												if (layer1.cameras.length > 0) {
														if (camera1.layers.indexOf(layer1.id) >= 0) {
																cameraLayers.push(layer1);
																if (!postProcessMarked && layer1.id === camera1.disablePostEffectsLayer) {
																		postProcessMarked = true;
																		if (lastRenderAction) {
																				lastRenderAction.triggerPostprocess = true;
																		}
																}
																var isTransparent = this.subLayerList[j1];
																lastRenderAction = this.addRenderAction(renderActionCount, layer1, isTransparent, camera1, cameraFirstRenderAction, postProcessMarked);
																renderActionCount++;
																cameraFirstRenderAction = false;
														}
												}
										}
								}
								if (cameraFirstRenderActionIndex < renderActionCount) {
										lastRenderAction.lastCameraUse = true;
								}
								if (!postProcessMarked && lastRenderAction) {
										lastRenderAction.triggerPostprocess = true;
								}
								if (camera1.renderTarget && camera1.postEffectsEnabled) {
										this.propagateRenderTarget(cameraFirstRenderActionIndex - 1, camera1);
								}
						}
						this._logRenderActions();
				}
		}
		getNextRenderAction(renderActionIndex) {
				var renderAction = new RenderAction();
				this._renderActions.push(renderAction);
				return renderAction;
		}
		addDummyRenderAction(renderActionIndex, camera) {
				var renderAction = this.getNextRenderAction(renderActionIndex);
				renderAction.camera = camera;
				renderAction.useCameraPasses = true;
		}
		addRenderAction(renderActionIndex, layer, isTransparent, camera, cameraFirstRenderAction, postProcessMarked) {
				var rt = layer.id !== LAYERID_DEPTH ? camera.renderTarget : null;
				var used = false;
				var renderActions = this._renderActions;
				for(var i = renderActionIndex - 1; i >= 0; i--){
						if (renderActions[i].camera === camera && renderActions[i].renderTarget === rt) {
								used = true;
								break;
						}
				}
				if (postProcessMarked && camera.postEffectsEnabled) {
						rt = null;
				}
				var renderAction = this.getNextRenderAction(renderActionIndex);
				renderAction.triggerPostprocess = false;
				renderAction.layer = layer;
				renderAction.transparent = isTransparent;
				renderAction.camera = camera;
				renderAction.renderTarget = rt;
				renderAction.firstCameraUse = cameraFirstRenderAction;
				renderAction.lastCameraUse = false;
				var needsCameraClear = cameraFirstRenderAction || !used;
				var needsLayerClear = layer.clearColorBuffer || layer.clearDepthBuffer || layer.clearStencilBuffer;
				if (needsCameraClear || needsLayerClear) {
						renderAction.setupClears(needsCameraClear ? camera : undefined, layer);
				}
				return renderAction;
		}
		propagateRenderTarget(startIndex, fromCamera) {
				for(var a = startIndex; a >= 0; a--){
						var ra = this._renderActions[a];
						var layer = ra.layer;
						if (ra.renderTarget && layer.id !== LAYERID_DEPTH) {
								break;
						}
						if (layer.id === LAYERID_DEPTH) {
								continue;
						}
						if (ra.useCameraPasses) {
								break;
						}
						var thisCamera = ra == null ? void 0 : ra.camera.camera;
						if (thisCamera) {
								if (!fromCamera.camera.rect.equals(thisCamera.rect) || !fromCamera.camera.scissorRect.equals(thisCamera.scissorRect)) {
										break;
								}
						}
						ra.renderTarget = fromCamera.renderTarget;
				}
		}
		_logRenderActions() {}
		_isLayerAdded(layer) {
				var found = this.layerIdMap.get(layer.id) === layer;
				return found;
		}
		_isSublayerAdded(layer, transparent) {
				var map = transparent ? this.layerTransparentIndexMap : this.layerOpaqueIndexMap;
				if (map.get(layer) !== undefined) {
						return true;
				}
				return false;
		}
		push(layer) {
				if (this._isLayerAdded(layer)) return;
				this.layerList.push(layer);
				this.layerList.push(layer);
				this._opaqueOrder[layer.id] = this.subLayerList.push(false) - 1;
				this._transparentOrder[layer.id] = this.subLayerList.push(true) - 1;
				this.subLayerEnabled.push(true);
				this.subLayerEnabled.push(true);
				this._updateLayerMaps();
				this._dirty = true;
				this.fire('add', layer);
		}
		insert(layer, index) {
				if (this._isLayerAdded(layer)) return;
				this.layerList.splice(index, 0, layer, layer);
				this.subLayerList.splice(index, 0, false, true);
				var count = this.layerList.length;
				this._updateOpaqueOrder(index, count - 1);
				this._updateTransparentOrder(index, count - 1);
				this.subLayerEnabled.splice(index, 0, true, true);
				this._updateLayerMaps();
				this._dirty = true;
				this.fire('add', layer);
		}
		remove(layer) {
				var id = this.layerList.indexOf(layer);
				delete this._opaqueOrder[id];
				delete this._transparentOrder[id];
				while(id >= 0){
						this.layerList.splice(id, 1);
						this.subLayerList.splice(id, 1);
						this.subLayerEnabled.splice(id, 1);
						id = this.layerList.indexOf(layer);
						this._dirty = true;
						this.fire('remove', layer);
				}
				var count = this.layerList.length;
				this._updateOpaqueOrder(0, count - 1);
				this._updateTransparentOrder(0, count - 1);
				this._updateLayerMaps();
		}
		pushOpaque(layer) {
				if (this._isSublayerAdded(layer, false)) return;
				this.layerList.push(layer);
				this._opaqueOrder[layer.id] = this.subLayerList.push(false) - 1;
				this.subLayerEnabled.push(true);
				this._updateLayerMaps();
				this._dirty = true;
				this.fire('add', layer);
		}
		insertOpaque(layer, index) {
				if (this._isSublayerAdded(layer, false)) return;
				this.layerList.splice(index, 0, layer);
				this.subLayerList.splice(index, 0, false);
				var count = this.subLayerList.length;
				this._updateOpaqueOrder(index, count - 1);
				this.subLayerEnabled.splice(index, 0, true);
				this._updateLayerMaps();
				this._dirty = true;
				this.fire('add', layer);
		}
		removeOpaque(layer) {
				for(var i = 0, len = this.layerList.length; i < len; i++){
						if (this.layerList[i] === layer && !this.subLayerList[i]) {
								this.layerList.splice(i, 1);
								this.subLayerList.splice(i, 1);
								len--;
								this._updateOpaqueOrder(i, len - 1);
								this.subLayerEnabled.splice(i, 1);
								this._dirty = true;
								if (this.layerList.indexOf(layer) < 0) {
										this.fire('remove', layer);
								}
								break;
						}
				}
				this._updateLayerMaps();
		}
		pushTransparent(layer) {
				if (this._isSublayerAdded(layer, true)) return;
				this.layerList.push(layer);
				this._transparentOrder[layer.id] = this.subLayerList.push(true) - 1;
				this.subLayerEnabled.push(true);
				this._updateLayerMaps();
				this._dirty = true;
				this.fire('add', layer);
		}
		insertTransparent(layer, index) {
				if (this._isSublayerAdded(layer, true)) return;
				this.layerList.splice(index, 0, layer);
				this.subLayerList.splice(index, 0, true);
				var count = this.subLayerList.length;
				this._updateTransparentOrder(index, count - 1);
				this.subLayerEnabled.splice(index, 0, true);
				this._updateLayerMaps();
				this._dirty = true;
				this.fire('add', layer);
		}
		removeTransparent(layer) {
				for(var i = 0, len = this.layerList.length; i < len; i++){
						if (this.layerList[i] === layer && this.subLayerList[i]) {
								this.layerList.splice(i, 1);
								this.subLayerList.splice(i, 1);
								len--;
								this._updateTransparentOrder(i, len - 1);
								this.subLayerEnabled.splice(i, 1);
								this._dirty = true;
								if (this.layerList.indexOf(layer) < 0) {
										this.fire('remove', layer);
								}
								break;
						}
				}
				this._updateLayerMaps();
		}
		getOpaqueIndex(layer) {
				var _this_layerOpaqueIndexMap_get;
				return (_this_layerOpaqueIndexMap_get = this.layerOpaqueIndexMap.get(layer)) != null ? _this_layerOpaqueIndexMap_get : -1;
		}
		getTransparentIndex(layer) {
				var _this_layerTransparentIndexMap_get;
				return (_this_layerTransparentIndexMap_get = this.layerTransparentIndexMap.get(layer)) != null ? _this_layerTransparentIndexMap_get : -1;
		}
		isEnabled(layer, transparent) {
				if (layer.enabled) {
						var index = transparent ? this.getTransparentIndex(layer) : this.getOpaqueIndex(layer);
						if (index >= 0) {
								return this.subLayerEnabled[index];
						}
				}
				return false;
		}
		_updateLayerMaps() {
				this.layerIdMap.clear();
				this.layerNameMap.clear();
				this.layerOpaqueIndexMap.clear();
				this.layerTransparentIndexMap.clear();
				for(var i = 0; i < this.layerList.length; i++){
						var layer = this.layerList[i];
						this.layerIdMap.set(layer.id, layer);
						this.layerNameMap.set(layer.name, layer);
						var subLayerIndexMap = this.subLayerList[i] ? this.layerTransparentIndexMap : this.layerOpaqueIndexMap;
						subLayerIndexMap.set(layer, i);
				}
		}
		getLayerById(id) {
				var _this_layerIdMap_get;
				return (_this_layerIdMap_get = this.layerIdMap.get(id)) != null ? _this_layerIdMap_get : null;
		}
		getLayerByName(name) {
				var _this_layerNameMap_get;
				return (_this_layerNameMap_get = this.layerNameMap.get(name)) != null ? _this_layerNameMap_get : null;
		}
		_updateOpaqueOrder(startIndex, endIndex) {
				for(var i = startIndex; i <= endIndex; i++){
						if (this.subLayerList[i] === false) {
								this._opaqueOrder[this.layerList[i].id] = i;
						}
				}
		}
		_updateTransparentOrder(startIndex, endIndex) {
				for(var i = startIndex; i <= endIndex; i++){
						if (this.subLayerList[i] === true) {
								this._transparentOrder[this.layerList[i].id] = i;
						}
				}
		}
		_sortLayersDescending(layersA, layersB, order) {
				var topLayerA = -1;
				var topLayerB = -1;
				for(var i = 0, len = layersA.length; i < len; i++){
						var id = layersA[i];
						if (order.hasOwnProperty(id)) {
								topLayerA = Math.max(topLayerA, order[id]);
						}
				}
				for(var i1 = 0, len1 = layersB.length; i1 < len1; i1++){
						var id1 = layersB[i1];
						if (order.hasOwnProperty(id1)) {
								topLayerB = Math.max(topLayerB, order[id1]);
						}
				}
				if (topLayerA === -1 && topLayerB !== -1) {
						return 1;
				} else if (topLayerB === -1 && topLayerA !== -1) {
						return -1;
				}
				return topLayerB - topLayerA;
		}
		sortTransparentLayers(layersA, layersB) {
				return this._sortLayersDescending(layersA, layersB, this._transparentOrder);
		}
		sortOpaqueLayers(layersA, layersB) {
				return this._sortLayersDescending(layersA, layersB, this._opaqueOrder);
		}
		constructor(name = 'Untitled'){
				super(), this.layerList = [], this.layerIdMap = new Map(), this.layerNameMap = new Map(), this.layerOpaqueIndexMap = new Map(), this.layerTransparentIndexMap = new Map(), this.subLayerList = [], this.subLayerEnabled = [], this.cameras = [], this._renderActions = [], this._dirty = false;
				this.name = name;
				this._opaqueOrder = {};
				this._transparentOrder = {};
		}
}

var tmpVec = new Vec3();
var tmpBiases = {
		bias: 0,
		normalBias: 0
};
var tmpColor = new Color();
var chanId = {
		r: 0,
		g: 1,
		b: 2,
		a: 3
};
var lightTypes = {
		'directional': LIGHTTYPE_DIRECTIONAL,
		'omni': LIGHTTYPE_OMNI,
		'point': LIGHTTYPE_OMNI,
		'spot': LIGHTTYPE_SPOT
};
var directionalCascades = [
		[
				new Vec4(0, 0, 1, 1)
		],
		[
				new Vec4(0, 0, 0.5, 0.5),
				new Vec4(0, 0.5, 0.5, 0.5)
		],
		[
				new Vec4(0, 0, 0.5, 0.5),
				new Vec4(0, 0.5, 0.5, 0.5),
				new Vec4(0.5, 0, 0.5, 0.5)
		],
		[
				new Vec4(0, 0, 0.5, 0.5),
				new Vec4(0, 0.5, 0.5, 0.5),
				new Vec4(0.5, 0, 0.5, 0.5),
				new Vec4(0.5, 0.5, 0.5, 0.5)
		]
];
var id = 0;
class LightRenderData {
		destroy() {
				this.viewBindGroups.forEach((bg)=>{
						bg.defaultUniformBuffer.destroy();
						bg.destroy();
				});
				this.viewBindGroups.length = 0;
		}
		get shadowBuffer() {
				var rt = this.shadowCamera.renderTarget;
				if (rt) {
						return this.light._isPcf ? rt.depthBuffer : rt.colorBuffer;
				}
				return null;
		}
		constructor(camera, face, light){
				this.light = light;
				this.camera = camera;
				this.shadowCamera = ShadowRenderer.createShadowCamera(light._shadowType, light._type, face);
				this.shadowMatrix = new Mat4();
				this.shadowViewport = new Vec4(0, 0, 1, 1);
				this.shadowScissor = new Vec4(0, 0, 1, 1);
				this.projectionCompensation = 0;
				this.face = face;
				this.visibleCasters = [];
				this.viewBindGroups = [];
		}
}
class Light {
		destroy() {
				this._destroyShadowMap();
				this.releaseRenderData();
				this._renderData = null;
		}
		releaseRenderData() {
				if (this._renderData) {
						for(var i = 0; i < this._renderData.length; i++){
								this._renderData[i].destroy();
						}
						this._renderData.length = 0;
				}
		}
		addLayer(layer) {
				this.layers.add(layer);
		}
		removeLayer(layer) {
				this.layers.delete(layer);
		}
		set shadowSamples(value) {
				this._softShadowParams[0] = value;
		}
		get shadowSamples() {
				return this._softShadowParams[0];
		}
		set shadowBlockerSamples(value) {
				this._softShadowParams[1] = value;
		}
		get shadowBlockerSamples() {
				return this._softShadowParams[1];
		}
		set shadowBias(value) {
				if (this._shadowBias !== value) {
						this._shadowBias = value;
						this._updateShadowBias();
				}
		}
		get shadowBias() {
				return this._shadowBias;
		}
		set numCascades(value) {
				if (!this.cascades || this.numCascades !== value) {
						this.cascades = directionalCascades[value - 1];
						this._shadowMatrixPalette = new Float32Array(4 * 16);
						this._shadowCascadeDistances = new Float32Array(4);
						this._destroyShadowMap();
						this.updateKey();
				}
		}
		get numCascades() {
				return this.cascades.length;
		}
		set cascadeBlend(value) {
				if (this._cascadeBlend !== value) {
						this._cascadeBlend = value;
						this.updateKey();
				}
		}
		get cascadeBlend() {
				return this._cascadeBlend;
		}
		set shadowMap(shadowMap) {
				if (this._shadowMap !== shadowMap) {
						this._destroyShadowMap();
						this._shadowMap = shadowMap;
				}
		}
		get shadowMap() {
				return this._shadowMap;
		}
		set mask(value) {
				if (this._mask !== value) {
						this._mask = value;
						this.updateKey();
				}
		}
		get mask() {
				return this._mask;
		}
		get numShadowFaces() {
				var type = this._type;
				if (type === LIGHTTYPE_DIRECTIONAL) {
						return this.numCascades;
				} else if (type === LIGHTTYPE_OMNI) {
						return 6;
				}
				return 1;
		}
		set type(value) {
				if (this._type === value) {
						return;
				}
				this._type = value;
				this._destroyShadowMap();
				this._updateShadowBias();
				this.updateKey();
				var stype = this._shadowType;
				this._shadowType = null;
				this.shadowUpdateOverrides = null;
				this.shadowType = stype;
		}
		get type() {
				return this._type;
		}
		set shape(value) {
				if (this._shape === value) {
						return;
				}
				this._shape = value;
				this._destroyShadowMap();
				this.updateKey();
				var stype = this._shadowType;
				this._shadowType = null;
				this.shadowType = stype;
		}
		get shape() {
				return this._shape;
		}
		set usePhysicalUnits(value) {
				if (this._usePhysicalUnits !== value) {
						this._usePhysicalUnits = value;
						this._updateLinearColor();
				}
		}
		get usePhysicalUnits() {
				return this._usePhysicalUnits;
		}
		set shadowType(value) {
				if (this._shadowType === value) {
						return;
				}
				var shadowInfo = shadowTypeInfo.get(value);
				if (!shadowInfo) {
						value = SHADOW_PCF3_32F;
				}
				var device = this.device;
				if (value === SHADOW_PCSS_32F && !device.textureFloatRenderable && !device.textureHalfFloatRenderable) {
						value = SHADOW_PCF3_32F;
				}
				if (this._type === LIGHTTYPE_OMNI && value !== SHADOW_PCF1_32F && value !== SHADOW_PCF3_32F && value !== SHADOW_PCF1_16F && value !== SHADOW_PCF3_16F && value !== SHADOW_PCSS_32F) {
						value = SHADOW_PCF3_32F;
				}
				if (value === SHADOW_VSM_32F && (!device.textureFloatRenderable || !device.textureFloatFilterable)) {
						value = SHADOW_VSM_16F;
				}
				if (value === SHADOW_VSM_16F && !device.textureHalfFloatRenderable) {
						value = SHADOW_PCF3_32F;
				}
				shadowInfo = shadowTypeInfo.get(value);
				var _shadowInfo_vsm;
				this._isVsm = (_shadowInfo_vsm = shadowInfo == null ? void 0 : shadowInfo.vsm) != null ? _shadowInfo_vsm : false;
				var _shadowInfo_pcf;
				this._isPcf = (_shadowInfo_pcf = shadowInfo == null ? void 0 : shadowInfo.pcf) != null ? _shadowInfo_pcf : false;
				this._shadowType = value;
				this._destroyShadowMap();
				this.updateKey();
		}
		get shadowType() {
				return this._shadowType;
		}
		set enabled(value) {
				if (this._enabled !== value) {
						this._enabled = value;
						this.layersDirty();
				}
		}
		get enabled() {
				return this._enabled;
		}
		set castShadows(value) {
				if (this._castShadows !== value) {
						this._castShadows = value;
						this._destroyShadowMap();
						this.layersDirty();
						this.updateKey();
				}
		}
		get castShadows() {
				return this._castShadows && this._mask !== MASK_BAKE && this._mask !== 0;
		}
		get bakeShadows() {
				return this._castShadows && this._mask === MASK_BAKE;
		}
		set shadowResolution(value) {
				if (this._shadowResolution !== value) {
						if (this._type === LIGHTTYPE_OMNI) {
								value = Math.min(value, this.device.maxCubeMapSize);
						} else {
								value = Math.min(value, this.device.maxTextureSize);
						}
						this._shadowResolution = value;
						this._destroyShadowMap();
				}
		}
		get shadowResolution() {
				return this._shadowResolution;
		}
		set vsmBlurSize(value) {
				if (this._vsmBlurSize === value) {
						return;
				}
				if (value % 2 === 0) value++;
				this._vsmBlurSize = value;
		}
		get vsmBlurSize() {
				return this._vsmBlurSize;
		}
		set normalOffsetBias(value) {
				if (this._normalOffsetBias !== value) {
						var dirty = !this._normalOffsetBias && value || this._normalOffsetBias && !value;
						this._normalOffsetBias = value;
						if (dirty) {
								this.updateKey();
						}
				}
		}
		get normalOffsetBias() {
				return this._normalOffsetBias;
		}
		set falloffMode(value) {
				if (this._falloffMode === value) {
						return;
				}
				this._falloffMode = value;
				this.updateKey();
		}
		get falloffMode() {
				return this._falloffMode;
		}
		set innerConeAngle(value) {
				if (this._innerConeAngle === value) {
						return;
				}
				this._innerConeAngle = value;
				this._innerConeAngleCos = Math.cos(value * Math.PI / 180);
				if (this._usePhysicalUnits) {
						this._updateLinearColor();
				}
		}
		get innerConeAngle() {
				return this._innerConeAngle;
		}
		set outerConeAngle(value) {
				if (this._outerConeAngle === value) {
						return;
				}
				this._outerConeAngle = value;
				this._updateOuterAngle(value);
				if (this._usePhysicalUnits) {
						this._updateLinearColor();
				}
		}
		get outerConeAngle() {
				return this._outerConeAngle;
		}
		set penumbraSize(value) {
				this._penumbraSize = value;
				this._softShadowParams[2] = value;
		}
		get penumbraSize() {
				return this._penumbraSize;
		}
		set penumbraFalloff(value) {
				this._softShadowParams[3] = value;
		}
		get penumbraFalloff() {
				return this._softShadowParams[3];
		}
		_updateOuterAngle(angle) {
				var radAngle = angle * Math.PI / 180;
				this._outerConeAngleCos = Math.cos(radAngle);
				this._outerConeAngleSin = Math.sin(radAngle);
		}
		set intensity(value) {
				if (this._intensity !== value) {
						this._intensity = value;
						this._updateLinearColor();
				}
		}
		get intensity() {
				return this._intensity;
		}
		set affectSpecularity(value) {
				if (this._type === LIGHTTYPE_DIRECTIONAL) {
						this._affectSpecularity = value;
						this.updateKey();
				}
		}
		get affectSpecularity() {
				return this._affectSpecularity;
		}
		set luminance(value) {
				if (this._luminance !== value) {
						this._luminance = value;
						this._updateLinearColor();
				}
		}
		get luminance() {
				return this._luminance;
		}
		get cookieMatrix() {
				if (!this._cookieMatrix) {
						this._cookieMatrix = new Mat4();
				}
				return this._cookieMatrix;
		}
		get atlasViewport() {
				if (!this._atlasViewport) {
						this._atlasViewport = new Vec4(0, 0, 1, 1);
				}
				return this._atlasViewport;
		}
		set cookie(value) {
				if (this._cookie === value) {
						return;
				}
				this._cookie = value;
				this.updateKey();
		}
		get cookie() {
				return this._cookie;
		}
		set cookieFalloff(value) {
				if (this._cookieFalloff === value) {
						return;
				}
				this._cookieFalloff = value;
				this.updateKey();
		}
		get cookieFalloff() {
				return this._cookieFalloff;
		}
		set cookieChannel(value) {
				if (this._cookieChannel === value) {
						return;
				}
				if (value.length < 3) {
						var chr = value.charAt(value.length - 1);
						var addLen = 3 - value.length;
						for(var i = 0; i < addLen; i++){
								value += chr;
						}
				}
				this._cookieChannel = value;
				this.updateKey();
		}
		get cookieChannel() {
				return this._cookieChannel;
		}
		set cookieTransform(value) {
				if (this._cookieTransform === value) {
						return;
				}
				this._cookieTransform = value;
				this._cookieTransformSet = !!value;
				if (value && !this._cookieOffset) {
						this.cookieOffset = new Vec2();
						this._cookieOffsetSet = false;
				}
				this.updateKey();
		}
		get cookieTransform() {
				return this._cookieTransform;
		}
		set cookieOffset(value) {
				if (this._cookieOffset === value) {
						return;
				}
				var xformNew = !!(this._cookieTransformSet || value);
				if (xformNew && !value && this._cookieOffset) {
						this._cookieOffset.set(0, 0);
				} else {
						this._cookieOffset = value;
				}
				this._cookieOffsetSet = !!value;
				if (value && !this._cookieTransform) {
						this.cookieTransform = new Vec4(1, 1, 0, 0);
						this._cookieTransformSet = false;
				}
				this.updateKey();
		}
		get cookieOffset() {
				return this._cookieOffset;
		}
		beginFrame() {
				this.visibleThisFrame = this._type === LIGHTTYPE_DIRECTIONAL && this._enabled;
				this.maxScreenSize = 0;
				this.atlasViewportAllocated = false;
				this.atlasSlotUpdated = false;
		}
		_destroyShadowMap() {
				this.releaseRenderData();
				if (this._shadowMap) {
						if (!this._shadowMap.cached) {
								this._shadowMap.destroy();
						}
						this._shadowMap = null;
				}
				if (this.shadowUpdateMode === SHADOWUPDATE_NONE) {
						this.shadowUpdateMode = SHADOWUPDATE_THISFRAME;
				}
				if (this.shadowUpdateOverrides) {
						for(var i = 0; i < this.shadowUpdateOverrides.length; i++){
								if (this.shadowUpdateOverrides[i] === SHADOWUPDATE_NONE) {
										this.shadowUpdateOverrides[i] = SHADOWUPDATE_THISFRAME;
								}
						}
				}
		}
		getRenderData(camera, face) {
				for(var i = 0; i < this._renderData.length; i++){
						var current = this._renderData[i];
						if (current.camera === camera && current.face === face) {
								return current;
						}
				}
				var rd = new LightRenderData(camera, face, this);
				this._renderData.push(rd);
				return rd;
		}
		clone() {
				var clone = new Light(this.device, this.clusteredLighting);
				clone.type = this._type;
				clone.setColor(this._color);
				clone.intensity = this._intensity;
				clone.affectSpecularity = this._affectSpecularity;
				clone.luminance = this._luminance;
				clone.castShadows = this.castShadows;
				clone._enabled = this._enabled;
				clone.attenuationStart = this.attenuationStart;
				clone.attenuationEnd = this.attenuationEnd;
				clone.falloffMode = this._falloffMode;
				clone.shadowType = this._shadowType;
				clone.vsmBlurSize = this._vsmBlurSize;
				clone.vsmBlurMode = this.vsmBlurMode;
				clone.vsmBias = this.vsmBias;
				clone.shadowUpdateMode = this.shadowUpdateMode;
				clone.mask = this.mask;
				if (this.shadowUpdateOverrides) {
						clone.shadowUpdateOverrides = this.shadowUpdateOverrides.slice();
				}
				clone.innerConeAngle = this._innerConeAngle;
				clone.outerConeAngle = this._outerConeAngle;
				clone.numCascades = this.numCascades;
				clone.cascadeDistribution = this.cascadeDistribution;
				clone.cascadeBlend = this._cascadeBlend;
				clone.shape = this._shape;
				clone.shadowDepthState.copy(this.shadowDepthState);
				clone.shadowBias = this.shadowBias;
				clone.normalOffsetBias = this._normalOffsetBias;
				clone.shadowResolution = this._shadowResolution;
				clone.shadowDistance = this.shadowDistance;
				clone.shadowIntensity = this.shadowIntensity;
				clone.shadowSamples = this.shadowSamples;
				clone.shadowBlockerSamples = this.shadowBlockerSamples;
				clone.penumbraSize = this.penumbraSize;
				clone.penumbraFalloff = this.penumbraFalloff;
				return clone;
		}
		static getLightUnitConversion(type, outerAngle, innerAngle) {
				if (outerAngle === void 0) outerAngle = Math.PI / 4;
				if (innerAngle === void 0) innerAngle = 0;
				switch(type){
						case LIGHTTYPE_SPOT:
								{
										var falloffEnd = Math.cos(outerAngle);
										var falloffStart = Math.cos(innerAngle);
										return 2 * Math.PI * (1 - falloffStart + (falloffStart - falloffEnd) / 2.0);
								}
						case LIGHTTYPE_OMNI:
								return 4 * Math.PI;
						case LIGHTTYPE_DIRECTIONAL:
								return 1;
				}
		}
		_getUniformBiasValues(lightRenderData) {
				var farClip = lightRenderData.shadowCamera._farClip;
				switch(this._type){
						case LIGHTTYPE_OMNI:
								tmpBiases.bias = this.shadowBias;
								tmpBiases.normalBias = this._normalOffsetBias;
								break;
						case LIGHTTYPE_SPOT:
								if (this._isVsm) {
										tmpBiases.bias = -1e-5 * 20;
								} else {
										tmpBiases.bias = this.shadowBias * 20;
								}
								tmpBiases.normalBias = this._isVsm ? this.vsmBias / (this.attenuationEnd / 7.0) : this._normalOffsetBias;
								break;
						case LIGHTTYPE_DIRECTIONAL:
								if (this._isVsm) {
										tmpBiases.bias = -1e-5 * 20;
								} else {
										tmpBiases.bias = this.shadowBias / farClip * 100;
								}
								tmpBiases.normalBias = this._isVsm ? this.vsmBias / (farClip / 7.0) : this._normalOffsetBias;
								break;
				}
				return tmpBiases;
		}
		getColor() {
				return this._color;
		}
		getBoundingSphere(sphere) {
				if (this._type === LIGHTTYPE_SPOT) {
						var size = this.attenuationEnd;
						var angle = this._outerConeAngle;
						var cosAngle = this._outerConeAngleCos;
						var node = this._node;
						tmpVec.copy(node.up);
						if (angle > 45) {
								sphere.radius = size * this._outerConeAngleSin;
								tmpVec.mulScalar(-size * cosAngle);
						} else {
								sphere.radius = size / (2 * cosAngle);
								tmpVec.mulScalar(-sphere.radius);
						}
						sphere.center.add2(node.getPosition(), tmpVec);
				} else if (this._type === LIGHTTYPE_OMNI) {
						sphere.center = this._node.getPosition();
						sphere.radius = this.attenuationEnd;
				}
		}
		getBoundingBox(box) {
				if (this._type === LIGHTTYPE_SPOT) {
						var range = this.attenuationEnd;
						var angle = this._outerConeAngle;
						var node = this._node;
						var scl = Math.abs(Math.sin(angle * math.DEG_TO_RAD) * range);
						box.center.set(0, -range * 0.5, 0);
						box.halfExtents.set(scl, range * 0.5, scl);
						box.setFromTransformedAabb(box, node.getWorldTransform(), true);
				} else if (this._type === LIGHTTYPE_OMNI) {
						box.center.copy(this._node.getPosition());
						box.halfExtents.set(this.attenuationEnd, this.attenuationEnd, this.attenuationEnd);
				}
		}
		_updateShadowBias() {
				if (this._type === LIGHTTYPE_OMNI && !this.clusteredLighting) {
						this.shadowDepthState.depthBias = 0;
						this.shadowDepthState.depthBiasSlope = 0;
				} else {
						var bias = this.shadowBias * -1e3;
						this.shadowDepthState.depthBias = bias;
						this.shadowDepthState.depthBiasSlope = bias;
				}
		}
		_updateLinearColor() {
				var intensity = this._intensity;
				if (this._usePhysicalUnits) {
						intensity = this._luminance / Light.getLightUnitConversion(this._type, this._outerConeAngle * math.DEG_TO_RAD, this._innerConeAngle * math.DEG_TO_RAD);
				}
				var color = this._color;
				var colorLinear = this._colorLinear;
				if (intensity >= 1) {
						tmpColor.linear(color).mulScalar(intensity);
				} else {
						tmpColor.copy(color).mulScalar(intensity).linear();
				}
				colorLinear[0] = tmpColor.r;
				colorLinear[1] = tmpColor.g;
				colorLinear[2] = tmpColor.b;
		}
		setColor() {
				if (arguments.length === 1) {
						this._color.set(arguments[0].r, arguments[0].g, arguments[0].b);
				} else if (arguments.length === 3) {
						this._color.set(arguments[0], arguments[1], arguments[2]);
				}
				this._updateLinearColor();
		}
		layersDirty() {
				this.layers.forEach((layer)=>{
						if (layer.hasLight(this)) {
								layer.markLightsDirty();
						}
				});
		}
		updateKey() {
				var key = this._type << 29 | this._shadowType << 25 | this._falloffMode << 23 | (this._normalOffsetBias !== 0.0 ? 1 : 0) << 22 | (this._cookie ? 1 : 0) << 21 | (this._cookieFalloff ? 1 : 0) << 20 | chanId[this._cookieChannel.charAt(0)] << 18 | (this._cookieTransform ? 1 : 0) << 12 | this._shape << 10 | (this.numCascades > 0 ? 1 : 0) << 9 | (this._cascadeBlend > 0 ? 1 : 0) << 8 | (this.affectSpecularity ? 1 : 0) << 7 | this.mask << 6 | (this._castShadows ? 1 : 0) << 3;
				if (this._cookieChannel.length === 3) {
						key |= chanId[this._cookieChannel.charAt(1)] << 16;
						key |= chanId[this._cookieChannel.charAt(2)] << 14;
				}
				if (key !== this.key) {
						this.layersDirty();
				}
				this.key = key;
		}
		constructor(graphicsDevice, clusteredLighting){
				this.layers = new Set();
				this.shadowDepthState = DepthState.DEFAULT.clone();
				this.device = graphicsDevice;
				this.clusteredLighting = clusteredLighting;
				this.id = id++;
				this._type = LIGHTTYPE_DIRECTIONAL;
				this._color = new Color(0.8, 0.8, 0.8);
				this._intensity = 1;
				this._affectSpecularity = true;
				this._luminance = 0;
				this._castShadows = false;
				this._enabled = false;
				this._mask = MASK_AFFECT_DYNAMIC;
				this.isStatic = false;
				this.key = 0;
				this.bakeDir = true;
				this.bakeNumSamples = 1;
				this.bakeArea = 0;
				this.attenuationStart = 10;
				this.attenuationEnd = 10;
				this._falloffMode = LIGHTFALLOFF_LINEAR;
				this._shadowType = SHADOW_PCF3_32F;
				this._vsmBlurSize = 11;
				this.vsmBlurMode = BLUR_GAUSSIAN;
				this.vsmBias = 0.01 * 0.25;
				this._cookie = null;
				this.cookieIntensity = 1;
				this._cookieFalloff = true;
				this._cookieChannel = 'rgb';
				this._cookieTransform = null;
				this._cookieTransformUniform = new Float32Array(4);
				this._cookieOffset = null;
				this._cookieOffsetUniform = new Float32Array(2);
				this._cookieTransformSet = false;
				this._cookieOffsetSet = false;
				this._innerConeAngle = 40;
				this._outerConeAngle = 45;
				this.cascades = null;
				this._shadowMatrixPalette = null;
				this._shadowCascadeDistances = null;
				this.numCascades = 1;
				this._cascadeBlend = 0;
				this.cascadeDistribution = 0.5;
				this._shape = LIGHTSHAPE_PUNCTUAL;
				this._colorLinear = new Float32Array(3);
				this._updateLinearColor();
				this._position = new Vec3(0, 0, 0);
				this._direction = new Vec3(0, 0, 0);
				this._innerConeAngleCos = Math.cos(this._innerConeAngle * Math.PI / 180);
				this._updateOuterAngle(this._outerConeAngle);
				this._usePhysicalUnits = undefined;
				this._shadowMap = null;
				this._shadowRenderParams = [];
				this._shadowCameraParams = [];
				this.shadowDistance = 40;
				this._shadowResolution = 1024;
				this._shadowBias = -5e-4;
				this.shadowIntensity = 1.0;
				this._normalOffsetBias = 0.0;
				this.shadowUpdateMode = SHADOWUPDATE_REALTIME;
				this.shadowUpdateOverrides = null;
				this._isVsm = false;
				this._isPcf = true;
				this._softShadowParams = new Float32Array(4);
				this.shadowSamples = 16;
				this.shadowBlockerSamples = 16;
				this.penumbraSize = 1.0;
				this.penumbraFalloff = 1.0;
				this._cookieMatrix = null;
				this._atlasViewport = null;
				this.atlasViewportAllocated = false;
				this.atlasVersion = 0;
				this.atlasSlotIndex = 0;
				this.atlasSlotUpdated = false;
				this._node = null;
				this._renderData = [];
				this.visibleThisFrame = false;
				this.maxScreenSize = 0;
				this._updateShadowBias();
		}
}

class LightingParams {
		applySettings(render) {
				var _render_lightingShadowsEnabled;
				this.shadowsEnabled = (_render_lightingShadowsEnabled = render.lightingShadowsEnabled) != null ? _render_lightingShadowsEnabled : this.shadowsEnabled;
				var _render_lightingCookiesEnabled;
				this.cookiesEnabled = (_render_lightingCookiesEnabled = render.lightingCookiesEnabled) != null ? _render_lightingCookiesEnabled : this.cookiesEnabled;
				var _render_lightingAreaLightsEnabled;
				this.areaLightsEnabled = (_render_lightingAreaLightsEnabled = render.lightingAreaLightsEnabled) != null ? _render_lightingAreaLightsEnabled : this.areaLightsEnabled;
				var _render_lightingShadowAtlasResolution;
				this.shadowAtlasResolution = (_render_lightingShadowAtlasResolution = render.lightingShadowAtlasResolution) != null ? _render_lightingShadowAtlasResolution : this.shadowAtlasResolution;
				var _render_lightingCookieAtlasResolution;
				this.cookieAtlasResolution = (_render_lightingCookieAtlasResolution = render.lightingCookieAtlasResolution) != null ? _render_lightingCookieAtlasResolution : this.cookieAtlasResolution;
				var _render_lightingMaxLightsPerCell;
				this.maxLightsPerCell = (_render_lightingMaxLightsPerCell = render.lightingMaxLightsPerCell) != null ? _render_lightingMaxLightsPerCell : this.maxLightsPerCell;
				var _render_lightingShadowType;
				this.shadowType = (_render_lightingShadowType = render.lightingShadowType) != null ? _render_lightingShadowType : this.shadowType;
				if (render.lightingCells) {
						this.cell = new Vec3(render.lightingCells);
				}
		}
		set cells(value) {
				this._cells.copy(value);
		}
		get cells() {
				return this._cells;
		}
		set maxLightsPerCell(value) {
				this._maxLightsPerCell = math.clamp(value, 1, 255);
		}
		get maxLightsPerCell() {
				return this._maxLightsPerCell;
		}
		set cookieAtlasResolution(value) {
				this._cookieAtlasResolution = math.clamp(value, 32, this._maxTextureSize);
		}
		get cookieAtlasResolution() {
				return this._cookieAtlasResolution;
		}
		set shadowAtlasResolution(value) {
				this._shadowAtlasResolution = math.clamp(value, 32, this._maxTextureSize);
		}
		get shadowAtlasResolution() {
				return this._shadowAtlasResolution;
		}
		set shadowType(value) {
				if (this._shadowType !== value) {
						this._shadowType = value;
						this._dirtyLightsFnc();
				}
		}
		get shadowType() {
				return this._shadowType;
		}
		set cookiesEnabled(value) {
				if (this._cookiesEnabled !== value) {
						this._cookiesEnabled = value;
						this._dirtyLightsFnc();
				}
		}
		get cookiesEnabled() {
				return this._cookiesEnabled;
		}
		set areaLightsEnabled(value) {
				if (this._supportsAreaLights) {
						if (this._areaLightsEnabled !== value) {
								this._areaLightsEnabled = value;
								this._dirtyLightsFnc();
						}
				}
		}
		get areaLightsEnabled() {
				return this._areaLightsEnabled;
		}
		set shadowsEnabled(value) {
				if (this._shadowsEnabled !== value) {
						this._shadowsEnabled = value;
						this._dirtyLightsFnc();
				}
		}
		get shadowsEnabled() {
				return this._shadowsEnabled;
		}
		constructor(supportsAreaLights, maxTextureSize, dirtyLightsFnc){
				this._areaLightsEnabled = false;
				this._cells = new Vec3(10, 3, 10);
				this._maxLightsPerCell = 255;
				this._shadowsEnabled = true;
				this._shadowType = SHADOW_PCF3_32F;
				this._shadowAtlasResolution = 2048;
				this._cookiesEnabled = false;
				this._cookieAtlasResolution = 2048;
				this.atlasSplit = null;
				this._supportsAreaLights = supportsAreaLights;
				this._maxTextureSize = maxTextureSize;
				this._dirtyLightsFnc = dirtyLightsFnc;
		}
}

var blendStateAdditive = new BlendState(true, BLENDEQUATION_ADD, BLENDMODE_ONE, BLENDMODE_ONE);
class MorphInstance {
		destroy() {
				this.shader = null;
				var morph = this.morph;
				if (morph) {
						this.morph = null;
						morph.decRefCount();
						if (morph.refCount < 1) {
								morph.destroy();
						}
				}
				if (this.rtPositions) {
						this.rtPositions.destroy();
						this.rtPositions = null;
				}
				if (this.texturePositions) {
						this.texturePositions.destroy();
						this.texturePositions = null;
				}
				if (this.rtNormals) {
						this.rtNormals.destroy();
						this.rtNormals = null;
				}
				if (this.textureNormals) {
						this.textureNormals.destroy();
						this.textureNormals = null;
				}
		}
		clone() {
				return new MorphInstance(this.morph);
		}
		_getWeightIndex(key) {
				if (typeof key === 'string') {
						var index = this._weightMap.get(key);
						return index;
				}
				return key;
		}
		getWeight(key) {
				var index = this._getWeightIndex(key);
				return this._weights[index];
		}
		setWeight(key, weight) {
				var index = this._getWeightIndex(key);
				this._weights[index] = weight;
				this._dirty = true;
		}
		_getShader(count) {
				var shader = this.shaderCache[count];
				if (!shader) {
						var wgsl = this.device.isWebGPU;
						var chunks = wgsl ? shaderChunksWGSL : shaderChunks;
						var defines = new Map();
						defines.set('MORPH_TEXTURE_COUNT', count);
						defines.set('{MORPH_TEXTURE_COUNT}', count);
						if (this.morph.intRenderFormat) defines.set('MORPH_INT', '');
						var includes = new Map();
						includes.set('morphDeclarationPS', chunks.morphDeclarationPS);
						includes.set('morphEvaluationPS', chunks.morphEvaluationPS);
						var outputType = this.morph.intRenderFormat ? 'uvec4' : 'vec4';
						shader = createShaderFromCode(this.device, chunks.morphVS, chunks.morphPS, "textureMorph" + count, {
								vertex_position: SEMANTIC_POSITION
						}, {
								shaderLanguage: wgsl ? SHADERLANGUAGE_WGSL : SHADERLANGUAGE_GLSL,
								fragmentIncludes: includes,
								fragmentDefines: defines,
								fragmentOutputTypes: [
										outputType
								]
						});
						this.shaderCache[count] = shader;
				}
				return shader;
		}
		_updateTextureRenderTarget(renderTarget, srcTextureName, isPos) {
				var device = this.device;
				var submitBatch = (usedCount, blending)=>{
						this.morphFactor.setValue(this._shaderMorphWeights);
						device.setBlendState(blending ? blendStateAdditive : BlendState.NOBLEND);
						var shader = this._getShader(usedCount);
						drawQuadWithShader(device, renderTarget, shader);
				};
				this.setAabbUniforms(isPos);
				var usedCount = 0;
				var blending = false;
				var count = this._activeTargets.length;
				for(var i = 0; i < count; i++){
						var activeTarget = this._activeTargets[i];
						var tex = activeTarget.target[srcTextureName];
						if (tex) {
								this["morphBlendTex" + usedCount].setValue(tex);
								this._shaderMorphWeights[usedCount] = activeTarget.weight;
								usedCount++;
								if (usedCount >= this.maxSubmitCount) {
										submitBatch(usedCount, blending);
										usedCount = 0;
										blending = true;
								}
						}
				}
				if (usedCount > 0 || count === 0 && !this.zeroTextures) {
						submitBatch(usedCount, blending);
				}
		}
		_updateTextureMorph() {
				this.device;
				if (this._activeTargets.length > 0 || !this.zeroTextures) {
						if (this.rtPositions) {
								this._updateTextureRenderTarget(this.rtPositions, 'texturePositions', true);
						}
						if (this.rtNormals) {
								this._updateTextureRenderTarget(this.rtNormals, 'textureNormals', false);
						}
						this.zeroTextures = this._activeTargets.length === 0;
				}
		}
		setAabbUniforms(isPos) {
				if (isPos === void 0) isPos = true;
				this.aabbSizeId.setValue(isPos ? this._aabbSize : this._aabbNrmSize);
				this.aabbMinId.setValue(isPos ? this._aabbMin : this._aabbNrmMin);
		}
		prepareRendering(device) {
				this.setAabbUniforms();
		}
		update() {
				this._dirty = false;
				var targets = this.morph._targets;
				var activeCount = 0;
				var epsilon = 0.00001;
				for(var i = 0; i < targets.length; i++){
						var absWeight = Math.abs(this.getWeight(i));
						if (absWeight > epsilon) {
								if (this._activeTargets.length <= activeCount) {
										this._activeTargets[activeCount] = {};
								}
								var activeTarget = this._activeTargets[activeCount++];
								activeTarget.absWeight = absWeight;
								activeTarget.weight = this.getWeight(i);
								activeTarget.target = targets[i];
						}
				}
				this._activeTargets.length = activeCount;
				if (this.morph.intRenderFormat) {
						if (this._activeTargets.length > this.maxSubmitCount) {
								this._activeTargets.sort((l, r)=>{
										return l.absWeight < r.absWeight ? 1 : r.absWeight < l.absWeight ? -1 : 0;
								});
								this._activeTargets.length = this.maxSubmitCount;
						}
				}
				this._updateTextureMorph();
		}
		constructor(morph){
				this.shaderCache = [];
				this.morph = morph;
				morph.incRefCount();
				this.device = morph.device;
				this._weights = [];
				this._weightMap = new Map();
				for(var v = 0; v < morph._targets.length; v++){
						var target = morph._targets[v];
						if (target.name) {
								this._weightMap.set(target.name, v);
						}
						this.setWeight(v, target.defaultWeight);
				}
				this._activeTargets = [];
				this.maxSubmitCount = this.device.maxTextures;
				this._shaderMorphWeights = new Float32Array(this.maxSubmitCount);
				var createRT = (name, textureVar)=>{
						this[textureVar] = morph._createTexture(name, morph._renderTextureFormat);
						return new RenderTarget({
								colorBuffer: this[textureVar],
								depth: false
						});
				};
				if (morph.morphPositions) {
						this.rtPositions = createRT('MorphRTPos', 'texturePositions');
				}
				if (morph.morphNormals) {
						this.rtNormals = createRT('MorphRTNrm', 'textureNormals');
				}
				this._textureParams = new Float32Array([
						morph.morphTextureWidth,
						morph.morphTextureHeight
				]);
				var halfSize = morph.aabb.halfExtents;
				this._aabbSize = new Float32Array([
						halfSize.x * 4,
						halfSize.y * 4,
						halfSize.z * 4
				]);
				var min = morph.aabb.getMin();
				this._aabbMin = new Float32Array([
						min.x * 2,
						min.y * 2,
						min.z * 2
				]);
				this._aabbNrmSize = new Float32Array([
						2,
						2,
						2
				]);
				this._aabbNrmMin = new Float32Array([
						-1,
						-1,
						-1
				]);
				this.aabbSizeId = this.device.scope.resolve('aabbSize');
				this.aabbMinId = this.device.scope.resolve('aabbMin');
				for(var i = 0; i < this.maxSubmitCount; i++){
						this["morphBlendTex" + i] = this.device.scope.resolve("morphBlendTex" + i);
				}
				this.morphFactor = this.device.scope.resolve('morphFactor[0]');
				this.zeroTextures = false;
		}
}

class Model {
		getGraph() {
				return this.graph;
		}
		setGraph(graph) {
				this.graph = graph;
		}
		getCameras() {
				return this.cameras;
		}
		setCameras(cameras) {
				this.cameras = cameras;
		}
		getLights() {
				return this.lights;
		}
		setLights(lights) {
				this.lights = lights;
		}
		getMaterials() {
				var materials = [];
				for(var i = 0; i < this.meshInstances.length; i++){
						var meshInstance = this.meshInstances[i];
						if (materials.indexOf(meshInstance.material) === -1) {
								materials.push(meshInstance.material);
						}
				}
				return materials;
		}
		clone() {
				var srcNodes = [];
				var cloneNodes = [];
				var _duplicate = function _duplicate1(node) {
						var newNode = node.clone();
						srcNodes.push(node);
						cloneNodes.push(newNode);
						for(var idx = 0; idx < node._children.length; idx++){
								newNode.addChild(_duplicate(node._children[idx]));
						}
						return newNode;
				};
				var cloneGraph = _duplicate(this.graph);
				var cloneMeshInstances = [];
				var cloneSkinInstances = [];
				var cloneMorphInstances = [];
				for(var i = 0; i < this.skinInstances.length; i++){
						var skin = this.skinInstances[i].skin;
						var cloneSkinInstance = new SkinInstance(skin);
						var bones = [];
						for(var j = 0; j < skin.boneNames.length; j++){
								var boneName = skin.boneNames[j];
								var bone = cloneGraph.findByName(boneName);
								bones.push(bone);
						}
						cloneSkinInstance.bones = bones;
						cloneSkinInstances.push(cloneSkinInstance);
				}
				for(var i1 = 0; i1 < this.morphInstances.length; i1++){
						var morph = this.morphInstances[i1].morph;
						var cloneMorphInstance = new MorphInstance(morph);
						cloneMorphInstances.push(cloneMorphInstance);
				}
				for(var i2 = 0; i2 < this.meshInstances.length; i2++){
						var meshInstance = this.meshInstances[i2];
						var nodeIndex = srcNodes.indexOf(meshInstance.node);
						var cloneMeshInstance = new MeshInstance(meshInstance.mesh, meshInstance.material, cloneNodes[nodeIndex]);
						if (meshInstance.skinInstance) {
								var skinInstanceIndex = this.skinInstances.indexOf(meshInstance.skinInstance);
								cloneMeshInstance.skinInstance = cloneSkinInstances[skinInstanceIndex];
						}
						if (meshInstance.morphInstance) {
								var morphInstanceIndex = this.morphInstances.indexOf(meshInstance.morphInstance);
								cloneMeshInstance.morphInstance = cloneMorphInstances[morphInstanceIndex];
						}
						cloneMeshInstances.push(cloneMeshInstance);
				}
				var clone = new Model();
				clone.graph = cloneGraph;
				clone.meshInstances = cloneMeshInstances;
				clone.skinInstances = cloneSkinInstances;
				clone.morphInstances = cloneMorphInstances;
				clone.getGraph().syncHierarchy();
				return clone;
		}
		destroy() {
				var meshInstances = this.meshInstances;
				for(var i = 0; i < meshInstances.length; i++){
						meshInstances[i].destroy();
				}
				this.meshInstances.length = 0;
		}
		generateWireframe() {
				MeshInstance._prepareRenderStyleForArray(this.meshInstances, RENDERSTYLE_WIREFRAME);
		}
		constructor(){
				this.graph = null;
				this.meshInstances = [];
				this.skinInstances = [];
				this.morphInstances = [];
				this.cameras = [];
				this.lights = [];
				this._shadersVersion = 0;
				this._immutable = false;
		}
}

class Morph extends RefCountedObject {
		get aabb() {
				if (!this._aabb) {
						var min = new Vec3();
						var max = new Vec3();
						for(var i = 0; i < this._targets.length; i++){
								var targetAabb = this._targets[i].aabb;
								min.min(targetAabb.getMin());
								max.max(targetAabb.getMax());
						}
						this._aabb = new BoundingBox();
						this._aabb.setMinMax(min, max);
				}
				return this._aabb;
		}
		get morphPositions() {
				return this._morphPositions;
		}
		get morphNormals() {
				return this._morphNormals;
		}
		_init() {
				this._initTextureBased();
				for(var i = 0; i < this._targets.length; i++){
						this._targets[i]._postInit();
				}
		}
		_findSparseSet(deltaArrays, ids, usedDataIndices) {
				var freeIndex = 1;
				var dataCount = deltaArrays[0].length;
				for(var v = 0; v < dataCount; v += 3){
						var vertexUsed = false;
						for(var i = 0; i < deltaArrays.length; i++){
								var data = deltaArrays[i];
								if (data[v] !== 0 || data[v + 1] !== 0 || data[v + 2] !== 0) {
										vertexUsed = true;
										break;
								}
						}
						if (vertexUsed) {
								ids.push(freeIndex);
								usedDataIndices.push(v / 3);
								freeIndex++;
						} else {
								ids.push(0);
						}
				}
				return freeIndex;
		}
		_initTextureBased() {
				var deltaArrays = [], deltaInfos = [];
				for(var i = 0; i < this._targets.length; i++){
						var target = this._targets[i];
						if (target.options.deltaPositions) {
								deltaArrays.push(target.options.deltaPositions);
								deltaInfos.push({
										target: target,
										name: 'texturePositions'
								});
						}
						if (target.options.deltaNormals) {
								deltaArrays.push(target.options.deltaNormals);
								deltaInfos.push({
										target: target,
										name: 'textureNormals'
								});
						}
				}
				var ids = [], usedDataIndices = [];
				var freeIndex = this._findSparseSet(deltaArrays, ids, usedDataIndices);
				var maxTextureSize = this.device.maxTextureSize;
				var morphTextureWidth = Math.ceil(Math.sqrt(freeIndex));
				morphTextureWidth = Math.min(morphTextureWidth, maxTextureSize);
				var morphTextureHeight = Math.ceil(freeIndex / morphTextureWidth);
				if (morphTextureHeight > maxTextureSize) {
						return false;
				}
				this.morphTextureWidth = morphTextureWidth;
				this.morphTextureHeight = morphTextureHeight;
				var halfFloat = false;
				var float2Half = FloatPacking.float2Half;
				if (this._textureFormat === PIXELFORMAT_RGBA16F) {
						halfFloat = true;
				}
				var textures = [];
				for(var i1 = 0; i1 < deltaArrays.length; i1++){
						textures.push(this._createTexture('MorphTarget', this._textureFormat));
				}
				for(var i2 = 0; i2 < deltaArrays.length; i2++){
						var data = deltaArrays[i2];
						var texture = textures[i2];
						var textureData = texture.lock();
						if (halfFloat) {
								for(var v = 0; v < usedDataIndices.length; v++){
										var index = usedDataIndices[v] * 3;
										var dstIndex = v * 4 + 4;
										textureData[dstIndex] = float2Half(data[index]);
										textureData[dstIndex + 1] = float2Half(data[index + 1]);
										textureData[dstIndex + 2] = float2Half(data[index + 2]);
								}
						} else {
								for(var v1 = 0; v1 < usedDataIndices.length; v1++){
										var index1 = usedDataIndices[v1] * 3;
										var dstIndex1 = v1 * 4 + 4;
										textureData[dstIndex1] = data[index1];
										textureData[dstIndex1 + 1] = data[index1 + 1];
										textureData[dstIndex1 + 2] = data[index1 + 2];
								}
						}
						texture.unlock();
						var target1 = deltaInfos[i2].target;
						target1._setTexture(deltaInfos[i2].name, texture);
				}
				var formatDesc = [
						{
								semantic: SEMANTIC_ATTR15,
								components: 1,
								type: TYPE_UINT32,
								asInt: true
						}
				];
				this.vertexBufferIds = new VertexBuffer(this.device, new VertexFormat(this.device, formatDesc, ids.length), ids.length, {
						data: new Uint32Array(ids)
				});
				return true;
		}
		destroy() {
				var _this_vertexBufferIds;
				(_this_vertexBufferIds = this.vertexBufferIds) == null ? void 0 : _this_vertexBufferIds.destroy();
				this.vertexBufferIds = null;
				for(var i = 0; i < this._targets.length; i++){
						this._targets[i].destroy();
				}
				this._targets.length = 0;
		}
		get targets() {
				return this._targets;
		}
		_updateMorphFlags() {
				this._morphPositions = false;
				this._morphNormals = false;
				for(var i = 0; i < this._targets.length; i++){
						var target = this._targets[i];
						if (target.morphPositions) {
								this._morphPositions = true;
						}
						if (target.morphNormals) {
								this._morphNormals = true;
						}
				}
		}
		_createTexture(name, format) {
				return new Texture(this.device, {
						width: this.morphTextureWidth,
						height: this.morphTextureHeight,
						format: format,
						cubemap: false,
						mipmaps: false,
						minFilter: FILTER_NEAREST,
						magFilter: FILTER_NEAREST,
						addressU: ADDRESS_CLAMP_TO_EDGE,
						addressV: ADDRESS_CLAMP_TO_EDGE,
						name: name
				});
		}
		constructor(targets, graphicsDevice, { preferHighPrecision = false } = {}){
				super();
				this.device = graphicsDevice;
				var device = graphicsDevice;
				this.preferHighPrecision = preferHighPrecision;
				this._targets = targets.slice();
				var renderableHalf = device.textureHalfFloatRenderable ? PIXELFORMAT_RGBA16F : undefined;
				var renderableFloat = device.textureFloatRenderable ? PIXELFORMAT_RGBA32F : undefined;
				this._renderTextureFormat = this.preferHighPrecision ? renderableFloat != null ? renderableFloat : renderableHalf : renderableHalf != null ? renderableHalf : renderableFloat;
				var _this__renderTextureFormat;
				this._renderTextureFormat = (_this__renderTextureFormat = this._renderTextureFormat) != null ? _this__renderTextureFormat : PIXELFORMAT_RGBA16U;
				this.intRenderFormat = isIntegerPixelFormat(this._renderTextureFormat);
				this._textureFormat = this.preferHighPrecision ? PIXELFORMAT_RGBA32F : PIXELFORMAT_RGBA16F;
				this._init();
				this._updateMorphFlags();
		}
}

class MorphTarget {
		destroy() {
				var _this_texturePositions, _this_textureNormals;
				(_this_texturePositions = this.texturePositions) == null ? void 0 : _this_texturePositions.destroy();
				this.texturePositions = null;
				(_this_textureNormals = this.textureNormals) == null ? void 0 : _this_textureNormals.destroy();
				this.textureNormals = null;
		}
		get name() {
				return this._name;
		}
		get defaultWeight() {
				return this._defaultWeight;
		}
		get aabb() {
				if (!this._aabb) {
						this._aabb = new BoundingBox();
						if (this.deltaPositions) {
								this._aabb.compute(this.deltaPositions);
						}
				}
				return this._aabb;
		}
		get morphPositions() {
				return !!this.texturePositions;
		}
		get morphNormals() {
				return !!this.textureNormals;
		}
		clone() {
				return new MorphTarget(this.options);
		}
		_postInit() {
				if (!this.options.preserveData) {
						this.options = null;
				}
				this.used = true;
		}
		_setTexture(name, texture) {
				this[name] = texture;
		}
		constructor(options){
				this.used = false;
				this.options = options;
				this._name = options.name;
				this._defaultWeight = options.defaultWeight || 0;
				this._aabb = options.aabb;
				this.deltaPositions = options.deltaPositions;
		}
}

var nonUniformScale;
var uniformScale = 1;
var particleTexChannels$1 = 4;
var rotMat = new Mat4();
var rotMatInv = new Mat4();
var randomPosTformed = new Vec3();
var randomPos = new Vec3();
var rndFactor3Vec = new Vec3();
var particlePosPrev = new Vec3();
var velocityVec = new Vec3();
var localVelocityVec = new Vec3();
var velocityVec2 = new Vec3();
var localVelocityVec2 = new Vec3();
var radialVelocityVec = new Vec3();
var particlePos = new Vec3();
var particleFinalPos = new Vec3();
var moveDirVec = new Vec3();
var tmpVec3$1 = new Vec3();
function frac(f) {
		return f - Math.floor(f);
}
function saturate$1(x) {
		return Math.max(Math.min(x, 1), 0);
}
function glMod(x, y) {
		return x - y * Math.floor(x / y);
}
function encodeFloatRGBA(v) {
		var encX = frac(v);
		var encY = frac(255.0 * v);
		var encZ = frac(65025.0 * v);
		var encW = frac(160581375.0 * v);
		encX -= encY / 255.0;
		encY -= encZ / 255.0;
		encZ -= encW / 255.0;
		encW -= encW / 255.0;
		return [
				encX,
				encY,
				encZ,
				encW
		];
}
function encodeFloatRG(v) {
		var encX = frac(v);
		var encY = frac(255.0 * v);
		encX -= encY / 255.0;
		encY -= encY / 255.0;
		return [
				encX,
				encY
		];
}
class ParticleCPUUpdater {
		calcSpawnPosition(particleTex, spawnMatrix, extentsInnerRatioUniform, emitterPos, i) {
				var emitter = this._emitter;
				var rX = Math.random();
				var rY = Math.random();
				var rZ = Math.random();
				var rW = Math.random();
				if (emitter.useCpu) {
						particleTex[i * particleTexChannels$1 + 0 + emitter.numParticlesPot * 2 * particleTexChannels$1] = rX;
						particleTex[i * particleTexChannels$1 + 1 + emitter.numParticlesPot * 2 * particleTexChannels$1] = rY;
						particleTex[i * particleTexChannels$1 + 2 + emitter.numParticlesPot * 2 * particleTexChannels$1] = rZ;
				}
				randomPos.x = rX - 0.5;
				randomPos.y = rY - 0.5;
				randomPos.z = rZ - 0.5;
				if (emitter.emitterShape === EMITTERSHAPE_BOX) {
						var max = Math.max(Math.abs(randomPos.x), Math.max(Math.abs(randomPos.y), Math.abs(randomPos.z)));
						var edgeX = max + (0.5 - max) * extentsInnerRatioUniform[0];
						var edgeY = max + (0.5 - max) * extentsInnerRatioUniform[1];
						var edgeZ = max + (0.5 - max) * extentsInnerRatioUniform[2];
						randomPos.x = edgeX * (max === Math.abs(randomPos.x) ? Math.sign(randomPos.x) : 2 * randomPos.x);
						randomPos.y = edgeY * (max === Math.abs(randomPos.y) ? Math.sign(randomPos.y) : 2 * randomPos.y);
						randomPos.z = edgeZ * (max === Math.abs(randomPos.z) ? Math.sign(randomPos.z) : 2 * randomPos.z);
						if (!emitter.localSpace) {
								randomPosTformed.copy(emitterPos).add(spawnMatrix.transformPoint(randomPos));
						} else {
								randomPosTformed.copy(spawnMatrix.transformPoint(randomPos));
						}
				} else {
						randomPos.normalize();
						var spawnBoundsSphereInnerRatio = emitter.emitterRadius === 0 ? 0 : emitter.emitterRadiusInner / emitter.emitterRadius;
						var r = rW * (1.0 - spawnBoundsSphereInnerRatio) + spawnBoundsSphereInnerRatio;
						if (!emitter.localSpace) {
								randomPosTformed.copy(emitterPos).add(randomPos.mulScalar(r * emitter.emitterRadius));
						} else {
								randomPosTformed.copy(randomPos.mulScalar(r * emitter.emitterRadius));
						}
				}
				var particleRate = math.lerp(emitter.rate, emitter.rate2, rX);
				var startSpawnTime = -particleRate * i;
				if (emitter.pack8) {
						var packX = (randomPosTformed.x - emitter.worldBounds.center.x) / emitter.worldBoundsSize.x + 0.5;
						var packY = (randomPosTformed.y - emitter.worldBounds.center.y) / emitter.worldBoundsSize.y + 0.5;
						var packZ = (randomPosTformed.z - emitter.worldBounds.center.z) / emitter.worldBoundsSize.z + 0.5;
						var packA = math.lerp(emitter.startAngle * math.DEG_TO_RAD, emitter.startAngle2 * math.DEG_TO_RAD, rX);
						packA = packA % (Math.PI * 2) / (Math.PI * 2);
						var rg0 = encodeFloatRG(packX);
						particleTex[i * particleTexChannels$1] = rg0[0];
						particleTex[i * particleTexChannels$1 + 1] = rg0[1];
						var ba0 = encodeFloatRG(packY);
						particleTex[i * particleTexChannels$1 + 2] = ba0[0];
						particleTex[i * particleTexChannels$1 + 3] = ba0[1];
						var rg1 = encodeFloatRG(packZ);
						particleTex[i * particleTexChannels$1 + 0 + emitter.numParticlesPot * particleTexChannels$1] = rg1[0];
						particleTex[i * particleTexChannels$1 + 1 + emitter.numParticlesPot * particleTexChannels$1] = rg1[1];
						var ba1 = encodeFloatRG(packA);
						particleTex[i * particleTexChannels$1 + 2 + emitter.numParticlesPot * particleTexChannels$1] = ba1[0];
						particleTex[i * particleTexChannels$1 + 3 + emitter.numParticlesPot * particleTexChannels$1] = ba1[1];
						var a2 = 1.0;
						particleTex[i * particleTexChannels$1 + 3 + emitter.numParticlesPot * particleTexChannels$1 * 2] = a2;
						var maxNegLife = Math.max(emitter.lifetime, (emitter.numParticles - 1.0) * Math.max(emitter.rate, emitter.rate2));
						var maxPosLife = emitter.lifetime + 1.0;
						startSpawnTime = (startSpawnTime + maxNegLife) / (maxNegLife + maxPosLife);
						var rgba3 = encodeFloatRGBA(startSpawnTime);
						particleTex[i * particleTexChannels$1 + 0 + emitter.numParticlesPot * particleTexChannels$1 * 3] = rgba3[0];
						particleTex[i * particleTexChannels$1 + 1 + emitter.numParticlesPot * particleTexChannels$1 * 3] = rgba3[1];
						particleTex[i * particleTexChannels$1 + 2 + emitter.numParticlesPot * particleTexChannels$1 * 3] = rgba3[2];
						particleTex[i * particleTexChannels$1 + 3 + emitter.numParticlesPot * particleTexChannels$1 * 3] = rgba3[3];
				} else {
						particleTex[i * particleTexChannels$1] = randomPosTformed.x;
						particleTex[i * particleTexChannels$1 + 1] = randomPosTformed.y;
						particleTex[i * particleTexChannels$1 + 2] = randomPosTformed.z;
						particleTex[i * particleTexChannels$1 + 3] = math.lerp(emitter.startAngle * math.DEG_TO_RAD, emitter.startAngle2 * math.DEG_TO_RAD, rX);
						particleTex[i * particleTexChannels$1 + 3 + emitter.numParticlesPot * particleTexChannels$1] = startSpawnTime;
				}
		}
		update(data, vbToSort, particleTex, spawnMatrix, extentsInnerRatioUniform, emitterPos, delta, isOnStop) {
				var a, b, c;
				var emitter = this._emitter;
				if (emitter.meshInstance.node) {
						var fullMat = emitter.meshInstance.node.worldTransform;
						for(var j = 0; j < 12; j++){
								rotMat.data[j] = fullMat.data[j];
						}
						rotMatInv.copy(rotMat);
						rotMatInv.invert();
						nonUniformScale = emitter.meshInstance.node.localScale;
						uniformScale = Math.max(Math.max(nonUniformScale.x, nonUniformScale.y), nonUniformScale.z);
				}
				emitterPos = emitter.meshInstance.node === null || emitter.localSpace ? Vec3.ZERO : emitter.meshInstance.node.getPosition();
				var posCam = emitter.camera ? emitter.camera._node.getPosition() : Vec3.ZERO;
				var vertSize = !emitter.useMesh ? 15 : 17;
				var cf, cc;
				var rotSpeed, rotSpeed2, scale2, alpha, alpha2, radialSpeed, radialSpeed2;
				var precision1 = emitter.precision - 1;
				for(var i = 0; i < emitter.numParticles; i++){
						var id = Math.floor(emitter.vbCPU[i * emitter.numParticleVerts * (emitter.useMesh ? 6 : 4) + 3]);
						var rndFactor = particleTex[id * particleTexChannels$1 + 0 + emitter.numParticlesPot * 2 * particleTexChannels$1];
						rndFactor3Vec.x = rndFactor;
						rndFactor3Vec.y = particleTex[id * particleTexChannels$1 + 1 + emitter.numParticlesPot * 2 * particleTexChannels$1];
						rndFactor3Vec.z = particleTex[id * particleTexChannels$1 + 2 + emitter.numParticlesPot * 2 * particleTexChannels$1];
						var particleRate = emitter.rate + (emitter.rate2 - emitter.rate) * rndFactor;
						var particleLifetime = emitter.lifetime;
						var life = particleTex[id * particleTexChannels$1 + 3 + emitter.numParticlesPot * particleTexChannels$1] + delta;
						var nlife = saturate$1(life / particleLifetime);
						var scale = 0;
						var alphaDiv = 0;
						var angle = 0;
						var respawn = life - delta <= 0.0 || life >= particleLifetime;
						if (respawn) {
								this.calcSpawnPosition(particleTex, spawnMatrix, extentsInnerRatioUniform, emitterPos, id);
						}
						var particleEnabled = life > 0.0 && life < particleLifetime;
						if (particleEnabled) {
								c = nlife * precision1;
								cf = Math.floor(c);
								cc = Math.ceil(c);
								c %= 1;
								a = emitter.qRotSpeed[cf];
								b = emitter.qRotSpeed[cc];
								rotSpeed = a + (b - a) * c;
								a = emitter.qRotSpeed2[cf];
								b = emitter.qRotSpeed2[cc];
								rotSpeed2 = a + (b - a) * c;
								a = emitter.qScale[cf];
								b = emitter.qScale[cc];
								scale = a + (b - a) * c;
								a = emitter.qScale2[cf];
								b = emitter.qScale2[cc];
								scale2 = a + (b - a) * c;
								a = emitter.qAlpha[cf];
								b = emitter.qAlpha[cc];
								alpha = a + (b - a) * c;
								a = emitter.qAlpha2[cf];
								b = emitter.qAlpha2[cc];
								alpha2 = a + (b - a) * c;
								a = emitter.qRadialSpeed[cf];
								b = emitter.qRadialSpeed[cc];
								radialSpeed = a + (b - a) * c;
								a = emitter.qRadialSpeed2[cf];
								b = emitter.qRadialSpeed2[cc];
								radialSpeed2 = a + (b - a) * c;
								radialSpeed += (radialSpeed2 - radialSpeed) * (rndFactor * 100.0 % 1.0);
								particlePosPrev.x = particleTex[id * particleTexChannels$1];
								particlePosPrev.y = particleTex[id * particleTexChannels$1 + 1];
								particlePosPrev.z = particleTex[id * particleTexChannels$1 + 2];
								if (!emitter.localSpace) {
										radialVelocityVec.copy(particlePosPrev).sub(emitterPos);
								} else {
										radialVelocityVec.copy(particlePosPrev);
								}
								radialVelocityVec.normalize().mulScalar(radialSpeed);
								cf *= 3;
								cc *= 3;
								a = emitter.qLocalVelocity[cf];
								b = emitter.qLocalVelocity[cc];
								localVelocityVec.x = a + (b - a) * c;
								a = emitter.qLocalVelocity[cf + 1];
								b = emitter.qLocalVelocity[cc + 1];
								localVelocityVec.y = a + (b - a) * c;
								a = emitter.qLocalVelocity[cf + 2];
								b = emitter.qLocalVelocity[cc + 2];
								localVelocityVec.z = a + (b - a) * c;
								a = emitter.qLocalVelocity2[cf];
								b = emitter.qLocalVelocity2[cc];
								localVelocityVec2.x = a + (b - a) * c;
								a = emitter.qLocalVelocity2[cf + 1];
								b = emitter.qLocalVelocity2[cc + 1];
								localVelocityVec2.y = a + (b - a) * c;
								a = emitter.qLocalVelocity2[cf + 2];
								b = emitter.qLocalVelocity2[cc + 2];
								localVelocityVec2.z = a + (b - a) * c;
								a = emitter.qVelocity[cf];
								b = emitter.qVelocity[cc];
								velocityVec.x = a + (b - a) * c;
								a = emitter.qVelocity[cf + 1];
								b = emitter.qVelocity[cc + 1];
								velocityVec.y = a + (b - a) * c;
								a = emitter.qVelocity[cf + 2];
								b = emitter.qVelocity[cc + 2];
								velocityVec.z = a + (b - a) * c;
								a = emitter.qVelocity2[cf];
								b = emitter.qVelocity2[cc];
								velocityVec2.x = a + (b - a) * c;
								a = emitter.qVelocity2[cf + 1];
								b = emitter.qVelocity2[cc + 1];
								velocityVec2.y = a + (b - a) * c;
								a = emitter.qVelocity2[cf + 2];
								b = emitter.qVelocity2[cc + 2];
								velocityVec2.z = a + (b - a) * c;
								localVelocityVec.x += (localVelocityVec2.x - localVelocityVec.x) * rndFactor3Vec.x;
								localVelocityVec.y += (localVelocityVec2.y - localVelocityVec.y) * rndFactor3Vec.y;
								localVelocityVec.z += (localVelocityVec2.z - localVelocityVec.z) * rndFactor3Vec.z;
								if (emitter.initialVelocity > 0) {
										if (emitter.emitterShape === EMITTERSHAPE_SPHERE) {
												randomPos.copy(rndFactor3Vec).mulScalar(2).sub(Vec3.ONE).normalize();
												localVelocityVec.add(randomPos.mulScalar(emitter.initialVelocity));
										} else {
												localVelocityVec.add(Vec3.FORWARD.mulScalar(emitter.initialVelocity));
										}
								}
								velocityVec.x += (velocityVec2.x - velocityVec.x) * rndFactor3Vec.x;
								velocityVec.y += (velocityVec2.y - velocityVec.y) * rndFactor3Vec.y;
								velocityVec.z += (velocityVec2.z - velocityVec.z) * rndFactor3Vec.z;
								rotSpeed += (rotSpeed2 - rotSpeed) * rndFactor3Vec.y;
								scale = (scale + (scale2 - scale) * (rndFactor * 10000.0 % 1.0)) * uniformScale;
								alphaDiv = (alpha2 - alpha) * (rndFactor * 1000.0 % 1.0);
								if (emitter.meshInstance.node) {
										if (!emitter.localSpace) {
												rotMat.transformPoint(localVelocityVec, localVelocityVec);
										} else {
												localVelocityVec.x /= nonUniformScale.x;
												localVelocityVec.y /= nonUniformScale.y;
												localVelocityVec.z /= nonUniformScale.z;
										}
								}
								if (!emitter.localSpace) {
										localVelocityVec.add(velocityVec.mul(nonUniformScale));
										localVelocityVec.add(radialVelocityVec.mul(nonUniformScale));
								} else {
										rotMatInv.transformPoint(velocityVec, velocityVec);
										localVelocityVec.add(velocityVec).add(radialVelocityVec);
								}
								moveDirVec.copy(localVelocityVec);
								particlePos.copy(particlePosPrev).add(localVelocityVec.mulScalar(delta));
								particleFinalPos.copy(particlePos);
								particleTex[id * particleTexChannels$1] = particleFinalPos.x;
								particleTex[id * particleTexChannels$1 + 1] = particleFinalPos.y;
								particleTex[id * particleTexChannels$1 + 2] = particleFinalPos.z;
								particleTex[id * particleTexChannels$1 + 3] += rotSpeed * delta;
								if (emitter.wrap && emitter.wrapBounds) {
										if (!emitter.localSpace) {
												particleFinalPos.sub(emitterPos);
										}
										particleFinalPos.x = glMod(particleFinalPos.x, emitter.wrapBounds.x) - emitter.wrapBounds.x * 0.5;
										particleFinalPos.y = glMod(particleFinalPos.y, emitter.wrapBounds.y) - emitter.wrapBounds.y * 0.5;
										particleFinalPos.z = glMod(particleFinalPos.z, emitter.wrapBounds.z) - emitter.wrapBounds.z * 0.5;
										if (!emitter.localSpace) {
												particleFinalPos.add(emitterPos);
										}
								}
								if (emitter.sort > 0) {
										if (emitter.sort === 1) {
												tmpVec3$1.copy(particleFinalPos).sub(posCam);
												emitter.particleDistance[id] = -(tmpVec3$1.x * tmpVec3$1.x + tmpVec3$1.y * tmpVec3$1.y + tmpVec3$1.z * tmpVec3$1.z);
										} else if (emitter.sort === 2) {
												emitter.particleDistance[id] = life;
										} else if (emitter.sort === 3) {
												emitter.particleDistance[id] = -life;
										}
								}
						}
						if (isOnStop) {
								if (life < 0) {
										particleTex[id * particleTexChannels$1 + 3 + emitter.numParticlesPot * 2 * particleTexChannels$1] = -1;
								}
						} else {
								if (life >= particleLifetime) {
										life -= Math.max(particleLifetime, (emitter.numParticles - 1) * particleRate);
										particleTex[id * particleTexChannels$1 + 3 + emitter.numParticlesPot * 2 * particleTexChannels$1] = emitter.loop ? 1 : -1;
								}
								if (life < 0 && emitter.loop) {
										particleTex[id * particleTexChannels$1 + 3 + emitter.numParticlesPot * 2 * particleTexChannels$1] = 1;
								}
						}
						if (particleTex[id * particleTexChannels$1 + 3 + emitter.numParticlesPot * 2 * particleTexChannels$1] < 0) {
								particleEnabled = false;
						}
						particleTex[id * particleTexChannels$1 + 3 + emitter.numParticlesPot * particleTexChannels$1] = life;
						for(var v = 0; v < emitter.numParticleVerts; v++){
								var vbOffset = (i * emitter.numParticleVerts + v) * (emitter.useMesh ? 6 : 4);
								var quadX = emitter.vbCPU[vbOffset];
								var quadY = emitter.vbCPU[vbOffset + 1];
								var quadZ = emitter.vbCPU[vbOffset + 2];
								if (!particleEnabled) {
										quadX = quadY = quadZ = 0;
								}
								var w = i * emitter.numParticleVerts * vertSize + v * vertSize;
								data[w] = particleFinalPos.x;
								data[w + 1] = particleFinalPos.y;
								data[w + 2] = particleFinalPos.z;
								data[w + 3] = nlife;
								data[w + 4] = emitter.alignToMotion ? angle : particleTex[id * particleTexChannels$1 + 3];
								data[w + 5] = scale;
								data[w + 6] = alphaDiv;
								data[w + 7] = moveDirVec.x;
								data[w + 8] = quadX;
								data[w + 9] = quadY;
								data[w + 10] = quadZ;
								data[w + 11] = moveDirVec.y;
								data[w + 12] = id;
								data[w + 13] = moveDirVec.z;
								data[w + 14] = emitter.vbCPU[vbOffset + 3];
								if (emitter.useMesh) {
										data[w + 15] = emitter.vbCPU[vbOffset + 4];
										data[w + 16] = emitter.vbCPU[vbOffset + 5];
								}
						}
				}
				if (emitter.sort > PARTICLESORT_NONE && emitter.camera) {
						var vbStride = emitter.useMesh ? 6 : 4;
						var particleDistance = emitter.particleDistance;
						for(var i1 = 0; i1 < emitter.numParticles; i1++){
								vbToSort[i1][0] = i1;
								vbToSort[i1][1] = particleDistance[Math.floor(emitter.vbCPU[i1 * emitter.numParticleVerts * vbStride + 3])];
						}
						emitter.vbOld.set(emitter.vbCPU);
						vbToSort.sort((p1, p2)=>{
								return p1[1] - p2[1];
						});
						for(var i2 = 0; i2 < emitter.numParticles; i2++){
								var src = vbToSort[i2][0] * emitter.numParticleVerts * vbStride;
								var dest = i2 * emitter.numParticleVerts * vbStride;
								for(var j1 = 0; j1 < emitter.numParticleVerts * vbStride; j1++){
										emitter.vbCPU[dest + j1] = emitter.vbOld[src + j1];
								}
						}
				}
		}
		constructor(emitter){
				this._emitter = emitter;
		}
}

var spawnMatrix3 = new Mat3();
var emitterMatrix3 = new Mat3();
var emitterMatrix3Inv = new Mat3();
class ParticleGPUUpdater {
		_setInputBounds() {
				this.inBoundsSizeUniform[0] = this._emitter.prevWorldBoundsSize.x;
				this.inBoundsSizeUniform[1] = this._emitter.prevWorldBoundsSize.y;
				this.inBoundsSizeUniform[2] = this._emitter.prevWorldBoundsSize.z;
				this.constantInBoundsSize.setValue(this.inBoundsSizeUniform);
				this.inBoundsCenterUniform[0] = this._emitter.prevWorldBoundsCenter.x;
				this.inBoundsCenterUniform[1] = this._emitter.prevWorldBoundsCenter.y;
				this.inBoundsCenterUniform[2] = this._emitter.prevWorldBoundsCenter.z;
				this.constantInBoundsCenter.setValue(this.inBoundsCenterUniform);
		}
		randomize() {
				this.frameRandomUniform[0] = Math.random();
				this.frameRandomUniform[1] = Math.random();
				this.frameRandomUniform[2] = Math.random();
		}
		update(device, spawnMatrix, extentsInnerRatioUniform, delta, isOnStop) {
				var emitter = this._emitter;
				device.setBlendState(BlendState.NOBLEND);
				device.setDepthState(DepthState.NODEPTH);
				device.setCullMode(CULLFACE_NONE);
				this.randomize();
				this.constantGraphSampleSize.setValue(1.0 / emitter.precision);
				this.constantGraphNumSamples.setValue(emitter.precision);
				this.constantNumParticles.setValue(emitter.numParticles);
				this.constantNumParticlesPot.setValue(emitter.numParticlesPot);
				this.constantInternalTex0.setValue(emitter.internalTex0);
				this.constantInternalTex1.setValue(emitter.internalTex1);
				this.constantInternalTex2.setValue(emitter.internalTex2);
				this.constantInternalTex3.setValue(emitter.internalTex3);
				var node = emitter.meshInstance.node;
				var emitterScale = node === null ? Vec3.ONE : node.localScale;
				if (emitter.pack8) {
						this.worldBoundsMulUniform[0] = emitter.worldBoundsMul.x;
						this.worldBoundsMulUniform[1] = emitter.worldBoundsMul.y;
						this.worldBoundsMulUniform[2] = emitter.worldBoundsMul.z;
						this.constantOutBoundsMul.setValue(this.worldBoundsMulUniform);
						this.worldBoundsAddUniform[0] = emitter.worldBoundsAdd.x;
						this.worldBoundsAddUniform[1] = emitter.worldBoundsAdd.y;
						this.worldBoundsAddUniform[2] = emitter.worldBoundsAdd.z;
						this.constantOutBoundsAdd.setValue(this.worldBoundsAddUniform);
						this._setInputBounds();
						var maxVel = emitter.maxVel * Math.max(Math.max(emitterScale.x, emitterScale.y), emitterScale.z);
						maxVel = Math.max(maxVel, 1);
						this.constantMaxVel.setValue(maxVel);
				}
				var emitterPos = node === null || emitter.localSpace ? Vec3.ZERO : node.getPosition();
				var emitterMatrix = node === null ? Mat4.IDENTITY : node.getWorldTransform();
				if (emitter.emitterShape === EMITTERSHAPE_BOX) {
						spawnMatrix3.setFromMat4(spawnMatrix);
						this.constantSpawnBounds.setValue(spawnMatrix3.data);
						this.constantSpawnPosInnerRatio.setValue(extentsInnerRatioUniform);
				} else {
						this.constantSpawnBoundsSphere.setValue(emitter.emitterRadius);
						this.constantSpawnBoundsSphereInnerRatio.setValue(emitter.emitterRadius === 0 ? 0 : emitter.emitterRadiusInner / emitter.emitterRadius);
				}
				this.constantInitialVelocity.setValue(emitter.initialVelocity);
				emitterMatrix3.setFromMat4(emitterMatrix);
				emitterMatrix3Inv.invertMat4(emitterMatrix);
				this.emitterPosUniform[0] = emitterPos.x;
				this.emitterPosUniform[1] = emitterPos.y;
				this.emitterPosUniform[2] = emitterPos.z;
				this.constantEmitterPos.setValue(this.emitterPosUniform);
				this.constantFrameRandom.setValue(this.frameRandomUniform);
				this.constantDelta.setValue(delta);
				this.constantRate.setValue(emitter.rate);
				this.constantRateDiv.setValue(emitter.rate2 - emitter.rate);
				this.constantStartAngle.setValue(emitter.startAngle * math.DEG_TO_RAD);
				this.constantStartAngle2.setValue(emitter.startAngle2 * math.DEG_TO_RAD);
				this.constantSeed.setValue(emitter.seed);
				this.constantLifetime.setValue(emitter.lifetime);
				this.emitterScaleUniform[0] = emitterScale.x;
				this.emitterScaleUniform[1] = emitterScale.y;
				this.emitterScaleUniform[2] = emitterScale.z;
				this.constantEmitterScale.setValue(this.emitterScaleUniform);
				this.constantEmitterMatrix.setValue(emitterMatrix3.data);
				this.constantEmitterMatrixInv.setValue(emitterMatrix3Inv.data);
				this.constantLocalVelocityDivMult.setValue(emitter.localVelocityUMax);
				this.constantVelocityDivMult.setValue(emitter.velocityUMax);
				this.constantRotSpeedDivMult.setValue(emitter.rotSpeedUMax[0]);
				var texIN = emitter.swapTex ? emitter.particleTexOUT : emitter.particleTexIN;
				texIN = emitter.beenReset ? emitter.particleTexStart : texIN;
				var texOUT = emitter.swapTex ? emitter.particleTexIN : emitter.particleTexOUT;
				this.constantParticleTexIN.setValue(texIN);
				drawQuadWithShader(device, emitter.swapTex ? emitter.rtParticleTexIN : emitter.rtParticleTexOUT, !isOnStop ? emitter.loop ? emitter.shaderParticleUpdateRespawn : emitter.shaderParticleUpdateNoRespawn : emitter.shaderParticleUpdateOnStop);
				emitter.material.setParameter('particleTexOUT', texIN);
				emitter.material.setParameter('particleTexIN', texOUT);
				emitter.beenReset = false;
				emitter.swapTex = !emitter.swapTex;
				emitter.prevWorldBoundsSize.copy(emitter.worldBoundsSize);
				emitter.prevWorldBoundsCenter.copy(emitter.worldBounds.center);
				if (emitter.pack8) {
						this._setInputBounds();
				}
		}
		constructor(emitter, gd){
				this._emitter = emitter;
				this.frameRandomUniform = new Float32Array(3);
				this.emitterPosUniform = new Float32Array(3);
				this.emitterScaleUniform = new Float32Array([
						1,
						1,
						1
				]);
				this.worldBoundsMulUniform = new Float32Array(3);
				this.worldBoundsAddUniform = new Float32Array(3);
				this.inBoundsSizeUniform = new Float32Array(3);
				this.inBoundsCenterUniform = new Float32Array(3);
				this.constantParticleTexIN = gd.scope.resolve('particleTexIN');
				this.constantParticleTexOUT = gd.scope.resolve('particleTexOUT');
				this.constantEmitterPos = gd.scope.resolve('emitterPos');
				this.constantEmitterScale = gd.scope.resolve('emitterScale');
				this.constantSpawnBounds = gd.scope.resolve('spawnBounds');
				this.constantSpawnPosInnerRatio = gd.scope.resolve('spawnPosInnerRatio');
				this.constantSpawnBoundsSphere = gd.scope.resolve('spawnBoundsSphere');
				this.constantSpawnBoundsSphereInnerRatio = gd.scope.resolve('spawnBoundsSphereInnerRatio');
				this.constantInitialVelocity = gd.scope.resolve('initialVelocity');
				this.constantFrameRandom = gd.scope.resolve('frameRandom');
				this.constantDelta = gd.scope.resolve('delta');
				this.constantRate = gd.scope.resolve('rate');
				this.constantRateDiv = gd.scope.resolve('rateDiv');
				this.constantLifetime = gd.scope.resolve('lifetime');
				this.constantGraphSampleSize = gd.scope.resolve('graphSampleSize');
				this.constantGraphNumSamples = gd.scope.resolve('graphNumSamples');
				this.constantInternalTex0 = gd.scope.resolve('internalTex0');
				this.constantInternalTex1 = gd.scope.resolve('internalTex1');
				this.constantInternalTex2 = gd.scope.resolve('internalTex2');
				this.constantInternalTex3 = gd.scope.resolve('internalTex3');
				this.constantEmitterMatrix = gd.scope.resolve('emitterMatrix');
				this.constantEmitterMatrixInv = gd.scope.resolve('emitterMatrixInv');
				this.constantNumParticles = gd.scope.resolve('numParticles');
				this.constantNumParticlesPot = gd.scope.resolve('numParticlesPot');
				this.constantLocalVelocityDivMult = gd.scope.resolve('localVelocityDivMult');
				this.constantVelocityDivMult = gd.scope.resolve('velocityDivMult');
				this.constantRotSpeedDivMult = gd.scope.resolve('rotSpeedDivMult');
				this.constantSeed = gd.scope.resolve('seed');
				this.constantStartAngle = gd.scope.resolve('startAngle');
				this.constantStartAngle2 = gd.scope.resolve('startAngle2');
				this.constantOutBoundsMul = gd.scope.resolve('outBoundsMul');
				this.constantOutBoundsAdd = gd.scope.resolve('outBoundsAdd');
				this.constantInBoundsSize = gd.scope.resolve('inBoundsSize');
				this.constantInBoundsCenter = gd.scope.resolve('inBoundsCenter');
				this.constantMaxVel = gd.scope.resolve('maxVel');
				this.constantFaceTangent = gd.scope.resolve('faceTangent');
				this.constantFaceBinorm = gd.scope.resolve('faceBinorm');
		}
}

function _extends$g() {
		_extends$g = Object.assign || function(target) {
				for(var i = 1; i < arguments.length; i++){
						var source = arguments[i];
						for(var key in source){
								if (Object.prototype.hasOwnProperty.call(source, key)) {
										target[key] = source[key];
								}
						}
				}
				return target;
		};
		return _extends$g.apply(this, arguments);
}
class ShaderGeneratorParticle extends ShaderGenerator {
		generateKey(options) {
				var definesHash = ShaderGenerator.definesHash(options.defines);
				var key = "particle_" + definesHash + "_";
				for(var prop in options){
						if (options.hasOwnProperty(prop)) {
								key += options[prop];
						}
				}
				return key;
		}
		_animTex(options) {
				var vshader = '';
				vshader += options.animTexLoop ? shaderChunks.particleAnimFrameLoopVS : shaderChunks.particleAnimFrameClampVS;
				vshader += shaderChunks.particleAnimTexVS;
				return vshader;
		}
		createShaderDefinition(device, options) {
				var executionDefine = "#define PARTICLE_" + (options.useCpu ? 'CPU' : 'GPU') + "\n";
				var fshader = "#define PARTICLE\n" + executionDefine;
				var vshader = "#define VERTEXSHADER\n" + executionDefine;
				if (options.mesh) vshader += '#define USE_MESH\n';
				if (options.localSpace) vshader += '#define LOCAL_SPACE\n';
				if (options.screenSpace) vshader += '#define SCREEN_SPACE\n';
				if (options.animTex) vshader += '\nuniform vec2 animTexTilesParams;\n';
				if (options.animTex) vshader += '\nuniform vec4 animTexParams;\n';
				if (options.animTex) vshader += '\nuniform vec2 animTexIndexParams;\n';
				if (options.normal === 2) vshader += '\nvarying mat3 ParticleMat;\n';
				if (options.normal === 1) vshader += '\nvarying vec3 Normal;\n';
				if (options.soft) vshader += '\nvarying float vDepth;\n';
				var faceVS = options.customFace ? shaderChunks.particle_customFaceVS : shaderChunks.particle_billboardVS;
				if (!options.useCpu) {
						vshader += shaderChunks.particle_initVS;
						vshader += options.pack8 ? shaderChunks.particleInputRgba8PS : shaderChunks.particleInputFloatPS;
						if (options.soft > 0) vshader += shaderChunks.screenDepthPS;
						vshader += shaderChunks.particleVS;
						if (options.localSpace) vshader += shaderChunks.particle_localShiftVS;
						if (options.animTex) vshader += this._animTex(options);
						if (options.wrap) vshader += shaderChunks.particle_wrapVS;
						if (options.alignToMotion) vshader += shaderChunks.particle_pointAlongVS;
						vshader += options.mesh ? shaderChunks.particle_meshVS : faceVS;
						if (options.normal === 1) vshader += shaderChunks.particle_normalVS;
						if (options.normal === 2) vshader += shaderChunks.particle_TBNVS;
						if (options.stretch > 0.0) vshader += shaderChunks.particle_stretchVS;
						vshader += shaderChunks.particle_endVS;
						if (options.soft > 0) vshader += shaderChunks.particle_softVS;
				} else {
						if (options.soft > 0) vshader += shaderChunks.screenDepthPS;
						vshader += shaderChunks.particle_cpuVS;
						if (options.localSpace) vshader += shaderChunks.particle_localShiftVS;
						if (options.animTex) vshader += this._animTex(options);
						if (options.alignToMotion) vshader += shaderChunks.particle_pointAlongVS;
						vshader += options.mesh ? shaderChunks.particle_meshVS : faceVS;
						if (options.normal === 1) vshader += shaderChunks.particle_normalVS;
						if (options.normal === 2) vshader += shaderChunks.particle_TBNVS;
						if (options.stretch > 0.0) vshader += shaderChunks.particle_stretchVS;
						vshader += shaderChunks.particle_cpu_endVS;
						if (options.soft > 0) vshader += shaderChunks.particle_softVS;
				}
				vshader += '}\n';
				if (options.normal > 0) {
						if (options.normal === 1) {
								fshader += '\nvarying vec3 Normal;\n';
						} else if (options.normal === 2) {
								fshader += '\nvarying mat3 ParticleMat;\n';
						}
						fshader += '\nuniform vec3 lightCube[6];\n';
				}
				if (options.soft) fshader += '\nvarying float vDepth;\n';
				fshader += shaderChunks.decodePS;
				fshader += '#include "gammaPS"\n';
				fshader += '#include "tonemappingPS"\n';
				fshader += '#include "fogPS"\n';
				if (options.normal === 2) fshader += '\nuniform sampler2D normalMap;\n';
				if (options.soft > 0) fshader += shaderChunks.screenDepthPS;
				fshader += shaderChunks.particlePS;
				if (options.soft > 0) fshader += shaderChunks.particle_softPS;
				if (options.normal === 1) fshader += '\nvec3 normal = Normal;\n';
				if (options.normal === 2) fshader += shaderChunks.particle_normalMapPS;
				if (options.normal > 0) fshader += options.halflambert ? shaderChunks.particle_halflambertPS : shaderChunks.particle_lambertPS;
				if (options.normal > 0) fshader += shaderChunks.particle_lightingPS;
				if (options.blend === BLEND_NORMAL) {
						fshader += shaderChunks.particle_blendNormalPS;
				} else if (options.blend === BLEND_ADDITIVE) {
						fshader += shaderChunks.particle_blendAddPS;
				} else if (options.blend === BLEND_MULTIPLICATIVE) {
						fshader += shaderChunks.particle_blendMultiplyPS;
				}
				fshader += shaderChunks.particle_endPS;
				var includes = new Map(Object.entries(_extends$g({}, shaderChunks, options.chunks)));
				return ShaderUtils.createDefinition(device, {
						name: 'ParticleShader',
						vertexCode: vshader,
						fragmentCode: fshader,
						fragmentDefines: options.defines,
						fragmentIncludes: includes,
						vertexDefines: options.defines
				});
		}
}
var particle = new ShaderGeneratorParticle();

class ParticleMaterial extends Material {
		getShaderVariant(params) {
				var { device, scene, cameraShaderParams } = params;
				var { emitter } = this;
				var _cameraShaderParams_shaderOutputGamma, _cameraShaderParams_toneMapping;
				var options = {
						defines: getCoreDefines(this, params),
						pass: SHADER_FORWARD,
						useCpu: this.emitter.useCpu,
						normal: emitter.lighting ? emitter.normalMap !== null ? 2 : 1 : 0,
						halflambert: this.emitter.halfLambert,
						stretch: this.emitter.stretch,
						alignToMotion: this.emitter.alignToMotion,
						soft: this.emitter.depthSoftening,
						mesh: this.emitter.useMesh,
						gamma: (_cameraShaderParams_shaderOutputGamma = cameraShaderParams == null ? void 0 : cameraShaderParams.shaderOutputGamma) != null ? _cameraShaderParams_shaderOutputGamma : GAMMA_NONE,
						toneMap: (_cameraShaderParams_toneMapping = cameraShaderParams == null ? void 0 : cameraShaderParams.toneMapping) != null ? _cameraShaderParams_toneMapping : TONEMAP_LINEAR,
						fog: scene && !this.emitter.noFog ? scene.fog.type : 'none',
						wrap: this.emitter.wrap && this.emitter.wrapBounds,
						localSpace: this.emitter.localSpace,
						screenSpace: emitter.inTools ? false : this.emitter.screenSpace,
						blend: this.blendType,
						animTex: this.emitter._isAnimated(),
						animTexLoop: this.emitter.animLoop,
						pack8: this.emitter.pack8,
						customFace: this.emitter.orientation !== PARTICLEORIENTATION_SCREEN
				};
				var processingOptions = new ShaderProcessorOptions(params.viewUniformFormat, params.viewBindGroupFormat, params.vertexFormat);
				var library = getProgramLibrary(device);
				library.register('particle', particle);
				return library.getProgram('particle', options, processingOptions, this.userId);
		}
		constructor(emitter){
				super(), this.emitter = null;
				this.emitter = emitter;
		}
}

var particleVerts = [
		[
				-1,
				-1
		],
		[
				1,
				-1
		],
		[
				1,
				1
		],
		[
				-1,
				1
		]
];
function _createTexture(device, width, height, pixelData, format, mult8Bit, filter) {
		if (format === void 0) format = PIXELFORMAT_RGBA32F;
		var mipFilter = FILTER_NEAREST;
		if (filter && (format === PIXELFORMAT_RGBA8 || format === PIXELFORMAT_SRGBA8)) {
				mipFilter = FILTER_LINEAR;
		}
		var texture = new Texture(device, {
				width: width,
				height: height,
				format: format,
				cubemap: false,
				mipmaps: false,
				minFilter: mipFilter,
				magFilter: mipFilter,
				addressU: ADDRESS_CLAMP_TO_EDGE,
				addressV: ADDRESS_CLAMP_TO_EDGE,
				name: 'ParticleSystemTexture'
		});
		var pixels = texture.lock();
		if (format === PIXELFORMAT_RGBA8 || format === PIXELFORMAT_SRGBA8) {
				var temp = new Uint8Array(pixelData.length);
				for(var i = 0; i < pixelData.length; i++){
						temp[i] = pixelData[i] * mult8Bit * 255;
				}
				pixelData = temp;
		}
		pixels.set(pixelData);
		texture.unlock();
		return texture;
}
function saturate(x) {
		return Math.max(Math.min(x, 1), 0);
}
var default0Curve = new Curve([
		0,
		0,
		1,
		0
]);
var default1Curve = new Curve([
		0,
		1,
		1,
		1
]);
var default0Curve3 = new CurveSet([
		0,
		0,
		1,
		0
], [
		0,
		0,
		1,
		0
], [
		0,
		0,
		1,
		0
]);
var default1Curve3 = new CurveSet([
		0,
		1,
		1,
		1
], [
		0,
		1,
		1,
		1
], [
		0,
		1,
		1,
		1
]);
var particleTexHeight = 2;
var particleTexChannels = 4;
var extentsInnerRatioUniform = new Float32Array(3);
var spawnMatrix = new Mat4();
var tmpVec3 = new Vec3();
var bMin = new Vec3();
var bMax = new Vec3();
var setPropertyTarget;
var setPropertyOptions;
function setProperty(pName, defaultVal) {
		if (setPropertyOptions[pName] !== undefined && setPropertyOptions[pName] !== null) {
				setPropertyTarget[pName] = setPropertyOptions[pName];
		} else {
				setPropertyTarget[pName] = defaultVal;
		}
}
function pack3NFloats(a, b, c) {
		var packed = a * 255 << 16 | b * 255 << 8 | c * 255;
		return packed / (1 << 24);
}
function packTextureXYZ_NXYZ(qXYZ, qXYZ2) {
		var num = qXYZ.length / 3;
		var colors = new Array(num * 4);
		for(var i = 0; i < num; i++){
				colors[i * 4] = qXYZ[i * 3];
				colors[i * 4 + 1] = qXYZ[i * 3 + 1];
				colors[i * 4 + 2] = qXYZ[i * 3 + 2];
				colors[i * 4 + 3] = pack3NFloats(qXYZ2[i * 3], qXYZ2[i * 3 + 1], qXYZ2[i * 3 + 2]);
		}
		return colors;
}
function packTextureRGBA(qRGB, qA) {
		var colors = new Array(qA.length * 4);
		for(var i = 0; i < qA.length; i++){
				colors[i * 4] = qRGB[i * 3];
				colors[i * 4 + 1] = qRGB[i * 3 + 1];
				colors[i * 4 + 2] = qRGB[i * 3 + 2];
				colors[i * 4 + 3] = qA[i];
		}
		return colors;
}
function packTexture5Floats(qA, qB, qC, qD, qE) {
		var colors = new Array(qA.length * 4);
		for(var i = 0; i < qA.length; i++){
				colors[i * 4] = qA[i];
				colors[i * 4 + 1] = qB[i];
				colors[i * 4 + 2] = 0;
				colors[i * 4 + 3] = pack3NFloats(qC[i], qD[i], qE[i]);
		}
		return colors;
}
function packTexture2Floats(qA, qB) {
		var colors = new Array(qA.length * 4);
		for(var i = 0; i < qA.length; i++){
				colors[i * 4] = qA[i];
				colors[i * 4 + 1] = qB[i];
				colors[i * 4 + 2] = 0;
				colors[i * 4 + 3] = 0;
		}
		return colors;
}
function calcEndTime(emitter) {
		var interval = Math.max(emitter.rate, emitter.rate2) * emitter.numParticles + emitter.lifetime;
		return Date.now() + interval * 1000;
}
function subGraph(A, B) {
		var r = new Float32Array(A.length);
		for(var i = 0; i < A.length; i++){
				r[i] = A[i] - B[i];
		}
		return r;
}
function maxUnsignedGraphValue(A, outUMax) {
		var chans = outUMax.length;
		var values = A.length / chans;
		for(var i = 0; i < values; i++){
				for(var j = 0; j < chans; j++){
						var a = Math.abs(A[i * chans + j]);
						outUMax[j] = Math.max(outUMax[j], a);
				}
		}
}
function normalizeGraph(A, uMax) {
		var chans = uMax.length;
		var values = A.length / chans;
		for(var i = 0; i < values; i++){
				for(var j = 0; j < chans; j++){
						A[i * chans + j] /= uMax[j] === 0 ? 1 : uMax[j];
						A[i * chans + j] *= 0.5;
						A[i * chans + j] += 0.5;
				}
		}
}
function divGraphFrom2Curves(curve1, curve2, outUMax) {
		var sub = subGraph(curve2, curve1);
		maxUnsignedGraphValue(sub, outUMax);
		normalizeGraph(sub, outUMax);
		return sub;
}
var particleEmitterDeviceCache = new DeviceCache();
class ParticleEmitter {
		get defaultParamTexture() {
				return particleEmitterDeviceCache.get(this.graphicsDevice, ()=>{
						var resolution = 16;
						var centerPoint = resolution * 0.5 + 0.5;
						var dtex = new Float32Array(resolution * resolution * 4);
						for(var y = 0; y < resolution; y++){
								for(var x = 0; x < resolution; x++){
										var xgrad = x + 1 - centerPoint;
										var ygrad = y + 1 - centerPoint;
										var c = saturate(1 - saturate(Math.sqrt(xgrad * xgrad + ygrad * ygrad) / resolution) - 0.5);
										var p = y * resolution + x;
										dtex[p * 4] = 1;
										dtex[p * 4 + 1] = 1;
										dtex[p * 4 + 2] = 1;
										dtex[p * 4 + 3] = c;
								}
						}
						var texture = _createTexture(this.graphicsDevice, resolution, resolution, dtex, PIXELFORMAT_SRGBA8, 1.0, true);
						texture.minFilter = FILTER_LINEAR;
						texture.magFilter = FILTER_LINEAR;
						return texture;
				});
		}
		onChangeCamera() {
				this.resetMaterial();
		}
		calculateBoundsMad() {
				this.worldBoundsMul.x = 1.0 / this.worldBoundsSize.x;
				this.worldBoundsMul.y = 1.0 / this.worldBoundsSize.y;
				this.worldBoundsMul.z = 1.0 / this.worldBoundsSize.z;
				this.worldBoundsAdd.copy(this.worldBounds.center).mul(this.worldBoundsMul).mulScalar(-1);
				this.worldBoundsAdd.x += 0.5;
				this.worldBoundsAdd.y += 0.5;
				this.worldBoundsAdd.z += 0.5;
		}
		calculateWorldBounds() {
				if (!this.node) return;
				this.prevWorldBoundsSize.copy(this.worldBoundsSize);
				this.prevWorldBoundsCenter.copy(this.worldBounds.center);
				if (!this.useCpu) {
						var recalculateLocalBounds = false;
						if (this.emitterShape === EMITTERSHAPE_BOX) {
								recalculateLocalBounds = !this.emitterExtents.equals(this.prevEmitterExtents);
						} else {
								recalculateLocalBounds = !(this.emitterRadius === this.prevEmitterRadius);
						}
						if (recalculateLocalBounds) {
								this.calculateLocalBounds();
						}
				}
				var nodeWT = this.node.getWorldTransform();
				if (this.localSpace) {
						this.worldBoundsNoTrail.copy(this.localBounds);
				} else {
						this.worldBoundsNoTrail.setFromTransformedAabb(this.localBounds, nodeWT);
				}
				this.worldBoundsTrail[0].add(this.worldBoundsNoTrail);
				this.worldBoundsTrail[1].add(this.worldBoundsNoTrail);
				var now = this.simTimeTotal;
				if (now >= this.timeToSwitchBounds) {
						this.worldBoundsTrail[0].copy(this.worldBoundsTrail[1]);
						this.worldBoundsTrail[1].copy(this.worldBoundsNoTrail);
						this.timeToSwitchBounds = now + this.lifetime;
				}
				this.worldBounds.copy(this.worldBoundsTrail[0]);
				this.worldBoundsSize.copy(this.worldBounds.halfExtents).mulScalar(2);
				if (this.localSpace) {
						this.meshInstance.aabb.setFromTransformedAabb(this.worldBounds, nodeWT);
						this.meshInstance.mesh.aabb.setFromTransformedAabb(this.worldBounds, nodeWT);
				} else {
						this.meshInstance.aabb.copy(this.worldBounds);
						this.meshInstance.mesh.aabb.copy(this.worldBounds);
				}
				this.meshInstance._aabbVer = 1 - this.meshInstance._aabbVer;
				if (this.pack8) this.calculateBoundsMad();
		}
		resetWorldBounds() {
				if (!this.node) return;
				this.worldBoundsNoTrail.setFromTransformedAabb(this.localBounds, this.localSpace ? Mat4.IDENTITY : this.node.getWorldTransform());
				this.worldBoundsTrail[0].copy(this.worldBoundsNoTrail);
				this.worldBoundsTrail[1].copy(this.worldBoundsNoTrail);
				this.worldBounds.copy(this.worldBoundsTrail[0]);
				this.worldBoundsSize.copy(this.worldBounds.halfExtents).mulScalar(2);
				this.prevWorldBoundsSize.copy(this.worldBoundsSize);
				this.prevWorldBoundsCenter.copy(this.worldBounds.center);
				this.simTimeTotal = 0;
				this.timeToSwitchBounds = 0;
		}
		calculateLocalBounds() {
				var minx = Number.MAX_VALUE;
				var miny = Number.MAX_VALUE;
				var minz = Number.MAX_VALUE;
				var maxx = -Number.MAX_VALUE;
				var maxy = -Number.MAX_VALUE;
				var maxz = -Number.MAX_VALUE;
				var maxR = 0;
				var maxScale = 0;
				var stepWeight = this.lifetime / this.precision;
				var wVels = [
						this.qVelocity,
						this.qVelocity2
				];
				var lVels = [
						this.qLocalVelocity,
						this.qLocalVelocity2
				];
				var accumX = [
						0,
						0
				];
				var accumY = [
						0,
						0
				];
				var accumZ = [
						0,
						0
				];
				var accumR = [
						0,
						0
				];
				var accumW = [
						0,
						0
				];
				var x, y, z;
				for(var i = 0; i < this.precision + 1; i++){
						var index = Math.min(i, this.precision - 1);
						for(var j = 0; j < 2; j++){
								x = lVels[j][index * 3 + 0] * stepWeight + accumX[j];
								y = lVels[j][index * 3 + 1] * stepWeight + accumY[j];
								z = lVels[j][index * 3 + 2] * stepWeight + accumZ[j];
								minx = Math.min(x, minx);
								miny = Math.min(y, miny);
								minz = Math.min(z, minz);
								maxx = Math.max(x, maxx);
								maxy = Math.max(y, maxy);
								maxz = Math.max(z, maxz);
								accumX[j] = x;
								accumY[j] = y;
								accumZ[j] = z;
						}
						for(var j1 = 0; j1 < 2; j1++){
								accumW[j1] += stepWeight * Math.sqrt(wVels[j1][index * 3 + 0] * wVels[j1][index * 3 + 0] + wVels[j1][index * 3 + 1] * wVels[j1][index * 3 + 1] + wVels[j1][index * 3 + 2] * wVels[j1][index * 3 + 2]);
						}
						accumR[0] += this.qRadialSpeed[index] * stepWeight;
						accumR[1] += this.qRadialSpeed2[index] * stepWeight;
						maxR = Math.max(maxR, Math.max(Math.abs(accumR[0]), Math.abs(accumR[1])));
						maxScale = Math.max(maxScale, this.qScale[index]);
				}
				if (this.emitterShape === EMITTERSHAPE_BOX) {
						x = this.emitterExtents.x * 0.5;
						y = this.emitterExtents.y * 0.5;
						z = this.emitterExtents.z * 0.5;
				} else {
						x = this.emitterRadius;
						y = this.emitterRadius;
						z = this.emitterRadius;
				}
				var w = Math.max(accumW[0], accumW[1]);
				bMin.x = minx - maxScale - x - maxR - w;
				bMin.y = miny - maxScale - y - maxR - w;
				bMin.z = minz - maxScale - z - maxR - w;
				bMax.x = maxx + maxScale + x + maxR + w;
				bMax.y = maxy + maxScale + y + maxR + w;
				bMax.z = maxz + maxScale + z + maxR + w;
				this.localBounds.setMinMax(bMin, bMax);
		}
		rebuild() {
				var gd = this.graphicsDevice;
				if (this.colorMap === null) this.colorMap = this.defaultParamTexture;
				this.spawnBounds = this.emitterShape === EMITTERSHAPE_BOX ? this.emitterExtents : this.emitterRadius;
				this.useCpu = this.useCpu || this.sort > PARTICLESORT_NONE || gd.maxVertexTextures <= 1 || gd.fragmentUniformsCount < 64 || gd.forceCpuParticles;
				this._destroyResources();
				this.pack8 = (this.pack8 || !gd.textureFloatRenderable) && !this.useCpu;
				particleTexHeight = this.useCpu || this.pack8 ? 4 : 2;
				this.useMesh = !!this.mesh;
				this.numParticlesPot = math.nextPowerOfTwo(this.numParticles);
				this.rebuildGraphs();
				this.calculateLocalBounds();
				this.resetWorldBounds();
				if (this.node) {
						this.worldBounds.setFromTransformedAabb(this.localBounds, this.localSpace ? Mat4.IDENTITY : this.node.getWorldTransform());
						this.worldBoundsTrail[0].copy(this.worldBounds);
						this.worldBoundsTrail[1].copy(this.worldBounds);
						this.worldBoundsSize.copy(this.worldBounds.halfExtents).mulScalar(2);
						this.prevWorldBoundsSize.copy(this.worldBoundsSize);
						this.prevWorldBoundsCenter.copy(this.worldBounds.center);
						if (this.pack8) this.calculateBoundsMad();
				}
				this.vbToSort = new Array(this.numParticles);
				for(var iSort = 0; iSort < this.numParticles; iSort++)this.vbToSort[iSort] = [
						0,
						0
				];
				this.particleDistance = new Float32Array(this.numParticles);
				this._gpuUpdater.randomize();
				this.particleTex = new Float32Array(this.numParticlesPot * particleTexHeight * particleTexChannels);
				var emitterPos = this.node === null || this.localSpace ? Vec3.ZERO : this.node.getPosition();
				if (this.emitterShape === EMITTERSHAPE_BOX) {
						if (this.node === null || this.localSpace) {
								spawnMatrix.setTRS(Vec3.ZERO, Quat.IDENTITY, this.spawnBounds);
						} else {
								spawnMatrix.setTRS(Vec3.ZERO, this.node.getRotation(), tmpVec3.copy(this.spawnBounds).mul(this.node.localScale));
						}
						extentsInnerRatioUniform[0] = this.emitterExtents.x !== 0 ? this.emitterExtentsInner.x / this.emitterExtents.x : 0;
						extentsInnerRatioUniform[1] = this.emitterExtents.y !== 0 ? this.emitterExtentsInner.y / this.emitterExtents.y : 0;
						extentsInnerRatioUniform[2] = this.emitterExtents.z !== 0 ? this.emitterExtentsInner.z / this.emitterExtents.z : 0;
				}
				for(var i = 0; i < this.numParticles; i++){
						this._cpuUpdater.calcSpawnPosition(this.particleTex, spawnMatrix, extentsInnerRatioUniform, emitterPos, i);
						if (this.useCpu) this.particleTex[i * particleTexChannels + 3 + this.numParticlesPot * 2 * particleTexChannels] = 1;
				}
				this.particleTexStart = new Float32Array(this.numParticlesPot * particleTexHeight * particleTexChannels);
				for(var i1 = 0; i1 < this.particleTexStart.length; i1++){
						this.particleTexStart[i1] = this.particleTex[i1];
				}
				if (!this.useCpu) {
						if (this.pack8) {
								this.particleTexIN = _createTexture(gd, this.numParticlesPot, particleTexHeight, this.particleTex, PIXELFORMAT_RGBA8, 1, false);
								this.particleTexOUT = _createTexture(gd, this.numParticlesPot, particleTexHeight, this.particleTex, PIXELFORMAT_RGBA8, 1, false);
								this.particleTexStart = _createTexture(gd, this.numParticlesPot, particleTexHeight, this.particleTexStart, PIXELFORMAT_RGBA8, 1, false);
						} else {
								this.particleTexIN = _createTexture(gd, this.numParticlesPot, particleTexHeight, this.particleTex);
								this.particleTexOUT = _createTexture(gd, this.numParticlesPot, particleTexHeight, this.particleTex);
								this.particleTexStart = _createTexture(gd, this.numParticlesPot